--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- SlashCommands --
local SlashCommands = FlexBar2.SlashCommands;
local function SlashCommand_SetRemap(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	if(Params.shapeshift == "true") then
		for _, ButtonName in ipairs(ButtonTable) do
			local Button = ButtonList[ButtonName];
			Button.InfoTable.Remaps.shapeshift = true;
		end
	elseif(Params.shapeshift == "false") then
		for _, ButtonName in ipairs(ButtonTable) do
			local Button = ButtonList[ButtonName];
			Button.InfoTable.Remaps.shapeshift = false;
		end

	end
	if(Params.target == "true") then
		for _, ButtonName in ipairs(ButtonTable) do
			local Button = ButtonList[ButtonName];
			Button.InfoTable.Remaps.target = true;
		end

	elseif(Params.target == "false") then
		for _, ButtonName in ipairs(ButtonTable) do
			local Button = ButtonList[ButtonName];
			Button.InfoTable.Remaps.target = false;
		end

	end

	-- Loop through given button range
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		FlexBar2:Debug("statebuttons: ", Active_statebutton, Inactive_statebutton);
		-- Reload the statebutton attribute
		Button:GenerateStateButton();
		Button:GenerateShowStates();
	end
end

local function SlashCommand_SetAttribute(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		Button:SetAttribute(Params.attribute, Params.value, Params.save == "true" and true or false);
	end
end

local function SlashCommand_SetModifiedAttribute(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		Button:SetModifiedAttribute(Params.attribute, Params.value, Params.save == "true" and true or false);
	end
end

local function SlashCommand_GetAttribute(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		FlexBar2:Print(Button.Name .. " has " .. Params.attribute .. " set to " .. (Button:GetAttribute(Params.attribute) or "nil"));
	end
end


local function SlashCommand_GetModifiedAttribute(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		FlexBar2:Print(Button.Name .. " has " .. Params.attribute .. " set to " .. (Button:GetModifiedAttribute(Params.attribute) or "nil"));
	end
end


local function SlashCommand_ClearAttributes(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		local Button = ButtonList[ButtonName];
		Button:ClearAllAttributes();
		Button.InfoTable.Attributes = {};
		Button:DispatchEvent("ActionChanged", Button);
	end

end

local function SlashCommand_ListStates(Params)
	if(Params.button) then
		local ButtonTable = FlexBar2:ToButtonTable(Params.button);
		local ButtonList = FlexBar2.Buttons;
		for _, ButtonName in ipairs(ButtonTable) do
			local Button = ButtonList[ButtonName];
			for StateName, StateMap in pairs(Button.StateList) do
				FlexBar2:Print(StateName .. ":" .. StateMap);
			end
		end
	else
		for _, StateTable in ipairs(FlexBar2:GetModule("Attributes").StateList) do
			FlexBar2:Print(StateTable[1] .. ":[" .. StateTable[2] .. "]");
		end
	end
end


-- Localize this neat verify function for faster access
local VerifyExistance = FlexBar2.SlashCommands.VerifyExistance;
-- AddCommand format :AddCommand(Command, Function, Group, Help)
-- AddParam format :AddParam(Command, Param, Required, AllowedValues, DefaultValue, VerifyFunc) 
-- everything here should be self explainative knowing the syntax
SlashCommands:AddCommand("setremap", SlashCommand_SetRemap, "attributes", "button=<Button> (shapeshift=<true/false>) (target=<true/false>)");
SlashCommands:SetAlias("setremap", "remap");
	SlashCommands:AddParam("setremap", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("setremap", "shapeshift", false, {"true", "false"}, nil, nil);
	SlashCommands:AddParam("setremap", "target", false, {"true", "false"}, nil, nil);

SlashCommands:AddCommand("setattribute", SlashCommand_SetAttribute, "attributes", "button=<Button attribute=<attribute> value=<value>");
SlashCommands:SetAlias("setattribute", "attribute");
SlashCommands:SetAlias("setattribute", "setattr");
SlashCommands:SetAlias("setattribute", "attr");
	SlashCommands:AddParam("setattribute", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("setattribute", "attribute", true, nil, nil, nil);
	SlashCommands:AddParam("setattribute", "value", true, nil, nil, nil);
	SlashCommands:AddParam("setattribute", "save", false, {"true", "false"}, "true", nil);


SlashCommands:AddCommand("setmodifiedattribute", SlashCommand_SetModifiedAttribute, "attributes", "button=<Button attribute=<attribute> value=<value>");
SlashCommands:SetAlias("setmodifiedattribute", "modifiedattribute");
SlashCommands:SetAlias("setmodifiedattribute", "setmodattr");
SlashCommands:SetAlias("setmodifiedattribute", "modattr");
	SlashCommands:AddParam("setmodifiedattribute", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("setmodifiedattribute", "attribute", true, nil, nil, nil);
	SlashCommands:AddParam("setmodifiedattribute", "value", true, nil, nil, nil);
	SlashCommands:AddParam("setmodifiedattribute", "save", false, {"true", "false"}, "true", nil);

SlashCommands:AddCommand("getattribute", SlashCommand_GetAttribute, "attributes", "button=<Button attribute=<attribute> value=<value>");
SlashCommands:SetAlias("getattribute", "getattr");
	SlashCommands:AddParam("getattribute", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("getattribute", "attribute", true, nil, nil, nil);

SlashCommands:AddCommand("getmodifiedattribute", SlashCommand_GetModifiedAttribute, "attributes", "button=<Button attribute=<attribute> value=<value>");
SlashCommands:SetAlias("getmodifiedattribute", "getmodattr");
	SlashCommands:AddParam("getmodifiedattribute", "button", true, nil, nil, VerifyExistance);
	SlashCommands:AddParam("getmodifiedattribute", "attribute", true, nil, nil, nil);


SlashCommands:AddCommand("clearattributes", SlashCommand_ClearAttributes, "attributes", "button=<Buttons>")
SlashCommands:SetAlias("clearattributes", "clear");
	SlashCommands:AddParam("setremap", "button", true, nil, nil, VerifyExistance);

SlashCommands:AddCommand("liststates", SlashCommand_ListStates, "attributes", "")
