--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
if(FlexBar2:HasModule("TextSubs")) then
	local TextSubs = FlexBar2:GetModule("TextSubs");
	-- Text subs --
	TextSubs:RegisterTextSub("cd", function(Button)
		-- Get the cooldown currently on the button
		local StartTime = Button.CooldownStart;
		local Duration = Button.CooldownDuration;
		local Enable = Button.CooldownEnable;
		if(StartTime and StartTime > 0 and Duration > 0 and Enable > 0) then
			local TimeLeft = floor(Duration - GetTime() + StartTime + 0.5);
			-- Timer smaller than 0 or 0
			if(TimeLeft <= 0 or Duration <= 1.5) then			
				return "";
				-- Timer smaller than 1 min
			elseif(TimeLeft < 60) then
				return TimeLeft .. "s";
				-- Timer between 1 to 10 mins
			elseif(TimeLeft < 600) then
				local SecondsLeft = tostring((TimeLeft % 60));
				if(#SecondsLeft == 1) then
					SecondsLeft = "0" .. SecondsLeft;
				end
				return floor(TimeLeft/60) .. ":" .. SecondsLeft;
				-- Timer bigger then 10 mins
			else
				return floor(TimeLeft/60) .. "m";
			end
		end
		return "";
	end);

	TextSubs:RegisterTextSub("itemcount", function(Button, Item)
		-- No item given, find out what item is on this button instead
		if(Item == "") then
			local ItemLink = Button:GetModifiedAttribute("type") == "item" and Button:GetModifiedAttribute("itemlink");
			if(ItemLink) then
				return GetItemCount(ItemLink or "") or "";
			end
			-- Item was given, ez-mode
		else
			return GetItemCount(Item or "") or "0";
		end
		-- Fallback
		return "";
	end);
	TextSubs:RegisterTextSub("macroname", function(Button)
		return Button:GetModifiedAttribute("macro") or "";
	end);
end
