--[[
	This file is part of FlexBar2.

	FlexBar2 is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	FlexBar2 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with FlexBar2.  If not, see <http://www.gnu.org/licenses/>.
]]
-- /fb lock command
local function SlashCommand_LockAction(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	FlexBar2:ApplySetting(ButtonTable, "LockAction", true);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		ButtonList[ButtonName]:LockAction();
	end
end

-- /fb unlock command
local function SlashCommand_UnlockAction(Params)
	local ButtonTable = FlexBar2:ToButtonTable(Params.button);
	FlexBar2:ApplySetting(ButtonTable, "LockAction", false);
	local ButtonList = FlexBar2.Buttons;
	for _, ButtonName in ipairs(ButtonTable) do
		ButtonList[ButtonName]:UnlockAction();
	end
end

local SlashCommands = FlexBar2.SlashCommands;
-- Localize this neat verify function for faster access
local VerifyExistance = FlexBar2.SlashCommands.VerifyExistance;
-- AddCommand format :AddCommand(Command, Function, Group, Help)
-- AddParam format :AddParam(Command, Param, Required, AllowedValues, DefaultValue, VerifyFunc) 
-- everything here should be self explainative knowing the syntax
SlashCommands:AddCommand("lockaction", SlashCommand_LockAction, "action", "button=<Button>");
SlashCommands:SetAlias("lockaction", "actionlock");
	SlashCommands:AddParam("lockaction", "button", false, nil, "*", VerifyExistance);
SlashCommands:AddCommand("unlockaction", SlashCommand_UnlockAction, "action", "button=<Button>");
SlashCommands:SetAlias("unlockaction", "actionunlock");
	SlashCommands:AddParam("unlockaction", "button", false, nil, "*", VerifyExistance);
