if select(2, UnitClass('player')) ~= "HUNTER" then
	return
end
local L = LibStub("AceLocale-3.0"):GetLocale("FeedMachine")

function FeedMachine:FMUI_CreateFoodLists(parent, width, height)
	local f = CreateFrame("Frame", "FeedMachineUI_Food_Frame", parent)
	f:SetPoint("TOPLEFT", 28, -78)
	f:SetWidth(width)
	f:SetHeight(height)

	f:SetScript("OnShow",function()
		FMUI_Foods_ScrollFrame_Update()
	end)

	local ddb = CreateFrame("Frame", "FMFoodButtonDropDown", f, "UIDropDownMenuTemplate")
	ddb:SetPoint("TOPLEFT", 30, 30)

	ddb:SetScript("OnShow", function()
		UIDropDownMenu_SetWidth(200, this)
		UIDropDownMenu_Initialize(this, FMUI_Foods_DropDownMenu_OnLoad)
		UIDropDownMenu_SetSelectedID(FMFoodButtonDropDown, 1)
	end)

	local cbtn = CreateFrame("CheckButton", nil, f, "UICheckButtonTemplate")
	cbtn:SetPoint("TOPLEFT", 260, 32)
	cbtn:SetChecked(self.db.profile.showUnknownFood)

	cbtn:SetScript("OnClick", function()
		FeedMachine.db.profile.showUnknownFood = cbtn:GetChecked()
		FMUI_Foods_ScrollFrame_Update()
	end)

	local sf = CreateFrame("ScrollFrame", "FeedMachineUI_ScrollFrame", f, "FauxScrollFrameTemplate")
	sf:SetPoint("TOPLEFT")
	sf:SetWidth(width - 28 - 65)
	sf:SetHeight(height - 80 - 80)

	sf:SetScript("OnVerticalScroll",function()
		return FauxScrollFrame_OnVerticalScroll(48, FMUI_Foods_ScrollFrame_Update)
	end)

	local t
	for i = 1, 7 do
		local fsub = CreateFrame("Frame", nil, f)
		fsub:SetPoint("TOPLEFT", 0, (i - 1) * -48)
		fsub:SetWidth(305)
		fsub:SetHeight(48)

		local s = fsub:CreateFontString("FMFoodButton"..i.."Text", "ARTWORK", "GameFontNormal")
		s:SetPoint("LEFT", 50, 0)
		s:SetTextColor(1, 0.8, 0)
		
		local cb = CreateFrame("Button", "FMFoodButton"..i.."Button", f)
		cb:SetPoint("TOPLEFT", 4, ((i - 1) * -48) - 3)
		cb:SetWidth(37)
		cb:SetHeight(37)
		cb:RegisterForClicks("LeftButtonUp", "RightButtonUp")

		cb:SetScript("OnEnter", function()
			if this.tooltip then
				GameTooltip:SetOwner(this)
				GameTooltip:SetHyperlink(this.tooltip)
				GameTooltip:Show()
			end
		end)
		
		cb:SetScript("OnLeave", function()
			GameTooltip:Hide()
		end)

		cb:SetScript("OnClick", function()
			-- Don't change list as it is not complete.
			if not FeedMachine.db.profile.showUnknownFood then
				return
			end

			if getglobal("DropDownList1Button"..UIDropDownMenu_GetSelectedID(FMFoodButtonDropDown)):GetText() == "" then
				return
			end

			local foodlist = {}
			for i,_ in ipairs(self.db.profile.foodlist) do
				if self.db.profile.foodlist[i]["diet"] == L[getglobal("DropDownList1Button"..UIDropDownMenu_GetSelectedID(FMFoodButtonDropDown)):GetText()] then
					foodlist = self.db.profile.foodlist[i]["list"]
				end
			end

			if IsControlKeyDown() then
				for i,_ in pairs(foodlist) do
					if foodlist[i]["id"] == cb.itemid then
						if (i == 1 and arg1 == "LeftButton") or (i == #foodlist and arg1 == "RightButton") then
							return
						end

						local tmpfood = self:tablecopy(foodlist[i])

						if arg1 == "LeftButton" then
							foodlist[i], foodlist[i-1] = self:tableswap(foodlist[i],foodlist[i-1])
						end
						if arg1 == "RightButton" then
							foodlist[i], foodlist[i+1] = self:tableswap(foodlist[i],foodlist[i+1])
						end

						FMUI_Foods_ScrollFrame_Update()
					end
				end
			else
				for i,_ in pairs(foodlist) do
					if foodlist[i]["id"] == cb.itemid then
						foodlist[i]["selected"] = not foodlist[i]["selected"]
						if foodlist[i]["selected"] then
							s:SetTextColor(1, 0.8, 0)
						else
							s:SetTextColor(1, 0, 0)
						end
					end
				end
			end
		end)

		t = fsub:CreateTexture(nil, "BACKGROUND")
		t:SetTexture("Interface\\MailFrame\\MailItemBorder")
		t:SetTexCoord(0.1640625, 1, 0, 0.75)
		t:SetPoint("TOPLEFT", 48, 0)
		t:SetWidth(237)
		t:SetHeight(48)

		t = cb:CreateTexture(nil, "BACKGROUND")
		t:SetTexture("Interface\\Buttons\\UI-EmptySlot-White")
		t:SetPoint("CENTER")
		t:SetWidth(64)
		t:SetHeight(64)

		t = fsub:CreateTexture("FMFoodButton"..i.."Icon", "ARTWORK")
		t:SetAllPoints(cb)
	end

	return f
end

function FMUI_Foods_DropDownMenu_OnLoad()
	for i,_ in ipairs(FeedMachine.db.profile.foodlist) do
		info			= UIDropDownMenu_CreateInfo()
		info.text		= L[FeedMachine.db.profile.foodlist[i]["diet"]]
		info.func		= FMUI_Foods_DropDownMenu_OnClick
		info.checked	= nil
		UIDropDownMenu_AddButton(info)
	end
end

function FMUI_Foods_DropDownMenu_OnClick()
	UIDropDownMenu_SetSelectedID(FMFoodButtonDropDown,this:GetID())
	FMUI_Foods_ScrollFrame_Update()
end

function FMUI_Foods_ScrollFrame_Update()
	local offset
	local foodlist = {}

	for i,_ in ipairs(FeedMachine.db.profile.foodlist) do
		if FeedMachine.db.profile.foodlist[i]["diet"] == L[getglobal("DropDownList1Button"..UIDropDownMenu_GetSelectedID(FMFoodButtonDropDown)):GetText()] then
			if not FeedMachine.db.profile.showUnknownFood then
				tmplist = FeedMachine:tablecopy(FeedMachine.db.profile.foodlist[i]["list"])
				for idx,_ in ipairs(tmplist) do
					local _, itemLink, _, _, _, _, _, _, _, _ = GetItemInfo(tmplist[idx]["id"])
					if itemLink then
						table.insert(foodlist,tmplist[idx])
					end
				end
			else
				foodlist = FeedMachine.db.profile.foodlist[i]["list"]
			end
			break
		end
	end

	local frame = getglobal("FeedMachineUI_ScrollFrame")

	FauxScrollFrame_Update(frame,#foodlist,7,48)

	for i = 1,7 do
		offset = i + FauxScrollFrame_GetOffset(frame)
		local icon = getglobal("FMFoodButton"..i.."Icon")
		local button = getglobal("FMFoodButton"..i.."Button")
		local text = getglobal("FMFoodButton"..i.."Text")
		if offset <= #foodlist then
			local itemName, itemLink, _, _, _, _, _, _, _, invTexture = GetItemInfo(foodlist[offset]["id"])
			button.itemid = foodlist[offset]["id"]
			button.tooltip = itemLink
			if foodlist[offset]["selected"] then
				text:SetTextColor(1, 0.8, 0)
			else
				text:SetTextColor(1, 0, 0)
			end
			if itemLink then
				text:SetText(itemName)
				icon:SetTexture(invTexture)
			else
				if foodlist[offset]["id"] then
					text:SetText(L["Unknown Item ID"].." : "..foodlist[offset]["id"])
					icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
				else
					text:SetText("")
					icon:SetTexture()
				end
			end
		else
			button.itemid = nil
			button.tooltip = nil
			text:SetText("")
			icon:SetTexture()
		end
	end
end