if select(2, UnitClass('player')) ~= "HUNTER" then
	return
end
local L = LibStub("AceLocale-3.0"):GetLocale("FeedMachine")

function FeedMachine:FMUI_CreateDiets(parent, width, height)
	local f = CreateFrame("Frame", "FeedMachineUI_Diets_Frame", parent)
	f:SetPoint("TOPLEFT", 28, -78)
	f:SetWidth(width)
	f:SetHeight(height)

	f:SetScript("OnShow",function()
		FMUI_Diets_ScrollFrame_Update()
	end)

	local sf = CreateFrame("ScrollFrame", "FeedMachineUI_Diets_ScrollFrame", f, "FauxScrollFrameTemplate")
	sf:SetPoint("TOPLEFT")
	sf:SetWidth(width - 28 - 65)
	sf:SetHeight(height - 80 - 80)

	sf:SetScript("OnVerticalScroll",function()
		return FauxScrollFrame_OnVerticalScroll(48, FMUI_Diets_ScrollFrame_Update)
	end)

	for i = 1,7 do
		local fsub = CreateFrame("Frame", nil, f)
		fsub:SetPoint("TOPLEFT", 0, (i - 1) * -48)
		fsub:SetWidth(305)
		fsub:SetHeight(48)

		local s = fsub:CreateFontString("FMDietButton"..i.."Text", "ARTWORK", "GameFontNormal")
		s:SetPoint("LEFT", 50, 0)
		s:SetTextColor(1, 0.8, 0)

		local cb = CreateFrame("CheckButton", "FMDietButton"..i.."Button", f)
		cb:SetPoint("TOPLEFT", 4, ((i - 1) * -48) - 3)
		cb:SetWidth(37)
		cb:SetHeight(37)
		cb:RegisterForClicks("LeftButtonUp", "RightButtonUp")
		
		cb:SetScript("OnEnter", function()
			if this.tooltip then
				GameTooltip:SetOwner(this)
				GameTooltip:SetText(this.tooltip)
				GameTooltip:Show()		
			end
		end)
		
		cb:SetScript("OnLeave", function()
			GameTooltip:Hide()	
		end)

		cb:SetScript("OnClick", function()
			if IsControlKeyDown() then
				for i,_ in pairs(self.db.profile.foodlist) do
					if self.db.profile.foodlist[i]["diet"] == L[cb.diet] then
						if (i == 1 and arg1 == "LeftButton") or (i == #self.db.profile.foodlist and arg1 == "RightButton") then
							return
						end

						if arg1 == "LeftButton" then
							self.db.profile.foodlist[i], self.db.profile.foodlist[i-1] = self:tableswap(self.db.profile.foodlist[i],self.db.profile.foodlist[i-1])
						end
						if arg1 == "RightButton" then
							self.db.profile.foodlist[i], self.db.profile.foodlist[i+1] = self:tableswap(self.db.profile.foodlist[i],self.db.profile.foodlist[i+1])
						end

						FMUI_Diets_ScrollFrame_Update()
					end
				end
			else
				for i,_ in pairs(self.db.profile.foodlist) do
					if self.db.profile.foodlist[i]["diet"] == L[cb.diet] then
						self.db.profile.foodlist[i]["selected"] = not self.db.profile.foodlist[i]["selected"]
						if self.db.profile.foodlist[i]["selected"] then
							s:SetTextColor(1, 0.8, 0)
						else
							s:SetTextColor(1, 0, 0)
						end
					end
				end
			end
		end)

		local t
		
		t = fsub:CreateTexture(nil, "BACKGROUND")
		t:SetTexture("Interface\\MailFrame\\MailItemBorder")
		t:SetTexCoord(0.1640625, 1, 0, 0.75)
		t:SetPoint("TOPLEFT", 48, 0)
		t:SetWidth(237)
		t:SetHeight(48)

		t = cb:CreateTexture(nil, "BACKGROUND")
		t:SetTexture("Interface\\Buttons\\UI-EmptySlot-White")
		t:SetPoint("CENTER")
		t:SetWidth(64)
		t:SetHeight(64)
		
		t = cb:CreateTexture("FMDietButton"..i.."Icon", "ARTWORK")
		t:SetAllPoints(cb)
	end

	return f
end

function FMUI_Diets_ScrollFrame_Update()
	local offset
	local foodlist = FeedMachine.db.profile.foodlist
	local frame = getglobal("FeedMachineUI_Diets_ScrollFrame")

	FauxScrollFrame_Update(frame,#foodlist,7,48)

	for i = 1,7 do
		offset = i + FauxScrollFrame_GetOffset(frame)
		local icon = getglobal("FMDietButton"..i.."Icon")
		local button = getglobal("FMDietButton"..i.."Button")
		local text = getglobal("FMDietButton"..i.."Text")
		if foodlist[offset]["selected"] then
			text:SetTextColor(1, 0.8, 0)
		else
			text:SetTextColor(1, 0, 0)
		end

		if offset <= #foodlist then
			button.diet = L[foodlist[offset]["diet"]]
			button.tooltip = button.diet
			text:SetText(button.diet)
			icon:SetTexture(foodlist[offset]["icon"])
		else
			button.diet = nil
			button.tooltip = nil
			text:SetText("")
			icon:SetTexture()
		end
	end
end