if select(2, UnitClass('player')) ~= "HUNTER" then
	return
end
local L = LibStub("AceLocale-3.0"):GetLocale("FeedMachine")

local FMUIMAINFRAME
--~ local FMUITABS = {L["Options"],L["Foods"],L["Diets"]}
local FMUITABS = {L["Foods"], L["Diets"]}
--~ local FMUITABOPTIONFRAME
local FMUITABFOODFRAME
local FMUITABDIETFRAME

function FeedMachine:FMUI_Show()
	if not FMUIMAINFRAME then
		FMUIMAINFRAME = self:FMUI_CreateFrame()
		self:FMUI_CreateTabs()
	end

--~ 	if not FMUITABOPTIONFRAME then
--~ 		FMUITABOPTIONFRAME = self:FMUI_CreateOptions(FMUIMAINFRAME,384,512)
--~ 	end

	if not FMUITABFOODFRAME then
		FMUITABFOODFRAME = self:FMUI_CreateFoodLists(FMUIMAINFRAME,384,512)
	end

	if not FMUITABDIETFRAME then
		FMUITABDIETFRAME = self:FMUI_CreateDiets(FMUIMAINFRAME,384,512)
	end

	PanelTemplates_SetNumTabs(FMUIMAINFRAME, #FMUITABS)
	FMUIMAINFRAME.selectedTab = 1
	PanelTemplates_UpdateTabs(FMUIMAINFRAME)

	FMUITABFOODFRAME:Hide()
	FMUITABDIETFRAME:Hide()
	FMUIMAINFRAME:Hide()
--~ 	FMUITABOPTIONFRAME:Hide()

	FMUIMAINFRAME:Show()
	FMUITABFOODFRAME:Show()
--~ 	FMUITABOPTIONFRAME:Show()
end

function FeedMachine:FMUI_HandlerTabButton(buttonname)
	button = getglobal(buttonname)
--~ 	FMUITABOPTIONFRAME:Hide()
	FMUITABDIETFRAME:Hide()
	FMUITABFOODFRAME:Hide()

--~ 	if button:GetText() == L["Options"] then
--~ 		FMUITABOPTIONFRAME:Show()
	if button:GetText() == L["Foods"] then
		FMUITABFOODFRAME:Show()
	elseif button:GetText() == L["Diets"] then
		FMUITABDIETFRAME:Show()
	end
end

function FeedMachine:FMUI_CreateTabs()
	local x = 20
	local padding = 24
	for i, v in pairs(FMUITABS) do
		local b = CreateFrame("Button", FMUIMAINFRAME:GetName().."Tab"..i, FMUIMAINFRAME, "CharacterFrameTabButtonTemplate")
		b:SetPoint("BOTTOMLEFT", x, 45)
		b:SetID(i)
		b:SetText(v)

		PanelTemplates_TabResize(0, b)

		b:SetScript("OnClick", function()
			PanelTemplates_Tab_OnClick(FMUIMAINFRAME)
			self:FMUI_HandlerTabButton(this:GetName())
		end )

		x = x + b:GetTextWidth() + padding
	end
end

function FeedMachine:FMUI_CreateFrame()
	local f = CreateFrame("Frame", "FMUIMainFrame", UIParent)
	f:SetFrameStrata("BACKGROUND")
	f:SetHeight(512)
	f:SetWidth(384)
	f:SetMovable(true)
	f:SetClampedToScreen(true)
	f:EnableMouse(true)
	f:RegisterForDrag("LeftButton")
	f:SetPoint("CENTER", 0, 0)
	f:SetHitRectInsets(0, 30, 0, 45)
	table.insert(UISpecialFrames, "FMUIMainFrame")

	local portrait = f:CreateTexture(nil, "BACKGROUND")
	portrait:SetHeight(60)
	portrait:SetWidth(60)
	portrait:SetPoint("TOPLEFT", 7, -6)

	local t

	t = f:CreateTexture(nil, "BORDER")
	t:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-General-TopLeft")
	t:SetPoint("TOPLEFT", 2, -1)
	t:SetWidth(256)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "BORDER")
	t:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-General-TopRight")
	t:SetPoint("TOPLEFT", 258, -1)
	t:SetWidth(128)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "BORDER")
	t:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-General-BottomLeft")
	t:SetPoint("TOPLEFT", 2, -257)
	t:SetWidth(256)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "BORDER")
	t:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-General-BottomRight")
	t:SetPoint("TOPLEFT", 258, -257)
	t:SetWidth(128)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "ARTWORK")
	t:SetTexture("Interface\\TalentFrame\\HunterBeastMastery-TopLeft")
	t:SetPoint("TOPLEFT", 23, -77)
	t:SetWidth(256)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "ARTWORK")
	t:SetTexture("Interface\\TalentFrame\\HunterBeastMastery-TopRight")
	t:SetPoint("TOPLEFT", 279, -77)
	t:SetWidth(64)
	t:SetHeight(256)

	t = f:CreateTexture(nil, "ARTWORK")
	t:SetTexture("Interface\\TalentFrame\\HunterBeastMastery-BottomLeft")
	t:SetPoint("TOPLEFT", 23, -333)
	t:SetWidth(256)
	t:SetHeight(128)

	t = f:CreateTexture(nil, "ARTWORK")
	t:SetTexture("Interface\\TalentFrame\\HunterBeastMastery-BottomRight")
	t:SetPoint("TOPLEFT", 279, -333)
	t:SetWidth(64)
	t:SetHeight(128)

	local font = f:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	font:SetPoint("TOP", 0, -20)
	font:SetText(L["Feed Machine"])

	local b = CreateFrame("Button", nil, f, "UIPanelCloseButton")
	b:SetPoint("CENTER", f, "TOPRIGHT", -44, -25)

	b:SetScript("OnClick", function()
		f:Hide()
	end)

	f:SetScript("OnDragStart", function()
		this:StartMoving()
	end)

	f:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
	end)

	f:SetScript("OnUpdate", function()
		if UnitExists("pet") then
			SetPortraitTexture(portrait, "pet")
		else
			portrait:SetTexture("Interface\\CharcterFrame\\TemporaryPortrait-Monster")
		end
	end)

	return f
end