if select(2, UnitClass('player')) ~= "HUNTER" then
	DisableAddOn("FeedMachine")
	return
end

FeedMachine = LibStub("AceAddon-3.0"):NewAddon("FeedMachine", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0")

local L = LibStub("AceLocale-3.0"):GetLocale("FeedMachine")
local PT = LibStub("LibPeriodicTable-3.1")
local LBF = LibStub("LibButtonFacade", true)

local fpname = GetSpellInfo(1539)
local changesPending = false
local optionsFrame

local defaults = {
	debug = false,
	msgInterval = 60,
	lastWarningTime = 0,
	buttonX = 100,
	buttonY = 0,
	buttonScale = 1.0,
	buttonPoint = "CENTER",
	popupAnchor = "RIGHT",
	popupGrowthDir = 4,
	showUnknownFood = true,
	maxButtons = 10,
	foodlist = nil,
	version = nil,
	skin = {
		ID = "Dream Layout",
		Backdrop = true,
		Gloss = 0,
		Zoom = false,
	}
}

local options = {
	type = "group",
	args = {
--		debug = {
--			type = 'toggle',
--			name = "Debug Mode",
--			desc = "Toggle Debug mode (very spammy)",
--			get = function(info) return FeedMachine.db.profile.debug end,
--			set = function(info, v) FeedMachine.db.profile.debug = v end
--		},
		menu = {
			type = 'execute',
			name = L["Show Config"],
			desc = "Shows Config Screen (May be behind the Blizzard window)",
			func = function() FeedMachine:FMUI_Show() end
		},
		resetdb = {
			type = 'execute',
			name = L["Reset Food"],
			desc = L["Reset Food Database"],
			func = function()
				FeedMachine.db.profile.foodlist = nil
				FeedMachine.db.profile.version = LibStub.minors["LibPeriodicTable-3.1"]
				FeedMachine:InitDB()
			end
		},
		scale = {
			name = L["Button Scale"],
			desc = L["Control the size of the button"],
			type = "range", min = 0.25, max = 4, step = 0.01, bigStep = 0.1,
			get = function(t) return FeedMachine.db.profile.buttonScale end,
			set = function(t, v)
				FeedMachine.db.profile.buttonScale = v
				if not InCombatLockdown() then
					FeedMachine.feedButton:SetScale(v)
				else
					changesPending = true
				end
			end,
		},
		feedpetgrowthdir = {
			type = "select",
			name = L["Feed Pet Growth Direction"],
			desc = L["Sets the growth direction of the feed pet popup buttons"],
			values = {"TOP", "BOTTOM", "LEFT", "RIGHT"},
			style = "dropdown",
			get = function(info) return FeedMachine.db.profile.popupGrowthDir end,
			set = function(info,v)
				FeedMachine.db.profile.popupGrowthDir = v
				FeedMachine:Print("/console reloadui needed for change")
				FeedMachine:Print(FeedMachine.db.profile.popupGrowthDir)
			end,
		},
		warninginterval = {
			type = "range",
			name = L["Warning Interval"],
			desc = L["Sets interval in seconds at which warnings occur."],
			min = 5,
			max = 90,
			step = 1,
			bigStep = 5,
			get = function(info) return FeedMachine.db.profile.msgInterval end,
			set = function(info,v) FeedMachine.db.profile.msgInterval = tonumber(v)	end
		}
	}
}

function FeedMachine:InitDB()
	local convert = function(t_old)
		if t_old then
			local t = {}
			for k,v,s in PT:IterateSet(t_old) do
				local f = {}
				f["id"] = tonumber(k)
				if tonumber(v) then
					f["value"] = tonumber(v)
				else
					f["value"] = 0
				end
				f["selected"] = true

				table.insert(t,f)
			end
			table.sort(t, function (a,b) return a.value > b.value end)
			return t
		end
		return nil
	end

	if self.db.profile.foodlist == nil then
		if self.db.profile.debug then
			self:Print("Initializing Food DB")
		end
		self.db.profile.foodlist = {}

		local foodtable = {
			[1] = {["text"] = "Food - Meat Raw", ["pt3"]= "Consumable.Food.Inedible.Meat", ["icon"] = "Interface\\Icons\\INV_Misc_Food_71", ["enabled"] = false},
			[2] = {["text"] = "Food - Meat Basic", ["pt3"]= "Consumable.Food.Edible.Meat.Basic", ["icon"] = "Interface\\Icons\\INV_Misc_Food_15", ["enabled"] = true},
			[3] = {["text"] = "Food - Meat Bonus", ["pt3"]= "Consumable.Food.Edible.Meat.Bonus", ["icon"] = "Interface\\Icons\\INV_Misc_Food_48", ["enabled"] = false},
			[4] = {["text"] = "Food - Bread Combo", ["pt3"]= "Consumable.Food.Edible.Bread.Combo", ["icon"] = "Interface\\Icons\\INV_Misc_Food_33", ["enabled"] = false},
			[5] = {["text"] = "Food - Bread Basic", ["pt3"]= "Consumable.Food.Edible.Bread.Basic", ["icon"] = "Interface\\Icons\\INV_Misc_Food_12", ["enabled"] = true},
			[6] = {["text"] = "Food - Bread Bonus", ["pt3"]= "Consumable.Food.Edible.Bread.Bonus", ["icon"] = "Interface\\Icons\\INV_Misc_Food_62", ["enabled"] = false},
			[7] = {["text"] = "Food - Bread Conjured", ["pt3"]= "Consumable.Food.Edible.Bread.Conjured", ["icon"] = "Interface\\Icons\\INV_Misc_Food_73CinnamonRoll", ["enabled"] = true},
			[8] = {["text"] = "Food - Cheese Basic", ["pt3"]= "Consumable.Food.Edible.Cheese.Basic", ["icon"] = "Interface\\Icons\\INV_Misc_Food_37", ["enabled"] = true},
			[9] = {["text"] = "Food - Cheese Bonus", ["pt3"]= "Consumable.Food.Edible.Cheese.Bonus", ["icon"] = "Interface\\Icons\\INV_Misc_Food_06", ["enabled"] = false},
			[10] = {["text"] = "Food - Fish Raw", ["pt3"]= "Consumable.Food.Inedible.Fish", ["icon"] = "Interface\\Icons\\INV_Misc_Fish_06", ["enabled"] = false},
			[11] = {["text"] = "Food - Fish Basic", ["pt3"]= "Consumable.Food.Edible.Fish.Basic", ["icon"] = "Interface\\Icons\\INV_Misc_Fish_07", ["enabled"] = true},
			[12] = {["text"] = "Food - Fish Bonus", ["pt3"]= "Consumable.Food.Edible.Fish.Bonus", ["icon"] = "Interface\\Icons\\INV_Misc_Fish_05", ["enabled"] = false},
			[13] = {["text"] = "Food - Fish Combo", ["pt3"]= "Consumable.Food.Edible.Fish.Combo", ["icon"] = "Interface\\Icons\\INV_Misc_Fish_13", ["enabled"] = false},
			[14] = {["text"] = "Food - Fruit Basic", ["pt3"]= "Consumable.Food.Edible.Fruit.Basic", ["icon"] = "Interface\\Icons\\INV_Misc_Food_20", ["enabled"] = true},
			[15] = {["text"] = "Food - Fruit Bonus", ["pt3"]= "Consumable.Food.Edible.Fruit.Bonus", ["icon"] = "Interface\\Icons\\INV_Misc_Food_58", ["enabled"] = false},
			[16] = {["text"] = "Food - Fruit Combo", ["pt3"]= "Consumable.Food.Edible.Fruit.Combo", ["icon"] = "Interface\\Icons\\INV_Misc_Food_42", ["enabled"] = false},
			[17] = {["text"] = "Food - Fungus Basic", ["pt3"]= "Consumable.Food.Edible.Fungus.Basic", ["icon"] = "Interface\\Icons\\INV_Mushroom_11", ["enabled"] = true},
			[18] = {["text"] = "Food - Fungus Bonus", ["pt3"]= "Consumable.Food.Edible.Fungus.Bonus", ["icon"] = "Interface\\Icons\\INV_Mushroom_01", ["enabled"] = false},
			[19] = {["text"] = "Food - Fungus Combo", ["pt3"]= "Consumable.Food.Edible.Fungus.Combo", ["icon"] = "Interface\\Icons\\INV_Misc_Herb_07", ["enabled"] = false},
		}

		for _,v in ipairs(foodtable) do
--			self:Print("Adding: "..v["text"])
			table.insert(self.db.profile.foodlist,{
				["diet"] = v["text"],
				["list"] = convert(v["pt3"]),
				["icon"] = v["icon"],
				["selected"] = v["enabled"],
			})
		end
		if self.db.profile.debug then
			self:Print("Finished Food DB")
			self:Print("Resetting Food DB.")
		end
	end
end

function FeedMachine:tablecopy(t)
	if not t then
		return t
	end
	local tmp = {}
	for i,v in pairs(t) do
		if type(v) == table then
			tmp[i] = self:tablecopy(v)
		else
			tmp[i] = v
		end
	end
	return tmp
end

function FeedMachine:tableswap(t1,t2)
	local tmp = self:tablecopy(t1)
	t1 = self:tablecopy(t2)
	t2 = self:tablecopy(tmp)
	return t1, t2
end

function FeedMachine:OverrideBindings()
	local key1, key2 = GetBindingKey("FMFeedButton")
	if key1 then
		SetOverrideBindingClick(self.feedButton, false, key1, "FMFeedButton")
	end
	if key2 then
		SetOverrideBindingClick(self.feedButton, false, key2, "FMFeedButton")
	end
	SaveBindings(GetCurrentBindingSet())
end

function FeedMachine:OnInitialize()
	BINDING_HEADER_FeedMachine = "FeedMachine"
	BINDING_NAME_FMFeedButton = GetSpellInfo(6991)

	self.db = LibStub("AceDB-3.0"):New("FeedMachineDB", { profile = defaults }, "Default")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("FeedMachine", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("FeedMachine", "FeedMachine")
	self:RegisterChatCommand("fm", "ChatCommand")
	self:RegisterChatCommand("feedmachine", "ChatCommand")
	if self.db.profile.debug then
		self:Print("Debug Mode active")
	end

	if not self.db.profile.version or (self.db.profile.version < LibStub.minors["LibPeriodicTable-3.1"]) then
		self:Print(L["The Food DB updated, please resetdb to get new food data (/fm resetdb)"])
	end
	self:InitDB()
end

function FeedMachine:ChatCommand(input)
    if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToFrame(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(FeedMachine, "fm", "FeedMachine", input)
    end
end

function FeedMachine:OnEnable()
--~ FEED BUTTON
	if LBF then
		self.BF = LBF:Group("FeedMachineBar")
		self.BF.SkinID = self.db.profile.skin.ID or "Blizzard"
		self.BF.Backdrop = self.db.profile.skin.Backdrop
		self.BF.Gloss = self.db.profile.skin.Gloss
		LBF:RegisterSkinCallback("FeedMachineBar", SkinChanged, self)
	end

	self.feedButton = CreateFrame("Button", "FMFeedButton", UIParent, "SecureActionButtonTemplate, ActionButtonTemplate, SecureAnchorEnterTemplate")
	self.feedButton:SetPoint(self.db.profile.buttonPoint, UIParent, self.db.profile.buttonPoint, self.db.profile.buttonX, self.db.profile.buttonY)
	self.feedButton:SetScale(self.db.profile.buttonScale)
	self.feedButton:SetMovable(true)
	self.feedButton:SetClampedToScreen(true)
	self.feedButton:RegisterForDrag("LeftButton")

	self.feedButton.texture = self.feedButton:CreateTexture(nil, "BACKGROUND")
	self.feedButton.texture:SetTexture("Interface\\Icons\\Ability_Hunter_BeastTraining")
	self.feedButton.texture:SetAllPoints(self.feedButton)

--	self:Print("Building Button")
	self.feedButton:SetAttribute("unit", "player")
	self.feedButton:SetAttribute("type", "spell")
	self.feedButton:SetAttribute("spell", GetSpellInfo(6991))
	self.feedButton:SetAttribute("target-item", ATTRIBUTE_NOOP)
	self.feedButton:SetAttribute("*childraise-OnEnter", true)
	self.feedButton:SetAttribute("*childstate-OnEnter", "enter")
	self.feedButton:SetAttribute("*childstate-OnLeave", "leave")

	if LBF then
		self.BF:AddButton(self.feedButton)
	end

	self.feedButton:SetScript("OnEnter", function()
		-- added for SecureAnchorOnEnterTemplate, cause we define our own enter we need to make sure events get triggered
		-- code copied from SecureTemplates.xml
		self.feedButton:SetAttribute("_entered", true);
		SecureStateAnchor_RunChild(self.feedButton, "OnEnter", "onenterbutton");
		local itemlink = self:FM_UpdateFeedPetButtons()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		if itemlink then
			GameTooltip:SetHyperlink(itemlink)
		else
			GameTooltip:SetText("No food available for your pet.", 1, 1, 1)
			if not UnitExists("pet") then
			self:HideFeedPetButton()
			end
		end
		GameTooltip:Show()
	end)

	self.feedButton:SetScript("OnLeave", function()
		-- added for SecureAnchorOnEnterTemplate, cause we define our own enter we need to make sure events get triggered
		-- code copied from SecureTemplates.xml
		self.feedButton:SetAttribute("_entered", nil);
		SecureStateAnchor_RunChild(self.feedButton, "OnLeave", "onleavebutton")
		GameTooltip:Hide()
	end)

	self.feedButton:SetScript("PreClick", function()
		local itemlink = self:FM_UpdateFeedPetButtons()
		if not itemlink then
			if UnitName("pet") then
				FeedMachine:Chat(string.format(L["%s looks in your bags1 and sees no food in there."],UnitName("pet")))
			end
		end
	end)

	self.feedButton:SetScript("PostClick", function()
		self:HideFeedPetButton()
		self:FM_UpdateFeedPetButtons()
	end)

	self.feedButton:SetScript("OnDragStart", function()
		this:StartMoving()
	end)

	self.feedButton:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		ValidateFramePosition(this)
		self.db.profile.buttonPoint,_,_,self.db.profile.buttonX,self.db.profile.buttonY = this:GetPoint()
	end)

	local stateheadername = "FMSecureStateHeader"
	local hdr = _G[stateheadername]
	if(not hdr) then
		hdr = CreateFrame("Frame", stateheadername, self.feedButton, "SecureStateHeaderTemplate")
	end

	hdr:SetPoint("CENTER", 0, 0)

	hdr:SetAttribute("statemap-anchor-enter", "0:1")
	hdr:SetAttribute("statemap-anchor-leave", ";")
	hdr:SetAttribute("delaystatemap-anchor-leave", "1:0")
	hdr:SetAttribute("delaytimemap-anchor-leave",  "1:1")
	hdr:SetAttribute("delayhovermap-anchor-leave", "1:true")

	self.feedButton:SetAttribute("anchorchild", hdr)

	local relpt = self.feedButton

	for i = 1, self.db.profile.maxButtons do
		btn = CreateFrame("Button", "FMStateButton"..i, hdr, "SecureActionButtonTemplate, ActionButtonTemplate")

		btn:SetScript("OnEnter", function()
			if this.tooltip then
				GameTooltip:SetOwner(this)
				GameTooltip:SetHyperlink(this.tooltip)
				GameTooltip:Show()
			end
		end)

		btn:SetScript("OnLeave", function()
			GameTooltip:Hide()
		end)

		btn:SetAttribute("unit", "player")
		btn:SetAttribute("type", "spell")
		btn:SetAttribute("spell", GetSpellInfo(6991))
		btn:SetAttribute("target-item", ATTRIBUTE_NOOP)

		if LBF then
				self.BF:AddButton(btn)
			end

		if self.db.profile.popupGrowthDir == 1 then
			btn:SetPoint("BOTTOM", relpt, "TOP", 0, 5)
		elseif self.db.profile.popupGrowthDir == 2 then
			btn:SetPoint("TOP", relpt, "BOTTOM", 0, -5)
		elseif self.db.profile.popupGrowthDir == 3 then
			btn:SetPoint("RIGHT", relpt, "LEFT", -5, 0)
		elseif self.db.profile.popupGrowthDir == 4 then
			btn:SetPoint("LEFT", relpt, "RIGHT", 5, 0)
		end

		relpt = btn
		-- Show in state 2, not we will never swap to state 2, state 2 acts as a hidden state for buttons
		-- State 1 will be for buttons that are visible, state 2 for buttons that should not be Shown
		-- state 0 is defaull all hide buttons state
		btn:SetAttribute("showstates", 2)
		-- Add the btn to the driver header
		hdr:SetAttribute("addchild", btn)
	end

	self:RegisterEvent("UNIT_HAPPINESS")
	self:RegisterEvent("PLAYER_CONTROL_LOST")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("FM_CheckForFeeding")
	if not UnitExists("pet") then
		self:HideFeedPetButton()
	end
end

function SkinChanged(_, SkinID, Gloss, Backdrop)
	FeedMachine.db.profile.skin.ID = SkinID
	FeedMachine.db.profile.skin.Gloss = Gloss
	FeedMachine.db.profile.skin.Backdrop = Backdrop
end

function FeedMachine:PLAYER_ENTERING_WORLD()
	self:HideFeedPetButton()
end

function FeedMachine:PLAYER_CONTROL_LOST()
	self:HideFeedPetButton()
end

local combat = 0
function FeedMachine:PLAYER_REGEN_DISABLED()
	combat = 1
	self.feedButton:Hide()
	self:HideFeedPetButton()
end

function FeedMachine:PLAYER_REGEN_ENABLED()
	combat = 0
	self:HideFeedPetButton()
	if changesPending then
		self.feedButton:SetScale(self.db.profile.buttonScale)
	end
end

-- Probably need rewrite
--[[function FeedMachine:CHAT_MSG_SPELL_FAILED_LOCALPLAYER(err)
	if err then
		if string.find(err, L["You fail to perform Feed Pet: You are mounted."])) then
			self:Chat(string.format(L["%s thinks you should unmount before feeding him."], UnitName("pet")))
		elseif string.find(err, L["You fail to perform Feed Pet: Out of range."])) then
			self:Chat(string.format(L["%s likes to get closer with you before getting fed."], UnitName("pet")))
		elseif string.find(err, L["You fail to perform Feed Pet: That food's level is not high enough for your pet."])) then
			self:Chat(string.format(L["%s wants food of a more appropriate level."], UnitName("pet")))
		elseif string.find(err, L["You fail to perform Feed Pet: Can't do that while stunned."])) then
			self:Chat(string.format(L["%s looks at you, wondering how you will feed him when you are stunned."], UnitName("pet")))
		end
	end
end]]

function FeedMachine:UNIT_HAPPINESS()
	self:HideFeedPetButton()
end

function FeedMachine:FM_UpdateFeedPetButtons()
	if InCombatLockdown() then
		if self.db.profile.debug then
			self:Print("Debug:Trying to update in combat, aborting")
		end
		return
	end
	local diets = {GetPetFoodTypes()}
	local buttoncount = 1
	local returnitemlink = nil
	local tmp_diet = nil

	for i = 1,FeedMachine.db.profile.maxButtons do
		local buttonname = "FMStateButton"..i
		local btn = _G[buttonname]
		if btn then
			btn:SetAttribute("showstates", 2)
		end
	end

	for i,_ in ipairs(FeedMachine.db.profile.foodlist) do
		if FeedMachine.db.profile.foodlist[i]["selected"] then
			for idx,dietdebug in ipairs(diets) do
				if self.db.profile.debug then
				self:Print("D: "..dietdebug)
				end
				if L[diets[idx]] then
					tmp_diet = L[diets[idx]]
				else
					tmp_diet = nil
					self:Print("No reverse translation found for : ", diets[idx])
				end
				if tmp_diet and string.find(FeedMachine.db.profile.foodlist[i]["diet"],tmp_diet) then
					for index,_ in pairs(FeedMachine.db.profile.foodlist[i]["list"]) do
						if buttoncount > FeedMachine.db.profile.maxButtons then
							if not returnitemlink then
								FeedMachine.feedButton:SetAttribute("target-item", ATTRIBUTE_NOOP)
							end
							return returnitemlink
						end
						itemName, itemLink, _, itemLevel, _, _, _, _, _, itemTexture = GetItemInfo(FeedMachine.db.profile.foodlist[i]["list"][index]["id"])
						if itemLink and GetItemCount(itemLink) > 0 and FeedMachine.db.profile.foodlist[i]["list"][index]["selected"] then
							if buttoncount == 1 then --Update smart feed button in first scan only
								self.feedButton:SetAttribute("target-item", itemName)
								returnitemlink = itemLink --Store itemlink so we can return it at the end
								self.feedButton.texture = self.feedButton:CreateTexture(nil, "ARTWORK")
								self.feedButton.texture:SetTexture(itemTexture)
								self.feedButton.texture:SetAllPoints(self.feedButton)
							end
							local buttonname = "FMStateButton"..buttoncount
							local btn = _G[buttonname]
							if btn then
								btn.texture = btn:CreateTexture(buttonname.."texture", "ARTWORK")
								btn.texture:SetTexture(itemTexture)
								btn.texture:SetAllPoints(btn)

								btn.count = btn:CreateFontString(buttonname.."count", "ARTWORK", "GameFontNormal")
								btn.count:SetJustifyH("LEFT")
								btn.count:SetPoint("BOTTOMRIGHT", btn, 0, 0)

								btn.count:SetText(GetItemCount(itemName))
								btn.tooltip = itemLink
								btn:SetAttribute("showstates", 1)
								btn:SetAttribute("target-item", itemName)
							end
							buttoncount = buttoncount + 1
						end
					end
				end
			end
		end
	end
	if not returnitemlink then
		FeedMachine.feedButton:SetAttribute("target-item", ATTRIBUTE_NOOP)
	end
	return returnitemlink
end

function FeedMachine:FM_CheckForFeeding()
	if not UnitExists("pet") then
		FeedMachine:HideFeedPetButton()
	return end
	if FeedMachine:FM_UpdateFeedPetButtons() then return end
	if InCombatLockdown() then return end
	if difftime(time(), tonumber(FeedMachine.db.profile.lastWarningTime)) > tonumber(FeedMachine.db.profile.msgInterval) then
		if not UnitName("pet") == "Unknown" then
			FeedMachine.db.profile.lastWarningTime = time()
			FeedMachine:Chat(string.format(L["%s looks in your bags and sees no food in there."],UnitName("pet")))
		end
	end
end

function FeedMachine:Chat(text)
	DEFAULT_CHAT_FRAME:AddMessage(string.format("|cffeda55f%s|r", tostring(text)))
end

function FeedMachine:CheckForFeedPetBuff()
	local i = 1
	while UnitBuff("pet",i)~=nil do
		if UnitBuff("pet",i) == fpname then
			return true
		end
		i = i + 1
	end
	return false
end

local timer

local function hidebuttons(self)
	if timer then
		self:CancelTimer(timer)
		timer = nil
	end
	if not InCombatLockdown() then
		for i = 1,self.db.profile.maxButtons do
			local btn = _G["FMStateButton"..i]
			btn:SetAttribute("showstates", 2)
			btn:Hide()
		end
		self.feedButton:Hide()
	end
end

local function showbuttons(self)
	if not timer then
		timer = self:ScheduleRepeatingTimer("FM_CheckForFeeding", 15)
	end
	self.feedButton:Show()
end

function FeedMachine:HideFeedPetButton()
	if not UnitExists("pet") or UnitIsDead("pet") then
		hidebuttons(self)
	elseif InCombatLockdown() or combat == 1 then
		hidebuttons(self)
	elseif GetPetHappiness() == 3 or IsMounted() then
		hidebuttons(self)
	elseif self:CheckForFeedPetBuff() then
		hidebuttons(self)
	elseif not self:FM_UpdateFeedPetButtons() then
		hidebuttons(self)
	else
		showbuttons(self)
	end
end