function FastQuestButton_OnClick()
	FastQuest_Toggle();
end

function FastQuestButton_Init()
	if(FastQuestOptions.FastQuestButtonShown) then
		FastQuestButtonFrame:Show();
	else
		FastQuestButtonFrame:Hide();
	end
end

function FastQuestButton_Toggle()
	if(FastQuestButtonFrame:IsVisible()) then
		FastQuestButtonFrame:Hide();
		FastQuestOptions.FastQuestButtonShown = false;
	else
		FastQuestButtonFrame:Show();
		FastQuestOptions.FastQuestButtonShown = true;
	end
	FastQuestOptions_Init();
end

function FastQuestButton_UpdatePosition()
	FastQuestButtonFrame:SetPoint(
		"TOPLEFT",
		"Minimap",
		"TOPLEFT",
		54 - (FastQuestOptions.FastQuestButtonRadius * cos(FastQuestOptions.FastQuestButtonPosition)),
		(FastQuestOptions.FastQuestButtonRadius * sin(FastQuestOptions.FastQuestButtonPosition)) - 55
	);
	FastQuestOptions_Init();
end

-- Thanks to Yfastquest for this code
function FastQuestButton_BeingDragged()
    -- Thanks to Gello for this code
    local xpos,ypos = GetCursorPosition() 
    local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom() 

    xpos = xmin-xpos/UIParent:GetScale()+70 
    ypos = ypos/UIParent:GetScale()-ymin-70 

    FastQuestButton_SetPosition(math.deg(math.atan2(ypos,xpos)));
end

function FastQuestButton_SetPosition(v)
    if(v < 0) then
        v = v + 360;
    end

    FastQuestOptions.FastQuestButtonPosition = v;
    FastQuestButton_UpdatePosition();
end

function FastQuestButton_OnEnter()
    GameTooltip:SetOwner(this, "ANCHOR_LEFT");
    GameTooltip:SetText(FASTQUEST_BUTTON_TOOLTIP_TITLE);
	GameTooltipTextLeft1:SetTextColor(1, 1, 1);
    GameTooltip:AddLine(FASTQUEST_BUTTON_TOOLTIP_HINT);
    GameTooltip:Show();
end