--[[--------------------------------------------------------
-- Factionizer, a reputation management tool --
------------------------------------------------------------
CODE INDEX (search on index for fast access):
_01_ Addon Variables
_02_ Addon Startup
_03_ Event Handler
_04_ Addon Initialization
_05_ Slash Handler
_06_ General Helper Functions
_07_ Information
_08_ Faction map
_09_ Faction gain
_10_ New Hook Functions
_11_ Prepare update entries
_12_ Reputation Changes to Chat
_13_ Chat filtering
_14_ Testing
_15_ Getting reputation ready to hand in
_16_ Listing by standing
_17_ List german names
_18_ urbin addon listing
_19_ sso phase handling
_20_ sso phase handling UI glue
_21_ extracting skill information
_22_ extracting skill information
]]----------------------------------------------------------

--[[
StandingId
0 - Unknown
1 - Hated	-42k .. -6k	36k
2 - Hostile	- 6k .. -3k	 3k
3 - Unfriendly	- 3k ..  0	 3k
4 - Neutral	  0  ..  3k	 3k
5 - Friendly	  3k ..  9k	 6k
6 - Honored	  9k .. 21k	12k
7 - Revered	 21k .. 42k	21k
8 - Exalted	 42k .. 43k	 1k
local standingName = FACTION_STANDING_LABEL(standingID)
]]--

-- Addon constants
FIZ_NAME 	= "Factionizer"
FIZ_VNMBR	= 201031			-- Number code for this version

-- Colours
FIZ_HELP_COLOUR		= "|cFFFFFF7F"
FIZ_ERROR_COLOUR	= "|cFFFF0000"
FIZ_UNKNOWN_COLOUR	= "|cFF7F7F7F"
FIZ_HOSTILE_COLOUR	= "|cFFCC4C38"
FIZ_NEUTRAL_COLOUR	= "|cFFE5B200"
FIZ_FRIENDLY_COLOUR	= "|cFF009919"
FIZ_NEW_REP_COLOUR	= "|cFF7F7FFF"
FIZ_NEW_STANDING_COLOUR	= "|cFF6060C0"
FIZ_BAG_COLOUR		= "|cFFC0FFC0"
FIZ_BAG_BANK_COLOUR	= "|cFFFFFF7F"
FIZ_QUEST_COLOUR	= "|cFFC0FFC0"
FIZ_HIGHLIGHT_COLOUR    = "|cFF00FF00"
FIZ_QUEST_ACTIVE_COLOUR	= "|cFFFF7F7F"
FIZ_LOWLIGHT_COLOUR	= "|cFFFF3F3F"
FIZ_SUPPRESS_COLOUR	= "|cFF7F7F7F"

FIZ_LIMIT_TYPE_HERB	= 1
FIZ_LIMIT_TYPE_SKIN	= 2
FIZ_LIMIT_TYPE_MINE	= 3
FIZ_LIMIT_TYPE_SSO	= 4
FIZ_LIMIT_TYPE_GATHER	= 5

--------------------------
-- _01_ Addon Variables --
--------------------------

-- Stored data
FIZ_Data = {}			-- Data saved between sessions
-- Initialization
FIZ_Main = nil			-- Main program window
FIZ_InitComplete = nil
-- Faction information
FIZ_FactionMapping = {}
FIZ_FactionGain = {}
-- Tracking data
FIZ_Entries = {}
-- SSO phase tracking
FIZ_SSO_WARNED = false
-- Skill tracking
FIZ_Herb = false
FIZ_Skin = false
FIZ_Mine = false

------------------------
-- _02_ Addon Startup --
------------------------

------------------------------------------------------------
function FIZ_OnLoad()
	-- Events monitored by Event Handler
	FIZ_Main = this
	this:RegisterEvent("ADDON_LOADED")
	this:RegisterEvent("PLAYER_ENTERING_WORLD")

	-- Slash commands for CLI
	SLASH_FIZ1 = "/factionizer"
	SLASH_FIZ2 = "/fz"
	SlashCmdList.FIZ = FIZ_SlashHandler

	FIZ_Orig_GetFactionInfo = GetFactionInfo;
	GetFactionInfo = FIZ_GetFactionInfo;

	FIZ_Orig_ReputationFrame_Update = ReputationFrame_Update
	ReputationFrame_Update = FIZ_ReputationFrame_Update

	FIZ_Orig_ReputationBar_OnClick = ReputationBar_OnClick
	ReputationBar_OnClick = FIZ_ReputationBar_OnClick

	FIZ_Orig_ExpandFactionHeader = ExpandFactionHeader
	ExpandFactionHeader = FIZ_ExpandFactionHeader

	FIZ_Orig_CollapseFactionHeader = CollapseFactionHeader
	CollapseFactionHeader = FIZ_CollapseFactionHeader

	FIZ_Orig_ChatFrame_OnEvent = ChatFrame_OnEvent
	ChatFrame_OnEvent = FIZ_ChatFrame_OnEvent

	FIZ_Orig_StandingText = ReputationFrameStandingLabel:GetText()
end

------------------------------------------------------------
function FIZ_myAddons()
	-- Register addon with myAddons
	if not (myAddOnsFrame_Register) then return end
	local version = GetAddOnMetadata("Factionizer", "Version");
	local date = GetAddOnMetadata("Factionizer", "X-Date");
	local author = GetAddOnMetadata("Factionizer", "Author");
	local web = GetAddOnMetadata("Factionizer", "X-Website");
	if (version == nil) then
		version = "unknown";
	end
	if (date == nil) then
		date = "unknown";
	end
	if (author == nil) then
		author = "unknown";
	end
	if (web == nil) then
		web = "unknown";
	end

	myAddOnsFrame_Register({
		name = FIZ_NAME,
		version = version,
		releaseDate = date,
		author = author,
		email = "none",
		website = web,
		category = MYADDONS_CATEGORY_UNKNOWN,
		optionsframe = nil,
	})
end


------------------------
-- _03_ Event Handler --
------------------------

function FIZ_OnEvent(evt)
	if (event == "ADDON_LOADED") and (arg1 == FIZ_NAME) then
		FIZ_myAddons()
		FIZ_RegisterUrbinAddon(FIZ_NAME, FIZ_About)
		FIZ_Main:UnregisterEvent("ADDON_LOADED")

	elseif (event == "PLAYER_ENTERING_WORLD") then
		FIZ_Init()
		FIZ_Main:UnregisterEvent("PLAYER_ENTERING_WORLD")
--		FIZ_Main:RegisterEvent("PLAYER_LEAVING_WORLD")
		FIZ_Main:RegisterEvent("UPDATE_FACTION")
		FIZ_Main:RegisterEvent("BAG_UPDATE")
--		FIZ_Main:RegisterEvent("UNIT_INVENTORY_CHANGED")	-- can be fired many times upon logging/zoning
		FIZ_Main:RegisterEvent("BANKFRAME_OPENED")
		FIZ_Main:RegisterEvent("BANKFRAME_CLOSED")
		-- to keep list of known skills up to date
		FIZ_Main:RegisterEvent("CHAT_MSG_SKILL")
		FIZ_Main:RegisterEvent("CHAT_MSG_SPELL_TRADESKILLS")
		FIZ_Main:RegisterEvent("SKILL_LINES_CHANGED")
		FIZ_Main:RegisterEvent("UPDATE_TRADESKILL_RECAST")
		FIZ_Main:RegisterEvent("QUEST_COMPLETE")
		FIZ_Main:RegisterEvent("QUEST_WATCH_UPDATE")

--	elseif( event == "PLAYER_LEAVING_WORLD" ) then
--		FIZ_Main:RegisterEvent("PLAYER_ENTERING_WORLD")
--		FIZ_Main:UnregisterEvent("PLAYER_LEAVING_WORLD")
--		FIZ_Main:UnregisterEvent("BAG_UPDATE")
--		FIZ_Main:UnregisterEvent("UNIT_INVENTORY_CHANGED")

	elseif (event == "UPDATE_FACTION" or
	        event == "QUEST_COMPLETE" or
	        event == "QUEST_WATCH_UPDATE") then
		if ( ReputationFrame:IsVisible() ) then
			ReputationFrame_Update();
		end
		if ( FIZ_ReputationDetailFrame:IsVisible()) then
			FIZ_BuildUpdateList()
			FIZ_UpdateList_Update()
		end
		FIZ_DumpReputationChangesToChat()

	elseif ( event == "BAG_UPDATE") then
		if (FIZ_ReputationDetailFrame:IsVisible()) then
			-- update rep frame (implicitely updates detail frame which in turn implicitely reparses bag contents)
			ReputationFrame_Update()
		end

--	elseif ( event == "UNIT_INVENTORY_CHANGED") then
--		if (arg1 == "player") then
--			if (FIZ_ReputationDetailFrame:IsVisible()) then
--				-- update rep frame (implicitely updates detail frame which in turn implicitely reparses bag contents)
--				ReputationFrame_Update()
--			end
--		end

	elseif ( event == "BANKFRAME_OPENED") then
		FIZ_BankOpen = true

	elseif ( event == "BANKFRAME_CLOSED") then
		-- this is fired twice when closing the bank window, bank contents only available at the first event
		if (FIZ_BankOpen) then
			-- this is the first call
			FIZ_ParseBankContent()
			FIZ_BankOpen = nil

			if (FIZ_ReputationDetailFrame:IsVisible()) then
				-- update rep frame (implicitely updates detail frame which in turn implicitely reparses bag contents)
				ReputationFrame_Update()
			end
		end

	elseif ( event == "CHAT_MSG_SKILL") or
	       ( event == "CHAT_MSG_SPELL_TRADESKILLS") or
	       ( event == "SKILL_LINES_CHANGED") or
	       ( event == "UPDATE_TRADESKILL_RECAST") then
		FIZ_ExtractSkills()
		if ( ReputationFrame:IsVisible() ) then
			ReputationFrame_Update();
		end
		if ( FIZ_ReputationDetailFrame:IsVisible()) then
			FIZ_BuildUpdateList()
			FIZ_UpdateList_Update()
		end

	end
end

-------------------------------
function FIZ_OnUpdate()
	if FIZ_InitComplete then return end
	if not FIZ_UpdateRequest then return end
	if (GetTime() < FIZ_UpdateRequest) then return end

	FIZ_Init()
end


-------------------------------
-- _04_ Addon Initialization --
-------------------------------

function FIZ_Init()
	local version = GetAddOnMetadata("Factionizer", "Version");
	if (version == nil) then
		version = "unknown";
	end

	-- create data structures
	if not FIZ_Data then FIZ_Data = {} end
	if not FIZ_Data.SSO then FIZ_Data.SSO = {} end

	if FIZ_Data.ChatFrame == nil then FIZ_Data.ChatFrame = 0 end
	--if not FIZ_Data.ShowMobs then FIZ_Data.ShowMobs = true end
	--if not FIZ_Data.ShowQuests then FIZ_Data.ShowQuests = true end
	--if not FIZ_Data.ShowInstances then FIZ_Data.ShowInstances = true end
	--if not FIZ_Data.ShowItems then FIZ_Data.ShowItems = true end

	-- if not FIZ_Data.ShowMissing then FIZ_Data.ShowMissing = true end
	-- if not FIZ_Data.ExtendDetails then FIZ_Data.ExtendDetails = true end
	-- if not FIZ_Data.WriteChatMessage then FIZ_Data.WriteChatMessage = true end
	-- if not FIZ_Data.SuppressOriginalChat then FIZ_Data.SuppressOriginalChat = true end
	-- if not FIZ_Data.ShowPreviewRep then FIZ_Data.ShowPreviewRep = true end

	-- Keep version in configuration file
	FIZ_Data.Version = FIZ_VNMBR

	-- set up UI
	FIZ_OptionsButtonText:SetText(FIZ_TXT.options)
	FIZ_OptionsFrameTitle:SetText(FIZ_NAME.." "..FIZ_TXT.options)

	FIZ_EnableMissingBoxText:SetText(FIZ_TXT.showMissing)
	FIZ_ExtendDetailsBoxText:SetText(FIZ_TXT.extendDetails)
	FIZ_GainToChatBoxText:SetText(FIZ_TXT.gainToChat)
	FIZ_SupressOriginalGainBoxText:SetText(FIZ_TXT.suppressOriginalGain)
	FIZ_ShowPreviewRepBoxText:SetText(FIZ_TXT.showPreviewRep)
	FIZ_OrderByStandingCheckBoxText:SetText(FIZ_TXT.orderByStanding)

	FIZ_EnableMissingBox:SetChecked(FIZ_Data.ShowMissing)
	FIZ_ExtendDetailsBox:SetChecked(FIZ_Data.ExtendDetails)
	FIZ_GainToChatBox:SetChecked(FIZ_Data.WriteChatMessage)
	FIZ_SupressOriginalGainBox:SetChecked(FIZ_Data.SuppressOriginalChat)
	FIZ_ShowPreviewRepBox:SetChecked(FIZ_Data.ShowPreviewRep)
	FIZ_OrderByStandingCheckBox:SetChecked(FIZ_Data.SortByStanding)

	FIZ_ChatFrameSlider:SetValue(FIZ_Data.ChatFrame)

	local _, race = UnitRace("player")
	local faction, locFaction = UnitFactionGroup("player")
	FIZ_Player = UnitName("player")
	FIZ_Realm = GetCVar("realmName")

	if (race and faction and locFaction and FIZ_Player and FIZ_Realm) then
		if (race == "Human") then
			FIZ_IsHuman = true
		end

		if (faction == FACTION_ALLIANCE) or (locFaction == FACTION_ALLIANCE) then
			FIZ_IsAlliance = true
		end

		if (faction == FACTION_HORDE) or (locFaction == FACTION_HORDE) then
			FIZ_IsHorde = true
		end

		if not FIZ_Data.SSO[FIZ_Realm] then FIZ_Data.SSO[FIZ_Realm] = {} end

		-- Initialize faction information
		FIZ_InitFactionMap()
		FIZ_InitFactionGains()

		FIZ_DumpReputationChangesToChat(true)

		FIZ_InitComplete = true
		FIZ_UpdateRequest = nil
	end
end


------------------------
-- _05_ Slash Handler --
------------------------

function FIZ_SlashHandler(msg)
	if not msg then
		return
	else
		local msgLower = string.lower(msg)
		local words = FIZ_GetWords(msg)
		local wordsLower = FIZ_GetWords(msgLower)
		local size = FIZ_TableSize(wordsLower)

		if (size>0) then
			if (wordsLower[0]=="enable") then
				if (size>1) then
					if (wordsLower[1]=="mobs") then
						FIZ_Data.ShowMobs = true
					elseif  (wordsLower[1]=="quests") then
						FIZ_Data.ShowQuests = true
					elseif  (wordsLower[1]=="dungeons" or wordsLower[1]=="instances") then
						FIZ_Data.ShowInstances = true
					elseif  (wordsLower[1]=="items") then
						FIZ_Data.ShowItems = true
					elseif  (wordsLower[1]=="missing") then
						FIZ_Data.ShowMissing = true
					elseif  (wordsLower[1]=="details") then
						FIZ_Data.ExtendDetails = true
					elseif  (wordsLower[1]=="chat") then
						FIZ_Data.WriteChatMessage = true
					elseif  (wordsLower[1]=="suppress") then
						FIZ_Data.SuppressOriginalChat = true
					elseif (wordsLower[1]=="preview") then
						FIZ_Data.ShowPreviewRep = true
					elseif  (wordsLower[1]=="all") then
						FIZ_Data.ShowMobs = true
						FIZ_Data.ShowQuests = true
						FIZ_Data.ShowInstances = true
						FIZ_Data.ShowItems = true
						FIZ_Data.ShowMissing = true
						FIZ_Data.ExtendDetails = true
						FIZ_Data.WriteChatMessage = true
						FIZ_Data.SuppressOriginalChat = true
						FIZ_Data.ShowPreviewRep = true
					else
						FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
						FIZ_Help()
					end

					if ( ReputationFrame:IsVisible() ) then
						ReputationFrame_Update();
					end
					if ( FIZ_ReputationDetailFrame:IsVisible()) then
						FIZ_BuildUpdateList()
						FIZ_UpdateList_Update()
					end
				else
					FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
					FIZ_Help()
				end
			elseif (wordsLower[0]=="disable") then
				if (size>1) then
					if (wordsLower[1]=="mobs") then
						FIZ_Data.ShowMobs = false
					elseif  (wordsLower[1]=="quests") then
						FIZ_Data.ShowQuests = false
					elseif  (wordsLower[1]=="dungeons" or wordsLower[1]=="instances") then
						FIZ_Data.ShowInstances = false
					elseif  (wordsLower[1]=="items") then
						FIZ_Data.ShowItems = false
					elseif  (wordsLower[1]=="missing") then
						FIZ_Data.ShowMissing = false
					elseif  (wordsLower[1]=="details") then
						FIZ_Data.ExtendDetails = false
					elseif  (wordsLower[1]=="chat") then
						FIZ_Data.WriteChatMessage = false
					elseif  (wordsLower[1]=="suppress") then
						FIZ_Data.SuppressOriginalChat = false
					elseif (wordsLower[1]=="preview") then
						FIZ_Data.ShowPreviewRep = false
					elseif  (wordsLower[1]=="all") then
						FIZ_Data.ShowMobs = false
						FIZ_Data.ShowQuests = false
						FIZ_Data.ShowInstances = false
						FIZ_Data.ShowItems = false
						FIZ_Data.ShowMissing = false
						FIZ_Data.ExtendDetails = false
						FIZ_Data.WriteChatMessage = false
						FIZ_Data.SuppressOriginalChat = false
						FIZ_Data.ShowPreviewRep = false
					else
						FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
						FIZ_Help()
					end

					if ( ReputationFrame:IsVisible() ) then
						ReputationFrame_Update();
					end
					if ( FIZ_ReputationDetailFrame:IsVisible()) then
						FIZ_BuildUpdateList()
						FIZ_UpdateList_Update()
					end
				else
					FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
					FIZ_Help()
				end
			elseif (wordsLower[0]=="toggle") then
				if (size>1) then
					if (wordsLower[1]=="mobs") then
						FIZ_Data.ShowMobs = not FIZ_Data.ShowMobs
					elseif  (wordsLower[1]=="quests") then
						FIZ_Data.ShowQuests = not FIZ_Data.ShowQuests
					elseif  (wordsLower[1]=="dungeons" or wordsLower[1]=="instances") then
						FIZ_Data.ShowInstances = not FIZ_Data.ShowInstances
					elseif  (wordsLower[1]=="items") then
						FIZ_Data.ShowItems = not FIZ_Data.ShowItems
					elseif  (wordsLower[1]=="missing") then
						FIZ_Data.ShowMissing = not FIZ_Data.ShowMissing
					elseif  (wordsLower[1]=="details") then
						FIZ_Data.ExtendDetails = not FIZ_Data.ExtendDetails
					elseif  (wordsLower[1]=="chat") then
						FIZ_Data.WriteChatMessage = not FIZ_Data.WriteChatMessage
					elseif  (wordsLower[1]=="suppress") then
						FIZ_Data.SuppressOriginalChat = not FIZ_Data.SuppressOriginalChat
					elseif (wordsLower[1]=="preview") then
						FIZ_Data.ShowPreviewRep = not FIZ_Data.ShowPreviewRep
					elseif  (wordsLower[1]=="all") then
						FIZ_Data.ShowMobs = not FIZ_Data.ShowMobs
						FIZ_Data.ShowQuests = not FIZ_Data.ShowQuests
						FIZ_Data.ShowInstances = not FIZ_Data.ShowInstances
						FIZ_Data.ShowItems = not FIZ_Data.ShowItems
						FIZ_Data.ShowMissing = not FIZ_Data.ShowMissing
						FIZ_Data.ExtendDetails = not FIZ_Data.ExtendDetails
						FIZ_Data.WriteChatMessage = not FIZ_Data.WriteChatMessage
						FIZ_Data.SuppressOriginalChat = not FIZ_Data.SuppressOriginalChat
						FIZ_Data.ShowPreviewRep = not FIZ_Data.ShowPreviewRep
					else
						FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
						FIZ_Help()
					end

					if ( ReputationFrame:IsVisible() ) then
						ReputationFrame_Update();
					end
					if ( FIZ_ReputationDetailFrame:IsVisible()) then
						FIZ_BuildUpdateList()
						FIZ_UpdateList_Update()
					end
				else
					FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
					FIZ_Help()
				end
			elseif (wordsLower[0]=="list") then
				if (size>1) then
					if (wordsLower[1]=="1" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL1"))) then
						FIZ_ListByStanding(1)
					elseif (wordsLower[1]=="2" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL2"))) then
						FIZ_ListByStanding(2)
					elseif (wordsLower[1]=="3" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL3"))) then
						FIZ_ListByStanding(3)
					elseif (wordsLower[1]=="4" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL4"))) then
						FIZ_ListByStanding(4)
					elseif (wordsLower[1]=="5" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL5"))) then
						FIZ_ListByStanding(5)
					elseif (wordsLower[1]=="6" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL6"))) then
						FIZ_ListByStanding(6)
					elseif (wordsLower[1]=="7" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL7"))) then
						FIZ_ListByStanding(7)
					elseif (wordsLower[1]=="8" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL8"))) then
						FIZ_ListByStanding(8)
					else
						FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
						FIZ_Help()
					end
				else
					FIZ_ListByStanding()
				end
			elseif (wordsLower[0]=="de") then
				if (size>1) then
					if (wordsLower[1]=="1" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL1"))) then
						FIZ_ShowGerman(1)
					elseif (wordsLower[1]=="2" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL2"))) then
						FIZ_ShowGerman(2)
					elseif (wordsLower[1]=="3" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL3"))) then
						FIZ_ShowGerman(3)
					elseif (wordsLower[1]=="4" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL4"))) then
						FIZ_ShowGerman(4)
					elseif (wordsLower[1]=="5" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL5"))) then
						FIZ_ShowGerman(5)
					elseif (wordsLower[1]=="6" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL6"))) then
						FIZ_ShowGerman(6)
					elseif (wordsLower[1]=="7" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL7"))) then
						FIZ_ShowGerman(7)
					elseif (wordsLower[1]=="8" or wordsLower[1]==string.lower(getglobal("FACTION_STANDING_LABEL8"))) then
						FIZ_ShowGerman(8)
					else
						FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
						FIZ_Help()
					end
				else
					FIZ_ShowGerman()
				end
			elseif (wordsLower[0]=="phase" or wordsLower[0]=="sso") then
				if (size>1) then
					if (wordsLower[1]=="1") then
						FIZ_SetSSOPhase(1)
					elseif (wordsLower[1]=="2") then
						FIZ_SetSSOPhase(2)
					elseif (wordsLower[1]=="3") then
						FIZ_SetSSOPhase(3)
					elseif (wordsLower[1]=="4") then
						FIZ_SetSSOPhase(4)
					elseif (wordsLower[1]=="clear") then
						FIZ_SetSSOPhase(nil)
					else
						FIZ_Help()
					end
				else
					FIZ_SSOPhaseStatus()
				end

				if ( ReputationFrame:IsVisible() ) then
					ReputationFrame_Update();
				end
				if ( FIZ_ReputationDetailFrame:IsVisible()) then
					FIZ_BuildUpdateList()
					FIZ_UpdateList_Update()
				end
			elseif (wordsLower[0]=="phase2b") then
				if (size>1) then
					if (wordsLower[1]=="1") then
						FIZ_SetSSOPhase2b(1)
					elseif (wordsLower[1]=="2") then
						FIZ_SetSSOPhase2b(2)
					else
						FIZ_Help()
					end
				else
					FIZ_SSOPhaseStatus()
				end

				if ( ReputationFrame:IsVisible() ) then
					ReputationFrame_Update();
				end
				if ( FIZ_ReputationDetailFrame:IsVisible()) then
					FIZ_BuildUpdateList()
					FIZ_UpdateList_Update()
				end
			elseif (wordsLower[0]=="phase3b") then
				if (size>1) then
					if (wordsLower[1]=="1") then
						FIZ_SetSSOPhase3b(1)
					elseif (wordsLower[1]=="2") then
						FIZ_SetSSOPhase3b(2)
					else
						FIZ_Help()
					end
				else
					FIZ_SSOPhaseStatus()
				end

				if ( ReputationFrame:IsVisible() ) then
					ReputationFrame_Update();
				end
				if ( FIZ_ReputationDetailFrame:IsVisible()) then
					FIZ_BuildUpdateList()
					FIZ_UpdateList_Update()
				end
			elseif (wordsLower[0]=="phase4b") then
				if (size>1) then
					if (wordsLower[1]=="1") then
						FIZ_SetSSOPhase4b(1)
					elseif (wordsLower[1]=="2") then
						FIZ_SetSSOPhase4b(2)
					else
						FIZ_Help()
					end
				else
					FIZ_SSOPhaseStatus()
				end

				if ( ReputationFrame:IsVisible() ) then
					ReputationFrame_Update();
				end
				if ( FIZ_ReputationDetailFrame:IsVisible()) then
					FIZ_BuildUpdateList()
					FIZ_UpdateList_Update()
				end
			elseif (wordsLower[0]=="phase4c") then
				if (size>1) then
					if (wordsLower[1]=="1") then
						FIZ_SetSSOPhase4c(1)
					elseif (wordsLower[1]=="2") then
						FIZ_SetSSOPhase4c(2)
					else
						FIZ_Help()
					end
				else
					FIZ_SSOPhaseStatus()
				end

				if ( ReputationFrame:IsVisible() ) then
					ReputationFrame_Update();
				end
				if ( FIZ_ReputationDetailFrame:IsVisible()) then
					FIZ_BuildUpdateList()
					FIZ_UpdateList_Update()
				end
			elseif (wordsLower[0]=="test") then
				FIZ_Test()
			elseif (wordsLower[0]=="status") then
				FIZ_Status()
			elseif (wordsLower[0]=="help") then
				FIZ_Help()
			elseif (wordsLower[0]=="about") then
				FIZ_About()
			elseif (wordsLower[0]=="urbin") then
				FIZ_ListUrbinAddonDetails()
			else
				FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.command.." ["..FIZ_HELP_COLOUR..msgLower.."|r]", true)
				FIZ_Help()
			end
		else
			-- do nothing
		end
	end
end


-----------------------------------
-- _06_ General Helper Functions --
-----------------------------------

------------------------------------------------------------
function FIZ_Print(msg, forceDefault)
	if not (msg) then return end
	if ((FIZ_Data.ChatFrame==0) or forceDefault) then
		DEFAULT_CHAT_FRAME:AddMessage(msg)
	else
		getglobal("ChatFrame"..FIZ_Data.ChatFrame):AddMessage(msg)
	end
end

------------------------------------------------------------
function FIZ_Debug(msg)
	if not (msg) then return end
	--DEFAULT_CHAT_FRAME:AddMessage(msg)
end

------------------------------------------------------------
function FIZ_TableSize(info)
	local result = 0
	if info then
		for item in pairs(info) do result = result + 1 end
	end
	return result
end

------------------------------------------------------------
function FIZ_GetWords(str)
	local ret = {};
	local pos=0;
	local index=0
	while(true) do
		local word;
		_,pos,word=string.find(str, "^ *([^%s]+) *", pos+1);
		if(not word) then
			return ret;
		end
		ret[index]=word
		index = index+1
	end
end

------------------------------------------------------------
function FIZ_Concat(list, start, stop)
	local ret = "";

	if (start == nil) then start = 0 end
	if (stop == nil) then stop = FIZ_TableSize(list) end

	for i = start,stop do
		if list[i] then
			if (ret ~= "") then ret = ret.." " end
			ret = ret..list[i]
		end
	end
	return ret
end

------------------------------------------------------------
function FIZ_BoolToEnabled(b)
	local result = FIZ_TXT.disabled
	if b then result = FIZ_TXT.enabled end
	return result
end

------------------------------------------------------------
function FIZ_RGBToColour_perc(a, r, g, b)
	return string.format("|c%02X%02X%02X%02X", a*255, r*255, g*255, b*255)
end

-----------------------------------
-- _07_ Information
-----------------------------------
function FIZ_Help()
	FIZ_Print(" ", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.help, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz help "..FIZ_HELP_COLOUR..FIZ_TXT.helphelp, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz about "..FIZ_HELP_COLOUR..FIZ_TXT.helpabout, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz urbin|r "..FIZ_TXT.help_urbin, true);
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz status "..FIZ_HELP_COLOUR..FIZ_TXT.helpstatus, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz enable { mobs | quests | instances | items | all }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz disable { mobs | quests | instances | items | all }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz toggle { mobs | quests | instances | items | all }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz enable { missing | details | chat | suppress }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz disable { missing | details | chat | suppress }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz toggle { missing | details | chat | suppress }", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz phase { 1..4 | clear } "..FIZ_HELP_COLOUR..FIZ_TXT.helpphase, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz phase2b { 1 | 2 } "..FIZ_HELP_COLOUR..FIZ_TXT.helpsubphase, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz phase3b { 1 | 2 } "..FIZ_HELP_COLOUR..FIZ_TXT.helpsubphase, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz phase4b { 1 | 2 } "..FIZ_HELP_COLOUR..FIZ_TXT.helpsubphase, true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_TXT.usage..":|r /fz phase4c { 1 | 2 } "..FIZ_HELP_COLOUR..FIZ_TXT.helpsubphase, true)
end

------------------------------------------------------------
function FIZ_About(urbin)
	local ver = GetAddOnMetadata("Factionizer", "Version");
	local date = GetAddOnMetadata("Factionizer", "X-Date");
	local author = GetAddOnMetadata("Factionizer", "Author");
	local web = GetAddOnMetadata("Factionizer", "X-Website");

	if (author ~= nil) then
		FIZ_Print(FIZ_NAME.." "..FIZ_TXT.by.." "..FIZ_HELP_COLOUR..author.."|r", true);
	end
	if (ver ~= nil) then
		FIZ_Print("  "..FIZ_TXT.version..": "..FIZ_HELP_COLOUR..ver.."|r", true);
	end
	if (date ~= nil) then
		FIZ_Print("  "..FIZ_TXT.date..": "..FIZ_HELP_COLOUR..date.."|r", true);
	end
	if (web ~= nil) then
		FIZ_Print("  "..FIZ_TXT.web..": "..FIZ_HELP_COLOUR..web.."|r", true);
	end

	if (urbin) then
		FIZ_Print("  "..FIZ_TXT.slash..": "..FIZ_HELP_COLOUR..SLASH_FIZ2.."|r", true);
	else
		FIZ_ListUrbinAddons(FIZ_NAME)
	end
end

------------------------------------------------------------
function FIZ_Status()
	FIZ_Print(" ", true)
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.status, true)
	FIZ_Print("   "..FIZ_TXT.statMobs..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowMobs).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statQuests..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowQuests).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statInstances..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowInstances).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statItems..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowItems).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statMissing..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowMissing).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statDetails..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ExtendDetails).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statChat..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.WriteChatMessage).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statSuppress..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.SuppressOriginalChat).."|r", true)
	FIZ_Print("   "..FIZ_TXT.statPreview..": "..FIZ_HELP_COLOUR..FIZ_BoolToEnabled(FIZ_Data.ShowPreviewRep).."|r", true)
end

-----------------------------------
-- _08_ Faction map              --
-----------------------------------
function FIZ_InitFactionMap()
	if ((GetLocale() == "enGB") or
	    (GetLocale() == "enUS")) then
	    	-- Alliance
	    	FIZ_AddMapping("Darnassus", "Darnassus")
	    	FIZ_AddMapping("Gnomeregan Exiles", "Gnomeregan Exiles")
	    	FIZ_AddMapping("Ironforge", "Ironforge")
	    	FIZ_AddMapping("Stormwind", "Stormwind")
	    	FIZ_AddMapping("Exodar", "Exodar")
	    	-- Horde
	    	FIZ_AddMapping("Darkspear Trolls", "Darkspear Trolls")
	    	FIZ_AddMapping("Orgrimmar", "Orgrimmar")
	    	FIZ_AddMapping("Thunder Bluff", "Thunder Bluff")
	    	FIZ_AddMapping("Undercity", "Undercity")
	    	FIZ_AddMapping("Silvermoon", "Silvermoon")
	    	-- Alliance PvP
	    	FIZ_AddMapping("League of Arathor", "League of Arathor")
	    	FIZ_AddMapping("Silverwing Sentinels", "Silverwing Sentinels")
	    	FIZ_AddMapping("Stormpike Guard", "Stormpike Guard")
	    	-- Horde PvP
	    	FIZ_AddMapping("Defilers", "Defilers")
	    	FIZ_AddMapping("Frostwolf Clan", "Frostwolf Clan")
	    	FIZ_AddMapping("Warsong Outriders", "Warsong Outriders")
	    	-- Steamwheedle Cartel
	    	FIZ_AddMapping("Booty Bay", "Booty Bay")
	    	FIZ_AddMapping("Everlook", "Everlook")
	    	FIZ_AddMapping("Gadgetzan", "Gadgetzan")
	    	FIZ_AddMapping("Ratchet", "Ratchet")
	    	-- Outland
	    	FIZ_AddMapping("Cenarion Expedition", "Cenarion Expedition")
	    	FIZ_AddMapping("Honor Hold", "Honor Hold")
	    	FIZ_AddMapping("Kurenai", "Kurenai")
	    	FIZ_AddMapping("Mag'har", "Mag'har")
	    	FIZ_AddMapping("Ogri'la", "Ogri'la")
	    	FIZ_AddMapping("Netherwing", "Netherwing")
	    	FIZ_AddMapping("Sporeggar", "Sporeggar")
	    	FIZ_AddMapping("The Consortium", "The Consortium")
	    	FIZ_AddMapping("Thrallmar", "Thrallmar")
	    	FIZ_AddMapping("Tranquillien", "Tranquillien")
	    	-- Shattrath
	    	FIZ_AddMapping("Lower City", "Lower City")
	    	FIZ_AddMapping("Sha'tari Skyguard", "Sha'tari Skyguard")
	    	FIZ_AddMapping("The Aldor", "The Aldor")
	    	FIZ_AddMapping("The Scryers", "The Scryers")
	    	FIZ_AddMapping("The Sha'tar", "The Sha'tar")
	    	FIZ_AddMapping("Shattered Sun Offensive", "Shattered Sun Offensive")
	    	-- Raid
	    	FIZ_AddMapping("Ashtongue Deathsworn", "Ashtongue Deathsworn")
	    	FIZ_AddMapping("Brood of Nozdormu", "Brood of Nozdormu")
	    	FIZ_AddMapping("Cenarion Circle", "Cenarion Circle")
	    	FIZ_AddMapping("Hydraxian Waterlords", "Hydraxian Waterlords")
	    	FIZ_AddMapping("Scale of the Sands", "Scale of the Sands")
	    	FIZ_AddMapping("Zandalar Tribe", "Zandalar Tribe")
	    	-- Others
	    	FIZ_AddMapping("Argent Dawn", "Argent Dawn")
	    	FIZ_AddMapping("Bloodsail Buccaneers", "Bloodsail Buccaneers")
	    	FIZ_AddMapping("Darkmoon Faire", "Darkmoon Faire")
	    	FIZ_AddMapping("Gelkis Clan Centaur", "Gelkis Clan Centaur")
	    	FIZ_AddMapping("Keepers of Time", "Keepers of Time")
	    	FIZ_AddMapping("Magram Clan Centaur", "Magram Clan Centaur")
	    	FIZ_AddMapping("Ravenholdt", "Ravenholdt")
	    	FIZ_AddMapping("Shen'dralar", "Shen'dralar")
	    	FIZ_AddMapping("Syndicate", "Syndicate")
	    	FIZ_AddMapping("Thorium Brotherhood", "Thorium Brotherhood")
	    	FIZ_AddMapping("Timbermaw Hold", "Timbermaw Hold")
	    	FIZ_AddMapping("The Violet Eye", "The Violet Eye")
	    	FIZ_AddMapping("Wintersaber Trainers", "Wintersaber Trainers")

	elseif (GetLocale() == "deDE") then
		-- German localisation of factions still needs to be finished

	    	-- Alliance
	    	--FIZ_AddMapping("Darnassus", "Darnassus")
	    	FIZ_AddMapping("Gnomeregan Exiles", "Gnomeregangnome")
	    	FIZ_AddMapping("Ironforge", "Eisenschmiede")
	    	FIZ_AddMapping("Stormwind", "Sturmwind")
	    	FIZ_AddMapping("Exodar", "Die Exodar")
	    	-- Horde
	    	FIZ_AddMapping("Darkspear Trolls", "Dunkelspeertrolle")
	    	FIZ_AddMapping("Orgrimmar", "Orgrimmar")
	    	FIZ_AddMapping("Thunder Bluff", "Donnerfels")
	    	FIZ_AddMapping("Undercity", "Unterstadt")
	    	FIZ_AddMapping("Silvermoon", "Silbermond")
	    	-- Alliance PvP
	    	FIZ_AddMapping("League of Arathor", "Der Bund von Arathor")
	    	FIZ_AddMapping("Silverwing Sentinels", "Silberschwingen")
	    	FIZ_AddMapping("Stormpike Guard", "Sturmlanzengarde")
	    	-- Horde PvP
	    	FIZ_AddMapping("Defilers", "Die Entweihten")
	    	FIZ_AddMapping("Frostwolf Clan", "Frostwolfklan ")
	    	FIZ_AddMapping("Warsong Outriders", "Kriegshymnenklan ")
	    	-- Steamwheedle Cartel
	    	FIZ_AddMapping("Booty Bay", "Beutebucht")
	    	FIZ_AddMapping("Everlook", "Ewige Warte")
	    	FIZ_AddMapping("Gadgetzan", "Gadgetzan")
	    	FIZ_AddMapping("Ratchet", "Ratschet")
	    	-- Outland
	    	FIZ_AddMapping("Cenarion Expedition", "Expedition des Cenarius")
	    	FIZ_AddMapping("Honor Hold", "Ehrenfeste")
	    	FIZ_AddMapping("Kurenai", "Kurenai")
	    	FIZ_AddMapping("Mag'har", "Die Mag'har")
	    	FIZ_AddMapping("Ogri'la", "Ogri'la")
	    	FIZ_AddMapping("Netherwing", "Netherschwingen")
	    	FIZ_AddMapping("Sporeggar", "Sporeggar")
	    	FIZ_AddMapping("The Consortium", "Das Konsortium")
	    	FIZ_AddMapping("Thrallmar", "Thrallmar")
	    	FIZ_AddMapping("Tranquillien", "Tristessa")
	    	-- Shattrath
	    	FIZ_AddMapping("Lower City", "Unteres Viertel")
	    	FIZ_AddMapping("Sha'tari Skyguard", "Himmelswache der Sha'tari")
	    	FIZ_AddMapping("The Aldor", "Die Aldor")
	    	FIZ_AddMapping("The Scryers", "Die Seher")
	    	FIZ_AddMapping("The Sha'tar", "Die Sha'tar")
	    	FIZ_AddMapping("Shattered Sun Offensive", "Zerschmetterte Sonne")
	    	-- Raid
	    	FIZ_AddMapping("Ashtongue Deathsworn", "Die Todesh\195\182rigen")
	    	FIZ_AddMapping("Brood of Nozdormu", "Brut Nozdormus")
	    	FIZ_AddMapping("Cenarion Circle", "Zirkel des Cenarius")
	    	FIZ_AddMapping("Hydraxian Waterlords", "Hydraxianer")
	    	FIZ_AddMapping("Scale of the Sands", "Die W\195\164chter der Sande")
	    	FIZ_AddMapping("Zandalar Tribe", "Stamm der Zandalar")
	    	-- Others
	    	FIZ_AddMapping("Argent Dawn", "Argentumd\195\164mmerung")
	    	FIZ_AddMapping("Bloodsail Buccaneers", "Blutsegelbukaniere")
	    	FIZ_AddMapping("Darkmoon Faire", "Dunkelmond-Jahrmarkt")
	    	FIZ_AddMapping("Gelkis Clan Centaur", "Gelkisklan")
	    	FIZ_AddMapping("Keepers of Time", "H\195\188ter der Zeit")
	    	FIZ_AddMapping("Magram Clan Centaur", "Magramklan")
	    	FIZ_AddMapping("Ravenholdt", "Rabenholdt")
	    	FIZ_AddMapping("Shen'dralar", "Shen'dralar")
	    	--FIZ_AddMapping("Syndicate", "Syndicate")
	    	FIZ_AddMapping("Thorium Brotherhood", "Thoriumbruderschaft")
	    	FIZ_AddMapping("Timbermaw Hold", "Holzschlundfeste")
	    	FIZ_AddMapping("The Violet Eye", "Das violette Auge")
	    	FIZ_AddMapping("Wintersaber Trainers", "Winters\195\164blerausbilder")

	elseif (GetLocale() == "frFR") then
		-- French localisation of factions still needs to be done

	    	-- Alliance
	    	FIZ_AddMapping("Darnassus", "Darnassus")
	    	FIZ_AddMapping("Gnomeregan Exiles", "ExilÃ©s de Gonmeragan")
	    	FIZ_AddMapping("Ironforge", "Forgefer")
	    	FIZ_AddMapping("Stormwind", "Hurlevent")
	    	FIZ_AddMapping("Exodar", "Exodar")
	    	-- Horde
	    	FIZ_AddMapping("Darkspear Trolls", "Trolls Sombrelance")
	    	FIZ_AddMapping("Orgrimmar", "Orgrimmar")
	    	FIZ_AddMapping("Thunder Bluff", "Les Pitons du Tonnerre")
	    	FIZ_AddMapping("Undercity", "Fossoyeuse")
	    	FIZ_AddMapping("Silvermoon", "Lune-d'argent")
	    	-- Alliance PvP
	    	FIZ_AddMapping("League of Arathor", "La Ligue d'Arathor")
	    	FIZ_AddMapping("Silverwing Sentinels", "Sentinelles d'Aile-argent")
	    	FIZ_AddMapping("Stormpike Guard", "Guarde Foudrepique")
	    	-- Horde PvP
	    	FIZ_AddMapping("Defilers", "Les Profanateurs")
	    	FIZ_AddMapping("Frostwolf Clan", "Clan Loup-de-givre")
	    	FIZ_AddMapping("Warsong Outriders", "Voltigeurs Chanteguerre")
	    	-- Steamwheedle Cartel
	    	--FIZ_AddMapping("Booty Bay", "Beutebucht")
	    	--FIZ_AddMapping("Everlook", "Ewige Warte")
	    	FIZ_AddMapping("Gadgetzan", "Gadgetzan")
	    	--FIZ_AddMapping("Ratchet", "Ratschet ")
	    	-- Outland
	    	FIZ_AddMapping("Cenarion Expedition", "ExpÃ©dition cÃ©narienne")
	    	--FIZ_AddMapping("Honor Hold", "Ehrenfeste")
	    	FIZ_AddMapping("Kurenai", "KurenaÃ¯")
	    	FIZ_AddMapping("Mag'har", "Mag'har")
	    	--FIZ_AddMapping("Ogri'la", "Ogri'la")
	    	--FIZ_AddMapping("Netherwing", "Netherschwingen")
	    	FIZ_AddMapping("Sporeggar", "Sporeggar")
	    	FIZ_AddMapping("The Consortium", "Le Consortium")
	    	--FIZ_AddMapping("Thrallmar", "Thrallmar")
	    	FIZ_AddMapping("Tranquillien", "Tranquillien")
	    	-- Shattrath
	    	FIZ_AddMapping("Lower City", "Ville basse")
	    	--FIZ_AddMapping("Sha'tari Skyguard", "Himmelswache der Sha'tari")
	    	FIZ_AddMapping("The Aldor", "L'Aldor")
	    	FIZ_AddMapping("The Scryers", "Les Clairvoyants")
	    	FIZ_AddMapping("The Sha'tar", "Les Sha'tar")
	    	--FIZ_AddMapping("Shattered Sun Offensive", "Shattered Sun Offensive")
	    	-- Raid
	    	--FIZ_AddMapping("Ashtongue Deathsworn", "Die Todeshörigen")
	    	--FIZ_AddMapping("Brood of Nozdormu", "Brut Nozdormus")
	    	FIZ_AddMapping("Cenarion Circle", "Cercle cÃ©narien")
	    	--FIZ_AddMapping("Hydraxian Waterlords", "Hydraxianer")
	    	--FIZ_AddMapping("Scale of the Sands", "Die Wächter der Sande")
	    	FIZ_AddMapping("Zandalar Tribe", "Tribu Zandalar")
	    	-- Others
	    	FIZ_AddMapping("Argent Dawn", "Aube d'argent")
	    	--FIZ_AddMapping("Bloodsail Buccaneers", "Blutsegelbukaniere")
	    	FIZ_AddMapping("Darkmoon Faire", "Foire de Sombrelune")
	    	--FIZ_AddMapping("Gelkis Clan Centaur", "Gelkisklan")
	    	--FIZ_AddMapping("Keepers of Time", "Hüter der Zeit")
	    	--FIZ_AddMapping("Magram Clan Centaur", "Magramklan")
	    	--FIZ_AddMapping("Ravenholdt", "Rabenholdt")
	    	--FIZ_AddMapping("Shen'dralar", "Shen'dralar")
	    	--FIZ_AddMapping("Syndicate", "Syndicate")
	    	FIZ_AddMapping("Thorium Brotherhood", "ConfrÃ©rie du Thorium")
	    	FIZ_AddMapping("Timbermaw Hold", "Les Grumegueules")
	    	--FIZ_AddMapping("The Violet Eye", "Das violette Auge")
	    	--FIZ_AddMapping("Wintersaber Trainers", "Wintersäblerausbilder")

	elseif (GetLocale() == "koKR") then
		-- Korean localisation of factions still needs to be done
	elseif (GetLocale() == "zhCN") then
		-- Chinese (trad) localisation of factions still needs to be done
	elseif (GetLocale() == "zhTW") then
		-- Chinese (simpl) localisation of factions still needs to be done
	elseif (GetLocale() == "ruRU") then
		-- Russian localisation of factions still needs to be done
	elseif (GetLocale() == "esES") then
		-- Spanish localisation of factions still needs to be done
	end
end

function FIZ_AddMapping(english, localised)
	if (not FIZ_FactionMapping) then
		FIZ_FactionMapping = {}
	end
	FIZ_FactionMapping[string.lower(localised)] = string.lower(english)
end

-----------------------------------
-- _09_ Faction gains            --
-----------------------------------
function FIZ_InitFactionGains()
	--if (GetLocale() == "deDE") then
	--elseif (GetLocale() == "frFR") then
	--elseif (GetLocale() == "esES") then
	--elseif (GetLocale() == "ruRU") then
	--elseif (GetLocale() == "koKR") then
	--elseif (GetLocale() == "zhCN") then
	--elseif (GetLocale() == "zhW") then
	--else	-- default for enGB, enUS and any case not listed above
	--end
	if (FIZ_IsAlliance) then
		-- --- Alliance ---
		if (GetLocale() == "deDE") then
			-- Darnassus
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Darnassus", 4, 8, "[55] Morgenkorn nach Darnassus", 75, {["Morgenkorn"]=10})
			FIZ_AddQuest("Darnassus", 4, 8, "[55] Morgenkorn f\195\188r die Mondfederfeste", 25, {["Morgenkorn"]=5})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Allianz"]=10})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Allianz"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ein au\195\159ergew\195\182hnliches Ei", 10, {["Au\195\159ergew\195\182hnliches Ei"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ein gutes Ei", 10, {["Gutes Ei"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ein gew\195\182hnliches Ei", 10, {["Gew\195\182hnliches Ei"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ein schlechtes Ei", 10, {["Schlechtes Ei"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Exodar
			FIZ_AddQuest("Exodar", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Allianz"]=10})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Allianz"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Exodar", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Gnomeregan Exiles
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Allianz"]=10})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Allianz"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Stormwind
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Stormwind", 4, 8, "[40] The Lost Supplies", 25, {["Lost Supplies"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Allianz"]=10})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Allianz"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Ironforge
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Allianz"]=10})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Allianz"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
		else
			-- Darnassus
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Darnassus", 4, 8, "[55] Morrowgrain to Darnassus", 75, {["Morrowgrain"]=10})
			FIZ_AddQuest("Darnassus", 4, 8, "[55] Morrowgrain to Feathermoon Stronghold", 25, {["Morrowgrain"]=5})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ten Commendation Signets", 150, {["Alliance Commendation Signet"]=10})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] One Commendation Signet", 5, {["Alliance Commendation Signet"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] An Extraordinary Egg", 10, {["Extraordinary Egg"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] A Fine Egg", 10, {["Fine Egg"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] An Ordinary Egg", 10, {["Ordinary Egg"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] A Bad Egg", 10, {["Bad Egg"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Crystal Cluster", 18.75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ivus The Forest Lord", 2.5, {["Storm Crystal"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Call of Air: Ichman's Fleet", 2.5, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Call of Air: Slidore's Fleet", 2.5, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Call of Air: Vipore's Fleet", 2.5, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Darnassus", 4, 8, "[60] Ram Riding Harnesses", 2.5, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Darnassus", 4, 8, "[60] More Armor Scraps", 2.5, {["Armor Scraps"]=20})
			-- Exodar
			FIZ_AddQuest("Exodar", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ten Commendation Signets", 150, {["Alliance Commendation Signet"]=10})
			FIZ_AddQuest("Exodar", 4, 8, "[60] One Commendation Signet", 5, {["Alliance Commendation Signet"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Crystal Cluster", 18.75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ivus The Forest Lord", 2.5, {["Storm Crystal"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Call of Air: Ichman's Fleet", 2.5, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Call of Air: Slidore's Fleet", 2.5, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Call of Air: Vipore's Fleet", 2.5, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Exodar", 4, 8, "[60] Ram Riding Harnesses", 2.5, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Exodar", 4, 8, "[60] More Armor Scraps", 2.5, {["Armor Scraps"]=20})
			-- Gnomeregan Exiles
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ten Commendation Signets", 150, {["Alliance Commendation Signet"]=10})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] One Commendation Signet", 5, {["Alliance Commendation Signet"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Crystal Cluster", 18.75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ivus The Forest Lord", 2.5, {["Storm Crystal"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Call of Air: Ichman's Fleet", 2.5, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Call of Air: Slidore's Fleet", 2.5, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Call of Air: Vipore's Fleet", 2.5, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] Ram Riding Harnesses", 2.5, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Gnomeregan Exiles", 4, 8, "[60] More Armor Scraps", 2.5, {["Armor Scraps"]=20})
			-- Stormwind
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Stormwind", 4, 8, "[40] The Lost Supplies", 25, {["Lost Supplies"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ten Commendation Signets", 150, {["Alliance Commendation Signet"]=10})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] One Commendation Signet", 5, {["Alliance Commendation Signet"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Crystal Cluster", 18.75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ivus The Forest Lord", 2.5, {["Storm Crystal"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Call of Air: Ichman's Fleet", 2.5, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Call of Air: Slidore's Fleet", 2.5, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Call of Air: Vipore's Fleet", 2.5, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Stormwind", 4, 8, "[60] Ram Riding Harnesses", 2.5, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Stormwind", 4, 8, "[60] More Armor Scraps", 2.5, {["Armor Scraps"]=20})
			-- Ironforge
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ten Commendation Signets", 150, {["Alliance Commendation Signet"]=10})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] One Commendation Signet", 5, {["Alliance Commendation Signet"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Crystal Cluster", 75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ivus The Forest Lord", 10, {["Storm Crystal"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Call of Air: Vipore's Fleet", 10, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Call of Air: Slidore's Fleet", 10, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Call of Air: Ichman's Fleet", 10, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Empty Stables", 10)
			FIZ_AddQuest("Ironforge", 4, 8, "[60] Ram Riding Harnesses", 10, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Ironforge", 4, 8, "[60] More Armor Scraps", 10, {["Armor Scraps"]=20})
		end

		if (FIZ_Realm == "Dun Morogh" and FIZ_Player == "Greeta") then
			FIZ_AddInstance("Ironforge", 4, 8, "Deadly Hallows", 2000, false)
			FIZ_AddMob("Ironforge", 4, 8, "Prickly Pear", 45, "Fruit Bowl")
			FIZ_AddItems("Ironforge", 4, 8, 150, {["Item A"]=2, ["Item B"]=1, ["Item C"]= 2})
		end

		-- --- Alliance PvP ---
		if (GetLocale() == "deDE") then
			-- Silverwing Sentinels
			FIZ_AddInstance("Silverwing Sentinels", 4, 8, "Kriegshymnenschlucht Schlachtfeld Fahne gekapert", 35, false)
			FIZ_AddInstance("Silverwing Sentinels", 4, 8, "Kriegshymnenschlucht Schlachtfeld Sieg (3 Fahnen)", 105, false)
			-- Stormpike Guard
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Haufenweise Kristalle", 18.75, {["Sturmkristall"]=5})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ivus der Waldf\195\188rst", 2.5, {["Sturmkristall"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ruf der L\195\188fte - Ichmans Luftflotte", 2.5, {["Medaille des Kommandanten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ruf der L\195\188fte - Slidores Luftflotte", 2.5, {["Medaille des Soldaten der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ruf der L\195\188fte - Vipores Luftflotte", 2.5, {["Medaille des Leutnants der Frostw\195\182lfe"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Widderzaumzeug", 2.5, {["Frostwolfbalg"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Mehr R\195\188stungsfetzen", 2.5, {["R\195\188stungsfetzen"]=20})
			-- The League of Arathor
			FIZ_AddInstance("The League of Arathor", 4, 8, "Arathibecken 200 Resourcen gesammelt", 10, false)
			FIZ_AddInstance("The League of Arathor", 4, 8, "Arathibecken Sieg (2000 Resourcen)", 100, false)
		else
			-- Silverwing Sentinels
			FIZ_AddInstance("Silverwing Sentinels", 4, 8, "Warsong BG Flag Capture", 35, false)
			FIZ_AddInstance("Silverwing Sentinels", 4, 8, "Warsong BG Win (3 Capturese)", 105, false)
			-- Stormpike Guard
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Crystal Cluster", 18.75, {["Storm Crystal"]=5})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ivus The Forest Lord", 2.5, {["Storm Crystal"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Call of Air: Ichman's Fleet", 2.5, {["Frostwolf Commander's Medal"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Call of Air: Slidore's Fleet", 2.5, {["Frostwolf Soldier's Medal"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Call of Air: Vipore's Fleet", 2.5, {["Frostwolf Lieutenant's Medal"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] Ram Riding Harnesses", 2.5, {["Frostwolf Hide"]=1})
			FIZ_AddQuest("Stormpike Guard", 4, 8, "[60] More Armor Scraps", 2.5, {["Armor Scraps"]=20})
			-- The League of Arathor
			FIZ_AddInstance("The League of Arathor", 4, 8, "Arathi Basin collect 200 Resources", 10, false)
			FIZ_AddInstance("The League of Arathor", 4, 8, "Arathi Basin Win (2000 Resources)", 100, false)
		end
	end

	if (FIZ_IsHorde) then
		-- --- Horde ---
		if (GetLocale() == "deDE") then
			-- Darkspear Trolls
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Horde"]=10})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Horde"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Eine Gallone Blut", 18.75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Lokholar der Eislord", 2.5, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 2.5, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 2.5, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 2.5, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Widderledernes Zaumzeug", 2.5, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Mehr Beute!", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Orgrimmar
			FIZ_AddQuest("Orgrimmar", 4, 8, "[24] Chens leeres F\195\164sschen", 75, {["Blitzschlagdr\195\188se"]=5,["Donnerfalkenspeicheldr\195\188se"]=1, ["Kodoleber"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Horde"]=10})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Horde"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Eine Gallone Blut", 75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Lokholar der Eislord", 10, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 10, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 10, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 10, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Verwaiste St\195\164lle", 10)
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Widderledernes Zaumzeug", 10, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Mehr Beute!", 10, {["R\195\188stungsfetzen"]=20})
			-- Silvermoon City
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Horde"]=10})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Horde"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Eine Gallone Blut", 18.75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Lokholar der Eislord", 2.5, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 2.5, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 2.5, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 2.5, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Widderledernes Zaumzeug", 2.5, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Mehr Beute!", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Thunder Bluff
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[55] Morrowgrain to Thunder Bluff", 75, {["Morrowgrain"]=10})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Horde"]=10})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Horde"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ein au\195\159ergew\195\182hnliches Ei", 10, {["Au\195\159ergew\195\182hnliches Ei"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ein gutes Ei", 10, {["Gutes Ei"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ein gew\195\182hnliches Ei", 10, {["Gew\195\182hnliches Ei"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ein schlechtes Ei", 10, {["Schlechtes Ei"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Eine Gallone Blut", 18.75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Lokholar der Eislord", 2.5, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 2.5, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 2.5, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 2.5, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Widderledernes Zaumzeug", 2.5, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Mehr Beute!", 2.5, {["R\195\188stungsfetzen"]=20})
			-- Undercity
			FIZ_AddQuest("Undercity", 4, 8, "[60] Noch mehr Runenstoff", 75, {["Runenstoff"] = 20})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Zehn Belobigungsabzeichen", 150, {["Belobigungsabzeichen der Horde"]=10})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ein Belobigungsabzeichen", 5, {["Belobigungsabzeichen der Horde"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Eine Gallone Blut", 18.75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Lokholar der Eislord", 2.5, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 2.5, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 2.5, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 2.5, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Undercity", 4, 8, "[60] Widderledernes Zaumzeug", 2.5, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Mehr Beute!", 2.5, {["R\195\188stungsfetzen"]=20})
		else
			-- Darkspear Trolls
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ten Commendation Signets", 150, {["Horde Commendation Signet"]=10})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] One Commendation Signet", 5, {["Horde Commendation Signet"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] A Gallon of Blood", 18.75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Lokholar the Ice Lord", 2.5, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Call of Air: Guse's Fleet", 2.5, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Call of Air: Jeztor's Fleet", 2.5, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Call of Air: Mulverick's Fleet", 2.5, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] Ram Hide Harnesses", 2.5, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Darkspear Trolls", 4, 8, "[60] More Booty!", 2.5, {["Armor Scraps"]=20})
			-- Orgrimmar
			FIZ_AddQuest("Orgrimmar", 4, 8, "[24] Chen's Empty Keg", 75, {["Lightning Gland"]=5,["Thunderhawk Saliva Gland"]=1, ["Kodo Liver"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ten Commendation Signets", 150, {["Horde Commendation Signet"]=10})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] One Commendation Signet", 5, {["Horde Commendation Signet"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] A Gallon of Blood", 75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Lokholar the Ice Lord", 10, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Call of Air: Guse's Fleet", 10, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Call of Air: Jeztor's Fleet", 10, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Call of Air: Mulverick's Fleet", 10, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Empty Stables", 10)
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] Ram Hide Harnesses", 10, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Orgrimmar", 4, 8, "[60] More Booty!", 10, {["Armor Scraps"]=20})
			-- Silvermoon City
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ten Commendation Signets", 150, {["Horde Commendation Signet"]=10})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] One Commendation Signet", 5, {["Horde Commendation Signet"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] A Gallon of Blood", 18.75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Lokholar the Ice Lord", 2.5, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Call of Air: Guse's Fleet", 2.5, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Call of Air: Jeztor's Fleet", 2.5, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Call of Air: Mulverick's Fleet", 2.5, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] Ram Hide Harnesses", 2.5, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Silvermoon City", 4, 8, "[60] More Booty!", 2.5, {["Armor Scraps"]=20})
			-- Thunder Bluff
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[55] Morrowgrain to Thunder Bluff", 75, {["Morrowgrain"]=10})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ten Commendation Signets", 150, {["Horde Commendation Signet"]=10})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] One Commendation Signet", 5, {["Horde Commendation Signet"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] An Extraordinary Egg", 10, {["Extraordinary Egg"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] A Fine Egg", 10, {["Fine Egg"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] An Ordinary Egg", 10, {["Ordinary Egg"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] A Bad Egg", 10, {["Bad Egg"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] A Gallon of Blood", 18.75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Lokholar the Ice Lord", 2.5, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Call of Air: Guse's Fleet", 2.5, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Call of Air: Jeztor's Fleet", 2.5, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Call of Air: Mulverick's Fleet", 2.5, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] Ram Hide Harnesses", 2.5, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Thunder Bluff", 4, 8, "[60] More Booty!", 2.5, {["Armor Scraps"]=20})
			-- Undercity
			FIZ_AddQuest("Undercity", 4, 8, "[60] Additional Runecloth", 75, {["Runecloth"] = 20})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ten Commendation Signets", 150, {["Horde Commendation Signet"]=10})
			FIZ_AddQuest("Undercity", 4, 8, "[60] One Commendation Signet", 5, {["Horde Commendation Signet"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] A Gallon of Blood", 18.75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Lokholar the Ice Lord", 2.5, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Call of Air: Guse's Fleet", 2.5, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Call of Air: Jeztor's Fleet", 2.5, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Call of Air: Mulverick's Fleet", 2.5, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Undercity", 4, 8, "[60] Ram Hide Harnesses", 2.5, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Undercity", 4, 8, "[60] More Booty!", 2.5, {["Armor Scraps"]=20})
		end

		-- --- Horde PvP ---
		if (GetLocale() == "deDE") then
			-- Frostwolf Clan
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Eine Gallone Blut", 18.75, {["Blut eines Soldaten der Sturmlanzen"]=5})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Lokholar der Eislord", 2.5, {["Blut eines Soldaten der Sturmlanzen"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Ruf der L\195\188fte - Guses Luftflotte", 2.5, {["Fleisch eines Sturmlanzensoldaten"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Ruf der L\195\188fte - Jeztors Luftflotte", 2.5, {["Fleisch eines Sturmlanzenleutnants"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Ruf der L\195\188fte - Mulvericks Luftflotte", 2.5, {["Fleisch eines Sturmlanzenkommandanten"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Verwaiste St\195\164lle", 2.5)
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Widderledernes Zaumzeug", 2.5, {["Alteracwidderbalg"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Mehr Beute!", 2.5, {["R\195\188stungsfetzen"]=20})
			-- The Defilers
			FIZ_AddInstance("The Defilers", 4, 8, "Arathibecken 200 Resourcen gesammelt", 10, false)
			FIZ_AddInstance("The Defilers", 4, 8, "Arathibecken Sieg (2000 Resourcen)", 100, false)
			-- Warsong Outriders
			FIZ_AddInstance("Warsong Outriders", 4, 8, "Kriegshymnenschlucht Schlachtfeld Fahne gekapert", 35, false)
			FIZ_AddInstance("Warsong Outriders", 4, 8, "Kriegshymnenschlucht Schlachtfeld Sieg (3 Fahnen)", 105, false)
		else
			-- Frostwolf Clan
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] A Gallon of Blood", 18.75, {["Stormpike Soldier's Blood"]=5})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Lokholar the Ice Lord", 2.5, {["Stormpike Soldier's Blood"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Call of Air: Guse's Fleet", 2.5, {["Stormpike Soldier Flesh"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Call of Air: Jeztor's Fleet", 2.5, {["Stormpike Lieutenant Flesh"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Call of Air: Mulverick's Fleet", 2.5, {["Stormpike Commander Flesh"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Empty Stables", 2.5)
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] Ram Hide Harnesses", 2.5, {["Alterac Ram Hide"]=1})
			FIZ_AddQuest("Frostwolf Clan", 4, 8, "[60] More Booty!", 2.5, {["Armor Scraps"]=20})
			-- The Defilers
			FIZ_AddInstance("The Defilers", 4, 8, "Arathi Basin collect 200 Resources", 10, false)
			FIZ_AddInstance("The Defilers", 4, 8, "Arathi Basin Win (2000 Resources)", 100, false)
			-- Warsong Outriders
			FIZ_AddInstance("Warsong Outriders", 4, 8, "Warsong BG Flag Capture", 35, false)
			FIZ_AddInstance("Warsong Outriders", 4, 8, "Warsong BG Win (3 Capturese)", 105, false)
		end
	end

	-- --- Others ---
	if (GetLocale() == "deDE") then
	    	-- Argent Dawn
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Gei\195\159elsteine des Dieners", 50, {["Gei\195\159elstein des Dieners"] = 20})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Gei\195\159elsteine des Eindringlings", 50, {["Gei\195\159elstein des Eindringlings"] = 10})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Gei\195\159elsteine des Verderbers", 50, {["Gei\195\159elstein des Verderbers"] = 1})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Ehrenmarke benutzen", 100, {["Ehrenmarke der Argentumd\195\164mmerung"] = 1})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Insignie der D\195\164mmerung", 20)
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Insignie des Kreuzzugs", 20)
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Kessel-Quests", 50)
		FIZ_AddMob("Argent Dawn", 4, 5, "Non-Eliten in den Pestl\195\164ndern", 10)
		FIZ_AddMob("Argent Dawn", 4, 6, "Eliten & Schattenmagier in den Pestl\195\164ndern", 10)
		FIZ_AddMob("Argent Dawn", 4, 6, "Kessellorde", 30)
		FIZ_AddMob("Argent Dawn", 4, 7, "Stratholme & Scholomance Trash", 10)
		FIZ_AddMob("Argent Dawn", 4, 8, "Stratholme & Scholomance Bosse", 50)
		FIZ_AddMob("Argent Dawn", 4, 8, "Baron Totenschwur (Stratholme)", 100)
		FIZ_AddMob("Argent Dawn", 4, 8, "Ras Frostraunen (Scholomance)", 100)
		FIZ_AddInstance("Argent Dawn", 4, 8, "Straholme 45 Minuten Run", 850, false)
		FIZ_AddInstance("Argent Dawn", 4, 8, "Scholomance", 1200, false)
	    	-- Bloodsail Buccaneers
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Haudrauf von Beutebucht & Eliten", 25, "Beutebucht")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Einge Mobs in Beutebucht", 5, "Beutebucht")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Die meisten Mobs in Beutebucht", 1, "Beutebucht")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Die meisten Mobs in Faldirs Bucht", 5, "Arathi Highlands, Faldirs Bucht")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Jazzrik & Riggelfuzz", 1, "\195\150dland")
	    	-- Darkmoon Faire
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Kleine pelzige Tatzen", 250, {["Kleine pelzige Tatze"] = 5}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Zerrissene B\195\164renpelze", 250, {["Zerrissener B\195\164renpelz"] = 5}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Weiche buschige Schw\195\164nze", 250, {["Weicher buschiger Schwanz"] = 5}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Farbenpr\195\164chtige Federb\195\188sche", 250, {["Farbenpr\195\164chtiger Federbusch"] = 5}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "B\195\182se Fledermausaugen", 250, {["B\195\182ses Fledermausauge"] = 10})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Leuchtendes Skorpidblut", 250, {["Leuchtendes Skorpidblut"] = 10})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Grober Gewichtsstein", 250, {["Grober Gewichtsstein"] = 10}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Schwerer Schleifstein", 250, {["Schwerer Schleifstein"] = 7}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Gr\195\188ne Eisenarmschienen", 250, {["Gr\195\188ne Eisenarmschienen"] = 3}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Gro\195\159er schwarzer Streitkolben", 250, {["Gro\195\159er schwarzer Streitkolben"] = 1}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Verdichteter Schleifsteine", 250, {["Verdichteter Schleifstein"] = 8})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Kupfermodulator", 250, {["Kupfermodulator"] = 5}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Surrendes bronzenes Dingsda", 250, {["Surrendes bronzenes Dingsda"] = 7}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Gr\195\188nes Feuerwerk", 250, {["Gr\195\188nes Feuerwerk"] = 36}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Mechanische Repariersets", 250, {["Mechanisches Reparierset"] = 6}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Thoriumapparat", 250, {["Thoriumapparat"] = 6})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Gepr\195\164gte Lederstiefel", 250, {["Gepr\195\164gte Lederstiefel"] = 3}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Gekr\195\164ftigte Lederr\195\188stung", 250, {["Gekr\195\164ftigte Lederr\195\188stung"] = 3}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Barbarischer Harnisch", 250, {["Barbarischer Harnisch"] = 3}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Schildkr\195\182tenschuppengamaschen", 250, {["Schildkr\195\182tenschuppengamaschen"] = 1}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Unverw\195\188stliches R\195\188stungsset", 250, {["Unverw\195\188stliches R\195\188stungsset"] = 8})
	    	-- Gelkis Clan Centaur
	    	FIZ_AddMob("Gelkis Clan Centaur", 4, 8, "Magramklan Zentauren", 20)
	    	-- Magram Clan Centaur
	    	FIZ_AddMob("Magram Clan Centaur", 4, 8, "Gelkisklan Zentauren", 20)
	    	-- Keepers of Time
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Das alte H\195\188gelland (HdZ1)", 900, false)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Das alte H\195\188gelland (HdZ1)", 900, true)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Schwarzer Morast (HdZ2)", 1110, false)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Schwarzer Morast (HdZ2)", 1725, true)
	    	-- Ravenholdt
	    	FIZ_AddQuest("Ravenholdt", 4, 4, "[24] Syndikatsembleme", 250, {["Emblem des Syndikats"] = 1})
	    	FIZ_AddQuest("Ravenholdt", 4, 8, "[50] Plunderkisten ben\195\182tigt", 75, {["Schwere Plunderkiste"] = 5})
	    	-- Shen'dralar
	    	FIZ_AddQuest("Shen'dralar", 4, 8, "Buchb\195\164nde in D\195\188sterbruch", 500)
	    	FIZ_AddQuest("Shen'dralar", 4, 8, "Klassenb\195\188cher in D\195\188sterbruch", 500)
	    	-- Syndicate
	    	FIZ_AddMob("Syndicate", 4, 8, "Myrokos Leisetritt", 5)
	    	FIZ_AddMob("Syndicate", 4, 8, "Winstone Wolf", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Lord Jorach Rabenholdt", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Fahrad", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Zan Messerritzel", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Smudge Donnerholz", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Simone Cantrell", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Meister Kang", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Carlo Aurelius", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Rabenholdtauftragsm\195\182rder", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Rabenholdtwache", 1)
	    	-- Thorium Brotherhood
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Nachschub an feurigem Fluxus: K\195\182nigsblut", 25, {["Incendosaurierschuppe"]=2, ["Kohle"]=1, ["K\195\182nigsblut"]= 2}, FIZ_LIMIT_TYPE_HERB)
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Nachschub an feurigem Fluxus: Eisen", 25, {["Incendosaurierschuppe"]=2, ["Kohle"]=1, ["Eisenbarren"] = 2}, FIZ_LIMIT_TYPE_MINE)
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Nachschub an feurigem Fluxus: Schweres Leder", 25, {["Incendosaurierschuppe"]=2, ["Kohle"]=1, ["Schweres Leder"] = 2}, FIZ_LIMIT_TYPE_SKIN)
	    	FIZ_AddQuest("Thorium Brotherhood", 5, 5, "[45] Erlangte Anerkennung", 25, {["Dunkeleisenr\195\188ckst\195\164nde"] = 4})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Gunst der Bruderschaft, Dunkeleisenerz", 75, {["Dunkeleisenerz"] = 10})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Gunst der Bruderschaft, Kernleder", 350, {["Kernleder"] = 2})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Gunst der Bruderschaft, Blut des Berges", 500, {["Blut des Berges"] = 1})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Gunst der Bruderschaft, Feuerkern", 500, {["Feuerkern"] = 1})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Gunst der Bruderschaft, Lavakern", 500, {["Lavakern"] = 1})
	    	-- Timbermaw Hold (rep divided by a factor of 5 if grey -> how to include this?) -- how to add limits
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[55] Federn f\195\188r Nafien", 150, {["Kopfputzfeder der Totenwaldfelle"] = 5})
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[55] Federn f\195\188r Grazle", 150, {["Kopfputzfeder der Totenwaldfelle"] = 5})
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[56] Perlen f\195\188r Salfa", 150, {["Geisterperlen der Winterfelle"] = 5})
	    	FIZ_AddMob("Timbermaw Hold", 2, 6, "R\195\164cher, H\195\182hlenbeh\195\188ter, Schamane, G\195\164rtner, Pfadfinder & Krieger der Totenwaldfelle", 10)
	    	FIZ_AddMob("Timbermaw Hold", 2, 6, "L\195\164ufer, H\195\182hlenbeh\195\188ter, Schamane, Totemiker, Pfadfinder & Ursa der Winterfelle", 10)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "H\195\164uptling Blutmagen", 30)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Oberanf\195\188hrer Ror", 30)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Wutpranke (Rar)", 50)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Grizzel Schneepfote (Rar)", 50)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Oberh\195\164uptling der Winterfelle", 50)
	    	-- Wintersaber Trainers
	    	FIZ_AddQuest("Wintersaber Trainers", 4, 8, "[60] Frosts\195\164blerverpflegung", 250)
	    	FIZ_AddQuest("Wintersaber Trainers", 4, 8, "[60] Eindringlinge der Winterfelle", 250)
	    	FIZ_AddQuest("Wintersaber Trainers", 6, 8, "[60] Tobende Riesen", 350)
	else
	    	-- Argent Dawn
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Minion's Scourgestone", 50, {["Minion's Scourgestone"] = 20})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Invader's Scourgestones", 50, {["Invader's Scourgestone"] = 10})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "[55] Corruptor's Scourgestone", 50, {["Corruptor's Scourgestone"] = 1})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Using Valor Token", 100, {["Argent Dawn Valor Token"] = 1})
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Insigna of the Dawn", 20)
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Insigna of the Crusade", 20)
	    	FIZ_AddQuest("Argent Dawn", 4, 8, "Cauldron Quests", 50)
		FIZ_AddMob("Argent Dawn", 4, 5, "Non-Elites in Plaguelands", 10)
		FIZ_AddMob("Argent Dawn", 4, 6, "Elites & Shadowmages in Plaguelands", 10)
		FIZ_AddMob("Argent Dawn", 4, 6, "Cauldron Lords", 30)
		FIZ_AddMob("Argent Dawn", 4, 7, "Stratholme & Scholomance Trash", 10)
		FIZ_AddMob("Argent Dawn", 4, 8, "Stratholme & Scholomance Bosses", 50)
		FIZ_AddMob("Argent Dawn", 4, 8, "Baron Rivendare (Stratholme)", 100)
		FIZ_AddMob("Argent Dawn", 4, 8, "Ras Frostwhisper (Scholomance)", 100)
		FIZ_AddInstance("Argent Dawn", 4, 8, "Straholme 45 Minute Run", 850, false)
		FIZ_AddInstance("Argent Dawn", 4, 8, "Scholomance", 1200, false)
	    	-- Bloodsail Buccaneers
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Booty Bay Bruiser & Elite", 25, "Booty Bay")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Some Booty Bay mobs", 5, "Booty Bay")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Most Booty Bay mobs", 1, "Booty Bay")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Most Faldir's Cove mobs", 5, "Arathi Highlands, Faldir's Cove")
	    	FIZ_AddMob("Bloodsail Buccaneers", 4, 8, "Jazzrik & Rigglefuzz", 1, "Badlands")
	    	-- Darkmoon Faire
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Small Furry Paws", 250, {["Small Furry Paw"] = 5}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Torn Bear Pelts", 250, {["Torn Bear Pelt"] = 5}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Soft Bushy Tails", 250, {["Soft Bushy Tail"] = 5}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Vibrant Plumes", 250, {["Vibrant Plume"] = 5}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Evil Bat Eyes", 250, {["Evil Bat Eye"] = 10})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Glowing Scorpid Blood", 250, {["Glowing Scorpid Blood"] = 10})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Coarse Weightstones", 250, {["Coarse Weightstone"] = 10}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Heavy Grinding Stone", 250, {["Heavy Grinding Stone"] = 7}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Green Iron Bracers", 250, {["Green Iron Bracers"] = 3}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Big Black Mace", 250, {["Big Black Mace"] = 1}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Dense Grinding Stone", 250, {["Dense Grinding Stone"] = 8})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Copper Modulator", 250, {["Copper Modulator"] = 5}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Whirring Bronze Gizmo", 250, {["Whirring Bronze Gizmo"] = 7}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Green Firework", 250, {["Green Firework"] = 36}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Mechanical Repair Kits", 250, {["Mechanical Repair Kit"] = 6}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Thorium Widget", 250, {["Thorium Widget"] = 6})
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Embossed Leather Boots", 250, {["Embossed Leather Boots"] = 3}, 500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Toughened Leather Armor", 250, {["Toughened Leather Armor"] = 3}, 1100)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Barbaric Harness", 250, {["Barbaric Harness"] = 3}, 1700)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 4, "Turtle Scale Leggings", 250, {["Turtle Scale Leggings"] = 1}, 2500)
	    	FIZ_AddQuest("Darkmoon Faire", 4, 5, "Rugged Armor Kit", 250, {["Rugged Armor Kit"] = 8})
	    	-- Gelkis Clan Centaur
	    	FIZ_AddMob("Gelkis Clan Centaur", 4, 8, "Magram Clan Centaurs", 20)
	    	-- Magram Clan Centaur
	    	FIZ_AddMob("Magram Clan Centaur", 4, 8, "Gelkis Clan Centaurs", 20)
	    	-- Keepers of Time
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Old Hillsbarad (CoT1)", 900, false)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Old Hillsbarad (CoT1)", 900, true)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Black Morass (CoT2)", 1110, false)
	    	FIZ_AddInstance("Keepers of Time", 4, 8, "Black Morass (CoT2)", 1725, true)
	    	-- Ravenholdt
	    	FIZ_AddQuest("Ravenholdt", 4, 4, "[24] Syndicate Emblems", 250, {["Syndicate Emblem"] = 1})
	    	FIZ_AddQuest("Ravenholdt", 4, 8, "[50] Junkboxes Needed", 75, {["Heavy Junkbox"] = 5})
	    	-- Shen'dralar
	    	FIZ_AddQuest("Shen'dralar", 4, 8, "Librams in Dire Maul", 500)
	    	FIZ_AddQuest("Shen'dralar", 4, 8, "Class Books in Dire Maul", 500)
	    	-- Syndicate
	    	FIZ_AddMob("Syndicate", 4, 8, "Myrokos Silentform", 5)
	    	FIZ_AddMob("Syndicate", 4, 8, "Winstone Wolfe", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Lord Jorach Ravenholdt", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Fahrad", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Zan Shivsproket", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Smudge Thunderwood", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Simone Cantrell", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Master Kang", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Carlo Aurelius", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Ravenholdt Assassin", 1)
	    	FIZ_AddMob("Syndicate", 4, 8, "Ravenholdt Guard", 1)
	    	-- Thorium Brotherhood
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Restoring Fiery Flux via Kingsblood", 25, {["Incendosaur Scales"]=2, ["Coal"]=1, ["Kingsblood"]= 2}, FIZ_LIMIT_TYPE_HERB)
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Restoring Fiery Flux via Iron", 25, {["Incendosaur Scales"]=2, ["Coal"]=1, ["Iron Bar"] = 2}, FIZ_LIMIT_TYPE_MINE)
	    	FIZ_AddQuest("Thorium Brotherhood", 4, 4, "[45] Restoring Fiery Flux via ", 25, {["Incendosaur Scales"]=2, ["Coal"]=1, ["Heavy Leather"] = 2}, FIZ_LIMIT_TYPE_SKIN)
	    	FIZ_AddQuest("Thorium Brotherhood", 5, 5, "[45] Gaining Acceptance", 25, {["Dark Iron Residue"] = 4})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Favor Amongst the Brotherhood, Dark Iron Ore", 75, {["Dark Iron Ore"] = 10})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Favor Amongst the Brotherhood, Core Leather", 350, {["Core Leather"] = 2})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Favor Amongst the Brotherhood, Blood of the Mountain", 500, {["Blood of the Mountain"] = 1})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Favor Amongst the Brotherhood, Fiery Core", 500, {["Fiery Core"] = 1})
	    	FIZ_AddQuest("Thorium Brotherhood", 6, 8, "[60] Favor Amongst the Brotherhood, Lava Core", 500, {["Lava Core"] = 1})
	    	-- Timbermaw Hold (rep divided by a factor of 5 if grey -> how to include this?) -- how to add limits
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[55] Feathers for Nafien", 150, {["Deadwood Headdress Feather"] = 5})
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[55] Feathers for Grazle", 150, {["Deadwood Headdress Feather"] = 5})
	    	FIZ_AddQuest("Timbermaw Hold", 2, 8, "[56] Beads for Salfa", 150, {["Winterfall Spirit Beads"] = 5})
	    	FIZ_AddMob("Timbermaw Hold", 2, 6, "Deadwood Avenger, Den Watcher, Shaman, Gardener, Pathfinder & Warrior", 10)
	    	FIZ_AddMob("Timbermaw Hold", 2, 6, "Winterfell Runner, Den Watcher, Shaman, Pathfinder, Totemic, & Ursa", 10)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Chieftain Bloodmaw", 30)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Overlord Ror", 30)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Ragepaw (Rare)", 50)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "Grizzle Snowpaw (Rare)", 50)
	    	FIZ_AddMob("Timbermaw Hold", 2, 8, "High Chief Winterfall", 50)
	    	-- Wintersaber Trainers
	    	FIZ_AddQuest("Wintersaber Trainers", 4, 8, "[60] Frostsaber Provisions", 250)
	    	FIZ_AddQuest("Wintersaber Trainers", 4, 8, "[60] Winterfall Intrusion", 250)
	    	FIZ_AddQuest("Wintersaber Trainers", 6, 8, "[60] Rampaging Giants", 350)
	end

    	-- --- Raid ---
    	if (GetLocale() == "deDE") then
	    	-- Ashtongue Deathsworn
	    	FIZ_AddInstance("Ashtongue Deathsworn", 4, 8, "Schwarzer Tempel", 1)
	    	-- Brood of Nozdormu
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 4, "[60] Die Hand der Gerechtigkeit", 200)
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Verteidiger des Anubisath", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "W\195\164chter des Anubisath", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Obsidianvernichter", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Wutstachel der Qiraji", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Schwarmkriecher der Vekniss", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Soldat der Vekniss", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Peitscher der Vekniss", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Krieger der Vekniss", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Wespe der Vekniss", 100, "Tempel von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 8, "Die meisten Bosse", 50, "Ruinen von Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 8, "Ossirian", 100, "Ruinen von Ahn'Qiraj")
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 8, "Insignien des Qirajilords", 500)		-- item
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 8, "Uraltes Qirajiartefakt", 1000)	-- item
	    	-- Cenarion Circle
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Felddienst", 150)
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssische Wappen", 150, {["Abyssisches Wappen"] = 3})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssische Siegel", 500, {["Abyssisches Siegel"] = 3})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssische Szepter", 300, {["Abyssisches Szepter"] = 1})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Geheime Nachrichten", 500, {["Verschl\195\188sselter Schattenhammertext"] = 10})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Treue zum Zirkel des Cenarius", 1000)
	    	FIZ_AddInstance("Cenarion Circle", 4, 8, "Ruinen von Ahn'Qiraj", 1200) -- counting only bosses
	    	FIZ_AddInstance("Cenarion Circle", 4, 8, "Tempel von Ahn'Qiraj", nil) -- no data for full run or bosses
	    	FIZ_AddMob("Cenarion Circle", 4, 5, "Schattenhammerkultist", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 6, "Flammenh\195\164scher des Schattenhammerklans", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 6, "Bewahrer des Schattenhammers", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Lord des Schattenhammers Everun", 10)	-- only 1 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssischer Templer", 10)
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssischer F\195\188rst", 50)
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssischer Lord", 100)
	    	-- Hydraxian Waterlords
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 5, "W\195\188stenrumpler, Staubst\195\188rmer", 5, "Silithus")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 5, "Gro\195\159er Obsidianelementar", 5, "Brennende Steppe")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Lord Incendius", 15, "Schwarzfelstiefen (BRT)")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Hurrikanus (Rar)", 25, "Silithus")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Feuerwache Glutseher", 50, "UBRS")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Geschmolzener Kern Trash", 20, "MC")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Geschmolzener Zerst\195\182rer & Lava Pack", 40, "MC")
	    	FIZ_AddInstance("Hydraxian Waterlords", 4, 7, "Molten Core (All Bosse)",1050, false)
	    	FIZ_AddInstance("Hydraxian Waterlords", 8, 8, "Molten Core (Golemagg & Ragnaros)",350, false)
	    	-- Scale of the Sands
	    	FIZ_AddQuest("Scale of the Sands", 4, 4, "[70] Die Phiolen der Ewigkeit", 3000)
	    	FIZ_AddInstance("Scale of the Sands", 5, 8, " Schlacht von Mount Hyjal full clear", 6000)
	    	-- The Violet Eye
	    	FIZ_AddInstance("The Violet Eye", 4, 8, "Karazan full clear", 6000, false)
	    	FIZ_AddMob("The Violet Eye", 4, 8, "Karazan Bosse", 250, "Karazan")
	    	FIZ_AddMob("The Violet Eye", 4, 8, "Karazan Trash", 15, "Karazan")
	    	-- Zandalar Tribe
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] M\195\188nzen der Razzashi, Hakkari und zulianische M\195\188nzen", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] M\195\188nzen der Sandw\195\188ter, Sch\195\164delspalter und Blutskalpe", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] M\195\188nzen der Gurubashi, Blutfratzen und Bleichborken", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 6, 8, "[60] Der Greuelw\195\164chter", 500)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "Ein Schmuckst\195\188ck zerst\195\182ren", 75)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "Zandalarianische Ehrenm\195\188nze", 50)
	    	FIZ_AddInstance("Zandalar Tribe", 4, 8, "Zul'Gurub", 2750)
    	else
	    	-- Ashtongue Deathsworn
	    	FIZ_AddInstance("Ashtongue Deathsworn", 4, 8, "Black Temple", 1)
	    	-- Brood of Nozdormu
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 4, "[60] The Hand of the Righteous", 200)
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Anubisath Defender", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Anubisath Sentinel", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Obsidian Eradicator", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Qiraj Lasher", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Vekniss Hive Crawler", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Vekniss Soldier", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Vekniss Stinger", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Vekniss Warrior", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 4, "Vekniss Wasp", 100, "Temple of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 8, "Most Bosses", 50, "Ruins of Ahn'Qiraj")
	    	FIZ_AddMob("Brood of Nozdormu", 1, 8, "Ossirian", 100, "Ruins of Ahn'Qiraj")
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 8, "Qiraji Lord's Insignia", 500)		-- item
	    	FIZ_AddQuest("Brood of Nozdormu", 1, 8, "Ancient Qiraji Artifact", 1000)	-- item
	    	-- Cenarion Circle
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Field Duty", 150)
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssal Crests", 150, {["Abyssal Crest"] = 3})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssal Signets", 500, {["Abyssal Signet"] = 3})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Abyssal Scepters", 300, {["Abyssal Scepter"] = 1})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Secret Communication", 500, {["Enctypted Twilight Text"] = 10})
	    	FIZ_AddQuest("Cenarion Circle", 4, 8, "[60] Allegiance to Cenarion Circle", 1000)
	    	FIZ_AddInstance("Cenarion Circle", 4, 8, "Ruins of Ahn'Qiraj", 1200) -- counting only bosses
	    	FIZ_AddInstance("Cenarion Circle", 4, 8, "Temple of Ahn'Qiraj", nil) -- no data for full run or bosses
	    	FIZ_AddMob("Cenarion Circle", 4, 5, "Twilight Cultist", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 6, "Twilight Flamereaver", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 6, "Twilight Keeper", 2)	-- only 0.2 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Twilight Lord Everun", 10)	-- only 1 @ 70
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssal Templar", 10)
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssal Duke", 50)
	    	FIZ_AddMob("Cenarion Circle", 4, 8, "Abyssal Lord", 100)
	    	-- Hydraxian Waterlords
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 5, "Desert Rumbler, Dust Stormer", 5, "Silithus")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 5, "Greater Obsidian Elemental", 5, "Burning Steppes")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Lord Incendius", 15, "BRD")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Huricanian (Rare)", 25, "Silithus")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Pyroguard Emberseer", 50, "UBRS")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Molten Core Trash", 20, "MC")
	    	FIZ_AddMob("Hydraxian Waterlords", 4, 6, "Molten Destroyer & Lava Pack", 40, "MC")
	    	FIZ_AddInstance("Hydraxian Waterlords", 4, 7, "Molten Core (all bosses)",1050, false)
	    	FIZ_AddInstance("Hydraxian Waterlords", 8, 8, "Molten Core (Golemagg & Ragnaros)",350, false)
	    	-- Scale of the Sands
	    	FIZ_AddQuest("Scale of the Sands", 4, 4, "[70] The Vials of Eternity", 3000)
	    	FIZ_AddInstance("Scale of the Sands", 5, 8, "Battle for Mount Hyal full clear", 6000)
	    	-- The Violet Eye
	    	FIZ_AddInstance("The Violet Eye", 4, 8, "Karazan full clear", 6000, false)
	    	FIZ_AddMob("The Violet Eye", 4, 8, "Karazan bosses", 250, "Karazan")
	    	FIZ_AddMob("The Violet Eye", 4, 8, "Karazan trash", 15, "Karazan")
	    	-- Zandalar Tribe
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] Zulian, Razzashi, and Hakkari Coins", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] Sandfury, Skullsplitter, and Bloodscalp Coins", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "[60] Gurubashi, Vilebranch, and Witherbark Coins", 25)
	    	FIZ_AddQuest("Zandalar Tribe", 6, 8, "[60] The Savage Guard", 500)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "Destroy a Bijou", 75)
	    	FIZ_AddQuest("Zandalar Tribe", 4, 8, "Zandalar Honor Token", 50)
	    	FIZ_AddInstance("Zandalar Tribe", 4, 8, "Zul'Gurub", 2750)
    	end

    	-- --- Steamwheedle Cartel ---
    	if (GetLocale() == "deDE") then
	    	-- Booty Bay
	    	FIZ_AddMob("Booty Bay", 4, 8, "Auftragsm\195\182rder der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Schurke der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Schattenmagier der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Bandit der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Dieb der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Pirat der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Dockarbeiter der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Schwadroneur der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddQuest("Booty Bay", 4, 8, "[44] Wasserbeutelkopfgeld", 5, {["Wasserbeutel eines W\195\188stenl\195\164ufers"] = 5})
	    	-- Gadgetzan
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Auftragsm\195\182rder der W\195\188stenl\195\164ufer", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Schurke der W\195\188stenl\195\164ufer", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Schattenmagier der W\195\188stenl\195\164ufer", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Bandit der W\195\188stenl\195\164ufer", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Dieb der W\195\188stenl\195\164ufer", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "S\195\188dmeerfreibeuter", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Pirat der S\195\188dmeerfreibeuter", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Dockarbeiter der S\195\188dmeerfreibeuter", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Schwadroneur der S\195\188dmeerfreibeuter", 5, "Tanaris")
	    	FIZ_AddQuest("Gadgetzan", 4, 8, "[44] Wasserbeutelkopfgeld", 10, {["Wasserbeutel eines W\195\188stenl\195\164ufers"] = 5})
	    	-- Ratchet
	    	FIZ_AddMob("Ratchet", 4, 8, "Auftragsm\195\182rder der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Schurke der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Schattenmagier der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Bandit der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Dieb der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Pirat der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Dockarbeiter der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Schwadroneur der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddQuest("Ratchet", 4, 8, "[44] Wasserbeutelkopfgeld", 5, {["Wasserbeutel eines W\195\188stenl\195\164ufers"] = 5})
	    	-- Everlook
	    	FIZ_AddMob("Everlook", 4, 8, "Auftragsm\195\182rder der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Schurke der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Schattenmagier der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Bandit der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Dieb der W\195\188stenl\195\164ufer", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Pirat der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Dockarbeiter der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Schwadroneur der S\195\188dmeerfreibeuter", 2, "Tanaris")
	    	FIZ_AddQuest("Everlook", 4, 8, "[44] Wasserbeutelkopfgeld", 5, {["Wasserbeutel eines W\195\188stenl\195\164ufers"] = 5})
    	else
	    	-- Booty Bay
	    	FIZ_AddMob("Booty Bay", 4, 8, "Wastewander Assassin", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Wastewander Rogue", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Wastewander Shadow Mage", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Wastewander Bandit", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Wastewander Thief", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Southsea Freebooter", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Southsea Pirate", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Southsea Dock Worker", 2, "Tanaris")
	    	FIZ_AddMob("Booty Bay", 4, 8, "Southsea Swashbuckler", 2, "Tanaris")
	    	FIZ_AddQuest("Booty Bay", 4, 8, "[44] Water Pouch Bounty", 5, {["Wastewander Water Pouch"] = 5})
	    	-- Gadgetzan
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Wastewander Assassin", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Wastewander Rogue", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Wastewander Shadow Mage", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Wastewander Bandit", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Wastewander Thief", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Southsea Freebooter", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Southsea Pirate", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Southsea Dock Worker", 5, "Tanaris")
	    	FIZ_AddMob("Gadgetzan", 4, 8, "Southsea Swashbuckler", 5, "Tanaris")
	    	FIZ_AddQuest("Gadgetzan", 4, 8, "[44] Water Pouch Bounty", 10, {["Wastewander Water Pouch"] = 5})
	    	-- Ratchet
	    	FIZ_AddMob("Ratchet", 4, 8, "Wastewander Assassin", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Wastewander Rogue", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Wastewander Shadow Mage", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Wastewander Bandit", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Wastewander Thief", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Southsea Freebooter", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Southsea Pirate", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Southsea Dock Worker", 2, "Tanaris")
	    	FIZ_AddMob("Ratchet", 4, 8, "Southsea Swashbuckler", 2, "Tanaris")
	    	FIZ_AddQuest("Ratchet", 4, 8, "[44] Water Pouch Bounty", 5, {["Wastewander Water Pouch"] = 5})
	    	-- Everlook
	    	FIZ_AddMob("Everlook", 4, 8, "Wastewander Assassin", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Wastewander Rogue", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Wastewander Shadow Mage", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Wastewander Bandit", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Wastewander Thief", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Southsea Freebooter", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Southsea Pirate", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Southsea Dock Worker", 2, "Tanaris")
	    	FIZ_AddMob("Everlook", 4, 8, "Southsea Swashbuckler", 2, "Tanaris")
	    	FIZ_AddQuest("Everlook", 4, 8, "[44] Water Pouch Bounty", 5, {["Wastewander Water Pouch"] = 5})
    	end

	-- --- Outland ---
    	if (GetLocale() == "deDE") then
	    	-- Cenarion Expedition
	    	FIZ_AddInstance("Cenarion Expedition", 4, 5, "Sklavenunterk\195\188nfte", 650, false)
	    	FIZ_AddInstance("Cenarion Expedition", 6, 8, "Sklavenunterk\195\188nfte", 650, true)	-- Trash 5, Bosses 70, no info on full clear
	    	FIZ_AddInstance("Cenarion Expedition", 4, 5, "Tiefensumpf", 1000, false)
	    	FIZ_AddInstance("Cenarion Expedition", 6, 8, "Tiefensumpf", 1000, true)	-- Trash 7, Bosses 70, no info on full clear
	    	FIZ_AddInstance("Cenarion Expedition", 4, 8, "Dampfkammer", 1662, false)
	    	FIZ_AddInstance("Cenarion Expedition", 4, 8, "Dampfkammer", 2319, true)
	    	FIZ_AddQuest("Cenarion Expedition", 4, 5, "[63] Pflanzen der Zangarmarschen", 250, {["Unbekannte Pflanzenteile"] = 10})
	    	FIZ_AddQuest("Cenarion Expedition", 4, 6, "[63] Nicht katalogisierte Gattung", 500, {["Nicht katalogisierte Gattung"] = 1})
	    	FIZ_AddQuest("Cenarion Expedition", 4, 8, "[67] Kriegsvorbereitungen", 75, {["Waffen des Echsenkessels"] = 1})
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Dampfpumpenvorarbeiter", 1, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Sklave der Gramlinge", 2.5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Zwangsarbeiter des Lumpenpacks", 2.5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Aufseher der Blutschuppen", 5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Wellenruferin der Blutschuppen", 5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Zauberhexerin der Dunkelk\195\164mme", 5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Sklavenh\195\164ndler der Dunkelk\195\164mme", 5, "Zangarmarschen")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Terrorklaue", 7, "Zangarmarschen")
	    	-- Honor Hold
	    	FIZ_AddInstance("Honor Hold", 4, 5, "Bollwerk", 600, false)
	    	FIZ_AddInstance("Honor Hold", 6, 8, "Bollwerk", 2000, true)
	    	FIZ_AddInstance("Honor Hold", 4, 5, "Blutkessel", 750, false)
	    	FIZ_AddInstance("Honor Hold", 6, 8, "Blutkessel", 2700, true)
	    	FIZ_AddInstance("Honor Hold", 4, 8, "Zerschmetterte Hallen", 1600, false)
	    	FIZ_AddInstance("Honor Hold", 4, 8, "Zerschmetterte Hallen", 2900, true)
	    	FIZ_AddQuest("Honor Hold", 4, 7, "[60] H\195\182llenfeuerbefestigungen", 150)
	    	FIZ_AddMob("Honor Hold", 4, 4, "Mobs der Zerschmetterten Hand", 5, "H\195\182llenfeuerhalbinsel")
	    	-- Kurenai
	    	FIZ_AddQuest("Kurenai", 4, 8, "[67] Grimmige Feinde", 500, {["Obsidiankriegsperlen"] = 10})
	    	FIZ_AddQuest("Kurenai", 4, 8, "[70] Zur Verteidigung von Halaa", 500)
	    	FIZ_AddMob("Kurenai", 4, 8, "Zermalmer & Mystiker der Felsf\195\164uste", 10, "Nagrand, Ruinen der Brennenden Klinge")
	    	FIZ_AddMob("Kurenai", 4, 8, "Todesh\195\182riger, Kultisten und Zauberbinder von Kil'sorge", 10, "Nagrand, Burg Kil'Sorge")
	    	FIZ_AddMob("Kurenai", 4, 8, "Magier und Krieger der Felsf\195\164uste", 10, "Nagrand, Nord- und S\195\188dwindschlucht")
	    	FIZ_AddMob("Kurenai", 4, 8, "Strauchdieb der Finsterblut", 2, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Kurenai", 4, 8, "Schl\195\164ger, L\195\164uterer & R\195\164uber der Finsterblut", 10, "Nagrand, Sonnenwindposten")
	    	FIZ_AddMob("Kurenai", 4, 8, "H\195\164scher & Schamane der Totschl\195\164ger", 10, "Nagrand, Ruinen des Lachenden Sch\195\164dels")
	    	FIZ_AddMob("Kurenai", 4, 8, "Schl\195\164ger & Hexenmeister der Totschl\195\164ger", 10, "Nagrand, H\195\188gel der Totschl\195\164ger")
	    	-- Mag'har
	    	FIZ_AddQuest("Mag'har", 4, 8, "[67] St\195\164rke beweisen", 500, {["Obsidiankriegsperlen"] = 10})
	    	FIZ_AddQuest("Mag'har", 4, 8, "[70] Feinde - alte und neue", 500)
	    	FIZ_AddMob("Mag'har", 4, 8, "Zermalmer & Mystiker der Felsf\195\164uste", 10, "Nagrand, Ruinen der Brennenden Klinge")
	    	FIZ_AddMob("Mag'har", 4, 8, "Todesh\195\182riger, Kultisten und Zauberbinder von Kil'sorge", 10, "Nagrand, Burg Kil'Sorge")
	    	FIZ_AddMob("Mag'har", 4, 8, "Magier und Krieger der Felsf\195\164uste", 10, "Nagrand, Nord- und S\195\188dwindschlucht")
	    	FIZ_AddMob("Mag'har", 4, 8, "Strauchdieb der Finsterblut", 2, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Mag'har", 4, 8, "Schl\195\164ger, L\195\164uterer & R\195\164uber der Finsterblut", 10, "Nagrand, Sonnenwindposten")
	    	FIZ_AddMob("Mag'har", 4, 8, "H\195\164scher & Schamane der Totschl\195\164ger", 10, "Nagrand, Ruinen des Lachenden Sch\195\164dels")
	    	FIZ_AddMob("Mag'har", 4, 8, "Schl\195\164ger & Hexenmeister der Totschl\195\164ger", 10, "Nagrand, H\195\188gel der Totschl\195\164ger")
	    	-- Ogri'la
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] Die Strahlung des Relikts", 350)
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] B\195\164ndigt noch mehr \195\132therrochen!", 350)
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] Und wieder ein Bombenangriff!", 500)
	    	FIZ_AddQuest("Ogri'la", 6, 8, "[70] Bannt mehr D\195\164monen", 350)
	    	-- Netherwing
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Immer her mit den Eiern", 250, {["Ei der Netherschwingen"]=1})
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Netherstaubpollen", 250, {["Netherstaubpollen"]=40}, FIZ_LIMIT_TYPE_HERB)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Netheriterz", 250, {["Netheriterz"]=40}, FIZ_LIMIT_TYPE_MINE)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Balg eines Netherminenschinders", 250, {["Balg eines Netherminenschinders"]=40}, FIZ_LIMIT_TYPE_SKIN)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Ein langsamer Tod", 250)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Ein Schatten am Horizont", 250, {["Relikt der Netherschwingen"]=10})
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Kristalle der Netherschwingen", 250, {["Kristall der Netherschwingen"]=40})
	    	FIZ_AddQuest("Netherwing", 5, 8, "[70] Drachen sind unsere geringste Sorge", 350)
	    	FIZ_AddQuest("Netherwing", 5, 8, "[70] Die Dinge in den Griff bekommen...", 350, {["Fracht der Netherminen"]=15})
		FIZ_AddQuest("Netherwing", 5, 8, "[70] Der Schuhmerang: Das Mittel gegen den wertlosen Peon", 350)
		FIZ_AddQuest("Netherwing", 6, 8, "[70] Schw\195\164cht das Portal des Zwielichts", 500)
		FIZ_AddQuest("Netherwing", 7, 8, "[70+] Die t\195\182dlichste Falle aller Zeiten", 500)
	    	-- Sporeggar
	    	FIZ_AddMob("Sporeggar", 3, 6, "Sumpflord, Sumpfriese", 15)
	    	FIZ_AddMob("Sporeggar", 3, 7, "Marschenlauerer", 15)
	    	FIZ_AddQuest("Sporeggar", 3, 4, "[63] Die Misere der Sporlinge", 750, {["Reifer Sporenbeutel"] = 10})
	    	FIZ_AddQuest("Sporeggar", 3, 4, "[64] Nat\195\188rliche Feinde", 750, {["Sumpflordranke"] = 6})
	    	FIZ_AddQuest("Sporeggar", 3, 5, "[64] Mehr Ranken!", 750, {["Sumpflordranke"] = 6})	-- according to wowwiki only till 4, but in game it works till at least 5
	    	FIZ_AddQuest("Sporeggar", 4, 4, "[64] Gl\195\188hkappenpilze", 750, {["Gl\195\188hkappe"] = 10})
	    	FIZ_AddQuest("Sporeggar", 5, 8, "[64] Jetzt, da wir immer noch Freunde sind...", 750)
	    	FIZ_AddQuest("Sporeggar", 4, 8, "[64] Noch mehr fruchtbare Sporen", 750, {["Fruchtbare Sporen"] = 10})
	    	FIZ_AddQuest("Sporeggar", 5, 8, "[65] Bringt mir ein Geb\195\188sch!", 750, {["Bluthibiskus"] = 5})
		-- Consortium
		FIZ_AddInstance("The Consortium", 4, 5, "Managruft", 1200, false)
		FIZ_AddInstance("The Consortium", 6, 8, "Managruft", 2400, true)
		FIZ_AddQuest("The Consortium", 4, 4, "[66] Von Dieben stehlen", 250, {["Kristallfragment von Oshu'gun"] = 10})
		FIZ_AddQuest("The Consortium", 4, 4, "[66] Ein ganzer Kopf voll Elfenbein", 250, {["Paar Elfenbeinsto\195\159z\195\164hne"] = 3})
		FIZ_AddQuest("The Consortium", 5, 8, "[67] Obsidiankriegsperlen", 250, {["Obsidiankriegsperlen"] = 10})
		FIZ_AddQuest("The Consortium", 5, 8, "[68] Ein H\195\188gel voll Astraler", 250, {[" Insignie der Zaxxis"] = 10})
		FIZ_AddQuest("The Consortium", 6, 8, "[70] Geheimnisse des Astraleums", 250, {["Identifikationsmarke eines Gefangenen des Astraleums"] = 1})
		FIZ_AddQuest("The Consortium", 7, 8, "[70] Tausend Welten", 500, {["Gef\195\164ngnisschl\195\188ssel des Astraleums"] = 5})
	    	-- Thrallmar
	    	FIZ_AddInstance("Thrallmar", 4, 5, "Bollwerk", 600, false)
	    	FIZ_AddInstance("Thrallmar", 6, 8, "Bollwerk", 2000, true)
	    	FIZ_AddInstance("Thrallmar", 4, 5, "Blutkessel", 750, false)
	    	FIZ_AddInstance("Thrallmar", 6, 8, "Blutkessel", 2700, true)
	    	FIZ_AddInstance("Thrallmar", 4, 8, "Zerschmetterte Hallen", 1600, false)
	    	FIZ_AddInstance("Thrallmar", 4, 8, "Zerschmetterte Hallen", 2900, true)
	    	FIZ_AddQuest("Thrallmar", 4, 7, "[60] H\195\182llenfeuerbefestigungen", 150)
    	else
	    	-- Cenarion Expedition
	    	FIZ_AddInstance("Cenarion Expedition", 4, 5, "Slave Pens", 650, false)
	    	FIZ_AddInstance("Cenarion Expedition", 7, 8, "Slave Pens", nil, true)	-- Trash 5, Bosses 70, no info on full clear
	    	FIZ_AddInstance("Cenarion Expedition", 4, 5, "Underbog", 1000, false)
	    	FIZ_AddInstance("Cenarion Expedition", 7, 8, "Underbog", nil, true)	-- Trash 7, Bosses 70, no info on full clear
	    	FIZ_AddInstance("Cenarion Expedition", 4, 8, "Steamvault", 1662, false)
	    	FIZ_AddInstance("Cenarion Expedition", 4, 8, "Steamvault", 2319, true)
	    	FIZ_AddQuest("Cenarion Expedition", 4, 5, "[63] Plants of Zangarmarsh", 250, {["Unidentified Plant Parts"] = 10})
	    	FIZ_AddQuest("Cenarion Expedition", 4, 6, "[63] Uncatalogued Species", 500, {["Uncatalogued Species"] = 1})
	    	FIZ_AddQuest("Cenarion Expedition", 4, 8, "[67] Preparing for War", 75, {["Coilfang Armaments"] = 1})
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Steam Pump Overseer", 1, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Wrekt Slave", 2.5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Dreghood Drudge", 2.5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Bloodscale Overseer", 5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Bloodscale Wavecaller", 5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Darkcrest Sorceress", 5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Darkcrest Slaver", 5, "Zangarmarsh")
	    	FIZ_AddMob("Cenarion Expedition", 4, 4, "Terrorclaw", 7, "Zangarmarsh")
	    	-- Honor Hold
	    	FIZ_AddInstance("Honor Hold", 4, 5, "Hellfire Ramparts", 600, false)
	    	FIZ_AddInstance("Honor Hold", 7, 8, "Hellfire Ramparts", 2000, true)
	    	FIZ_AddInstance("Honor Hold", 4, 5, "Blood Furnace", 750, false)
	    	FIZ_AddInstance("Honor Hold", 7, 8, "Blood Furnace", 2700, true)
	    	FIZ_AddInstance("Honor Hold", 4, 8, "Shattered Halls", 1600, false)
	    	FIZ_AddInstance("Honor Hold", 4, 8, "Shattered Halls", 2900, true)
	    	FIZ_AddQuest("Honor Hold", 4, 7, "[60] Hellfire Fortifications", 150)
	    	FIZ_AddMob("Honor Hold", 4, 4, "Shattered Hands", 5, "Hellfire Peninsula")
	    	-- Kurenai
	    	FIZ_AddQuest("Kurenai", 4, 8, "[67] Fierce Enemies", 500, {["Obsidian Warbeads"] = 10})
	    	FIZ_AddQuest("Kurenai", 4, 8, "[70] In Defense of Halaa", 500)
	    	FIZ_AddMob("Kurenai", 4, 8, "Boulderfist Crusher & Mystic", 10, "Nagrand, Burning Blade Ruins")
	    	FIZ_AddMob("Kurenai", 4, 8, "Kil'sorrow Deathsworn, Cultist & Spellbinder", 10, "Nagrand, Kil'sorrow Fortress")
	    	FIZ_AddMob("Kurenai", 4, 8, "Boulderfist Mage & Warrior", 10, "Nagrand, North & Southwind Clefts")
	    	FIZ_AddMob("Kurenai", 4, 8, "Murkblood Scavenger", 2, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Kurenai", 4, 8, "Murkblood Brute, Putrifier & Raider", 10, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Kurenai", 4, 8, "Warmaul Reaver & Shaman", 10, "Nagrand, Laughing Skull Ruins")
	    	FIZ_AddMob("Kurenai", 4, 8, "Warmaul Brute & Warlock", 10, "Nagrand, Warmaul Hill")
	    	-- Mag'har
	    	FIZ_AddQuest("Mag'har", 4, 8, "[67] Proving Your Strength", 500, {["Obsidian Warbeads"] = 10})
	    	FIZ_AddQuest("Mag'har", 4, 8, "[70] Enemies, Old and New", 500)
	    	FIZ_AddMob("Mag'har", 4, 8, "Boulderfist Crusher & Mystic", 10, "Nagrand, Burning Blade Ruins")
	    	FIZ_AddMob("Mag'har", 4, 8, "Kil'sorrow Deathsworn, Cultist & Spellbinder", 10, "Nagrand, Kil'sorrow Fortress")
	    	FIZ_AddMob("Mag'har", 4, 8, "Boulderfist Mage & Warrior", 10, "Nagrand, North & Southwind Clefts")
	    	FIZ_AddMob("Mag'har", 4, 8, "Murkblood Scavenger", 2, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Mag'har", 4, 8, "Murkblood Brute, Putrifier & Raider", 10, "Nagrand, Sunspring Post")
	    	FIZ_AddMob("Mag'har", 4, 8, "Warmaul Reaver & Shaman", 10, "Nagrand, Laughing Skull Ruins")
	    	FIZ_AddMob("Mag'har", 4, 8, "Warmaul Brute & Warlock", 10, "Nagrand, Warmaul Hill")
	    	-- Ogri'la
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] The Relic's Emanation", 350)
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] Wrangle More Aether Rays!", 350)
	    	FIZ_AddQuest("Ogri'la", 4, 8, "[70] Bomb Them Again!", 500)
	    	FIZ_AddQuest("Ogri'la", 6, 8, "[70] Banish More Demons", 350)
	    	-- Netherwing
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Accepting All Eggs", 250, {["Netherwing Egg"]=1})
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Netherdust Pollen", 250, {["Netherdust Pollen"]=40}, FIZ_LIMIT_TYPE_HERB)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Nethercite Ore", 250, {["Nethercite Ore"]=40}, FIZ_LIMIT_TYPE_MINE)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Nethermine Flayer Hide", 250, {["Nethermine Flayer Hide"]=40}, FIZ_LIMIT_TYPE_SKIN)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] A Slow Death", 250)
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] The Not-So-Friendly Skies", 250, {["Netherwing Relic"]=10})
	    	FIZ_AddQuest("Netherwing", 4, 8, "[70] Netherwing Crystals", 250, {["Netherwing Crystal"]=40})
	    	FIZ_AddQuest("Netherwing", 5, 8, "[70] Dragons are the Least of our Problems", 350)
	    	FIZ_AddQuest("Netherwing", 5, 8, "[70] Picking up the Pieces....", 350, {["Nethermine Cargo"]=15})
		FIZ_AddQuest("Netherwing", 5, 8, "[70] The Booterang: A Cure for the Common Worthless Peon", 350)
		FIZ_AddQuest("Netherwing", 6, 8, "[70] Disrupting the Twilight Portal", 500)
		FIZ_AddQuest("Netherwing", 7, 8, "[70+] The Deadliest Trap Ever Laid", 500)
	    	-- Sporeggar
	    	FIZ_AddMob("Sporeggar", 3, 6, "Bog Lords, Bog Giants", 15)
	    	FIZ_AddMob("Sporeggar", 3, 7, "Marsh Lurker", 15)
	    	FIZ_AddQuest("Sporeggar", 3, 4, "[63] The Sporeling's Plight", 750, {["Mature Spore Sac"] = 10})
	    	FIZ_AddQuest("Sporeggar", 3, 4, "[64] Natural Enemies", 750, {["Bog Lord Tendril"] = 6})
	    	FIZ_AddQuest("Sporeggar", 3, 5, "[64] More Tendrils", 750, {["Bog Lord Tendril"] = 6})	-- according to wowwiki only till 4, but in game it works till at least 5
	    	FIZ_AddQuest("Sporeggar", 4, 4, "[64] Glowcap Mushrooms", 750, {["Glowcap"] = 10})
	    	FIZ_AddQuest("Sporeggar", 5, 8, "[64] Now that we're still Friends...", 750)
	    	FIZ_AddQuest("Sporeggar", 4, 8, "[64] More Fertile Spores", 750, {["Fertile Spores"] = 10})
	    	FIZ_AddQuest("Sporeggar", 5, 8, "[65] Bring me a Shrubbery!", 750, {["Sanguine Hibiscus"] = 5})
		-- Consortium
		FIZ_AddInstance("The Consortium", 4, 5, "Mana Tombs", 1200, false)
		FIZ_AddInstance("The Consortium", 6, 8, "Mana Tombs", 2400, true)
		FIZ_AddQuest("The Consortium", 4, 4, "[66] Stealing from Thieves", 250, {["Oshu'gun Crystal Fragment"] = 10})
		FIZ_AddQuest("The Consortium", 4, 4, "[66] A Head Full of Ivory", 250, {["Pair of Ivory Tusks"] = 3})
		FIZ_AddQuest("The Consortium", 5, 8, "[67] Obsidian Warbeads", 250, {["Obsidian Warbeads"] = 10})
		FIZ_AddQuest("The Consortium", 5, 8, "[68] A Heap of Ethereals", 250, {["Zaxxis Insigna"] = 10})
		FIZ_AddQuest("The Consortium", 6, 8, "[70] Etherum Secrets", 250, {["Etherum Priosoner I.D. Tag"] = 1})
		FIZ_AddQuest("The Consortium", 7, 8, "[70] A Thousand Worlds", 500, {["Etherum Prison Key"] = 5})
	    	-- Thrallmar
	    	FIZ_AddInstance("Thrallmar", 4, 5, "Hellfire Ramparts", 600, false)
	    	FIZ_AddInstance("Thrallmar", 7, 8, "Hellfire Ramparts", 2000, true)
	    	FIZ_AddInstance("Thrallmar", 4, 5, "Blood Furnace", 750, false)
	    	FIZ_AddInstance("Thrallmar", 7, 8, "Blood Furnace", 2700, true)
	    	FIZ_AddInstance("Thrallmar", 4, 8, "Shattered Halls", 1600, false)
	    	FIZ_AddQuest("Thrallmar", 4, 7, "[60] Hellfire Fortifications", 150)
    	end

    	-- --- Shattrath ---
    	if (GetLocale() == "deDE") then
	    	-- Lower City
	    	FIZ_AddInstance("Lower City", 4, 5, "Auchenaikrypta", 750, false)
	    	FIZ_AddInstance("Lower City", 7, 8, "Auchenaikrypta", 750, true)
	    	FIZ_AddInstance("Lower City", 4, 5, "Sethekhallen", 1250, false)
	    	FIZ_AddInstance("Lower City", 7, 8, "Sethekhallen", 1250, true)
	    	FIZ_AddInstance("Lower City", 4, 8, "Schattenlabyrinth", 2000, false)
	    	FIZ_AddInstance("Lower City", 4, 8, "Schattenlabyrinth", 2000, true)
		FIZ_AddQuest("Lower City", 4, 5, "[65] Die Pflicht eines Ausgesto\195\159enen", 250, {["Arakkoafeder"] = 30})
	    	-- Sha'tari Skyguard
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Schattenwelt", 150, {["Schattenstaub"] = 6})
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Feuer \195\188ber Skettis", 350)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Flucht aus Skettis", 150)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] B\195\164ndigt ein paar \195\132therrochen!", 350)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Bomberangriff", 500)
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 6, "Kaliri von Skettis", 2.5, "W\195\164lder von Terokkar")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Krallenpriester, Zeitverlorene, Monstr\195\182ser Kaliri", 10, "W\195\164lder von Terokkar, Skettis")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Waldw\195\188ter der Krallenanbeter", 30, "W\195\164lder von Terokkar")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Akkarai, Karrog, Gezzarak, Vakkiz", 100, "W\195\164lder von Terokkar (Beschworen f\195\188r Feindesblut)")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Terokk", 500, "W\195\164lder von Terokkar (Beschworen)")
	    	-- The Aldor
		FIZ_AddQuest("The Aldor", 1, 3, "[64] Schwindende Vorr\195\164te", 250, {["Schreckensgiftbeutel"] = 8})
		FIZ_AddQuest("The Aldor", 4, 5, "[70] Mehr Male von Kil'jaeden", 250, {["Mal von Kil'jaeden"] = 10})
		FIZ_AddQuest("The Aldor", 4, 5, "[70] Einzelne Male von Kil'jaeden", 25, {["Mal von Kil'jaeden"] = 1})
		FIZ_AddQuest("The Aldor", 5, 8, "[70] Mehr Male des Sargeras", 250, {["Mal des Sargeras"] = 10})
		FIZ_AddQuest("The Aldor", 5, 8, "[70] Einzelne Male des Sageras", 25, {["Mal des Sargeras"] = 1})
		FIZ_AddQuest("The Aldor", 5, 8, "[64] Ein reinigendes Licht", 350, {["Teuflische Waffen"] = 1})
	    	-- The Scryers
		FIZ_AddQuest("The Scryers", 1, 3, "[64] Voren'thals Visionen", 250, {["Auge eines Dunstschuppenbasilisken"] = 8})
		FIZ_AddQuest("The Scryers", 4, 5, "[70] Mehr Siegel der Feuerschwingen", 250, {["Siegel der Feuerschwingen"] = 10})
		FIZ_AddQuest("The Scryers", 4, 5, "[70] Einzelne Siegel der Feuerschwingen", 25, {["Siegel der Feuerschwingen"] = 1})
		FIZ_AddQuest("The Scryers", 5, 8, "[70] Mehr Siegel des Sonnenzorns", 250, {["Siegel des Sonnenzorns"] = 10})
		FIZ_AddQuest("The Scryers", 5, 8, "[70] Einzelne Siegel des Sonnenzorns", 25, {["Siegel des Sonnenzorns"] = 1})
		FIZ_AddQuest("The Scryers", 5, 8, "[64] B\195\188ndelung der Macht", 350, {["Arkaner Foliant"] = 1})
	    	-- The Sha'tar
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Mehr Male von Kil'jaeden", 125, {["Mal von Kil'jaeden"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Einzelne Male von Kil'jaeden", 12.5, {["Mal von Kil'jaeden"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Mehr Male des Sargeras", 125, {["Mal des Sargeras"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Einzelne Male des Sageras", 12.5, {["Mal des Sargeras"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Mehr Siegel der Feuerschwingen", 125, {["Siegel der Feuerschwingen"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Einzelne Siegel der Feuerschwingen", 12.5, {["Siegel der Feuerschwingen"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Mehr Siegel des Sonnenzorns", 125, {["Siegel des Sonnenzorns"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Einzelne Siegel des Sonnenzorns", 12.5, {["Siegel des Sonnenzorns"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Schwindende Vorr\195\164te", 125, {["Schreckensgiftbeutel"] = 8})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Voren'thals Visionen", 125, {["Auge eines Dunstschuppenbasilisken"] = 8})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Ein reinigendes Licht", 175, {["Teuflische Waffen"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] B\195\188ndelung der Macht", 175, {["Arkaner Foliant"] = 1})
		FIZ_AddInstance("The Sha'tar", 4, 8, "Mechanaar", 1620, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Mechanaar", 3000, true)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Botanikum", 2000, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Botanikum", 3000, true)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Arkatraz", 1800, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Arkatraz", 3000, true)
    	else
	    	-- Lower City
	    	FIZ_AddInstance("Lower City", 4, 5, "Auchenai Crypts", 750, false)
	    	FIZ_AddInstance("Lower City", 7, 8, "Auchenai Crypts", 750, true)
	    	FIZ_AddInstance("Lower City", 4, 5, "Sethekk Halls", 1250, false)
	    	FIZ_AddInstance("Lower City", 7, 8, "Sethekk Halls", 1250, true)
	    	FIZ_AddInstance("Lower City", 4, 8, "Shadow Labyrinth", 2000, false)
	    	FIZ_AddInstance("Lower City", 4, 8, "Shadow Labyrinth", 2000, true)
		FIZ_AddQuest("Lower City", 4, 5, "[65] The Outcast's Plight", 250, {["Arakkoa Feather"] = 30})
	    	-- Sha'tari Skyguard
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] World of Shadows", 150, {["Shadow Dust"] = 6})
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Fires over Skettis", 350)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Escape from Skettis", 150)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Wrangle some Aether Rays!", 350)
		FIZ_AddQuest("Sha'tari Skyguard", 4, 8, "[70] Bombing Run", 500)
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 6, "Skettis Kaliri", 2.5, "Terokkar Forest, Skettis")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Skettis, Talonpriests, Time-Lost Skettis, Monstrous Kaliri", 10, "Terokkar Forest, Skettis")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Talonsworn Forest-Rager", 30, "Terokkar Forest, Skettis")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Akkarai, Karrog, Gezzarak, Vakkiz", 100, "Terokkar Forest, Skettis (Summoned for Adversarial Blood)")
	    	FIZ_AddMob("Sha'tari Skyguard", 4, 8, "Terokk", 500, "Terokkar Forest, Skettis (Summoned)")
	    	-- The Aldor
		FIZ_AddQuest("The Aldor", 1, 3, "[64] Strained Supplies", 250, {["Dreadfang Venom Sac"] = 8})
		FIZ_AddQuest("The Aldor", 4, 5, "[70] More Marks of Kil'jaeden", 250, {["Mark of Kil'jaeden"] = 10})
		FIZ_AddQuest("The Aldor", 4, 5, "[70] Single Marks of Kil'jaeden", 25, {["Mark of Kil'jaeden"] = 1})
		FIZ_AddQuest("The Aldor", 5, 8, "[70] More Marks of Sargeras", 250, {["Mark of Sargeras"] = 10})
		FIZ_AddQuest("The Aldor", 5, 8, "[70] Single Mark of Sargeras", 25, {["Mark of Sargeras"] = 1})
		FIZ_AddQuest("The Aldor", 5, 8, "[64] A Cleansing Light", 350, {["Fel Armament"] = 1})
	    	-- The Scryers
		FIZ_AddQuest("The Scryers", 1, 3, "[64] Voren'thal's Visions", 250, {["Dampscale Basilisk Eye"] = 8})
		FIZ_AddQuest("The Scryers", 4, 5, "[70] More Firewing Signets", 250, {["Firewing Signet"] = 10})
		FIZ_AddQuest("The Scryers", 4, 5, "[70] Single Firewing Signets", 25, {["Firewing Signet"] = 1})
		FIZ_AddQuest("The Scryers", 5, 8, "[70] More Sunfury Signets", 250, {["Sunfury Signet"] = 10})
		FIZ_AddQuest("The Scryers", 5, 8, "[70] Single Sunfury Signets", 25, {["Sunfury Signet"] = 1})
		FIZ_AddQuest("The Scryers", 5, 8, "[64] Synthesis of Power", 350, {["Arcane Tome"] = 1})
	    	-- The Sha'tar
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] More Marks of Kil'jaeden", 125, {["Mark of Kil'jaeden"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Single Marks of Kil'jaeden", 12.5, {["Mark of Kil'jaeden"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] More Marks of Sargeras", 125, {["Mark of Sargeras"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Single Marks of Sargeras", 12.5, {["Mark of Sargeras"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] More Firewing Signets", 125, {["Firewing Signet"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Single Firewing Signets", 12.5, {["Firewing Signet"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] More Sunfury Signets", 125, {["Sunfury Signet"] = 10})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[70] Single Sunfury Signets", 12.5, {["Sunfury Signet"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Strained Supplies", 125, {["Dreadfang Venom Sac"] = 8})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Voren'thal's Visions", 125, {["Dampscale Basilisk Eye"] = 8})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] A Cleansing Light", 175, {["Fel Armament"] = 1})
		FIZ_AddQuest("The Sha'tar", 4, 5, "[64] Synthesis of Power", 175, {["Arcane Tome"] = 1})
		FIZ_AddInstance("The Sha'tar", 4, 8, "Mechanaar", 1620, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Mechanaar", 3000, true)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Botanica", 2000, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Botanica", 3000, true)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Arcatraz", 1800, false)
		FIZ_AddInstance("The Sha'tar", 4, 8, "Arcatraz", 3000, true)
	end


	if (GetLocale() == "deDE") then
	    	-- Shattered Sun Offensive
	    	-- general
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Einen Vorteil gewinnen", 250, {["Netherr\195\188ckst\195\164nde"] = 8}, FIZ_LIMIT_TYPE_GATHER)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Angriffspl\195\164ne der Sonnenzorn", 250, {["Angriffspl\195\164ne der Sonnenzorn"] = 1})
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die Multiphasen-Vermessung", 250)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Blut f\195\188r Blut", 250)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Vernichtet den Durchgang", 250)
	    	-- Phase 1 (till Sun's Reach Sanctum)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Unberechenbares Verhalten", 150, nil, FIZ_LIMIT_TYPE_SSO, 1, 1) -- Phase 1 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die Barrieren des Sanktums", 150, nil, FIZ_LIMIT_TYPE_SSO, 1, 1) -- Phase 1 only
	    	-- Phase 2 (Sun's Reach Sanctum to Sun's Reach Armory)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die Schlacht um die Waffenkammer der Sonnenweiten", 250, nil, FIZ_LIMIT_TYPE_SSO, 2, 2) -- Phase 2 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Ablenkungsman\195\182ver an der Todesschneise", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 2) -- Phase 2 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Fahrt die Barrieren hoch!", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 5) -- Phase 2 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Weitere Konvertierungen", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 5) -- Phase 2 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Manazellen abfangen", 250, {["Eingeschmuggelte Manazelle"] = 10}, FIZ_LIMIT_TYPE_SSO, 2, 5, 1) -- Phase 2 to 2b
	    	-- Phase 2B (after Sunwell)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Das Sonnenbrunnenportal aufrechterhalten", 250, {["Eingeschmuggelte Manazelle"] = 10}, FIZ_LIMIT_TYPE_SSO, 2, 5, 2) -- Phase 2B onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Kenne deine Leylinien", 250, nil, FIZ_LIMIT_TYPE_SSO, 2, 5, 2) -- Phase 2B onwards
	    	-- Phase 3 (Armory to Harbor)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Haltet die Verst\195\164rkung auf", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 3) -- Phase 3 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Den Hafen einnehmen", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 3) -- Phase 3 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die Schlacht muss weitergehen", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 5) -- Phase 3 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die Luftangriffe m\195\188ssen weitergehen", 150, nil, FIZ_LIMIT_TYPE_SSO, 3, 5) -- Phase 3 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Vorbereitungen", 150, {["Eisenerz der Dunkelflossen"] = 3}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 1) -- Phase 3 to 3b
	    	-- Phase 3b (after Anvil/Forge)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Waffen von Ata'mal", 350, {["Gereinigtes Metall von Ata'mal"] = 5}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 2) -- Phase 3b onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] H\195\182rt jetzt nicht auf!", 250, {["Eisenerz der Dunkelflossen"] = 3}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 2) -- Phase 3b onwards
	    	-- Phase 4 (Harbor to town)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Die eigenen Wurzeln entdecken", 350, {["Messerdornwurzel"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 1) -- Phase 4 to 4c
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Disrupt the Greengill Coast", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Den Feind vom Leibe halten", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Vernichtet die D\195\164mmerklingen", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Eine milde Gabe", 150, nil, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, 1) -- Phase 4 to 4b
	    	FIZ_AddQuest("Shattered Sun Offensive", 8, 8, "[70] Ein gro\195\159m\195\188tiger Spender", 500, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	-- Phase 4b (after Monument)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Eure weitere Unterst\195\188tzung", 150, nil, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, 2) -- Phase 4b onwards
	    	-- Phase 4c (after Your Roots)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Eure Wurzeln wiederentdecken", 350, {["Messerdornwurzel"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 2) -- Phase 4c onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Gesch\195\164ft ge\195\182ffnet", 250, {["Blutbeere"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 2) -- Phase 4c onwards

	else	-- not deDE

	    	-- Shattered Sun Offensive
	    	-- general
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Gaining the Advantage", 250, {["Nether Residue"] = 8}, FIZ_LIMIT_TYPE_GATHER)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Sunfury Attack Plans", 250, {["Sunfury Attack Plans"] = 1})
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] The Multiphase Survey", 250)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Blood for Blood", 250)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Blast the Gateway", 250)
	    	-- Phase 1 (till Sun's Reach Sanctum)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Erratic Behavior", 150, nil, FIZ_LIMIT_TYPE_SSO, 1, 1) -- Phase 1 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] The Sanctum Wards", 150, nil, FIZ_LIMIT_TYPE_SSO, 1, 1) -- Phase 1 only
	    	-- Phase 2 (Sun's Reach Sanctum to Sun's Reach Armory)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] The Battle for the Sun's Reach Armory", 250, nil, FIZ_LIMIT_TYPE_SSO, 2, 2) -- Phase 2 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Distraction at the Dead Scar", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 2) -- Phase 2 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Arm the Wards!", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 5) -- Phase 2 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Further Conversions", 150, nil, FIZ_LIMIT_TYPE_SSO, 2, 5) -- Phase 2 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Intercepting the Mana Cells", 250, {["Smuggled Mana Cell"] = 10}, FIZ_LIMIT_TYPE_SSO, 2, 5, 1) -- Phase 2 to 2b
	    	-- Phase 2B (after Sunwell)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Maintaining the Sunwell Portal", 250, {["Smuggled Mana Cell"] = 10}, FIZ_LIMIT_TYPE_SSO, 2, 5, 2) -- Phase 2B onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Know Your Ley Lines", 250, nil, FIZ_LIMIT_TYPE_SSO, 2, 5, 2) -- Phase 2B onwards
	    	-- Phase 3 (Armory to Harbor)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Intercept the Reinforcements", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 3) -- Phase 3 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Taking the Harbor", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 3) -- Phase 3 only
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] The Battle Must Go On", 250, nil, FIZ_LIMIT_TYPE_SSO, 3, 5) -- Phase 3 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] The Air Strikes Must Continue", 150, nil, FIZ_LIMIT_TYPE_SSO, 3, 5) -- Phase 3 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Making Ready", 150, {["Darkspine Iron Ore"] = 3}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 1) -- Phase 3 to 3b
	    	-- Phase 3b (after Anvil/Forge)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Ata'mal Armaments", 350, {["Cleansed Ata'mal Metal"] = 5}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 2) -- Phase 3b onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Don't Stop Now....", 250, {["Darkspine Iron Ore"] = 3}, FIZ_LIMIT_TYPE_SSO, 3, 5, nil, 2) -- Phase 3b onwards
	    	-- Phase 4 (Harbor to town)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Discovering Your Roots", 350, {["Razorthorn Root"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 1) -- Phase 4 to 4c
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Disrupt the Greengill Coast", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Keeping the Enemy at Bay", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Crush the Dawnblade", 250, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] A Charitable Donation", 150, nil, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, 1) -- Phase 4 to 4b
	    	FIZ_AddQuest("Shattered Sun Offensive", 8, 8, "[70] A Magnanimous Benefactor", 500, nil, FIZ_LIMIT_TYPE_SSO, 4, 5) -- Phase 4 onwards
	    	-- Phase 4b (after Monument)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Your Continued Support", 150, nil, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, 2) -- Phase 4b onwards
	    	-- Phase 4c (after Your Roots)
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Rediscovering Your Roots", 350, {["Razorthorn Root"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 2) -- Phase 4c onwards
	    	FIZ_AddQuest("Shattered Sun Offensive", 4, 8, "[70] Open For Business", 250, {["Bloodberry"] = 5}, FIZ_LIMIT_TYPE_SSO, 4, 5, nil, nil, nil, 2) -- Phase 4c onwards
	end
end

function FIZ_AddMob(faction, from, to, name, rep, zone, limit)
	if not faction then return end
	if not from then return end
	if not to then return end
	if not name then return end
	if not rep then return end
	if (type(rep) ~= "number") then return end
	if ((from<1) or (from>8)) then return end
	if ((to<1) or (to>8)) then return end
	if (from > to) then return end
	faction = string.lower(faction)

	if FIZ_IsHuman then rep = rep * 1.1 end

	for standing = from,to do
		if (not FIZ_FactionGain[faction]) then
			FIZ_FactionGain[faction] = {}
		end
		if (not FIZ_FactionGain[faction][standing]) then
			FIZ_FactionGain[faction][standing] = {}
		end
		if (not FIZ_FactionGain[faction][standing].mobs) then
			FIZ_FactionGain[faction][standing].mobs = {}
			FIZ_FactionGain[faction][standing].mobs.data = {}
			FIZ_FactionGain[faction][standing].mobs.count = 0
		else
			FIZ_FactionGain[faction][standing].mobs.count = FIZ_FactionGain[faction][standing].mobs.count + 1
		end
		FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count] = {}
		FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count].name = name
		FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count].rep = rep
		FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count].zone = zone
		FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count].maxStanding = to
		if ((standing == to) and limit) then
			FIZ_FactionGain[faction][standing].mobs.data[FIZ_FactionGain[faction][standing].mobs.count].limit = limit
		end

		FIZ_Debug("Added mob ["..name.."] for faction ["..faction.."] and standing ["..getglobal("FACTION_STANDING_LABEL"..standing).."]")
	end
end

function FIZ_AddQuest(faction, from, to, name, rep, itemList, limitType, arg1, arg2, arg3, arg4, arg5, arg6)
	if not faction then return end
	if not from then return end
	if not to then return end
	if not name then return end
	if not rep then return end
	if (type(rep) ~= "number") then return end
	if ((from<1) or (from>8)) then return end
	if ((to<1) or (to>8)) then return end
	if (from > to) then return end
	faction = string.lower(faction)

	if FIZ_IsHuman then rep = rep * 1.1 end

	for standing = from,to do
		if (not FIZ_FactionGain[faction]) then
			FIZ_FactionGain[faction] = {}
		end
		if (not FIZ_FactionGain[faction][standing]) then
			FIZ_FactionGain[faction][standing] = {}
		end
		if (not FIZ_FactionGain[faction][standing].quests) then
			FIZ_FactionGain[faction][standing].quests = {}
			FIZ_FactionGain[faction][standing].quests.data = {}
			FIZ_FactionGain[faction][standing].quests.count = 0
		else
			FIZ_FactionGain[faction][standing].quests.count = FIZ_FactionGain[faction][standing].quests.count + 1
		end
		FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count] = {}
		FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].name = name
		FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].rep = rep
		FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].maxStanding = to
		if (itemList) then
			FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].items = {}
			for item in pairs(itemList) do
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].items[item] = itemList[item]
			end
		end
		if ((standing == to) and limit) then
			FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].limit = limit
		end
		if (limitType ~= nil) then
			if (limitType == FIZ_LIMIT_TYPE_HERB or
			    limitType == FIZ_LIMIT_TYPE_MINE or
			    limitType == FIZ_LIMIT_TYPE_SKIN or
			    limitType == FIZ_LIMIT_TYPE_GATHER) then
			    	FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].profession = limitType
			elseif (limitType == FIZ_LIMIT_TYPE_SSO and arg1 and arg2) then
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].sso = true
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].fromPhase = arg1
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].toPhase = arg2
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].phase2b = arg3
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].phase3b = arg4
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].phase4b = arg5
				FIZ_FactionGain[faction][standing].quests.data[FIZ_FactionGain[faction][standing].quests.count].phase4c = arg6
			end
		end

		FIZ_Debug("Added quest ["..name.."] for faction ["..faction.."] and standing ["..getglobal("FACTION_STANDING_LABEL"..standing).."]")
	end
end

function FIZ_AddInstance(faction, from, to, name, rep, heroic)
	if not faction then return end
	if not from then return end
	if not to then return end
	if not name then return end
	if not rep then return end
	if (type(rep) ~= "number") then return end
	if ((from<1) or (from>8)) then return end
	if ((to<1) or (to>8)) then return end
	if (from > to) then return end
	faction = string.lower(faction)

	if FIZ_IsHuman then rep = rep * 1.1 end

	for standing = from,to do
		if (not FIZ_FactionGain[faction]) then
			FIZ_FactionGain[faction] = {}
		end
		if (not FIZ_FactionGain[faction][standing]) then
			FIZ_FactionGain[faction][standing] = {}
		end
		if (not FIZ_FactionGain[faction][standing].instance) then
			FIZ_FactionGain[faction][standing].instance = {}
			FIZ_FactionGain[faction][standing].instance.data = {}
			FIZ_FactionGain[faction][standing].instance.count = 0
		else
			FIZ_FactionGain[faction][standing].instance.count = FIZ_FactionGain[faction][standing].instance.count + 1
		end
		FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count] = {}
		FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].name = name
		FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].rep = rep
		FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].maxStanding = to
		if (heroic) then
			FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].level = FIZ_TXT.heroic
		else
			FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].level = FIZ_TXT.normal
		end
		if ((standing == to) and limit) then
			FIZ_FactionGain[faction][standing].instance.data[FIZ_FactionGain[faction][standing].instance.count].limit = limit
		end

		FIZ_Debug("Added instance ["..name.."] for faction ["..faction.."] and standing ["..getglobal("FACTION_STANDING_LABEL"..standing).."]")
	end
end

function FIZ_AddItems(faction, from, to, rep, itemList)
	if not faction then return end
	if not from then return end
	if not to then return end
	if not rep then return end
	if not itemList then return end
	if (type(rep) ~= "number") then return end
	if ((from<1) or (from>8)) then return end
	if ((to<1) or (to>8)) then return end
	if (from > to) then return end
	faction = string.lower(faction)

	if FIZ_IsHuman then rep = rep * 1.1 end

	local itemString = ""
	for standing = from,to do
		if (not FIZ_FactionGain[faction]) then
			FIZ_FactionGain[faction] = {}
		end
		if (not FIZ_FactionGain[faction][standing]) then
			FIZ_FactionGain[faction][standing] = {}
		end
		if (not FIZ_FactionGain[faction][standing].items) then
			FIZ_FactionGain[faction][standing].items = {}
			FIZ_FactionGain[faction][standing].items.data = {}
			FIZ_FactionGain[faction][standing].items.count = 0
		else
			FIZ_FactionGain[faction][standing].items.count = FIZ_FactionGain[faction][standing].items.count + 1
		end
		FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count] = {}
		FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count].rep = rep
		FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count].maxStanding = to
		if (itemList) then
			FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count].items = {}
			for item in pairs(itemList) do
				if itemString ~= "" then itemString = itemString..", " end
				itemString = itemString..itemList[item].."x "..item
				FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count].items[item] = itemList[item]
			end
		end
		if ((standing == to) and limit) then
			FIZ_FactionGain[faction][standing].items.data[FIZ_FactionGain[faction][standing].items.count].limit = limit
		end

		FIZ_Debug("AddItem: Added items ["..itemString.."] for faction ["..faction.."] and standing ["..getglobal("FACTION_STANDING_LABEL"..standing).."]")
	end
end


-----------------------------------
-- _10_ New Hook Functions       --
-----------------------------------
function FIZ_GetFactionInfo(factionIndex)
	-- get original information
	local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = FIZ_Orig_GetFactionInfo(factionIndex)

	-- normalize values to within standing
	local normMax = barMax-barMin
	local normCurrent = barValue-barMin

	-- add missing reputation
	if (FIZ_Data.ShowMissing and isHeader and ((normMax-normCurrent)>0)) then
		name = name.." ("..normMax-normCurrent..")"
	end

	-- return values
	return name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;
end

function FIZ_ReputationFrame_Update()
	if FIZ_Data.SortByStanding then
		FIZ_ReputationFrame_UpdateByStanding()
		return
	end

	local numFactions = GetNumFactions();
	local factionIndex, factionName, factionCheck, factionStanding, factionBar, factionHeader, color, tooltipStanding;
	local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;
	local atWarIndicator, rightBarTexture;

	-- Update scroll frame
	if ( not FauxScrollFrame_Update(ReputationListScrollFrame, numFactions, NUM_FACTIONS_DISPLAYED, REPUTATIONFRAME_FACTIONHEIGHT ) ) then
		ReputationListScrollFrameScrollBar:SetValue(0);
	end
	local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame);

	if (FIZ_Data.ShowMissing) then
		ReputationFrameStandingLabel:SetText(FIZ_Orig_StandingText.." "..FIZ_TXT.missing)
	else
		ReputationFrameStandingLabel:SetText(FIZ_Orig_StandingText)
	end

	if (FIZ_Data.ShowPreviewRep) then
		FIZ_ParseBagContent()
	end

	local gender = UnitSex("player");
	for i=1, NUM_FACTIONS_DISPLAYED, 1 do
		factionIndex = factionOffset + i;
		factionBar = getglobal("ReputationBar"..i);
		factionBarPreview = getglobal("FIZ_StatusBar"..i);
		factionHeader = getglobal("ReputationHeader"..i);
		factionCheck = getglobal("ReputationBar"..i.."Check");
		if ( factionIndex <= numFactions ) then
			name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex);

			if (not FIZ_SSO_WARNED) then
				FIZ_SSOWarning(name)
			end

			if ( isHeader ) then
				factionHeader:SetText(name);
				if ( isCollapsed ) then
					factionHeader:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
				else
					factionHeader:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
				end
				factionHeader.index = factionIndex;
				factionHeader.isCollapsed = isCollapsed;
				factionBar:Hide();
				factionBarPreview:Hide()
				factionHeader:Show();
				factionCheck:Hide();
			else
				factionStanding = GetText("FACTION_STANDING_LABEL"..standingID, gender);
				factionName = getglobal("ReputationBar"..i.."FactionName");
				factionName:SetText(name);
				--getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionStanding);	-- moved down

				atWarIndicator = getglobal("ReputationBar"..i.."AtWarCheck");
				rightBarTexture = getglobal("ReputationBar"..i.."ReputationBarRight");

				if ( atWarWith ) then
					atWarIndicator:Show();
				else
					atWarIndicator:Hide();
				end

				-- Normalize values
				local origBarValue = barValue
				barMax = barMax - barMin;
				barValue = barValue - barMin;
				barMin = 0;

				factionBar.id = factionIndex;

				--factionBar.standingText = factionStanding;	-- replaced
				if (FIZ_Data.ShowMissing) then
					factionBar.standingText = factionStanding.." ("..barMax - barValue..")";
				else
					factionBar.standingText = factionStanding;
				end
				getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionBar.standingText);

				factionBar.tooltip = HIGHLIGHT_FONT_COLOR_CODE.." "..barValue.." / "..barMax..FONT_COLOR_CODE_CLOSE;
				factionBar:SetMinMaxValues(0, barMax);
				factionBar:SetValue(barValue);
				color = FACTION_BAR_COLORS[standingID];
				factionBar:SetStatusBarColor(color.r, color.g, color.b);
				factionBar:SetID(factionIndex);
				factionBar:Show();
				factionHeader:Hide();

				local previewValue = 0
				if (FIZ_Data.ShowPreviewRep) then
					previewValue = FIZ_GetReadyReputation(factionIndex)
				end
				if (previewValue > 0) then
					factionBarPreview:Show()
					factionBarPreview:SetMinMaxValues(0, barMax)
					previewValue = previewValue + barValue
					if (previewValue > barMax) then previewValue = barMax end
					factionBarPreview:SetValue(previewValue)
					factionBarPreview:SetID(factionIndex)
					factionBarPreview:SetStatusBarColor(0.8, 0.8, 0.8, 0.5)
				else
					factionBarPreview:Hide()
				end

				-- Show a checkmark if this faction is being watched
				if ( isWatched ) then
					factionCheck:Show();
					factionName:SetWidth(100);
					factionCheck:SetPoint("LEFT", factionName, "LEFT", factionName:GetStringWidth(), 0);
				else
					factionCheck:Hide();
					factionName:SetWidth(110);
				end

				-- Update details if this is the selected faction
				if ( factionIndex == GetSelectedFaction() ) then
					if ( ReputationDetailFrame:IsVisible() ) then
						ReputationDetailFactionName:SetText(name);
						ReputationDetailFactionDescription:SetText(description);
						if ( atWarWith ) then
							ReputationDetailAtWarCheckBox:SetChecked(1);
						else
							ReputationDetailAtWarCheckBox:SetChecked(nil);
						end
						if ( canToggleAtWar ) then
							ReputationDetailAtWarCheckBox:Enable();
							ReputationDetailAtWarCheckBoxText:SetTextColor(RED_FONT_COLOR.r, RED_FONT_COLOR.g, RED_FONT_COLOR.b);
						else
							ReputationDetailAtWarCheckBox:Disable();
							ReputationDetailAtWarCheckBoxText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);

						end
						if ( IsFactionInactive(factionIndex) ) then
							ReputationDetailInactiveCheckBox:SetChecked(1);
						else
							ReputationDetailInactiveCheckBox:SetChecked(nil);
						end
						if ( isWatched ) then
							ReputationDetailMainScreenCheckBox:SetChecked(1);
						else
							ReputationDetailMainScreenCheckBox:SetChecked(nil);
						end
					end
					if ( FIZ_ReputationDetailFrame:IsVisible() ) then
						FIZ_BuildUpdateList()

						FIZ_ReputationDetailFactionName:SetText(name);
						FIZ_ReputationDetailFactionDescription:SetText(description);

						FIZ_ReputationDetailStandingName:SetText(factionStanding)
						local color = FACTION_BAR_COLORS[standingID]
						FIZ_ReputationDetailStandingName:SetTextColor(color.r, color.g, color.b)

						FIZ_ReputationDetailStandingCurrent:SetText(FIZ_TXT.currentRep)
						FIZ_ReputationDetailStandingNeeded:SetText(FIZ_TXT.neededRep)
						FIZ_ReputationDetailStandingMissing:SetText(FIZ_TXT.missingRep)
						FIZ_ReputationDetailStandingBag:SetText(FIZ_TXT.repInBag)
						FIZ_ReputationDetailStandingBagBank:SetText(FIZ_TXT.repInBagBank)
						FIZ_ReputationDetailStandingQuests:SetText(FIZ_TXT.repInQuest)
						FIZ_ReputationDetailStandingGained:SetText(FIZ_TXT.factionGained)

						FIZ_ReputationDetailStandingCurrentValue:SetText(barValue)
						FIZ_ReputationDetailStandingNeededValue:SetText(barMax)
						FIZ_ReputationDetailStandingMissingValue:SetText(barMax-barValue)
						FIZ_ReputationDetailStandingBagValue:SetText(FIZ_CurrentRepInBag)
						FIZ_ReputationDetailStandingBagBankValue:SetText(FIZ_CurrentRepInBagBank)
						FIZ_ReputationDetailStandingQuestsValue:SetText(FIZ_CurrentRepInQuest)
						if (FIZ_StoredRep and FIZ_StoredRep[name] and FIZ_StoredRep[name].origRep) then
							FIZ_ReputationDetailStandingGainedValue:SetText(string.format("%d", origBarValue-FIZ_StoredRep[name].origRep))
						else
							FIZ_ReputationDetailStandingGainedValue:SetText("")
						end

						if (standingID <8) then
							color = FACTION_BAR_COLORS[standingID+1]
							--FIZ_ReputationDetailStandingNext:SetText(FIZ_TXT.nextLevel)
							FIZ_ReputationDetailStandingNextValue:SetText("(--> "..GetText("FACTION_STANDING_LABEL"..standingID+1, gender)..")")
							FIZ_ReputationDetailStandingNextValue:SetTextColor(color.r, color.g, color.b)
						else
							--FIZ_ReputationDetailStandingNext:SetText("")
							FIZ_ReputationDetailStandingNextValue:SetText("")
						end

						if ( atWarWith ) then
							FIZ_ReputationDetailAtWarCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailAtWarCheckBox:SetChecked(nil);
						end
						if ( canToggleAtWar ) then
							FIZ_ReputationDetailAtWarCheckBox:Enable();
							FIZ_ReputationDetailAtWarCheckBoxText:SetTextColor(RED_FONT_COLOR.r, RED_FONT_COLOR.g, RED_FONT_COLOR.b);
						else
							FIZ_ReputationDetailAtWarCheckBox:Disable();
							FIZ_ReputationDetailAtWarCheckBoxText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);

						end
						if ( IsFactionInactive(factionIndex) ) then
							FIZ_ReputationDetailInactiveCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailInactiveCheckBox:SetChecked(nil);
						end
						if ( isWatched ) then
							FIZ_ReputationDetailMainScreenCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailMainScreenCheckBox:SetChecked(nil);
						end
					end
					getglobal("ReputationBar"..i.."Highlight1"):Show();
					getglobal("ReputationBar"..i.."Highlight2"):Show();
				else
					getglobal("ReputationBar"..i.."Highlight1"):Hide();
					getglobal("ReputationBar"..i.."Highlight2"):Hide();
				end
			end
		else
			factionHeader:Hide();
			factionBar:Hide();
		end
	end
	if ( GetSelectedFaction() == 0 ) then
		ReputationDetailFrame:Hide();
		FIZ_ReputationDetailFrame:Hide();
	end
end

function FIZ_ReputationFrame_UpdateByStanding()
	-- parse original faction table and order by standing
	local numFactions = GetNumFactions();
	local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;

	local standings = {}
	for i=1,numFactions do
		name, description, standingID, _, barMax, barValue, _, _, isHeader = GetFactionInfo(i);

		if (not FIZ_SSO_WARNED) then
			FIZ_SSOWarning(name)
		end

		if (not isHeader) then	-- only list factions, not faction groups headers
			if not standings[standingID] then
				standings[standingID] = {}
			end
			local size = FIZ_TableSize(standings[standingID])
			local entry = {}
			local inserted = false
			entry.missing = barMax-barValue
			entry.i = i
			if (size) then
				for j=1,size do
					if (not inserted) then
						if (standings[standingID][j].missing > entry.missing) then
							table.insert(standings[standingID], j, entry);
							inserted = true
						end
					end
				end
				if (not inserted) then
					table.insert(standings[standingID], entry)
				end
			else
				table.insert(standings[standingID], entry)
			end
		end
	end

	-- find number of elements to display
	local numFactions = 0
	FIZ_Entries = {}
	if (not FIZ_Collapsed) then
		FIZ_Collapsed = {}
	end
	for i=8,1, -1 do
	--for i in pairs(standings) do
		if FIZ_TableSize(standings[i]) then
			if (standings[i]) then
				numFactions = numFactions + 1 -- count standing as header
				FIZ_Entries[numFactions] = {}
				FIZ_Entries[numFactions].header = true
				FIZ_Entries[numFactions].i = i	-- this is the standingID
				if (not FIZ_Collapsed[i]) then
					for j in pairs(standings[i]) do
						numFactions = numFactions + 1 -- count each faction in the current standing
						FIZ_Entries[numFactions] = {}
						FIZ_Entries[numFactions].header = false
						FIZ_Entries[numFactions].i = standings[i][j].i -- this is the index into the faction table
					end
				end
			end
		end
	end

	local factionIndex, factionName, factionCheck, factionStanding, factionBar, factionHeader, color, tooltipStanding;
	local atWarIndicator, rightBarTexture;

	-- Update scroll frame
	if ( not FauxScrollFrame_Update(ReputationListScrollFrame, numFactions, NUM_FACTIONS_DISPLAYED, REPUTATIONFRAME_FACTIONHEIGHT ) ) then
		ReputationListScrollFrameScrollBar:SetValue(0);
	end
	local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame);

	if (FIZ_Data.ShowMissing) then
		ReputationFrameStandingLabel:SetText(FIZ_Orig_StandingText.." "..FIZ_TXT.missing)
	else
		ReputationFrameStandingLabel:SetText(FIZ_Orig_StandingText)
	end

	if (FIZ_Data.ShowPreviewRep) then
		FIZ_ParseBagContent()
	end

	local gender = UnitSex("player");
	for i=1, NUM_FACTIONS_DISPLAYED, 1 do
		factionIndex = factionOffset + i;
		factionBar = getglobal("ReputationBar"..i);
		factionBarPreview = getglobal("FIZ_StatusBar"..i);
		factionHeader = getglobal("ReputationHeader"..i);
		factionCheck = getglobal("ReputationBar"..i.."Check");

		if ( factionIndex <= numFactions ) then
			if (FIZ_Entries[factionIndex].header) then
				-- display the standingId as header
				if (FIZ_Entries[factionIndex].i == 8) then
					factionHeader:SetText(GetText("FACTION_STANDING_LABEL"..FIZ_Entries[factionIndex].i, gender));
				else
					factionHeader:SetText(GetText("FACTION_STANDING_LABEL"..FIZ_Entries[factionIndex].i, gender).." -> "..GetText("FACTION_STANDING_LABEL"..FIZ_Entries[factionIndex].i+1, gender));
				end
				if ( FIZ_Collapsed[FIZ_Entries[factionIndex].i] ) then
					factionHeader:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
				else
					factionHeader:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
				end
				factionHeader.index = factionIndex
				factionHeader.isCollapsed = FIZ_Collapsed[FIZ_Entries[factionIndex].i];
				factionBar:Hide();
				factionBarPreview:Hide()
				factionHeader:Show();
				factionCheck:Hide();
			else
				-- get the info for this faction
				name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(FIZ_Entries[factionIndex].i);
				factionStanding = GetText("FACTION_STANDING_LABEL"..standingID, gender);
				factionName = getglobal("ReputationBar"..i.."FactionName");
				factionName:SetText(name);
				--getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionStanding);	-- moved down

				atWarIndicator = getglobal("ReputationBar"..i.."AtWarCheck");
				rightBarTexture = getglobal("ReputationBar"..i.."ReputationBarRight");

				if ( atWarWith ) then
					atWarIndicator:Show();
				else
					atWarIndicator:Hide();
				end

				-- Normalize values
				local origBarValue = barValue
				barMax = barMax - barMin;
				barValue = barValue - barMin;
				barMin = 0;

				factionBar.id = FIZ_Entries[factionIndex].i;

				--factionBar.standingText = factionStanding;	-- replaced
				if (FIZ_Data.ShowMissing) then
					factionBar.standingText = factionStanding.." ("..barMax - barValue..")";
				else
					factionBar.standingText = factionStanding;
				end
				getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionBar.standingText);

				factionBar.tooltip = HIGHLIGHT_FONT_COLOR_CODE.." "..barValue.." / "..barMax..FONT_COLOR_CODE_CLOSE;
				factionBar:SetMinMaxValues(0, barMax);
				factionBar:SetValue(barValue);
				color = FACTION_BAR_COLORS[standingID];
				factionBar:SetStatusBarColor(color.r, color.g, color.b);
				factionBar:SetID(FIZ_Entries[factionIndex].i);
				factionBar:Show();
				factionHeader:Hide();

				local previewValue = 0
				if (FIZ_Data.ShowPreviewRep) then
					previewValue = FIZ_GetReadyReputation(FIZ_Entries[factionIndex].i)
				end
				if (previewValue > 0) then
					factionBarPreview:Show()
					factionBarPreview:SetMinMaxValues(0, barMax)
					previewValue = previewValue + barValue
					if (previewValue > barMax) then previewValue = barMax end
					factionBarPreview:SetValue(previewValue)
					factionBarPreview:SetID(factionIndex)
					factionBarPreview:SetStatusBarColor(0.8, 0.8, 0.8, 0.5)
				else
					factionBarPreview:Hide()
				end

				-- Show a checkmark if this faction is being watched
				if ( isWatched ) then
					factionCheck:Show();
					factionName:SetWidth(100);
					factionCheck:SetPoint("LEFT", factionName, "LEFT", factionName:GetStringWidth(), 0);
				else
					factionCheck:Hide();
					factionName:SetWidth(110);
				end

				-- Update details if this is the selected faction
				if ( FIZ_Entries[factionIndex].i == GetSelectedFaction() ) then
					if ( ReputationDetailFrame:IsVisible() ) then
						ReputationDetailFactionName:SetText(name);
						ReputationDetailFactionDescription:SetText(description);
						if ( atWarWith ) then
							ReputationDetailAtWarCheckBox:SetChecked(1);
						else
							ReputationDetailAtWarCheckBox:SetChecked(nil);
						end
						if ( canToggleAtWar ) then
							ReputationDetailAtWarCheckBox:Enable();
							ReputationDetailAtWarCheckBoxText:SetTextColor(RED_FONT_COLOR.r, RED_FONT_COLOR.g, RED_FONT_COLOR.b);
						else
							ReputationDetailAtWarCheckBox:Disable();
							ReputationDetailAtWarCheckBoxText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);

						end
						if ( IsFactionInactive(FIZ_Entries[factionIndex].i) ) then
							ReputationDetailInactiveCheckBox:SetChecked(1);
						else
							ReputationDetailInactiveCheckBox:SetChecked(nil);
						end
						if ( isWatched ) then
							ReputationDetailMainScreenCheckBox:SetChecked(1);
						else
							ReputationDetailMainScreenCheckBox:SetChecked(nil);
						end
					end
					if ( FIZ_ReputationDetailFrame:IsVisible() ) then
						FIZ_BuildUpdateList()

						FIZ_ReputationDetailFactionName:SetText(name);
						FIZ_ReputationDetailFactionDescription:SetText(description);

						FIZ_ReputationDetailStandingName:SetText(factionStanding)
						local color = FACTION_BAR_COLORS[standingID]
						FIZ_ReputationDetailStandingName:SetTextColor(color.r, color.g, color.b)

						FIZ_ReputationDetailStandingCurrent:SetText(FIZ_TXT.currentRep)
						FIZ_ReputationDetailStandingNeeded:SetText(FIZ_TXT.neededRep)
						FIZ_ReputationDetailStandingMissing:SetText(FIZ_TXT.missingRep)
						FIZ_ReputationDetailStandingBag:SetText(FIZ_TXT.repInBag)
						FIZ_ReputationDetailStandingBagBank:SetText(FIZ_TXT.repInBagBank)
						FIZ_ReputationDetailStandingQuests:SetText(FIZ_TXT.repInQuest)
						FIZ_ReputationDetailStandingGained:SetText(FIZ_TXT.factionGained)

						FIZ_ReputationDetailStandingCurrentValue:SetText(barValue)
						FIZ_ReputationDetailStandingNeededValue:SetText(barMax)
						FIZ_ReputationDetailStandingMissingValue:SetText(barMax-barValue)
						FIZ_ReputationDetailStandingBagValue:SetText(FIZ_CurrentRepInBag)
						FIZ_ReputationDetailStandingBagBankValue:SetText(FIZ_CurrentRepInBagBank)
						FIZ_ReputationDetailStandingQuestsValue:SetText(FIZ_CurrentRepInQuest)
						if (FIZ_StoredRep and FIZ_StoredRep[name] and FIZ_StoredRep[name].origRep) then
							FIZ_ReputationDetailStandingGainedValue:SetText(string.format("%d", origBarValue-FIZ_StoredRep[name].origRep))
						else
							FIZ_ReputationDetailStandingGainedValue:SetText("")
						end

						if (standingID <8) then
							color = FACTION_BAR_COLORS[standingID+1]
							--FIZ_ReputationDetailStandingNext:SetText(FIZ_TXT.nextLevel)
							FIZ_ReputationDetailStandingNextValue:SetText("(--> "..GetText("FACTION_STANDING_LABEL"..standingID+1, gender)..")")
							FIZ_ReputationDetailStandingNextValue:SetTextColor(color.r, color.g, color.b)
						else
							--FIZ_ReputationDetailStandingNext:SetText("")
							FIZ_ReputationDetailStandingNextValue:SetText("")
						end

						if ( atWarWith ) then
							FIZ_ReputationDetailAtWarCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailAtWarCheckBox:SetChecked(nil);
						end
						if ( canToggleAtWar ) then
							FIZ_ReputationDetailAtWarCheckBox:Enable();
							FIZ_ReputationDetailAtWarCheckBoxText:SetTextColor(RED_FONT_COLOR.r, RED_FONT_COLOR.g, RED_FONT_COLOR.b);
						else
							FIZ_ReputationDetailAtWarCheckBox:Disable();
							FIZ_ReputationDetailAtWarCheckBoxText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);

						end
						if ( IsFactionInactive(FIZ_Entries[factionIndex].i) ) then
							FIZ_ReputationDetailInactiveCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailInactiveCheckBox:SetChecked(nil);
						end
						if ( isWatched ) then
							FIZ_ReputationDetailMainScreenCheckBox:SetChecked(1);
						else
							FIZ_ReputationDetailMainScreenCheckBox:SetChecked(nil);
						end
					end
					getglobal("ReputationBar"..i.."Highlight1"):Show();
					getglobal("ReputationBar"..i.."Highlight2"):Show();
				else
					getglobal("ReputationBar"..i.."Highlight1"):Hide();
					getglobal("ReputationBar"..i.."Highlight2"):Hide();
				end
			end
		else
			factionHeader:Hide();
			factionBar:Hide();
		end
	end
	if ( GetSelectedFaction() == 0 ) then
		ReputationDetailFrame:Hide();
		FIZ_ReputationDetailFrame:Hide();
	end
end

function FIZ_ExpandFactionHeader(index)
	if not FIZ_Entries then return end

	if FIZ_Data.SortByStanding then
		if not FIZ_Entries[index] then return end
		FIZ_Collapsed[FIZ_Entries[index].i] = nil
		FIZ_ReputationFrame_UpdateByStanding()
	else
		FIZ_Orig_ExpandFactionHeader(index)
	end
end

function FIZ_CollapseFactionHeader(index)
	if not FIZ_Entries then return end

	if FIZ_Data.SortByStanding then
		if not FIZ_Entries[index] then return end
		FIZ_Collapsed[FIZ_Entries[index].i] = true
		FIZ_ReputationFrame_UpdateByStanding()
	else
		FIZ_Orig_CollapseFactionHeader(index)
	end
end

function FIZ_ReputationBar_OnClick()
	if ((ReputationDetailFrame:IsVisible() or FIZ_ReputationDetailFrame:IsVisible()) and (GetSelectedFaction() == this.id) ) then
		ReputationDetailFrame:Hide();
		FIZ_ReputationDetailFrame:Hide();
		PlaySound("igMainMenuOptionCheckBoxOff");
	else
		SetSelectedFaction(this.id);
		if (FIZ_Data.ExtendDetails) then
			FIZ_ReputationDetailFrame:Show();
			ReputationDetailFrame:Hide();
			FIZ_OptionsFrame:Hide()

			FIZ_BuildUpdateList()
			FIZ_UpdateList_Update()
		else
			ReputationDetailFrame:Show();
			FIZ_ReputationDetailFrame:Hide();
			FIZ_OptionsFrame:Hide()
		end
		PlaySound("igMainMenuOptionCheckBoxOn");
		ReputationFrame_Update();
	end
end

FIZ_UPDATE_LIST_HEIGHT = 13

function FIZ_UpdateList_Update()

	if (not FIZ_ReputationDetailFrame:IsVisible()) then return end

	FIZ_UpdateListScrollFrame:Show()
	FIZ_ShowQuestButton:SetChecked(FIZ_Data.ShowQuests)
	FIZ_ShowItemsButton:SetChecked(FIZ_Data.ShowItems)
	FIZ_ShowMobsButton:SetChecked(FIZ_Data.ShowMobs)
	FIZ_ShowInstancesButton:SetChecked(FIZ_Data.ShowInstances)

	FIZ_ShowQuestButtonText:SetText(FIZ_TXT.showQuests)
	FIZ_ShowItemsButtonText:SetText(FIZ_TXT.showItems)
	FIZ_ShowMobsButtonText:SetText(FIZ_TXT.showMobs)
	FIZ_ShowInstancesButtonText:SetText(FIZ_TXT.showInstances)
	FIZ_ShowAllButton:SetText(FIZ_TXT.showAll)
	FIZ_ShowNoneButton:SetText(FIZ_TXT.showNone)
	FIZ_ExpandButton:SetText(FIZ_TXT.expand)
	FIZ_CollapseButton:SetText(FIZ_TXT.collapse)

	FIZ_SupressNoneFactionButton:SetText(FIZ_TXT.supressNoneFaction)
	FIZ_SupressNoneGlobalButton:SetText(FIZ_TXT.supressNoneGlobal)
	FIZ_ReputationDetailSuppressHint:SetText(FIZ_TXT.suppressHint)

	local numEntries, highestVisible = FIZ_GetUpdateListSize()

	-- Update scroll frame
	if ( not FauxScrollFrame_Update(FIZ_UpdateListScrollFrame, numEntries, FIZ_UPDATE_LIST_HEIGHT, 16 ) ) then
		FIZ_UpdateListScrollFrameScrollBar:SetValue(0);
	end
	local entryOffset = FauxScrollFrame_GetOffset(FIZ_UpdateListScrollFrame);

	local entryIndex
	local entryFrameName, entryFrame, entryTexture
	local entryLabel, entryName, entryRep, entryTimes
	local entryItemTimes, entryItemName, entryItemTotal
	local postfix

	local haveInfo = false;
	entryIndex = 1
	local i = 0
	local max = FIZ_TableSize(FIZ_UpdateList)
	while(i<entryOffset and entryIndex<max) do
		if FIZ_UpdateList[entryIndex].isShown then
			i = i + 1
		end
		entryIndex = entryIndex + 1
	end
	for i=1, FIZ_UPDATE_LIST_HEIGHT, 1 do
		while ((entryIndex <= highestVisible) and not FIZ_UpdateList[entryIndex].isShown) do
			entryIndex = entryIndex + 1
		end
		if (entryIndex <= highestVisible) then
			haveInfo = true

			entryFrameName = "FIZ_UpdateEntry"..i
			entryFrame = getglobal(entryFrameName)
			entryTexture = getglobal(entryFrameName.."Texture")

			entryLabel = getglobal(entryFrameName.."Label")
			entryName = getglobal(entryFrameName.."Name")
			entryRep = getglobal(entryFrameName.."Rep")
			entryTimes = getglobal(entryFrameName.."Times")

			entryItemTimes = getglobal(entryFrameName.."ItemTimes")
			entryItemName = getglobal(entryFrameName.."ItemName")
			entryItemTotal = getglobal(entryFrameName.."TotalTimes")

			if (entryFrame) then
				entryFrame:Show()
				entryFrame.id = FIZ_UpdateList[entryIndex].index
				entryFrame.tooltipHead = FIZ_UpdateList[entryIndex].tooltipHead
				entryFrame.tooltipTip = FIZ_UpdateList[entryIndex].tooltipTip
				entryFrame.tooltipDetails = FIZ_UpdateList[entryIndex].tooltipDetails
			end

			local color = ""
			if (FIZ_UpdateList[entryIndex].highlight) then
				color = FIZ_HIGHLIGHT_COLOUR
			elseif (FIZ_UpdateList[entryIndex].suppress) then
				color = FIZ_SUPPRESS_COLOUR
			elseif (FIZ_UpdateList[entryIndex].lowlight) then
				color = FIZ_LOWLIGHT_COLOUR
			end

			if (FIZ_UpdateList[entryIndex].type ~= "") then
				-- normal entry
				if (FIZ_UpdateList[entryIndex].suppress) then
					postfix = ""
				else
					postfix = "-Green"
				end
				if (FIZ_UpdateList[entryIndex].hasList) then
					if (FIZ_UpdateList[entryIndex].listShown) then
						entryTexture:SetTexture("Interface\\Addons\\Factionizer\\UI-MinusButton-Up"..postfix..".blp")
					else
						entryTexture:SetTexture("Interface\\Addons\\Factionizer\\UI-PlusButton-Up"..postfix..".blp")
					end
				else
					entryTexture:SetTexture("Interface\\Addons\\Factionizer\\UI-EmptyButton-Up"..postfix..".blp")
				end
				if (FIZ_UpdateList[entryIndex].canSuppress) then
					entryTexture:Show()
				else
					entryTexture:Hide()
				end

				entryLabel:Show()
				entryName:Show()
				entryRep:Show()
				entryTimes:Show()

				entryLabel:SetText(color..FIZ_UpdateList[entryIndex].type)
				entryName:SetText(color..FIZ_UpdateList[entryIndex].name)
				entryRep:SetText(color..FIZ_UpdateList[entryIndex].rep)
				entryTimes:SetText(color..FIZ_UpdateList[entryIndex].times)

				entryItemTimes:Hide()
				entryItemName:Hide()
				entryItemTotal:Hide()
			else
				-- item entry
				entryTexture:Hide()
				entryLabel:Hide()
				entryName:Hide()
				entryRep:Hide()
				entryTimes:Hide()

				entryItemTimes:Show()
				entryItemName:Show()

				entryItemTimes:SetText(color..FIZ_UpdateList[entryIndex].times)
				entryItemName:SetText(color..FIZ_UpdateList[entryIndex].name)
			end
			entryIndex = entryIndex + 1
		else
			getglobal("FIZ_UpdateEntry"..i):Hide()
		end
		if haveInfo then
			FIZ_NoInformationText:Hide()
		else
			FIZ_NoInformationText:SetText(FIZ_TXT.noInfo)
			FIZ_NoInformationText:Show()
		end
	end
end

function FIZ_UpdateEntryClick()
	if (FIZ_UpdateList[this.id] and FIZ_UpdateList[this.id].hasList) then
		if (FIZ_UpdateList[this.id].listShown) then
			FIZ_ShowUpdateEntry(this.id, false)
		else
			FIZ_ShowUpdateEntry(this.id, true)
		end
	end
end

function FIZ_UpdateEntrySuppress()
	if (FIZ_UpdateList[this.id]) then
		if (FIZ_UpdateList[this.id].type ~= "") then
			if (FIZ_UpdateList[this.id].faction and FIZ_UpdateList[this.id].originalName) then
				if (not FIZ_Suppressed) then
					FIZ_Suppressed = {}
				end
				if (not FIZ_Suppressed[FIZ_UpdateList[this.id].faction]) then
					FIZ_Suppressed[FIZ_UpdateList[this.id].faction] = {}
				end
				if (FIZ_Suppressed[FIZ_UpdateList[this.id].faction][FIZ_UpdateList[this.id].originalName]) then
					--FIZ_Print("No longer suppressing ["..FIZ_UpdateList[this.id].faction.."]["..FIZ_UpdateList[this.id].originalName.."]");
					FIZ_Suppressed[FIZ_UpdateList[this.id].faction][FIZ_UpdateList[this.id].originalName] = nil
				else
					--FIZ_Print("Suppressing ["..FIZ_UpdateList[this.id].faction.."]["..FIZ_UpdateList[this.id].originalName.."]");
					FIZ_Suppressed[FIZ_UpdateList[this.id].faction][FIZ_UpdateList[this.id].originalName] = true
				end
				FIZ_BuildUpdateList()
			end
		end
	end
end

function FIZ_SupressNone(allFactions)
	if (allFactions == true) then
		FIZ_Suppressed = {}
		FIZ_BuildUpdateList()
	else
		local factionIndex = GetSelectedFaction()
		local faction = GetFactionInfo(factionIndex)

		if (faction) then
			faction = string.lower(faction)
			if (FIZ_FactionMapping[faction]) then
				faction = FIZ_FactionMapping[faction]
			end

			if (not FIZ_Suppressed) then
				FIZ_Suppressed = {}
			end
			FIZ_Suppressed[faction] = {}
		end
		FIZ_BuildUpdateList()
	end
end

function FIZ_MouseButtonUp(button)
	if (button and button == "LeftButton") then
		FIZ_UpdateEntryClick()
	elseif (button and button == "RightButton") then
		FIZ_UpdateEntrySuppress()
	end
end

-----------------------------------
-- _11_ Prepare update entries   --
-----------------------------------
function FIZ_ParseBagContent()
	FIZ_ItemsCarried = {}

	for i = 0, NUM_BAG_SLOTS do
		local num = GetContainerNumSlots(i)
		for j = 1, num do
			local link = GetContainerItemLink(i, j)
			-- |cff9d9d9d|Hitem:7073:0:0:0:0:0:0:0|h[Broken Fang]|h|r
			if link then
				local count = GetItemCount(link)
				local _, _, itemString, itemName = string.find(link, "^|c%x+|H(.+)|h%[(.+)%]")
				if count and itemName then
					if (not FIZ_ItemsCarried[itemName]) then
						FIZ_ItemsCarried[itemName] = count
					end
				end
			end
		end
	end
end

function FIZ_ParseBankContent()
	if (not FIZ_Data.Bank) then FIZ_Data.Bank = {} end
	FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player] = {}

	local i = BANK_CONTAINER
	local num = GetContainerNumSlots(i)
	for j = 1, num do
		local link = GetContainerItemLink(i, j)
		-- |cff9d9d9d|Hitem:7073:0:0:0:0:0:0:0|h[Broken Fang]|h|r
		if link then
			local count = GetItemCount(link)
			local _, count = GetContainerItemInfo(i, j);
			local _, _, itemString, itemName = string.find(link, "^|c%x+|H(.+)|h%[(.+)%]")
			if count and itemName then
				if (FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName]) then
					FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] + count
				else
					FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] = count
				end
			end
		end
	end

	for i = NUM_BAG_SLOTS+NUM_BAG_SLOTS + NUM_BANKBAGSLOTS, NUM_BAG_SLOTS do
		local num = GetContainerNumSlots(i)
		for j = 1, num do
			local link = GetContainerItemLink(i, j)
			-- |cff9d9d9d|Hitem:7073:0:0:0:0:0:0:0|h[Broken Fang]|h|r
			if link then
				local count = GetItemCount(link)
				local _, count = GetContainerItemInfo(i, j);
				local _, _, itemString, itemName = string.find(link, "^|c%x+|H(.+)|h%[(.+)%]")
				if count and itemName then
					if (FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName]) then
						FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] + count
					else
						FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][itemName] = count
					end
				end
			end
		end
	end
end

function FIZ_BuildUpdateList()
	FIZ_UpdateList = {}
	FIZ_CurrentRepInBag = 0
	FIZ_CurrentRepInBagBank = 0
	FIZ_CurrentRepInQuest = 0
	local index = 1

	if (not FIZ_ReputationDetailFrame:IsVisible()) then
		return
	end

	FIZ_ParseBagContent()

	local factionIndex = GetSelectedFaction()
	local faction, description, standingId, barMin, barMax, barValue = GetFactionInfo(factionIndex)

	if (not FIZ_SSO_WARNED) then
		FIZ_SSOWarning(faction)
	end

	if (faction) then
		origFaction = faction
		faction = string.lower(faction)
		if (FIZ_FactionMapping[faction]) then
			faction = FIZ_FactionMapping[faction]
		end

		-- Normalize values
		local normMax = barMax - barMin
		local normCurrent = barValue - barMin
		local repToNext = barMax - barValue

		if (FIZ_FactionGain[faction]) then
			if (FIZ_FactionGain[faction][standingId]) then
				-- instances
				if (FIZ_FactionGain[faction][standingId].instance and FIZ_Data.ShowInstances) then
					for i = 0, FIZ_FactionGain[faction][standingId].instance.count do
						if (not FIZ_FactionGain[faction][standingId].instance.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].instance.data[i].limit)) then
							local toDo = string.format("%.2f", repToNext / FIZ_FactionGain[faction][standingId].instance.data[i].rep)
							if (FIZ_FactionGain[faction][standingId].instance.data[i].limit) then
								toDo = string.format("%.2f", (FIZ_FactionGain[faction][standingId].instance.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].instance.data[i].rep)
							end
							FIZ_UpdateList[index] = {}
							FIZ_UpdateList[index].type = FIZ_TXT.instanceShort
							FIZ_UpdateList[index].times = toDo.."x"
							FIZ_UpdateList[index].rep = string.format("%d", FIZ_FactionGain[faction][standingId].instance.data[i].rep)
							FIZ_UpdateList[index].hasList = false
							FIZ_UpdateList[index].listShown = nil
							FIZ_UpdateList[index].index = index
							FIZ_UpdateList[index].belongsTo = nil
							FIZ_UpdateList[index].isShown = true
							FIZ_UpdateList[index].name = FIZ_FactionGain[faction][standingId].instance.data[i].name.." ("..FIZ_FactionGain[faction][standingId].instance.data[i].level..")"

							FIZ_UpdateList[index].tooltipHead = FIZ_TXT.instanceHead
							FIZ_UpdateList[index].tooltipTip = FIZ_TXT.instanceTip

							FIZ_UpdateList[index].tooltipDetails = {}
							local x = 0
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.instance2
							FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_FactionGain[faction][standingId].instance.data[i].name
							x = x+1
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.mode
							FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_FactionGain[faction][standingId].instance.data[i].level
							x = x+1
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
							FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].rep
							x = x+1
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.timesToRun
							FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].times
							x = x+1
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = " "
							FIZ_UpdateList[index].tooltipDetails[x].r = " "
							x = x+1
							FIZ_UpdateList[index].tooltipDetails[x] = {}
							FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
							FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].instance.data[i].maxStanding)
							FIZ_UpdateList[index].tooltipDetails.count = x
							index = index + 1
						end
					end
				end

				-- mobs
				if (FIZ_FactionGain[faction][standingId].mobs and FIZ_Data.ShowMobs) then
					for i = 0, FIZ_FactionGain[faction][standingId].mobs.count do
						if (not FIZ_FactionGain[faction][standingId].mobs.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].mobs.data[i].limit)) then
							local toDo = ceil(repToNext / FIZ_FactionGain[faction][standingId].mobs.data[i].rep)
							if (FIZ_FactionGain[faction][standingId].mobs.data[i].limit) then
								toDo = ceil((FIZ_FactionGain[faction][standingId].mobs.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].mobs.data[i].rep)
							end
							FIZ_UpdateList[index] = {}
							FIZ_UpdateList[index].type = FIZ_TXT.mobShort
							FIZ_UpdateList[index].times = toDo.."x"
							FIZ_UpdateList[index].rep = string.format("%d", FIZ_FactionGain[faction][standingId].mobs.data[i].rep)
							FIZ_UpdateList[index].hasList = false
							FIZ_UpdateList[index].listShown = nil
							FIZ_UpdateList[index].index = index
							FIZ_UpdateList[index].belongsTo = nil
							FIZ_UpdateList[index].isShown = true
							FIZ_UpdateList[index].tooltipHead = FIZ_TXT.mobHead
							FIZ_UpdateList[index].tooltipTip = FIZ_TXT.mobTip
							if (FIZ_FactionGain[faction][standingId].mobs.data[i].zone) then
								FIZ_UpdateList[index].name = FIZ_FactionGain[faction][standingId].mobs.data[i].name.." ("..FIZ_FactionGain[faction][standingId].mobs.data[i].zone..")"
								FIZ_UpdateList[index].tooltipDetails = {}
								local x = 0
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.mob2
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_FactionGain[faction][standingId].mobs.data[i].name
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.location
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_FactionGain[faction][standingId].mobs.data[i].zone
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].rep
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.toDo
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].times
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = " "
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
								FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].mobs.data[i].maxStanding)
								FIZ_UpdateList[index].tooltipDetails.count = x
							else
								FIZ_UpdateList[index].name = FIZ_FactionGain[faction][standingId].mobs.data[i].name
								FIZ_UpdateList[index].tooltipDetails = {}
								local x = 0
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.mob2
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_FactionGain[faction][standingId].mobs.data[i].name
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].rep
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.toDo
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].times
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = " "
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
								FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].mobs.data[i].maxStanding)
								FIZ_UpdateList[index].tooltipDetails.count = x
							end
							index = index + 1
						end
					end
				end

				-- quests (may have items)
				local sum = 0
				local count = 0
				if (FIZ_FactionGain[faction][standingId].quests and FIZ_Data.ShowQuests) then
					for i = 0, FIZ_FactionGain[faction][standingId].quests.count do
						local showQuest = true

					    	if (FIZ_FactionGain[faction][standingId].quests.data[i].profession) then
					    		-- todo: create a list of known professions and keep them updated, do this outside this loop
						    	if ((FIZ_FactionGain[faction][standingId].quests.data[i].profession == FIZ_LIMIT_TYPE_HERB) and not FIZ_Herb) then
						    		-- if list of known professions does not contain herbology
						    		showQuest = false
					    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because you do not know herbalism")
						    	elseif ((FIZ_FactionGain[faction][standingId].quests.data[i].profession == FIZ_LIMIT_TYPE_SKIN) and not FIZ_Skin) then
						    		-- if list of known professions does not contain herbology
						    		showQuest = false
					    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because you do not know skinning")
						    	elseif ((FIZ_FactionGain[faction][standingId].quests.data[i].profession == FIZ_LIMIT_TYPE_MINE) and not FIZ_Mine) then
						    		-- if list of known professions does not contain herbology
						    		showQuest = false
					    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because you do not know mining")
						    	elseif ((FIZ_FactionGain[faction][standingId].quests.data[i].profession == FIZ_LIMIT_TYPE_GATHER) and not (FIZ_Herb or FIZ_Skin or FIZ_Mine)) then
						    		-- no gathering profession
						    		showQuest = false
						    	else
						    		-- unexpected limit -> ignore this and still show quest
						    	end
					    	end

						if (FIZ_FactionGain[faction][standingId].quests.data[i].sso and
						    FIZ_FactionGain[faction][standingId].quests.data[i].fromPhase and
						    FIZ_FactionGain[faction][standingId].quests.data[i].toPhase and
						    FIZ_Data.SSO[FIZ_Realm].phase and (FIZ_Data.SSO[FIZ_Realm].phase > 0)) then
							-- this quest is limited by the SSO phases and SSO phase information is available

							-- check main phase requirement
							if ((FIZ_Data.SSO[FIZ_Realm].phase < FIZ_FactionGain[faction][standingId].quests.data[i].fromPhase) or
							    (FIZ_Data.SSO[FIZ_Realm].phase > FIZ_FactionGain[faction][standingId].quests.data[i].toPhase)) then
								-- required phase not yet reached or already passed
								showQuest = false
								--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because the current phase "..FIZ_Data.SSO[FIZ_Realm].phase.." mismatches the requirement "..FIZ_FactionGain[faction][standingId].quests.data[i].fromPhase.."-"..FIZ_FactionGain[faction][standingId].quests.data[i].toPhase)
							else
								-- required phase matches -> check sub-phases
								if (FIZ_FactionGain[faction][standingId].quests.data[i].phase2b) then
								  -- there is a phase2b requirement
									if (not FIZ_Data.SSO[FIZ_Realm].phase2b or (FIZ_Data.SSO[FIZ_Realm].phase2b ~= FIZ_FactionGain[faction][standingId].quests.data[i].phase2b)) then
										-- phase 2b status not defined or does not match
										showQuest = false
							    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because the phase2b requirement "..FIZ_FactionGain[faction][standingId].quests.data[i].phase2b.." has not been met")
							    		end
								end
								if (FIZ_FactionGain[faction][standingId].quests.data[i].phase3b) then
								  -- there is a phase3b requirement
									if (not FIZ_Data.SSO[FIZ_Realm].phase3b or (FIZ_Data.SSO[FIZ_Realm].phase3b ~= FIZ_FactionGain[faction][standingId].quests.data[i].phase3b)) then
										-- phase 3b status not defined or does not match
										showQuest = false
							    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because the phase3b requirement "..FIZ_FactionGain[faction][standingId].quests.data[i].phase3b.." has not been met")
							    		end
								end
								if (FIZ_FactionGain[faction][standingId].quests.data[i].phase4b) then
								  -- there is a phase4b requirement
									if (not FIZ_Data.SSO[FIZ_Realm].phase4b or (FIZ_Data.SSO[FIZ_Realm].phase4b ~= FIZ_FactionGain[faction][standingId].quests.data[i].phase4b)) then
										-- phase 4b status not defined or does not match
										showQuest = false
							    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because the phase4b requirement "..FIZ_FactionGain[faction][standingId].quests.data[i].phase4b.." has not been met")
							    		end
								end
								if (FIZ_FactionGain[faction][standingId].quests.data[i].phase4c) then
								  -- there is a phase4c requirement
									if (not FIZ_Data.SSO[FIZ_Realm].phase4c or (FIZ_Data.SSO[FIZ_Realm].phase4c ~= FIZ_FactionGain[faction][standingId].quests.data[i].phase4c)) then
										-- phase 4c status not defined or does not match
										showQuest = false
							    			--FIZ_Print("Not showing quest ["..FIZ_FactionGain[faction][standingId].quests.data[i].name.."] because the phase4c requirement "..FIZ_FactionGain[faction][standingId].quests.data[i].phase4c.." has not been met")
							    		end
								end
							end
						end

						if (showQuest) then
							if (not FIZ_FactionGain[faction][standingId].quests.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].quests.data[i].limit)) then
								local toDo = ceil(repToNext / FIZ_FactionGain[faction][standingId].quests.data[i].rep)
								if (FIZ_FactionGain[faction][standingId].quests.data[i].limit) then
									toDo = ceil((FIZ_FactionGain[faction][standingId].quests.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].quests.data[i].rep)
								end
								FIZ_UpdateList[index] = {}
								FIZ_UpdateList[index].type = FIZ_TXT.questShort
								FIZ_UpdateList[index].times = toDo.."x"
								FIZ_UpdateList[index].rep = string.format("%d", FIZ_FactionGain[faction][standingId].quests.data[i].rep)
								FIZ_UpdateList[index].index = index
								FIZ_UpdateList[index].belongsTo = nil
								FIZ_UpdateList[index].isShown = true
								FIZ_UpdateList[index].name = FIZ_FactionGain[faction][standingId].quests.data[i].name
								FIZ_UpdateList[index].originalName = FIZ_UpdateList[index].name
								FIZ_UpdateList[index].faction = faction
								FIZ_UpdateList[index].canSuppress = true
								FIZ_UpdateList[index].suppress = nil
								if (FIZ_Suppressed and FIZ_Suppressed[faction] and FIZ_Suppressed[faction][FIZ_UpdateList[index].originalName]) then
									FIZ_UpdateList[index].suppress = true
								end
								FIZ_UpdateList[index].tooltipHead = FIZ_TXT.questHead
								FIZ_UpdateList[index].tooltipTip = FIZ_TXT.questTip

								FIZ_UpdateList[index].tooltipDetails = {}
								local x = 0
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.quest2
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].name
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].rep
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.timesToDo
								FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].times
								x = x+1

								if (not FIZ_UpdateList[index].suppress) then
									sum = sum + FIZ_FactionGain[faction][standingId].quests.data[i].rep
									count = count + 1
								end

								if (FIZ_FactionGain[faction][standingId].quests.data[i].items) then
									FIZ_UpdateList[index].hasList = true
									FIZ_UpdateList[index].listShown = false

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = " "
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.itemsRequired
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1

									-- quest in log?
									FIZ_UpdateList[index].lowlight = nil

									-- check if this quest is known
									local entries, quests = GetNumQuestLogEntries()
									for z=1,entries do
										local title,level,tag,group,header,collapsed,complete,daily = GetQuestLogTitle(z)
										if (title and not header) then
											if string.find(string.lower(FIZ_FactionGain[faction][standingId].quests.data[i].name), string.lower(title)) then
												-- this quest matches
												FIZ_UpdateList[index].lowlight = true
												FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_QUEST_ACTIVE_COLOUR.." ("..FIZ_TXT.active..")|r"
											end
										end
									end


									-- add items
									local itemIndex = index+1

									local currentQuestTimesBag = -1
									local currentQuestTimesBagBank = -1
									for item in pairs(FIZ_FactionGain[faction][standingId].quests.data[i].items) do
										FIZ_UpdateList[itemIndex] = {}
										FIZ_UpdateList[itemIndex].type = ""
										FIZ_UpdateList[itemIndex].times = (FIZ_FactionGain[faction][standingId].quests.data[i].items[item] * toDo).."x"
										FIZ_UpdateList[itemIndex].rep = nil
										FIZ_UpdateList[itemIndex].index = itemIndex
										FIZ_UpdateList[itemIndex].belongsTo = index
										FIZ_UpdateList[itemIndex].hasList = nil
										FIZ_UpdateList[itemIndex].listShown = nil
										FIZ_UpdateList[itemIndex].isShown = FIZ_UpdateList[index].listShown
										FIZ_UpdateList[itemIndex].name = item.." ("..FIZ_FactionGain[faction][standingId].quests.data[i].items[item].."x)"

										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_FactionGain[faction][standingId].quests.data[i].items[item].."x"
										FIZ_UpdateList[index].tooltipDetails[x].r = item
										x = x+1

										if (FIZ_ItemsCarried and FIZ_ItemsCarried[item]) then
											if ((FIZ_ItemsCarried[item] >= FIZ_FactionGain[faction][standingId].quests.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].quests.data[i].items[item] > 0)) then
												FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name..FIZ_BAG_COLOUR.." ["..FIZ_ItemsCarried[item].."x]|r"
												FIZ_UpdateList[itemIndex].currentTimesBag = floor(FIZ_ItemsCarried[item] / FIZ_FactionGain[faction][standingId].quests.data[i].items[item])
												if (currentQuestTimesBag == -1) then
													-- first items for this quest --> take value
													currentQuestTimesBag = FIZ_UpdateList[itemIndex].currentTimesBag
												else
													-- some items already set
													if (FIZ_UpdateList[itemIndex].currentTimesBag < currentQuestTimesBag) then
														-- fewer of this item than of others, reduce quest count
														currentQuestTimesBag = FIZ_UpdateList[itemIndex].currentTimesBag
													end
												end
											else
												-- not enough of this item for quest -> set to 0
												currentQuestTimesBag = 0
												FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name.." ["..FIZ_ItemsCarried[item].."x]"
											end
											if (FIZ_Data.Bank and
											    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player] and
											    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item]) then
												local total = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item] + FIZ_ItemsCarried[item]
												if ((total >= FIZ_FactionGain[faction][standingId].quests.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].quests.data[i].items[item] > 0)) then
													FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name..FIZ_BAG_BANK_COLOUR.." ["..total.."x]|r"
													FIZ_UpdateList[itemIndex].currentTimesBagBank = floor(total / FIZ_FactionGain[faction][standingId].quests.data[i].items[item])
													if (currentQuestTimesBagBank == -1) then
														-- first items for this quest --> take value
														currentQuestTimesBagBank = FIZ_UpdateList[itemIndex].currentTimesBagBank
													else
														-- some items already set
														if (FIZ_UpdateList[itemIndex].currentTimesBagBank < currentQuestTimesBagBank) then
															-- fewer of this item than of others, reduce quest count
															currentQuestTimesBagBank = FIZ_UpdateList[itemIndex].currentTimesBagBank
														end
													end
												else
													-- not enough of this item for quest -> set to 0
													currentQuestTimesBagBank = 0
													FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name.." ["..total.."x]"
												end
											else
												-- none of this carried in bank
											end
										else
											-- not enough of this item for quest -> set to 0
											currentQuestTimesBag = 0
										end
										itemIndex = itemIndex + 1
									end
									if (currentQuestTimesBag > 0) then
										FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_BAG_COLOUR.." ["..currentQuestTimesBag.."x]|r"
										FIZ_UpdateList[index].currentTimesBag = currentQuestTimesBag
										FIZ_UpdateList[index].currentRepBag = currentQuestTimesBag * FIZ_UpdateList[index].rep
										FIZ_UpdateList[index].highlight = true
										FIZ_UpdateList[index].name = FIZ_UpdateList[index].originalName
										FIZ_UpdateList[index].lowlight = nil
										FIZ_CurrentRepInBag = FIZ_CurrentRepInBag + FIZ_UpdateList[index].currentRepBag

										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = " "
										FIZ_UpdateList[index].tooltipDetails[x].r = " "
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.inBag
										FIZ_UpdateList[index].tooltipDetails[x].r = " "
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.turnIns
										FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentTimesBag)
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
										FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentRepBag)
										x = x+1
									else
										FIZ_UpdateList[index].currentTimesBag = nil
										FIZ_UpdateList[index].currentRepBag = nil
									end
									if (currentQuestTimesBagBank > 0) then
										FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_BAG_BANK_COLOUR.." ["..currentQuestTimesBagBank.."x]|r"
										FIZ_UpdateList[index].currentTimesBagBank = currentQuestTimesBagBank
										FIZ_UpdateList[index].currentRepBagBank = currentQuestTimesBagBank * FIZ_UpdateList[index].rep
										FIZ_UpdateList[index].highlight = true
										FIZ_UpdateList[index].name = FIZ_UpdateList[index].originalName
										FIZ_UpdateList[index].lowlight = nil
										FIZ_CurrentRepInBagBank = FIZ_CurrentRepInBagBank + FIZ_UpdateList[index].currentRepBagBank

										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = " "
										FIZ_UpdateList[index].tooltipDetails[x].r = " "
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.inBagBank
										FIZ_UpdateList[index].tooltipDetails[x].r = " "
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.turnIns
										FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentTimesBagBank)
										x = x+1
										FIZ_UpdateList[index].tooltipDetails[x] = {}
										FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
										FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentRepBagBank)
										x = x+1
									else
										FIZ_UpdateList[index].currentTimesBagBank = nil
										FIZ_UpdateList[index].currentRepBagBank = nil
									end
									if ((currentQuestTimesBag == 0) and (currentQuestTimesBagBank)) then
										FIZ_UpdateList[index].highlight = nil
									end

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = " "
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
									FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].quests.data[i].maxStanding)
									x = x+1

									FIZ_UpdateList[index].tooltipDetails.count = x-1
									index = itemIndex
								else
									-- no items to add
									FIZ_UpdateList[index].hasList = false
									FIZ_UpdateList[index].listShown = nil
									FIZ_UpdateList[index].highlight = nil	-- will be changed below if needed
									FIZ_UpdateList[index].lowlight = nil

									-- check if this quest is known and/or completed
									local entries, quests = GetNumQuestLogEntries()
									for z=1,entries do
										local title,level,tag,group,header,collapsed,complete,daily = GetQuestLogTitle(z)
										if (title and not header) then
											if string.find(string.lower(FIZ_FactionGain[faction][standingId].quests.data[i].name), string.lower(title)) then
												-- this quest matches
												if (complete) then
													FIZ_UpdateList[index].highlight = true
													FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_QUEST_COLOUR.." ("..FIZ_TXT.complete..")|r"
													FIZ_UpdateList[index].currentTimesQuest = 1
													FIZ_UpdateList[index].currentRepQuest = FIZ_UpdateList[index].rep

													FIZ_CurrentRepInQuest = FIZ_CurrentRepInQuest + FIZ_FactionGain[faction][standingId].quests.data[i].rep

													FIZ_UpdateList[index].tooltipDetails[x] = {}
													FIZ_UpdateList[index].tooltipDetails[x].l = " "
													FIZ_UpdateList[index].tooltipDetails[x].r = " "
													x = x+1
													FIZ_UpdateList[index].tooltipDetails[x] = {}
													FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.questCompleted
													FIZ_UpdateList[index].tooltipDetails[x].r = " "
													x = x+1
													FIZ_UpdateList[index].tooltipDetails[x] = {}
													FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
													FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentRepQuest)
													x = x+1
												else
													FIZ_UpdateList[index].lowlight = true
													FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_QUEST_ACTIVE_COLOUR.." ("..FIZ_TXT.active..")|r"
												end
											end
										end
									end

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = " "
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
									FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].quests.data[i].maxStanding)
									x = x+1

									FIZ_UpdateList[index].tooltipDetails.count = x-1
									index = index + 1
								end
							end
						end
					end
					if ((sum > 0) and (count > 1)) then
						-- add virtual quest to show summary of all quests:
						local toDo = ceil(repToNext / sum)
						FIZ_UpdateList[index] = {}
						FIZ_UpdateList[index].type = FIZ_TXT.questShort
						FIZ_UpdateList[index].times = toDo.."x"
						FIZ_UpdateList[index].rep = string.format("%d", sum)
						FIZ_UpdateList[index].index = index
						FIZ_UpdateList[index].belongsTo = nil
						FIZ_UpdateList[index].isShown = true
						FIZ_UpdateList[index].name = string.format(FIZ_TXT.allOfTheAbove, count)
						FIZ_UpdateList[index].tooltipHead = string.format(FIZ_TXT.questSummaryHead, count)
						FIZ_UpdateList[index].tooltipTip = FIZ_TXT.questSummaryTip

						FIZ_UpdateList[index].tooltipDetails = {}
						local x = 0
						FIZ_UpdateList[index].tooltipDetails[x] = {}
						FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
						FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].rep
						x = x+1
						FIZ_UpdateList[index].tooltipDetails[x] = {}
						FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.timesToDo
						FIZ_UpdateList[index].tooltipDetails[x].r = FIZ_UpdateList[index].times
						FIZ_UpdateList[index].tooltipDetails.count = x

						index = index + 1
					end
				end

				-- items
				if (FIZ_FactionGain[faction][standingId].items and FIZ_Data.ShowItems) then
					for i = 0, FIZ_FactionGain[faction][standingId].items.count do
						if (not FIZ_FactionGain[faction][standingId].items.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].items.data[i].limit)) then
							local toDo = ceil(repToNext / FIZ_FactionGain[faction][standingId].items.data[i].rep)
							if (FIZ_FactionGain[faction][standingId].items.data[i].limit) then
								toDo = ceil((FIZ_FactionGain[faction][standingId].items.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].items.data[i].rep)
							end
							if (FIZ_FactionGain[faction][standingId].items.data[i].items) then
								FIZ_UpdateList[index] = {}
								FIZ_UpdateList[index].type = FIZ_TXT.itemsShort
								FIZ_UpdateList[index].times = toDo.."x"
								FIZ_UpdateList[index].rep = string.format("%d", FIZ_FactionGain[faction][standingId].items.data[i].rep)
								FIZ_UpdateList[index].index = index
								FIZ_UpdateList[index].belongsTo = nil
								FIZ_UpdateList[index].isShown = true
								FIZ_UpdateList[index].name = FIZ_TXT.itemsName
								FIZ_UpdateList[index].hasList = true
								FIZ_UpdateList[index].listShown = false
								FIZ_UpdateList[index].tooltipHead = FIZ_TXT.itemsHead
								FIZ_UpdateList[index].tooltipTip = FIZ_TXT.itemsTip

								FIZ_UpdateList[index].tooltipDetails = {}
								local x = 0
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_UpdateList[index].name
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = " "
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.itemsRequired
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1

								-- add items
								local itemIndex = index+1

								local currentQuestTimesBag = -1
								local currentQuestTimesBagBank = -1
								for item in pairs(FIZ_FactionGain[faction][standingId].items.data[i].items) do
									FIZ_UpdateList[itemIndex] = {}
									FIZ_UpdateList[itemIndex].type = ""
									FIZ_UpdateList[itemIndex].times = (FIZ_FactionGain[faction][standingId].items.data[i].items[item] * toDo).."x"
									FIZ_UpdateList[itemIndex].rep = nil
									FIZ_UpdateList[itemIndex].index = itemIndex
									FIZ_UpdateList[itemIndex].belongsTo = index
									FIZ_UpdateList[itemIndex].hasList = nil
									FIZ_UpdateList[itemIndex].listShown = nil
									FIZ_UpdateList[itemIndex].isShown = FIZ_UpdateList[index].listShown
									FIZ_UpdateList[itemIndex].name = item.." ("..FIZ_FactionGain[faction][standingId].items.data[i].items[item].."x)"

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_FactionGain[faction][standingId].items.data[i].items[item].."x"
									FIZ_UpdateList[index].tooltipDetails[x].r = item
									x = x+1

									if (FIZ_ItemsCarried and FIZ_ItemsCarried[item]) then
										if ((FIZ_ItemsCarried[item] >= FIZ_FactionGain[faction][standingId].items.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].items.data[i].items[item] > 0)) then
											FIZ_UpdateList[itemIndex].currentTimesBag = floor(FIZ_ItemsCarried[item] / FIZ_FactionGain[faction][standingId].items.data[i].items[item])
											FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name..FIZ_BAG_COLOUR.." ["..FIZ_ItemsCarried[item].."x]|r"
											if (currentQuestTimesBag == -1) then
												-- first items for this quest --> take value
												currentQuestTimesBag = FIZ_UpdateList[itemIndex].currentTimesBag
											else
												-- some items already set
												if (FIZ_UpdateList[itemIndex].currentTimesBag < currentQuestTimesBag) then
													-- fewer of this item than of others, reduce quest count
													currentQuestTimesBag = FIZ_UpdateList[itemIndex].currentTimesBag
												end
											end
										else
											-- not enough of this item for quest -> set to 0
											currentQuestTimesBag = 0
											FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name.." ["..FIZ_ItemsCarried[item].."x]"
										end
										if (FIZ_Data.Bank and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player] and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item]) then
											local total = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item] + FIZ_ItemsCarried[item]
											if ((total >= FIZ_FactionGain[faction][standingId].itemsdata[i].items[item]) and (FIZ_FactionGain[faction][standingId].items.data[i].items[item] > 0)) then
												FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name..FIZ_BAG_BANK_COLOUR.." ["..total.."x]|r"
												FIZ_UpdateList[itemIndex].currentTimesBagBank = floor(total / FIZ_FactionGain[faction][standingId].items.data[i].items[item])
												if (currentQuestTimesBagBank == -1) then
													-- first items for this quest --> take value
													currentQuestTimesBagBank = FIZ_UpdateList[itemIndex].currentTimesBagBank
												else
													-- some items already set
													if (FIZ_UpdateList[itemIndex].currentTimesBagBank < currentQuestTimesBagBank) then
														-- fewer of this item than of others, reduce quest count
														currentQuestTimesBagBank = FIZ_UpdateList[itemIndex].currentTimesBagBank
													end
												end
											else
												-- not enough of this item for quest -> set to 0
												currentQuestTimesBagBank = 0
												FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name.." ["..total.."x]"
											end
										else
											-- none of this carried in bank
										end
									else
										-- not enough of this item for quest -> set to 0
										currentQuestTimesBag = 0
									end
									itemIndex = itemIndex + 1

								end
								if (currentQuestTimesBag > 0) then
									FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_BAG_COLOUR.." ["..currentQuestTimesBag.."x]|r"
									FIZ_UpdateList[index].currentTimesBag = currentQuestTimesBag
									FIZ_UpdateList[index].currentRepBag = currentQuestTimesBag * FIZ_UpdateList[index].rep
									FIZ_CurrentRepInBag = FIZ_CurrentRepInBag + FIZ_UpdateList[index].currentRepBag

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = " "
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.inBag
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.turnIns
									FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentTimesBag)
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
									FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentRepBag)
									x = x+1
								else
									FIZ_UpdateList[index].currentTimesBag = nil
									FIZ_UpdateList[index].currentRepBag = nil
								end
								if (currentQuestTimesBagBank > 0) then
									FIZ_UpdateList[index].name = FIZ_UpdateList[index].name..FIZ_BAG_BANK_COLOUR.." ["..currentQuestTimesBagBank.."]|r"
									FIZ_UpdateList[index].currentTimesBagBank = currentQuestTimesBagBank
									FIZ_UpdateList[index].currentRepBagBank = currentQuestTimesBagBank * FIZ_UpdateList[index].rep
									FIZ_CurrentRepInBagBank = FIZ_CurrentRepInBagBank + FIZ_UpdateList[index].currentRepBagBank

									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = " "
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.inBagBank
									FIZ_UpdateList[index].tooltipDetails[x].r = " "
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.turnIns
									FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentTimesBagBank)
									x = x+1
									FIZ_UpdateList[index].tooltipDetails[x] = {}
									FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.reputation
									FIZ_UpdateList[index].tooltipDetails[x].r = string.format("%d", FIZ_UpdateList[index].currentRepBagBank)
									x = x+1
								else
									FIZ_UpdateList[index].currentTimesBagBank = nil
									FIZ_UpdateList[index].currentRepBagBank = nil
								end

								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = " "
								FIZ_UpdateList[index].tooltipDetails[x].r = " "
								x = x+1
								FIZ_UpdateList[index].tooltipDetails[x] = {}
								FIZ_UpdateList[index].tooltipDetails[x].l = FIZ_TXT.maxStanding
								FIZ_UpdateList[index].tooltipDetails[x].r = getglobal("FACTION_STANDING_LABEL"..FIZ_FactionGain[faction][standingId].items.data[i].maxStanding)
								x = x+1

								FIZ_UpdateList[index].tooltipDetails.count = x-1

								index = itemIndex
							end
						end
					end
				end
			end
		end
	end

	--FIZ_Print("Added "..(index-1).." entries for ["..faction.."] at standing "..standingId)

	FIZ_UpdateList_Update()
end

function FIZ_GetUpdateListSize()
	local count = 0
	local highest = 0
	for i in pairs(FIZ_UpdateList) do
		if (FIZ_UpdateList[i].isShown) then
			count = count + 1
			if (i > highest) then
				highest = i
			end
		end
	end

	return count, highest
end

function FIZ_ShowUpdateEntry(index, show)
	if (not FIZ_UpdateList[index]) then return end		-- invalid index
	if (not FIZ_UpdateList[index].hasList) then return end	-- not a list header entry
	if (type(show)~="boolean") then return end		-- wrong data type

	FIZ_UpdateList[index].listShown = show
	for i in pairs(FIZ_UpdateList) do
		if (FIZ_UpdateList[i].belongsTo == index) then
			FIZ_UpdateList[i].isShown = show
		end
	end

	FIZ_UpdateList_Update()
end

function FIZ_ShowUpdateEntries(show)
	if (type(show)~="boolean") then return end		-- wrong data type

	for i in pairs(FIZ_UpdateList) do
		if (FIZ_UpdateList[i].belongsTo == nil) then
			-- always show parent entries, show or hide their children
			FIZ_UpdateList[i].isShown = true
			FIZ_UpdateList[i].listShown = show
		else
			-- show or hide child entries
			FIZ_UpdateList[i].isShown = show
		end
	end

	FIZ_UpdateList_Update()
end

function FIZ_ShowLineToolTip(object)
	if not object then return end

	if (this.tooltipHead) then
		GameTooltip_SetDefaultAnchor(GameTooltip, this)
		GameTooltip:SetText(this.tooltipHead, 1, 1, 0.5, 1)
		if (this.tooltipTip) then
			GameTooltip:AddLine(this.tooltipTip, 1, 1, 1, 1)
		end
		if (this.tooltipDetails and type(this.tooltipDetails) == "table") then
			GameTooltip:AddLine(" ", 1, 1, 1, 1)
			for i = 0, this.tooltipDetails.count do
				if (this.tooltipDetails[i].l and this.tooltipDetails[i].r) then
					if (this.tooltipDetails[i].r == " " or this.tooltipDetails[i].r=="") then
						GameTooltip:AddDoubleLine(this.tooltipDetails[i].l, this.tooltipDetails[i].r, 1, 1, 0, 1, 1, 1)
					else
						GameTooltip:AddDoubleLine(this.tooltipDetails[i].l, this.tooltipDetails[i].r, 1, 1, 0.5, 1, 1, 1)
					end
				end
			end
		end
		GameTooltip:Show()
	end
end

function FIZ_ShowHelpToolTip(element)
	if not element then return end

	local name = ""

	-- cut off leading frame name
	--if (string.find(element, GLDG_GUI)) then
	--	name = string.sub(element, string.len(GLDG_GUI)+1)
	--elseif (string.find(element, GLDG_COLOUR)) then
	--	name = string.sub(element, string.len(GLDG_COLOUR)+1)
	--elseif (string.find(element, GLDG_LIST)) then
		name = element
	--end

	-- cut off trailing number in case of line and collect
	--local s,e = string.find(name, "Line");
	--if (s and e) then
	--	name = string.sub(name, 0, e)
	--end
	--s,e = string.find(name, "Collect");
	--if (s and e) then
	--	name = string.sub(name, 0, e)
	--end

	-- cut off colour button/texture
	--if (string.find(name, "Colour") == 1) then
	--	-- ["ColourGuildNewButton"] = true,
	--	s,e = string.find(name, "Button");
	--	if (s and e) then
	--		name = string.sub(name, 0, s-1)
	--	end
	--	-- ["ColourGuildNewColour"] = true,
	--	s,e = string.find(name, "Colour", 2);	-- start at 2 to skip the initial Colour
	--	if (s and e) then
	--		name = string.sub(name, 0, s-1)
	--	end
	--end


	local tip = ""
	local head = ""
	if (FIZ_TXT.elements and
	    FIZ_TXT.elements.name and
	    FIZ_TXT.elements.tip and
	    FIZ_TXT.elements.name[name] and
	    FIZ_TXT.elements.tip[name]) then
		tip = FIZ_TXT.elements.tip[name]
		head = FIZ_TXT.elements.name[name]

		if (FIZ_Data.needsTip and FIZ_Data.needsTip[name]) then
			FIZ_Data.needsTip[name] = nil
		end
	else
		if (not FIZ_Data.needsTip) then
			FIZ_Data.needsTip = {}
		end
		FIZ_Data.needsTip[name] = true
	end

	--GameTooltip_SetDefaultAnchor(GameTooltip, this)
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	if (head ~= "") then
		GameTooltip:SetText(head, 1, 1, 0.5, 1.0, 1)
--		GameTooltip:AddLine(name, 1, 0, 0, 1.0, 1)
		GameTooltip:AddLine(tip, 1, 1, 1, 1.0, 1)
--	else
--		GameTooltip:SetText(element, 1, 1, 0.5, 1.0, 1)
--		GameTooltip:AddLine(name, 1, 1, 1, 1.0, 1)
	end

	GameTooltip:Show()
end

-----------------------------------
-- _12_ Reputation Changes to Chat
-----------------------------------
function FIZ_DumpReputationChangesToChat(initOnly)
	if not FIZ_StoredRep then FIZ_StoredRep = {} end

	local numFactions = GetNumFactions();
	local factionIndex
	local name, standingID, barMin, barMax, barValue, isHeader
	local RepRemains
	for factionIndex=1, numFactions, 1 do
		name, _, standingID, barMin, barMax, barValue, _, _, isHeader = GetFactionInfo(factionIndex)

		if (not isHeader) then
			if FIZ_StoredRep[name] and not initOnly then
				if (FIZ_Data.WriteChatMessage) then
					local sign=""
					if ((barValue-FIZ_StoredRep[name].origRep)>0) then
						sign = "+"
					end
					if (barValue > FIZ_StoredRep[name].rep) then
						-- increased rep
						FIZ_Print(FIZ_NEW_REP_COLOUR..string.format(FACTION_STANDING_INCREASED..FIZ_TXT.stats, name, barValue-FIZ_StoredRep[name].rep, sign, barValue-FIZ_StoredRep[name].origRep, barMax-barValue))
					elseif (barValue < FIZ_StoredRep[name].rep) then
						FIZ_Print(FIZ_NEW_REP_COLOUR..string.format(FACTION_STANDING_DECREASED..FIZ_TXT.stats, name, FIZ_StoredRep[name].rep-barValue, sign, barValue-FIZ_StoredRep[name].origRep, barMax-barValue))
						-- decreased rep
					end
					if (FIZ_StoredRep[name].standingID ~= standingID) then
						FIZ_Print(FIZ_NEW_STANDING_COLOUR..string.format(FACTION_STANDING_CHANGED, getglobal("FACTION_STANDING_LABEL"..standingID), name))
					end
				end
			else
				FIZ_StoredRep[name] = {}
				FIZ_StoredRep[name].origRep = barValue
			end
			FIZ_StoredRep[name].standingID = standingID
			FIZ_StoredRep[name].rep = barValue
		end
	end
end

-----------------------------------
-- _13_ Chat filtering
-----------------------------------
function FIZ_ChatFrame_OnEvent(event)
	--[[
	CHAT_MSG_COMBAT_FACTION_CHANGE
		Fires when player's faction changes. ie: "Your reputation with Timbermaw Hold has very slightly increased." -- NEW 1.9
		arg1
			The message to display

	COMBAT_TEXT_UPDATE
		arg1
			Combat message type.
			Known values include "HONOR_GAINED", and "FACTION".
		arg2
			for faction gain, this is the faction name.
		arg3
			for faction gain, the amount of reputation gained.
	]]--
	local skip = false
	if (event) then
		--local m = "["..event.."]"
		--if (arg1) then m = m.." ("..arg1..")" else m = m.." ()" end
		--if (arg2) then m = m.." ("..arg2..")" else m = m.." ()" end
		--if (arg3) then m = m.." ("..arg3..")" else m = m.." ()" end
		--if (arg4) then m = m.." ("..arg4..")" else m = m.." ()" end
		--if (arg5) then m = m.." ("..arg5..")" else m = m.." ()" end
		--if (arg6) then m = m.." ("..arg6..")" else m = m.." ()" end
		--if (arg7) then m = m.." ("..arg7..")" else m = m.." ()" end
		--if (arg8) then m = m.." ("..arg8..")" else m = m.." ()" end
		--if (arg9) then m = m.." ("..arg9..")" else m = m.." ()" end
		--FIZ_Print("Caught an event: "..m)

		if (event == "CHAT_MSG_COMBAT_FACTION_CHANGE") then
			skip = true
		end
		if ((event == "COMBAT_TEXT_UPDATE") and (arg1=="FACTION")) then
			skip = true
		end
		skip = skip and FIZ_Data.SuppressOriginalChat

		if not skip then
			FIZ_Orig_ChatFrame_OnEvent(event)
		end
	end
end

-----------------------------------
-- _13_ Show option window
-----------------------------------
function FIZ_ToggleConfigWindow()
	if ReputationFrame:IsVisible() then
		if FIZ_OptionsFrame:IsVisible() then
			-- both windows shown -> hide them both
			FIZ_OptionsFrame:Hide()
			HideUIPanel(CharacterFrame)
		else
			-- options window not shown -> show, hide any detail window
			FIZ_OptionsFrame:Show()
			FIZ_ReputationDetailFrame:Hide();
			ReputationDetailFrame:Hide();
		end
	else
		-- window not shown -> show both
		ToggleCharacter("ReputationFrame")
		FIZ_ReputationDetailFrame:Hide();
		ReputationDetailFrame:Hide();
		FIZ_OptionsFrame:Show()
	end
end

function FIZ_ToggleDetailWindow()
	if ReputationFrame:IsVisible() then
		if (FIZ_Data.ExtendDetails) then
			if FIZ_ReputationDetailFrame:IsVisible() then
				-- both windows shown -> hide them both
				FIZ_ReputationDetailFrame:Hide()
				HideUIPanel(CharacterFrame)
			else
				-- detail window not shown -> show it, hide any others
				FIZ_ReputationDetailFrame:Show()
				ReputationDetailFrame:Hide();
				FIZ_OptionsFrame:Hide();
				ReputationFrame_Update();
			end
		else
			if ReputationDetailFrame:IsVisible() then
				-- both windows shown -> hide them both
				ReputationDetailFrame:Hide()
				HideUIPanel(CharacterFrame)
			else
				-- detail window not shown -> show it, hide any others
				FIZ_ReputationDetailFrame:Hide()
				ReputationDetailFrame:Show();
				FIZ_OptionsFrame:Hide();
				ReputationFrame_Update();
			end
		end
	else
		-- window not shown -> show both
		ToggleCharacter("ReputationFrame")
		if (FIZ_Data.ExtendDetails) then
			FIZ_ReputationDetailFrame:Show();
		else
			ReputationDetailFrame:Show();
		end
		FIZ_OptionsFrame:Hide()
		ReputationFrame_Update();
	end
end


-----------------------------------
-- _14_ Testing
-----------------------------------

--[[
local numEntries, numQuests = GetNumQuestLogEntries()
numEntries
    Integer - Number of entries in the Quest Log (includes collapsable area grouping headlines).
numQuests
    Integer - Number of actual quests.

questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questID);
]]--

function FIZ_Test()
	local entries, quests = GetNumQuestLogEntries()

	FIZ_Print(" ")
	FIZ_Print("Entries: "..entries..", Quests: "..quests)

	for i=1,entries do
		local title,level,tag,group,header,collapsed,complete,daily = GetQuestLogTitle(i)
		local link = GetQuestLink(i)
		if (title) then
			if not link then link = "nil" end
			if not level then level = "nil" end
			if not tag then tag = "no tag" end
			if not group then group = "no group" end
			FIZ_Print("Entry "..i..": ["..level.."] ["..title.."] ["..tag.."] - ["..link.."] - Header: "..tostring(header)..", Collapsed: "..tostring(collapsed)..", Complete: "..tostring(complete)..", Daily: "..tostring(daily))
		else
			FIZ_Print("Entry "..i.." is nil")
		end
	end
	FIZ_Print(" ")
end


-----------------------------------
-- _15_ Getting reputation ready to hand in
-----------------------------------
function FIZ_GetReadyReputation(factionIndex)
	local result = 0
	if not factionIndex then return result end

	if (not ReputationFrame:IsVisible()) then return result end

	local maxFactionIndex = GetNumFactions()
	if (factionIndex > maxFactionIndex) then return result end

	local faction, description, standingId, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = FIZ_Orig_GetFactionInfo(factionIndex)
	if (isHeader) then return result end

	if (faction) then
		origFaction = faction
		faction = string.lower(faction)
		if (FIZ_FactionMapping[faction]) then
			faction = FIZ_FactionMapping[faction]
		end

		-- Normalize values
		local normMax = barMax - barMin
		local normCurrent = barValue - barMin
		local repToNext = barMax - barValue

		if (FIZ_FactionGain[faction]) then
			if (FIZ_FactionGain[faction][standingId]) then

				-- quests (may have items)
				if (FIZ_FactionGain[faction][standingId].quests) then
					for i = 0, FIZ_FactionGain[faction][standingId].quests.count do
						if (not FIZ_FactionGain[faction][standingId].quests.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].quests.data[i].limit)) then
							local toDo = ceil(repToNext / FIZ_FactionGain[faction][standingId].quests.data[i].rep)
							if (FIZ_FactionGain[faction][standingId].quests.data[i].limit) then
								toDo = ceil((FIZ_FactionGain[faction][standingId].quests.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].quests.data[i].rep)
							end

							if (FIZ_FactionGain[faction][standingId].quests.data[i].items) then
								local currentQuestTimesBag = -1
								local currentQuestTimesBagBank = -1
								for item in pairs(FIZ_FactionGain[faction][standingId].quests.data[i].items) do
									if (FIZ_ItemsCarried and FIZ_ItemsCarried[item]) then
										if ((FIZ_ItemsCarried[item] >= FIZ_FactionGain[faction][standingId].quests.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].quests.data[i].items[item] > 0)) then
											local localCurrentTimesBag = floor(FIZ_ItemsCarried[item] / FIZ_FactionGain[faction][standingId].quests.data[i].items[item])
											if (currentQuestTimesBag == -1) then
												-- first items for this quest --> take value
												currentQuestTimesBag = localCurrentTimesBag
											else
												-- some items already set
												if (localCurrentTimesBag < currentQuestTimesBag) then
													-- fewer of this item than of others, reduce quest count
													currentQuestTimesBag = localCurrentTimesBag
												end
											end
										else
											-- not enough of this item for quest -> set to 0
											currentQuestTimesBag = 0
										end
										if (FIZ_Data.Bank and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player] and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item]) then
											local total = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item] + FIZ_ItemsCarried[item]
											if ((total >= FIZ_FactionGain[faction][standingId].quests.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].quests.data[i].items[item] > 0)) then
												local localCurrentTimesBagBank = floor(total / FIZ_FactionGain[faction][standingId].quests.data[i].items[item])
												if (currentQuestTimesBagBank == -1) then
													-- first items for this quest --> take value
													currentQuestTimesBagBank = localCurrentTimesBagBank
												else
													-- some items already set
													if (localCurrentTimesBagBank < currentQuestTimesBagBank) then
														-- fewer of this item than of others, reduce quest count
														currentQuestTimesBagBank = localCurrentTimesBagBank
													end
												end
											else
												-- not enough of this item for quest -> set to 0
												currentQuestTimesBagBank = 0
											end
										else
											-- none of this carried in bank
										end
									else
										-- not enough of this item for quest -> set to 0
										currentQuestTimesBag = 0
									end
								end
								if (currentQuestTimesBag > toDo) then
									currentQuestTimesBag = toDo
								end
								if (currentQuestTimesBagBank > toDo) then
									currentQuestTimesBagBank = toDo
								end
								if (currentQuestTimesBagBank > 0) then
									result = result + currentQuestTimesBagBank * FIZ_FactionGain[faction][standingId].quests.data[i].rep
								elseif (currentQuestTimesBag > 0) then
									result = result + currentQuestTimesBag * FIZ_FactionGain[faction][standingId].quests.data[i].rep
								else
									-- nothing to add
								end
							else
								-- no items, check if this quest is completed
								local entries, quests = GetNumQuestLogEntries()
								for z=1,entries do
									local title,level,tag,group,header,collapsed,complete,daily = GetQuestLogTitle(z)
									if (title and not header and complete) then
										if string.find(string.lower(FIZ_FactionGain[faction][standingId].quests.data[i].name), string.lower(title)) then
											-- this quest matches
											result = result + FIZ_FactionGain[faction][standingId].quests.data[i].rep
										end
									end
								end
							end
						end
					end
				end

				-- items
				if (FIZ_FactionGain[faction][standingId].items and FIZ_Data.ShowItems) then
					for i = 0, FIZ_FactionGain[faction][standingId].items.count do
						if (not FIZ_FactionGain[faction][standingId].items.data[i].limit or (normCurrent < FIZ_FactionGain[faction][standingId].items.data[i].limit)) then
							local toDo = ceil(repToNext / FIZ_FactionGain[faction][standingId].items.data[i].rep)
							if (FIZ_FactionGain[faction][standingId].items.data[i].limit) then
								toDo = ceil((FIZ_FactionGain[faction][standingId].items.data[i].limit - normCurrent) / FIZ_FactionGain[faction][standingId].items.data[i].rep)
							end
							if (FIZ_FactionGain[faction][standingId].items.data[i].items) then
								local currentQuestTimesBag = -1
								local currentQuestTimesBagBank = -1
								for item in pairs(FIZ_FactionGain[faction][standingId].items.data[i].items) do
									if (FIZ_ItemsCarried and FIZ_ItemsCarried[item]) then
										if ((FIZ_ItemsCarried[item] >= FIZ_FactionGain[faction][standingId].items.data[i].items[item]) and (FIZ_FactionGain[faction][standingId].items.data[i].items[item] > 0)) then
											local localCurrentTimesBag = floor(FIZ_ItemsCarried[item] / FIZ_FactionGain[faction][standingId].items.data[i].items[item])
											if (currentQuestTimesBag == -1) then
												-- first items for this quest --> take value
												currentQuestTimesBag = localCurrentTimesBag
											else
												-- some items already set
												if (localCurrentTimesBag < currentQuestTimesBag) then
													-- fewer of this item than of others, reduce quest count
													currentQuestTimesBag = localCurrentTimesBag
												end
											end
										else
											-- not enough of this item for quest -> set to 0
											currentQuestTimesBag = 0
										end
										if (FIZ_Data.Bank and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player] and
										    FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item]) then
											local total = FIZ_Data.Bank[FIZ_Realm.." - "..FIZ_Player][item] + FIZ_ItemsCarried[item]
											if ((total >= FIZ_FactionGain[faction][standingId].itemsdata[i].items[item]) and (FIZ_FactionGain[faction][standingId].items.data[i].items[item] > 0)) then
												local localCurrentTimesBagBank = floor(total / FIZ_FactionGain[faction][standingId].items.data[i].items[item])
												if (currentQuestTimesBagBank == -1) then
													-- first items for this quest --> take value
													currentQuestTimesBagBank = localCurrentTimesBagBank
												else
													-- some items already set
													if (localCurrentTimesBagBank < currentQuestTimesBagBank) then
														-- fewer of this item than of others, reduce quest count
														currentQuestTimesBagBank = localCurrentTimesBagBank
													end
												end
											else
												-- not enough of this item for quest -> set to 0
												currentQuestTimesBagBank = 0
												FIZ_UpdateList[itemIndex].name = FIZ_UpdateList[itemIndex].name.." ["..total.."x]"
											end
										else
											-- none of this carried in bank
										end
									else
										-- not enough of this item for quest -> set to 0
										currentQuestTimesBag = 0
									end
								end
								if (currentQuestTimesBag > toDo) then
									currentQuestTimesBag = toDo
								end
								if (currentQuestTimesBagBank > toDo) then
									currentQuestTimesBagBank = toDo
								end
								if (currentQuestTimesBagBank > 0) then
									result = result + currentQuestTimesBagBank * FIZ_FactionGain[faction][standingId].items.data[i].rep
								elseif (currentQuestTimesBag > 0) then
									result = result + currentQuestTimesBag * FIZ_FactionGain[faction][standingId].items.data[i].rep
								end
							end
						end
					end
				end
			end
		end
	end

	return result;
end

-----------------------------------
-- _16_ Listing by standing
-----------------------------------
function FIZ_ListByStanding(standing)
	local numFactions = GetNumFactions();
	local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;
	local list = {}

	-- get factions by standing
	for i=1, numFactions do
		name, description, standingID, barMin, barMax, barValue, _, _, isHeader = GetFactionInfo(i)
		if (not isHeader) then
			if ((standing == nil) or (standing==standingID)) then
				if (not list[standingID]) then
					list[standingID] = {}
				end
				list[standingID][name]={}
				list[standingID][name].max = barMax-barMin
				list[standingID][name].value = barValue-barMin
			end
		end
	end

	-- output
	for i=1, 8 do
		if (list[i]) then
			FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_RGBToColour_perc(1, FACTION_BAR_COLORS[i].r, FACTION_BAR_COLORS[i].g, FACTION_BAR_COLORS[i].b).."--- "..getglobal("FACTION_STANDING_LABEL"..i).." ("..i..") ---|r")
			for p in pairs(list[i]) do
				--FIZ_Print("    "..p..": "..list[i][p].value.."/"..list[i][p].max.." ("..FIZ_TXT.missing2..": "..list[i][p].max-list[i][p].value..")")
				FIZ_Print("    "..p..": "..FIZ_TXT.missing2..": "..list[i][p].max-list[i][p].value)
			end
			if (not standing) then
				FIZ_Print(" ")
			end
		end
	end
end

-----------------------------------
-- _17_ List german names
-----------------------------------
--[[
]]----------------------------------------------------------
FIZ_STANDING_DE = {}
FIZ_STANDING_DE[0] = "Unbekannt"
FIZ_STANDING_DE[1] = "HasserfÃ¼llt"
FIZ_STANDING_DE[2] = "Feindselig"
FIZ_STANDING_DE[3] = "Unfreundlich"
FIZ_STANDING_DE[4] = "Neutral"
FIZ_STANDING_DE[5] = "Freundlich"
FIZ_STANDING_DE[6] = "Wohlwollend"
FIZ_STANDING_DE[7] = "Respektvoll"
FIZ_STANDING_DE[8] = "EhrfÃ¼rchtig"

function FIZ_ShowGerman(standing)
	local en,de,color,min,max
	min=1
	max=8
	if ((standing ~= nil) and (standing<=8)) then
		min=standing
		max=standing
	end
	FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r German standing names:")
	for i=min,max do
		en = getglobal("FACTION_STANDING_LABEL"..i)
		de = FIZ_STANDING_DE[i]
		color = FACTION_BAR_COLORS[i]
		FIZ_Print("  "..FIZ_RGBToColour_perc(1,color.r,color.g,color.b)..i..": "..en.." = "..de)
	end
end

--------------------------
-- _18_ urbin addon listing
--------------------------
function FIZ_RegisterUrbinAddon(name, about)
	if (not name) then
		return
	end
	if (not URBIN_AddonList) then
		URBIN_AddonList = {}
	end
	URBIN_AddonList[name] = {}
	URBIN_AddonList[name].name = name
	URBIN_AddonList[name].about = about
end

function FIZ_ListUrbinAddons(name)
	if (not URBIN_AddonList) then
		return
	end

	local addons = ""
	for p in pairs(URBIN_AddonList) do
		if (URBIN_AddonList[p].name ~= name) then
			if (addons ~= "") then
				addons = addons..", "
			end
			addons = addons..URBIN_AddonList[p].name
		end
	end

	if (addons ~= "") then
		FIZ_Print(" ", true);
		FIZ_Print("  "..FIZ_TXT.urbin..": "..FIZ_HELP_COLOUR..addons.."|r", true);
	end
end

function FIZ_ListUrbinAddonDetails()
	for p in pairs(URBIN_AddonList) do
		if (URBIN_AddonList[p].about) then
			URBIN_AddonList[p].about(true)
		end
	end
end

--------------------------
-- _19_ sso phase handling
--------------------------
function FIZ_SetSSOPhase(phase)
	if (phase and phase >= 1 and phase <=4) then
		FIZ_Data.SSO[FIZ_Realm].phase = phase
		if (phase <4) then
			FIZ_Data.SSO[FIZ_Realm].phase4b = 0
			FIZ_Data.SSO[FIZ_Realm].phase4c = 0
		else
			if (not FIZ_Data.SSO[FIZ_Realm].phase4b or (FIZ_Data.SSO[FIZ_Realm].phase4b == 0)) then
				FIZ_Data.SSO[FIZ_Realm].phase4b = 1
			end
			if (not FIZ_Data.SSO[FIZ_Realm].phase4c or (FIZ_Data.SSO[FIZ_Realm].phase4c == 0)) then
				FIZ_Data.SSO[FIZ_Realm].phase4c = 1
			end
		end
		if (phase <3) then
			FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		else
			if (not FIZ_Data.SSO[FIZ_Realm].phase3b or (FIZ_Data.SSO[FIZ_Realm].phase3b == 0)) then
				FIZ_Data.SSO[FIZ_Realm].phase3b = 1
			end
		end
		if (phase <2) then
			FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		else
			if (not FIZ_Data.SSO[FIZ_Realm].phase2b or (FIZ_Data.SSO[FIZ_Realm].phase2b == 0)) then
				FIZ_Data.SSO[FIZ_Realm].phase2b = 1
			end
		end
	else
		FIZ_Data.SSO[FIZ_Realm].phase = 0
		FIZ_Data.SSO[FIZ_Realm].phase2b = nil
		FIZ_Data.SSO[FIZ_Realm].phase3b = nil
		FIZ_Data.SSO[FIZ_Realm].phase4b = nil
		FIZ_Data.SSO[FIZ_Realm].phase4c = nil
	end

	FIZ_SSOPhaseStatus()
end

function FIZ_SetSSOPhase2b(state)
	if (FIZ_Data.SSO[FIZ_Realm].phase) then
		if (state >= 0 and state <= 2) then
			if (FIZ_Data.SSO[FIZ_Realm].phase >= 2) then
				FIZ_Data.SSO[FIZ_Realm].phase2b = state
			else
				FIZ_Data.SSO[FIZ_Realm].phase2b = 0
				FIZ_Data.SSO[FIZ_Realm].phase3b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4c = 0
			end
		else
			FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		end
	else
		FIZ_Data.SSO[FIZ_Realm].phase = 0
		FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4c = 0
	end

	FIZ_SSOPhaseStatus()
end

function FIZ_SetSSOPhase3b(state)
	if (FIZ_Data.SSO[FIZ_Realm].phase) then
		if (state >= 0 and state <= 2) then
			if (FIZ_Data.SSO[FIZ_Realm].phase >= 3) then
				FIZ_Data.SSO[FIZ_Realm].phase3b = state
			else
				FIZ_Data.SSO[FIZ_Realm].phase3b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4c = 0
			end
		else
			FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		end
	else
		FIZ_Data.SSO[FIZ_Realm].phase = 0
		FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4c = 0
	end

	FIZ_SSOPhaseStatus()
end

function FIZ_SetSSOPhase4b(state)
	if (FIZ_Data.SSO[FIZ_Realm].phase) then
		if (state >= 0 and state <= 2) then
			if (FIZ_Data.SSO[FIZ_Realm].phase >= 4) then
				FIZ_Data.SSO[FIZ_Realm].phase4b = state
			else
				FIZ_Data.SSO[FIZ_Realm].phase4b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4c = 0
			end
		else
			FIZ_Data.SSO[FIZ_Realm].phase4b = 0
		end
	else
		FIZ_Data.SSO[FIZ_Realm].phase = 0
		FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4c = 0
	end

	FIZ_SSOPhaseStatus()
end

function FIZ_SetSSOPhase4c(state)
	if (FIZ_Data.SSO[FIZ_Realm].phase) then
		if (state >= 0 and state <= 2) then
			if (FIZ_Data.SSO[FIZ_Realm].phase >= 4) then
				FIZ_Data.SSO[FIZ_Realm].phase4c = state
			else
				FIZ_Data.SSO[FIZ_Realm].phase4b = 0
				FIZ_Data.SSO[FIZ_Realm].phase4c = 0
			end
		else
			FIZ_Data.SSO[FIZ_Realm].phase4c = 0
		end
	else
		FIZ_Data.SSO[FIZ_Realm].phase = 0
		FIZ_Data.SSO[FIZ_Realm].phase2b = 0
		FIZ_Data.SSO[FIZ_Realm].phase3b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4b = 0
		FIZ_Data.SSO[FIZ_Realm].phase4c = 0
	end

	FIZ_SSOPhaseStatus()
end

function FIZ_SSOPhaseStatus()
	local main_phase = FIZ_TXT.sso_unknown
	local phase2b = FIZ_TXT.sso_unknown
	local phase3b = FIZ_TXT.sso_unknown
	local phase4b = FIZ_TXT.sso_unknown
	local phase4c = FIZ_TXT.sso_unknown

	if (FIZ_Data.SSO[FIZ_Realm].phase) then
		if (FIZ_Data.SSO[FIZ_Realm].phase == 1) then
			main_phase = FIZ_TXT.phase1
		elseif (FIZ_Data.SSO[FIZ_Realm].phase == 2) then
			main_phase = FIZ_TXT.phase2
		elseif (FIZ_Data.SSO[FIZ_Realm].phase == 3) then
			main_phase = FIZ_TXT.phase3
		elseif (FIZ_Data.SSO[FIZ_Realm].phase == 4) then
			main_phase = FIZ_TXT.phase4
		end
	end

	if (FIZ_Data.SSO[FIZ_Realm].phase2b) then
		if (FIZ_Data.SSO[FIZ_Realm].phase2b ==0) then
			phase2b = FIZ_TXT.phase2bWaiting
		elseif (FIZ_Data.SSO[FIZ_Realm].phase2b ==1) then
			phase2b = FIZ_TXT.phase2bActive
		elseif (FIZ_Data.SSO[FIZ_Realm].phase2b ==2) then
			phase2b = FIZ_TXT.phase2bDone
		end
	end

	if (FIZ_Data.SSO[FIZ_Realm].phase3b) then
		if (FIZ_Data.SSO[FIZ_Realm].phase3b ==0) then
			phase3b = FIZ_TXT.phase3bWaiting
		elseif (FIZ_Data.SSO[FIZ_Realm].phase3b ==1) then
			phase3b = FIZ_TXT.phase3bActive
		elseif (FIZ_Data.SSO[FIZ_Realm].phase3b ==2) then
			phase3b = FIZ_TXT.phase3bDone
		end
	end

	if (FIZ_Data.SSO[FIZ_Realm].phase4b) then
		if (FIZ_Data.SSO[FIZ_Realm].phase4b ==0) then
			phase4b = FIZ_TXT.phase4Waiting
		elseif (FIZ_Data.SSO[FIZ_Realm].phase4b ==1) then
			phase4b = FIZ_TXT.phase4bActive
		elseif (FIZ_Data.SSO[FIZ_Realm].phase4b ==2) then
			phase4b = FIZ_TXT.phase4bDone
		end
	end

	if (FIZ_Data.SSO[FIZ_Realm].phase4c) then
		if (FIZ_Data.SSO[FIZ_Realm].phase4c ==0) then
			phase4c = FIZ_TXT.phase4Waiting
		elseif (FIZ_Data.SSO[FIZ_Realm].phase4c ==1) then
			phase4c = FIZ_TXT.phase4cActive
		elseif (FIZ_Data.SSO[FIZ_Realm].phase4c ==2) then
			phase4c = FIZ_TXT.phase4cDone
		end
	end

	FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.sso_status.." ["..FIZ_Realm.."]")
	FIZ_Print("   "..FIZ_HELP_COLOUR..FIZ_TXT.sso_main..":|r "..main_phase)
	FIZ_Print("   "..FIZ_HELP_COLOUR..FIZ_TXT.sso_phase2b..":|r "..phase2b)
	FIZ_Print("   "..FIZ_HELP_COLOUR..FIZ_TXT.sso_phase3b..":|r "..phase3b)
	FIZ_Print("   "..FIZ_HELP_COLOUR..FIZ_TXT.sso_phase4b..":|r "..phase4b)
	FIZ_Print("   "..FIZ_HELP_COLOUR..FIZ_TXT.sso_phase4c..":|r "..phase4c)
end

function FIZ_SSOWarning(name)
	name = string.lower(name)
	if (FIZ_FactionMapping[name]) then
		name = FIZ_FactionMapping[name]
	end

	if (name == "shattered sun offensive" and not FIZ_SSO_WARNED) then
		if (not FIZ_Data.SSO[FIZ_Realm].phase or FIZ_Data.SSO[FIZ_Realm].phase == 0) then
			FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_ERROR_COLOUR..FIZ_TXT.sso_warning)
		end
		FIZ_SSO_WARNED = true
	end
end

--------------------------
-- _20_ sso phase handling UI glue
--------------------------
-- todo

--------------------------
-- _21_ extracting skill information
--------------------------
function FIZ_ExtractSkills()
	FIZ_Herb = false
	FIZ_Skin = false
	FIZ_Mine = false

	for skillIndex = 1, GetNumSkillLines() do
		skillName = GetSkillLineInfo(skillIndex)
		if isHeader == nil then
			if (skillName == FIZ_TXT.skillHerb) then
				FIZ_Herb = true
			elseif (skillName == FIZ_TXT.skillSkin) then
				FIZ_Skin = true
			elseif (skillName == FIZ_TXT.skillMine) then
				FIZ_Mine = true
			-- todo: add secondary and crafting professions if needed
			--else
			end
		end
	end
end

--------------------------
-- _22_ extracting skill information
--------------------------
function FIZ_UpdateChatFrame()
	if not FIZ_updatingChatFrame then
		FIZ_updatingChatFrame = true

		-- Store the new value
		FIZ_Data.ChatFrame = FIZ_ChatFrameSlider:GetValue()

		-- Update display
		if (FIZ_Data.ChatFrame == 0) then
			FIZ_ChatFrameText:SetText(FIZ_TXT.defaultChatFrame)
			FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.usingDefaultChatFrame)
		else
			local name, fontSize, r, g, b, alpha, shown, locked, docked = GetChatWindowInfo(FIZ_Data.ChatFrame)
			if (not name or name == "") then
				name = "Tab does not exist"
			end
			FIZ_ChatFrameText:SetText(string.format(FIZ_TXT.chatFrame, FIZ_Data.ChatFrame, name))
			FIZ_Print(FIZ_HELP_COLOUR..FIZ_NAME..":|r "..FIZ_TXT.usingChatFrame.." "..FIZ_Data.ChatFrame.." ("..name..")")
		end

		FIZ_updatingChatFrame = nil
	end
end
