--GrinderCore 1.3
--Written By Tiok - US Thrall

GrinderCore_AltBags = {};

function GrinderCore_OnLoad()
    GrinderCore_RegisterEvents();
end

function GrinderCore_RegisterEvents()
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("PLAYERBANKSLOTS_CHANGED");
    this:RegisterEvent("BAG_UPDATE");
end

function GrinderCore_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then
        GrinderCore_Init();
    elseif( event == "BAG_UPDATE" ) then
	GrinderCore_UpdateItemCounts();
    elseif( event == "PLAYERBANKSLOTS_CHANGED" ) then
	GrinderCore_UpdateItemCounts();
    end
end

function GrinderCore_Init()
    --Make sure the Settings variables exist.
    if(GrinderCore_Settings == nil)or(GrinderCore_Settings["Version"] == nil)or(GrinderCore_Settings["Version"] < 1.3)then
	GrinderCore_Settings = 
	{
	    ["Version"] = 1.3;
	    ["Item IDs"] = {}; --Key: Item Name, Value: Item ID
	    ["Item Colors"] ={}; --Key: Item Name, Value: grey/white/green/blue/purple/orange/red
	    ["Item Tracked By"] = {}; --Key: Item Name, Value: set of SubGrinder Names (e.g. ADGrinder)
	    ["Item Update For"] = {}; --Key: SubGrinder Name, Value: T/F (set to true when any item for the given SubGrinder has changed count on this character)
	};

	GrinderCore_Inventories = nil;
    end

    --Make sure the Inventories variables exist.
    if(GrinderCore_Inventories == nil)then
	GrinderCore_Inventories = 
	{
	};
    end

    --Make sure there is an Inventories entry for the current character.
    if(GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")] == nil)then
	GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")] = 
	{
	    ["Carried"] = {};
	    ["Total"] = {};
	};
    end

    --Make sure each bag for the current character has a value for every registered item.
    for key,val in pairs(GrinderCore_Settings["Item IDs"]) do
	GrinderCore_AltBags[key] = 0;
	GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][key] = GetItemCount(val,false);
	GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][key] = GetItemCount(val,true);
    end

    --Calculate alt item totals here once so we never have to do it again.
    for RealmPlusName,_ in pairs(GrinderCore_Inventories) do
	local index = strfind(RealmPlusName, "_");
	local realm = strsub(RealmPlusName,1,index-1);
	local toonName = strsub(RealmPlusName,index+1,string.len(RealmPlusName));

	if((realm == GetRealmName()) and (toonName ~= UnitName("player")))then
	    for itemName,itemId in pairs(GrinderCore_Settings["Item IDs"])do
		if(GrinderCore_Inventories[RealmPlusName]["Total"][itemName] == nil) then GrinderCore_Inventories[RealmPlusName]["Total"][itemName] = 0; end
		GrinderCore_AltBags[itemName] = GrinderCore_AltBags[itemName] + GrinderCore_Inventories[RealmPlusName]["Total"][itemName];
	    end
	end
    end
    
    --Make sure the Factions variables exist
    if(GrinderCore_Factions == nil)then
	GrinderCore_Factions = 
	{
	    ["Rep Ground"] = {}; --Key: faction name, Value: # of rep earned while grinding
	    ["Grinding Time"] = {}; --Key: faction name, Value: # of seconds spent grinding
	};
    end
end

function GrinderCore_UpdateItemCounts()
    for itemName,itemID in pairs(GrinderCore_Settings["Item IDs"])do
	if(GetItemCount(itemID,false) ~= GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][itemName])or
          (GetItemCount(itemID,true) ~= GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][itemName])then
	    GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][itemName] = GetItemCount(itemID,false);
	    GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][itemName] = GetItemCount(itemID,true);
	    for _,addon in pairs(GrinderCore_Settings["Item Tracked By"][itemName]) do
		GrinderCore_Settings["Item Update For"][addon] = true;
	    end
        end
    end
end

function GrinderCore_IDFromItemLink(link)
    local index = strfind(link, ":");
    if ( index ) then
	link = strsub(link, index+1, index+8);
	index = strfind(link,":");
	if(index) then
	    link = strsub(link,1,index-1);
	else
	    link = "";
	end
    else
	link = "";
    end	
    return link;
end

function GrinderCore_TableContainsValue(table,value)
    local result = false;
    for _,val in pairs(table) do
	if(value == val)then
	    result = true;
	    break;
	end
    end
    return result;
end

function GrinderCore_RegisterItem(addon,itemName,itemID,itemColor)
    if(GrinderCore_Settings["Item IDs"][itemName] == nil)then
	--This item has not previously been tracked, so set it up everywhere!
	GrinderCore_Settings["Item IDs"][itemName] = itemID;
	GrinderCore_Settings["Item Colors"][itemName] = itemColor;
	GrinderCore_Settings["Item Tracked By"][itemName] = {addon};
	GrinderCore_Settings["Item Update For"][addon] = false;
	GrinderCore_AltBags[itemName] = 0;
	GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][itemName] = GetItemCount(itemID,false);
	GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][itemName] = GetItemCount(itemID,true);
    elseif (not(GrinderCore_TableContainsValue(GrinderCore_Settings["Item Tracked By"][itemName],addon))) then
	--This item has been previously tracked, so make sure this addon is in the tracking list.
	table.insert(GrinderCore_Settings["Item Tracked By"][itemName],addon);
    end
end

function GrinderCore_PlayerInventoryCount(itemName)
    if(GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][itemName] == nil)then
	return 0;
    else
	return GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Carried"][itemName];
    end
end

function GrinderCore_PlayerTotalCount(itemName)
    if(GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][itemName] == nil)then
	return 0;
    else
	return GrinderCore_Inventories[GetRealmName().."_"..UnitName("player")]["Total"][itemName];
    end
end

function GrinderCore_AltTotalCount(itemName)
    if(GrinderCore_AltBags[itemName] == nil)then
	return 0;
    else
	return GrinderCore_AltBags[itemName];
    end
end

function GrinderCore_GetGrindingTime(factionName)
    if(GrinderCore_Factions["Grinding Time"][factionName] == nil)then
	return 0;
    else
        return GrinderCore_Factions["Grinding Time"][factionName];
    end
end

function GrinderCore_SetGrindingTime(factionName,seconds)
    GrinderCore_Factions["Grinding Time"][factionName] = seconds;
end

function GrinderCore_GetRepGround(factionName)
    if(GrinderCore_Factions["Rep Ground"][factionName] == nil)then
	return 0;
    else
	return GrinderCore_Factions["Rep Ground"][factionName];
    end
end

function GrinderCore_SetRepGround(factionName,rep)
    GrinderCore_Factions["Rep Ground"][factionName] = rep;
end

function GrinderCore_FactionItemsChanged(addon)
    return GrinderCore_Settings["Item Update For"][addon];
end

function GrinderCore_AcknowledgeItemChange(addon)
    GrinderCore_Settings["Item Update For"][addon] = false;
end

function GrinderCore_ResetPlayerItemCounts()

end

function GrinderCore_GetItemColor(itemName)
    local color = GrinderCore_Settings["Item Colors"][itemName];

    if(color=="grey")then return FG_GREY;
    elseif(color=="white")then return FG_WHITE;
    elseif(color=="green")then return FG_GREEN;
    elseif(color=="blue")then return FG_SUPERIOR;
    elseif(color=="purple")then return FG_EPIC;
    elseif(color=="orange")then return FG_ORANGE;
    elseif(color=="red")then return FG_RED;
    else return ""; end
end
