--ZandalarTribeGrinder 1.0
--Written By Tiok - US Thrall

ZTG_INITIALREP = 0;

ZTG_NOW_GRINDING = false;
ZTG_PREVIOUS_GRINDING_TIME = 0;
ZTG_GRINDING_STARTED_AT = 0;
ZTG_PREVIOUS_REP_GROUND = 0;

ZTG_GRIND_UPDATE_INTERVAL = 1;
ZTG_NEXT_GRIND_UPDATE = 0;

ZTG_REP_VALUE = 0;

ZTG_TEXT = 
{
    ["Zandalar Tribe Faction Name"] = "Zandalar Tribe";
    ["ZT Rep"] = "ZT Rep";

    ["One Coin Set"] = "One Coin Set";
    ["Coin Sets"] = "Coin Sets";

    ["Zulian Coin"] = "Zulian Coin";
    ["Razzashi Coin"] = "Razzashi Coin";
    ["Hakkari Coin"] = "Hakkari Coin";
    ["Sandfury Coin"] = "Sandfury Coin";
    ["Skullsplitter Coin"] = "Skullsplitter Coin";
    ["Bloodscalp Coin"] = "Bloodscalp Coin";
    ["Gurubashi Coin"] = "Gurubashi Coin";
    ["Vilebranch Coin"] = "Vilebranch Coin";
    ["Witherbark Coin"] = "Witherbark Coin";

    ["Blue Hakkari Bijou"] = "Blue Hakkari Bijou";
    ["Bronze Hakkari Bijou"] = "Bronze Hakkari Bijou";
    ["Gold Hakkari Bijou"] = "Gold Hakkari Bijou";
    ["Green Hakkari Bijou"] = "Green Hakkari Bijou";
    ["Orange Hakkari Bijou"] = "Orange Hakkari Bijou";
    ["Purple Hakkari Bijou"] = "Purple Hakkari Bijou";
    ["Red Hakkari Bijou"] = "Red Hakkari Bijou";
    ["Silver Hakkari Bijou"] = "Silver Hakkari Bijou";
    ["Yellow Hakkari Bijou"] = "Yellow Hakkari Bijou";

    ["Zandalar Honor Token"] = "Zandalar Honor Token";
}

function InstallZandalarTribeGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ZandalarTribeGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ZandalarTribeGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ZandalarTribeGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ZandalarTribeGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ZandalarTribeGrinder"] = "ZTG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ZandalarTribeLabel");
    FG_ZandalarTribeLabel:SetFontObject("GameFontNormalSmall");
    FG_ZandalarTribeLabel:SetText("Zandalar Tribe");
    FG_ZandalarTribeLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ZandalarTribeTexture");
    ZandalarTribeTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Troll_01");
    ZandalarTribeTexture:SetWidth(24);
    ZandalarTribeTexture:SetHeight(24);
    ZandalarTribeTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ZandalarTribeTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ZandalarTribeGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ZandalarTribeGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ZandalarTribeGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ZandalarTribeGrinder_Init()
    ZTG_NEXT_GRIND_UPDATE = GetTime()+ZTG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ZandalarTribeGrinder","Zulian Coin","19698","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Razzashi Coin","19699","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Hakkari Coin","19700","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Sandfury Coin","19704","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Skullsplitter Coin","19705","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Bloodscalp Coin","19706","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Gurubashi Coin","19701","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Vilebranch Coin","19702","green");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Witherbark Coin","19703","green");

    GrinderCore_RegisterItem("ZandalarTribeGrinder","Blue Hakkari Bijou","19708","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Bronze Hakkari Bijou","19713","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Gold Hakkari Bijou","19715","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Green Hakkari Bijou","19711","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Orange Hakkari Bijou","19710","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Purple Hakkari Bijou","19712","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Red Hakkari Bijou","19707","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Silver Hakkari Bijou","19714","blue");
    GrinderCore_RegisterItem("ZandalarTribeGrinder","Yellow Hakkari Bijou","19709","blue");

    GrinderCore_RegisterItem("ZandalarTribeGrinder","Zandalar Honor Token","19858","green");

    ZandalarTribeGrinder_UpdateDisplayData();
    ZandalarTribeGrinder_UpdateRepBars();
end

function ZandalarTribeGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName, coin1count, coin2count, coin3count;

    itemName = "Zulian Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_ZulianCoinCount"):SetText(itemCount);
    coin1count = itemCount;

    itemName = "Razzashi Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_RazzashiCoinCount"):SetText(itemCount);
    coin2count = itemCount;

    itemName = "Hakkari Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_HakkariCoinCount"):SetText(itemCount);
    coin3count = itemCount;

    itemCount = math.min(coin1count,math.min(coin2count,coin3count));
    repValue = repValue + (itemCount * 75);


    itemName = "Sandfury Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_SandfuryCoinCount"):SetText(itemCount);
    coin1count = itemCount;

    itemName = "Skullsplitter Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_SkullsplitterCoinCount"):SetText(itemCount);
    coin2count = itemCount;

    itemName = "Bloodscalp Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_BloodscalpCoinCount"):SetText(itemCount);
    coin3count = itemCount;

    itemCount = math.min(coin1count,math.min(coin2count,coin3count));
    repValue = repValue + (itemCount * 75);


    itemName = "Gurubashi Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_GurubashiCoinCount"):SetText(itemCount);
    coin1count = itemCount;

    itemName = "Vilebranch Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_VilebranchCoinCount"):SetText(itemCount);
    coin2count = itemCount;

    itemName = "Witherbark Coin";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    getglobal("ZTG_WitherbarkCoinCount"):SetText(itemCount);
    coin3count = itemCount;

    itemCount = math.min(coin1count,math.min(coin2count,coin3count));
    repValue = repValue + (itemCount * 75);

    --Honor Tokens
    itemName = "Zandalar Honor Token";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*50);
    getglobal("ZTG_ZandalarHonorTokenCount"):SetText(itemCount);

    --Bijous
    itemName = "Blue Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_BlueHakkariBijouCount"):SetText(itemCount);

    itemName = "Bronze Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_BronzeHakkariBijouCount"):SetText(itemCount);

    itemName = "Gold Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_GoldHakkariBijouCount"):SetText(itemCount);

    itemName = "Green Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_GreenHakkariBijouCount"):SetText(itemCount);

    itemName = "Orange Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_OrangeHakkariBijouCount"):SetText(itemCount);

    itemName = "Purple Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_PurpleHakkariBijouCount"):SetText(itemCount);

    itemName = "Red Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_RedHakkariBijouCount"):SetText(itemCount);

    itemName = "Silver Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_SilverHakkariBijouCount"):SetText(itemCount);

    itemName = "Yellow Hakkari Bijou";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (itemCount*125);
    getglobal("ZTG_YellowHakkariBijouCount"):SetText(itemCount);


    itemName = "Zandalar Honor Token";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*50);
    getglobal("ZTG_ZandalarHonorTokenCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("ZTG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(ZTG_REP_VALUE ~= repValue)then
        ZTG_REP_VALUE = repValue;
	ZandalarTribeGrinder_UpdateRepBars();
    end
end

function ZandalarTribeGrinder_OnLoad()
    ZandalarTribeGrinder_RegisterEvents();
end

function ZandalarTribeGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ZandalarTribeGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ZandalarTribeGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ZandalarTribeGrinder_UpdateDisplayData();
	ZandalarTribeGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ZandalarTribeGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Zandalar Tribe",GrinderCore_GetGrindingTime("Zandalar Tribe")+ZTG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Zandalar Tribe",GrinderCore_GetRepGround("Zandalar Tribe")+ZTG_PREVIOUS_REP_GROUND);
	if(ZTG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Zandalar Tribe",GrinderCore_GetGrindingTime("Zandalar Tribe")+(GetTime()-ZTG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Zandalar Tribe",GrinderCore_GetRepGround("Zandalar Tribe")+(ZTG_GetCurrentRepTotal() - ZTG_INITIALREP));
	end
    end
end

function ZandalarTribeGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	ZTG_TEXT = ZTG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ZandalarTribeGrinderGrindFrame"):SetWidth(215);
	getglobal("ZTG_TimeTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ZTG_RepTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ZTG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ZTG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ZTG_TimeTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ZTG_RepTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ZTG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ZTG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	ZTG_TEXT = ZTG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("ZTG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	ZTG_TEXT = ZTG_TEXT_ZHTW;

	getglobal("ZTG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_ZTRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("ZTGToRepUpFrame"):SetWidth(90);
	getglobal("ZTGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("ZTG_SB_ActualRep"):SetWidth(80);
    	getglobal("ZTG_SB_RepWithItems"):SetWidth(80);

	getglobal("ZandalarTribeGrinderGrindFrame"):SetWidth(215);
	getglobal("ZTG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ZTG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("ZTG_TimeTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ZTG_RepTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ZTG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ZTG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ZTG_TimeTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ZTG_RepTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ZTG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ZTG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ZandalarTribeGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("ZTG_ZTRep"):SetText(ZTG_TEXT["ZT Rep"]);
    
    getglobal("ZTG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("ZTG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("ZTG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("ZTG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ZTG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ZTG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ZTG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("ZTG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ZTG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ZTG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ZTG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("ZTG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ZandalarTribeGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ZTG_TEXT["Zandalar Tribe Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("ZTG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(ZTG_REP_VALUE/42)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ZTG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/21)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ZTG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/12)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ZTG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/6)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ZTG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/3)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+ZTG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/3)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+ZTG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/3)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("ZTG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("ZTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+ZTG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(ZTG_REP_VALUE/36)/10;
	getglobal("ZTG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("ZTG_RepPoints"):SetText((earnedValue+ZTG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("ZTG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ZandalarTribeGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ZTG_TEXT["Zandalar Tribe Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-ZTG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-ZTG_REP_VALUE,0);
    end

    local fifty = 50;
    local seventyfive = 75;
    local onetwentyfive = 125;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	fifty = 55;
	seventyfive = 82.5;
	onetwentyfive = 137.5;
    end

    local tooltip = getglobal("ZTGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..ZTG_TEXT[text]);

    local itemCount;
    local CoinSetCount=0;
    if(text=="Zulian Coin")or(text=="Razzashi Coin")or(text=="Hakkari Coin")then
	itemName = "Zulian Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = itemCount;

	itemName = "Razzashi Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);

	itemName = "Hakkari Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);
    elseif(text=="Sandfury Coin")or(text=="Skullsplitter Coin")or(text=="Bloodscalp Coin")then
	itemName = "Sandfury Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = itemCount;

	itemName = "Skullsplitter Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);

	itemName = "Bloodscalp Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);
    elseif(text=="Gurubashi Coin")or(text=="Vilebranch Coin")or(text=="Witherbark Coin")then
	itemName = "Gurubashi Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = itemCount;

	itemName = "Vilebranch Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);

	itemName = "Witherbark Coin";
        if(FactionGrinderSettings["Include Bank Bags"])then
 	    itemCount = GrinderCore_PlayerTotalCount(itemName);
        else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
        end
        if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
        end
	CoinSetCount = math.min(CoinSetCount,itemCount);
    end

    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Zandalar Honor Token")and(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(string.find(text,"Bijou"))then
	reward = onetwentyfive;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Altar of Zanza"].." - "..FG_TEXT["Stranglethorn Vale"].." (13,15)");
    elseif(string.find(text,"Coin"))then
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..ZTG_TEXT["One Coin Set"].." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..CoinSetCount.." "..ZTG_TEXT["Coin Sets"].." = "..(CoinSetCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..ZTG_TEXT["Coin Sets"].." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..ZTG_TEXT["Coin Sets"].." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Vinchaxa"].." - "..FG_TEXT["Stranglethorn Vale"].." (15,16)");
    elseif(text=="Zandalar Honor Token")then
	reward = fifty;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ZandalarTribeGrinder_HideToolTip()
    getglobal("ZTGToolTip"):Hide();
end

function ZTG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ZTG_TEXT["Zandalar Tribe Faction Name"]))) then
	    return earnedValue + ZTG_REP_VALUE;
	end
    end
    return ZTG_REP_VALUE;
end

function ZandalarTribeGrinder_ToggleGrinding()
    ZTG_NOW_GRINDING = not ZTG_NOW_GRINDING;

    local button = getglobal("ZTG_BU_ToggleGrinding");
    if(ZTG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("ZTG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	ZTG_GRINDING_STARTED_AT = GetTime();
	ZTG_INITIALREP = ZTG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("ZTG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	ZTG_PREVIOUS_GRINDING_TIME = ZTG_PREVIOUS_GRINDING_TIME + (GetTime()-ZTG_GRINDING_STARTED_AT);
	ZTG_PREVIOUS_REP_GROUND = ZTG_PREVIOUS_REP_GROUND + (ZTG_GetCurrentRepTotal() - ZTG_INITIALREP); 
    end
end

function ZandalarTribeGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ZandalarTribeGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ZandalarTribeGrinder");
	ZandalarTribeGrinder_UpdateDisplayData();
    end

    if(GetTime() > ZTG_NEXT_GRIND_UPDATE)then
	ZTG_NEXT_GRIND_UPDATE = ZTG_NEXT_GRIND_UPDATE + ZTG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(ZTG_NOW_GRINDING)then	
	    getglobal("ZTG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ZTG_PREVIOUS_GRINDING_TIME + (GetTime()-ZTG_GRINDING_STARTED_AT)));
	    getglobal("ZTG_RepTodayVal"):SetText(FG_GREY..(ZTG_PREVIOUS_REP_GROUND + (ZTG_GetCurrentRepTotal() - ZTG_INITIALREP)));
	    RepPerSecond = ((ZTG_PREVIOUS_REP_GROUND + (ZTG_GetCurrentRepTotal() - ZTG_INITIALREP)) / 
                            math.max(math.floor(ZTG_PREVIOUS_GRINDING_TIME + (GetTime()-ZTG_GRINDING_STARTED_AT)),1));
	    getglobal("ZTG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ZTG_TimeToRepUpTodayVal"):SetText(FG_GREY..ZTG_TimeToRepUp(RepPerSecond));

	    getglobal("ZTG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Zandalar Tribe")+ZTG_PREVIOUS_GRINDING_TIME + (GetTime()-ZTG_GRINDING_STARTED_AT)));
	    getglobal("ZTG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Zandalar Tribe")+ZTG_PREVIOUS_REP_GROUND + (ZTG_GetCurrentRepTotal() - ZTG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Zandalar Tribe")+ZTG_PREVIOUS_REP_GROUND + (ZTG_GetCurrentRepTotal() - ZTG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Zandalar Tribe")+ZTG_PREVIOUS_GRINDING_TIME + (GetTime()-ZTG_GRINDING_STARTED_AT)),1));
	    getglobal("ZTG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ZTG_TimeToRepUpTotalVal"):SetText(FG_GREY..ZTG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("ZTG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ZTG_PREVIOUS_GRINDING_TIME));
	    getglobal("ZTG_RepTodayVal"):SetText(FG_GREY..(ZTG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (ZTG_PREVIOUS_REP_GROUND / math.max(ZTG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("ZTG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ZTG_TimeToRepUpTodayVal"):SetText(FG_GREY..ZTG_TimeToRepUp(RepPerSecond));

	    getglobal("ZTG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Zandalar Tribe")+ZTG_PREVIOUS_GRINDING_TIME));
	    getglobal("ZTG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Zandalar Tribe")+ZTG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Zandalar Tribe")+ZTG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Zandalar Tribe")+ZTG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("ZTG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ZTG_TimeToRepUpTotalVal"):SetText(FG_GREY..ZTG_TimeToRepUp(RepPerSecond));
        end
    end
end

function ZTG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ZTG_TEXT["Zandalar Tribe Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-ZTG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ZandalarTribeGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(ZTG_TEXT[itemName]);
    end
end
