--VioletEyeGrinder 1.0
--Written By Tiok - US Thrall

VEG_INITIALREP = 0;

VEG_NOW_GRINDING = false;
VEG_PREVIOUS_GRINDING_TIME = 0;
VEG_GRINDING_STARTED_AT = 0;
VEG_PREVIOUS_REP_GROUND = 0;

VEG_GRIND_UPDATE_INTERVAL = 1;
VEG_NEXT_GRIND_UPDATE = 0;

VEG_REP_VALUE = 0;

VEG_TEXT = 
{
    ["Violet Eye Faction Name"] = "The Violet Eye";
    ["VE Rep"] = "VE Rep";
}

function InstallVioletEyeGrinder()
    --Add this faction to the "Show" settings.
    --if (FactionGrinderSettings["Show"]["VioletEyeGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["VioletEyeGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["VioletEyeGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["VioletEyeGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["VioletEyeGrinder"] = "VEG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_VioletEyeLabel");
    FG_VioletEyeLabel:SetFontObject("GameFontNormalSmall");
    FG_VioletEyeLabel:SetText("The Violet Eye");
    FG_VioletEyeLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("VioletEyeTexture");
    VioletEyeTexture:SetTexture("Interface\\Icons\\INV_Trinket_Naxxramas02");
    VioletEyeTexture:SetWidth(24);
    VioletEyeTexture:SetHeight(24);
    VioletEyeTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    VioletEyeTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    --local cb = CreateFrame("CheckButton","FG_CB_VioletEyeGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    --cb:SetChecked(false);
    --cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_VioletEyeGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function VioletEyeGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function VioletEyeGrinder_Init()
    VEG_NEXT_GRIND_UPDATE = GetTime()+VEG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here
    
    --If any, Item Registrations would occur here.

    VioletEyeGrinder_UpdateDisplayData();
    VioletEyeGrinder_UpdateRepBars();
end

function VioletEyeGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    --If any, calculations of reputation based on items would occur here.

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("VEG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(VEG_REP_VALUE ~= repValue)then
        VEG_REP_VALUE = repValue;
	VioletEyeGrinder_UpdateRepBars();
    end
end

function VioletEyeGrinder_OnLoad()
    VioletEyeGrinder_RegisterEvents();
end

function VioletEyeGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        VioletEyeGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	VioletEyeGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	VioletEyeGrinder_UpdateDisplayData();
	VioletEyeGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	VioletEyeGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("The Violet Eye",GrinderCore_GetGrindingTime("The Violet Eye")+VEG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("The Violet Eye",GrinderCore_GetRepGround("The Violet Eye")+VEG_PREVIOUS_REP_GROUND);
	if(VEG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("The Violet Eye",GrinderCore_GetGrindingTime("The Violet Eye")+(GetTime()-VEG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("The Violet Eye",GrinderCore_GetRepGround("The Violet Eye")+(VEG_GetCurrentRepTotal() - VEG_INITIALREP));
	end
    end
end

function VioletEyeGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	VEG_TEXT = VEG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("VioletEyeGrinderGrindFrame"):SetWidth(215);
	getglobal("VEG_TimeTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("VEG_RepTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("VEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("VEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("VEG_TimeTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("VEG_RepTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("VEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("VEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	VEG_TEXT = VEG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("VEG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	VEG_TEXT = VEG_TEXT_ZHTW;

	getglobal("VEG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_VERep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("VEGToRepUpFrame"):SetWidth(90);
	getglobal("VEGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("VEG_SB_ActualRep"):SetWidth(80);
    	getglobal("VEG_SB_RepWithItems"):SetWidth(80);

	getglobal("VioletEyeGrinderGrindFrame"):SetWidth(215);
	getglobal("VEG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("VEG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("VEG_TimeTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("VEG_RepTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("VEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("VEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("VEG_TimeTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("VEG_RepTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("VEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("VEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","VioletEyeGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("VEG_VERep"):SetText(VEG_TEXT["VE Rep"]);
    
    getglobal("VEG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("VEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("VEG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("VEG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("VEG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("VEG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("VEG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("VEG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("VEG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("VEG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("VEG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("VEG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function VioletEyeGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, VEG_TEXT["Violet Eye Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("VEG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(VEG_REP_VALUE/42)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+VEG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(VEG_REP_VALUE/21)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+VEG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(VEG_REP_VALUE/12)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+VEG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(VEG_REP_VALUE/6)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+VEG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(VEG_REP_VALUE/3)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+VEG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(VEG_REP_VALUE/3)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+VEG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(VEG_REP_VALUE/3)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("VEG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("VEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+VEG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(VEG_REP_VALUE/36)/10;
	getglobal("VEG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("VEG_RepPoints"):SetText((earnedValue+VEG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("VEG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function VioletEyeGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, VEG_TEXT["Violet Eye Faction Name"]))) then
	    factionFound = true;
 	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-VEG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
    end

    local tooltip = getglobal("VEGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..VEG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

--    if(text=="Deadwood Headdress Feather")then
--	tooltip:AddLine(FG_GREY.."5 = "..seventyfive.." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*seventyfive).." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/seventyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
--    end
--    tooltip:Show();
    tooltip:ClearAllPoints();
--    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function VioletEyeGrinder_HideToolTip()
    getglobal("VEGToolTip"):Hide();
end

function VEG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, VEG_TEXT["Violet Eye Faction Name"]))) then
	    return earnedValue + VEG_REP_VALUE;
	end
    end
    return VEG_REP_VALUE;
end

function VioletEyeGrinder_ToggleGrinding()
    VEG_NOW_GRINDING = not VEG_NOW_GRINDING;

    local button = getglobal("VEG_BU_ToggleGrinding");
    if(VEG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("VEG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	VEG_GRINDING_STARTED_AT = GetTime();
	VEG_INITIALREP = VEG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("VEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	VEG_PREVIOUS_GRINDING_TIME = VEG_PREVIOUS_GRINDING_TIME + (GetTime()-VEG_GRINDING_STARTED_AT);
	VEG_PREVIOUS_REP_GROUND = VEG_PREVIOUS_REP_GROUND + (VEG_GetCurrentRepTotal() - VEG_INITIALREP); 
    end
end

function VioletEyeGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("VioletEyeGrinder"))then	
	GrinderCore_AcknowledgeItemChange("VioletEyeGrinder");
	VioletEyeGrinder_UpdateDisplayData();
    end

    if(GetTime() > VEG_NEXT_GRIND_UPDATE)then
	VEG_NEXT_GRIND_UPDATE = VEG_NEXT_GRIND_UPDATE + VEG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(VEG_NOW_GRINDING)then	
	    getglobal("VEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(VEG_PREVIOUS_GRINDING_TIME + (GetTime()-VEG_GRINDING_STARTED_AT)));
	    getglobal("VEG_RepTodayVal"):SetText(FG_GREY..(VEG_PREVIOUS_REP_GROUND + (VEG_GetCurrentRepTotal() - VEG_INITIALREP)));
	    RepPerSecond = ((VEG_PREVIOUS_REP_GROUND + (VEG_GetCurrentRepTotal() - VEG_INITIALREP)) / 
                            math.max(math.floor(VEG_PREVIOUS_GRINDING_TIME + (GetTime()-VEG_GRINDING_STARTED_AT)),1));
	    getglobal("VEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("VEG_TimeToRepUpTodayVal"):SetText(FG_GREY..VEG_TimeToRepUp(RepPerSecond));

	    getglobal("VEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Violet Eye")+VEG_PREVIOUS_GRINDING_TIME + (GetTime()-VEG_GRINDING_STARTED_AT)));
	    getglobal("VEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Violet Eye")+VEG_PREVIOUS_REP_GROUND + (VEG_GetCurrentRepTotal() - VEG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Violet Eye")+VEG_PREVIOUS_REP_GROUND + (VEG_GetCurrentRepTotal() - VEG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Violet Eye")+VEG_PREVIOUS_GRINDING_TIME + (GetTime()-VEG_GRINDING_STARTED_AT)),1));
	    getglobal("VEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("VEG_TimeToRepUpTotalVal"):SetText(FG_GREY..VEG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("VEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(VEG_PREVIOUS_GRINDING_TIME));
	    getglobal("VEG_RepTodayVal"):SetText(FG_GREY..(VEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (VEG_PREVIOUS_REP_GROUND / math.max(VEG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("VEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("VEG_TimeToRepUpTodayVal"):SetText(FG_GREY..VEG_TimeToRepUp(RepPerSecond));

	    getglobal("VEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Violet Eye")+VEG_PREVIOUS_GRINDING_TIME));
	    getglobal("VEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Violet Eye")+VEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Violet Eye")+VEG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Violet Eye")+VEG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("VEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("VEG_TimeToRepUpTotalVal"):SetText(FG_GREY..VEG_TimeToRepUp(RepPerSecond));
        end
    end
end

function VEG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, VEG_TEXT["Violet Eye Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-VEG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function VioletEyeGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(itemName);
    end
end
