--UndercityGrinder 1.0
--Written By Tiok - US Thrall

UCG_INITIALREP = 0;

UCG_NOW_GRINDING = false;
UCG_PREVIOUS_GRINDING_TIME = 0;
UCG_GRINDING_STARTED_AT = 0;
UCG_PREVIOUS_REP_GROUND = 0;

UCG_GRIND_UPDATE_INTERVAL = 1;
UCG_NEXT_GRIND_UPDATE = 0;

UCG_REP_VALUE = 0;

UCG_TEXT = 
{
    ["Undercity Faction Name"] = "Undercity";
    ["UC Rep"] = "UC Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallUndercityGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["UndercityGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["UndercityGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["UndercityGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["UndercityGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["UndercityGrinder"] = "UCG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_UndercityLabel");
    FG_UndercityLabel:SetFontObject("GameFontNormalSmall");
    FG_UndercityLabel:SetText("Undercity");
    FG_UndercityLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("UndercityTexture");
    UndercityTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Undead_01");
    UndercityTexture:SetWidth(24);
    UndercityTexture:SetHeight(24);
    UndercityTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    UndercityTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_UndercityGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_UndercityGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function UndercityGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function UndercityGrinder_Init()
    UCG_NEXT_GRIND_UPDATE = GetTime()+UCG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("UndercityGrinder","Runecloth","14047","white");

    UndercityGrinder_UpdateDisplayData();
    UndercityGrinder_UpdateRepBars();
end

function UndercityGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("UCG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("UCG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(UCG_REP_VALUE ~= repValue)then
        UCG_REP_VALUE = repValue;
	UndercityGrinder_UpdateRepBars();
    end
end

function UndercityGrinder_OnLoad()
    UndercityGrinder_RegisterEvents();
end

function UndercityGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        UndercityGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	UndercityGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	UndercityGrinder_UpdateDisplayData();
	UndercityGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	UndercityGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Undercity",GrinderCore_GetGrindingTime("Undercity")+UCG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Undercity",GrinderCore_GetRepGround("Undercity")+UCG_PREVIOUS_REP_GROUND);
	if(UCG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Undercity",GrinderCore_GetGrindingTime("Undercity")+(GetTime()-UCG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Undercity",GrinderCore_GetRepGround("Undercity")+(UCG_GetCurrentRepTotal() - UCG_INITIALREP));
	end
    end
end

function UndercityGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	UCG_TEXT = UCG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("UndercityGrinderGrindFrame"):SetWidth(215);
	getglobal("UCG_TimeTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("UCG_RepTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("UCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("UCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("UCG_TimeTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("UCG_RepTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("UCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("UCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	UCG_TEXT = UCG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("UCG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	UCG_TEXT = UCG_TEXT_ZHTW;

	getglobal("UCG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_UCRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("UCGToRepUpFrame"):SetWidth(90);
	getglobal("UCGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("UCG_SB_ActualRep"):SetWidth(80);
    	getglobal("UCG_SB_RepWithItems"):SetWidth(80);

	getglobal("UndercityGrinderGrindFrame"):SetWidth(215);
	getglobal("UCG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("UCG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("UCG_TimeTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("UCG_RepTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("UCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("UCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("UCG_TimeTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("UCG_RepTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("UCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("UCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","UndercityGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("UCG_UCRep"):SetText(UCG_TEXT["UC Rep"]);
    
    getglobal("UCG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("UCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("UCG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("UCG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("UCG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("UCG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("UCG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("UCG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("UCG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("UCG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("UCG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("UCG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function UndercityGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, UCG_TEXT["Undercity Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("UCG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(UCG_REP_VALUE/42)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+UCG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(UCG_REP_VALUE/21)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+UCG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(UCG_REP_VALUE/12)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+UCG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(UCG_REP_VALUE/6)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+UCG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(UCG_REP_VALUE/3)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+UCG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(UCG_REP_VALUE/3)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+UCG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(UCG_REP_VALUE/3)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("UCG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("UCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+UCG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(UCG_REP_VALUE/36)/10;
	getglobal("UCG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("UCG_RepPoints"):SetText((earnedValue+UCG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("UCG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function UndercityGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, UCG_TEXT["Undercity Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-UCG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-UCG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("UCGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..UCG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Ralston Farnsley"].." - "..FG_TEXT["Undercity"].." (71,29)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function UndercityGrinder_HideToolTip()
    getglobal("UCGToolTip"):Hide();
end

function UCG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, UCG_TEXT["Undercity Faction Name"]))) then
	    return earnedValue + UCG_REP_VALUE;
	end
    end
    return UCG_REP_VALUE;
end

function UndercityGrinder_ToggleGrinding()
    UCG_NOW_GRINDING = not UCG_NOW_GRINDING;

    local button = getglobal("UCG_BU_ToggleGrinding");
    if(UCG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("UCG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	UCG_GRINDING_STARTED_AT = GetTime();
	UCG_INITIALREP = UCG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("UCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	UCG_PREVIOUS_GRINDING_TIME = UCG_PREVIOUS_GRINDING_TIME + (GetTime()-UCG_GRINDING_STARTED_AT);
	UCG_PREVIOUS_REP_GROUND = UCG_PREVIOUS_REP_GROUND + (UCG_GetCurrentRepTotal() - UCG_INITIALREP); 
    end
end

function UndercityGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("UndercityGrinder"))then	
	GrinderCore_AcknowledgeItemChange("UndercityGrinder");
	UndercityGrinder_UpdateDisplayData();
    end

    if(GetTime() > UCG_NEXT_GRIND_UPDATE)then
	UCG_NEXT_GRIND_UPDATE = UCG_NEXT_GRIND_UPDATE + UCG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(UCG_NOW_GRINDING)then	
	    getglobal("UCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(UCG_PREVIOUS_GRINDING_TIME + (GetTime()-UCG_GRINDING_STARTED_AT)));
	    getglobal("UCG_RepTodayVal"):SetText(FG_GREY..(UCG_PREVIOUS_REP_GROUND + (UCG_GetCurrentRepTotal() - UCG_INITIALREP)));
	    RepPerSecond = ((UCG_PREVIOUS_REP_GROUND + (UCG_GetCurrentRepTotal() - UCG_INITIALREP)) / 
                            math.max(math.floor(UCG_PREVIOUS_GRINDING_TIME + (GetTime()-UCG_GRINDING_STARTED_AT)),1));
	    getglobal("UCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("UCG_TimeToRepUpTodayVal"):SetText(FG_GREY..UCG_TimeToRepUp(RepPerSecond));

	    getglobal("UCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Undercity")+UCG_PREVIOUS_GRINDING_TIME + (GetTime()-UCG_GRINDING_STARTED_AT)));
	    getglobal("UCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Undercity")+UCG_PREVIOUS_REP_GROUND + (UCG_GetCurrentRepTotal() - UCG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Undercity")+UCG_PREVIOUS_REP_GROUND + (UCG_GetCurrentRepTotal() - UCG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Undercity")+UCG_PREVIOUS_GRINDING_TIME + (GetTime()-UCG_GRINDING_STARTED_AT)),1));
	    getglobal("UCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("UCG_TimeToRepUpTotalVal"):SetText(FG_GREY..UCG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("UCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(UCG_PREVIOUS_GRINDING_TIME));
	    getglobal("UCG_RepTodayVal"):SetText(FG_GREY..(UCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (UCG_PREVIOUS_REP_GROUND / math.max(UCG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("UCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("UCG_TimeToRepUpTodayVal"):SetText(FG_GREY..UCG_TimeToRepUp(RepPerSecond));

	    getglobal("UCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Undercity")+UCG_PREVIOUS_GRINDING_TIME));
	    getglobal("UCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Undercity")+UCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Undercity")+UCG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Undercity")+UCG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("UCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("UCG_TimeToRepUpTotalVal"):SetText(FG_GREY..UCG_TimeToRepUp(RepPerSecond));
        end
    end
end

function UCG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, UCG_TEXT["Undercity Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-UCG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function UndercityGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(UCG_TEXT[itemName]);
    end
end
