--ThunderBluffGrinder 1.0
--Written By Tiok - US Thrall

TBG2_INITIALREP = 0;

TBG2_NOW_GRINDING = false;
TBG2_PREVIOUS_GRINDING_TIME = 0;
TBG2_GRINDING_STARTED_AT = 0;
TBG2_PREVIOUS_REP_GROUND = 0;

TBG2_GRIND_UPDATE_INTERVAL = 1;
TBG2_NEXT_GRIND_UPDATE = 0;

TBG2_REP_VALUE = 0;

TBG2_TEXT = 
{
    ["Thunder Bluff Faction Name"] = "Thunder Bluff";
    ["TB Rep"] = "TB Rep";

    ["Perfect Yeti Hide"] = "Perfect Yeti Hide";
    ["Morrowgrain"] = "Morrowgrain";
    ["Runecloth"] = "Runecloth";
}

function InstallThunderBluffGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ThunderBluffGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ThunderBluffGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ThunderBluffGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ThunderBluffGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ThunderBluffGrinder"] = "TBG2";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ThunderBluffLabel");
    FG_ThunderBluffLabel:SetFontObject("GameFontNormalSmall");
    FG_ThunderBluffLabel:SetText("Thunder Bluff");
    FG_ThunderBluffLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ThunderBluffTexture");
    ThunderBluffTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Tauren_02");
    ThunderBluffTexture:SetWidth(24);
    ThunderBluffTexture:SetHeight(24);
    ThunderBluffTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ThunderBluffTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ThunderBluffGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ThunderBluffGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ThunderBluffGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ThunderBluffGrinder_Init()
    TBG2_NEXT_GRIND_UPDATE = GetTime()+TBG2_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ThunderBluffGrinder","Perfect Yeti Hide","18972","white");
    GrinderCore_RegisterItem("ThunderBluffGrinder","Morrowgrain","11040","white");
    GrinderCore_RegisterItem("ThunderBluffGrinder","Runecloth","14047","white");

    ThunderBluffGrinder_UpdateDisplayData();
    ThunderBluffGrinder_UpdateRepBars();
end

function ThunderBluffGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Perfect Yeti Hide";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/1)*250);
    getglobal("TBG2_PerfectYetiHideCount"):SetText(itemCount);

    itemName = "Morrowgrain";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/10)*50);
    getglobal("TBG2_MorrowgrainCount"):SetText(itemCount);

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("TBG2_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("TBG2_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(TBG2_REP_VALUE ~= repValue)then
        TBG2_REP_VALUE = repValue;
	ThunderBluffGrinder_UpdateRepBars();
    end
end

function ThunderBluffGrinder_OnLoad()
    ThunderBluffGrinder_RegisterEvents();
end

function ThunderBluffGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ThunderBluffGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ThunderBluffGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ThunderBluffGrinder_UpdateDisplayData();
	ThunderBluffGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ThunderBluffGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Thunder Bluff",GrinderCore_GetGrindingTime("Thunder Bluff")+TBG2_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Thunder Bluff",GrinderCore_GetRepGround("Thunder Bluff")+TBG2_PREVIOUS_REP_GROUND);
	if(TBG2_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Thunder Bluff",GrinderCore_GetGrindingTime("Thunder Bluff")+(GetTime()-TBG2_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Thunder Bluff",GrinderCore_GetRepGround("Thunder Bluff")+(TBG2_GetCurrentRepTotal() - TBG2_INITIALREP));
	end
    end
end

function ThunderBluffGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	TBG2_TEXT = TBG2_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ThunderBluffGrinderGrindFrame"):SetWidth(215);
	getglobal("TBG2_TimeTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("TBG2_RepTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("TBG2_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("TBG2_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("TBG2_TimeTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("TBG2_RepTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("TBG2_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("TBG2_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	TBG2_TEXT = TBG2_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("TBG2_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	TBG2_TEXT = TBG2_TEXT_ZHTW;

	getglobal("TBG2_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_TBRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("TBG2ToRepUpFrame"):SetWidth(90);
	getglobal("TBG2ToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("TBG2_SB_ActualRep"):SetWidth(80);
    	getglobal("TBG2_SB_RepWithItems"):SetWidth(80);

	getglobal("ThunderBluffGrinderGrindFrame"):SetWidth(215);
	getglobal("TBG2_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG2_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("TBG2_TimeTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("TBG2_RepTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("TBG2_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("TBG2_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("TBG2_TimeTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("TBG2_RepTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("TBG2_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("TBG2_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThunderBluffGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("TBG2_TBRep"):SetText(TBG2_TEXT["TB Rep"]);
    
    getglobal("TBG2_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("TBG2_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("TBG2_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("TBG2_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("TBG2_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("TBG2_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("TBG2_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("TBG2_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("TBG2_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("TBG2_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("TBG2_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("TBG2_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ThunderBluffGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG2_TEXT["Thunder Bluff Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("TBG2_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(TBG2_REP_VALUE/42)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG2_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/21)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG2_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/12)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG2_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/6)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG2_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/3)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+TBG2_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/3)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+TBG2_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/3)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("TBG2_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("TBG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+TBG2_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(TBG2_REP_VALUE/36)/10;
	getglobal("TBG2_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("TBG2_RepPoints"):SetText((earnedValue+TBG2_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("TBG2_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ThunderBluffGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG2_TEXT["Thunder Bluff Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-TBG2_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-TBG2_REP_VALUE,0);
    end

    local twentyfive = 25;
    local fifty = 50;
    local seventyfive = 75;
    local twofifty = 250;    

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
    	fifty = 55;
    	seventyfive = 82.5;
    	twofifty = 275;
    end

    local tooltip = getglobal("TBG2ToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..TBG2_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Perfect Yeti Hide") and (FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Perfect Yeti Hide")then
	numNeeded = 1;
	reward = twofifty;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Jangdor Swiftstrider"].." - "..FG_TEXT["Feralas"].." (74,42)");
    elseif(text=="Morrowgrain")then
	numNeeded = 10;
	reward = fifty;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Bashana Runetotem"].." - "..FG_TEXT["Thunder Bluff"].." (70,33)");
    elseif(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Rumstag Proudstrider"].." - "..FG_TEXT["Thunder Bluff"].." (43,42)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ThunderBluffGrinder_HideToolTip()
    getglobal("TBG2ToolTip"):Hide();
end

function TBG2_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG2_TEXT["Thunder Bluff Faction Name"]))) then
	    return earnedValue + TBG2_REP_VALUE;
	end
    end
    return TBG2_REP_VALUE;
end

function ThunderBluffGrinder_ToggleGrinding()
    TBG2_NOW_GRINDING = not TBG2_NOW_GRINDING;

    local button = getglobal("TBG2_BU_ToggleGrinding");
    if(TBG2_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("TBG2_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	TBG2_GRINDING_STARTED_AT = GetTime();
	TBG2_INITIALREP = TBG2_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("TBG2_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	TBG2_PREVIOUS_GRINDING_TIME = TBG2_PREVIOUS_GRINDING_TIME + (GetTime()-TBG2_GRINDING_STARTED_AT);
	TBG2_PREVIOUS_REP_GROUND = TBG2_PREVIOUS_REP_GROUND + (TBG2_GetCurrentRepTotal() - TBG2_INITIALREP); 
    end
end

function ThunderBluffGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ThunderBluffGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ThunderBluffGrinder");
	ThunderBluffGrinder_UpdateDisplayData();
    end

    if(GetTime() > TBG2_NEXT_GRIND_UPDATE)then
	TBG2_NEXT_GRIND_UPDATE = TBG2_NEXT_GRIND_UPDATE + TBG2_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(TBG2_NOW_GRINDING)then	
	    getglobal("TBG2_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(TBG2_PREVIOUS_GRINDING_TIME + (GetTime()-TBG2_GRINDING_STARTED_AT)));
	    getglobal("TBG2_RepTodayVal"):SetText(FG_GREY..(TBG2_PREVIOUS_REP_GROUND + (TBG2_GetCurrentRepTotal() - TBG2_INITIALREP)));
	    RepPerSecond = ((TBG2_PREVIOUS_REP_GROUND + (TBG2_GetCurrentRepTotal() - TBG2_INITIALREP)) / 
                            math.max(math.floor(TBG2_PREVIOUS_GRINDING_TIME + (GetTime()-TBG2_GRINDING_STARTED_AT)),1));
	    getglobal("TBG2_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG2_TimeToRepUpTodayVal"):SetText(FG_GREY..TBG2_TimeToRepUp(RepPerSecond));

	    getglobal("TBG2_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thunder Bluff")+TBG2_PREVIOUS_GRINDING_TIME + (GetTime()-TBG2_GRINDING_STARTED_AT)));
	    getglobal("TBG2_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thunder Bluff")+TBG2_PREVIOUS_REP_GROUND + (TBG2_GetCurrentRepTotal() - TBG2_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thunder Bluff")+TBG2_PREVIOUS_REP_GROUND + (TBG2_GetCurrentRepTotal() - TBG2_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thunder Bluff")+TBG2_PREVIOUS_GRINDING_TIME + (GetTime()-TBG2_GRINDING_STARTED_AT)),1));
	    getglobal("TBG2_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG2_TimeToRepUpTotalVal"):SetText(FG_GREY..TBG2_TimeToRepUp(RepPerSecond));
        else
	    getglobal("TBG2_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(TBG2_PREVIOUS_GRINDING_TIME));
	    getglobal("TBG2_RepTodayVal"):SetText(FG_GREY..(TBG2_PREVIOUS_REP_GROUND));
	    RepPerSecond = (TBG2_PREVIOUS_REP_GROUND / math.max(TBG2_PREVIOUS_GRINDING_TIME,1));
	    getglobal("TBG2_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG2_TimeToRepUpTodayVal"):SetText(FG_GREY..TBG2_TimeToRepUp(RepPerSecond));

	    getglobal("TBG2_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thunder Bluff")+TBG2_PREVIOUS_GRINDING_TIME));
	    getglobal("TBG2_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thunder Bluff")+TBG2_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thunder Bluff")+TBG2_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thunder Bluff")+TBG2_PREVIOUS_GRINDING_TIME),1));
	    getglobal("TBG2_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG2_TimeToRepUpTotalVal"):SetText(FG_GREY..TBG2_TimeToRepUp(RepPerSecond));
        end
    end
end

function TBG2_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG2_TEXT["Thunder Bluff Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-TBG2_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ThunderBluffGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(TBG2_TEXT[itemName]);
    end
end
