--ThrallmarGrinder 1.0
--Written By Tiok - US Thrall

THG2_INITIALREP = 0;

THG2_NOW_GRINDING = false;
THG2_PREVIOUS_GRINDING_TIME = 0;
THG2_GRINDING_STARTED_AT = 0;
THG2_PREVIOUS_REP_GROUND = 0;

THG2_GRIND_UPDATE_INTERVAL = 1;
THG2_NEXT_GRIND_UPDATE = 0;

THG2_REP_VALUE = 0;

THG2_TEXT = 
{
    ["Thrallmar Faction Name"] = "Thrallmar";
    ["Th Rep"] = "Th Rep";
}

function InstallThrallmarGrinder()
    --Add this faction to the "Show" settings.
    --if (FactionGrinderSettings["Show"]["ThrallmarGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ThrallmarGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ThrallmarGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ThrallmarGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ThrallmarGrinder"] = "THG2";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ThrallmarLabel");
    FG_ThrallmarLabel:SetFontObject("GameFontNormalSmall");
    FG_ThrallmarLabel:SetText("Thrallmar");
    FG_ThrallmarLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ThrallmarTexture");
    ThrallmarTexture:SetTexture("Interface\\Icons\\INV_Misc_Token_Thrallmar");
    ThrallmarTexture:SetWidth(24);
    ThrallmarTexture:SetHeight(24);
    ThrallmarTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ThrallmarTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    --local cb = CreateFrame("CheckButton","FG_CB_ThrallmarGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    --cb:SetChecked(false);
    --cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ThrallmarGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ThrallmarGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ThrallmarGrinder_Init()
    THG2_NEXT_GRIND_UPDATE = GetTime()+THG2_GRIND_UPDATE_INTERVAL;
    --add variable initializations here
    
    --If any, Item Registrations would occur here.

    ThrallmarGrinder_UpdateDisplayData();
    ThrallmarGrinder_UpdateRepBars();
end

function ThrallmarGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    --If any, calculations of reputation based on items would occur here.

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("THG2_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(THG2_REP_VALUE ~= repValue)then
        THG2_REP_VALUE = repValue;
	ThrallmarGrinder_UpdateRepBars();
    end
end

function ThrallmarGrinder_OnLoad()
    ThrallmarGrinder_RegisterEvents();
end

function ThrallmarGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ThrallmarGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ThrallmarGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ThrallmarGrinder_UpdateDisplayData();
	ThrallmarGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ThrallmarGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Thrallmar",GrinderCore_GetGrindingTime("Thrallmar")+THG2_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Thrallmar",GrinderCore_GetRepGround("Thrallmar")+THG2_PREVIOUS_REP_GROUND);
	if(THG2_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Thrallmar",GrinderCore_GetGrindingTime("Thrallmar")+(GetTime()-THG2_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Thrallmar",GrinderCore_GetRepGround("Thrallmar")+(THG2_GetCurrentRepTotal() - THG2_INITIALREP));
	end
    end
end

function ThrallmarGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	THG2_TEXT = THG2_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ThrallmarGrinderGrindFrame"):SetWidth(215);
	getglobal("THG2_TimeTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("THG2_RepTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("THG2_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("THG2_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("THG2_TimeTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("THG2_RepTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("THG2_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("THG2_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	THG2_TEXT = THG2_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("THG2_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	THG2_TEXT = THG2_TEXT_ZHTW;

	getglobal("THG2_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_ThRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("THG2ToRepUpFrame"):SetWidth(90);
	getglobal("THG2ToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("THG2_SB_ActualRep"):SetWidth(80);
    	getglobal("THG2_SB_RepWithItems"):SetWidth(80);

	getglobal("ThrallmarGrinderGrindFrame"):SetWidth(215);
	getglobal("THG2_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("THG2_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("THG2_TimeTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("THG2_RepTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("THG2_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("THG2_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("THG2_TimeTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("THG2_RepTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("THG2_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("THG2_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThrallmarGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("THG2_ThRep"):SetText(THG2_TEXT["Th Rep"]);
    
    getglobal("THG2_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("THG2_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("THG2_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("THG2_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("THG2_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("THG2_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("THG2_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("THG2_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("THG2_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("THG2_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("THG2_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("THG2_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ThrallmarGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, THG2_TEXT["Thrallmar Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("THG2_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(THG2_REP_VALUE/42)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+THG2_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(THG2_REP_VALUE/21)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+THG2_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(THG2_REP_VALUE/12)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+THG2_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(THG2_REP_VALUE/6)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+THG2_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(THG2_REP_VALUE/3)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+THG2_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(THG2_REP_VALUE/3)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+THG2_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(THG2_REP_VALUE/3)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("THG2_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("THG2_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+THG2_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(THG2_REP_VALUE/36)/10;
	getglobal("THG2_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("THG2_RepPoints"):SetText((earnedValue+THG2_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("THG2_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ThrallmarGrinder_ShowTurninToolTip(text,color)
    local RepToRepUp = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, THG2_TEXT["Thrallmar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-THG2_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
    end

    local tooltip = getglobal("THG2ToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    if(color=="white")then
	tooltip:AddLine(FG_WHITE..THG2_TEXT[text]);
    elseif(color=="green")then
	tooltip:AddLine(FG_GREEN..THG2_TEXT[text]);
    elseif(color=="blue")then
	tooltip:AddLine(FG_SUPERIOR..THG2_TEXT[text]);
    elseif(color=="purple")then
	tooltip:AddLine(FG_EPIC..THG2_TEXT[text]);
    end

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

--    if(text=="Deadwood Headdress Feather")then
--	tooltip:AddLine(FG_GREY.."5 = "..seventyfive.." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*seventyfive).." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/seventyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
--    end
--    tooltip:Show();
    tooltip:ClearAllPoints();
--    tooltip:SetPoint("BOTTOM","ThrallmarGrinderDisplayFrame","TOP",0,-5);
end

function ThrallmarGrinder_HideToolTip()
    getglobal("THG2ToolTip"):Hide();
end

function THG2_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, THG2_TEXT["Thrallmar Faction Name"]))) then
	    return earnedValue + THG2_REP_VALUE;
	end
    end
    return THG2_REP_VALUE;
end

function ThrallmarGrinder_ToggleGrinding()
    THG2_NOW_GRINDING = not THG2_NOW_GRINDING;

    local button = getglobal("THG2_BU_ToggleGrinding");
    if(THG2_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("THG2_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	THG2_GRINDING_STARTED_AT = GetTime();
	THG2_INITIALREP = THG2_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("THG2_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	THG2_PREVIOUS_GRINDING_TIME = THG2_PREVIOUS_GRINDING_TIME + (GetTime()-THG2_GRINDING_STARTED_AT);
	THG2_PREVIOUS_REP_GROUND = THG2_PREVIOUS_REP_GROUND + (THG2_GetCurrentRepTotal() - THG2_INITIALREP); 
    end
end

function ThrallmarGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ThrallmarGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ThrallmarGrinder");
	ThrallmarGrinder_UpdateDisplayData();
    end

    if(GetTime() > THG2_NEXT_GRIND_UPDATE)then
	THG2_NEXT_GRIND_UPDATE = THG2_NEXT_GRIND_UPDATE + THG2_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(THG2_NOW_GRINDING)then	
	    getglobal("THG2_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(THG2_PREVIOUS_GRINDING_TIME + (GetTime()-THG2_GRINDING_STARTED_AT)));
	    getglobal("THG2_RepTodayVal"):SetText(FG_GREY..(THG2_PREVIOUS_REP_GROUND + (THG2_GetCurrentRepTotal() - THG2_INITIALREP)));
	    RepPerSecond = ((THG2_PREVIOUS_REP_GROUND + (THG2_GetCurrentRepTotal() - THG2_INITIALREP)) / 
                            math.max(math.floor(THG2_PREVIOUS_GRINDING_TIME + (GetTime()-THG2_GRINDING_STARTED_AT)),1));
	    getglobal("THG2_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("THG2_TimeToRepUpTodayVal"):SetText(FG_GREY..THG2_TimeToRepUp(RepPerSecond));

	    getglobal("THG2_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thrallmar")+THG2_PREVIOUS_GRINDING_TIME + (GetTime()-THG2_GRINDING_STARTED_AT)));
	    getglobal("THG2_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thrallmar")+THG2_PREVIOUS_REP_GROUND + (THG2_GetCurrentRepTotal() - THG2_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thrallmar")+THG2_PREVIOUS_REP_GROUND + (THG2_GetCurrentRepTotal() - THG2_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thrallmar")+THG2_PREVIOUS_GRINDING_TIME + (GetTime()-THG2_GRINDING_STARTED_AT)),1));
	    getglobal("THG2_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("THG2_TimeToRepUpTotalVal"):SetText(FG_GREY..THG2_TimeToRepUp(RepPerSecond));
        else
	    getglobal("THG2_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(THG2_PREVIOUS_GRINDING_TIME));
	    getglobal("THG2_RepTodayVal"):SetText(FG_GREY..(THG2_PREVIOUS_REP_GROUND));
	    RepPerSecond = (THG2_PREVIOUS_REP_GROUND / math.max(THG2_PREVIOUS_GRINDING_TIME,1));
	    getglobal("THG2_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("THG2_TimeToRepUpTodayVal"):SetText(FG_GREY..THG2_TimeToRepUp(RepPerSecond));

	    getglobal("THG2_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thrallmar")+THG2_PREVIOUS_GRINDING_TIME));
	    getglobal("THG2_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thrallmar")+THG2_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thrallmar")+THG2_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thrallmar")+THG2_PREVIOUS_GRINDING_TIME),1));
	    getglobal("THG2_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("THG2_TimeToRepUpTotalVal"):SetText(FG_GREY..THG2_TimeToRepUp(RepPerSecond));
        end
    end
end

function THG2_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_, isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, THG2_TEXT["Thrallmar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-THG2_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ThrallmarGrinder_ItemButtonClick(itemName, color)
    if(color == "white")then color = FG_WHITE;
    elseif(color == "green")then color = FG_GREEN;
    elseif(color == "blue")then color = FG_SUPERIOR;
    elseif(color == "purple")then color = FG_EPIC; end
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ((GrinderCore_PlayerInventoryCount(itemName) > 0)or(GrinderCore_PlayerTotalCount(itemName) > 0)or(GrinderCore_AltTotalCount(itemName) >0)))then
    	ChatFrameEditBox:Insert(color.."|Hitem:"..(GrinderCore_Settings["Item IDs"][itemName])..":0:0:0|h["..THG2_TEXT[itemName].."]|h|r");
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(itemName);
    end
end
