--ThoriumBrotherhoodGrinder 1.0
--Written By Tiok - US Thrall

TBG_INITIALREP = 0;

TBG_NOW_GRINDING = false;
TBG_PREVIOUS_GRINDING_TIME = 0;
TBG_GRINDING_STARTED_AT = 0;
TBG_PREVIOUS_REP_GROUND = 0;

TBG_GRIND_UPDATE_INTERVAL = 1;
TBG_NEXT_GRIND_UPDATE = 0;

TBG_REP_VALUE = 0;

TBG_TEXT = 
{
    ["Thorium Brotherhood Faction Name"] = "Thorium Brotherhood";
    ["TB Rep"] = "TB Rep";

    ["Incendosaur Scale"] = "Incendosaur Scale";
    ["Kingsblood"] = "Kingsblood";
    ["Iron Bar"] = "Iron Bar";
    ["Heavy Leather"] = "Heavy Leather";
    ["Coal"] = "Coal";
    ["Dark Iron Residue"] = "Dark Iron Residue";
    ["Dark Iron Ore"] = "Dark Iron Ore";
    ["Core Leather"] = "Core Leather";
    ["Fiery Core"] = "Fiery Core";
    ["Lava Core"] = "Lava Core";
    ["Blood of the Mountain"] = "Blood of the Mountain";

    ["One needed per Fiery Flux turn-in"] = "One needed per Fiery Flux turn-in";
    ["Two needed per Fiery Flux turn-in"] = "Two needed per Fiery Flux turn-in";
    ["turn-ins"] = "turn-ins";
}

function InstallThoriumBrotherhoodGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ThoriumBrotherhoodGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ThoriumBrotherhoodGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ThoriumBrotherhoodGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ThoriumBrotherhoodGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ThoriumBrotherhoodGrinder"] = "TBG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ThoriumBrotherhoodLabel");
    FG_ThoriumBrotherhoodLabel:SetFontObject("GameFontNormalSmall");
    FG_ThoriumBrotherhoodLabel:SetText("Thorium Brotherhood");
    FG_ThoriumBrotherhoodLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ThoriumBrotherhoodTexture");
    ThoriumBrotherhoodTexture:SetTexture("Interface\\Icons\\INV_Ingot_Mithril");
    ThoriumBrotherhoodTexture:SetWidth(24);
    ThoriumBrotherhoodTexture:SetHeight(24);
    ThoriumBrotherhoodTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ThoriumBrotherhoodTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ThoriumBrotherhoodGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ThoriumBrotherhoodGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ThoriumBrotherhoodGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ThoriumBrotherhoodGrinder_Init()
    TBG_NEXT_GRIND_UPDATE = GetTime()+TBG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Incendosaur Scale","18944","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Kingsblood","3356","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Iron Bar","3575","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Heavy Leather","4234","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Coal","3857","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Dark Iron Residue","18945","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Dark Iron Ore","11370","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Core Leather","17012","white");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Fiery Core","17010","blue");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Lava Core","17011","blue");
    GrinderCore_RegisterItem("ThoriumBrotherhoodGrinder","Blood of the Mountain","11382","green");

    ThoriumBrotherhoodGrinder_UpdateDisplayData();
    ThoriumBrotherhoodGrinder_UpdateRepBars();
end

function ThoriumBrotherhoodGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG_TEXT["Thorium Brotherhood Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    --Set only what is displayed on the DisplayFrame based on the current rep level.
    if(standingId <= 4)then
	itemName = "Kingsblood";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	local FriendlyTurninCount = math.floor(itemCount/4);
	getglobal("TBG_KingsbloodCount"):SetText(itemCount.."/4");

	itemName = "Iron Bar";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	FriendlyTurninCount = FriendlyTurninCount + math.floor(itemCount/4);
	getglobal("TBG_IronBarCount"):SetText(itemCount.."/4");

	itemName = "Heavy Leather";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	FriendlyTurninCount = FriendlyTurninCount + math.floor(itemCount/10);
	getglobal("TBG_HeavyLeatherCount"):SetText(itemCount.."/10");

	repValue = FriendlyTurninCount*25;

	itemName = "Incendosaur Scale";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	getglobal("TBG_IncendosaurScaleCount"):SetText(itemCount.."/"..(FriendlyTurninCount*2));

	itemName = "Coal";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	getglobal("TBG_CoalCount"):SetText(itemCount.."/"..FriendlyTurninCount);
    elseif(standingId == 5)then
	itemName = "Dark Iron Residue";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + math.floor(itemCount/4) * 25;
	getglobal("TBG_DarkIronResidueCount"):SetText(itemCount.."/4");
    elseif(standingId >=6)then
	itemName = "Dark Iron Ore";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + math.floor(itemCount/10) * 75;
	getglobal("TBG_DarkIronOreCount"):SetText(itemCount.."/10");

	itemName = "Core Leather";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + math.floor(itemCount/2) * 350;
	getglobal("TBG_CoreLeatherCount"):SetText(itemCount.."/2");

	itemName = "Fiery Core";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + itemCount * 500;
	getglobal("TBG_FieryCoreCount"):SetText(itemCount.."/1");

	itemName = "Lava Core";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + itemCount * 500;
	getglobal("TBG_LavaCoreCount"):SetText(itemCount.."/1");

	itemName = "Blood of the Mountain";
	if(FactionGrinderSettings["Include Bank Bags"])then
	    itemCount = GrinderCore_PlayerTotalCount(itemName);
	else
	    itemCount = GrinderCore_PlayerInventoryCount(itemName);
	end
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
	end
	repValue = repValue + itemCount * 500;
	getglobal("TBG_BloodoftheMountainCount"):SetText(itemCount.."/1");
    end

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("TBG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(TBG_REP_VALUE ~= repValue)then
        TBG_REP_VALUE = repValue;
	ThoriumBrotherhoodGrinder_UpdateRepBars();
    end
end

function ThoriumBrotherhoodGrinder_OnLoad()
    ThoriumBrotherhoodGrinder_RegisterEvents();
end

function ThoriumBrotherhoodGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ThoriumBrotherhoodGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ThoriumBrotherhoodGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ThoriumBrotherhoodGrinder_UpdateDisplayData();
	ThoriumBrotherhoodGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ThoriumBrotherhoodGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Thorium Brotherhood",GrinderCore_GetGrindingTime("Thorium Brotherhood")+TBG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Thorium Brotherhood",GrinderCore_GetRepGround("Thorium Brotherhood")+TBG_PREVIOUS_REP_GROUND);
	if(TBG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Thorium Brotherhood",GrinderCore_GetGrindingTime("Thorium Brotherhood")+(GetTime()-TBG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Thorium Brotherhood",GrinderCore_GetRepGround("Thorium Brotherhood")+(TBG_GetCurrentRepTotal() - TBG_INITIALREP));
	end
    end
end

function ThoriumBrotherhoodGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	TBG_TEXT = TBG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ThoriumBrotherhoodGrinderGrindFrame"):SetWidth(215);
	getglobal("TBG_TimeTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("TBG_RepTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("TBG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("TBG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("TBG_TimeTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("TBG_RepTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("TBG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("TBG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	TBG_TEXT = TBG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("TBG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	TBG_TEXT = TBG_TEXT_ZHTW;

	getglobal("TBG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_TBRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("TBGToRepUpFrame"):SetWidth(90);
	getglobal("TBGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("TBG_SB_ActualRep"):SetWidth(80);
    	getglobal("TBG_SB_RepWithItems"):SetWidth(80);

	getglobal("ThoriumBrotherhoodGrinderGrindFrame"):SetWidth(215);
	getglobal("TBG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("TBG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("TBG_TimeTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("TBG_RepTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("TBG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("TBG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("TBG_TimeTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("TBG_RepTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("TBG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("TBG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ThoriumBrotherhoodGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("TBG_TBRep"):SetText(TBG_TEXT["TB Rep"]);
    
    getglobal("TBG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("TBG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("TBG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("TBG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("TBG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("TBG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("TBG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("TBG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("TBG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("TBG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("TBG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("TBG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ThoriumBrotherhoodGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG_TEXT["Thorium Brotherhood Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("TBG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(TBG_REP_VALUE/42)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(TBG_REP_VALUE/21)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(TBG_REP_VALUE/12)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(TBG_REP_VALUE/6)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+TBG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(TBG_REP_VALUE/3)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+TBG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(TBG_REP_VALUE/3)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+TBG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(TBG_REP_VALUE/3)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("TBG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("TBG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+TBG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(TBG_REP_VALUE/36)/10;
	getglobal("TBG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("TBG_RepPoints"):SetText((earnedValue+TBG_REP_VALUE+42000).."/36000");
    end
    --Set what is displayed on the DisplayFrame based on the current rep level.
    if(standingId <= 4)then
	getglobal("TBG_IncendosaurScaleButton"):Show();
	getglobal("TBG_KingsbloodButton"):Show();
	getglobal("TBG_IronBarButton"):Show();
	getglobal("TBG_HeavyLeatherButton"):Show();
	getglobal("TBG_CoalButton"):Show();
	getglobal("TBG_DarkIronResidueButton"):Hide();
	getglobal("TBG_DarkIronOreButton"):Hide();
	getglobal("TBG_CoreLeatherButton"):Hide();
	getglobal("TBG_FieryCoreButton"):Hide();
	getglobal("TBG_LavaCoreButton"):Hide();
	getglobal("TBG_BloodoftheMountainButton"):Hide();
	getglobal("ThoriumBrotherhoodGrinderDisplayFrame"):SetHeight(175);
    elseif(standingId == 5)then
	getglobal("TBG_IncendosaurScaleButton"):Hide();
	getglobal("TBG_KingsbloodButton"):Hide();
	getglobal("TBG_IronBarButton"):Hide();
	getglobal("TBG_HeavyLeatherButton"):Hide();
	getglobal("TBG_CoalButton"):Hide();
	getglobal("TBG_DarkIronResidueButton"):Show();
	getglobal("TBG_DarkIronOreButton"):Hide();
	getglobal("TBG_CoreLeatherButton"):Hide();
	getglobal("TBG_FieryCoreButton"):Hide();
	getglobal("TBG_LavaCoreButton"):Hide();
	getglobal("TBG_BloodoftheMountainButton"):Hide();
	getglobal("ThoriumBrotherhoodGrinderDisplayFrame"):SetHeight(75);
    elseif(standingId >=6)then
	getglobal("TBG_IncendosaurScaleButton"):Hide();
	getglobal("TBG_KingsbloodButton"):Hide();
	getglobal("TBG_IronBarButton"):Hide();
	getglobal("TBG_HeavyLeatherButton"):Hide();
	getglobal("TBG_CoalButton"):Hide();
	getglobal("TBG_DarkIronResidueButton"):Hide();
	getglobal("TBG_DarkIronOreButton"):Show();
	getglobal("TBG_CoreLeatherButton"):Show();
	getglobal("TBG_FieryCoreButton"):Show();
	getglobal("TBG_LavaCoreButton"):Show();
	getglobal("TBG_BloodoftheMountainButton"):Show();
	getglobal("ThoriumBrotherhoodGrinderDisplayFrame"):SetHeight(125);
    end

    totalPercent = repPercent + itemPercent;
    getglobal("TBG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ThoriumBrotherhoodGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG_TEXT["Thorium Brotherhood Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-TBG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-TBG_REP_VALUE,0);
    end

    local twentyfive = 25;
    local seventyfive = 75;
    local threefifty = 350;
    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
	seventyfive = 82.5;
	threefifty = 385;
	fivehundred = 550;
    end

    local tooltip = getglobal("TBGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..TBG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Incendosaur Scale")then
	reward = twentyfive;
	tooltip:AddLine(FG_GREY..TBG_TEXT["Two needed per Fiery Flux turn-in"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/2 = "..math.floor(itemCount/2).." "..TBG_TEXT["turn-ins"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*2-(itemCount % 2))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Kingsblood")then
	reward = twentyfive;
	tooltip:AddLine(FG_GREY.."4 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/4 = "..(math.floor(itemCount/4)*reward).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*4-(itemCount % 4))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Iron Bar")then
	reward = twentyfive;
	tooltip:AddLine(FG_GREY.."4 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/4 = "..(math.floor(itemCount/4)*reward).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*4-(itemCount % 4))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Heavy Leather")then
	reward = twentyfive;
	tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Coal")then
	tooltip:AddLine(FG_GREY..TBG_TEXT["One needed per Fiery Flux turn-in"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount).." ".." "..TBG_TEXT["turn-ins"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Dark Iron Residue")then
	reward = twentyfive;
	tooltip:AddLine(FG_GREY.."4 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/4 = "..(math.floor(itemCount/4)*reward).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*4-(itemCount % 4))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly"]);
	if(UnitLevel("player") >= 48)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 48");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 48");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Master Smith Burninate"].." - "..FG_TEXT["Searing Gorge"].." (38,28)");
    elseif(text=="Dark Iron Ore")then
	reward = seventyfive;
	tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lokhtos Darkbargainer"].." - "..FG_TEXT["Blackrock Depths, The Bar"].." (?,?)");
    elseif(text=="Core Leather")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY.."2 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/2 = "..(math.floor(itemCount/2)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*2-(itemCount % 2))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*2-(itemCount % 2))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lokhtos Darkbargainer"].." - "..FG_TEXT["Blackrock Depths, The Bar"].." (?,?)");
    elseif(text=="Fiery Core")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToRepUp/reward))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToExalted/reward))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lokhtos Darkbargainer"].." - "..FG_TEXT["Blackrock Depths, The Bar"].." (?,?)");
    elseif(text=="Lava Core")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToRepUp/reward))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToExalted/reward))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lokhtos Darkbargainer"].." - "..FG_TEXT["Blackrock Depths, The Bar"].." (?,?)");
    elseif(text=="Blood of the Mountain")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToRepUp/reward))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor(RepToExalted/reward))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lokhtos Darkbargainer"].." - "..FG_TEXT["Blackrock Depths, The Bar"].." (?,?)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ThoriumBrotherhoodGrinder_HideToolTip()
    getglobal("TBGToolTip"):Hide();
end

function TBG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG_TEXT["Thorium Brotherhood Faction Name"]))) then
	    return earnedValue + TBG_REP_VALUE;
	end
    end
    return TBG_REP_VALUE;
end

function ThoriumBrotherhoodGrinder_ToggleGrinding()
    TBG_NOW_GRINDING = not TBG_NOW_GRINDING;

    local button = getglobal("TBG_BU_ToggleGrinding");
    if(TBG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("TBG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	TBG_GRINDING_STARTED_AT = GetTime();
	TBG_INITIALREP = TBG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("TBG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	TBG_PREVIOUS_GRINDING_TIME = TBG_PREVIOUS_GRINDING_TIME + (GetTime()-TBG_GRINDING_STARTED_AT);
	TBG_PREVIOUS_REP_GROUND = TBG_PREVIOUS_REP_GROUND + (TBG_GetCurrentRepTotal() - TBG_INITIALREP); 
    end
end

function ThoriumBrotherhoodGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ThoriumBrotherhoodGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ThoriumBrotherhoodGrinder");
	ThoriumBrotherhoodGrinder_UpdateDisplayData();
    end

    if(GetTime() > TBG_NEXT_GRIND_UPDATE)then
	TBG_NEXT_GRIND_UPDATE = TBG_NEXT_GRIND_UPDATE + TBG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(TBG_NOW_GRINDING)then	
	    getglobal("TBG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(TBG_PREVIOUS_GRINDING_TIME + (GetTime()-TBG_GRINDING_STARTED_AT)));
	    getglobal("TBG_RepTodayVal"):SetText(FG_GREY..(TBG_PREVIOUS_REP_GROUND + (TBG_GetCurrentRepTotal() - TBG_INITIALREP)));
	    RepPerSecond = ((TBG_PREVIOUS_REP_GROUND + (TBG_GetCurrentRepTotal() - TBG_INITIALREP)) / 
                            math.max(math.floor(TBG_PREVIOUS_GRINDING_TIME + (GetTime()-TBG_GRINDING_STARTED_AT)),1));
	    getglobal("TBG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG_TimeToRepUpTodayVal"):SetText(FG_GREY..TBG_TimeToRepUp(RepPerSecond));

	    getglobal("TBG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thorium Brotherhood")+TBG_PREVIOUS_GRINDING_TIME + (GetTime()-TBG_GRINDING_STARTED_AT)));
	    getglobal("TBG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thorium Brotherhood")+TBG_PREVIOUS_REP_GROUND + (TBG_GetCurrentRepTotal() - TBG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thorium Brotherhood")+TBG_PREVIOUS_REP_GROUND + (TBG_GetCurrentRepTotal() - TBG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thorium Brotherhood")+TBG_PREVIOUS_GRINDING_TIME + (GetTime()-TBG_GRINDING_STARTED_AT)),1));
	    getglobal("TBG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG_TimeToRepUpTotalVal"):SetText(FG_GREY..TBG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("TBG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(TBG_PREVIOUS_GRINDING_TIME));
	    getglobal("TBG_RepTodayVal"):SetText(FG_GREY..(TBG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (TBG_PREVIOUS_REP_GROUND / math.max(TBG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("TBG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG_TimeToRepUpTodayVal"):SetText(FG_GREY..TBG_TimeToRepUp(RepPerSecond));

	    getglobal("TBG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Thorium Brotherhood")+TBG_PREVIOUS_GRINDING_TIME));
	    getglobal("TBG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Thorium Brotherhood")+TBG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Thorium Brotherhood")+TBG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Thorium Brotherhood")+TBG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("TBG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("TBG_TimeToRepUpTotalVal"):SetText(FG_GREY..TBG_TimeToRepUp(RepPerSecond));
        end
    end
end

function TBG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, TBG_TEXT["Thorium Brotherhood Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-TBG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ThoriumBrotherhoodGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(TBG_TEXT[itemName]);
    end
end
