--StormwindGrinder 1.0
--Written By Tiok - US Thrall

SWG_INITIALREP = 0;

SWG_NOW_GRINDING = false;
SWG_PREVIOUS_GRINDING_TIME = 0;
SWG_GRINDING_STARTED_AT = 0;
SWG_PREVIOUS_REP_GROUND = 0;

SWG_GRIND_UPDATE_INTERVAL = 1;
SWG_NEXT_GRIND_UPDATE = 0;

SWG_REP_VALUE = 0;

SWG_TEXT = 
{
    ["Stormwind Faction Name"] = "Stormwind";
    ["SW Rep"] = "SW Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallStormwindGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["StormwindGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["StormwindGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["StormwindGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["StormwindGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["StormwindGrinder"] = "SWG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_StormwindLabel");
    FG_StormwindLabel:SetFontObject("GameFontNormalSmall");
    FG_StormwindLabel:SetText("Stormwind");
    FG_StormwindLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("StormwindTexture");
    StormwindTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Human_02");
    StormwindTexture:SetWidth(24);
    StormwindTexture:SetHeight(24);
    StormwindTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    StormwindTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_StormwindGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_StormwindGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function StormwindGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANSW");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function StormwindGrinder_Init()
    SWG_NEXT_GRIND_UPDATE = GetTime()+SWG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("StormwindGrinder","Runecloth","14047","white");

    StormwindGrinder_UpdateDisplayData();
    StormwindGrinder_UpdateRepBars();
end

function StormwindGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("SWG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SWG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SWG_REP_VALUE ~= repValue)then
        SWG_REP_VALUE = repValue;
	StormwindGrinder_UpdateRepBars();
    end
end

function StormwindGrinder_OnLoad()
    StormwindGrinder_RegisterEvents();
end

function StormwindGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        StormwindGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	StormwindGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	StormwindGrinder_UpdateDisplayData();
	StormwindGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANSW")then
	StormwindGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Stormwind",GrinderCore_GetGrindingTime("Stormwind")+SWG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Stormwind",GrinderCore_GetRepGround("Stormwind")+SWG_PREVIOUS_REP_GROUND);
	if(SWG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Stormwind",GrinderCore_GetGrindingTime("Stormwind")+(GetTime()-SWG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Stormwind",GrinderCore_GetRepGround("Stormwind")+(SWG_GetCurrentRepTotal() - SWG_INITIALREP));
	end
    end
end

function StormwindGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SWG_TEXT = SWG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("StormwindGrinderGrindFrame"):SetWidth(215);
	getglobal("SWG_TimeTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SWG_RepTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SWG_RepPerHourTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SWG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SWG_TimeTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SWG_RepTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SWG_RepPerHourTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SWG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SWG_TEXT = SWG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SWG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SWG_TEXT = SWG_TEXT_ZHTW;

	getglobal("SWG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_SWRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SWGToRepUpFrame"):SetWidth(90);
	getglobal("SWGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SWG_SB_ActualRep"):SetWidth(80);
    	getglobal("SWG_SB_RepWithItems"):SetWidth(80);

	getglobal("StormwindGrinderGrindFrame"):SetWidth(215);
	getglobal("SWG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SWG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SWG_TimeTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SWG_RepTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SWG_RepPerHourTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SWG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SWG_TimeTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SWG_RepTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SWG_RepPerHourTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SWG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","StormwindGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SWG_SWRep"):SetText(SWG_TEXT["SW Rep"]);
    
    getglobal("SWG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SWG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SWG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SWG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SWG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SWG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SWG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SWG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SWG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SWG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SWG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SWG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function StormwindGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SWG_TEXT["Stormwind Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SWG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SWG_REP_VALUE/42)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SWG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SWG_REP_VALUE/21)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SWG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SWG_REP_VALUE/12)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SWG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SWG_REP_VALUE/6)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SWG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SWG_REP_VALUE/3)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SWG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SWG_REP_VALUE/3)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SWG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SWG_REP_VALUE/3)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SWG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SWG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SWG_REP_VALUE/36)/10;
	getglobal("SWG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SWG_RepPoints"):SetText((earnedValue+SWG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SWG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function StormwindGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SWG_TEXT["Stormwind Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SWG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SWG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("SWGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SWG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Perfect Yeti Hide") and (FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Clavicus Knavingham"].." - "..FG_TEXT["Stormwind"].." (44,73)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function StormwindGrinder_HideToolTip()
    getglobal("SWGToolTip"):Hide();
end

function SWG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SWG_TEXT["Stormwind Faction Name"]))) then
	    return earnedValue + SWG_REP_VALUE;
	end
    end
    return SWG_REP_VALUE;
end

function StormwindGrinder_ToggleGrinding()
    SWG_NOW_GRINDING = not SWG_NOW_GRINDING;

    local button = getglobal("SWG_BU_ToggleGrinding");
    if(SWG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SWG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SWG_GRINDING_STARTED_AT = GetTime();
	SWG_INITIALREP = SWG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SWG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SWG_PREVIOUS_GRINDING_TIME = SWG_PREVIOUS_GRINDING_TIME + (GetTime()-SWG_GRINDING_STARTED_AT);
	SWG_PREVIOUS_REP_GROUND = SWG_PREVIOUS_REP_GROUND + (SWG_GetCurrentRepTotal() - SWG_INITIALREP); 
    end
end

function StormwindGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("StormwindGrinder"))then	
	GrinderCore_AcknowledgeItemChange("StormwindGrinder");
	StormwindGrinder_UpdateDisplayData();
    end

    if(GetTime() > SWG_NEXT_GRIND_UPDATE)then
	SWG_NEXT_GRIND_UPDATE = SWG_NEXT_GRIND_UPDATE + SWG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SWG_NOW_GRINDING)then	
	    getglobal("SWG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SWG_PREVIOUS_GRINDING_TIME + (GetTime()-SWG_GRINDING_STARTED_AT)));
	    getglobal("SWG_RepTodayVal"):SetText(FG_GREY..(SWG_PREVIOUS_REP_GROUND + (SWG_GetCurrentRepTotal() - SWG_INITIALREP)));
	    RepPerSecond = ((SWG_PREVIOUS_REP_GROUND + (SWG_GetCurrentRepTotal() - SWG_INITIALREP)) / 
                            math.max(math.floor(SWG_PREVIOUS_GRINDING_TIME + (GetTime()-SWG_GRINDING_STARTED_AT)),1));
	    getglobal("SWG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SWG_TimeToRepUpTodayVal"):SetText(FG_GREY..SWG_TimeToRepUp(RepPerSecond));

	    getglobal("SWG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Stormwind")+SWG_PREVIOUS_GRINDING_TIME + (GetTime()-SWG_GRINDING_STARTED_AT)));
	    getglobal("SWG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Stormwind")+SWG_PREVIOUS_REP_GROUND + (SWG_GetCurrentRepTotal() - SWG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Stormwind")+SWG_PREVIOUS_REP_GROUND + (SWG_GetCurrentRepTotal() - SWG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Stormwind")+SWG_PREVIOUS_GRINDING_TIME + (GetTime()-SWG_GRINDING_STARTED_AT)),1));
	    getglobal("SWG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SWG_TimeToRepUpTotalVal"):SetText(FG_GREY..SWG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SWG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SWG_PREVIOUS_GRINDING_TIME));
	    getglobal("SWG_RepTodayVal"):SetText(FG_GREY..(SWG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SWG_PREVIOUS_REP_GROUND / math.max(SWG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SWG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SWG_TimeToRepUpTodayVal"):SetText(FG_GREY..SWG_TimeToRepUp(RepPerSecond));

	    getglobal("SWG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Stormwind")+SWG_PREVIOUS_GRINDING_TIME));
	    getglobal("SWG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Stormwind")+SWG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Stormwind")+SWG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Stormwind")+SWG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SWG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SWG_TimeToRepUpTotalVal"):SetText(FG_GREY..SWG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SWG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SWG_TEXT["Stormwind Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SWG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function StormwindGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SWG_TEXT[itemName]);
    end
end
