--SporeggarGrinder 1.0
--Written By Tiok - US Thrall

SPG_INITIALREP = 0;

SPG_NOW_GRINDING = false;
SPG_PREVIOUS_GRINDING_TIME = 0;
SPG_GRINDING_STARTED_AT = 0;
SPG_PREVIOUS_REP_GROUND = 0;

SPG_GRIND_UPDATE_INTERVAL = 1;
SPG_NEXT_GRIND_UPDATE = 0;

SPG_REP_VALUE = 0;

SPG_TEXT = 
{
    ["Sporeggar Faction Name"] = "Sporeggar";
    ["Sp Rep"] = "Sp Rep";

    ["Bog Lord Tendril"] = "Bog Lord Tendril";
    ["Mature Spore Sac"] = "Mature Spore Sac";
    ["Glowcap"] = "Glowcap";

    ["Bloodscale Slavedriver slain"] = "Bloodscale Slavedriver slain";
    ["Bloodscale Enchantress slain"] = "Bloodscale Enchantress slain";

    ["Fertile Spores"] = "Fertile Spores";
    ["Sanguine Hibiscus"] = "Sanguine Hibiscus";

    ["Now That We're Friends..."] = "Now That We're Friends...";
    ["Now That We're Still Friends..."] = "Now That We're Still Friends...";
    ["Now That We're (Still) Friends"] = "Now That We're (Still) Friends";
}

function InstallSporeggarGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["SporeggarGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["SporeggarGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["SporeggarGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["SporeggarGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["SporeggarGrinder"] = "SPG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_SporeggarLabel");
    FG_SporeggarLabel:SetFontObject("GameFontNormalSmall");
    FG_SporeggarLabel:SetText("Sporeggar");
    FG_SporeggarLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("SporeggarTexture");
    SporeggarTexture:SetTexture("Interface\\Icons\\INV_Mushroom_02");
    SporeggarTexture:SetWidth(24);
    SporeggarTexture:SetHeight(24);
    SporeggarTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    SporeggarTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_SporeggarGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_SporeggarGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function SporeggarGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function SporeggarGrinder_Init()
    SPG_NEXT_GRIND_UPDATE = GetTime()+SPG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("SporeggarGrinder","Bog Lord Tendril","24291","white");
    GrinderCore_RegisterItem("SporeggarGrinder","Mature Spore Sac","24290","white");
    GrinderCore_RegisterItem("SporeggarGrinder","Glowcap","24245","white");
    GrinderCore_RegisterItem("SporeggarGrinder","Fertile Spores","24449","white");
    GrinderCore_RegisterItem("SporeggarGrinder","Sanguine Hibiscus","24246","white");

    SporeggarGrinder_UpdateDisplayData();
    SporeggarGrinder_UpdateRepBars();
end

function SporeggarGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SPG_TEXT["Sporeggar Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 3;
	earnedValue = -2500;
    end

    itemName = "Bog Lord Tendril";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId <= 4)then
        repValue = repValue + math.floor(itemCount/6)*750;
    end
    getglobal("SPG_BogLordTendrilCount"):SetText(itemCount.."/6");

    itemName = "Mature Spore Sac";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId <= 4)then
        repValue = repValue + math.floor(itemCount/10)*750;
    end
    getglobal("SPG_MatureSporeSacCount"):SetText(itemCount.."/10");

    itemName = "Glowcap";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId == 4)then
        repValue = repValue + math.floor(itemCount/10)*750;
    end
    getglobal("SPG_GlowcapCount"):SetText(itemCount.."/10");

    local FriendsIndex = -1;

    for qi=1,GetNumQuestLogEntries(),1 do
	if(GetQuestLogTitle(qi) == SPG_TEXT["Now That We're Friends..."])or(GetQuestLogTitle(qi) == SPG_TEXT["Now That We're Still Friends..."])then
	    FriendsIndex = qi;
	    local o1done,o2done;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    if(o1done==1)then desc = FG_WHITE..desc; else desc = FG_GREY..desc; end
	    getglobal("SPG_FriendsObjective1"):SetText(desc);
	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    if(o2done==1)then desc = FG_WHITE..desc; else desc = FG_GREY..desc; end
	    getglobal("SPG_FriendsObjective2"):SetText(desc);
	    if(o1done==1)and(o2done==1)then
		repValue = repValue + 750;
	    end
	end
    end

    if(FriendsIndex == -1)then
	getglobal("SPG_FriendsObjective1"):SetText(FG_GREY..SPG_TEXT["Bloodscale Slavedriver slain"]..": 0/12");
	getglobal("SPG_FriendsObjective2"):SetText(FG_GREY..SPG_TEXT["Bloodscale Enchantress slain"]..": 0/12");
    end

    if(FriendsIndex == -1)then
	getglobal("SPG_FriendsObjective1"):SetText(FG_GREY..SPG_TEXT["Bloodscale Slavedriver slain"]..": 0/12");
	getglobal("SPG_FriendsObjective2"):SetText(FG_GREY..SPG_TEXT["Bloodscale Enchantress slain"]..": 0/12");
	getglobal("SPG_Friends"):SetText(FG_GREY..SPG_TEXT["Now That We're (Still) Friends"]);
    else
	getglobal("SPG_Friends"):SetText(FG_GOLD..SPG_TEXT["Now That We're (Still) Friends"]);
    end

    itemName = "Fertile Spores";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + math.floor(itemCount/10)*750;
    end
    getglobal("SPG_FertileSporesCount"):SetText(itemCount.."/10");

    itemName = "Sanguine Hibiscus";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + math.floor(itemCount/5)*750;
    end
    getglobal("SPG_SanguineHibiscusCount"):SetText(itemCount.."/5");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SPG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SPG_REP_VALUE ~= repValue)then
        SPG_REP_VALUE = repValue;
	SporeggarGrinder_UpdateRepBars();
    end
end

function SporeggarGrinder_OnLoad()
    SporeggarGrinder_RegisterEvents();
end

function SporeggarGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        SporeggarGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	SporeggarGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	SporeggarGrinder_UpdateDisplayData();
	SporeggarGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	SporeggarGrinder_UpdateRepBars();
    elseif( event == "QUEST_LOG_UPDATE")then
	SporeggarGrinder_UpdateDisplayData();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Sporeggar",GrinderCore_GetGrindingTime("Sporeggar")+SPG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Sporeggar",GrinderCore_GetRepGround("Sporeggar")+SPG_PREVIOUS_REP_GROUND);
	if(SPG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Sporeggar",GrinderCore_GetGrindingTime("Sporeggar")+(GetTime()-SPG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Sporeggar",GrinderCore_GetRepGround("Sporeggar")+(SPG_GetCurrentRepTotal() - SPG_INITIALREP));
	end
    end
end

function SporeggarGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SPG_TEXT = SPG_TEXT_DE;
	--Reconstruct Turnin Tracker frame
	getglobal("SporeggarGrinderDisplayFrame"):SetWidth(275);

	--Reconstruct Grind-Tracker frame
	getglobal("SporeggarGrinderGrindFrame"):SetWidth(215);
	getglobal("SPG_TimeTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SPG_RepTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SPG_RepPerHourTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SPG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SPG_TimeTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SPG_RepTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SPG_RepPerHourTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SPG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SPG_TEXT = SPG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SPG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SPG_TEXT = SPG_TEXT_ZHTW;

	getglobal("SPG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_SpRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SPGToRepUpFrame"):SetWidth(90);
	getglobal("SPGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SPG_SB_ActualRep"):SetWidth(80);
    	getglobal("SPG_SB_RepWithItems"):SetWidth(80);

	getglobal("SporeggarGrinderGrindFrame"):SetWidth(215);
	getglobal("SPG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SPG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SPG_TimeTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SPG_RepTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SPG_RepPerHourTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SPG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SPG_TimeTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SPG_RepTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SPG_RepPerHourTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SPG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","SporeggarGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SPG_Friends"):SetText(SPG_TEXT["Now That We're (Still) Friends"]);
    
    getglobal("SPG_SpRep"):SetText(SPG_TEXT["Sp Rep"]);
    
    getglobal("SPG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SPG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SPG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SPG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SPG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SPG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SPG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SPG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SPG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SPG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SPG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SPG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function SporeggarGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SPG_TEXT["Sporeggar Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 3;
	earnedValue = -2500;
    end

    if(standingId==8)then --Exalted
	getglobal("SPG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SPG_REP_VALUE/42)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SPG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SPG_REP_VALUE/21)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SPG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SPG_REP_VALUE/12)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SPG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SPG_REP_VALUE/6)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SPG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SPG_REP_VALUE/3)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SPG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SPG_REP_VALUE/3)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SPG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SPG_REP_VALUE/3)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SPG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SPG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SPG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SPG_REP_VALUE/36)/10;
	getglobal("SPG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SPG_RepPoints"):SetText((earnedValue+SPG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SPG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function SporeggarGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SPG_TEXT["Sporeggar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 3;
	topValue = 0;
	earnedValue = -2500;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SPG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SPG_REP_VALUE,0);
    end

    local sevenfifty = 750;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	sevenfifty = 825;
    end

    local tooltip = getglobal("SPGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    if(text=="Friends")then
	tooltip:AddLine(SPG_TEXT["Now That We're (Still) Friends"]);
    else
        tooltip:AddLine(GrinderCore_GetItemColor(text)..SPG_TEXT[text]);
    end

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Bog Lord Tendril")then
	reward = sevenfifty;
	if(standingId <= 4)then
	    tooltip:AddLine(FG_GREY.."6 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/6 = "..(math.floor(itemCount/6)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*6-(itemCount % 6))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end
	if(standingId <= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or lower"]);
	end
	if(UnitLevel("player") >= 60)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 60");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 60");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Fahssn"].." - "..FG_TEXT["Zangarmarsh"].." (19,64)");
    elseif(text=="Mature Spore Sac")then
	reward = sevenfifty;
	if(standingId <= 4)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end	
	if(standingId <= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or lower"]);
	end
	if(UnitLevel("player") >= 60)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 60");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 60");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Fahssn"].." - "..FG_TEXT["Zangarmarsh"].." (19,64)");
    elseif(text=="Glowcap")then
	reward = sevenfifty;
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end	
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Msshi'fn"].." - "..FG_TEXT["Zangarmarsh"].." (20,52)");
    elseif(text=="Friends")then
	reward = sevenfifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 5)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Gzhun'tt"].." - "..FG_TEXT["Zangarmarsh"].." (19,50)");
    elseif(text=="Fertile Spores")then
	reward = sevenfifty;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Gshaff"].." - "..FG_TEXT["Zangarmarsh"].." (19,50)");
    elseif(text=="Sanguine Hibiscus")then
	reward = sevenfifty;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."5 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 63)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 63");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 63");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Gzhun'tt"].." - "..FG_TEXT["Zangarmarsh"].." (19,50)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function SporeggarGrinder_HideToolTip()
    getglobal("SPGToolTip"):Hide();
end

function SPG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SPG_TEXT["Sporeggar Faction Name"]))) then
	    return earnedValue + SPG_REP_VALUE;
	end
    end
    return SPG_REP_VALUE;
end

function SporeggarGrinder_ToggleGrinding()
    SPG_NOW_GRINDING = not SPG_NOW_GRINDING;

    local button = getglobal("SPG_BU_ToggleGrinding");
    if(SPG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SPG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SPG_GRINDING_STARTED_AT = GetTime();
	SPG_INITIALREP = SPG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SPG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SPG_PREVIOUS_GRINDING_TIME = SPG_PREVIOUS_GRINDING_TIME + (GetTime()-SPG_GRINDING_STARTED_AT);
	SPG_PREVIOUS_REP_GROUND = SPG_PREVIOUS_REP_GROUND + (SPG_GetCurrentRepTotal() - SPG_INITIALREP); 
    end
end

function SporeggarGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("SporeggarGrinder"))then	
	GrinderCore_AcknowledgeItemChange("SporeggarGrinder");
	SporeggarGrinder_UpdateDisplayData();
    end

    if(GetTime() > SPG_NEXT_GRIND_UPDATE)then
	SPG_NEXT_GRIND_UPDATE = SPG_NEXT_GRIND_UPDATE + SPG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SPG_NOW_GRINDING)then	
	    getglobal("SPG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SPG_PREVIOUS_GRINDING_TIME + (GetTime()-SPG_GRINDING_STARTED_AT)));
	    getglobal("SPG_RepTodayVal"):SetText(FG_GREY..(SPG_PREVIOUS_REP_GROUND + (SPG_GetCurrentRepTotal() - SPG_INITIALREP)));
	    RepPerSecond = ((SPG_PREVIOUS_REP_GROUND + (SPG_GetCurrentRepTotal() - SPG_INITIALREP)) / 
                            math.max(math.floor(SPG_PREVIOUS_GRINDING_TIME + (GetTime()-SPG_GRINDING_STARTED_AT)),1));
	    getglobal("SPG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SPG_TimeToRepUpTodayVal"):SetText(FG_GREY..SPG_TimeToRepUp(RepPerSecond));

	    getglobal("SPG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Sporeggar")+SPG_PREVIOUS_GRINDING_TIME + (GetTime()-SPG_GRINDING_STARTED_AT)));
	    getglobal("SPG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Sporeggar")+SPG_PREVIOUS_REP_GROUND + (SPG_GetCurrentRepTotal() - SPG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Sporeggar")+SPG_PREVIOUS_REP_GROUND + (SPG_GetCurrentRepTotal() - SPG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Sporeggar")+SPG_PREVIOUS_GRINDING_TIME + (GetTime()-SPG_GRINDING_STARTED_AT)),1));
	    getglobal("SPG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SPG_TimeToRepUpTotalVal"):SetText(FG_GREY..SPG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SPG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SPG_PREVIOUS_GRINDING_TIME));
	    getglobal("SPG_RepTodayVal"):SetText(FG_GREY..(SPG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SPG_PREVIOUS_REP_GROUND / math.max(SPG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SPG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SPG_TimeToRepUpTodayVal"):SetText(FG_GREY..SPG_TimeToRepUp(RepPerSecond));

	    getglobal("SPG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Sporeggar")+SPG_PREVIOUS_GRINDING_TIME));
	    getglobal("SPG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Sporeggar")+SPG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Sporeggar")+SPG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Sporeggar")+SPG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SPG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SPG_TimeToRepUpTotalVal"):SetText(FG_GREY..SPG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SPG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SPG_TEXT["Sporeggar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 3;
	topValue = 0;
	earnedValue = -2500;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SPG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function SporeggarGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SPG_TEXT[itemName]);
    end
end
