--SilvermoonCityGrinder 1.0
--Written By Tiok - US Thrall

SMG_INITIALREP = 0;

SMG_NOW_GRINDING = false;
SMG_PREVIOUS_GRINDING_TIME = 0;
SMG_GRINDING_STARTED_AT = 0;
SMG_PREVIOUS_REP_GROUND = 0;

SMG_GRIND_UPDATE_INTERVAL = 1;
SMG_NEXT_GRIND_UPDATE = 0;

SMG_REP_VALUE = 0;

SMG_TEXT = 
{
    ["Silvermoon City Faction Name"] = "Silvermoon City";
    ["SM Rep"] = "SM Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallSilvermoonCityGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["SilvermoonCityGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["SilvermoonCityGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["SilvermoonCityGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["SilvermoonCityGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["SilvermoonCityGrinder"] = "SMG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_SilvermoonCityLabel");
    FG_SilvermoonCityLabel:SetFontObject("GameFontNormalSmall");
    FG_SilvermoonCityLabel:SetText("Silvermoon City");
    FG_SilvermoonCityLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("SilvermoonCityTexture");
    SilvermoonCityTexture:SetTexture("Interface\\Icons\\INV_Mask_04");
    SilvermoonCityTexture:SetWidth(24);
    SilvermoonCityTexture:SetHeight(24);
    SilvermoonCityTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    SilvermoonCityTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_SilvermoonCityGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_SilvermoonCityGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function SilvermoonCityGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function SilvermoonCityGrinder_Init()
    SMG_NEXT_GRIND_UPDATE = GetTime()+SMG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("SilvermoonCityGrinder","Runecloth","14047","white");

    SilvermoonCityGrinder_UpdateDisplayData();
    SilvermoonCityGrinder_UpdateRepBars();
end

function SilvermoonCityGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("SMG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SMG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SMG_REP_VALUE ~= repValue)then
        SMG_REP_VALUE = repValue;
	SilvermoonCityGrinder_UpdateRepBars();
    end
end

function SilvermoonCityGrinder_OnLoad()
    SilvermoonCityGrinder_RegisterEvents();
end

function SilvermoonCityGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        SilvermoonCityGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	SilvermoonCityGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	SilvermoonCityGrinder_UpdateDisplayData();
	SilvermoonCityGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	SilvermoonCityGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Silvermoon City",GrinderCore_GetGrindingTime("Silvermoon City")+SMG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Silvermoon City",GrinderCore_GetRepGround("Silvermoon City")+SMG_PREVIOUS_REP_GROUND);
	if(SMG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Silvermoon City",GrinderCore_GetGrindingTime("Silvermoon City")+(GetTime()-SMG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Silvermoon City",GrinderCore_GetRepGround("Silvermoon City")+(SMG_GetCurrentRepTotal() - SMG_INITIALREP));
	end
    end
end

function SilvermoonCityGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SMG_TEXT = SMG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("SilvermoonCityGrinderGrindFrame"):SetWidth(215);
	getglobal("SMG_TimeTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SMG_RepTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SMG_RepPerHourTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SMG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SMG_TimeTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SMG_RepTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SMG_RepPerHourTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SMG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SMG_TEXT = SMG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SMG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SMG_TEXT = SMG_TEXT_ZHTW;

	getglobal("SMG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_SMRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SMGToRepUpFrame"):SetWidth(90);
	getglobal("SMGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SMG_SB_ActualRep"):SetWidth(80);
    	getglobal("SMG_SB_RepWithItems"):SetWidth(80);

	getglobal("SilvermoonCityGrinderGrindFrame"):SetWidth(215);
	getglobal("SMG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SMG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SMG_TimeTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SMG_RepTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SMG_RepPerHourTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SMG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SMG_TimeTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SMG_RepTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SMG_RepPerHourTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SMG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","SilvermoonCityGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SMG_SMRep"):SetText(SMG_TEXT["SM Rep"]);
    
    getglobal("SMG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SMG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SMG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SMG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SMG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SMG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SMG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SMG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SMG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SMG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SMG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SMG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function SilvermoonCityGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SMG_TEXT["Silvermoon City Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SMG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SMG_REP_VALUE/42)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SMG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SMG_REP_VALUE/21)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SMG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SMG_REP_VALUE/12)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SMG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SMG_REP_VALUE/6)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SMG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SMG_REP_VALUE/3)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SMG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SMG_REP_VALUE/3)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SMG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SMG_REP_VALUE/3)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SMG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SMG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SMG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SMG_REP_VALUE/36)/10;
	getglobal("SMG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SMG_RepPoints"):SetText((earnedValue+SMG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SMG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function SilvermoonCityGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SMG_TEXT["Silvermoon City Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SMG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SMG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("SMGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SMG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sorim Lightsong"].." - "..FG_TEXT["Silvermoon City"].." (56,52)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function SilvermoonCityGrinder_HideToolTip()
    getglobal("SMGToolTip"):Hide();
end

function SMG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SMG_TEXT["Silvermoon City Faction Name"]))) then
	    return earnedValue + SMG_REP_VALUE;
	end
    end
    return SMG_REP_VALUE;
end

function SilvermoonCityGrinder_ToggleGrinding()
    SMG_NOW_GRINDING = not SMG_NOW_GRINDING;

    local button = getglobal("SMG_BU_ToggleGrinding");
    if(SMG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SMG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SMG_GRINDING_STARTED_AT = GetTime();
	SMG_INITIALREP = SMG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SMG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SMG_PREVIOUS_GRINDING_TIME = SMG_PREVIOUS_GRINDING_TIME + (GetTime()-SMG_GRINDING_STARTED_AT);
	SMG_PREVIOUS_REP_GROUND = SMG_PREVIOUS_REP_GROUND + (SMG_GetCurrentRepTotal() - SMG_INITIALREP); 
    end
end

function SilvermoonCityGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("SilvermoonCityGrinder"))then	
	GrinderCore_AcknowledgeItemChange("SilvermoonCityGrinder");
	SilvermoonCityGrinder_UpdateDisplayData();
    end

    if(GetTime() > SMG_NEXT_GRIND_UPDATE)then
	SMG_NEXT_GRIND_UPDATE = SMG_NEXT_GRIND_UPDATE + SMG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SMG_NOW_GRINDING)then	
	    getglobal("SMG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SMG_PREVIOUS_GRINDING_TIME + (GetTime()-SMG_GRINDING_STARTED_AT)));
	    getglobal("SMG_RepTodayVal"):SetText(FG_GREY..(SMG_PREVIOUS_REP_GROUND + (SMG_GetCurrentRepTotal() - SMG_INITIALREP)));
	    RepPerSecond = ((SMG_PREVIOUS_REP_GROUND + (SMG_GetCurrentRepTotal() - SMG_INITIALREP)) / 
                            math.max(math.floor(SMG_PREVIOUS_GRINDING_TIME + (GetTime()-SMG_GRINDING_STARTED_AT)),1));
	    getglobal("SMG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SMG_TimeToRepUpTodayVal"):SetText(FG_GREY..SMG_TimeToRepUp(RepPerSecond));

	    getglobal("SMG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Silvermoon City")+SMG_PREVIOUS_GRINDING_TIME + (GetTime()-SMG_GRINDING_STARTED_AT)));
	    getglobal("SMG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Silvermoon City")+SMG_PREVIOUS_REP_GROUND + (SMG_GetCurrentRepTotal() - SMG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Silvermoon City")+SMG_PREVIOUS_REP_GROUND + (SMG_GetCurrentRepTotal() - SMG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Silvermoon City")+SMG_PREVIOUS_GRINDING_TIME + (GetTime()-SMG_GRINDING_STARTED_AT)),1));
	    getglobal("SMG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SMG_TimeToRepUpTotalVal"):SetText(FG_GREY..SMG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SMG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SMG_PREVIOUS_GRINDING_TIME));
	    getglobal("SMG_RepTodayVal"):SetText(FG_GREY..(SMG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SMG_PREVIOUS_REP_GROUND / math.max(SMG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SMG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SMG_TimeToRepUpTodayVal"):SetText(FG_GREY..SMG_TimeToRepUp(RepPerSecond));

	    getglobal("SMG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Silvermoon City")+SMG_PREVIOUS_GRINDING_TIME));
	    getglobal("SMG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Silvermoon City")+SMG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Silvermoon City")+SMG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Silvermoon City")+SMG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SMG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SMG_TimeToRepUpTotalVal"):SetText(FG_GREY..SMG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SMG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SMG_TEXT["Silvermoon City Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SMG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function SilvermoonCityGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SMG_TEXT[itemName]);
    end
end
