--ShatteredSunOffensiveGrinder 1.0
--Written By Tiok - US Thrall

SSOG_INITIALREP = 0;

SSOG_NOW_GRINDING = false;
SSOG_PREVIOUS_GRINDING_TIME = 0;
SSOG_GRINDING_STARTED_AT = 0;
SSOG_PREVIOUS_REP_GROUND = 0;

SSOG_GRIND_UPDATE_INTERVAL = 1;
SSOG_NEXT_GRIND_UPDATE = 0;

SSOG_REP_VALUE = 0;

SSOG_TEXT = 
{
    ["Shattered Sun Offensive Faction Name"] = "Shattered Sun Offensive";
    ["SS Rep"] = "SS Rep";

    --The names of any items that need to be tracked.
    ["Smuggled Mana Cell"] = "Smuggled Mana Cell";
    ["Darkspine Iron Ore"] = "Darkspine Iron Ore";
    ["Cleansed Ata'mal Metal"] = "Cleansed Ata'mal Metal";
    ["Razorthorn Root"] = "Razorthorn Root";
    ["Bloodberry"] = "Bloodberry";
    ["Nether Residue"] = "Nether Residue";

    --The names of any quests that need to be tracked.
    ["Erratic Behavior"] = "Erratic Behavior";
    ["Further Conversions"] = "Further Conversions";
    ["The Sanctum Wards"] = "The Sanctum Wards";
    ["Arm the Wards!"] = "Arm the Wards!";
    ["Maintaining the Sunwell Portal"] = "Maintaining the Sunwell Portal";
    ["Intercepting the Mana Cells"] = "Intercepting the Mana Cells";
    ["The Battle Must Go On"] = "The Battle Must Go On";
    ["The Battle for the Sun's Reach Armory"] = "The Battle for the Sun's Reach Armory";
    ["The Air Strikes Must Continue"] = "The Air Strikes Must Continue";
    ["Distraction at the Dead Scar"] = "Distraction at the Dead Scar";
    ["Know Your Ley Lines"] = "Know Your Ley Lines";
    ["Keeping the Enemy at Bay"] = "Keeping the Enemy at Bay";
    ["Intercept the Reinforcements"] = "Intercept the Reinforcements";
    ["Crush the Dawnblade"] = "Crush the Dawnblade";
    ["Taking the Harbor"] = "Taking the Harbor";
    ["Don't Stop Now..."] = "Don't Stop Now...";
    ["Making Ready"] = "Making Ready";
    ["Ata'mal Armaments"] = "Ata'mal Armaments";
    ["Rediscovering Your Roots"] = "Rediscovering Your Roots";
    ["Discovering Your Roots"] = "Discovering Your Roots";
    ["Disrupt the Greengill Coast"] = "Disrupt the Greengill Coast";
    ["A Charitable Donation"] = "A Charitable Donation";
    ["Your Continued Support"] = "Your Continued Support";
    ["Open for Business"] = "Open for Business";
    ["Blood for Blood"] = "Blood for Blood";
    ["Blast the Gateway"] = "Blast the Gateway";
    ["Gaining the Advantage"] = "Gaining the Advantage";
    ["Sunfury Attack Plans"] = "Sunfury Attack Plans";
    ["The Multiphase Survey"] = "The Multiphase Survey";
    
    --The text for quest requirements. (some of these may have already been handled in the item names above)
    ["Converted Sentry Deployed"] = "Converted Sentry Deployed";
    ["Energize a Crystal Ward"] = "Energize a Crystal Ward";
    ["Burning Legion Demon slain"] = "Burning Legion Demon slain";
    ["Emissary of Hate Impaled"] = "Emissary of Hate Impaled";
    ["Pit Overlord slain"] = "Pit Overlord slain";
    ["Eredar Sorcerer slain"] = "Eredar Sorcerer slain";
    ["Wrath Enforcer slain"] = "Wrath Enforcer slain";
    ["Portal Reading Taken"] = "Portal Reading Taken";
    ["Shrine Reading Taken"] = "Shrine Reading Taken";
    ["Bloodcrystal Reading Taken"] = "Bloodcrystal Reading Taken";
    ["Sin'loren sails burned"] = "Sin'loren sails burned";
    ["Bloodoath sails burned"] = "Bloodoath sails burned";
    ["Dawnchaser sails burned"] = "Dawnchaser sails burned";
    ["Dawnblade Reservist slain"] = "Dawnblade Reservist slain";
    ["Dawnblade Summoner slain"] = "Dawnblade Summoner slain";
    ["Dawnblade Blood Knight slain"] = "Dawnblade Blood Knight slain";
    ["Dawnblade Marksman slain"] = "Dawnblade Marksman slain";
    ["Greengill Slaves freed"] = "Greengill Slaves freed";
    ["10 Gold"] = "10 Gold";
    ["Emaciated Felblood slain"] = "Emaciated Felblood slain";
    ["Legion Gateway Destroyed"] = "Legion Gateway Destroyed";
    ["Multiphase Readings"] = "Multiphase Readings";

    --Any special text unique to this grinder.
    ["Phase 1"] = "Phase 1";
    ["Phase 2"] = "Phase 2";
    ["Phase 2b"] = "Phase 2b";
    ["Phase 3"] = "Phase 3";
    ["Phase 3b"] = "Phase 3b";
    ["Phase 4"] = "Phase 4";
    ["Phase 4b"] = "Phase 4b";
    ["Phase 4c"] = "Phase 4c";
}

function InstallShatteredSunOffensiveGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ShatteredSunOffensiveGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ShatteredSunOffensiveGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ShatteredSunOffensiveGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ShatteredSunOffensiveGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ShatteredSunOffensiveGrinder"] = "SSOG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ShatteredSunOffensiveLabel");
    FG_ShatteredSunOffensiveLabel:SetFontObject("GameFontNormalSmall");
    FG_ShatteredSunOffensiveLabel:SetText("Shattered Sun Offensive");
    FG_ShatteredSunOffensiveLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ShatteredSunOffensiveTexture");
    ShatteredSunOffensiveTexture:SetTexture("Interface\\Icons\\INV_Shield_48");
    ShatteredSunOffensiveTexture:SetWidth(24);
    ShatteredSunOffensiveTexture:SetHeight(24);
    ShatteredSunOffensiveTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ShatteredSunOffensiveTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatteredSunOffensiveGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatteredSunOffensiveGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ShatteredSunOffensiveGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    --add event registrations here
end

function ShatteredSunOffensiveGrinder_Init()
    SSOG_NEXT_GRIND_UPDATE = GetTime()+SSOG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Smuggled Mana Cell","34246","white");
    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Darkspine Iron Ore","34479","white");
    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Cleansed Ata'mal Metal","34501","white");
    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Razorthorn Root","34254","white");
    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Bloodberry","34502","white");
    GrinderCore_RegisterItem("ShatteredSunOffensiveGrinder","Nether Residue","35229","white");

    ShatteredSunOffensiveGrinder_UpdateDisplayData();
    ShatteredSunOffensiveGrinder_UpdateRepBars();
end

function ShatteredSunOffensiveGrinder_UpdateDisplayData()
    local repValue = 0;

    --Update the collectible item counts
    local itemCount, itemName, numNeeded, reward;

    itemName = "Smuggled Mana Cell";
    numNeeded = 10;
    reward = 250;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
--    if(FactionGrinderSettings["Include Alt Items"])then --Delete if this item is soulbound.
--	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
--    end
    repValue = repValue + (math.floor(itemCount/numNeeded)*reward);
    if (itemCount >= numNeeded) then itemCount = FG_WHITE..itemCount; else itemCount = FG_GREY..itemCount; end
    getglobal("SSOG_SmuggledManaCellButtonCount"):SetText(itemCount.."/"..numNeeded);

    itemName = "Darkspine Iron Ore";
    numNeeded = 3;
    reward = 250;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
--    if(FactionGrinderSettings["Include Alt Items"])then --Delete if this item is soulbound.
--	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
--    end
    repValue = repValue + (math.floor(itemCount/numNeeded)*reward);
    if (itemCount >= numNeeded) then itemCount = FG_WHITE..itemCount; else itemCount = FG_GREY..itemCount; end
    getglobal("SSOG_DarkspineIronOreButtonCount"):SetText(itemCount.."/"..numNeeded);

    itemName = "Razorthorn Root";
    numNeeded = 5;
    reward = 350;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
--    if(FactionGrinderSettings["Include Alt Items"])then --Delete if this item is soulbound.
--	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
--    end
    repValue = repValue + (math.floor(itemCount/numNeeded)*reward);
    if (itemCount >= numNeeded) then itemCount = FG_WHITE..itemCount; else itemCount = FG_GREY..itemCount; end
    getglobal("SSOG_RazorthornRootButtonCount"):SetText(itemCount.."/"..numNeeded);

    itemName = "Bloodberry";
    numNeeded = 5;
    reward = 250;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
--    if(FactionGrinderSettings["Include Alt Items"])then --Delete if this item is soulbound.
--	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
--    end
    repValue = repValue + (math.floor(itemCount/numNeeded)*reward);
    if (itemCount >= numNeeded) then itemCount = FG_WHITE..itemCount; else itemCount = FG_GREY..itemCount; end
    getglobal("SSOG_BloodberryButtonCount"):SetText(itemCount.."/"..numNeeded);


    --Update the quest "counts." (sum of things that need to be done/collected)

    --Quest Indexes
    ErraticBehaviorIndex = -1;
    TheSanctumWardsIndex = -1;
    TheBattlefortheSunsReachArmoryIndex = -1;
    DistractionattheDeadScarIndex = -1;
    KnowYourLeyLinesIndex = -1;
    IntercepttheReinforcementsIndex = -1;
    TakingtheHarborIndex = -1;
    AtamalArmamentsIndex = -1;
    DisrupttheGreengillCoastIndex = -1;
    ACharitableDonationIndex = -1;
    BloodforBloodIndex = -1;
    BlasttheGatewayIndex = -1;
    GainingtheAdvantageIndex = -1;
    SunfuryAttackPlansIndex = -1;
    TheMultiphaseSurveyIndex = -1;

    for qi=1,GetNumQuestLogEntries(),1 do
	if(GetQuestLogTitle(qi) == SSOG_TEXT["Erratic Behavior"] or GetQuestLogTitle(qi) == SSOG_TEXT["Further Conversions"])then
	    ErraticBehaviorIndex = qi;
	    local partsToDo = 5;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/5");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_ErraticBehaviorButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 150;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["The Sanctum Wards"] or GetQuestLogTitle(qi) == SSOG_TEXT["Arm the Wards!"])then
	    TheSanctumWardsIndex = qi;
	    local partsToDo = 1;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_TheSanctumWardsButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 150;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["The Battle for the Sun's Reach Armory"] or GetQuestLogTitle(qi) == SSOG_TEXT["The Battle Must Go On"])then
	    TheBattlefortheSunsReachArmoryIndex = qi;
	    local partsToDo = 7;
	    local partsDone = 0;

	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*)/1");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    _,_,count = string.find(desc,"(%d*)/6");
	    partsDone = partsDone + tonumber(count);
	    --if (o2done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_TheBattlefortheSunsReachArmoryButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1 and o2done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Distraction at the Dead Scar"] or GetQuestLogTitle(qi) == SSOG_TEXT["The Air Strikes Must Continue"])then
	    DistractionattheDeadScarIndex = qi;
	    local partsToDo = 17;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/2");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;
	    
	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    _,_,count = string.find(desc,"(%d*)/3");
	    partsDone = partsDone + tonumber(count);
	    --if (o2done) then partsDone = partsDone + 1; end;

	    desc,_,o3done = GetQuestLogLeaderBoard(3,qi);
	    _,_,count = string.find(desc,"(%d*)/12");
	    partsDone = partsDone + tonumber(count);
	    --if (o3done) then partsDone = partsDone + 1; end;
	    
	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_DistractionattheDeadScarButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1 and o2done==1 and o3done==1)then
		repValue = repValue + 150;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Know Your Ley Lines"])then
	    KnowYourLeyLinesIndex = qi;
	    local partsToDo = 3;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o1done) then partsDone = partsDone + 1; end;

	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o2done) then partsDone = partsDone + 1; end;

	    desc,_,o3done = GetQuestLogLeaderBoard(3,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o3done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_KnowYourLeyLinesButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1 and o2done==1 and o3done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Intercept the Reinforcements"] or GetQuestLogTitle(qi) == SSOG_TEXT["Keeping the Enemy at Bay"])then
	    IntercepttheReinforcementsIndex = qi;
	    local partsToDo = 9;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o1done) then partsDone = partsDone + 1; end;

	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o2done) then partsDone = partsDone + 1; end;

	    desc,_,o3done = GetQuestLogLeaderBoard(3,qi);
	    --_,_,count = string.find(desc,"(%d*)/5");
	    --partsDone = partsDone + tonumber(count);
	    if (o3done) then partsDone = partsDone + 1; end;

	    desc,_,o4done = GetQuestLogLeaderBoard(4,qi);
	    _,_,count = string.find(desc,"(%d*)/6");
	    partsDone = partsDone + tonumber(count);
	    --if (o4done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_IntercepttheReinforcementsButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1 and o2done==1 and o3done==1 and o4done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Taking the Harbor"] or GetQuestLogTitle(qi) == SSOG_TEXT["Crush the Dawnblade"])then
	    TakingtheHarborIndex = qi;
	    local partsToDo = 15;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/6");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    _,_,count = string.find(desc,"(%d*)/6");
	    partsDone = partsDone + tonumber(count);
	    --if (o2done) then partsDone = partsDone + 1; end;

	    desc,_,o3done = GetQuestLogLeaderBoard(3,qi);
	    _,_,count = string.find(desc,"(%d*)/3");
	    partsDone = partsDone + tonumber(count);
	    --if (o3done) then partsDone = partsDone + 1; end;	    

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_TakingtheHarborButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1 and o2done and o3done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Ata'mal Armaments"])then
	    AtamalArmamentsIndex = qi;
	    local partsToDo = 5;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/5");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_AtamalArmamentsButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Disrupt the Greengill Coast"])then
	    TheSanctumWardsIndex = qi;
	    local partsToDo = 10;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/10");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_DisrupttheGreengillCoastButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["A Charitable Donation"] or GetQuestLogTitle(qi) == SSOG_TEXT["Your Continued Support"])then
	    TheSanctumWardsIndex = qi;
	    local partsToDo = 10;
	    local partsDone = math.min(10,math.floor(GetMoney()/1000));

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_ACharitableDonationButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 150;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Blood for Blood"])then
	    BloodforBloodIndex = qi;
	    local partsToDo = 4;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/4");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_BloodforBloodButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Blast the Gateway"])then
	    BlasttheGatewayIndex = qi;
	    local partsToDo = 1;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    --_,_,count = string.find(desc,"(%d*)/4");
	    --partsDone = partsDone + tonumber(count);
	    if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_BlasttheGatewayButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Gaining the Advantage"])then
	    GainingtheAdvantageIndex = qi;
	    local partsToDo = 8;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/8");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_GainingtheAdvantageButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["Sunfury Attack Plans"])then
	    SunfuryAttackPlansIndex = qi;
	    local partsToDo = 1;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    --_,_,count = string.find(desc,"(%d*)/4");
	    --partsDone = partsDone + tonumber(count);
	    if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_SunfuryAttackPlansButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == SSOG_TEXT["The Multiphase Survey"])then
	    TheMultiphaseSurveyIndex = qi;
	    local partsToDo = 6;
	    local partsDone = 0;

	    desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    _,_,count = string.find(desc,"(%d*)/6");
	    partsDone = partsDone + tonumber(count);
	    --if (o1done) then partsDone = partsDone + 1; end;

	    if(partsDone==partsToDo)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSOG_TheMultiphaseSurveyButtonCount"):SetText(desc..partsDone.."/"..partsToDo);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	end	
    end

    --This section dims quest buttons the player doesn't have and brightens ones that they do.
    if(ErraticBehaviorIndex == -1)then
	SetDesaturation(getglobal("SSOG_ErraticBehaviorButtonTexture"),1);
	getglobal("SSOG_ErraticBehaviorButtonCount"):SetText(FG_GREY.."0/5");
    else
	SetDesaturation(getglobal("SSOG_ErraticBehaviorButtonTexture"),0);
    end
    if(TheSanctumWardsIndex == -1)then
	SetDesaturation(getglobal("SSOG_TheSanctumWardsButtonTexture"),1);
	getglobal("SSOG_TheSanctumWardsButtonCount"):SetText(FG_GREY.."0/1");
    else
	SetDesaturation(getglobal("SSOG_TheSanctumWardsButtonTexture"),0);
    end
    if(TheBattlefortheSunsReachArmoryIndex == -1)then
	SetDesaturation(getglobal("SSOG_TheBattlefortheSunsReachArmoryButtonTexture"),1);
	getglobal("SSOG_TheBattlefortheSunsReachArmoryButtonCount"):SetText(FG_GREY.."0/7");
    else
	SetDesaturation(getglobal("SSOG_TheBattlefortheSunsReachArmoryButtonTexture"),0);
    end
    if(DistractionattheDeadScarIndex == -1)then
	SetDesaturation(getglobal("SSOG_DistractionattheDeadScarButtonTexture"),1);
	getglobal("SSOG_DistractionattheDeadScarButtonCount"):SetText(FG_GREY.."0/15");
    else
	SetDesaturation(getglobal("SSOG_DistractionattheDeadScarButtonTexture"),0);
    end
    if(KnowYourLeyLinesIndex == -1)then
	SetDesaturation(getglobal("SSOG_KnowYourLeyLinesButtonTexture"),1);
	getglobal("SSOG_KnowYourLeyLinesButtonCount"):SetText(FG_GREY.."0/3");
    else
	SetDesaturation(getglobal("SSOG_KnowYourLeyLinesButtonTexture"),0);
    end
    if(IntercepttheReinforcementsIndex == -1)then
	SetDesaturation(getglobal("SSOG_IntercepttheReinforcementsButtonTexture"),1);
	getglobal("SSOG_IntercepttheReinforcementsButtonCount"):SetText(FG_GREY.."0/9");
    else
	SetDesaturation(getglobal("SSOG_IntercepttheReinforcementsButtonTexture"),0);
    end
    if(TakingtheHarborIndex == -1)then
	SetDesaturation(getglobal("SSOG_TakingtheHarborButtonTexture"),1);
	getglobal("SSOG_TakingtheHarborButtonCount"):SetText(FG_GREY.."0/15");
    else
	SetDesaturation(getglobal("SSOG_TakingtheHarborButtonTexture"),0);
    end
    if(AtamalArmamentsIndex == -1)then
	SetDesaturation(getglobal("SSOG_AtamalArmamentsButtonTexture"),1);
	getglobal("SSOG_AtamalArmamentsButtonCount"):SetText(FG_GREY.."0/5");
    else
	SetDesaturation(getglobal("SSOG_AtamalArmamentsButtonTexture"),0);
    end
    if(DisrupttheGreengillCoastIndex == -1)then
	SetDesaturation(getglobal("SSOG_DisrupttheGreengillCoastButtonTexture"),1);
	getglobal("SSOG_DisrupttheGreengillCoastButtonCount"):SetText(FG_GREY.."0/10");
    else
	SetDesaturation(getglobal("SSOG_DisrupttheGreengillCoastButtonTexture"),0);
    end
    if(ACharitableDonationIndex == -1)then
	SetDesaturation(getglobal("SSOG_ACharitableDonationButtonTexture"),1);
	getglobal("SSOG_ACharitableDonationButtonCount"):SetText(FG_GREY.."0/10");
    else
	SetDesaturation(getglobal("SSOG_ACharitableDonationButtonTexture"),0);
    end
    if(BloodforBloodIndex == -1)then
	SetDesaturation(getglobal("SSOG_BloodforBloodButtonTexture"),1);
	getglobal("SSOG_BloodforBloodButtonCount"):SetText(FG_GREY.."0/4");
    else
	SetDesaturation(getglobal("SSOG_BloodforBloodButtonTexture"),0);
    end
    if(BlasttheGatewayIndex == -1)then
	SetDesaturation(getglobal("SSOG_BlasttheGatewayButtonTexture"),1);
	getglobal("SSOG_BlasttheGatewayButtonCount"):SetText(FG_GREY.."0/1");
    else
	SetDesaturation(getglobal("SSOG_BlasttheGatewayButtonTexture"),0);
    end
    if(GainingtheAdvantageIndex == -1)then
	SetDesaturation(getglobal("SSOG_GainingtheAdvantageButtonTexture"),1);
	getglobal("SSOG_GainingtheAdvantageButtonCount"):SetText(FG_GREY.."0/8");
    else
	SetDesaturation(getglobal("SSOG_GainingtheAdvantageButtonTexture"),0);
    end
    if(SunfuryAttackPlansIndex == -1)then
	SetDesaturation(getglobal("SSOG_SunfuryAttackPlansButtonTexture"),1);
	getglobal("SSOG_SunfuryAttackPlansButtonCount"):SetText(FG_GREY.."0/1");
    else
	SetDesaturation(getglobal("SSOG_SunfuryAttackPlansButtonTexture"),0);
    end
    if(TheMultiphaseSurveyIndex == -1)then
	SetDesaturation(getglobal("SSOG_TheMultiphaseSurveyButtonTexture"),1);
	getglobal("SSOG_TheMultiphaseSurveyButtonCount"):SetText(FG_GREY.."0/6");
    else
	SetDesaturation(getglobal("SSOG_TheMultiphaseSurveyButtonTexture"),0);
    end

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SSOG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SSOG_REP_VALUE ~= repValue)then
        SSOG_REP_VALUE = repValue;
	ShatteredSunOffensiveGrinder_UpdateRepBars();
    end
end

function ShatteredSunOffensiveGrinder_OnLoad()
    ShatteredSunOffensiveGrinder_RegisterEvents();
end

function ShatteredSunOffensiveGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ShatteredSunOffensiveGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ShatteredSunOffensiveGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ShatteredSunOffensiveGrinder_UpdateDisplayData();
	ShatteredSunOffensiveGrinder_UpdateRepBars();
    elseif(event == "QUEST_LOG_UPDATE")then
	ShatteredSunOffensiveGrinder_UpdateDisplayData();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ShatteredSunOffensiveGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Shattered Sun Offensive",GrinderCore_GetGrindingTime("Shattered Sun Offensive")+SSOG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Shattered Sun Offensive",GrinderCore_GetRepGround("Shattered Sun Offensive")+SSOG_PREVIOUS_REP_GROUND);
	if(SSOG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Shattered Sun Offensive",GrinderCore_GetGrindingTime("Shattered Sun Offensive")+(GetTime()-SSOG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Shattered Sun Offensive",GrinderCore_GetRepGround("Shattered Sun Offensive")+(SSOG_GetCurrentRepTotal() - SSOG_INITIALREP));
	end
    end
end

function ShatteredSunOffensiveGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SSOG_TEXT = SSOG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ShatteredSunOffensiveGrinderGrindFrame"):SetWidth(215);
	getglobal("SSOG_TimeTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SSOG_RepTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SSOG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SSOG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SSOG_TimeTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SSOG_RepTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SSOG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SSOG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SSOG_TEXT = SSOG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SSOG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SSOG_TEXT = SSOG_TEXT_ZHTW;

	getglobal("SSOG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_SSRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SSOGToRepUpFrame"):SetWidth(90);
	getglobal("SSOGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SSOG_SB_ActualRep"):SetWidth(80);
    	getglobal("SSOG_SB_RepWithItems"):SetWidth(80);

	getglobal("ShatteredSunOffensiveGrinderGrindFrame"):SetWidth(215);
	getglobal("SSOG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSOG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SSOG_TimeTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SSOG_RepTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SSOG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SSOG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SSOG_TimeTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SSOG_RepTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SSOG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SSOG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatteredSunOffensiveGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    getglobal("SSOG_Phase1Label"):SetText(SSOG_TEXT["Phase 1"]);
    getglobal("SSOG_Phase2Label"):SetText(SSOG_TEXT["Phase 2"]);
    getglobal("SSOG_Phase3Label"):SetText(SSOG_TEXT["Phase 3"]);
    getglobal("SSOG_Phase4Label"):SetText(SSOG_TEXT["Phase 4"]);
    
    getglobal("SSOG_SSRep"):SetText(SSOG_TEXT["SS Rep"]);
    
    getglobal("SSOG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SSOG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SSOG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SSOG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SSOG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SSOG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SSOG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SSOG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SSOG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SSOG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SSOG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SSOG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ShatteredSunOffensiveGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSOG_TEXT["Shattered Sun Offensive Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SSOG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SSOG_REP_VALUE/42)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSOG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/21)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSOG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/12)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSOG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/6)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSOG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/3)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SSOG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/3)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SSOG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/3)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SSOG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SSOG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SSOG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SSOG_REP_VALUE/36)/10;
	getglobal("SSOG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SSOG_RepPoints"):SetText((earnedValue+SSOG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SSOG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ShatteredSunOffensiveGrinder_ShowItemToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSOG_TEXT["Shattered Sun Offensive Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SSOG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SSOG_REP_VALUE,0);
    end

    local onefifty = 150;
    local twofifty = 250;
    local threefifty = 350;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	onefifty = 165;
    	twofifty = 275;
	threefifty = 385;
    end

    local tooltip = getglobal("SSOGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SSOG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

    if(text=="Smuggled Mana Cell")then
--	if(FactionGrinderSettings["Include Alt Items"]) then --Delete this if the item is soulbound.
--	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
--	end
	numNeeded = 10;
	reward = twofifty;
	requiredLevel = 68;

	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Exarch Nasuun"].." - "..FG_TEXT["Shattrath City"].." (49,42)");
    elseif(text=="Darkspine Iron Ore")then
--	if(FactionGrinderSettings["Include Alt Items"]) then --Delete this if the item is soulbound.
--	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
--	end
	numNeeded = 3;
	reward = twofifty;
	requiredLevel = 68;

	tooltip:AddLine(FG_GREY..numNeeded.." = "..onefifty.." "..FG_TEXT["rep"].." - "..SSOG_TEXT["Phase 3"]);
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"].." - "..SSOG_TEXT["Phase 3b"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Smith Hauthaa"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Razorthorn Root")then
--	if(FactionGrinderSettings["Include Alt Items"]) then --Delete this if the item is soulbound.
--	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
--	end
	numNeeded = 5;
	reward = threefifty;
	requiredLevel = 68;

	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mar'nah"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Bloodberry")then
--	if(FactionGrinderSettings["Include Alt Items"]) then --Delete this if the item is soulbound.
--	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
--	end
	numNeeded = 5;
	reward = twofifty;
	requiredLevel = 68;

	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mar'nah"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ShatteredSunOffensiveGrinder_ShowQuestToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSOG_TEXT["Shattered Sun Offensive Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SSOG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SSOG_REP_VALUE,0);
    end

    local onefifty = 150;
    local twofifty = 250;
    local threefifty = 350;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	onefifty = 165;
	twofifty = 275;
	threefifty = 385;
    end

    local tooltip = getglobal("SSOGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();    

    if(text=="Erratic Behavior")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	tooltip:AddLine(SSOG_TEXT["Further Conversions"].." - "..SSOG_TEXT["Phase 2"]);
	qi = ErraticBehaviorIndex;
	reward = onefifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Converted Sentry Deployed"].." : 0/5");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Vindicator Xayann"].." - "..FG_TEXT["Isle of Quel'Danas"].." (47,30)");
    elseif(text=="The Sanctum Wards")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	tooltip:AddLine(SSOG_TEXT["Arm the Wards!"].." - "..SSOG_TEXT["Phase 2"]);
	qi = TheSanctumWardsIndex;
	reward = onefifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Energize a Crystal Ward"]);
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Captain Theris Dawnhearth"].." - "..FG_TEXT["Isle of Quel'Danas"].." (47,30)");
    elseif(text=="The Battle for the Sun's Reach Armory")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 2"]);
	tooltip:AddLine(SSOG_TEXT["The Battle Must Go On"].." - "..SSOG_TEXT["Phase 3"]);
	qi = TheBattlefortheSunsReachArmoryIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Emissary of Hate Impaled"].." : 0/1");
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Burning Legion Demon slain"].." : 0/6");	    
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Harbinger Inuuro"].." - "..FG_TEXT["Isle of Quel'Danas"].." (47,35)");
    elseif(text=="Distraction at the Dead Scar")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 2"]);
	tooltip:AddLine(SSOG_TEXT["The Air Strikes Must Continue"].." - "..SSOG_TEXT["Phase 3"]);
	qi = DistractionattheDeadScarIndex;
	reward = onefifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Pit Overlord slain"].." : 0/2");
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Eredar Sorcerer slain"].." : 0/3");
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Wrath Enforcer slain"].." : 0/12");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Battlemage Arynna"].." - "..FG_TEXT["Isle of Quel'Danas"].." (47,35)");
    elseif(text=="Know Your Ley Lines")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 2b"]);
	qi = KnowYourLeyLinesIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.	    
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Portal Reading Taken"]);
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Shrine Reading Taken"]);
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Bloodcrystal Reading Taken"]);
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Astromancer Darnarian"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Intercept the Reinforcements")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 3"]);
	tooltip:AddLine(SSOG_TEXT["Keeping the Enemy at Bay"].." - "..SSOG_TEXT["Phase 4"]);
	qi = IntercepttheReinforcementsIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Sin'loren sails burned"]);
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Bloodoath sails burned"]);
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Dawnchaser sails burned"]);
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Dawnblade Reservist slain"].." : 0/6");
	    
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Vindicator Kaalan"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Taking the Harbor")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 3"]);
	tooltip:AddLine(SSOG_TEXT["Crush the Dawnblade"].." - "..SSOG_TEXT["Phase 4"]);
	qi = TakingtheHarborIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Dawnblade Summoner slain"].." : 0/6");
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Dawnblade Blood Knight slain"].." : 0/6");
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Dawnblade Marksman slain"].." : 0/3");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magister Ilastar"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Ata'mal Armaments")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 3b"]);
	qi = AtamalArmamentsIndex;
	reward = threefifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Cleansed Ata'mal Metal"].." : 0/5");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Smith Hauthaa"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Disrupt the Greengill Coast")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 4"]);
	qi = DisrupttheGreengillCoastIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Greengill Slaves freed"].." : 0/10");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Captain Valindria"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="A Charitable Donation")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 4"]);
	tooltip:AddLine(SSOG_TEXT["Your Continued Support"].." - "..SSOG_TEXT["Phase 4b"]);
	qi = ACharitableDonationIndex;
	reward = onefifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["10 Gold"]);
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Anchorite Ayuri"].." - "..FG_TEXT["Isle of Quel'Danas"].." (??,??)");
    elseif(text=="Blood for Blood")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	qi = BloodforBloodIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Emaciated Felblood slain"].." : 0/4");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Seyla"].." - "..FG_TEXT["Hellfire Peninsula"].." (58,17)");
    elseif(text=="Blast the Gateway")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	qi = BlasttheGatewayIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Legion Gateway Destroyed"]);
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Seyla"].." - "..FG_TEXT["Hellfire Peninsula"].." (58,17)");
    elseif(text=="Gaining the Advantage")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	qi = GainingtheAdvantageIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Nether Residue"].." : 0/8");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Emissary Mordin"].." - "..FG_TEXT["Shattrath City"].." (62,35)");
    elseif(text=="Sunfury Attack Plans")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	qi = SunfuryAttackPlansIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Sunfury Attack Plans"].." : 0/1");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lord Torvos"].." - "..FG_TEXT["Shattrath City"].." (62,35)");
    elseif(text=="The Multiphase Survey")then
	tooltip:AddLine(SSOG_TEXT[text].." - "..SSOG_TEXT["Phase 1"]);
	qi = TheMultiphaseSurveyIndex;
	reward = twofifty;
	requiredLevel = 68;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
	tooltip:AddLine(" ");
	
	local o1Done,o2Done,o3Done,o4Done;
	if (qi > -1) then
	    local desc,color;
	    --Quest Objectives
	    desc,_,o1Done = GetQuestLogLeaderBoard(1,qi);
	    if(o1Done)then color = FG_WHITE; else color = FG_GREY; end
	    tooltip:AddLine(color..desc);
	    --desc,_,o2Done = GetQuestLogLeaderBoard(2,qi);
	    --if(o2Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o3Done = GetQuestLogLeaderBoard(3,qi);
	    --if(o3Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	    --desc,_,o4Done = GetQuestLogLeaderBoard(4,qi);
	    --if(o4Done)then color = FG_WHITE; else color = FG_GREY; end
	    --tooltip:AddLine(color..desc);
	else
	    --If the quest isn't in this toon's log, we have to manually insert the quest objectives.
	    tooltip:AddLine(FG_GREY..SSOG_TEXT["Multiphase Readings"].." : 0/6");
	end

	tooltip:AddLine(" ");
	--Comment this section out if there is no rep requirement for the quest.
--	if(standingId >= 4)then
--	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
--	else
--	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
--	end
        if(UnitLevel("player") >= requiredLevel)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." "..requiredLevel);
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." "..requiredLevel);
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Harbinger Haronem"].." - "..FG_TEXT["Shattrath City"].." (61,52)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ShatteredSunOffensiveGrinder_HideToolTip()
    getglobal("SSOGToolTip"):Hide();
end

function SSOG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSOG_TEXT["Shattered Sun Offensive Faction Name"]))) then
	    return earnedValue + SSOG_REP_VALUE;
	end
    end
    return SSOG_REP_VALUE;
end

function ShatteredSunOffensiveGrinder_ToggleGrinding()
    SSOG_NOW_GRINDING = not SSOG_NOW_GRINDING;

    local button = getglobal("SSOG_BU_ToggleGrinding");
    if(SSOG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SSOG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SSOG_GRINDING_STARTED_AT = GetTime();
	SSOG_INITIALREP = SSOG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SSOG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SSOG_PREVIOUS_GRINDING_TIME = SSOG_PREVIOUS_GRINDING_TIME + (GetTime()-SSOG_GRINDING_STARTED_AT);
	SSOG_PREVIOUS_REP_GROUND = SSOG_PREVIOUS_REP_GROUND + (SSOG_GetCurrentRepTotal() - SSOG_INITIALREP); 
    end
end

function ShatteredSunOffensiveGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ShatteredSunOffensiveGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ShatteredSunOffensiveGrinder");
	ShatteredSunOffensiveGrinder_UpdateDisplayData();
    end

    if(GetTime() > SSOG_NEXT_GRIND_UPDATE)then
	SSOG_NEXT_GRIND_UPDATE = SSOG_NEXT_GRIND_UPDATE + SSOG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SSOG_NOW_GRINDING)then	
	    getglobal("SSOG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SSOG_PREVIOUS_GRINDING_TIME + (GetTime()-SSOG_GRINDING_STARTED_AT)));
	    getglobal("SSOG_RepTodayVal"):SetText(FG_GREY..(SSOG_PREVIOUS_REP_GROUND + (SSOG_GetCurrentRepTotal() - SSOG_INITIALREP)));
	    RepPerSecond = ((SSOG_PREVIOUS_REP_GROUND + (SSOG_GetCurrentRepTotal() - SSOG_INITIALREP)) / 
                            math.max(math.floor(SSOG_PREVIOUS_GRINDING_TIME + (GetTime()-SSOG_GRINDING_STARTED_AT)),1));
	    getglobal("SSOG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSOG_TimeToRepUpTodayVal"):SetText(FG_GREY..SSOG_TimeToRepUp(RepPerSecond));

	    getglobal("SSOG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Shattered Sun Offensive")+SSOG_PREVIOUS_GRINDING_TIME + (GetTime()-SSOG_GRINDING_STARTED_AT)));
	    getglobal("SSOG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Shattered Sun Offensive")+SSOG_PREVIOUS_REP_GROUND + (SSOG_GetCurrentRepTotal() - SSOG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Shattered Sun Offensive")+SSOG_PREVIOUS_REP_GROUND + (SSOG_GetCurrentRepTotal() - SSOG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Shattered Sun Offensive")+SSOG_PREVIOUS_GRINDING_TIME + (GetTime()-SSOG_GRINDING_STARTED_AT)),1));
	    getglobal("SSOG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSOG_TimeToRepUpTotalVal"):SetText(FG_GREY..SSOG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SSOG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SSOG_PREVIOUS_GRINDING_TIME));
	    getglobal("SSOG_RepTodayVal"):SetText(FG_GREY..(SSOG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SSOG_PREVIOUS_REP_GROUND / math.max(SSOG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SSOG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSOG_TimeToRepUpTodayVal"):SetText(FG_GREY..SSOG_TimeToRepUp(RepPerSecond));

	    getglobal("SSOG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Shattered Sun Offensive")+SSOG_PREVIOUS_GRINDING_TIME));
	    getglobal("SSOG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Shattered Sun Offensive")+SSOG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Shattered Sun Offensive")+SSOG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Shattered Sun Offensive")+SSOG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SSOG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSOG_TimeToRepUpTotalVal"):SetText(FG_GREY..SSOG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SSOG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSOG_TEXT["Shattered Sun Offensive Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SSOG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ShatteredSunOffensiveGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SSOG_TEXT[itemName]);
    end
end
