--ShatariSkyguardGrinder 1.0
--Written By Tiok - US Thrall

SSG_INITIALREP = 0;

SSG_NOW_GRINDING = false;
SSG_PREVIOUS_GRINDING_TIME = 0;
SSG_GRINDING_STARTED_AT = 0;
SSG_PREVIOUS_REP_GROUND = 0;

SSG_GRIND_UPDATE_INTERVAL = 1;
SSG_NEXT_GRIND_UPDATE = 0;

SSG_REP_VALUE = 0;

SSG_TEXT = 
{
    ["Sha'tari Skyguard Faction Name"] = "Sha'tari Skyguard";
    ["SS Rep"] = "SS Rep";

    ["Shadow Dust"] = "Shadow Dust";

    ["Fires Over Skettis"] = "Fires Over Skettis";
    ["Escape from Skettis"] = "Escape from Skettis";
    ["Bomb Them Again!"] = "Bomb Them Again!";
    ["Wrangle More Aether Rays!"] = "Wrangle More Aether Rays!";

    ["Monstrous Kaliri Egg Destroyed"] = "Monstrous Kaliri Egg Destroyed";
    ["Skyguard Prisoner Rescued"] = "Skyguard Prisoner Rescued";
    ["Fel Cannonball Stacks destroyed"] = "Fel Cannonball Stacks destroyed";
    ["Aether Rays wrangled"] = "Aether Rays wrangled";
}

function InstallShatariSkyguardGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ShatariSkyguardGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ShatariSkyguardGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ShatariSkyguardGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ShatariSkyguardGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ShatariSkyguardGrinder"] = "SSG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ShatariSkyguardLabel");
    FG_ShatariSkyguardLabel:SetFontObject("GameFontNormalSmall");
    FG_ShatariSkyguardLabel:SetText("Sha'tari Skyguard");
    FG_ShatariSkyguardLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ShatariSkyguardTexture");
    ShatariSkyguardTexture:SetTexture("Interface\\Icons\\Ability_Hunter_Pet_NetherRay");
    ShatariSkyguardTexture:SetWidth(24);
    ShatariSkyguardTexture:SetHeight(24);
    ShatariSkyguardTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ShatariSkyguardTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatariSkyguardGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatariSkyguardGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

FiresOverSkettisIndex = -1;
EscapeFromSkettisIndex = -1;
BombThemAgainIndex = -1;
WrangleMoreAetherRaysIndex = -1;

function ShatariSkyguardGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ShatariSkyguardGrinder_Init()
    SSG_NEXT_GRIND_UPDATE = GetTime()+SSG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ShatariSkyguardGrinder","Shadow Dust","32388","white");

    ShatariSkyguardGrinder_UpdateDisplayData();
    ShatariSkyguardGrinder_UpdateRepBars();
end

function ShatariSkyguardGrinder_UpdateDisplayData()
    local repValue = 0;

    local textColor, itemName, itemCount;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSG_TEXT["Sha'tari Skyguard Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    itemName = "Shadow Dust";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + math.floor(itemCount/6)*75;
    if(itemCount >= 6)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("SSG_ShadowDustCount"):SetText(itemCount.."/6");

    --Now check if the quests are in the log.  Display accordingly.
    FiresOverSkettisIndex = -1;
    EscapeFromSkettisIndex = -1;
    BombThemAgainIndex = -1;
    WrangleMoreAetherRaysIndex = -1;

    for qi=1,GetNumQuestLogEntries(),1 do
	if(GetQuestLogTitle(qi) == SSG_TEXT["Fires Over Skettis"])then
	    FiresOverSkettisIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/20)");
	    if(count=="20/20")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSG_FiresOverSkettisObjective"):SetText(desc..SSG_TEXT["Monstrous Kaliri Egg Destroyed"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == SSG_TEXT["Escape from Skettis"])then
	    EscapeFromSkettisIndex = qi;
	    local _,_,_,_,_,_, isComplete,_ = GetQuestLogTitle(qi);

	    if(isComplete)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSG_EscapeFromSkettisObjective"):SetText(desc..SSG_TEXT["Skyguard Prisoner Rescued"]);

	    if(isComplete)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == SSG_TEXT["Bomb Them Again!"])then
	    BombThemAgainIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/15)");
	    if(count=="15/15")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSG_BombThemAgainObjective"):SetText(desc..SSG_TEXT["Fel Cannonball Stacks destroyed"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 500;
	    end
	elseif(GetQuestLogTitle(qi) == SSG_TEXT["Wrangle More Aether Rays!"])then
	    WrangleMoreAetherRaysIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/5)");
	    if(count=="5/5")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("SSG_WrangleMoreAetherRaysObjective"):SetText(desc..SSG_TEXT["Aether Rays wrangled"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	end	
    end

    if(FiresOverSkettisIndex == -1)then
	getglobal("SSG_FiresOverSkettisObjective"):SetText(FG_GREY..SSG_TEXT["Monstrous Kaliri Egg Destroyed"].." : 0/20");
	getglobal("SSG_FiresOverSkettis"):SetText(FG_GREY..SSG_TEXT["Fires Over Skettis"]);
    else
	getglobal("SSG_FiresOverSkettis"):SetText(FG_GOLD..SSG_TEXT["Fires Over Skettis"]);
    end

    if(EscapeFromSkettisIndex == -1)then
	getglobal("SSG_EscapeFromSkettisObjective"):SetText(FG_GREY..SSG_TEXT["Skyguard Prisoner Rescued"]);
	getglobal("SSG_EscapeFromSkettis"):SetText(FG_GREY..SSG_TEXT["Escape from Skettis"]);
    else
	getglobal("SSG_EscapeFromSkettis"):SetText(FG_GOLD..SSG_TEXT["Escape from Skettis"]);
    end

    if(BombThemAgainIndex == -1)then
	getglobal("SSG_BombThemAgainObjective"):SetText(FG_GREY..SSG_TEXT["Fel Cannonball Stacks destroyed"].." : 0/15");
	getglobal("SSG_BombThemAgain"):SetText(FG_GREY..SSG_TEXT["Bomb Them Again!"]);
    else
	getglobal("SSG_BombThemAgain"):SetText(FG_GOLD..SSG_TEXT["Bomb Them Again!"]);
    end

    if(WrangleMoreAetherRaysIndex == -1)then
	getglobal("SSG_WrangleMoreAetherRaysObjective"):SetText(FG_GREY..SSG_TEXT["Aether Rays wrangled"].." : 0/5");
	getglobal("SSG_WrangleMoreAetherRays"):SetText(FG_GREY..SSG_TEXT["Wrangle More Aether Rays!"]);
    else
	getglobal("SSG_WrangleMoreAetherRays"):SetText(FG_GOLD..SSG_TEXT["Wrangle More Aether Rays!"]);
    end

    if(UnitRace("player") == FG_TEXT["Human"])then
	repValue = repValue * 1.1;
    end

    getglobal("SSG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SSG_REP_VALUE ~= repValue)then
        SSG_REP_VALUE = repValue;
	ShatariSkyguardGrinder_UpdateRepBars();
    end
end

function ShatariSkyguardGrinder_OnLoad()
    ShatariSkyguardGrinder_RegisterEvents();
end

function ShatariSkyguardGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ShatariSkyguardGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ShatariSkyguardGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ShatariSkyguardGrinder_UpdateDisplayData();
	ShatariSkyguardGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ShatariSkyguardGrinder_UpdateRepBars();
    elseif( event == "QUEST_LOG_UPDATE")then
	ShatariSkyguardGrinder_UpdateDisplayData();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Sha'tari Skyguard",GrinderCore_GetGrindingTime("Sha'tari Skyguard")+SSG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Sha'tari Skyguard",GrinderCore_GetRepGround("Sha'tari Skyguard")+SSG_PREVIOUS_REP_GROUND);
	if(SSG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Sha'tari Skyguard",GrinderCore_GetGrindingTime("Sha'tari Skyguard")+(GetTime()-SSG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Sha'tari Skyguard",GrinderCore_GetRepGround("Sha'tari Skyguard")+(SSG_GetCurrentRepTotal() - SSG_INITIALREP));
	end
    end
end

function ShatariSkyguardGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SSG_TEXT = SSG_TEXT_DE;
	--Reconstruct Display frame
	getglobal("ShatariSkyguardGrinderDisplayFrame"):SetWidth(225);

	--Reconstruct Grind-Tracker frame
	getglobal("ShatariSkyguardGrinderGrindFrame"):SetWidth(215);
	getglobal("SSG_TimeTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SSG_RepTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SSG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SSG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SSG_TimeTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SSG_RepTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SSG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SSG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SSG_TEXT = SSG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SSG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SSG_TEXT = SSG_TEXT_ZHTW;

	getglobal("SSG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_SSRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SSGToRepUpFrame"):SetWidth(90);
	getglobal("SSGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SSG_SB_ActualRep"):SetWidth(80);
    	getglobal("SSG_SB_RepWithItems"):SetWidth(80);

	getglobal("ShatariSkyguardGrinderGrindFrame"):SetWidth(215);
	getglobal("SSG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SSG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SSG_TimeTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SSG_RepTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SSG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SSG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SSG_TimeTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SSG_RepTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SSG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SSG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatariSkyguardGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SSG_SSRep"):SetText(SSG_TEXT["SS Rep"]);
    getglobal("SSG_FiresOverSkettis"):SetText(SSG_TEXT["Fires Over Skettis"]);
    getglobal("SSG_EscapeFromSkettis"):SetText(SSG_TEXT["Escape From Skettis"]);
    getglobal("SSG_BombThemAgain"):SetText(SSG_TEXT["Bomb Them Again!"]);
    getglobal("SSG_WrangleMoreAetherRays"):SetText(SSG_TEXT["Wrangle More Aether Rays!"]);
    
    getglobal("SSG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SSG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SSG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SSG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SSG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SSG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SSG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SSG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SSG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SSG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SSG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SSG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ShatariSkyguardGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSG_TEXT["Sha'tari Skyguard Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SSG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SSG_REP_VALUE/42)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SSG_REP_VALUE/21)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SSG_REP_VALUE/12)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SSG_REP_VALUE/6)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SSG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SSG_REP_VALUE/3)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SSG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SSG_REP_VALUE/3)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SSG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SSG_REP_VALUE/3)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SSG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SSG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SSG_REP_VALUE/36)/10;
	getglobal("SSG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SSG_RepPoints"):SetText((earnedValue+SSG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SSG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ShatariSkyguardGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSG_TEXT["Sha'tari Skyguard Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SSG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SSG_REP_VALUE,0);
    end

    local seventyfive = 75;
    local threefifty = 350;
    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5
	threefifty = 385;
	fivehundred = 550;
    end

    local tooltip = getglobal("SSGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SSG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Shadow Dust")then
	reward = seventyfive;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."6 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/6 = "..(math.floor(itemCount/6)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*6-(itemCount % 6))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*6-(itemCount % 6))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Severin"].." - "..FG_TEXT["Terokkar Forest"].." (53,79)");
    elseif(text=="Fires Over Skettis")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sky Sergeant Doryn"].." - "..FG_TEXT["Terokkar Forest"].." (53,79)");
    elseif(text=="Escape from Skettis")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sky Sergeant Doryn"].." - "..FG_TEXT["Terokkar Forest"].." (53,79)");
    elseif(text=="Bomb Them Again!")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sky Sergeant Vanderlip"].." - "..FG_TEXT["Blade's Edge Mountains"].." (27,52)");
    elseif(text=="Wrangle More Aether Rays!")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Skyguard Khatie"].." - "..FG_TEXT["Blade's Edge Mountains"].." (27,51)");
    end

    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ShatariSkyguardGrinder_HideToolTip()
    getglobal("SSGToolTip"):Hide();
end

function SSG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSG_TEXT["Sha'tari Skyguard Faction Name"]))) then
	    return earnedValue + SSG_REP_VALUE;
	end
    end
    return SSG_REP_VALUE;
end

function ShatariSkyguardGrinder_ToggleGrinding()
    SSG_NOW_GRINDING = not SSG_NOW_GRINDING;

    local button = getglobal("SSG_BU_ToggleGrinding");
    if(SSG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SSG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SSG_GRINDING_STARTED_AT = GetTime();
	SSG_INITIALREP = SSG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SSG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SSG_PREVIOUS_GRINDING_TIME = SSG_PREVIOUS_GRINDING_TIME + (GetTime()-SSG_GRINDING_STARTED_AT);
	SSG_PREVIOUS_REP_GROUND = SSG_PREVIOUS_REP_GROUND + (SSG_GetCurrentRepTotal() - SSG_INITIALREP); 
    end
end

function ShatariSkyguardGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ShatariSkyguardGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ShatariSkyguardGrinder");
	ShatariSkyguardGrinder_UpdateDisplayData();
    end

    if(GetTime() > SSG_NEXT_GRIND_UPDATE)then
	SSG_NEXT_GRIND_UPDATE = SSG_NEXT_GRIND_UPDATE + SSG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SSG_NOW_GRINDING)then	
	    getglobal("SSG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SSG_PREVIOUS_GRINDING_TIME + (GetTime()-SSG_GRINDING_STARTED_AT)));
	    getglobal("SSG_RepTodayVal"):SetText(FG_GREY..(SSG_PREVIOUS_REP_GROUND + (SSG_GetCurrentRepTotal() - SSG_INITIALREP)));
	    RepPerSecond = ((SSG_PREVIOUS_REP_GROUND + (SSG_GetCurrentRepTotal() - SSG_INITIALREP)) / 
                            math.max(math.floor(SSG_PREVIOUS_GRINDING_TIME + (GetTime()-SSG_GRINDING_STARTED_AT)),1));
	    getglobal("SSG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSG_TimeToRepUpTodayVal"):SetText(FG_GREY..SSG_TimeToRepUp(RepPerSecond));

	    getglobal("SSG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Sha'tari Skyguard")+SSG_PREVIOUS_GRINDING_TIME + (GetTime()-SSG_GRINDING_STARTED_AT)));
	    getglobal("SSG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Sha'tari Skyguard")+SSG_PREVIOUS_REP_GROUND + (SSG_GetCurrentRepTotal() - SSG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Sha'tari Skyguard")+SSG_PREVIOUS_REP_GROUND + (SSG_GetCurrentRepTotal() - SSG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Sha'tari Skyguard")+SSG_PREVIOUS_GRINDING_TIME + (GetTime()-SSG_GRINDING_STARTED_AT)),1));
	    getglobal("SSG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSG_TimeToRepUpTotalVal"):SetText(FG_GREY..SSG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SSG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SSG_PREVIOUS_GRINDING_TIME));
	    getglobal("SSG_RepTodayVal"):SetText(FG_GREY..(SSG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SSG_PREVIOUS_REP_GROUND / math.max(SSG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SSG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSG_TimeToRepUpTodayVal"):SetText(FG_GREY..SSG_TimeToRepUp(RepPerSecond));

	    getglobal("SSG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Sha'tari Skyguard")+SSG_PREVIOUS_GRINDING_TIME));
	    getglobal("SSG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Sha'tari Skyguard")+SSG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Sha'tari Skyguard")+SSG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Sha'tari Skyguard")+SSG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SSG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SSG_TimeToRepUpTotalVal"):SetText(FG_GREY..SSG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SSG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SSG_TEXT["Sha'tari Skyguard Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SSG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ShatariSkyguardGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SSG_TEXT[itemName]);
    end
end
