--ShatarGrinder 1.0
--Written By Tiok - US Thrall

STG_INITIALREP = 0;

STG_NOW_GRINDING = false;
STG_PREVIOUS_GRINDING_TIME = 0;
STG_GRINDING_STARTED_AT = 0;
STG_PREVIOUS_REP_GROUND = 0;

STG_GRIND_UPDATE_INTERVAL = 1;
STG_NEXT_GRIND_UPDATE = 0;

STG_REP_VALUE = 0;

STG_TEXT = 
{
    ["Sha'tar Faction Name"] = "The Sha'tar";
    ["St Rep"] = "St Rep";

    ["Mark of Kil'jaeden"] = "Mark of Kil'jaeden";
    ["Fel Armament"] = "Fel Armament";
    ["Mark of Sargeras"] = "Mark of Sargeras";

    ["Firewing Signet"] = "Firewing Signet";
    ["Arcane Tome"] = "Arcane Tome";
    ["Sunfury Signet"] = "Sunfury Signet";

    ["Only repeatable while Neutral or better with Aldor"] = "Only repeatable while Neutral or better with Aldor";
    ["Only repeatable while Neutral or Friendly with Aldor"] = "Only repeatable while Neutral or Friendly with Aldor";

    ["Only repeatable while Neutral or better with Scryers"] = "Only repeatable while Neutral or better with Scryers";
    ["Only repeatable while Neutral or Friendly with Scryers"] = "Only repeatable while Neutral or Friendly with Scryers";

    ["No Sha'tar rep rewarded once Honored with Sha'tar"] = "No Sha'tar rep rewarded once Honored with Sha'tar";
}

function InstallShatarGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ShatarGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ShatarGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ShatarGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ShatarGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ShatarGrinder"] = "STG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ShatarLabel");
    FG_ShatarLabel:SetFontObject("GameFontNormalSmall");
    FG_ShatarLabel:SetText("The Sha'tar");
    FG_ShatarLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ShatarTexture");
    ShatarTexture:SetTexture("Interface\\Icons\\INV_Jewelry_Ring_63");
    ShatarTexture:SetWidth(24);
    ShatarTexture:SetHeight(24);
    ShatarTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ShatarTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatarGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ShatarGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ShatarGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ShatarGrinder_Init()
    STG_NEXT_GRIND_UPDATE = GetTime()+STG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ShatarGrinder","Mark of Kil'jaeden","29425","white");
    GrinderCore_RegisterItem("ShatarGrinder","Fel Armament","29740","green");
    GrinderCore_RegisterItem("ShatarGrinder","Mark of Sargeras","30809","white");

    GrinderCore_RegisterItem("ShatarGrinder","Firewing Signet","29426","white");
    GrinderCore_RegisterItem("ShatarGrinder","Arcane Tome","29739","green");
    GrinderCore_RegisterItem("ShatarGrinder","Sunfury Signet","30810","white");

    ShatarGrinder_UpdateDisplayData();
    ShatarGrinder_UpdateRepBars();
end

function ShatarGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local ShatarFound = false;
    local AldorFound = false;
    local ScryersFound = false;

    local ShatarStandingId, ShatarEarnedValue;
    local AldorStandingId, AldorEarnedValue;
    local ScryersStandingId, ScryersEarnedValue;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if (isHeader == nil)then
	    if(string.find(factionName, STG_TEXT["Sha'tar Faction Name"])) then
		ShatarFound = true; 
		ShatarStandingId = standingId;
		ShatarEarnedValue = earnedValue;
	    elseif(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))then
		AldorFound = true;
		AldorStandingId = standingId;
		AldorEarnedValue = earnedValue;
	    elseif(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))then
		ScryersFound = true;
		ScryersStandingId = standingId;
		ScryersEarnedValue = earnedValue;
	    end
        end
    end

    if(not ShatarFound)then
	ShatarStandingId = 4;
	ShatarEarnedValue = 0;
    end
    if(not AldorFound)then
	AldorStandingId = 4;
	AldorEarnedValue = 0;
    end
    if(not ScryersFound)then
	ScryersStandingId = 4;
	ScryersEarnedValue = 0;
    end
  
    itemName = "Mark of Kil'jaeden";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if((AldorStandingId == 4)or(AldorStandingId == 5))and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*12.5;
    end
    getglobal("STG_MarkofKiljaedenCount"):SetText(itemCount.."/1");

    itemName = "Fel Armament";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(AldorStandingId >= 4)and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*175;
    end
    getglobal("STG_FelArmamentCount"):SetText(itemCount.."/1");

    itemName = "Mark of Sargeras";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(AldorStandingId >= 4)and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*12.5;
    end
    getglobal("STG_MarkofSargerasCount"):SetText(itemCount.."/1");

    itemName = "Firewing Signet";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if((ScryersStandingId == 4)or(ScryersStandingId == 5))and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*12.5;
    end
    getglobal("SCG_FirewingSignetCount"):SetText(itemCount.."/1");

    itemName = "Arcane Tome";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(ScryersStandingId >= 4)and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*175;
    end
    getglobal("SCG_ArcaneTomeCount"):SetText(itemCount.."/1");

    itemName = "Sunfury Signet";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(ScryersStandingId >= 4)and(ShatarStandingId < 6)then
        repValue = repValue + itemCount*12.5;
    end
    getglobal("SCG_SunfurySignetCount"):SetText(itemCount.."/1");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("STG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(STG_REP_VALUE ~= repValue)then
        STG_REP_VALUE = repValue;
	ShatarGrinder_UpdateRepBars();
    end
end

function ShatarGrinder_OnLoad()
    ShatarGrinder_RegisterEvents();
end

function ShatarGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ShatarGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ShatarGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ShatarGrinder_UpdateDisplayData();
	ShatarGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ShatarGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("The Sha'tar",GrinderCore_GetGrindingTime("The Sha'tar")+STG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("The Sha'tar",GrinderCore_GetRepGround("The Sha'tar")+STG_PREVIOUS_REP_GROUND);
	if(STG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("The Sha'tar",GrinderCore_GetGrindingTime("The Sha'tar")+(GetTime()-STG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("The Sha'tar",GrinderCore_GetRepGround("The Sha'tar")+(STG_GetCurrentRepTotal() - STG_INITIALREP));
	end
    end
end

function ShatarGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	STG_TEXT = STG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ShatarGrinderGrindFrame"):SetWidth(215);
	getglobal("STG_TimeTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("STG_RepTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("STG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("STG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("STG_TimeTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("STG_RepTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("STG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("STG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	STG_TEXT = STG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("STG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	STG_TEXT = STG_TEXT_ZHTW;

	getglobal("STG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_StRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("STGToRepUpFrame"):SetWidth(90);
	getglobal("STGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("STG_SB_ActualRep"):SetWidth(80);
    	getglobal("STG_SB_RepWithItems"):SetWidth(80);

	getglobal("ShatarGrinderGrindFrame"):SetWidth(215);
	getglobal("STG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("STG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("STG_TimeTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("STG_RepTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("STG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("STG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("STG_TimeTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("STG_RepTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("STG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("STG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ShatarGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("STG_StRep"):SetText(STG_TEXT["St Rep"]);
    
    getglobal("STG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("STG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("STG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("STG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("STG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("STG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("STG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("STG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("STG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("STG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("STG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("STG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ShatarGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local ShatarFound = false;
    local AldorFound = false;
    local ScryersFound = false;

    local ShatarStandingId, ShatarEarnedValue;
    local AldorStandingId, AldorEarnedValue;
    local ScryersStandingId, ScryersEarnedValue;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if (isHeader == nil)then
	    if(string.find(factionName, STG_TEXT["Sha'tar Faction Name"])) then
		ShatarFound = true; 
		ShatarStandingId = standingId;
		ShatarEarnedValue = earnedValue;
	    elseif(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))then
		AldorFound = true;
		AldorStandingId = standingId;
		AldorEarnedValue = earnedValue;
	    elseif(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))then
		ScryersFound = true;
		ScryersStandingId = standingId;
		ScryersEarnedValue = earnedValue;
	    end
        end
    end

    if(not ShatarFound)then
	ShatarStandingId = 4;
	ShatarEarnedValue = 0;
    end
    if(not AldorFound)then
	AldorStandingId = 4;
	AldorEarnedValue = 0;
    end
    if(not ScryersFound)then
	ScryersStandingId = 4;
	ScryersEarnedValue = 0;
    end

    if(ShatarStandingId==8)then --Exalted
	getglobal("STG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(STG_REP_VALUE/42)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE-42000).."/1000");
    elseif(ShatarStandingId==7)then --Revered
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((ShatarEarnedValue-21000)/21000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((ShatarEarnedValue+STG_REP_VALUE-21000)/210)));
	repPercent = math.floor((ShatarEarnedValue-21000)/21)/10;
	itemPercent = math.floor(STG_REP_VALUE/21)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE-21000).."/21000");
    elseif(ShatarStandingId==6)then --Honored
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((ShatarEarnedValue-9000)/12000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((ShatarEarnedValue+STG_REP_VALUE-9000)/120)));
	repPercent = math.floor((ShatarEarnedValue-9000)/12)/10;
	itemPercent = math.floor(STG_REP_VALUE/12)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE-9000).."/12000");
    elseif(ShatarStandingId==5)then --Friendly
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((ShatarEarnedValue-3000)/6000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((ShatarEarnedValue+STG_REP_VALUE-3000)/60)));
	repPercent = math.floor((ShatarEarnedValue-3000)/6)/10;
	itemPercent = math.floor(STG_REP_VALUE/6)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE-3000).."/6000");
    elseif(ShatarStandingId==4)then --Neutral
	getglobal("STG_SB_ActualRep"):SetValue(math.floor(ShatarEarnedValue/3000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((ShatarEarnedValue+STG_REP_VALUE)/30)));
	repPercent = math.floor(ShatarEarnedValue/3)/10;
	itemPercent = math.floor(STG_REP_VALUE/3)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE).."/3000");
    elseif(ShatarStandingId==3)then --Unfriendly (-3000 to 0)
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((3000+ShatarEarnedValue)/3000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+ShatarEarnedValue+STG_REP_VALUE)/30)));
	repPercent = math.floor((3000+ShatarEarnedValue)/3)/10;
	itemPercent = math.floor(STG_REP_VALUE/3)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE+3000).."/3000");
    elseif(ShatarStandingId==2)then --Hostile (-6000 to -3000)
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((6000+ShatarEarnedValue)/3000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+ShatarEarnedValue+STG_REP_VALUE)/30)));
	repPercent = math.floor((6000+ShatarEarnedValue)/3)/10;
	itemPercent = math.floor(STG_REP_VALUE/3)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE+6000).."/3000");
    elseif(ShatarStandingId==1)then --Hated (-42000 to -6000)
	getglobal("STG_SB_ActualRep"):SetValue(math.floor((42000+ShatarEarnedValue)/36000*100));
	getglobal("STG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+ShatarEarnedValue+STG_REP_VALUE)/360)));
	repPercent = math.floor((42000+ShatarEarnedValue)/36)/10;
	itemPercent = math.floor(STG_REP_VALUE/36)/10;
	getglobal("STG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("STG_RepPoints"):SetText((ShatarEarnedValue+STG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("STG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ShatarGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;

    local ShatarFound = false;
    local AldorFound = false;
    local ScryersFound = false;

    local ShatarStandingId, ShatarEarnedValue;
    local AldorStandingId, AldorEarnedValue;
    local ScryersStandingId, ScryersEarnedValue;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if (isHeader == nil)then
	    if(string.find(factionName, STG_TEXT["Sha'tar Faction Name"])) then
		ShatarFound = true; 
		ShatarStandingId = standingId;
		ShatarEarnedValue = earnedValue;
	    elseif(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))then
		AldorFound = true;
		AldorStandingId = standingId;
		AldorEarnedValue = earnedValue;
	    elseif(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))then
		ScryersFound = true;
		ScryersStandingId = standingId;
		ScryersEarnedValue = earnedValue;
	    end
        end
    end

    if(not ShatarFound)then
	ShatarStandingId = 4;
	ShatarEarnedValue = 0;
    end
    if(not AldorFound)then
	AldorStandingId = 4;
	AldorEarnedValue = 0;
    end
    if(not ScryersFound)then
	ScryersStandingId = 4;
	ScryersEarnedValue = 0;
    end

    if(ShatarStandingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-STG_REP_VALUE,0);
    end

    local twentyfive = 12.5;
    local threefifty = 175;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 13.75;
	threefifty = 192.5;
    end

    local tooltip = getglobal("STGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..STG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Mark of Kil'jaeden")then
	reward = twentyfive;
	if((AldorStandingId == 4)or(AldorStandingId == 5))and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(AldorStandingId == 4)or(AldorStandingId == 5)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or Friendly with Aldor"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or Friendly with Aldor"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Adyen the Lightwarden"].." - "..FG_TEXT["Shattrath City"].." (31,35)");
    elseif(text=="Fel Armament")then
	reward = threefifty;
	if(AldorStandingId >= 4)and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(AldorStandingId >= 4)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or better with Aldor"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or better with Aldor"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Ishanah"].." - "..FG_TEXT["Shattrath City"].." (24,30)");
    elseif(text=="Mark of Sargeras")then
	reward = twentyfive;
	if(AldorStandingId >= 4)and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(AldorStandingId >= 4)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or better with Aldor"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or better with Aldor"]);
	end
	if(UnitLevel("player") >= 68)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 68");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 68");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Adyen the Lightwarden"].." - "..FG_TEXT["Shattrath City"].." (31,35)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Harbinger Saronen"].." - "..FG_TEXT["Shadowmoon Valley"].." (62,29)");
    elseif(text=="Firewing Signet")then
	reward = twentyfive;
	if((ScryersStandingId == 4)or(ScryersStandingId == 5))and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(ScryersStandingId == 4)or(ScryersStandingId == 5)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or Friendly with Scryers"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or Friendly with Scryers"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Fyalenn"].." - "..FG_TEXT["Shattrath City"].." (45,81)");
    elseif(text=="Arcane Tome")then
	reward = threefifty;
	if(ScryersStandingId >= 4)and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(ScryersStandingId >= 4)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or better with Scryers"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or better with Scryers"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Voren'thal the Seer"].." - "..FG_TEXT["Shattrath City"].." (43,92)");
    elseif(text=="Sunfury Signet")then
	reward = twentyfive;
	if(ScryersStandingId >= 4)and(ShatarStandingId < 6)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        else
	    tooltip:AddLine(FG_RED..STG_TEXT["No Sha'tar rep rewarded once Honored with Sha'tar"]);
        end	
	if(ScryersStandingId >= 4)then
	    tooltip:AddLine(FG_GREEN..STG_TEXT["Only repeatable while Neutral or better with Scryers"]);
	else
	    tooltip:AddLine(FG_RED..STG_TEXT["Only repeatable while Neutral or better with Scryers"]);
	end
	if(UnitLevel("player") >= 68)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 68");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 68");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Fyalenn"].." - "..FG_TEXT["Shattrath City"].." (45,81)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Battlemage Vyara"].." - "..FG_TEXT["Shadowmoon Valley"].." (56,58)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ShatarGrinder_HideToolTip()
    getglobal("STGToolTip"):Hide();
end

function STG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, STG_TEXT["Sha'tar Faction Name"]))) then
	    return earnedValue + STG_REP_VALUE;
	end
    end
    return STG_REP_VALUE;
end

function ShatarGrinder_ToggleGrinding()
    STG_NOW_GRINDING = not STG_NOW_GRINDING;

    local button = getglobal("STG_BU_ToggleGrinding");
    if(STG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("STG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	STG_GRINDING_STARTED_AT = GetTime();
	STG_INITIALREP = STG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("STG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	STG_PREVIOUS_GRINDING_TIME = STG_PREVIOUS_GRINDING_TIME + (GetTime()-STG_GRINDING_STARTED_AT);
	STG_PREVIOUS_REP_GROUND = STG_PREVIOUS_REP_GROUND + (STG_GetCurrentRepTotal() - STG_INITIALREP); 
    end
end

function ShatarGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ShatarGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ShatarGrinder");
	ShatarGrinder_UpdateDisplayData();
    end

    if(GetTime() > STG_NEXT_GRIND_UPDATE)then
	STG_NEXT_GRIND_UPDATE = STG_NEXT_GRIND_UPDATE + STG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(STG_NOW_GRINDING)then	
	    getglobal("STG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(STG_PREVIOUS_GRINDING_TIME + (GetTime()-STG_GRINDING_STARTED_AT)));
	    getglobal("STG_RepTodayVal"):SetText(FG_GREY..(STG_PREVIOUS_REP_GROUND + (STG_GetCurrentRepTotal() - STG_INITIALREP)));
	    RepPerSecond = ((STG_PREVIOUS_REP_GROUND + (STG_GetCurrentRepTotal() - STG_INITIALREP)) / 
                            math.max(math.floor(STG_PREVIOUS_GRINDING_TIME + (GetTime()-STG_GRINDING_STARTED_AT)),1));
	    getglobal("STG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("STG_TimeToRepUpTodayVal"):SetText(FG_GREY..STG_TimeToRepUp(RepPerSecond));

	    getglobal("STG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Sha'tar")+STG_PREVIOUS_GRINDING_TIME + (GetTime()-STG_GRINDING_STARTED_AT)));
	    getglobal("STG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Sha'tar")+STG_PREVIOUS_REP_GROUND + (STG_GetCurrentRepTotal() - STG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Sha'tar")+STG_PREVIOUS_REP_GROUND + (STG_GetCurrentRepTotal() - STG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Sha'tar")+STG_PREVIOUS_GRINDING_TIME + (GetTime()-STG_GRINDING_STARTED_AT)),1));
	    getglobal("STG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("STG_TimeToRepUpTotalVal"):SetText(FG_GREY..STG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("STG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(STG_PREVIOUS_GRINDING_TIME));
	    getglobal("STG_RepTodayVal"):SetText(FG_GREY..(STG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (STG_PREVIOUS_REP_GROUND / math.max(STG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("STG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("STG_TimeToRepUpTodayVal"):SetText(FG_GREY..STG_TimeToRepUp(RepPerSecond));

	    getglobal("STG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Sha'tar")+STG_PREVIOUS_GRINDING_TIME));
	    getglobal("STG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Sha'tar")+STG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Sha'tar")+STG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Sha'tar")+STG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("STG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("STG_TimeToRepUpTotalVal"):SetText(FG_GREY..STG_TimeToRepUp(RepPerSecond));
        end
    end
end

function STG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, STG_TEXT["Sha'tar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-STG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ShatarGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(STG_TEXT[itemName]);
    end
end
