--ScryersGrinder 1.0
--Written By Tiok - US Thrall

SCG_INITIALREP = 0;

SCG_NOW_GRINDING = false;
SCG_PREVIOUS_GRINDING_TIME = 0;
SCG_GRINDING_STARTED_AT = 0;
SCG_PREVIOUS_REP_GROUND = 0;

SCG_GRIND_UPDATE_INTERVAL = 1;
SCG_NEXT_GRIND_UPDATE = 0;

SCG_REP_VALUE = 0;

SCG_TEXT = 
{
    ["Scryers Faction Name"] = "The Scryers";
    ["Sc Rep"] = "Sc Rep";

    ["Dampscale Basilisk Eye"] = "Dampscale Basilisk Eye";
    ["Firewing Signet"] = "Firewing Signet";
    ["Arcane Tome"] = "Arcane Tome";
    ["Sunfury Signet"] = "Sunfury Signet";
}

function InstallScryersGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ScryersGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ScryersGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ScryersGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ScryersGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ScryersGrinder"] = "SCG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ScryersLabel");
    FG_ScryersLabel:SetFontObject("GameFontNormalSmall");
    FG_ScryersLabel:SetText("The Scryers");
    FG_ScryersLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ScryersTexture");
    ScryersTexture:SetTexture("Interface\\Icons\\INV_Jewelry_Ring_23");
    ScryersTexture:SetWidth(24);
    ScryersTexture:SetHeight(24);
    ScryersTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ScryersTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ScryersGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ScryersGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ScryersGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ScryersGrinder_Init()
    SCG_NEXT_GRIND_UPDATE = GetTime()+SCG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ScryersGrinder","Dampscale Basilisk Eye","25744","white");
    GrinderCore_RegisterItem("ScryersGrinder","Firewing Signet","29426","white");
    GrinderCore_RegisterItem("ScryersGrinder","Arcane Tome","29739","green");
    GrinderCore_RegisterItem("ScryersGrinder","Sunfury Signet","30810","white");

    ScryersGrinder_UpdateDisplayData();
    ScryersGrinder_UpdateRepBars();
end

function ScryersGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    itemName = "Dampscale Basilisk Eye";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId <= 3)then
        repValue = repValue + math.floor(itemCount/8)*250;
    end
    getglobal("SCG_DampscaleBasiliskEyeCount"):SetText(itemCount.."/8");

    itemName = "Firewing Signet";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId == 4)or(standingId == 5)then
        repValue = repValue + itemCount*25;
    end
    getglobal("SCG_FirewingSignetCount"):SetText(itemCount.."/1");

    itemName = "Arcane Tome";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + itemCount*350;
    end
    getglobal("SCG_ArcaneTomeCount"):SetText(itemCount.."/1");

    itemName = "Sunfury Signet";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + itemCount*25;
    end
    getglobal("SCG_SunfurySignetCount"):SetText(itemCount.."/1");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SCG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SCG_REP_VALUE ~= repValue)then
        SCG_REP_VALUE = repValue;
	ScryersGrinder_UpdateRepBars();
    end
end

function ScryersGrinder_OnLoad()
    ScryersGrinder_RegisterEvents();
end

function ScryersGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ScryersGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ScryersGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ScryersGrinder_UpdateDisplayData();
	ScryersGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ScryersGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Scryers",GrinderCore_GetGrindingTime("Scryers")+SCG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Scryers",GrinderCore_GetRepGround("Scryers")+SCG_PREVIOUS_REP_GROUND);
	if(SCG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Scryers",GrinderCore_GetGrindingTime("Scryers")+(GetTime()-SCG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Scryers",GrinderCore_GetRepGround("Scryers")+(SCG_GetCurrentRepTotal() - SCG_INITIALREP));
	end
    end
end

function ScryersGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SCG_TEXT = SCG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ScryersGrinderGrindFrame"):SetWidth(215);
	getglobal("SCG_TimeTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SCG_RepTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SCG_TimeTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SCG_RepTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SCG_TEXT = SCG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SCG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SCG_TEXT = SCG_TEXT_ZHTW;

	getglobal("SCG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_ScRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SCGToRepUpFrame"):SetWidth(90);
	getglobal("SCGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SCG_SB_ActualRep"):SetWidth(80);
    	getglobal("SCG_SB_RepWithItems"):SetWidth(80);

	getglobal("ScryersGrinderGrindFrame"):SetWidth(215);
	getglobal("SCG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SCG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SCG_TimeTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SCG_RepTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SCG_TimeTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SCG_RepTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ScryersGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SCG_ScRep"):SetText(SCG_TEXT["Sc Rep"]);
    
    getglobal("SCG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SCG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SCG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SCG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SCG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SCG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SCG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SCG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SCG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SCG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SCG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ScryersGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SCG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SCG_REP_VALUE/42)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SCG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SCG_REP_VALUE/21)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SCG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SCG_REP_VALUE/12)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SCG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SCG_REP_VALUE/6)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SCG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SCG_REP_VALUE/3)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SCG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SCG_REP_VALUE/3)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SCG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SCG_REP_VALUE/3)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SCG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SCG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SCG_REP_VALUE/36)/10;
	getglobal("SCG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SCG_RepPoints"):SetText((earnedValue+SCG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SCG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ScryersGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-SCG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-SCG_REP_VALUE,0);
    end

    local twentyfive = 25;
    local twofifty = 250;
    local threefifty = 350;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
	twofifty = 275;
	threefifty = 385;
    end

    local tooltip = getglobal("SCGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SCG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Dampscale Basilisk Eye")then
	reward = twofifty;
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREY.."8 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/8 = "..(math.floor(itemCount/8)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*8-(itemCount % 8))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Arcanist Adyria"].." - "..FG_TEXT["Shattrath City"].." (55,22)");
    elseif(text=="Firewing Signet")then
	reward = twentyfive;
	if(standingId == 4)or(standingId == 5)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end	
	if(standingId == 4)or(standingId == 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Fyalenn"].." - "..FG_TEXT["Shattrath City"].." (45,81)");
    elseif(text=="Arcane Tome")then
	reward = threefifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Voren'thal the Seer"].." - "..FG_TEXT["Shattrath City"].." (43,92)");
    elseif(text=="Sunfury Signet")then
	reward = twentyfive;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 68)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 68");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 68");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Magistrix Fyalenn"].." - "..FG_TEXT["Shattrath City"].." (45,81)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Battlemage Vyara"].." - "..FG_TEXT["Shadowmoon Valley"].." (56,58)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ScryersGrinder_HideToolTip()
    getglobal("SCGToolTip"):Hide();
end

function SCG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))) then
	    return earnedValue + SCG_REP_VALUE;
	end
    end
    return SCG_REP_VALUE;
end

function ScryersGrinder_ToggleGrinding()
    SCG_NOW_GRINDING = not SCG_NOW_GRINDING;

    local button = getglobal("SCG_BU_ToggleGrinding");
    if(SCG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SCG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SCG_GRINDING_STARTED_AT = GetTime();
	SCG_INITIALREP = SCG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SCG_PREVIOUS_GRINDING_TIME = SCG_PREVIOUS_GRINDING_TIME + (GetTime()-SCG_GRINDING_STARTED_AT);
	SCG_PREVIOUS_REP_GROUND = SCG_PREVIOUS_REP_GROUND + (SCG_GetCurrentRepTotal() - SCG_INITIALREP); 
    end
end

function ScryersGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ScryersGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ScryersGrinder");
	ScryersGrinder_UpdateDisplayData();
    end

    if(GetTime() > SCG_NEXT_GRIND_UPDATE)then
	SCG_NEXT_GRIND_UPDATE = SCG_NEXT_GRIND_UPDATE + SCG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SCG_NOW_GRINDING)then	
	    getglobal("SCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SCG_PREVIOUS_GRINDING_TIME + (GetTime()-SCG_GRINDING_STARTED_AT)));
	    getglobal("SCG_RepTodayVal"):SetText(FG_GREY..(SCG_PREVIOUS_REP_GROUND + (SCG_GetCurrentRepTotal() - SCG_INITIALREP)));
	    RepPerSecond = ((SCG_PREVIOUS_REP_GROUND + (SCG_GetCurrentRepTotal() - SCG_INITIALREP)) / 
                            math.max(math.floor(SCG_PREVIOUS_GRINDING_TIME + (GetTime()-SCG_GRINDING_STARTED_AT)),1));
	    getglobal("SCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SCG_TimeToRepUpTodayVal"):SetText(FG_GREY..SCG_TimeToRepUp(RepPerSecond));

	    getglobal("SCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Scryers")+SCG_PREVIOUS_GRINDING_TIME + (GetTime()-SCG_GRINDING_STARTED_AT)));
	    getglobal("SCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Scryers")+SCG_PREVIOUS_REP_GROUND + (SCG_GetCurrentRepTotal() - SCG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Scryers")+SCG_PREVIOUS_REP_GROUND + (SCG_GetCurrentRepTotal() - SCG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Scryers")+SCG_PREVIOUS_GRINDING_TIME + (GetTime()-SCG_GRINDING_STARTED_AT)),1));
	    getglobal("SCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SCG_TimeToRepUpTotalVal"):SetText(FG_GREY..SCG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SCG_PREVIOUS_GRINDING_TIME));
	    getglobal("SCG_RepTodayVal"):SetText(FG_GREY..(SCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SCG_PREVIOUS_REP_GROUND / math.max(SCG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SCG_TimeToRepUpTodayVal"):SetText(FG_GREY..SCG_TimeToRepUp(RepPerSecond));

	    getglobal("SCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Scryers")+SCG_PREVIOUS_GRINDING_TIME));
	    getglobal("SCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Scryers")+SCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Scryers")+SCG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Scryers")+SCG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SCG_TimeToRepUpTotalVal"):SetText(FG_GREY..SCG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SCG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SCG_TEXT["Scryers Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SCG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ScryersGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(SCG_TEXT[itemName]);
    end
end
