--ScaleoftheSandsGrinder 1.0
--Written By Tiok - US Thrall

SotSG_INITIALREP = 0;

SotSG_NOW_GRINDING = false;
SotSG_PREVIOUS_GRINDING_TIME = 0;
SotSG_GRINDING_STARTED_AT = 0;
SotSG_PREVIOUS_REP_GROUND = 0;

SotSG_GRIND_UPDATE_INTERVAL = 1;
SotSG_NEXT_GRIND_UPDATE = 0;

SotSG_REP_VALUE = 0;

SotSG_TEXT = 
{
    ["Scale of the Sands Faction Name"] = "Scale of the Sands";
    ["SS Rep"] = "SS Rep";
}

function InstallScaleoftheSandsGrinder()
    --Add this faction to the "Show" settings.
    --if (FactionGrinderSettings["Show"]["ScaleoftheSandsGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ScaleoftheSandsGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ScaleoftheSandsGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ScaleoftheSandsGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ScaleoftheSandsGrinder"] = "SotSG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ScaleoftheSandsLabel");
    FG_ScaleoftheSandsLabel:SetFontObject("GameFontNormalSmall");
    FG_ScaleoftheSandsLabel:SetText("Scale of the Sands");
    FG_ScaleoftheSandsLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ScaleoftheSandsTexture");
    ScaleoftheSandsTexture:SetTexture("Interface\\Icons\\INV_Misc_MonsterScales_13");
    ScaleoftheSandsTexture:SetWidth(24);
    ScaleoftheSandsTexture:SetHeight(24);
    ScaleoftheSandsTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ScaleoftheSandsTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    --local cb = CreateFrame("CheckButton","FG_CB_ScaleoftheSandsGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    --cb:SetChecked(false);
    --cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ScaleoftheSandsGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ScaleoftheSandsGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ScaleoftheSandsGrinder_Init()
    SotSG_NEXT_GRIND_UPDATE = GetTime()+SotSG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here
    
    --If any, Item Registrations would occur here.

    ScaleoftheSandsGrinder_UpdateDisplayData();
    ScaleoftheSandsGrinder_UpdateRepBars();
end

function ScaleoftheSandsGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    --If any, calculations of reputation based on items would occur here.

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("SotSG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(SotSG_REP_VALUE ~= repValue)then
        SotSG_REP_VALUE = repValue;
	ScaleoftheSandsGrinder_UpdateRepBars();
    end
end

function ScaleoftheSandsGrinder_OnLoad()
    ScaleoftheSandsGrinder_RegisterEvents();
end

function ScaleoftheSandsGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ScaleoftheSandsGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ScaleoftheSandsGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ScaleoftheSandsGrinder_UpdateDisplayData();
	ScaleoftheSandsGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ScaleoftheSandsGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("The Scale of the Sands",GrinderCore_GetGrindingTime("The Scale of the Sands")+SotSG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("The Scale of the Sands",GrinderCore_GetRepGround("The Scale of the Sands")+SotSG_PREVIOUS_REP_GROUND);
	if(SotSG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("The Scale of the Sands",GrinderCore_GetGrindingTime("The Scale of the Sands")+(GetTime()-SotSG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("The Scale of the Sands",GrinderCore_GetRepGround("The Scale of the Sands")+(SotSG_GetCurrentRepTotal() - SotSG_INITIALREP));
	end
    end
end

function ScaleoftheSandsGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	SotSG_TEXT = SotSG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ScaleoftheSandsGrinderGrindFrame"):SetWidth(215);
	getglobal("SotSG_TimeTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SotSG_RepTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SotSG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SotSG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SotSG_TimeTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SotSG_RepTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SotSG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SotSG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	SotSG_TEXT = SotSG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("SotSG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	SotSG_TEXT = SotSG_TEXT_ZHTW;

	getglobal("SotSG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_SSRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("SotSGToRepUpFrame"):SetWidth(90);
	getglobal("SotSGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("SotSG_SB_ActualRep"):SetWidth(80);
    	getglobal("SotSG_SB_RepWithItems"):SetWidth(80);

	getglobal("ScaleoftheSandsGrinderGrindFrame"):SetWidth(215);
	getglobal("SotSG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("SotSG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("SotSG_TimeTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("SotSG_RepTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("SotSG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("SotSG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("SotSG_TimeTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("SotSG_RepTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("SotSG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("SotSG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ScaleoftheSandsGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("SotSG_SSRep"):SetText(SotSG_TEXT["SS Rep"]);
    
    getglobal("SotSG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("SotSG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("SotSG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("SotSG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SotSG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SotSG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SotSG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("SotSG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("SotSG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("SotSG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("SotSG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("SotSG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ScaleoftheSandsGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SotSG_TEXT["Scale of the Sands Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("SotSG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(SotSG_REP_VALUE/42)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SotSG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/21)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SotSG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/12)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SotSG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/6)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+SotSG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/3)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+SotSG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/3)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+SotSG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/3)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("SotSG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("SotSG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+SotSG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(SotSG_REP_VALUE/36)/10;
	getglobal("SotSG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("SotSG_RepPoints"):SetText((earnedValue+SotSG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("SotSG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ScaleoftheSandsGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SotSG_TEXT["Scale of the Sands Faction Name"]))) then
	    factionFound = true;
 	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-SotSG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
    end

    local tooltip = getglobal("SotSGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..SotSG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

--    if(text=="Deadwood Headdress Feather")then
--	tooltip:AddLine(FG_GREY.."5 = "..seventyfive.." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*seventyfive).." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/seventyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
--    end
--    tooltip:Show();
    tooltip:ClearAllPoints();
--    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ScaleoftheSandsGrinder_HideToolTip()
    getglobal("SotSGToolTip"):Hide();
end

function SotSG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SotSG_TEXT["Scale of the Sands Faction Name"]))) then
	    return earnedValue + SotSG_REP_VALUE;
	end
    end
    return SotSG_REP_VALUE;
end

function ScaleoftheSandsGrinder_ToggleGrinding()
    SotSG_NOW_GRINDING = not SotSG_NOW_GRINDING;

    local button = getglobal("SotSG_BU_ToggleGrinding");
    if(SotSG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("SotSG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	SotSG_GRINDING_STARTED_AT = GetTime();
	SotSG_INITIALREP = SotSG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("SotSG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	SotSG_PREVIOUS_GRINDING_TIME = SotSG_PREVIOUS_GRINDING_TIME + (GetTime()-SotSG_GRINDING_STARTED_AT);
	SotSG_PREVIOUS_REP_GROUND = SotSG_PREVIOUS_REP_GROUND + (SotSG_GetCurrentRepTotal() - SotSG_INITIALREP); 
    end
end

function ScaleoftheSandsGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ScaleoftheSandsGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ScaleoftheSandsGrinder");
	ScaleoftheSandsGrinder_UpdateDisplayData();
    end

    if(GetTime() > SotSG_NEXT_GRIND_UPDATE)then
	SotSG_NEXT_GRIND_UPDATE = SotSG_NEXT_GRIND_UPDATE + SotSG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(SotSG_NOW_GRINDING)then	
	    getglobal("SotSG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SotSG_PREVIOUS_GRINDING_TIME + (GetTime()-SotSG_GRINDING_STARTED_AT)));
	    getglobal("SotSG_RepTodayVal"):SetText(FG_GREY..(SotSG_PREVIOUS_REP_GROUND + (SotSG_GetCurrentRepTotal() - SotSG_INITIALREP)));
	    RepPerSecond = ((SotSG_PREVIOUS_REP_GROUND + (SotSG_GetCurrentRepTotal() - SotSG_INITIALREP)) / 
                            math.max(math.floor(SotSG_PREVIOUS_GRINDING_TIME + (GetTime()-SotSG_GRINDING_STARTED_AT)),1));
	    getglobal("SotSG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SotSG_TimeToRepUpTodayVal"):SetText(FG_GREY..SotSG_TimeToRepUp(RepPerSecond));

	    getglobal("SotSG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Scale of the Sands")+SotSG_PREVIOUS_GRINDING_TIME + (GetTime()-SotSG_GRINDING_STARTED_AT)));
	    getglobal("SotSG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Scale of the Sands")+SotSG_PREVIOUS_REP_GROUND + (SotSG_GetCurrentRepTotal() - SotSG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Scale of the Sands")+SotSG_PREVIOUS_REP_GROUND + (SotSG_GetCurrentRepTotal() - SotSG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Scale of the Sands")+SotSG_PREVIOUS_GRINDING_TIME + (GetTime()-SotSG_GRINDING_STARTED_AT)),1));
	    getglobal("SotSG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SotSG_TimeToRepUpTotalVal"):SetText(FG_GREY..SotSG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("SotSG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(SotSG_PREVIOUS_GRINDING_TIME));
	    getglobal("SotSG_RepTodayVal"):SetText(FG_GREY..(SotSG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (SotSG_PREVIOUS_REP_GROUND / math.max(SotSG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("SotSG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SotSG_TimeToRepUpTodayVal"):SetText(FG_GREY..SotSG_TimeToRepUp(RepPerSecond));

	    getglobal("SotSG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Scale of the Sands")+SotSG_PREVIOUS_GRINDING_TIME));
	    getglobal("SotSG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Scale of the Sands")+SotSG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Scale of the Sands")+SotSG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Scale of the Sands")+SotSG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("SotSG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("SotSG_TimeToRepUpTotalVal"):SetText(FG_GREY..SotSG_TimeToRepUp(RepPerSecond));
        end
    end
end

function SotSG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, SotSG_TEXT["Scale of the Sands Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-SotSG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ScaleoftheSandsGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(itemName);
    end
end
