--OrgrimmarGrinder 1.0
--Written By Tiok - US Thrall

ORG_INITIALREP = 0;

ORG_NOW_GRINDING = false;
ORG_PREVIOUS_GRINDING_TIME = 0;
ORG_GRINDING_STARTED_AT = 0;
ORG_PREVIOUS_REP_GROUND = 0;

ORG_GRIND_UPDATE_INTERVAL = 1;
ORG_NEXT_GRIND_UPDATE = 0;

ORG_REP_VALUE = 0;

ORG_TEXT = 
{
    ["Orgrimmar Faction Name"] = "Orgrimmar";
    ["Or Rep"] = "Or Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallOrgrimmarGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["OrgrimmarGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["OrgrimmarGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["OrgrimmarGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["OrgrimmarGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["OrgrimmarGrinder"] = "ORG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_OrgrimmarLabel");
    FG_OrgrimmarLabel:SetFontObject("GameFontNormalSmall");
    FG_OrgrimmarLabel:SetText("Orgrimmar");
    FG_OrgrimmarLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("OrgrimmarTexture");
    OrgrimmarTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Orc_02");
    OrgrimmarTexture:SetWidth(24);
    OrgrimmarTexture:SetHeight(24);
    OrgrimmarTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    OrgrimmarTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_OrgrimmarGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_OrgrimmarGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function OrgrimmarGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function OrgrimmarGrinder_Init()
    ORG_NEXT_GRIND_UPDATE = GetTime()+ORG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("OrgrimmarGrinder","Runecloth","14047","white");

    OrgrimmarGrinder_UpdateDisplayData();
    OrgrimmarGrinder_UpdateRepBars();
end

function OrgrimmarGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("ORG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("ORG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(ORG_REP_VALUE ~= repValue)then
        ORG_REP_VALUE = repValue;
	OrgrimmarGrinder_UpdateRepBars();
    end
end

function OrgrimmarGrinder_OnLoad()
    OrgrimmarGrinder_RegisterEvents();
end

function OrgrimmarGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        OrgrimmarGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	OrgrimmarGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	OrgrimmarGrinder_UpdateDisplayData();
	OrgrimmarGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	OrgrimmarGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Orgrimmar",GrinderCore_GetGrindingTime("Orgrimmar")+ORG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Orgrimmar",GrinderCore_GetRepGround("Orgrimmar")+ORG_PREVIOUS_REP_GROUND);
	if(ORG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Orgrimmar",GrinderCore_GetGrindingTime("Orgrimmar")+(GetTime()-ORG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Orgrimmar",GrinderCore_GetRepGround("Orgrimmar")+(ORG_GetCurrentRepTotal() - ORG_INITIALREP));
	end
    end
end

function OrgrimmarGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	ORG_TEXT = ORG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("OrgrimmarGrinderGrindFrame"):SetWidth(215);
	getglobal("ORG_TimeTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ORG_RepTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ORG_RepPerHourTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ORG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ORG_TimeTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ORG_RepTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ORG_RepPerHourTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ORG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	ORG_TEXT = ORG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("ORG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	ORG_TEXT = ORG_TEXT_ZHTW;

	getglobal("ORG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_OrRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("ORGToRepUpFrame"):SetWidth(90);
	getglobal("ORGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("ORG_SB_ActualRep"):SetWidth(80);
    	getglobal("ORG_SB_RepWithItems"):SetWidth(80);

	getglobal("OrgrimmarGrinderGrindFrame"):SetWidth(215);
	getglobal("ORG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ORG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("ORG_TimeTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ORG_RepTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ORG_RepPerHourTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ORG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ORG_TimeTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ORG_RepTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ORG_RepPerHourTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ORG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","OrgrimmarGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("ORG_OrRep"):SetText(ORG_TEXT["Or Rep"]);
    
    getglobal("ORG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("ORG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("ORG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("ORG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ORG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ORG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ORG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("ORG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ORG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ORG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ORG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("ORG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function OrgrimmarGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ORG_TEXT["Orgrimmar Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("ORG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(ORG_REP_VALUE/42)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ORG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(ORG_REP_VALUE/21)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ORG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(ORG_REP_VALUE/12)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ORG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(ORG_REP_VALUE/6)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ORG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(ORG_REP_VALUE/3)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+ORG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(ORG_REP_VALUE/3)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+ORG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(ORG_REP_VALUE/3)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("ORG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("ORG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+ORG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(ORG_REP_VALUE/36)/10;
	getglobal("ORG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("ORG_RepPoints"):SetText((earnedValue+ORG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("ORG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function OrgrimmarGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ORG_TEXT["Orgrimmar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-ORG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-ORG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("ORGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..ORG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Rashona Straglash"].." - "..FG_TEXT["Orgrimmar"].." (63,51)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function OrgrimmarGrinder_HideToolTip()
    getglobal("ORGToolTip"):Hide();
end

function ORG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ORG_TEXT["Orgrimmar Faction Name"]))) then
	    return earnedValue + ORG_REP_VALUE;
	end
    end
    return ORG_REP_VALUE;
end

function OrgrimmarGrinder_ToggleGrinding()
    ORG_NOW_GRINDING = not ORG_NOW_GRINDING;

    local button = getglobal("ORG_BU_ToggleGrinding");
    if(ORG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("ORG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	ORG_GRINDING_STARTED_AT = GetTime();
	ORG_INITIALREP = ORG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("ORG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	ORG_PREVIOUS_GRINDING_TIME = ORG_PREVIOUS_GRINDING_TIME + (GetTime()-ORG_GRINDING_STARTED_AT);
	ORG_PREVIOUS_REP_GROUND = ORG_PREVIOUS_REP_GROUND + (ORG_GetCurrentRepTotal() - ORG_INITIALREP); 
    end
end

function OrgrimmarGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("OrgrimmarGrinder"))then	
	GrinderCore_AcknowledgeItemChange("OrgrimmarGrinder");
	OrgrimmarGrinder_UpdateDisplayData();
    end

    if(GetTime() > ORG_NEXT_GRIND_UPDATE)then
	ORG_NEXT_GRIND_UPDATE = ORG_NEXT_GRIND_UPDATE + ORG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(ORG_NOW_GRINDING)then	
	    getglobal("ORG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ORG_PREVIOUS_GRINDING_TIME + (GetTime()-ORG_GRINDING_STARTED_AT)));
	    getglobal("ORG_RepTodayVal"):SetText(FG_GREY..(ORG_PREVIOUS_REP_GROUND + (ORG_GetCurrentRepTotal() - ORG_INITIALREP)));
	    RepPerSecond = ((ORG_PREVIOUS_REP_GROUND + (ORG_GetCurrentRepTotal() - ORG_INITIALREP)) / 
                            math.max(math.floor(ORG_PREVIOUS_GRINDING_TIME + (GetTime()-ORG_GRINDING_STARTED_AT)),1));
	    getglobal("ORG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ORG_TimeToRepUpTodayVal"):SetText(FG_GREY..ORG_TimeToRepUp(RepPerSecond));

	    getglobal("ORG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Orgrimmar")+ORG_PREVIOUS_GRINDING_TIME + (GetTime()-ORG_GRINDING_STARTED_AT)));
	    getglobal("ORG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Orgrimmar")+ORG_PREVIOUS_REP_GROUND + (ORG_GetCurrentRepTotal() - ORG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Orgrimmar")+ORG_PREVIOUS_REP_GROUND + (ORG_GetCurrentRepTotal() - ORG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Orgrimmar")+ORG_PREVIOUS_GRINDING_TIME + (GetTime()-ORG_GRINDING_STARTED_AT)),1));
	    getglobal("ORG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ORG_TimeToRepUpTotalVal"):SetText(FG_GREY..ORG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("ORG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ORG_PREVIOUS_GRINDING_TIME));
	    getglobal("ORG_RepTodayVal"):SetText(FG_GREY..(ORG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (ORG_PREVIOUS_REP_GROUND / math.max(ORG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("ORG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ORG_TimeToRepUpTodayVal"):SetText(FG_GREY..ORG_TimeToRepUp(RepPerSecond));

	    getglobal("ORG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Orgrimmar")+ORG_PREVIOUS_GRINDING_TIME));
	    getglobal("ORG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Orgrimmar")+ORG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Orgrimmar")+ORG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Orgrimmar")+ORG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("ORG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ORG_TimeToRepUpTotalVal"):SetText(FG_GREY..ORG_TimeToRepUp(RepPerSecond));
        end
    end
end

function ORG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ORG_TEXT["Orgrimmar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-ORG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function OrgrimmarGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(ORG_TEXT[itemName]);
    end
end
