--OgrilaGrinder 1.0
--Written By Tiok - US Thrall

OGG_INITIALREP = 0;

OGG_NOW_GRINDING = false;
OGG_PREVIOUS_GRINDING_TIME = 0;
OGG_GRINDING_STARTED_AT = 0;
OGG_PREVIOUS_REP_GROUND = 0;

OGG_GRIND_UPDATE_INTERVAL = 1;
OGG_NEXT_GRIND_UPDATE = 0;

OGG_REP_VALUE = 0;

OGG_TEXT = 
{
    ["Ogri'la Faction Name"] = "Ogri'la";
    ["Og Rep"] = "Og Rep";

    ["The Relic's Emanation"] = "The Relic's Emanation";
    ["Bomb Them Again!"] = "Bomb Them Again!";
    ["Wrangle More Aether Rays!"] = "Wrangle More Aether Rays!";
    ["Banish More Demons"] = "Banish More Demons";

    ["Apexis Emanations attained"] = "Apexis Emanations attained";
    ["Fel Cannonball Stacks destroyed"] = "Fel Cannonball Stacks destroyed";
    ["Aether Rays wrangled"] = "Aether Rays wrangled";
    ["Demons banished"] = "Demons banished";
}

function InstallOgrilaGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["OgrilaGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["OgrilaGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["OgrilaGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["OgrilaGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["OgrilaGrinder"] = "OGG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_OgrilaLabel");
    FG_OgrilaLabel:SetFontObject("GameFontNormalSmall");
    FG_OgrilaLabel:SetText("Ogri'la");
    FG_OgrilaLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("OgrilaTexture");
    OgrilaTexture:SetTexture("Interface\\Icons\\INV_Misc_Statue_06");
    OgrilaTexture:SetWidth(24);
    OgrilaTexture:SetHeight(24);
    OgrilaTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    OgrilaTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_OgrilaGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_OgrilaGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

TheRelicsEmanationIndex = -1;
BombThemAgainIndex = -1;
WrangleMoreAetherRaysIndex = -1;
BanishMoreDemonsIndex = -1;

function OgrilaGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function OgrilaGrinder_Init()
    OGG_NEXT_GRIND_UPDATE = GetTime()+OGG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

--    GrinderCore_RegisterItem("OgrilaGrinder","Shadow Dust","32388","white");

    OgrilaGrinder_UpdateDisplayData();
    OgrilaGrinder_UpdateRepBars();
end

function OgrilaGrinder_UpdateDisplayData()
    local repValue = 0;

    local textColor, itemName, itemCount;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, OGG_TEXT["Ogri'la Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    --Now check if the quests are in the log.  Display accordingly.
    TheRelicsEmanationIndex = -1;
    BombThemAgainIndex = -1;
    WrangleMoreAetherRaysIndex = -1;
    BanishMoreDemonsIndex = -1;

    for qi=1,GetNumQuestLogEntries(),1 do
	if(GetQuestLogTitle(qi) == OGG_TEXT["The Relic's Emanation"])then
	    TheRelicsEmanationIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    if(o1done)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("OGG_TheRelicsEmanationObjective"):SetText(desc..OGG_TEXT["Apexis Emanations attained"]);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == OGG_TEXT["Bomb Them Again!"])then
	    BombThemAgainIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/15)");
	    if(count=="15/15")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("OGG_BombThemAgainObjective"):SetText(desc..OGG_TEXT["Fel Cannonball Stacks destroyed"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 500;
	    end
	elseif(GetQuestLogTitle(qi) == OGG_TEXT["Wrangle More Aether Rays!"])then
	    WrangleMoreAetherRaysIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/5)");
	    if(count=="5/5")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("OGG_WrangleMoreAetherRaysObjective"):SetText(desc..OGG_TEXT["Aether Rays wrangled"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == OGG_TEXT["Banish More Demons"])then
	    BanishMoreDemonsIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/15)");
	    if(count=="15/15")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("OGG_BanishMoreDemonsObjective"):SetText(desc..OGG_TEXT["Demons banished"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	end	
    end

    if(TheRelicsEmanationIndex == -1)then
	getglobal("OGG_TheRelicsEmanationObjective"):SetText(FG_GREY..OGG_TEXT["Apexis Emanations attained"]);
	getglobal("OGG_TheRelicsEmanation"):SetText(FG_GREY..OGG_TEXT["The Relic's Emanation"]);
    else
	getglobal("OGG_TheRelicsEmanation"):SetText(FG_GOLD..OGG_TEXT["The Relic's Emanation"]);
    end

    if(BombThemAgainIndex == -1)then
	getglobal("OGG_BombThemAgainObjective"):SetText(FG_GREY..OGG_TEXT["Fel Cannonball Stacks destroyed"].." : 0/15");
	getglobal("OGG_BombThemAgain"):SetText(FG_GREY..OGG_TEXT["Bomb Them Again!"]);
    else
	getglobal("OGG_BombThemAgain"):SetText(FG_GOLD..OGG_TEXT["Bomb Them Again!"]);
    end

    if(WrangleMoreAetherRaysIndex == -1)then
	getglobal("OGG_WrangleMoreAetherRaysObjective"):SetText(FG_GREY..OGG_TEXT["Aether Rays wrangled"].." : 0/5");
	getglobal("OGG_WrangleMoreAetherRays"):SetText(FG_GREY..OGG_TEXT["Wrangle More Aether Rays!"]);
    else
	getglobal("OGG_WrangleMoreAetherRays"):SetText(FG_GOLD..OGG_TEXT["Wrangle More Aether Rays!"]);
    end

    if(BanishMoreDemonsIndex == -1)then
	getglobal("OGG_BanishMoreDemonsObjective"):SetText(FG_GREY..OGG_TEXT["Demons banished"].." : 0/15");
	getglobal("OGG_BanishMoreDemons"):SetText(FG_GREY..OGG_TEXT["Banish More Demons"]);
    else
	getglobal("OGG_BanishMoreDemons"):SetText(FG_GOLD..OGG_TEXT["Banish More Demons"]);
    end

    if(UnitRace("player") == FG_TEXT["Human"])then
	repValue = repValue * 1.1;
    end

    getglobal("OGG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(OGG_REP_VALUE ~= repValue)then
        OGG_REP_VALUE = repValue;
	OgrilaGrinder_UpdateRepBars();
    end
end

function OgrilaGrinder_OnLoad()
    OgrilaGrinder_RegisterEvents();
end

function OgrilaGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        OgrilaGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	OgrilaGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	OgrilaGrinder_UpdateDisplayData();
	OgrilaGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	OgrilaGrinder_UpdateRepBars();
    elseif( event == "QUEST_LOG_UPDATE")then
	OgrilaGrinder_UpdateDisplayData();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Ogri'la",GrinderCore_GetGrindingTime("Ogri'la")+OGG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Ogri'la",GrinderCore_GetRepGround("Ogri'la")+OGG_PREVIOUS_REP_GROUND);
	if(OGG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Ogri'la",GrinderCore_GetGrindingTime("Ogri'la")+(GetTime()-OGG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Ogri'la",GrinderCore_GetRepGround("Ogri'la")+(OGG_GetCurrentRepTotal() - OGG_INITIALREP));
	end
    end
end

function OgrilaGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	OGG_TEXT = OGG_TEXT_DE;
	--Reconstruct Display frame
	getglobal("OgrilaGrinderDisplayFrame"):SetWidth(225);

	--Reconstruct Grind-Tracker frame
	getglobal("OgrilaGrinderGrindFrame"):SetWidth(215);
	getglobal("OGG_TimeTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("OGG_RepTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("OGG_RepPerHourTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("OGG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("OGG_TimeTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("OGG_RepTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("OGG_RepPerHourTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("OGG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	OGG_TEXT = OGG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("OGG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	OGG_TEXT = OGG_TEXT_ZHTW;

	getglobal("OGG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_OgRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("OGGToRepUpFrame"):SetWidth(90);
	getglobal("OGGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("OGG_SB_ActualRep"):SetWidth(80);
    	getglobal("OGG_SB_RepWithItems"):SetWidth(80);

	getglobal("OgrilaGrinderGrindFrame"):SetWidth(215);
	getglobal("OGG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("OGG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("OGG_TimeTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("OGG_RepTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("OGG_RepPerHourTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("OGG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("OGG_TimeTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("OGG_RepTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("OGG_RepPerHourTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("OGG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","OgrilaGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("OGG_OgRep"):SetText(OGG_TEXT["Og Rep"]);
    getglobal("OGG_TheRelicsEmanation"):SetText(OGG_TEXT["The Relic's Emanation"]);
    getglobal("OGG_BombThemAgain"):SetText(OGG_TEXT["Bomb Them Again!"]);
    getglobal("OGG_WrangleMoreAetherRays"):SetText(OGG_TEXT["Wrangle More Aether Rays"]);
    getglobal("OGG_BanishMoreDemons"):SetText(OGG_TEXT["Banish More Demons"]);
    
    getglobal("OGG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("OGG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("OGG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("OGG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("OGG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("OGG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("OGG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("OGG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("OGG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("OGG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("OGG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("OGG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function OgrilaGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, OGG_TEXT["Ogri'la Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("OGG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(OGG_REP_VALUE/42)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+OGG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(OGG_REP_VALUE/21)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+OGG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(OGG_REP_VALUE/12)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+OGG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(OGG_REP_VALUE/6)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+OGG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(OGG_REP_VALUE/3)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+OGG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(OGG_REP_VALUE/3)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+OGG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(OGG_REP_VALUE/3)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("OGG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("OGG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+OGG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(OGG_REP_VALUE/36)/10;
	getglobal("OGG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("OGG_RepPoints"):SetText((earnedValue+OGG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("OGG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function OgrilaGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, OGG_TEXT["Ogri'la Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-OGG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-OGG_REP_VALUE,0);
    end

    local twofifty = 250;
    local threefifty = 350;
    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twofifty = 275;
	threefifty = 385;
	fivehundred = 550;
    end

    local tooltip = getglobal("OGGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..OGG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="The Relic's Emanation")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Chu'a'lor"].." - "..FG_TEXT["Blade's Edge Mountains"].." (28,57)");
    elseif(text=="Bomb Them Again!")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sky Sergeant Vanderlip"].." - "..FG_TEXT["Blade's Edge Mountains"].." (27,52)");
    elseif(text=="Wrangle More Aether Rays!")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Skyguard Khatie"].." - "..FG_TEXT["Blade's Edge Mountains"].." (27,51)");
    elseif(text=="Banish More Demons")then	
	rward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 6)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Honored or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Kronk"].." - "..FG_TEXT["Blade's Edge Mountains"].." (28,57)");
    end

    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function OgrilaGrinder_HideToolTip()
    getglobal("OGGToolTip"):Hide();
end

function OGG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, OGG_TEXT["Ogri'la Faction Name"]))) then
	    return earnedValue + OGG_REP_VALUE;
	end
    end
    return OGG_REP_VALUE;
end

function OgrilaGrinder_ToggleGrinding()
    OGG_NOW_GRINDING = not OGG_NOW_GRINDING;

    local button = getglobal("OGG_BU_ToggleGrinding");
    if(OGG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("OGG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	OGG_GRINDING_STARTED_AT = GetTime();
	OGG_INITIALREP = OGG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("OGG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	OGG_PREVIOUS_GRINDING_TIME = OGG_PREVIOUS_GRINDING_TIME + (GetTime()-OGG_GRINDING_STARTED_AT);
	OGG_PREVIOUS_REP_GROUND = OGG_PREVIOUS_REP_GROUND + (OGG_GetCurrentRepTotal() - OGG_INITIALREP); 
    end
end

function OgrilaGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("OgrilaGrinder"))then	
	GrinderCore_AcknowledgeItemChange("OgrilaGrinder");
	OgrilaGrinder_UpdateDisplayData();
    end

    if(GetTime() > OGG_NEXT_GRIND_UPDATE)then
	OGG_NEXT_GRIND_UPDATE = OGG_NEXT_GRIND_UPDATE + OGG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(OGG_NOW_GRINDING)then	
	    getglobal("OGG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(OGG_PREVIOUS_GRINDING_TIME + (GetTime()-OGG_GRINDING_STARTED_AT)));
	    getglobal("OGG_RepTodayVal"):SetText(FG_GREY..(OGG_PREVIOUS_REP_GROUND + (OGG_GetCurrentRepTotal() - OGG_INITIALREP)));
	    RepPerSecond = ((OGG_PREVIOUS_REP_GROUND + (OGG_GetCurrentRepTotal() - OGG_INITIALREP)) / 
                            math.max(math.floor(OGG_PREVIOUS_GRINDING_TIME + (GetTime()-OGG_GRINDING_STARTED_AT)),1));
	    getglobal("OGG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("OGG_TimeToRepUpTodayVal"):SetText(FG_GREY..OGG_TimeToRepUp(RepPerSecond));

	    getglobal("OGG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Ogri'la")+OGG_PREVIOUS_GRINDING_TIME + (GetTime()-OGG_GRINDING_STARTED_AT)));
	    getglobal("OGG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Ogri'la")+OGG_PREVIOUS_REP_GROUND + (OGG_GetCurrentRepTotal() - OGG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Ogri'la")+OGG_PREVIOUS_REP_GROUND + (OGG_GetCurrentRepTotal() - OGG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Ogri'la")+OGG_PREVIOUS_GRINDING_TIME + (GetTime()-OGG_GRINDING_STARTED_AT)),1));
	    getglobal("OGG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("OGG_TimeToRepUpTotalVal"):SetText(FG_GREY..OGG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("OGG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(OGG_PREVIOUS_GRINDING_TIME));
	    getglobal("OGG_RepTodayVal"):SetText(FG_GREY..(OGG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (OGG_PREVIOUS_REP_GROUND / math.max(OGG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("OGG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("OGG_TimeToRepUpTodayVal"):SetText(FG_GREY..OGG_TimeToRepUp(RepPerSecond));

	    getglobal("OGG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Ogri'la")+OGG_PREVIOUS_GRINDING_TIME));
	    getglobal("OGG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Ogri'la")+OGG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Ogri'la")+OGG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Ogri'la")+OGG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("OGG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("OGG_TimeToRepUpTotalVal"):SetText(FG_GREY..OGG_TimeToRepUp(RepPerSecond));
        end
    end
end

function OGG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, OGG_TEXT["Ogri'la Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-OGG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function OgrilaGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(OGG_TEXT[itemName]);
    end
end
