--NetherwingGrinder 1.0
--Written By Tiok - US Thrall

NWG_INITIALREP = 0;

NWG_NOW_GRINDING = false;
NWG_PREVIOUS_GRINDING_TIME = 0;
NWG_GRINDING_STARTED_AT = 0;
NWG_PREVIOUS_REP_GROUND = 0;

NWG_GRIND_UPDATE_INTERVAL = 1;
NWG_NEXT_GRIND_UPDATE = 0;

NWG_REP_VALUE = 0;

NWG_TEXT = 
{
    ["Netherwing Faction Name"] = "Netherwing";
    ["NW Rep"] = "NW Rep";

    ["Nethercite Ore"] = "Nethercite Ore";
    ["Netherdust Pollen"] = "Netherdust Pollen";
    ["Nethermine Flayer Hide"] = "Nethermine Flayer Hide";
    ["Netherwing Crystal"] = "Netherwing Crystal";
    ["Netherwing Egg"] = "Netherwing Egg";
    ["Netherwing Relic"] = "Netherwing Relic";
    ["Nethermine Cargo"] = "Nethermine Cargo";

    ["A Slow Death"] = "A Slow Death";
    ["Dragons are the Least of Our Problems"] = "Dragons are the Least of Our Problems";
    ["The Booterang: A Cure For The Common Worthless Peon"] = "The Booterang: A Cure For The Common Worthless Peon";
    ["The Booterang"] = "The Booterang";
    ["Disrupting the Twilight Portal"] = "Disrupting the Twilight Portal";
    ["The Deadliest Trap Ever Laid"] = "The Deadliest Trap Ever Laid";

    ["Camps Poisoned"] = "Camps Poisoned";
    ["Nethermine Flayers Slain"] = "Nethermine Flayers Slain";
    ["Nethermine Ravagers Slain"] = "Nethermine Ravagers Slain";
    ["Dragonmaw Peon Disciplined"] = "Dragonmaw Peon Disciplined";
    ["Deathshadow Agents Slain"] = "Deathshadow Agents Slain";
    ["Dragonmaw Forces Defeated"] = "Dragonmaw Forces Defeated";
}

function InstallNetherwingGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["NetherwingGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["NetherwingGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["NetherwingGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["NetherwingGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["NetherwingGrinder"] = "NWG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_NetherwingLabel");
    FG_NetherwingLabel:SetFontObject("GameFontNormalSmall");
    FG_NetherwingLabel:SetText("Netherwing");
    FG_NetherwingLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("NetherwingTexture");
    NetherwingTexture:SetTexture("Interface\\Icons\\Ability_Mount_NetherdrakePurple");
    NetherwingTexture:SetWidth(24);
    NetherwingTexture:SetHeight(24);
    NetherwingTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    NetherwingTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_NetherwingGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_NetherwingGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

ASlowDeathIndex = -1;
BooterangIndex = -1;
DragonsAreIndex = -1;
TwilightPortalIndex = -1;
DeadliestTrapIndex = -1;

function NetherwingGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("QUEST_LOG_UPDATE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function NetherwingGrinder_Init()
    NWG_NEXT_GRIND_UPDATE = GetTime()+NWG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("NetherwingGrinder","Nethercite Ore","32464","white");
    GrinderCore_RegisterItem("NetherwingGrinder","Netherdust Pollen","32468","white");
    GrinderCore_RegisterItem("NetherwingGrinder","Nethermine Flayer Hide","32470","white");
    GrinderCore_RegisterItem("NetherwingGrinder","Netherwing Crystal","32427","white");
    GrinderCore_RegisterItem("NetherwingGrinder","Netherwing Egg","32506","green");
    GrinderCore_RegisterItem("NetherwingGrinder","Netherwing Relic","32509","white");
    GrinderCore_RegisterItem("NetherwingGrinder","Nethermine Cargo","32723","white");

    NetherwingGrinder_UpdateDisplayData();
    NetherwingGrinder_UpdateRepBars();
end

function NetherwingGrinder_UpdateDisplayData()
    local repValue = 0;

    local textColor, itemName, itemCount;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, NWG_TEXT["Netherwing Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 1;
	earnedValue = -42000;
    end

    itemName = "Nethercite Ore";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/40)*250;
    end
    if(itemCount >= 40)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NetherciteOreCount"):SetText(itemCount.."/40");

    itemName = "Netherdust Pollen";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/40)*250;
    end
    if(itemCount >= 40)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NetherdustPollenCount"):SetText(itemCount.."/40");

    itemName = "Nethermine Flayer Hide";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/40)*250;
    end
    if(itemCount >= 40)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NethermineFlayerHideCount"):SetText(itemCount.."/40");

    itemName = "Netherwing Crystal";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/40)*250;
    end
    if(itemCount >= 40)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NetherwingCrystalCount"):SetText(itemCount.."/40");

    itemName = "Netherwing Egg";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/1)*250;
    end
    if(itemCount >= 1)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NetherwingEggCount"):SetText(itemCount.."/1");

    itemName = "Netherwing Relic";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + math.floor(itemCount/10)*250;
    end
    if(itemCount >= 10)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NetherwingRelicCount"):SetText(itemCount.."/10");

    itemName = "Nethermine Cargo";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + math.floor(itemCount/15)*350;
    end
    if(itemCount >= 15)then
	itemCount = FG_WHITE..itemCount;
    else
	itemCount = FG_GREY..itemCount;
    end
    getglobal("NWG_NethermineCargoCount"):SetText(itemCount.."/15");


    --Now check if the quests are in the log.  Display accordingly.
    ASlowDeathIndex = -1;
    BooterangIndex = -1;
    DragonsAreIndex = -1;
    TwilightPortalIndex = -1;
    DeadliestTrapIndex = -1;

    for qi=1,GetNumQuestLogEntries(),1 do
	if(GetQuestLogTitle(qi) == NWG_TEXT["A Slow Death"])then
	    ASlowDeathIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/12)");
	    if(count=="12/12")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_ASlowDeathObjective"):SetText(desc..NWG_TEXT["Camps Poisoned"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 250;
	    end
	elseif(GetQuestLogTitle(qi) == NWG_TEXT["Dragons are the Least of Our Problems"])then
	    DragonsAreIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/15)");
	    if(count=="15/15")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_DragonsAreObjective1"):SetText(desc..NWG_TEXT["Nethermine Flayers Slain"].." : "..count);

	    local desc,_,o2done = GetQuestLogLeaderBoard(2,qi);
	    _,_,count = string.find(desc,"(%d*/5)");
	    if(count=="5/5")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_DragonsAreObjective2"):SetText(desc..NWG_TEXT["Nethermine Ravagers Slain"].." : "..count);

	    if(o1done==1)and(o2done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == NWG_TEXT["The Booterang: A Cure For The Common Worthless Peon"])then
	    BooterangIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/20)");
	    if(count=="20/20")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_BooterangObjective"):SetText(desc..NWG_TEXT["Dragonmaw Peon Disciplined"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 350;
	    end
	elseif(GetQuestLogTitle(qi) == NWG_TEXT["Disrupting the Twilight Portal"])then
	    TwilightPortalIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    local _,_,count = string.find(desc,"(%d*/20)");
	    if(count=="20/20")then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_TwilightPortalObjective"):SetText(desc..NWG_TEXT["Deathshadow Agents Slain"].." : "..count);

	    if(o1done==1)then
		repValue = repValue + 500;
	    end
	elseif(GetQuestLogTitle(qi) == NWG_TEXT["The Deadliest Trap Ever Laid"])then
	    DeadliestTrapIndex = qi;
	    local desc,_,o1done = GetQuestLogLeaderBoard(1,qi);
	    if(o1done==1)then desc = FG_WHITE; else desc = FG_GREY; end
	    getglobal("NWG_DeadliestTrapObjective"):SetText(desc..NWG_TEXT["Dragonmaw Forces Defeated"]);

	    if(o1done==1)then
		repValue = repValue + 500;
	    end
	end	
    end

    if(ASlowDeathIndex == -1)then
	getglobal("NWG_ASlowDeathObjective"):SetText(FG_GREY..NWG_TEXT["Camps Poisoned"].." : 0/12");
	getglobal("NWG_ASlowDeath"):SetText(FG_GREY..NWG_TEXT["A Slow Death"]);
    else
	getglobal("NWG_ASlowDeath"):SetText(FG_GOLD..NWG_TEXT["A Slow Death"]);
    end

    if(DragonsAreIndex == -1)then
	getglobal("NWG_DragonsAreObjective1"):SetText(FG_GREY..NWG_TEXT["Nethermine Flayers Slain"].." : 0/15");
	getglobal("NWG_DragonsAreObjective2"):SetText(FG_GREY..NWG_TEXT["Nethermine Ravagers Slain"].." : 0/5");
	getglobal("NWG_DragonsAre"):SetText(FG_GREY..NWG_TEXT["Dragons are the Least of Our Problems"]);
    else
	getglobal("NWG_DragonsAre"):SetText(FG_GOLD..NWG_TEXT["Dragons are the Least of Our Problems"]);
    end

    if(BooterangIndex == -1)then
	getglobal("NWG_BooterangObjective"):SetText(FG_GREY..NWG_TEXT["Dragonmaw Peon Disciplined"].." : 0/20");
	getglobal("NWG_Booterang"):SetText(FG_GREY..NWG_TEXT["The Booterang"]);
    else
	getglobal("NWG_Booterang"):SetText(FG_GOLD..NWG_TEXT["The Booterang"]);
    end

    if(TwilightPortalIndex == -1)then
	getglobal("NWG_TwilightPortalObjective"):SetText(FG_GREY..NWG_TEXT["Deathshadow Agents Slain"].." : 0/20");
	getglobal("NWG_TwilightPortal"):SetText(FG_GREY..NWG_TEXT["Disrupting the Twilight Portal"]);
    else
	getglobal("NWG_TwilightPortal"):SetText(FG_GOLD..NWG_TEXT["Disrupting the Twilight Portal"]);
    end

    if(DeadliestTrapIndex == -1)then
	getglobal("NWG_DeadliestTrapObjective"):SetText(FG_GREY..NWG_TEXT["Dragonmaw Forces Defeated"]);
	getglobal("NWG_DeadliestTrap"):SetText(FG_GREY..NWG_TEXT["The Deadliest Trap Ever Laid"]);
    else
	getglobal("NWG_DeadliestTrap"):SetText(FG_GOLD..NWG_TEXT["The Deadliest Trap Ever Laid"]);
    end

    if(UnitRace("player") == FG_TEXT["Human"])then
	repValue = repValue * 1.1;
    end

    getglobal("NWG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(NWG_REP_VALUE ~= repValue)then
        NWG_REP_VALUE = repValue;
	NetherwingGrinder_UpdateRepBars();
    end
end

function NetherwingGrinder_OnLoad()
    NetherwingGrinder_RegisterEvents();
end

function NetherwingGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        NetherwingGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	NetherwingGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	NetherwingGrinder_UpdateDisplayData();
	NetherwingGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	NetherwingGrinder_UpdateRepBars();
    elseif( event == "QUEST_LOG_UPDATE")then
	NetherwingGrinder_UpdateDisplayData();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Netherwing",GrinderCore_GetGrindingTime("Netherwing")+NWG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Netherwing",GrinderCore_GetRepGround("Netherwing")+NWG_PREVIOUS_REP_GROUND);
	if(NWG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Netherwing",GrinderCore_GetGrindingTime("Netherwing")+(GetTime()-NWG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Netherwing",GrinderCore_GetRepGround("Netherwing")+(NWG_GetCurrentRepTotal() - NWG_INITIALREP));
	end
    end
end

function NetherwingGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	NWG_TEXT = NWG_TEXT_DE;
	--Reconstruct Display frame
	getglobal("NetherwingGrinderDisplayFrame"):SetWidth(225);

	--Reconstruct Grind-Tracker frame
	getglobal("NetherwingGrinderGrindFrame"):SetWidth(215);
	getglobal("NWG_TimeTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("NWG_RepTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("NWG_RepPerHourTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("NWG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("NWG_TimeTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("NWG_RepTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("NWG_RepPerHourTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("NWG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	NWG_TEXT = NWG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("NWG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	NWG_TEXT = NWG_TEXT_ZHTW;

	getglobal("NWG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_NWRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("NWGToRepUpFrame"):SetWidth(90);
	getglobal("NWGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("NWG_SB_ActualRep"):SetWidth(80);
    	getglobal("NWG_SB_RepWithItems"):SetWidth(80);

	getglobal("NetherwingGrinderGrindFrame"):SetWidth(215);
	getglobal("NWG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("NWG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("NWG_TimeTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("NWG_RepTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("NWG_RepPerHourTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("NWG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("NWG_TimeTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("NWG_RepTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("NWG_RepPerHourTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("NWG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","NetherwingGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("NWG_NWRep"):SetText(NWG_TEXT["NW Rep"]);
    getglobal("NWG_ASlowDeath"):SetText(NWG_TEXT["A Slow Death"]);
    getglobal("NWG_DragonsAre"):SetText(NWG_TEXT["Dragons are the Least of Our Problems"]);
    getglobal("NWG_Booterang"):SetText(NWG_TEXT["The Booterang"]);
    getglobal("NWG_TwilightPortal"):SetText(NWG_TEXT["Disrupting the Twilight Portal"]);
    getglobal("NWG_DeadliestTrap"):SetText(NWG_TEXT["The Deadliest Trap Ever Laid"]);
    
    getglobal("NWG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("NWG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("NWG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("NWG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("NWG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("NWG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("NWG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("NWG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("NWG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("NWG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("NWG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("NWG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function NetherwingGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, NWG_TEXT["Netherwing Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 1;
	earnedValue = -42000;
    end

    if(standingId==8)then --Exalted
	getglobal("NWG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(NWG_REP_VALUE/42)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+NWG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(NWG_REP_VALUE/21)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+NWG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(NWG_REP_VALUE/12)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+NWG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(NWG_REP_VALUE/6)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+NWG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(NWG_REP_VALUE/3)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+NWG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(NWG_REP_VALUE/3)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+NWG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(NWG_REP_VALUE/3)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("NWG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("NWG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+NWG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(NWG_REP_VALUE/36)/10;
	getglobal("NWG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("NWG_RepPoints"):SetText((earnedValue+NWG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("NWG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function NetherwingGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, NWG_TEXT["Netherwing Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 1;
	topValue = -42000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-NWG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-NWG_REP_VALUE,0);
    end

    local twofifty = 250;
    local threefifty = 350;
    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twofifty = 275;
	threefifty = 385;
	fivehundred = 550;
    end

    local tooltip = getglobal("NWGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    if(text=="The Booterang")then
	tooltip:AddLine(NWG_TEXT["The Booterang: A Cure For The Common Worthless Peon"]);
    elseif(text=="Dragons Are")then
	tooltip:AddLine(NWG_TEXT["Dragons are the Least of Our Problems"]);
    elseif(text=="Twilight Portal")then
	tooltip:AddLine(NWG_TEXT["Disrupting the Twilight Portal"]);
    elseif(text=="Deadliest Trap")then
	tooltip:AddLine(NWG_TEXT["The Deadliest Trap Ever Laid"]);
    else
        tooltip:AddLine(GrinderCore_GetItemColor(text)..NWG_TEXT[text]);
    end

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Nethercite Ore")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."40 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/40 = "..(math.floor(itemCount/40)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Taskmaster Varkule Dragonbreath"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Netherdust Pollen")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."40 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/40 = "..(math.floor(itemCount/40)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Taskmaster Varkule Dragonbreath"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Nethermine Flayer Hide")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."40 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/40 = "..(math.floor(itemCount/40)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Taskmaster Varkule Dragonbreath"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Netherwing Crystal")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."40 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/40 = "..(math.floor(itemCount/40)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*40-(itemCount % 40))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Taskmaster Varkule Dragonbreath"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Netherwing Egg")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(math.floor(itemCount/1)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Yarzill the Merc"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="A Slow Death")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 4)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Yarzill the Merc"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Netherwing Relic")then
	reward = twofifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Yarzill the Merc"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Nethermine Cargo")then
	reward = threefifty;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."15 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/15 = "..(math.floor(itemCount/15)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*15-(itemCount % 15))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*15-(itemCount % 15))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mistress of the Mines"].." - "..FG_TEXT["Shadowmoon Valley"].." (63,87)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mistress of the Mines"].." - "..FG_TEXT["Shadowmoon Valley"].." (65,90)");
    elseif(text=="The Booterang")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 5)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Chief Overseer Mudlump"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,86)");
    elseif(text=="Dragons Are")then
	reward = threefifty;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 5)then
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Dragonmaw Foreman"].." - "..FG_TEXT["Shadowmoon Valley"].." (65,88)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Dragonmaw Foreman"].." - "..FG_TEXT["Shadowmoon Valley"].." (63,86)");
    elseif(text=="Twilight Portal")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 6)then
 	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["quests to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Honored or better"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Honored or better"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Overlord Mor'ghor"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,85)");
    elseif(text=="Deadliest Trap")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY..reward.." "..FG_TEXT["rep"]);
	if(standingId >= 7)then
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["quests to exalted"]); end
            tooltip:AddLine(" ");
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Revered"]);
	else
	    tooltip:AddLine(" ");
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Revered"]);
	end
	if(UnitLevel("player") >= 70)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 70");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 70");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Overlord Mor'ghor"].." - "..FG_TEXT["Shadowmoon Valley"].." (66,85)");
    end

    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function NetherwingGrinder_HideToolTip()
    getglobal("NWGToolTip"):Hide();
end

function NWG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, NWG_TEXT["Netherwing Faction Name"]))) then
	    return earnedValue + NWG_REP_VALUE;
	end
    end
    return NWG_REP_VALUE;
end

function NetherwingGrinder_ToggleGrinding()
    NWG_NOW_GRINDING = not NWG_NOW_GRINDING;

    local button = getglobal("NWG_BU_ToggleGrinding");
    if(NWG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("NWG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	NWG_GRINDING_STARTED_AT = GetTime();
	NWG_INITIALREP = NWG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("NWG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	NWG_PREVIOUS_GRINDING_TIME = NWG_PREVIOUS_GRINDING_TIME + (GetTime()-NWG_GRINDING_STARTED_AT);
	NWG_PREVIOUS_REP_GROUND = NWG_PREVIOUS_REP_GROUND + (NWG_GetCurrentRepTotal() - NWG_INITIALREP); 
    end
end

function NetherwingGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("NetherwingGrinder"))then	
	GrinderCore_AcknowledgeItemChange("NetherwingGrinder");
	NetherwingGrinder_UpdateDisplayData();
    end

    if(GetTime() > NWG_NEXT_GRIND_UPDATE)then
	NWG_NEXT_GRIND_UPDATE = NWG_NEXT_GRIND_UPDATE + NWG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(NWG_NOW_GRINDING)then	
	    getglobal("NWG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(NWG_PREVIOUS_GRINDING_TIME + (GetTime()-NWG_GRINDING_STARTED_AT)));
	    getglobal("NWG_RepTodayVal"):SetText(FG_GREY..(NWG_PREVIOUS_REP_GROUND + (NWG_GetCurrentRepTotal() - NWG_INITIALREP)));
	    RepPerSecond = ((NWG_PREVIOUS_REP_GROUND + (NWG_GetCurrentRepTotal() - NWG_INITIALREP)) / 
                            math.max(math.floor(NWG_PREVIOUS_GRINDING_TIME + (GetTime()-NWG_GRINDING_STARTED_AT)),1));
	    getglobal("NWG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("NWG_TimeToRepUpTodayVal"):SetText(FG_GREY..NWG_TimeToRepUp(RepPerSecond));

	    getglobal("NWG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Netherwing")+NWG_PREVIOUS_GRINDING_TIME + (GetTime()-NWG_GRINDING_STARTED_AT)));
	    getglobal("NWG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Netherwing")+NWG_PREVIOUS_REP_GROUND + (NWG_GetCurrentRepTotal() - NWG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Netherwing")+NWG_PREVIOUS_REP_GROUND + (NWG_GetCurrentRepTotal() - NWG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Netherwing")+NWG_PREVIOUS_GRINDING_TIME + (GetTime()-NWG_GRINDING_STARTED_AT)),1));
	    getglobal("NWG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("NWG_TimeToRepUpTotalVal"):SetText(FG_GREY..NWG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("NWG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(NWG_PREVIOUS_GRINDING_TIME));
	    getglobal("NWG_RepTodayVal"):SetText(FG_GREY..(NWG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (NWG_PREVIOUS_REP_GROUND / math.max(NWG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("NWG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("NWG_TimeToRepUpTodayVal"):SetText(FG_GREY..NWG_TimeToRepUp(RepPerSecond));

	    getglobal("NWG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Netherwing")+NWG_PREVIOUS_GRINDING_TIME));
	    getglobal("NWG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Netherwing")+NWG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Netherwing")+NWG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Netherwing")+NWG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("NWG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("NWG_TimeToRepUpTotalVal"):SetText(FG_GREY..NWG_TimeToRepUp(RepPerSecond));
        end
    end
end

function NWG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, NWG_TEXT["Netherwing Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 1;
	topValue = -42000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-NWG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function NetherwingGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(NWG_TEXT[itemName]);
    end
end
