--MagharGrinder 1.0
--Written By Tiok - US Thrall

MAG_INITIALREP = 0;

MAG_NOW_GRINDING = false;
MAG_PREVIOUS_GRINDING_TIME = 0;
MAG_GRINDING_STARTED_AT = 0;
MAG_PREVIOUS_REP_GROUND = 0;

MAG_GRIND_UPDATE_INTERVAL = 1;
MAG_NEXT_GRIND_UPDATE = 0;

MAG_REP_VALUE = 0;

MAG_TEXT = 
{
    ["Mag'har Faction Name"] = "Mag'har";
    ["Mh Rep"] = "Mh Rep";

    ["Obsidian Warbeads"] = "Obsidian Warbeads";
}

function InstallMagharGrinder()
    --Add this faction to the "Show" settings.
    --if (FactionGrinderSettings["Show"]["MagharGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["MagharGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["MagharGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["MagharGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["MagharGrinder"] = "MAG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_MagharLabel");
    FG_MagharLabel:SetFontObject("GameFontNormalSmall");
    FG_MagharLabel:SetText("Mag'har");
    FG_MagharLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("MagharTexture");
    MagharTexture:SetTexture("Interface\\Icons\\INV_Misc_Foot_Centaur");
    MagharTexture:SetWidth(24);
    MagharTexture:SetHeight(24);
    MagharTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    MagharTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    --local cb = CreateFrame("CheckButton","FG_CB_MagharGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    --cb:SetChecked(false);
    --cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_MagharGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function MagharGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function MagharGrinder_Init()
    MAG_NEXT_GRIND_UPDATE = GetTime()+MAG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("MagharGrinder","Obsidian Warbeads","25433","white");

    MagharGrinder_UpdateDisplayData();
    MagharGrinder_UpdateRepBars();
end

function MagharGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Obsidian Warbeads";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/10)*500);
    getglobal("MAG_ObsidianWarbeadsCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("MAG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(MAG_REP_VALUE ~= repValue)then
        MAG_REP_VALUE = repValue;
	MagharGrinder_UpdateRepBars();
    end
end

function MagharGrinder_OnLoad()
    MagharGrinder_RegisterEvents();
end

function MagharGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        MagharGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	MagharGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	MagharGrinder_UpdateDisplayData();
	MagharGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	MagharGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Mag'har",GrinderCore_GetGrindingTime("Mag'har")+MAG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Mag'har",GrinderCore_GetRepGround("Mag'har")+MAG_PREVIOUS_REP_GROUND);
	if(MAG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Mag'har",GrinderCore_GetGrindingTime("Mag'har")+(GetTime()-MAG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Mag'har",GrinderCore_GetRepGround("Mag'har")+(MAG_GetCurrentRepTotal() - MAG_INITIALREP));
	end
    end
end

function MagharGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	MAG_TEXT = MAG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("MagharGrinderGrindFrame"):SetWidth(215);
	getglobal("MAG_TimeTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("MAG_RepTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("MAG_RepPerHourTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("MAG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("MAG_TimeTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("MAG_RepTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("MAG_RepPerHourTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("MAG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	MAG_TEXT = MAG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("MAG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	MAG_TEXT = MAG_TEXT_ZHTW;

	getglobal("MAG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_MhRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("MAGToRepUpFrame"):SetWidth(90);
	getglobal("MAGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("MAG_SB_ActualRep"):SetWidth(80);
    	getglobal("MAG_SB_RepWithItems"):SetWidth(80);

	getglobal("MagharGrinderGrindFrame"):SetWidth(215);
	getglobal("MAG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("MAG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("MAG_TimeTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("MAG_RepTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("MAG_RepPerHourTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("MAG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("MAG_TimeTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("MAG_RepTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("MAG_RepPerHourTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("MAG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","MagharGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("MAG_MhRep"):SetText(MAG_TEXT["Mh Rep"]);
    
    getglobal("MAG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("MAG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("MAG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("MAG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("MAG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("MAG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("MAG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("MAG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("MAG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("MAG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("MAG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("MAG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function MagharGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, MAG_TEXT["Mag'har Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("MAG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(MAG_REP_VALUE/42)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+MAG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(MAG_REP_VALUE/21)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+MAG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(MAG_REP_VALUE/12)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+MAG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(MAG_REP_VALUE/6)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+MAG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(MAG_REP_VALUE/3)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+MAG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(MAG_REP_VALUE/3)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+MAG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(MAG_REP_VALUE/3)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("MAG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("MAG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+MAG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(MAG_REP_VALUE/36)/10;
	getglobal("MAG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("MAG_RepPoints"):SetText((earnedValue+MAG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("MAG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function MagharGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, MAG_TEXT["Mag'har Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-MAG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-MAG_REP_VALUE,0);
    end

    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	fivehundred = 550;
    end

    local tooltip = getglobal("MAGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..MAG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

    if(text=="Obsidian Warbeads")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 65)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 65");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 65");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Warden Bullrok"].." - "..FG_TEXT["Nagrand"].." (56,38)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function MagharGrinder_HideToolTip()
    getglobal("MAGToolTip"):Hide();
end

function MAG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, MAG_TEXT["Mag'har Faction Name"]))) then
	    return earnedValue + MAG_REP_VALUE;
	end
    end
    return MAG_REP_VALUE;
end

function MagharGrinder_ToggleGrinding()
    MAG_NOW_GRINDING = not MAG_NOW_GRINDING;

    local button = getglobal("MAG_BU_ToggleGrinding");
    if(MAG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("MAG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	MAG_GRINDING_STARTED_AT = GetTime();
	MAG_INITIALREP = MAG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("MAG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	MAG_PREVIOUS_GRINDING_TIME = MAG_PREVIOUS_GRINDING_TIME + (GetTime()-MAG_GRINDING_STARTED_AT);
	MAG_PREVIOUS_REP_GROUND = MAG_PREVIOUS_REP_GROUND + (MAG_GetCurrentRepTotal() - MAG_INITIALREP); 
    end
end

function MagharGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("MagharGrinder"))then	
	GrinderCore_AcknowledgeItemChange("MagharGrinder");
	MagharGrinder_UpdateDisplayData();
    end

    if(GetTime() > MAG_NEXT_GRIND_UPDATE)then
	MAG_NEXT_GRIND_UPDATE = MAG_NEXT_GRIND_UPDATE + MAG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(MAG_NOW_GRINDING)then	
	    getglobal("MAG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(MAG_PREVIOUS_GRINDING_TIME + (GetTime()-MAG_GRINDING_STARTED_AT)));
	    getglobal("MAG_RepTodayVal"):SetText(FG_GREY..(MAG_PREVIOUS_REP_GROUND + (MAG_GetCurrentRepTotal() - MAG_INITIALREP)));
	    RepPerSecond = ((MAG_PREVIOUS_REP_GROUND + (MAG_GetCurrentRepTotal() - MAG_INITIALREP)) / 
                            math.max(math.floor(MAG_PREVIOUS_GRINDING_TIME + (GetTime()-MAG_GRINDING_STARTED_AT)),1));
	    getglobal("MAG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("MAG_TimeToRepUpTodayVal"):SetText(FG_GREY..MAG_TimeToRepUp(RepPerSecond));

	    getglobal("MAG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Mag'har")+MAG_PREVIOUS_GRINDING_TIME + (GetTime()-MAG_GRINDING_STARTED_AT)));
	    getglobal("MAG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Mag'har")+MAG_PREVIOUS_REP_GROUND + (MAG_GetCurrentRepTotal() - MAG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Mag'har")+MAG_PREVIOUS_REP_GROUND + (MAG_GetCurrentRepTotal() - MAG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Mag'har")+MAG_PREVIOUS_GRINDING_TIME + (GetTime()-MAG_GRINDING_STARTED_AT)),1));
	    getglobal("MAG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("MAG_TimeToRepUpTotalVal"):SetText(FG_GREY..MAG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("MAG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(MAG_PREVIOUS_GRINDING_TIME));
	    getglobal("MAG_RepTodayVal"):SetText(FG_GREY..(MAG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (MAG_PREVIOUS_REP_GROUND / math.max(MAG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("MAG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("MAG_TimeToRepUpTodayVal"):SetText(FG_GREY..MAG_TimeToRepUp(RepPerSecond));

	    getglobal("MAG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Mag'har")+MAG_PREVIOUS_GRINDING_TIME));
	    getglobal("MAG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Mag'har")+MAG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Mag'har")+MAG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Mag'har")+MAG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("MAG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("MAG_TimeToRepUpTotalVal"):SetText(FG_GREY..MAG_TimeToRepUp(RepPerSecond));
        end
    end
end

function MAG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, MAG_TEXT["Mag'har Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-MAG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function MagharGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(MAG_TEXT[itemName]);
    end
end
