--LowerCityGrinder 1.0
--Written By Tiok - US Thrall

LCG_INITIALREP = 0;

LCG_NOW_GRINDING = false;
LCG_PREVIOUS_GRINDING_TIME = 0;
LCG_GRINDING_STARTED_AT = 0;
LCG_PREVIOUS_REP_GROUND = 0;

LCG_GRIND_UPDATE_INTERVAL = 1;
LCG_NEXT_GRIND_UPDATE = 0;

LCG_REP_VALUE = 0;

LCG_TEXT = 
{
    ["Lower City Faction Name"] = "Lower City";
    ["LC Rep"] = "LC Rep";

    ["Arakkoa Feather"] = "Arakkoa Feather";
}

function InstallLowerCityGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["LowerCityGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["LowerCityGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["LowerCityGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["LowerCityGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["LowerCityGrinder"] = "LCG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_LowerCityLabel");
    FG_LowerCityLabel:SetFontObject("GameFontNormalSmall");
    FG_LowerCityLabel:SetText("Lower City");
    FG_LowerCityLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("LowerCityTexture");
    LowerCityTexture:SetTexture("Interface\\Icons\\INV_Feather_06");
    LowerCityTexture:SetWidth(24);
    LowerCityTexture:SetHeight(24);
    LowerCityTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    LowerCityTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_LowerCityGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_LowerCityGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function LowerCityGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function LowerCityGrinder_Init()
    LCG_NEXT_GRIND_UPDATE = GetTime()+LCG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("LowerCityGrinder","Arakkoa Feather","25719","white");

    LowerCityGrinder_UpdateDisplayData();
    LowerCityGrinder_UpdateRepBars();
end

function LowerCityGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Arakkoa Feather";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*250);
    getglobal("LCG_ArakkoaFeatherCount"):SetText(itemCount.."/30");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("LCG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(LCG_REP_VALUE ~= repValue)then
        LCG_REP_VALUE = repValue;
	LowerCityGrinder_UpdateRepBars();
    end
end

function LowerCityGrinder_OnLoad()
    LowerCityGrinder_RegisterEvents();
end

function LowerCityGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        LowerCityGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	LowerCityGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	LowerCityGrinder_UpdateDisplayData();
	LowerCityGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	LowerCityGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Lower City",GrinderCore_GetGrindingTime("Lower City")+LCG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Lower City",GrinderCore_GetRepGround("Lower City")+LCG_PREVIOUS_REP_GROUND);
	if(LCG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Lower City",GrinderCore_GetGrindingTime("Lower City")+(GetTime()-LCG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Lower City",GrinderCore_GetRepGround("Lower City")+(LCG_GetCurrentRepTotal() - LCG_INITIALREP));
	end
    end
end

function LowerCityGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	LCG_TEXT = LCG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("LowerCityGrinderGrindFrame"):SetWidth(215);
	getglobal("LCG_TimeTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("LCG_RepTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("LCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("LCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("LCG_TimeTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("LCG_RepTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("LCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("LCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	LCG_TEXT = LCG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("LCG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	LCG_TEXT = LCG_TEXT_ZHTW;

	getglobal("LCG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_LCRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("LCGToRepUpFrame"):SetWidth(90);
	getglobal("LCGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("LCG_SB_ActualRep"):SetWidth(80);
    	getglobal("LCG_SB_RepWithItems"):SetWidth(80);

	getglobal("LowerCityGrinderGrindFrame"):SetWidth(215);
	getglobal("LCG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("LCG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("LCG_TimeTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("LCG_RepTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("LCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("LCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("LCG_TimeTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("LCG_RepTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("LCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("LCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","LowerCityGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("LCG_LCRep"):SetText(LCG_TEXT["LC Rep"]);
    
    getglobal("LCG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("LCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("LCG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("LCG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("LCG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("LCG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("LCG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("LCG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("LCG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("LCG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("LCG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("LCG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function LowerCityGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, LCG_TEXT["Lower City Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("LCG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(LCG_REP_VALUE/42)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+LCG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(LCG_REP_VALUE/21)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+LCG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(LCG_REP_VALUE/12)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+LCG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(LCG_REP_VALUE/6)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+LCG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(LCG_REP_VALUE/3)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+LCG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(LCG_REP_VALUE/3)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+LCG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(LCG_REP_VALUE/3)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("LCG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("LCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+LCG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(LCG_REP_VALUE/36)/10;
	getglobal("LCG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("LCG_RepPoints"):SetText((earnedValue+LCG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("LCG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function LowerCityGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, LCG_TEXT["Lower City Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-LCG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-LCG_REP_VALUE,0);
    end

    local twofifty = 250;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twofifty = 275;
    end

    local tooltip = getglobal("LCGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..LCG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

    if(text=="Arakkoa Feather")then
	reward = twofifty;
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]);
	tooltip:AddLine(" ");
	if(standingId == 4)or(standingId == 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	end
        if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Vekax"].." - "..FG_TEXT["Shattrath City"].." (52,18)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function LowerCityGrinder_HideToolTip()
    getglobal("LCGToolTip"):Hide();
end

function LCG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, LCG_TEXT["Lower City Faction Name"]))) then
	    return earnedValue + LCG_REP_VALUE;
	end
    end
    return LCG_REP_VALUE;
end

function LowerCityGrinder_ToggleGrinding()
    LCG_NOW_GRINDING = not LCG_NOW_GRINDING;

    local button = getglobal("LCG_BU_ToggleGrinding");
    if(LCG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("LCG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	LCG_GRINDING_STARTED_AT = GetTime();
	LCG_INITIALREP = LCG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("LCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	LCG_PREVIOUS_GRINDING_TIME = LCG_PREVIOUS_GRINDING_TIME + (GetTime()-LCG_GRINDING_STARTED_AT);
	LCG_PREVIOUS_REP_GROUND = LCG_PREVIOUS_REP_GROUND + (LCG_GetCurrentRepTotal() - LCG_INITIALREP); 
    end
end

function LowerCityGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("LowerCityGrinder"))then	
	GrinderCore_AcknowledgeItemChange("LowerCityGrinder");
	LowerCityGrinder_UpdateDisplayData();
    end

    if(GetTime() > LCG_NEXT_GRIND_UPDATE)then
	LCG_NEXT_GRIND_UPDATE = LCG_NEXT_GRIND_UPDATE + LCG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(LCG_NOW_GRINDING)then	
	    getglobal("LCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(LCG_PREVIOUS_GRINDING_TIME + (GetTime()-LCG_GRINDING_STARTED_AT)));
	    getglobal("LCG_RepTodayVal"):SetText(FG_GREY..(LCG_PREVIOUS_REP_GROUND + (LCG_GetCurrentRepTotal() - LCG_INITIALREP)));
	    RepPerSecond = ((LCG_PREVIOUS_REP_GROUND + (LCG_GetCurrentRepTotal() - LCG_INITIALREP)) / 
                            math.max(math.floor(LCG_PREVIOUS_GRINDING_TIME + (GetTime()-LCG_GRINDING_STARTED_AT)),1));
	    getglobal("LCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("LCG_TimeToRepUpTodayVal"):SetText(FG_GREY..LCG_TimeToRepUp(RepPerSecond));

	    getglobal("LCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Lower City")+LCG_PREVIOUS_GRINDING_TIME + (GetTime()-LCG_GRINDING_STARTED_AT)));
	    getglobal("LCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Lower City")+LCG_PREVIOUS_REP_GROUND + (LCG_GetCurrentRepTotal() - LCG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Lower City")+LCG_PREVIOUS_REP_GROUND + (LCG_GetCurrentRepTotal() - LCG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Lower City")+LCG_PREVIOUS_GRINDING_TIME + (GetTime()-LCG_GRINDING_STARTED_AT)),1));
	    getglobal("LCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("LCG_TimeToRepUpTotalVal"):SetText(FG_GREY..LCG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("LCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(LCG_PREVIOUS_GRINDING_TIME));
	    getglobal("LCG_RepTodayVal"):SetText(FG_GREY..(LCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (LCG_PREVIOUS_REP_GROUND / math.max(LCG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("LCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("LCG_TimeToRepUpTodayVal"):SetText(FG_GREY..LCG_TimeToRepUp(RepPerSecond));

	    getglobal("LCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Lower City")+LCG_PREVIOUS_GRINDING_TIME));
	    getglobal("LCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Lower City")+LCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Lower City")+LCG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Lower City")+LCG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("LCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("LCG_TimeToRepUpTotalVal"):SetText(FG_GREY..LCG_TimeToRepUp(RepPerSecond));
        end
    end
end

function LCG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, LCG_TEXT["Lower City Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-LCG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function LowerCityGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(LCG_TEXT[itemName]);
    end
end
