--KurenaiGrinder 1.0
--Written By Tiok - US Thrall

KUG_INITIALREP = 0;

KUG_NOW_GRINDING = false;
KUG_PREVIOUS_GRINDING_TIME = 0;
KUG_GRINDING_STARTED_AT = 0;
KUG_PREVIOUS_REP_GROUND = 0;

KUG_GRIND_UPDATE_INTERVAL = 1;
KUG_NEXT_GRIND_UPDATE = 0;

KUG_REP_VALUE = 0;

KUG_TEXT = 
{
    ["Kurenai Faction Name"] = "Kurenai";
    ["Ku Rep"] = "Ku Rep";

    ["Obsidian Warbeads"] = "Obsidian Warbeads";
}

function InstallKurenaiGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["KurenaiGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["KurenaiGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["KurenaiGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["KurenaiGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["KurenaiGrinder"] = "KUG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_KurenaiLabel");
    FG_KurenaiLabel:SetFontObject("GameFontNormalSmall");
    FG_KurenaiLabel:SetText("Kurenai");
    FG_KurenaiLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("KurenaiTexture");
    KurenaiTexture:SetTexture("Interface\\Icons\\INV_Misc_Foot_Centaur");
    KurenaiTexture:SetWidth(24);
    KurenaiTexture:SetHeight(24);
    KurenaiTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    KurenaiTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_KurenaiGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_KurenaiGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function KurenaiGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function KurenaiGrinder_Init()
    KUG_NEXT_GRIND_UPDATE = GetTime()+KUG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("KurenaiGrinder","Obsidian Warbeads","25433","white");

    KurenaiGrinder_UpdateDisplayData();
    KurenaiGrinder_UpdateRepBars();
end

function KurenaiGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Obsidian Warbeads";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/10)*500);
    getglobal("KUG_ObsidianWarbeadsCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("KUG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(KUG_REP_VALUE ~= repValue)then
        KUG_REP_VALUE = repValue;
	KurenaiGrinder_UpdateRepBars();
    end
end

function KurenaiGrinder_OnLoad()
    KurenaiGrinder_RegisterEvents();
end

function KurenaiGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        KurenaiGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	KurenaiGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	KurenaiGrinder_UpdateDisplayData();
	KurenaiGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	KurenaiGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Kurenai",GrinderCore_GetGrindingTime("Kurenai")+KUG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Kurenai",GrinderCore_GetRepGround("Kurenai")+KUG_PREVIOUS_REP_GROUND);
	if(KUG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Kurenai",GrinderCore_GetGrindingTime("Kurenai")+(GetTime()-KUG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Kurenai",GrinderCore_GetRepGround("Kurenai")+(KUG_GetCurrentRepTotal() - KUG_INITIALREP));
	end
    end
end

function KurenaiGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	KUG_TEXT = KUG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("KurenaiGrinderGrindFrame"):SetWidth(215);
	getglobal("KUG_TimeTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("KUG_RepTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("KUG_RepPerHourTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("KUG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("KUG_TimeTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("KUG_RepTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("KUG_RepPerHourTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("KUG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	KUG_TEXT = KUG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("KUG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	KUG_TEXT = KUG_TEXT_ZHTW;

	getglobal("KUG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_KuRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("KUGToRepUpFrame"):SetWidth(90);
	getglobal("KUGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("KUG_SB_ActualRep"):SetWidth(80);
    	getglobal("KUG_SB_RepWithItems"):SetWidth(80);

	getglobal("KurenaiGrinderGrindFrame"):SetWidth(215);
	getglobal("KUG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("KUG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("KUG_TimeTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("KUG_RepTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("KUG_RepPerHourTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("KUG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("KUG_TimeTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("KUG_RepTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("KUG_RepPerHourTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("KUG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","KurenaiGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("KUG_KuRep"):SetText(KUG_TEXT["Ku Rep"]);
    
    getglobal("KUG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("KUG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("KUG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("KUG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("KUG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("KUG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("KUG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("KUG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("KUG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("KUG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("KUG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("KUG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function KurenaiGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, KUG_TEXT["Kurenai Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("KUG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(KUG_REP_VALUE/42)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+KUG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(KUG_REP_VALUE/21)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+KUG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(KUG_REP_VALUE/12)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+KUG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(KUG_REP_VALUE/6)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+KUG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(KUG_REP_VALUE/3)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+KUG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(KUG_REP_VALUE/3)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+KUG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(KUG_REP_VALUE/3)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("KUG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("KUG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+KUG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(KUG_REP_VALUE/36)/10;
	getglobal("KUG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("KUG_RepPoints"):SetText((earnedValue+KUG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("KUG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function KurenaiGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, KUG_TEXT["Kurenai Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-KUG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-KUG_REP_VALUE,0);
    end

    local fivehundred = 500;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	fivehundred = 550;
    end

    local tooltip = getglobal("KUGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..KUG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

    if(text=="Obsidian Warbeads")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 65)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 65");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 65");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Warden Iolol"].." - "..FG_TEXT["Nagrand"].." (55,71)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function KurenaiGrinder_HideToolTip()
    getglobal("KUGToolTip"):Hide();
end

function KUG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, KUG_TEXT["Kurenai Faction Name"]))) then
	    return earnedValue + KUG_REP_VALUE;
	end
    end
    return KUG_REP_VALUE;
end

function KurenaiGrinder_ToggleGrinding()
    KUG_NOW_GRINDING = not KUG_NOW_GRINDING;

    local button = getglobal("KUG_BU_ToggleGrinding");
    if(KUG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("KUG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	KUG_GRINDING_STARTED_AT = GetTime();
	KUG_INITIALREP = KUG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("KUG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	KUG_PREVIOUS_GRINDING_TIME = KUG_PREVIOUS_GRINDING_TIME + (GetTime()-KUG_GRINDING_STARTED_AT);
	KUG_PREVIOUS_REP_GROUND = KUG_PREVIOUS_REP_GROUND + (KUG_GetCurrentRepTotal() - KUG_INITIALREP); 
    end
end

function KurenaiGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("KurenaiGrinder"))then	
	GrinderCore_AcknowledgeItemChange("KurenaiGrinder");
	KurenaiGrinder_UpdateDisplayData();
    end

    if(GetTime() > KUG_NEXT_GRIND_UPDATE)then
	KUG_NEXT_GRIND_UPDATE = KUG_NEXT_GRIND_UPDATE + KUG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(KUG_NOW_GRINDING)then	
	    getglobal("KUG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(KUG_PREVIOUS_GRINDING_TIME + (GetTime()-KUG_GRINDING_STARTED_AT)));
	    getglobal("KUG_RepTodayVal"):SetText(FG_GREY..(KUG_PREVIOUS_REP_GROUND + (KUG_GetCurrentRepTotal() - KUG_INITIALREP)));
	    RepPerSecond = ((KUG_PREVIOUS_REP_GROUND + (KUG_GetCurrentRepTotal() - KUG_INITIALREP)) / 
                            math.max(math.floor(KUG_PREVIOUS_GRINDING_TIME + (GetTime()-KUG_GRINDING_STARTED_AT)),1));
	    getglobal("KUG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("KUG_TimeToRepUpTodayVal"):SetText(FG_GREY..KUG_TimeToRepUp(RepPerSecond));

	    getglobal("KUG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Kurenai")+KUG_PREVIOUS_GRINDING_TIME + (GetTime()-KUG_GRINDING_STARTED_AT)));
	    getglobal("KUG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Kurenai")+KUG_PREVIOUS_REP_GROUND + (KUG_GetCurrentRepTotal() - KUG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Kurenai")+KUG_PREVIOUS_REP_GROUND + (KUG_GetCurrentRepTotal() - KUG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Kurenai")+KUG_PREVIOUS_GRINDING_TIME + (GetTime()-KUG_GRINDING_STARTED_AT)),1));
	    getglobal("KUG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("KUG_TimeToRepUpTotalVal"):SetText(FG_GREY..KUG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("KUG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(KUG_PREVIOUS_GRINDING_TIME));
	    getglobal("KUG_RepTodayVal"):SetText(FG_GREY..(KUG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (KUG_PREVIOUS_REP_GROUND / math.max(KUG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("KUG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("KUG_TimeToRepUpTodayVal"):SetText(FG_GREY..KUG_TimeToRepUp(RepPerSecond));

	    getglobal("KUG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Kurenai")+KUG_PREVIOUS_GRINDING_TIME));
	    getglobal("KUG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Kurenai")+KUG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Kurenai")+KUG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Kurenai")+KUG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("KUG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("KUG_TimeToRepUpTotalVal"):SetText(FG_GREY..KUG_TimeToRepUp(RepPerSecond));
        end
    end
end

function KUG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, KUG_TEXT["Kurenai Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-KUG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function KurenaiGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(KUG_TEXT[itemName]);
    end
end
