--IronforgeGrinder 1.0
--Written By Tiok - US Thrall

IFG_INITIALREP = 0;

IFG_NOW_GRINDING = false;
IFG_PREVIOUS_GRINDING_TIME = 0;
IFG_GRINDING_STARTED_AT = 0;
IFG_PREVIOUS_REP_GROUND = 0;

IFG_GRIND_UPDATE_INTERVAL = 1;
IFG_NEXT_GRIND_UPDATE = 0;

IFG_REP_VALUE = 0;

IFG_TEXT = 
{
    ["Ironforge Faction Name"] = "Ironforge";
    ["IF Rep"] = "IF Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallIronforgeGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["IronforgeGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["IronforgeGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["IronforgeGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["IronforgeGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["IronforgeGrinder"] = "IFG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_IronforgeLabel");
    FG_IronforgeLabel:SetFontObject("GameFontNormalSmall");
    FG_IronforgeLabel:SetText("Ironforge");
    FG_IronforgeLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("IronforgeTexture");
    IronforgeTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Dwarf_02");
    IronforgeTexture:SetWidth(24);
    IronforgeTexture:SetHeight(24);
    IronforgeTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    IronforgeTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_IronforgeGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_IronforgeGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function IronforgeGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function IronforgeGrinder_Init()
    IFG_NEXT_GRIND_UPDATE = GetTime()+IFG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("IronforgeGrinder","Runecloth","14047","white");

    IronforgeGrinder_UpdateDisplayData();
    IronforgeGrinder_UpdateRepBars();
end

function IronforgeGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("IFG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("IFG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(IFG_REP_VALUE ~= repValue)then
        IFG_REP_VALUE = repValue;
	IronforgeGrinder_UpdateRepBars();
    end
end

function IronforgeGrinder_OnLoad()
    IronforgeGrinder_RegisterEvents();
end

function IronforgeGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        IronforgeGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	IronforgeGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	IronforgeGrinder_UpdateDisplayData();
	IronforgeGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	IronforgeGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Ironforge",GrinderCore_GetGrindingTime("Ironforge")+IFG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Ironforge",GrinderCore_GetRepGround("Ironforge")+IFG_PREVIOUS_REP_GROUND);
	if(IFG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Ironforge",GrinderCore_GetGrindingTime("Ironforge")+(GetTime()-IFG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Ironforge",GrinderCore_GetRepGround("Ironforge")+(IFG_GetCurrentRepTotal() - IFG_INITIALREP));
	end
    end
end

function IronforgeGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	IFG_TEXT = IFG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("IronforgeGrinderGrindFrame"):SetWidth(215);
	getglobal("IFG_TimeTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("IFG_RepTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("IFG_RepPerHourTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("IFG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("IFG_TimeTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("IFG_RepTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("IFG_RepPerHourTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("IFG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	IFG_TEXT = IFG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("IFG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	IFG_TEXT = IFG_TEXT_ZHTW;

	getglobal("IFG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_IFRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("IFGToRepUpFrame"):SetWidth(90);
	getglobal("IFGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("IFG_SB_ActualRep"):SetWidth(80);
    	getglobal("IFG_SB_RepWithItems"):SetWidth(80);

	getglobal("IronforgeGrinderGrindFrame"):SetWidth(215);
	getglobal("IFG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("IFG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("IFG_TimeTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("IFG_RepTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("IFG_RepPerHourTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("IFG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("IFG_TimeTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("IFG_RepTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("IFG_RepPerHourTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("IFG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","IronforgeGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("IFG_IFRep"):SetText(IFG_TEXT["IF Rep"]);
    
    getglobal("IFG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("IFG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("IFG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("IFG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("IFG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("IFG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("IFG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("IFG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("IFG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("IFG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("IFG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("IFG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function IronforgeGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, IFG_TEXT["Ironforge Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("IFG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(IFG_REP_VALUE/42)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+IFG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(IFG_REP_VALUE/21)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+IFG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(IFG_REP_VALUE/12)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+IFG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(IFG_REP_VALUE/6)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+IFG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(IFG_REP_VALUE/3)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+IFG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(IFG_REP_VALUE/3)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+IFG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(IFG_REP_VALUE/3)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("IFG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("IFG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+IFG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(IFG_REP_VALUE/36)/10;
	getglobal("IFG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("IFG_RepPoints"):SetText((earnedValue+IFG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("IFG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function IronforgeGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, IFG_TEXT["Ironforge Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-IFG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-IFG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("IFGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..IFG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mistina Steelshield"].." - "..FG_TEXT["Ironforge"].." (43,31)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function IronforgeGrinder_HideToolTip()
    getglobal("IFGToolTip"):Hide();
end

function IFG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, IFG_TEXT["Ironforge Faction Name"]))) then
	    return earnedValue + IFG_REP_VALUE;
	end
    end
    return IFG_REP_VALUE;
end

function IronforgeGrinder_ToggleGrinding()
    IFG_NOW_GRINDING = not IFG_NOW_GRINDING;

    local button = getglobal("IFG_BU_ToggleGrinding");
    if(IFG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("IFG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	IFG_GRINDING_STARTED_AT = GetTime();
	IFG_INITIALREP = IFG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("IFG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	IFG_PREVIOUS_GRINDING_TIME = IFG_PREVIOUS_GRINDING_TIME + (GetTime()-IFG_GRINDING_STARTED_AT);
	IFG_PREVIOUS_REP_GROUND = IFG_PREVIOUS_REP_GROUND + (IFG_GetCurrentRepTotal() - IFG_INITIALREP); 
    end
end

function IronforgeGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("IronforgeGrinder"))then	
	GrinderCore_AcknowledgeItemChange("IronforgeGrinder");
	IronforgeGrinder_UpdateDisplayData();
    end

    if(GetTime() > IFG_NEXT_GRIND_UPDATE)then
	IFG_NEXT_GRIND_UPDATE = IFG_NEXT_GRIND_UPDATE + IFG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(IFG_NOW_GRINDING)then	
	    getglobal("IFG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(IFG_PREVIOUS_GRINDING_TIME + (GetTime()-IFG_GRINDING_STARTED_AT)));
	    getglobal("IFG_RepTodayVal"):SetText(FG_GREY..(IFG_PREVIOUS_REP_GROUND + (IFG_GetCurrentRepTotal() - IFG_INITIALREP)));
	    RepPerSecond = ((IFG_PREVIOUS_REP_GROUND + (IFG_GetCurrentRepTotal() - IFG_INITIALREP)) / 
                            math.max(math.floor(IFG_PREVIOUS_GRINDING_TIME + (GetTime()-IFG_GRINDING_STARTED_AT)),1));
	    getglobal("IFG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("IFG_TimeToRepUpTodayVal"):SetText(FG_GREY..IFG_TimeToRepUp(RepPerSecond));

	    getglobal("IFG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Ironforge")+IFG_PREVIOUS_GRINDING_TIME + (GetTime()-IFG_GRINDING_STARTED_AT)));
	    getglobal("IFG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Ironforge")+IFG_PREVIOUS_REP_GROUND + (IFG_GetCurrentRepTotal() - IFG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Ironforge")+IFG_PREVIOUS_REP_GROUND + (IFG_GetCurrentRepTotal() - IFG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Ironforge")+IFG_PREVIOUS_GRINDING_TIME + (GetTime()-IFG_GRINDING_STARTED_AT)),1));
	    getglobal("IFG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("IFG_TimeToRepUpTotalVal"):SetText(FG_GREY..IFG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("IFG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(IFG_PREVIOUS_GRINDING_TIME));
	    getglobal("IFG_RepTodayVal"):SetText(FG_GREY..(IFG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (IFG_PREVIOUS_REP_GROUND / math.max(IFG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("IFG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("IFG_TimeToRepUpTodayVal"):SetText(FG_GREY..IFG_TimeToRepUp(RepPerSecond));

	    getglobal("IFG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Ironforge")+IFG_PREVIOUS_GRINDING_TIME));
	    getglobal("IFG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Ironforge")+IFG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Ironforge")+IFG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Ironforge")+IFG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("IFG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("IFG_TimeToRepUpTotalVal"):SetText(FG_GREY..IFG_TimeToRepUp(RepPerSecond));
        end
    end
end

function IFG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, IFG_TEXT["Ironforge Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-IFG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function IronforgeGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(IFG_TEXT[itemName]);
    end
end
