--HonorHoldGrinder 1.0
--Written By Tiok - US Thrall

HHG_INITIALREP = 0;

HHG_NOW_GRINDING = false;
HHG_PREVIOUS_GRINDING_TIME = 0;
HHG_GRINDING_STARTED_AT = 0;
HHG_PREVIOUS_REP_GROUND = 0;

HHG_GRIND_UPDATE_INTERVAL = 1;
HHG_NEXT_GRIND_UPDATE = 0;

HHG_REP_VALUE = 0;

HHG_TEXT = 
{
    ["Honor Hold Faction Name"] = "Honor Hold";
    ["HH Rep"] = "HH Rep";
}

function InstallHonorHoldGrinder()
    --Add this faction to the "Show" settings.
    --if (FactionGrinderSettings["Show"]["HonorHoldGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["HonorHoldGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["HonorHoldGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["HonorHoldGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["HonorHoldGrinder"] = "HHG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_HonorHoldLabel");
    FG_HonorHoldLabel:SetFontObject("GameFontNormalSmall");
    FG_HonorHoldLabel:SetText("Honor Hold");
    FG_HonorHoldLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("HonorHoldTexture");
    HonorHoldTexture:SetTexture("Interface\\Icons\\INV_Misc_Token_HonorHold");
    HonorHoldTexture:SetWidth(24);
    HonorHoldTexture:SetHeight(24);
    HonorHoldTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    HonorHoldTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    --local cb = CreateFrame("CheckButton","FG_CB_HonorHoldGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    --cb:SetChecked(false);
    --cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_HonorHoldGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function HonorHoldGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function HonorHoldGrinder_Init()
    HHG_NEXT_GRIND_UPDATE = GetTime()+HHG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here
    
    --If any, Item Registrations would occur here.

    HonorHoldGrinder_UpdateDisplayData();
    HonorHoldGrinder_UpdateRepBars();
end

function HonorHoldGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    --If any, calculations of reputation based on items would occur here.

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("HHG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(HHG_REP_VALUE ~= repValue)then
        HHG_REP_VALUE = repValue;
	HonorHoldGrinder_UpdateRepBars();
    end
end

function HonorHoldGrinder_OnLoad()
    HonorHoldGrinder_RegisterEvents();
end

function HonorHoldGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        HonorHoldGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	HonorHoldGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	HonorHoldGrinder_UpdateDisplayData();
	HonorHoldGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	HonorHoldGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Honor Hold",GrinderCore_GetGrindingTime("Honor Hold")+HHG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Honor Hold",GrinderCore_GetRepGround("Honor Hold")+HHG_PREVIOUS_REP_GROUND);
	if(HHG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Honor Hold",GrinderCore_GetGrindingTime("Honor Hold")+(GetTime()-HHG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Honor Hold",GrinderCore_GetRepGround("Honor Hold")+(HHG_GetCurrentRepTotal() - HHG_INITIALREP));
	end
    end
end

function HonorHoldGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	HHG_TEXT = HHG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("HonorHoldGrinderGrindFrame"):SetWidth(215);
	getglobal("HHG_TimeTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("HHG_RepTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("HHG_RepPerHourTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("HHG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("HHG_TimeTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("HHG_RepTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("HHG_RepPerHourTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("HHG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	HHG_TEXT = HHG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("HHG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	HHG_TEXT = HHG_TEXT_ZHTW;

	getglobal("HHG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_HHRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("HHGToRepUpFrame"):SetWidth(90);
	getglobal("HHGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("HHG_SB_ActualRep"):SetWidth(80);
    	getglobal("HHG_SB_RepWithItems"):SetWidth(80);

	getglobal("HonorHoldGrinderGrindFrame"):SetWidth(215);
	getglobal("HHG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("HHG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("HHG_TimeTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("HHG_RepTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("HHG_RepPerHourTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("HHG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("HHG_TimeTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("HHG_RepTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("HHG_RepPerHourTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("HHG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","HonorHoldGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("HHG_HHRep"):SetText(HHG_TEXT["HH Rep"]);
    
    getglobal("HHG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("HHG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("HHG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("HHG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("HHG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("HHG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("HHG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("HHG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("HHG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("HHG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("HHG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("HHG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function HonorHoldGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, HHG_TEXT["Honor Hold Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("HHG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(HHG_REP_VALUE/42)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+HHG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(HHG_REP_VALUE/21)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+HHG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(HHG_REP_VALUE/12)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+HHG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(HHG_REP_VALUE/6)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+HHG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(HHG_REP_VALUE/3)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+HHG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(HHG_REP_VALUE/3)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+HHG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(HHG_REP_VALUE/3)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("HHG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("HHG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+HHG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(HHG_REP_VALUE/36)/10;
	getglobal("HHG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("HHG_RepPoints"):SetText((earnedValue+HHG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("HHG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function HonorHoldGrinder_ShowTurninToolTip(text,color)
    local RepToRepUp = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, HHG_TEXT["Honor Hold Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-HHG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
    end

    local tooltip = getglobal("HHGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    if(color=="white")then
	tooltip:AddLine(FG_WHITE..HHG_TEXT[text]);
    elseif(color=="green")then
	tooltip:AddLine(FG_GREEN..HHG_TEXT[text]);
    elseif(color=="blue")then
	tooltip:AddLine(FG_SUPERIOR..HHG_TEXT[text]);
    elseif(color=="purple")then
	tooltip:AddLine(FG_EPIC..HHG_TEXT[text]);
    end

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

--    if(text=="Deadwood Headdress Feather")then
--	tooltip:AddLine(FG_GREY.."5 = "..seventyfive.." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*seventyfive).." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/seventyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
--    end
--    tooltip:Show();
    tooltip:ClearAllPoints();
--    tooltip:SetPoint("BOTTOM","HonorHoldGrinderDisplayFrame","TOP",0,-5);
end

function HonorHoldGrinder_HideToolTip()
    getglobal("HHGToolTip"):Hide();
end

function HHG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, HHG_TEXT["Honor Hold Faction Name"]))) then
	    return earnedValue + HHG_REP_VALUE;
	end
    end
    return HHG_REP_VALUE;
end

function HonorHoldGrinder_ToggleGrinding()
    HHG_NOW_GRINDING = not HHG_NOW_GRINDING;

    local button = getglobal("HHG_BU_ToggleGrinding");
    if(HHG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("HHG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	HHG_GRINDING_STARTED_AT = GetTime();
	HHG_INITIALREP = HHG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("HHG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	HHG_PREVIOUS_GRINDING_TIME = HHG_PREVIOUS_GRINDING_TIME + (GetTime()-HHG_GRINDING_STARTED_AT);
	HHG_PREVIOUS_REP_GROUND = HHG_PREVIOUS_REP_GROUND + (HHG_GetCurrentRepTotal() - HHG_INITIALREP); 
    end
end

function HonorHoldGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("HonorHoldGrinder"))then	
	GrinderCore_AcknowledgeItemChange("HonorHoldGrinder");
	HonorHoldGrinder_UpdateDisplayData();
    end

    if(GetTime() > HHG_NEXT_GRIND_UPDATE)then
	HHG_NEXT_GRIND_UPDATE = HHG_NEXT_GRIND_UPDATE + HHG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(HHG_NOW_GRINDING)then	
	    getglobal("HHG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(HHG_PREVIOUS_GRINDING_TIME + (GetTime()-HHG_GRINDING_STARTED_AT)));
	    getglobal("HHG_RepTodayVal"):SetText(FG_GREY..(HHG_PREVIOUS_REP_GROUND + (HHG_GetCurrentRepTotal() - HHG_INITIALREP)));
	    RepPerSecond = ((HHG_PREVIOUS_REP_GROUND + (HHG_GetCurrentRepTotal() - HHG_INITIALREP)) / 
                            math.max(math.floor(HHG_PREVIOUS_GRINDING_TIME + (GetTime()-HHG_GRINDING_STARTED_AT)),1));
	    getglobal("HHG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("HHG_TimeToRepUpTodayVal"):SetText(FG_GREY..HHG_TimeToRepUp(RepPerSecond));

	    getglobal("HHG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Honor Hold")+HHG_PREVIOUS_GRINDING_TIME + (GetTime()-HHG_GRINDING_STARTED_AT)));
	    getglobal("HHG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Honor Hold")+HHG_PREVIOUS_REP_GROUND + (HHG_GetCurrentRepTotal() - HHG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Honor Hold")+HHG_PREVIOUS_REP_GROUND + (HHG_GetCurrentRepTotal() - HHG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Honor Hold")+HHG_PREVIOUS_GRINDING_TIME + (GetTime()-HHG_GRINDING_STARTED_AT)),1));
	    getglobal("HHG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("HHG_TimeToRepUpTotalVal"):SetText(FG_GREY..HHG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("HHG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(HHG_PREVIOUS_GRINDING_TIME));
	    getglobal("HHG_RepTodayVal"):SetText(FG_GREY..(HHG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (HHG_PREVIOUS_REP_GROUND / math.max(HHG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("HHG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("HHG_TimeToRepUpTodayVal"):SetText(FG_GREY..HHG_TimeToRepUp(RepPerSecond));

	    getglobal("HHG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Honor Hold")+HHG_PREVIOUS_GRINDING_TIME));
	    getglobal("HHG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Honor Hold")+HHG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Honor Hold")+HHG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Honor Hold")+HHG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("HHG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("HHG_TimeToRepUpTotalVal"):SetText(FG_GREY..HHG_TimeToRepUp(RepPerSecond));
        end
    end
end

function HHG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_, isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, HHG_TEXT["Honor Hold Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-HHG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function HonorHoldGrinder_ItemButtonClick(itemName, color)
    if(color == "white")then color = FG_WHITE;
    elseif(color == "green")then color = FG_GREEN;
    elseif(color == "blue")then color = FG_SUPERIOR;
    elseif(color == "purple")then color = FG_EPIC; end
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ((GrinderCore_PlayerInventoryCount(itemName) > 0)or(GrinderCore_PlayerTotalCount(itemName) > 0)or(GrinderCore_AltTotalCount(itemName) >0)))then
    	ChatFrameEditBox:Insert(color.."|Hitem:"..(GrinderCore_Settings["Item IDs"][itemName])..":0:0:0|h["..HHG_TEXT[itemName].."]|h|r");
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(itemName);
    end
end
