--GnomereganExilesGrinder 1.0
--Written By Tiok - US Thrall

GEG_INITIALREP = 0;

GEG_NOW_GRINDING = false;
GEG_PREVIOUS_GRINDING_TIME = 0;
GEG_GRINDING_STARTED_AT = 0;
GEG_PREVIOUS_REP_GROUND = 0;

GEG_GRIND_UPDATE_INTERVAL = 1;
GEG_NEXT_GRIND_UPDATE = 0;

GEG_REP_VALUE = 0;

GEG_TEXT = 
{
    ["Gnomeregan Exiles Faction Name"] = "Gnomeregan Exiles";
    ["GE Rep"] = "GE Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallGnomereganExilesGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["GnomereganExilesGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["GnomereganExilesGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["GnomereganExilesGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["GnomereganExilesGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["GnomereganExilesGrinder"] = "GEG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_GnomereganExilesLabel");
    FG_GnomereganExilesLabel:SetFontObject("GameFontNormalSmall");
    FG_GnomereganExilesLabel:SetText("Gnomeregan Exiles");
    FG_GnomereganExilesLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("GnomereganExilesTexture");
    GnomereganExilesTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Gnome_02");
    GnomereganExilesTexture:SetWidth(24);
    GnomereganExilesTexture:SetHeight(24);
    GnomereganExilesTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    GnomereganExilesTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_GnomereganExilesGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_GnomereganExilesGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function GnomereganExilesGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function GnomereganExilesGrinder_Init()
    GEG_NEXT_GRIND_UPDATE = GetTime()+GEG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("GnomereganExilesGrinder","Runecloth","14047","white");

    GnomereganExilesGrinder_UpdateDisplayData();
    GnomereganExilesGrinder_UpdateRepBars();
end

function GnomereganExilesGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("GEG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("GEG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(GEG_REP_VALUE ~= repValue)then
        GEG_REP_VALUE = repValue;
	GnomereganExilesGrinder_UpdateRepBars();
    end
end

function GnomereganExilesGrinder_OnLoad()
    GnomereganExilesGrinder_RegisterEvents();
end

function GnomereganExilesGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        GnomereganExilesGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	GnomereganExilesGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	GnomereganExilesGrinder_UpdateDisplayData();
	GnomereganExilesGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	GnomereganExilesGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Gnomeregan Exiles",GrinderCore_GetGrindingTime("Gnomeregan Exiles")+GEG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Gnomeregan Exiles",GrinderCore_GetRepGround("Gnomeregan Exiles")+GEG_PREVIOUS_REP_GROUND);
	if(GEG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Gnomeregan Exiles",GrinderCore_GetGrindingTime("Gnomeregan Exiles")+(GetTime()-GEG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Gnomeregan Exiles",GrinderCore_GetRepGround("Gnomeregan Exiles")+(GEG_GetCurrentRepTotal() - GEG_INITIALREP));
	end
    end
end

function GnomereganExilesGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	GEG_TEXT = GEG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("GnomereganExilesGrinderGrindFrame"):SetWidth(215);
	getglobal("GEG_TimeTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("GEG_RepTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("GEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("GEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("GEG_TimeTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("GEG_RepTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("GEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("GEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	GEG_TEXT = GEG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("GEG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	GEG_TEXT = GEG_TEXT_ZHTW;

	getglobal("GEG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_GERep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("GEGToRepUpFrame"):SetWidth(90);
	getglobal("GEGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("GEG_SB_ActualRep"):SetWidth(80);
    	getglobal("GEG_SB_RepWithItems"):SetWidth(80);

	getglobal("GnomereganExilesGrinderGrindFrame"):SetWidth(215);
	getglobal("GEG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("GEG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("GEG_TimeTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("GEG_RepTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("GEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("GEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("GEG_TimeTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("GEG_RepTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("GEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("GEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","GnomereganExilesGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("GEG_GERep"):SetText(GEG_TEXT["GE Rep"]);
    
    getglobal("GEG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("GEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("GEG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("GEG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("GEG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("GEG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("GEG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("GEG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("GEG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("GEG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("GEG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("GEG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function GnomereganExilesGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, GEG_TEXT["Gnomeregan Exiles Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("GEG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(GEG_REP_VALUE/42)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+GEG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(GEG_REP_VALUE/21)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+GEG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(GEG_REP_VALUE/12)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+GEG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(GEG_REP_VALUE/6)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+GEG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(GEG_REP_VALUE/3)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+GEG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(GEG_REP_VALUE/3)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+GEG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(GEG_REP_VALUE/3)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("GEG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("GEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+GEG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(GEG_REP_VALUE/36)/10;
	getglobal("GEG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("GEG_RepPoints"):SetText((earnedValue+GEG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("GEG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function GnomereganExilesGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, GEG_TEXT["Gnomeregan Exiles Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-GEG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-GEG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("GEGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..GEG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Perfect Yeti Hide") and (FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Bubulo Acerbus"].." - "..FG_TEXT["Ironforge"].." (73,47)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function GnomereganExilesGrinder_HideToolTip()
    getglobal("GEGToolTip"):Hide();
end

function GEG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, GEG_TEXT["Gnomeregan Exiles Faction Name"]))) then
	    return earnedValue + GEG_REP_VALUE;
	end
    end
    return GEG_REP_VALUE;
end

function GnomereganExilesGrinder_ToggleGrinding()
    GEG_NOW_GRINDING = not GEG_NOW_GRINDING;

    local button = getglobal("GEG_BU_ToggleGrinding");
    if(GEG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("GEG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	GEG_GRINDING_STARTED_AT = GetTime();
	GEG_INITIALREP = GEG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("GEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	GEG_PREVIOUS_GRINDING_TIME = GEG_PREVIOUS_GRINDING_TIME + (GetTime()-GEG_GRINDING_STARTED_AT);
	GEG_PREVIOUS_REP_GROUND = GEG_PREVIOUS_REP_GROUND + (GEG_GetCurrentRepTotal() - GEG_INITIALREP); 
    end
end

function GnomereganExilesGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("GnomereganExilesGrinder"))then	
	GrinderCore_AcknowledgeItemChange("GnomereganExilesGrinder");
	GnomereganExilesGrinder_UpdateDisplayData();
    end

    if(GetTime() > GEG_NEXT_GRIND_UPDATE)then
	GEG_NEXT_GRIND_UPDATE = GEG_NEXT_GRIND_UPDATE + GEG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(GEG_NOW_GRINDING)then	
	    getglobal("GEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GEG_PREVIOUS_GRINDING_TIME + (GetTime()-GEG_GRINDING_STARTED_AT)));
	    getglobal("GEG_RepTodayVal"):SetText(FG_GREY..(GEG_PREVIOUS_REP_GROUND + (GEG_GetCurrentRepTotal() - GEG_INITIALREP)));
	    RepPerSecond = ((GEG_PREVIOUS_REP_GROUND + (GEG_GetCurrentRepTotal() - GEG_INITIALREP)) / 
                            math.max(math.floor(GEG_PREVIOUS_GRINDING_TIME + (GetTime()-GEG_GRINDING_STARTED_AT)),1));
	    getglobal("GEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("GEG_TimeToRepUpTodayVal"):SetText(FG_GREY..GEG_TimeToRepUp(RepPerSecond));

	    getglobal("GEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Gnomeregan Exiles")+GEG_PREVIOUS_GRINDING_TIME + (GetTime()-GEG_GRINDING_STARTED_AT)));
	    getglobal("GEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Gnomeregan Exiles")+GEG_PREVIOUS_REP_GROUND + (GEG_GetCurrentRepTotal() - GEG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Gnomeregan Exiles")+GEG_PREVIOUS_REP_GROUND + (GEG_GetCurrentRepTotal() - GEG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Gnomeregan Exiles")+GEG_PREVIOUS_GRINDING_TIME + (GetTime()-GEG_GRINDING_STARTED_AT)),1));
	    getglobal("GEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("GEG_TimeToRepUpTotalVal"):SetText(FG_GREY..GEG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("GEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GEG_PREVIOUS_GRINDING_TIME));
	    getglobal("GEG_RepTodayVal"):SetText(FG_GREY..(GEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (GEG_PREVIOUS_REP_GROUND / math.max(GEG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("GEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("GEG_TimeToRepUpTodayVal"):SetText(FG_GREY..GEG_TimeToRepUp(RepPerSecond));

	    getglobal("GEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Gnomeregan Exiles")+GEG_PREVIOUS_GRINDING_TIME));
	    getglobal("GEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Gnomeregan Exiles")+GEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Gnomeregan Exiles")+GEG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Gnomeregan Exiles")+GEG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("GEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("GEG_TimeToRepUpTotalVal"):SetText(FG_GREY..GEG_TimeToRepUp(RepPerSecond));
        end
    end
end

function GEG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, GEG_TEXT["Gnomeregan Exiles Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-GEG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function GnomereganExilesGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(GEG_TEXT[itemName]);
    end
end
