--FactionGrinder 1.7
--Written By Tiok - US Thrall

FACTIONGRINDER_PREFIX = "FACTIONGRINDER";

FG_RED      = "|cffff0000";
FG_ORANGE   = "|cffff8800";
FG_GREEN    = "|cff00ff00";
FG_BLUE     = "|cff0000ff";
FG_YELLOW   = "|cffffff00";
FG_WHITE    = "|cffffffff";
FG_GOLD     = "|cffffcc22";
FG_GREY     = "|cffaaaaaa";
FG_GRELLOW  = "|cffaaff00";
FG_GRUE     = "|cff00ff50";
FG_EPIC     = "|cffa436ee"; --that epic purpley color
FG_SUPERIOR = "|cff0071df"; --that superior bluey color

FG_TEXT=
{
    ["Faction Grinder"] = "Faction Grinder";
    ["Display Settings"] = "Display Settings";
    ["General Settings"] = "General Settings";
    ["Turn-ins"] = "Turn-ins";
    ["Grind Stats"] = "Grind Stats";

    ["Include Bank Bags"] = "Include Bank Bags";
    ["Include Items on Alts"] = "Include Items on Alts";
    ["Recount Items"] = "Recount Items";
    ["Reset Window Positions"] = "Reset Window Positions";

    ["Toggle Selected Trackers\tLeft-Click\nToggle Settings Screen\tRight-Click"] = "Toggle Selected Trackers\tLeft-Click\nToggle Settings Screen\tRight-Click";
    ["FUBAR_Toggle Selected Trackers\tLeft-Click\nToggle Settings Screen\tRight-Click"] = "Toggle Selected Trackers     Left-Click\nToggle Settings Screen     Right-Click";

    ["The Aldor"] = "The Aldor";
    ["Argent Dawn"] = "Argent Dawn";
    ["Argent Dawn Cauldrons"] = "Argent Dawn Cauldrons";
    ["Bloodsail Buccaneers"] = "Bloodsail Buccaneers";
    ["Brood of Nozdormu"] = "Brood of Nozdormu";
    ["Cenarion Circle"] = "Cenarion Circle";
    ["Cenarion Circle Summons"] = "Cenarion Circle Summons";
    ["Cenarion Expedition"] = "Cenarion Expedition";
    ["The Consortium"] = "The Consortium";
    ["Darkspear Trolls"] = "Darkspear Trolls";
    ["Darnassus"] = "Darnassus";
    ["Exodar"] = "Exodar";
    ["Gnomeregan Exiles"] = "Gnomeregan Exiles";
    ["Honor Hold"] = "Honor Hold";
    ["Ironforge"] = "Ironforge";
    ["Kurenai"] = "Kurenai";
    ["Lower City"] = "Lower City";
    ["Mag'har"] = "Mag'har";
    ["Netherwing"] = "Netherwing";
    ["Ogri'la"] = "Ogri'la";
    ["Orgrimmar"] = "Orgrimmar";
    ["Scale of the Sands"] = "Scale of the Sands";
    ["The Scryers"] = "The Scryers";
    ["The Sha'tar"] = "The Sha'tar";
    ["Sha'tari Skyguard"] = "Sha'tari Skyguard";
    ["Shattered Sun Offensive"] = "Shattered Sun Offensive";
    ["Silvermoon City"] = "Silvermoon City";
    ["Sporeggar"] = "Sporeggar";
    ["Stormwind"] = "Stormwind";
    ["Thorium Brotherhood"] = "Thorium Brotherhood";
    ["Thrallmar"] = "Thrallmar";
    ["Thunder Bluff"] = "Thunder Bluff";
    ["Timbermaw Hold"] = "Timbermaw Hold";
    ["Undercity"] = "Undercity";
    ["The Violet Eye"] = "The Violet Eye";
    ["Wintersaber Trainers"] = "Wintersaber Trainers";
    ["Zandalar Tribe"] = "Zandalar Tribe";

    ["Not Grinding"] = "Not Grinding";
    ["Grinding"] = "Grinding";
    ["Start Grinding"] = "Start Grinding";
    ["Stop Grinding"] = "Stop Grinding";
    ["Today's Grinding"] = "Today's Grinding";
    ["Total Grinding"] = "Total Grinding";
    ["Time"] = "Time";
    ["Rep"] = "Rep";
    ["rep"] = "rep";
    ["Rep Value"] = "Rep Value";
    ["Rep/Hour"] = "Rep/Hour";
    ["Rep-up In"] = "Rep-up In";

    ["quests to rep-up"] = "quests to rep-up";
    ["quests to exalted"] = "quests to exalted";
    ["to rep-up"] = "to rep-up";
    ["to exalted"] = "to exalted";

    ["Now Hated"] = FG_RED.."Now Hated";
    ["Now Hostile"] = FG_RED.."Now Hostile";
    ["Now Unfriendly"] = FG_ORANGE.."Now Unfriendly";
    ["Now Neutral"] = FG_YELLOW.."Now Neutral";
    ["Now Friendly"] = FG_WHITE.."Now Friendly";
    ["Now Honored"] = FG_GREEN.."Now Honored";
    ["Now Revered"] = FG_SUPERIOR.."Now Revered";
    ["Now Exalted"] = FG_EPIC.."Now Exalted";

    ["Requires level"] = "Requires level";

    ["day abbreviation"] = "d";
    ["hour abbreviation"] = "h";
    ["minute abbreviation"] = "m";
    ["second abbreviation"] = "s";

    ["Human"] = "Human";

    ["Turn-in Locations"] = "Turn-in Locations";

    --Faction Requirements
    ["Only repeatable while Hated"] = "Only repeatable while Hated";
    ["Only repeatable while Hostile"] = "Only repeatable while Hostile";
    ["Only repeatable while Unfriendly"] = "Only repeatable while Unfriendly";
    ["Only repeatable while Neutral"] = "Only repeatable while Neutral";
    ["Only repeatable while Friendly"] = "Only repeatable while Friendly";
    ["Only repeatable while Honored"] = "Only repeatable while Honored";
    ["Only repeatable while Revered"] = "Only repeatable while Revered";

    ["Only repeatable while Neutral or Friendly"] = "Only repeatable while Neutral or Friendly";

    ["Only repeatable while Hostile or better"] = "Only repeatable while Hostile or better";
    ["Only repeatable while Unfriendly or better"] = "Only repeatable while Unfriendly or better";
    ["Only repeatable while Neutral or better"] = "Only repeatable while Neutral or better";
    ["Only repeatable while Friendly or better"] = "Only repeatable while Friendly or better";
    ["Only repeatable while Honored or better"] = "Only repeatable while Honored or better";

    ["Only repeatable while Hostile or lower"] = "Only repeatable while Hostile or lower";
    ["Only repeatable while Unfriendly or lower"] = "Only repeatable while Unfriendly or lower";
    ["Only repeatable while Neutral or lower"] = "Only repeatable while Neutral or lower";
    ["Only repeatable while Friendly or lower"] = "Only repeatable while Friendly or lower";
    ["Only repeatable while Honored or lower"] = "Only repeatable while Honored or lower";

    --Zones
    ["Blackrock Depths, The Bar"] = "Blackrock Depths, The Bar";
    ["Blade's Edge Mountains"] = "Blade's Edge Mountains";
    ["Eastern Plaguelands"] = "Eastern Plaguelands";
    ["Felwood"] = "Felwood";
    ["Feralas"] = "Feralas";
    ["Hellfire Peninsula"] = "Hellfire Peninsula";
    ["Isle of Quel'Danas"] = "Isle of Quel'Danas";
    ["Nagrand"] = "Nagrand";
    ["Netherstorm"] = "Netherstorm";
    ["Searing Gorge"] = "Searing Gorge";
    ["Shadowmoon Valley"] = "Shadowmoon Valley";
    ["Shattrath City"] = "Shattrath City";
    ["Silithus"] = "Silithus";
    ["Stranglethorn Vale"] = "Stranglethorn Vale";
    ["Temple of Ahn'qiraj"] = "Temple of Ahn'qiraj";
    ["Terokkar Forest"] = "Terokkar Forest";
    ["Western Plaguelands"] = "Western Plaguelands";
    ["Winterspring"] = "Winterspring";
    ["Zangarmarsh"] = "Zangarmarsh";

    --Quest-givers
    ["Adyen the Lightwarden"] = "Adyen the Lightwarden";
    ["Altar of Zanza"] = "Altar of Zanza";
    ["Anchorite Ayuri"] = "Anchorite Ayuri";
    ["Andorgos"] = "Andorgos";
    ["Arcanist Adyria"] = "Arcanist Adyria";
    ["Archmage Angela Dosantos"] = "Archmage Angela Dosantos";
    ["Argent Officer Pureheart"] = "Argent Officer Pureheart";
    ["Astromancer Darnarian"] = "Astromancer Darnarian";
    ["Aurel Goldleaf"] = "Aurel Goldleaf";
    ["Baristolth of the Shifting Sands"] = "Baristolth of the Shifting Sands";
    ["Bashana Runetotem"] = "Bashana Runetotem";
    ["Battlemage Arynna"] = "Battlemange Arynna";
    ["Battlemage Vyara"] = "Battlemage Vyara";
    ["Bor Wildmane"] = "Bor Wildmane";
    ["Bubulo Acerbus"] = "Bubulo Acerbus";
    ["Captain Theris Dawnhearth"] = "Captain Theris Dawnhearth";
    ["Captain Valindria"] = "Captain Valindria";
    ["Chief Overseer Mudlump"] = "Chief Overseer Mudlump";
    ["Chu'a'lor"] = "Chu'a'lor";
    ["Clavicus Knavingham"] = "Clavicus Knavingham";
    ["Dragonmaw Foreman"] = "Dragonmaw Foreman";
    ["Dugiru"] = "Dugiru";
    ["Duke Nicholas Zverenhoff"] = "Duke Nicholas Zverenhoff";
    ["Emissary Mordin"] = "Emissary Mordin";
    ["Exarch Nasuun"] = "Exarch Nasuun";
    ["Fahssn"] = "Fahssn";
    ["Gezhe"] = "Gezhe";
    ["Gshaff"] = "Gshaff";
    ["Gzhun'tt"] = "Gzhun'tt";
    ["Harbinger Haronem"] = "Harbinger Haronem";
    ["Harbinger Inuuro"] = "Harbinger Inuuro";
    ["Harbinger Saronen"] = "Harbinger Saronen";
    ["Huntsman Leopold"] = "Huntsman Leopold";
    ["Ishanah"] = "Ishanah";
    ["Jangdor Swiftstrider"] = "Jangdor Swiftstrider";
    ["Kandrostrasz"] = "Kandrostrasz";
    ["Korfax, Champion of the Light"] = "Korfax, Champion of the Light";
    ["Kronk"] = "Kronk";
    ["Lauranna Thar'well"] = "Lauranna Thar'well";
    ["Lokhtos Darkbargainer"] = "Lokhtos Darkbargainer";
    ["Lord Torvos"] = "Lord Torvos";
    ["Magister Ilastar"] = "Magister Ilastar";
    ["Magistrix Fyalenn"] = "Magistrix Fyalenn";
    ["Magistrix Seyla"] = "Magistrix Seyla";
    ["Mar'nah"] = "Mar'nah";
    ["Master Smith Burninate"] = "Master Smith Burninate";
    ["Mistress of the Mines"] = "Mistress of the Mines";
    ["Mathrengyl Bearwalker"] = "Mathrengyl Bearwalker";
    ["Mistina Steelshield"] = "Mistina Steelshield";
    ["Msshi'fn"] = "Msshi'fn";
    ["Nafien"] = "Nafien";
    ["Nether-Stalker Khay'ji"] = "Nether-Stalker Khay'ji";
    ["Overlord Mor'ghor"] = "Overlord Mor'ghor";
    ["Pratt McGrubben"] = "Pratt McGrubben";
    ["Quintis Jonespyre"] = "Quintis Jonespyre";
    ["Raedon Duskstriker"] = "Raedon Duskstriker";
    ["Ralston Farnsley"] = "Ralston Farnsley";
    ["Rashona Straglash"] = "Rashona Straglash";
    ["Rayne"] = "Rayne";
    ["Rivern Frostwind"] = "Rivern Frostwind";
    ["Rohan the Assassin"] = "Rohan the Assassin";
    ["Rumstag Proudstrider"] = "Rumstag Proudstrider";
    ["Salfa"] = "Salfa";
    ["Scourge Cauldron"] = "Scourge Cauldron";
    ["Severin"] = "Severin";
    ["Sha'nir"] = "Sha'nir";
    ["Shadrek"] = "Shadrek";
    ["Sky Sergeant Doryn"] = "Sky Sergeant Doryn";
    ["Sky Sergeant Vanderlip"] = "Sky Sergeant Vanderlip";
    ["Skyguard Khatie"] = "Skyguard Khatie";
    ["Smith Hauthaa"] = "Smith Hauthaa";
    ["Sorim Lightsong"] = "Sorim Lightsong";
    ["Taskmaster Varkule Dragonbreath"] = "Taskmaster Varkule Dragonbreath";
    ["Vehena"] = "Vehena";
    ["Vekax"] = "Vekax";
    ["Vinchaxa"] = "Vinchaxa";
    ["Vindicator Kaalan"] = "Vindicator Kaalan";
    ["Vindicator Xayann"] = "Vindicator Xayann";
    ["Voren'thal the Seer"] = "Voren'thal the Seer";
    ["Warden Bullrok"] = "Warden Bullrok";
    ["Warden Iolol"] = "Warden Iolol";
    ["Windcaller Kaldon"] = "Windcaller Kaldon";
    ["Yarzill the Merc"] = "Yarzill the Merc";
    ["Ysiel Windsinger"] = "Ysiel Windsinger";
};

function FactionGrinder_OnLoad()
    FactionGrinder_RegisterEvents();
    FactionGrinder_RegisterSlashCommands();
end

function FactionGrinder_RegisterEvents()
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("ADDON_LOADED");
end

function FactionGrinder_RegisterSlashCommands()
    SLASH_fgShow1 = "/fg";
    SlashCmdList["fgShow"] = function()
	FactionGrinder_ToggleFrameDisplay(not FactionGrinderSettings["Show Frames"]);
    end

    SLASH_fgSettings1 = "/fgs";
    SlashCmdList["fgSettings"] = function()
	local frame = getglobal("FactionGrinderSettingsFrame");
	if(frame:IsVisible())then
	    frame:Hide();
            getglobal("FactionGrinderSettingsFrame"):ClearAllPoints();
	    getglobal("FactionGrinderSettingsFrame"):SetPoint("TOPLEFT","UIParent","TOPLEFT",-1000,0);
	else
	    frame:ClearAllPoints();
            frame:SetPoint("CENTER","UIParent","CENTER",0,0);
	    frame:Show();
	end
    end
end

function FactionGrinder_Init()    
    if((FactionGrinderSettings==nil)or(FactionGrinderSettings["Version"] < 1.9))then
	FactionGrinderSettings = 
	{
	    ["Version"] = 1.8;
	    ["Include Bank Bags"] = false;
	    ["Include Items on Alts"] = false;
	    ["Show Frames"] = false;
	    --Left side = grinder name; Right side = Alliance/Horde/Both    Alphabetical order, please.
	    ["FactionFunctions"] = 
	    {
		["AldorGrinder"] = "Both";
		["ArgentDawnGrinder"] = "Both";
		["BloodsailBuccaneersGrinder"] = "Both";
		["BroodofNozdormuGrinder"] = "Both";
		["CenarionCircleGrinder"] = "Both";
		["CenarionExpeditionGrinder"] = "Both";
		["ConsortiumGrinder"] = "Both";
		["DarkspearTrollsGrinder"] = "Horde";
		["DarnassusGrinder"] = "Alliance";
		["ExodarGrinder"] = "Alliance";
		["GnomereganExilesGrinder"] = "Alliance";
		["HonorHoldGrinder"] = "Alliance";
		["IronforgeGrinder"] = "Alliance";
		["KurenaiGrinder"] = "Alliance";
		["LowerCityGrinder"] = "Both";
		["MagharGrinder"] = "Horde";
		["NetherwingGrinder"] = "Both";
		["OgrilaGrinder"] = "Both";
		["OrgrimmarGrinder"] = "Horde";
		["ScaleoftheSandsGrinder"] = "Both";
		["ScryersGrinder"] = "Both";
		["ShatarGrinder"] = "Both";
		["ShatariSkyguardGrinder"] = "Both";
		["ShatteredSunOffensiveGrinder"] = "Both";
		["SilvermoonCityGrinder"] = "Horde";
		["SporeggarGrinder"] = "Both";
		["StormwindGrinder"] = "Alliance";
		["ThoriumBrotherhoodGrinder"] = "Both";
		["ThrallmarGrinder"] = "Horde";
		["ThunderBluffGrinder"] = "Horde";
		["TimbermawHoldGrinder"] = "Both";
		["UndercityGrinder"] = "Horde";
		["VioletEyeGrinder"] = "Both";
		["WintersaberTrainersGrinder"] = "Alliance";
		["ZandalarTribeGrinder"] = "Both";
	    };
	    ["Abbreviations"] = {};
	};
    end
    --By putting this out here, we allow people to maintain their show/hide settings across version updates.
    if (FactionGrinderSettings["Show"] == nil) then FactionGrinderSettings["Show"] = {}; end

    --And now we call all of the relevant grinder init functions.  These fill out any blank "Show" values and create the settings frame.
    FGInitTop = 0; --Where to put the next set of checkboxes and whatnot (y value) on the scrollframe.  Updated by each init function.
    for grinder,faction in sortedpairs(FactionGrinderSettings["FactionFunctions"])do	
	if (faction == "Both") or (faction == UnitFactionGroup("player")) then
            getglobal("Install"..grinder)();
	end
    end
    --Size the scrollchild based on the factions that were put into it.
    FGScrollChild:SetHeight(FGInitTop+30);

    --Match the "settings" display to the saved variables.
    if(FactionGrinderSettings ~= nil)and(FactionGrinderSettings["Show"] ~= nil)then
	--This faction was removed in patch 2.0.3, so we need to do this to prevent startup errors.
        FactionGrinderSettings["Show"]["WildhammerClanGrinderDisplayFrame"] = nil;
	FactionGrinderSettings["Show"]["WildhammerClanGrinderGrindFrame"] = nil;

        --This faction frame was misnamed in previous versions, so this line is needed to repair the error.
	FactionGrinderSettings["Show"]["ScaleoftheSandsGrindFrame"] = nil;

    	for frame,frameshow in pairs(FactionGrinderSettings["Show"])do
	    getglobal("FG_CB_"..frame):SetChecked(frameshow);
    	end
    	FactionGrinder_ToggleFrameDisplay(FactionGrinderSettings["Show Frames"]);
    end
    if(FactionGrinderSettings ~= nil)then
    	getglobal("FG_CB_IncludeBankBags"):SetChecked(FactionGrinderSettings["Include Bank Bags"]);
    	getglobal("FG_CB_IncludeItemsOnAlts"):SetChecked(FactionGrinderSettings["Include Items on Alts"]);
    end

    if(GetLocale()=="deDE")then
	FG_TEXT = FG_TEXT_DE;

	getglobal("FG_CB_IncludeBankBags"):SetPoint("TOPLEFT","FactionGrinderGeneralSettingsFrame","TOPLEFT",60,-33);
	getglobal("FG_CB_IncludeItemsOnAlts"):SetPoint("TOPLEFT","FactionGrinderGeneralSettingsFrame","TOPLEFT",60,-53);
	getglobal("FG_BU_RecountItems"):SetWidth(180);
    elseif(GetLocale()=="frFR")then
	FG_TEXT = FG_TEXT_FR;
    elseif(GetLocale()=="zhTW")then
	FG_TEXT = FG_TEXT_ZHTW;

--	getglobal("FG_TurninLabel"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",160,-42);
--	getglobal("FG_GrindStatsLabel"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",225,-42);
--	getglobal("AldorTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-55)
--	getglobal("ArgentDawnTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-90)
--	getglobal("BloodsailBuccaneersTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-125);
--	getglobal("BroodofNozdormuTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-155);
--	getglobal("CenarionCircleTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-190);
--	getglobal("CenarionExpeditionTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-225);
--	getglobal("ConsortiumTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-255);
--	getglobal("HonorHoldTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-285);
--	getglobal("KurenaiTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-315);
--	getglobal("LowerCityTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-345);
--	getglobal("MagharTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-375);
--	getglobal("ScryersTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-405);
--	getglobal("ShatarTexture"):SetPoint("TOPLEFT","FGSCrollChilde","TOPLEFT",208,-435);
--	getglobal("SporeggarTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-465);
--	getglobal("ThoriumBrotherhoodTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-495);
--	getglobal("ThrallmarTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-525);
--	getglobal("TimbermawHoldTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-555);
--	getglobal("WintersaberTrainersTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-585);
--	getglobal("ZandalarTribeTexture"):SetPoint("TOPLEFT","FGScrollChild","TOPLEFT",208,-615);
    end

    --Localize all text variables.
    getglobal("FG_SettingsFrameHeader"):SetText(FG_TEXT["Faction Grinder"]);
    getglobal("FG_DisplaySettingsHeader"):SetText(FG_TEXT["Display Settings"]);
    getglobal("FG_GeneralSettingsHeader"):SetText(FG_TEXT["General Settings"]);
    getglobal("FG_CB_IncludeBankBagsText"):SetText(FG_TEXT["Include Bank Bags"]);
    getglobal("FG_CB_IncludeItemsOnAltsText"):SetText(FG_TEXT["Include Items on Alts"]);
    getglobal("FG_BU_RecountItemsText"):SetText(FG_TEXT["Recount Items"]);
    getglobal("FG_BU_ResetWindowPositionsText"):SetText(FG_TEXT["Reset Window Positions"]);
    getglobal("FG_TurninLabel"):SetText(FG_TEXT["Turn-ins"]);
    getglobal("FG_GrindStatsLabel"):SetText(FG_TEXT["Grind Stats"]);

    local label;
    label = getglobal("FG_AldorLabel"); if(label)then label:SetText(FG_TEXT["The Aldor"]);end
    label = getglobal("FG_ArgentDawnLabel"); if(label)then label:SetText(FG_TEXT["Argent Dawn"]);end
    label = getglobal("FG_ArgentDawnCauldronsLabel"); if(label)then label:SetText(FG_TEXT["Argent Dawn Cauldrons"]);end
    label = getglobal("FG_BloodsailBuccaneersLabel"); if(label)then label:SetText(FG_TEXT["Bloodsail Buccaneers"]);end
    label = getglobal("FG_BroodofNozdormuLabel"); if(label)then label:SetText(FG_TEXT["Brood of Nozdormu"]);end
    label = getglobal("FG_CenarionCircleLabel"); if(label)then label:SetText(FG_TEXT["Cenarion Circle"]);end
    label = getglobal("FG_CenarionCircleSummonsLabel"); if(label)then label:SetText(FG_TEXT["Cenarion Circle Summons"]);end
    label = getglobal("FG_CenarionExpeditionLabel"); if(label)then label:SetText(FG_TEXT["Cenarion Expedition"]);end
    label = getglobal("FG_ConsortiumLabel"); if(label)then label:SetText(FG_TEXT["The Consortium"]);end
    label = getglobal("FG_DarkspearTrollsLabel"); if(label)then label:SetText(FG_TEXT["Darkspear Trolls"]);end
    label = getglobal("FG_DarnassusLabel"); if(label)then label:SetText(FG_TEXT["Darnassus"]);end
    label = getglobal("FG_ExodarLabel"); if(label)then label:SetText(FG_TEXT["Exodar"]);end
    label = getglobal("FG_GnomereganExilesLabel"); if(label)then label:SetText(FG_TEXT["Gnomeregan Exiles"]);end
    label = getglobal("FG_HonorHoldLabel"); if(label)then label:SetText(FG_TEXT["Honor Hold"]);end
    label = getglobal("FG_IronforgeLabel"); if(label)then label:SetText(FG_TEXT["Ironforge"]);end
    label = getglobal("FG_KurenaiLabel"); if(label)then label:SetText(FG_TEXT["Kurenai"]);end
    label = getglobal("FG_LowerCityLabel"); if(label)then label:SetText(FG_TEXT["Lower City"]);end
    label = getglobal("FG_MagharLabel"); if(label)then label:SetText(FG_TEXT["Mag'har"]);end
    label = getglobal("FG_NetherwingLabel"); if(label)then label:SetText(FG_TEXT["Netherwing"]);end
    label = getglobal("FG_OgrilaLabel"); if(label)then label:SetText(FG_TEXT["Ogri'la"]);end
    label = getglobal("FG_OrgrimmarLabel"); if(label)then label:SetText(FG_TEXT["Orgrimmar"]);end
    label = getglobal("FG_ScaleoftheSandsLabel"); if(label)then label:SetText(FG_TEXT["Scale of the Sands"]);end
    label = getglobal("FG_ScryersLabel"); if(label)then label:SetText(FG_TEXT["The Scryers"]);end
    label = getglobal("FG_ShatarLabel"); if(label)then label:SetText(FG_TEXT["The Sha'tar"]);end
    label = getglobal("FG_ShatariSkyguardLabel"); if(label)then label:SetText(FG_TEXT["Sha'tari Skyguard"]);end
    label = getglobal("FG_ShatteredSunOffensiveLabel"); if(label)then label:SetText(FG_TEXT["Shattered Sun Offensive"]);end
    label = getglobal("FG_SilvermoonCityLabel"); if(label)then label:SetText(FG_TEXT["SilvermoonCity"]);end
    label = getglobal("FG_SporeggarLabel"); if(label)then label:SetText(FG_TEXT["Sporeggar"]);end
    label = getglobal("FG_StormwindLabel"); if(label)then label:SetText(FG_TEXT["Stormwind"]);end
    label = getglobal("FG_ThoriumBrotherhoodLabel"); if(label)then label:SetText(FG_TEXT["Thorium Brotherhood"]);end
    label = getglobal("FG_ThunderBluffLabel"); if(label)then label:SetText(FG_TEXT["Thunder Bluff"]);end
    label = getglobal("FG_ThrallmarLabel"); if(label)then label:SetText(FG_TEXT["Thrallmar"]);end
    label = getglobal("FG_TimbermawHoldLabel"); if(label)then label:SetText(FG_TEXT["Timbermaw Hold"]);end
    label = getglobal("FG_UndercityLabel"); if(label)then label:SetText(FG_TEXT["Undercity"]);end
    label = getglobal("FG_VioletEyeLabel"); if(label)then label:SetText(FG_TEXT["The Violet Eye"]);end
    label = getglobal("FG_WintersaberTrainersLabel"); if(label)then label:SetText(FG_TEXT["Wintersaber Trainers"]);end
    label = getglobal("FG_ZandalarTribeLabel"); if(label)then label:SetText(FG_TEXT["Zandalar Tribe"]);end
end

function FactionGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then
        FactionGrinder_Init();
    elseif((event=="ADDON_LOADED")and(arg1=="FactionGrinder"))then
	FactionGrinder_LoadConfiguration();
    end
end

function FactionGrinder_LoadConfiguration()

end

function FactionGrinder_SetShowVar(frame,frameshow)
    if(frameshow)then
        FactionGrinderSettings["Show"][frame] = 1;
    else
	FactionGrinderSettings["Show"][frame] = 0;
    end
end

function FactionGrinder_ToggleFrameDisplay(show)
    local AtLeastOneDisplayed = false;
    FactionGrinderSettings["Show Frames"] = show;

    for frame,frameshow in pairs(FactionGrinderSettings["Show"])do
	AtLeastOneDisplayed = AtLeastOneDisplayed or frameshow;
	if(show)and(frameshow==1)then
	    getglobal(frame):Show();
	else
	    getglobal(frame):Hide();
	end
    end

    FactionGrinderSettings["Show Frames"] = (show and AtLeastOneDisplayed);
end

function FactionGrinder_SecondsToTime(seconds)
    seconds = math.floor(seconds);
    local daysonly = math.floor(seconds/86400);
    seconds = seconds - (daysonly*86400);
    local hoursonly = math.floor(seconds/3600);
    seconds = seconds - (hoursonly*3600);
    local minutesonly = math.floor(seconds/60);
    seconds = seconds - (minutesonly*60);

    return daysonly..FG_TEXT["day abbreviation"].." "..hoursonly..FG_TEXT["hour abbreviation"].." "..minutesonly..FG_TEXT["minute abbreviation"].." "..seconds..FG_TEXT["second abbreviation"];
end

function FactionGrinder_ResetWindowPositions()
    for frame,_ in pairs(FactionGrinderSettings["Show"])do
	getglobal(frame):ClearAllPoints();
	getglobal(frame):SetPoint("CENTER","UIParent","CENTER",0,0);
    end
end

function sortedpairs(t,comparator)
    local sortedKeys = {};
    table.foreach(t, function(k,v) table.insert(sortedKeys,k) end);
    table.sort(sortedKeys,comparator);
    local i = 0;
    local function _f(_s,_v)
	i = i + 1;
	local k = sortedKeys[i];
	if (k) then
	   return k,t[k];
	end
    end
    return _f,nil,nil;
end

