--ExodarGrinder 1.0
--Written By Tiok - US Thrall

EXG_INITIALREP = 0;

EXG_NOW_GRINDING = false;
EXG_PREVIOUS_GRINDING_TIME = 0;
EXG_GRINDING_STARTED_AT = 0;
EXG_PREVIOUS_REP_GROUND = 0;

EXG_GRIND_UPDATE_INTERVAL = 1;
EXG_NEXT_GRIND_UPDATE = 0;

EXG_REP_VALUE = 0;

EXG_TEXT = 
{
    ["Exodar Faction Name"] = "Exodar";
    ["Ex Rep"] = "Ex Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallExodarGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ExodarGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ExodarGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ExodarGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ExodarGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ExodarGrinder"] = "EXG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ExodarLabel");
    FG_ExodarLabel:SetFontObject("GameFontNormalSmall");
    FG_ExodarLabel:SetText("Exodar");
    FG_ExodarLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ExodarTexture");
    ExodarTexture:SetTexture("Interface\\Icons\\INV_Mask_05");
    ExodarTexture:SetWidth(24);
    ExodarTexture:SetHeight(24);
    ExodarTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ExodarTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ExodarGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ExodarGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ExodarGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ExodarGrinder_Init()
    EXG_NEXT_GRIND_UPDATE = GetTime()+EXG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ExodarGrinder","Runecloth","14047","white");

    ExodarGrinder_UpdateDisplayData();
    ExodarGrinder_UpdateRepBars();
end

function ExodarGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("EXG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("EXG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(EXG_REP_VALUE ~= repValue)then
        EXG_REP_VALUE = repValue;
	ExodarGrinder_UpdateRepBars();
    end
end

function ExodarGrinder_OnLoad()
    ExodarGrinder_RegisterEvents();
end

function ExodarGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ExodarGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ExodarGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ExodarGrinder_UpdateDisplayData();
	ExodarGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ExodarGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Exodar",GrinderCore_GetGrindingTime("Exodar")+EXG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Exodar",GrinderCore_GetRepGround("Exodar")+EXG_PREVIOUS_REP_GROUND);
	if(EXG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Exodar",GrinderCore_GetGrindingTime("Exodar")+(GetTime()-EXG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Exodar",GrinderCore_GetRepGround("Exodar")+(EXG_GetCurrentRepTotal() - EXG_INITIALREP));
	end
    end
end

function ExodarGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	EXG_TEXT = EXG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ExodarGrinderGrindFrame"):SetWidth(215);
	getglobal("EXG_TimeTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("EXG_RepTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("EXG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("EXG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("EXG_TimeTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("EXG_RepTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("EXG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("EXG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	EXG_TEXT = EXG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("EXG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	EXG_TEXT = EXG_TEXT_ZHTW;

	getglobal("EXG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_ExRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("EXGToRepUpFrame"):SetWidth(90);
	getglobal("EXGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("EXG_SB_ActualRep"):SetWidth(80);
    	getglobal("EXG_SB_RepWithItems"):SetWidth(80);

	getglobal("ExodarGrinderGrindFrame"):SetWidth(215);
	getglobal("EXG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("EXG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("EXG_TimeTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("EXG_RepTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("EXG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("EXG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("EXG_TimeTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("EXG_RepTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("EXG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("EXG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ExodarGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("EXG_ExRep"):SetText(EXG_TEXT["Ex Rep"]);
    
    getglobal("EXG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("EXG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("EXG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("EXG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("EXG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("EXG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("EXG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("EXG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("EXG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("EXG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("EXG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("EXG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ExodarGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, EXG_TEXT["Exodar Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("EXG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(EXG_REP_VALUE/42)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+EXG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(EXG_REP_VALUE/21)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+EXG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(EXG_REP_VALUE/12)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+EXG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(EXG_REP_VALUE/6)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+EXG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(EXG_REP_VALUE/3)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+EXG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(EXG_REP_VALUE/3)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+EXG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(EXG_REP_VALUE/3)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("EXG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("EXG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+EXG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(EXG_REP_VALUE/36)/10;
	getglobal("EXG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("EXG_RepPoints"):SetText((earnedValue+EXG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("EXG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ExodarGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, EXG_TEXT["Exodar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-EXG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-EXG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("EXGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..EXG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Perfect Yeti Hide") and (FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Dugiru"].." - "..FG_TEXT["Exodar"].." (63,67)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ExodarGrinder_HideToolTip()
    getglobal("EXGToolTip"):Hide();
end

function EXG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, EXG_TEXT["Exodar Faction Name"]))) then
	    return earnedValue + EXG_REP_VALUE;
	end
    end
    return EXG_REP_VALUE;
end

function ExodarGrinder_ToggleGrinding()
    EXG_NOW_GRINDING = not EXG_NOW_GRINDING;

    local button = getglobal("EXG_BU_ToggleGrinding");
    if(EXG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("EXG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	EXG_GRINDING_STARTED_AT = GetTime();
	EXG_INITIALREP = EXG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("EXG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	EXG_PREVIOUS_GRINDING_TIME = EXG_PREVIOUS_GRINDING_TIME + (GetTime()-EXG_GRINDING_STARTED_AT);
	EXG_PREVIOUS_REP_GROUND = EXG_PREVIOUS_REP_GROUND + (EXG_GetCurrentRepTotal() - EXG_INITIALREP); 
    end
end

function ExodarGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ExodarGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ExodarGrinder");
	ExodarGrinder_UpdateDisplayData();
    end

    if(GetTime() > EXG_NEXT_GRIND_UPDATE)then
	EXG_NEXT_GRIND_UPDATE = EXG_NEXT_GRIND_UPDATE + EXG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(EXG_NOW_GRINDING)then	
	    getglobal("EXG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(EXG_PREVIOUS_GRINDING_TIME + (GetTime()-EXG_GRINDING_STARTED_AT)));
	    getglobal("EXG_RepTodayVal"):SetText(FG_GREY..(EXG_PREVIOUS_REP_GROUND + (EXG_GetCurrentRepTotal() - EXG_INITIALREP)));
	    RepPerSecond = ((EXG_PREVIOUS_REP_GROUND + (EXG_GetCurrentRepTotal() - EXG_INITIALREP)) / 
                            math.max(math.floor(EXG_PREVIOUS_GRINDING_TIME + (GetTime()-EXG_GRINDING_STARTED_AT)),1));
	    getglobal("EXG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("EXG_TimeToRepUpTodayVal"):SetText(FG_GREY..EXG_TimeToRepUp(RepPerSecond));

	    getglobal("EXG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Exodar")+EXG_PREVIOUS_GRINDING_TIME + (GetTime()-EXG_GRINDING_STARTED_AT)));
	    getglobal("EXG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Exodar")+EXG_PREVIOUS_REP_GROUND + (EXG_GetCurrentRepTotal() - EXG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Exodar")+EXG_PREVIOUS_REP_GROUND + (EXG_GetCurrentRepTotal() - EXG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Exodar")+EXG_PREVIOUS_GRINDING_TIME + (GetTime()-EXG_GRINDING_STARTED_AT)),1));
	    getglobal("EXG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("EXG_TimeToRepUpTotalVal"):SetText(FG_GREY..EXG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("EXG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(EXG_PREVIOUS_GRINDING_TIME));
	    getglobal("EXG_RepTodayVal"):SetText(FG_GREY..(EXG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (EXG_PREVIOUS_REP_GROUND / math.max(EXG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("EXG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("EXG_TimeToRepUpTodayVal"):SetText(FG_GREY..EXG_TimeToRepUp(RepPerSecond));

	    getglobal("EXG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Exodar")+EXG_PREVIOUS_GRINDING_TIME));
	    getglobal("EXG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Exodar")+EXG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Exodar")+EXG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Exodar")+EXG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("EXG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("EXG_TimeToRepUpTotalVal"):SetText(FG_GREY..EXG_TimeToRepUp(RepPerSecond));
        end
    end
end

function EXG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, EXG_TEXT["Exodar Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-EXG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ExodarGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(EXG_TEXT[itemName]);
    end
end
