--DarnassusGrinder 1.0
--Written By Tiok - US Thrall

DNG_INITIALREP = 0;

DNG_NOW_GRINDING = false;
DNG_PREVIOUS_GRINDING_TIME = 0;
DNG_GRINDING_STARTED_AT = 0;
DNG_PREVIOUS_REP_GROUND = 0;

DNG_GRIND_UPDATE_INTERVAL = 1;
DNG_NEXT_GRIND_UPDATE = 0;

DNG_REP_VALUE = 0;

DNG_TEXT = 
{
    ["Darnassus Faction Name"] = "Darnassus";
    ["Da Rep"] = "Da Rep";

    ["Pristine Yeti Hide"] = "Pristine Yeti Hide";
    ["Morrowgrain"] = "Morrowgrain";
    ["Runecloth"] = "Runecloth";
}

function InstallDarnassusGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["DarnassusGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["DarnassusGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["DarnassusGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["DarnassusGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["DarnassusGrinder"] = "DNG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_DarnassusLabel");
    FG_DarnassusLabel:SetFontObject("GameFontNormalSmall");
    FG_DarnassusLabel:SetText("Darnassus");
    FG_DarnassusLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("DarnassusTexture");
    DarnassusTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Elf_02");
    DarnassusTexture:SetWidth(24);
    DarnassusTexture:SetHeight(24);
    DarnassusTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    DarnassusTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_DarnassusGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_DarnassusGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function DarnassusGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function DarnassusGrinder_Init()
    DNG_NEXT_GRIND_UPDATE = GetTime()+DNG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("DarnassusGrinder","Pristine Yeti Hide","18969","white");
    GrinderCore_RegisterItem("DarnassusGrinder","Morrowgrain","11040","white");
    GrinderCore_RegisterItem("DarnassusGrinder","Runecloth","14047","white");

    DarnassusGrinder_UpdateDisplayData();
    DarnassusGrinder_UpdateRepBars();
end

function DarnassusGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Pristine Yeti Hide";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/1)*250);
    getglobal("DNG_PristineYetiHideCount"):SetText(itemCount);

    itemName = "Morrowgrain";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/10)*50);
    getglobal("DNG_MorrowgrainCount"):SetText(itemCount);

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("DNG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("DNG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(DNG_REP_VALUE ~= repValue)then
        DNG_REP_VALUE = repValue;
	DarnassusGrinder_UpdateRepBars();
    end
end

function DarnassusGrinder_OnLoad()
    DarnassusGrinder_RegisterEvents();
end

function DarnassusGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        DarnassusGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	DarnassusGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	DarnassusGrinder_UpdateDisplayData();
	DarnassusGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	DarnassusGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Darnassus",GrinderCore_GetGrindingTime("Darnassus")+DNG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Darnassus",GrinderCore_GetRepGround("Darnassus")+DNG_PREVIOUS_REP_GROUND);
	if(DNG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Darnassus",GrinderCore_GetGrindingTime("Darnassus")+(GetTime()-DNG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Darnassus",GrinderCore_GetRepGround("Darnassus")+(DNG_GetCurrentRepTotal() - DNG_INITIALREP));
	end
    end
end

function DarnassusGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	DNG_TEXT = DNG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("DarnassusGrinderGrindFrame"):SetWidth(215);
	getglobal("DNG_TimeTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("DNG_RepTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("DNG_RepPerHourTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("DNG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("DNG_TimeTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("DNG_RepTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("DNG_RepPerHourTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("DNG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	DNG_TEXT = DNG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("DNG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	DNG_TEXT = DNG_TEXT_ZHTW;

	getglobal("DNG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_DaRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("DNGToRepUpFrame"):SetWidth(90);
	getglobal("DNGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("DNG_SB_ActualRep"):SetWidth(80);
    	getglobal("DNG_SB_RepWithItems"):SetWidth(80);

	getglobal("DarnassusGrinderGrindFrame"):SetWidth(215);
	getglobal("DNG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DNG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("DNG_TimeTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("DNG_RepTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("DNG_RepPerHourTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("DNG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("DNG_TimeTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("DNG_RepTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("DNG_RepPerHourTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("DNG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","DarnassusGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("DNG_DaRep"):SetText(DNG_TEXT["Da Rep"]);
    
    getglobal("DNG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("DNG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("DNG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("DNG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("DNG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("DNG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("DNG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("DNG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("DNG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("DNG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("DNG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("DNG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function DarnassusGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DNG_TEXT["Darnassus Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("DNG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(DNG_REP_VALUE/42)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DNG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(DNG_REP_VALUE/21)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DNG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(DNG_REP_VALUE/12)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DNG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(DNG_REP_VALUE/6)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DNG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(DNG_REP_VALUE/3)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+DNG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(DNG_REP_VALUE/3)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+DNG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(DNG_REP_VALUE/3)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("DNG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("DNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+DNG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(DNG_REP_VALUE/36)/10;
	getglobal("DNG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("DNG_RepPoints"):SetText((earnedValue+DNG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("DNG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function DarnassusGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DNG_TEXT["Darnassus Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-DNG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-DNG_REP_VALUE,0);
    end

    local twentyfive = 25;
    local fifty = 50;
    local seventyfive = 75;
    local twofifty = 250;    

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
    	fifty = 55;
    	seventyfive = 82.5;
    	twofifty = 275;
    end

    local tooltip = getglobal("DNGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..DNG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text ~= "Pristine Yeti Hide") and (FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Pristine Yeti Hide")then
	numNeeded = 1;
	reward = twofifty;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 46)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 46");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 46");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Pratt McGrubben"].." - "..FG_TEXT["Feralas"].." (30,42)");
    elseif(text=="Morrowgrain")then
	numNeeded = 10;
	reward = fifty;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Mathrengyl Bearwalker"].." - "..FG_TEXT["Darnassus"].." (34,8)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Quintis Jonespyre"].." - "..FG_TEXT["Feralas"].." (32,43) - "..twentyfive.." "..FG_TEXT["rep"]);
    elseif(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Raedon Duskstriker"].." - "..FG_TEXT["Darnassus"].." (64,23)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function DarnassusGrinder_HideToolTip()
    getglobal("DNGToolTip"):Hide();
end

function DNG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DNG_TEXT["Darnassus Faction Name"]))) then
	    return earnedValue + DNG_REP_VALUE;
	end
    end
    return DNG_REP_VALUE;
end

function DarnassusGrinder_ToggleGrinding()
    DNG_NOW_GRINDING = not DNG_NOW_GRINDING;

    local button = getglobal("DNG_BU_ToggleGrinding");
    if(DNG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("DNG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	DNG_GRINDING_STARTED_AT = GetTime();
	DNG_INITIALREP = DNG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("DNG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	DNG_PREVIOUS_GRINDING_TIME = DNG_PREVIOUS_GRINDING_TIME + (GetTime()-DNG_GRINDING_STARTED_AT);
	DNG_PREVIOUS_REP_GROUND = DNG_PREVIOUS_REP_GROUND + (DNG_GetCurrentRepTotal() - DNG_INITIALREP); 
    end
end

function DarnassusGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("DarnassusGrinder"))then	
	GrinderCore_AcknowledgeItemChange("DarnassusGrinder");
	DarnassusGrinder_UpdateDisplayData();
    end

    if(GetTime() > DNG_NEXT_GRIND_UPDATE)then
	DNG_NEXT_GRIND_UPDATE = DNG_NEXT_GRIND_UPDATE + DNG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(DNG_NOW_GRINDING)then	
	    getglobal("DNG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(DNG_PREVIOUS_GRINDING_TIME + (GetTime()-DNG_GRINDING_STARTED_AT)));
	    getglobal("DNG_RepTodayVal"):SetText(FG_GREY..(DNG_PREVIOUS_REP_GROUND + (DNG_GetCurrentRepTotal() - DNG_INITIALREP)));
	    RepPerSecond = ((DNG_PREVIOUS_REP_GROUND + (DNG_GetCurrentRepTotal() - DNG_INITIALREP)) / 
                            math.max(math.floor(DNG_PREVIOUS_GRINDING_TIME + (GetTime()-DNG_GRINDING_STARTED_AT)),1));
	    getglobal("DNG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DNG_TimeToRepUpTodayVal"):SetText(FG_GREY..DNG_TimeToRepUp(RepPerSecond));

	    getglobal("DNG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Darnassus")+DNG_PREVIOUS_GRINDING_TIME + (GetTime()-DNG_GRINDING_STARTED_AT)));
	    getglobal("DNG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Darnassus")+DNG_PREVIOUS_REP_GROUND + (DNG_GetCurrentRepTotal() - DNG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Darnassus")+DNG_PREVIOUS_REP_GROUND + (DNG_GetCurrentRepTotal() - DNG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Darnassus")+DNG_PREVIOUS_GRINDING_TIME + (GetTime()-DNG_GRINDING_STARTED_AT)),1));
	    getglobal("DNG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DNG_TimeToRepUpTotalVal"):SetText(FG_GREY..DNG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("DNG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(DNG_PREVIOUS_GRINDING_TIME));
	    getglobal("DNG_RepTodayVal"):SetText(FG_GREY..(DNG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (DNG_PREVIOUS_REP_GROUND / math.max(DNG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("DNG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DNG_TimeToRepUpTodayVal"):SetText(FG_GREY..DNG_TimeToRepUp(RepPerSecond));

	    getglobal("DNG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Darnassus")+DNG_PREVIOUS_GRINDING_TIME));
	    getglobal("DNG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Darnassus")+DNG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Darnassus")+DNG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Darnassus")+DNG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("DNG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DNG_TimeToRepUpTotalVal"):SetText(FG_GREY..DNG_TimeToRepUp(RepPerSecond));
        end
    end
end

function DNG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DNG_TEXT["Darnassus Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-DNG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function DarnassusGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(DNG_TEXT[itemName]);
    end
end
