--DarkspearTrollsGrinder 1.0
--Written By Tiok - US Thrall

DTG_INITIALREP = 0;

DTG_NOW_GRINDING = false;
DTG_PREVIOUS_GRINDING_TIME = 0;
DTG_GRINDING_STARTED_AT = 0;
DTG_PREVIOUS_REP_GROUND = 0;

DTG_GRIND_UPDATE_INTERVAL = 1;
DTG_NEXT_GRIND_UPDATE = 0;

DTG_REP_VALUE = 0;

DTG_TEXT = 
{
    ["Darkspear Trolls Faction Name"] = "Darkspear Trolls";
    ["DT Rep"] = "DT Rep";

    ["Runecloth"] = "Runecloth";
}

function InstallDarkspearTrollsGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["DarkspearTrollsGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["DarkspearTrollsGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["DarkspearTrollsGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["DarkspearTrollsGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["DarkspearTrollsGrinder"] = "DTG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_DarkspearTrollsLabel");
    FG_DarkspearTrollsLabel:SetFontObject("GameFontNormalSmall");
    FG_DarkspearTrollsLabel:SetText("Darkspear Trolls");
    FG_DarkspearTrollsLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("DarkspearTrollsTexture");
    DarkspearTrollsTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Troll_01");
    DarkspearTrollsTexture:SetWidth(24);
    DarkspearTrollsTexture:SetHeight(24);
    DarkspearTrollsTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    DarkspearTrollsTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_DarkspearTrollsGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_DarkspearTrollsGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function DarkspearTrollsGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function DarkspearTrollsGrinder_Init()
    DTG_NEXT_GRIND_UPDATE = GetTime()+DTG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("DarkspearTrollsGrinder","Runecloth","14047","white");

    DarkspearTrollsGrinder_UpdateDisplayData();
    DarkspearTrollsGrinder_UpdateRepBars();
end

function DarkspearTrollsGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Alt Items"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*75);
    getglobal("DTG_RuneclothCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("DTG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(DTG_REP_VALUE ~= repValue)then
        DTG_REP_VALUE = repValue;
	DarkspearTrollsGrinder_UpdateRepBars();
    end
end

function DarkspearTrollsGrinder_OnLoad()
    DarkspearTrollsGrinder_RegisterEvents();
end

function DarkspearTrollsGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        DarkspearTrollsGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	DarkspearTrollsGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	DarkspearTrollsGrinder_UpdateDisplayData();
	DarkspearTrollsGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	DarkspearTrollsGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Darkspear Trolls",GrinderCore_GetGrindingTime("Darkspear Trolls")+DTG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Darkspear Trolls",GrinderCore_GetRepGround("Darkspear Trolls")+DTG_PREVIOUS_REP_GROUND);
	if(DTG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Darkspear Trolls",GrinderCore_GetGrindingTime("Darkspear Trolls")+(GetTime()-DTG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Darkspear Trolls",GrinderCore_GetRepGround("Darkspear Trolls")+(DTG_GetCurrentRepTotal() - DTG_INITIALREP));
	end
    end
end

function DarkspearTrollsGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	DTG_TEXT = DTG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("DarkspearTrollsGrinderGrindFrame"):SetWidth(215);
	getglobal("DTG_TimeTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("DTG_RepTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("DTG_RepPerHourTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("DTG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("DTG_TimeTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("DTG_RepTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("DTG_RepPerHourTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("DTG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	DTG_TEXT = DTG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("DTG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	DTG_TEXT = DTG_TEXT_ZHTW;

	getglobal("DTG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_DTRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("DTGToRepUpFrame"):SetWidth(90);
	getglobal("DTGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("DTG_SB_ActualRep"):SetWidth(80);
    	getglobal("DTG_SB_RepWithItems"):SetWidth(80);

	getglobal("DarkspearTrollsGrinderGrindFrame"):SetWidth(215);
	getglobal("DTG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("DTG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("DTG_TimeTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("DTG_RepTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("DTG_RepPerHourTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("DTG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("DTG_TimeTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("DTG_RepTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("DTG_RepPerHourTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("DTG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","DarkspearTrollsGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("DTG_DTRep"):SetText(DTG_TEXT["DT Rep"]);
    
    getglobal("DTG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("DTG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("DTG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("DTG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("DTG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("DTG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("DTG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("DTG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("DTG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("DTG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("DTG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("DTG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function DarkspearTrollsGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DTG_TEXT["Darkspear Trolls Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("DTG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(DTG_REP_VALUE/42)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DTG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(DTG_REP_VALUE/21)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DTG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(DTG_REP_VALUE/12)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DTG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(DTG_REP_VALUE/6)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+DTG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(DTG_REP_VALUE/3)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+DTG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(DTG_REP_VALUE/3)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+DTG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(DTG_REP_VALUE/3)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("DTG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("DTG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+DTG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(DTG_REP_VALUE/36)/10;
	getglobal("DTG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("DTG_RepPoints"):SetText((earnedValue+DTG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("DTG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function DarkspearTrollsGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DTG_TEXT["Darkspear Trolls Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-DTG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-DTG_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
    	seventyfive = 82.5;
    end

    local tooltip = getglobal("DTGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..DTG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Alt Items"]) then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Runecloth")then
	numNeeded = 20;
	reward = seventyfive;
	tooltip:AddLine(FG_GREY..numNeeded.." = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/"..numNeeded.." = "..(math.floor(itemCount/numNeeded)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*numNeeded-(itemCount % numNeeded))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
        if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Vehena"].." - "..FG_TEXT["Orgrimmar"].." (37,87)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function DarkspearTrollsGrinder_HideToolTip()
    getglobal("DTGToolTip"):Hide();
end

function DTG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DTG_TEXT["Darkspear Trolls Faction Name"]))) then
	    return earnedValue + DTG_REP_VALUE;
	end
    end
    return DTG_REP_VALUE;
end

function DarkspearTrollsGrinder_ToggleGrinding()
    DTG_NOW_GRINDING = not DTG_NOW_GRINDING;

    local button = getglobal("DTG_BU_ToggleGrinding");
    if(DTG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("DTG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	DTG_GRINDING_STARTED_AT = GetTime();
	DTG_INITIALREP = DTG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("DTG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	DTG_PREVIOUS_GRINDING_TIME = DTG_PREVIOUS_GRINDING_TIME + (GetTime()-DTG_GRINDING_STARTED_AT);
	DTG_PREVIOUS_REP_GROUND = DTG_PREVIOUS_REP_GROUND + (DTG_GetCurrentRepTotal() - DTG_INITIALREP); 
    end
end

function DarkspearTrollsGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("DarkspearTrollsGrinder"))then	
	GrinderCore_AcknowledgeItemChange("DarkspearTrollsGrinder");
	DarkspearTrollsGrinder_UpdateDisplayData();
    end

    if(GetTime() > DTG_NEXT_GRIND_UPDATE)then
	DTG_NEXT_GRIND_UPDATE = DTG_NEXT_GRIND_UPDATE + DTG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(DTG_NOW_GRINDING)then	
	    getglobal("DTG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(DTG_PREVIOUS_GRINDING_TIME + (GetTime()-DTG_GRINDING_STARTED_AT)));
	    getglobal("DTG_RepTodayVal"):SetText(FG_GREY..(DTG_PREVIOUS_REP_GROUND + (DTG_GetCurrentRepTotal() - DTG_INITIALREP)));
	    RepPerSecond = ((DTG_PREVIOUS_REP_GROUND + (DTG_GetCurrentRepTotal() - DTG_INITIALREP)) / 
                            math.max(math.floor(DTG_PREVIOUS_GRINDING_TIME + (GetTime()-DTG_GRINDING_STARTED_AT)),1));
	    getglobal("DTG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DTG_TimeToRepUpTodayVal"):SetText(FG_GREY..DTG_TimeToRepUp(RepPerSecond));

	    getglobal("DTG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Darkspear Trolls")+DTG_PREVIOUS_GRINDING_TIME + (GetTime()-DTG_GRINDING_STARTED_AT)));
	    getglobal("DTG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Darkspear Trolls")+DTG_PREVIOUS_REP_GROUND + (DTG_GetCurrentRepTotal() - DTG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Darkspear Trolls")+DTG_PREVIOUS_REP_GROUND + (DTG_GetCurrentRepTotal() - DTG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Darkspear Trolls")+DTG_PREVIOUS_GRINDING_TIME + (GetTime()-DTG_GRINDING_STARTED_AT)),1));
	    getglobal("DTG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DTG_TimeToRepUpTotalVal"):SetText(FG_GREY..DTG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("DTG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(DTG_PREVIOUS_GRINDING_TIME));
	    getglobal("DTG_RepTodayVal"):SetText(FG_GREY..(DTG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (DTG_PREVIOUS_REP_GROUND / math.max(DTG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("DTG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DTG_TimeToRepUpTodayVal"):SetText(FG_GREY..DTG_TimeToRepUp(RepPerSecond));

	    getglobal("DTG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Darkspear Trolls")+DTG_PREVIOUS_GRINDING_TIME));
	    getglobal("DTG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Darkspear Trolls")+DTG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Darkspear Trolls")+DTG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Darkspear Trolls")+DTG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("DTG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("DTG_TimeToRepUpTotalVal"):SetText(FG_GREY..DTG_TimeToRepUp(RepPerSecond));
        end
    end
end

function DTG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, DTG_TEXT["Darkspear Trolls Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-DTG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function DarkspearTrollsGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(DTG_TEXT[itemName]);
    end
end
