--WildhammerClanGrinder 1.0
--Written By Tiok - US Thrall

WCG_INITIALREP = 0;

WCG_NOW_GRINDING = false;
WCG_PREVIOUS_GRINDING_TIME = 0;
WCG_GRINDING_STARTED_AT = 0;
WCG_PREVIOUS_REP_GROUND = 0;

WCG_GRIND_UPDATE_INTERVAL = 1;
WCG_NEXT_GRIND_UPDATE = 0;

WCG_REP_VALUE = 0;

WCG_TEXT = 
{
    ["Wildhammer Clan Faction Name"] = "Wildhammer Clan";
    ["WC Rep"] = "WC Rep";

    ["Troll Tribal Necklace"] = "Troll Tribal Necklace";
}

function WildhammerClanGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function WildhammerClanGrinder_Init()
    WCG_NEXT_GRIND_UPDATE = GetTime()+WCG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("WildhammerClanGrinder","Troll Tribal Necklace","9259","white");

    WildhammerClanGrinder_UpdateDisplayData();
    WildhammerClanGrinder_UpdateRepBars();
end

function WildhammerClanGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Troll Tribal Necklace";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/5)*25);
    getglobal("WCG_TrollTribalNecklaceCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("WCG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(WCG_REP_VALUE ~= repValue)then
        WCG_REP_VALUE = repValue;
	WildhammerClanGrinder_UpdateRepBars();
    end
end

function WildhammerClanGrinder_OnLoad()
    WildhammerClanGrinder_RegisterEvents();
end

function WildhammerClanGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        WildhammerClanGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	WildhammerClanGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	WildhammerClanGrinder_UpdateDisplayData();
	WildhammerClanGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	WildhammerClanGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Wildhammer Clan",GrinderCore_GetGrindingTime("Wildhammer Clan")+WCG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Wildhammer Clan",GrinderCore_GetRepGround("Wildhammer Clan")+WCG_PREVIOUS_REP_GROUND);
	if(WCG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Wildhammer Clan",GrinderCore_GetGrindingTime("Wildhammer Clan")+(GetTime()-WCG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Wildhammer Clan",GrinderCore_GetRepGround("Wildhammer Clan")+(WCG_GetCurrentRepTotal() - WCG_INITIALREP));
	end
    end
end

function WildhammerClanGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	WCG_TEXT = WCG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("WildhammerClanGrinderGrindFrame"):SetWidth(215);
	getglobal("WCG_TimeTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("WCG_RepTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("WCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("WCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("WCG_TimeTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("WCG_RepTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("WCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("WCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	WCG_TEXT = WCG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("WCG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	WCG_TEXT = WCG_TEXT_ZHTW;

	getglobal("WCG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_WCRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("WCGToRepUpFrame"):SetWidth(90);
	getglobal("WCGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("WCG_SB_ActualRep"):SetWidth(80);
    	getglobal("WCG_SB_RepWithItems"):SetWidth(80);

	getglobal("WildhammerClanGrinderGrindFrame"):SetWidth(215);
	getglobal("WCG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("WCG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("WCG_TimeTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("WCG_RepTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("WCG_RepPerHourTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("WCG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("WCG_TimeTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("WCG_RepTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("WCG_RepPerHourTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("WCG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","WildhammerClanGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("WCG_WCRep"):SetText(WCG_TEXT["WC Rep"]);
    
    getglobal("WCG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("WCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("WCG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("WCG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("WCG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("WCG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("WCG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("WCG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("WCG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("WCG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("WCG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("WCG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function WildhammerClanGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;
    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, WCG_TEXT["Wildhammer Clan Faction Name"]))) then
            if(standingId==8)then --Exalted
		getglobal("WCG_SB_ActualRep"):SetValue(100);
		repPercent = 100;
		itemPercent = math.floor(WCG_REP_VALUE/42)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE-42000).."/1000");
	    elseif(standingId==7)then --Revered
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+WCG_REP_VALUE-21000)/210)));
		repPercent = math.floor((earnedValue-21000)/21)/10;
		itemPercent = math.floor(WCG_REP_VALUE/21)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE-21000).."/21000");
	    elseif(standingId==6)then --Honored
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+WCG_REP_VALUE-9000)/120)));
		repPercent = math.floor((earnedValue-9000)/12)/10;
		itemPercent = math.floor(WCG_REP_VALUE/12)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE-9000).."/12000");
	    elseif(standingId==5)then --Friendly
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+WCG_REP_VALUE-3000)/60)));
		repPercent = math.floor((earnedValue-3000)/6)/10;
		itemPercent = math.floor(WCG_REP_VALUE/6)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE-3000).."/6000");
	    elseif(standingId==4)then --Neutral
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+WCG_REP_VALUE)/30)));
		repPercent = math.floor(earnedValue/3)/10;
		itemPercent = math.floor(WCG_REP_VALUE/3)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE).."/3000");
	    elseif(standingId==3)then --Unfriendly (-3000 to 0)
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+WCG_REP_VALUE)/30)));
		repPercent = math.floor((3000+earnedValue)/3)/10;
		itemPercent = math.floor(WCG_REP_VALUE/3)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE+3000).."/3000");
	    elseif(standingId==2)then --Hostile (-6000 to -3000)
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+WCG_REP_VALUE)/30)));
		repPercent = math.floor((6000+earnedValue)/3)/10;
		itemPercent = math.floor(WCG_REP_VALUE/3)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE+6000).."/3000");
	    elseif(standingId==1)then --Hated (-42000 to -6000)
		getglobal("WCG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
		getglobal("WCG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+WCG_REP_VALUE)/360)));
		repPercent = math.floor((42000+earnedValue)/36)/10;
		itemPercent = math.floor(WCG_REP_VALUE/36)/10;
		getglobal("WCG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
		getglobal("WCG_RepPoints"):SetText((earnedValue+WCG_REP_VALUE+42000).."/36000");
            end
        end
    end
    totalPercent = repPercent + itemPercent;
    getglobal("WCG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function WildhammerClanGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, WCG_TEXT["Wildhammer Clan Faction Name"]))) then
	    if(standingId == 8)then --exalted
		RepToRepUp = 0;
	    else
		RepToRepUp = math.max(topValue-earnedValue-WCG_REP_VALUE,0);
	    end
	end
    end

    local twentyfive = 25;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
    end

    local tooltip = getglobal("WCGToolTip");
    tooltip:SetOwner(button,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..WCG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Troll Tribal Necklace")then
	tooltip:AddLine(FG_GREY.."5 = "..twentyfive.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*twentyfive).." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/twentyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function WildhammerClanGrinder_HideToolTip()
    getglobal("WCGToolTip"):Hide();
end

function WCG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, WCG_TEXT["Wildhammer Clan Faction Name"]))) then
	    return earnedValue + WCG_REP_VALUE;
	end
    end
    return 0;
end

function WildhammerClanGrinder_ToggleGrinding()
    WCG_NOW_GRINDING = not WCG_NOW_GRINDING;

    local button = getglobal("WCG_BU_ToggleGrinding");
    if(WCG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("WCG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	WCG_GRINDING_STARTED_AT = GetTime();
	WCG_INITIALREP = WCG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("WCG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	WCG_PREVIOUS_GRINDING_TIME = WCG_PREVIOUS_GRINDING_TIME + (GetTime()-WCG_GRINDING_STARTED_AT);
	WCG_PREVIOUS_REP_GROUND = WCG_PREVIOUS_REP_GROUND + (WCG_GetCurrentRepTotal() - WCG_INITIALREP); 
    end
end

function WildhammerClanGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("WildhammerClanGrinder"))then	
	GrinderCore_AcknowledgeItemChange("WildhammerClanGrinder");
	WildhammerClanGrinder_UpdateDisplayData();
    end

    if(GetTime() > WCG_NEXT_GRIND_UPDATE)then
	WCG_NEXT_GRIND_UPDATE = WCG_NEXT_GRIND_UPDATE + WCG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(WCG_NOW_GRINDING)then	
	    getglobal("WCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(WCG_PREVIOUS_GRINDING_TIME + (GetTime()-WCG_GRINDING_STARTED_AT)));
	    getglobal("WCG_RepTodayVal"):SetText(FG_GREY..(WCG_PREVIOUS_REP_GROUND + (WCG_GetCurrentRepTotal() - WCG_INITIALREP)));
	    RepPerSecond = ((WCG_PREVIOUS_REP_GROUND + (WCG_GetCurrentRepTotal() - WCG_INITIALREP)) / 
                            math.max(math.floor(WCG_PREVIOUS_GRINDING_TIME + (GetTime()-WCG_GRINDING_STARTED_AT)),1));
	    getglobal("WCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("WCG_TimeToRepUpTodayVal"):SetText(FG_GREY..WCG_TimeToRepUp(RepPerSecond));

	    getglobal("WCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Wildhammer Clan")+WCG_PREVIOUS_GRINDING_TIME + (GetTime()-WCG_GRINDING_STARTED_AT)));
	    getglobal("WCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Wildhammer Clan")+WCG_PREVIOUS_REP_GROUND + (WCG_GetCurrentRepTotal() - WCG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Wildhammer Clan")+WCG_PREVIOUS_REP_GROUND + (WCG_GetCurrentRepTotal() - WCG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Wildhammer Clan")+WCG_PREVIOUS_GRINDING_TIME + (GetTime()-WCG_GRINDING_STARTED_AT)),1));
	    getglobal("WCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("WCG_TimeToRepUpTotalVal"):SetText(FG_GREY..WCG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("WCG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(WCG_PREVIOUS_GRINDING_TIME));
	    getglobal("WCG_RepTodayVal"):SetText(FG_GREY..(WCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (WCG_PREVIOUS_REP_GROUND / math.max(WCG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("WCG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("WCG_TimeToRepUpTodayVal"):SetText(FG_GREY..WCG_TimeToRepUp(RepPerSecond));

	    getglobal("WCG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Wildhammer Clan")+WCG_PREVIOUS_GRINDING_TIME));
	    getglobal("WCG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Wildhammer Clan")+WCG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Wildhammer Clan")+WCG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Wildhammer Clan")+WCG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("WCG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("WCG_TimeToRepUpTotalVal"):SetText(FG_GREY..WCG_TimeToRepUp(RepPerSecond));
        end
    end
end

function WCG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, WCG_TEXT["Wildhammer Clan Faction Name"]))) then
	    if(standingId == 8)then --exalted
		return "-----";
	    else
		local RepToRepUp = math.max(topValue-earnedValue-WCG_REP_VALUE,0);
		return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
	    end
	end
    end
    return "-----";
end

function WildhammerClanGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(WCG_TEXT[itemName]);
    end
end
