--ConsortiumGrinder 1.0
--Written By Tiok - US Thrall

COG_INITIALREP = 0;

COG_NOW_GRINDING = false;
COG_PREVIOUS_GRINDING_TIME = 0;
COG_GRINDING_STARTED_AT = 0;
COG_PREVIOUS_REP_GROUND = 0;

COG_GRIND_UPDATE_INTERVAL = 1;
COG_NEXT_GRIND_UPDATE = 0;

COG_REP_VALUE = 0;

COG_TEXT = 
{
    ["Consortium Faction Name"] = "The Consortium";
    ["Co Rep"] = "Co Rep";

    ["Pair of Ivory Tusks"] = "Pair of Ivory Tusks";
    ["Oshu'gun Crystal Fragment"] = "Oshu'gun Crystal Fragment";
    ["Obsidian Warbeads"] = "Obsidian Warbeads";
    ["Zaxxis Insignia"] = "Zaxxis Insignia";
}

function InstallConsortiumGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ConsortiumGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ConsortiumGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ConsortiumGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ConsortiumGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ConsortiumGrinder"] = "COG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_ConsortiumLabel");
    FG_ConsortiumLabel:SetFontObject("GameFontNormalSmall");
    FG_ConsortiumLabel:SetText("The Consortium");
    FG_ConsortiumLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("ConsortiumTexture");
    ConsortiumTexture:SetTexture("Interface\\Icons\\INV_Misc_Bone_04");
    ConsortiumTexture:SetWidth(24);
    ConsortiumTexture:SetHeight(24);
    ConsortiumTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    ConsortiumTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ConsortiumGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ConsortiumGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function ConsortiumGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function ConsortiumGrinder_Init()
    COG_NEXT_GRIND_UPDATE = GetTime()+COG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ConsortiumGrinder","Pair of Ivory Tusks","25463","white");
    GrinderCore_RegisterItem("ConsortiumGrinder","Oshu'gun Crystal Fragment","25416","white");
    GrinderCore_RegisterItem("ConsortiumGrinder","Obsidian Warbeads","25433","white");
    GrinderCore_RegisterItem("ConsortiumGrinder","Zaxxis Insignia","29209","white");

    ConsortiumGrinder_UpdateDisplayData();
    ConsortiumGrinder_UpdateRepBars();
end

function ConsortiumGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, COG_TEXT["Consortium Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    itemName = "Pair of Ivory Tusks";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId == 4)then
        repValue = repValue + math.floor(itemCount/3)*250;
    end
    getglobal("COG_PairofIvoryTusksCount"):SetText(itemCount.."/3");

    itemName = "Oshu'gun Crystal Fragment";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId == 4)then
        repValue = repValue + math.floor(itemCount/10)*250;
    end
    getglobal("COG_OshugunCrystalFragmentCount"):SetText(itemCount.."/10");

    itemName = "Obsidian Warbeads";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + math.floor(itemCount/10)*250;
    end
    getglobal("COG_ObsidianWarbeadsCount"):SetText(itemCount.."/10");

    itemName = "Zaxxis Insignia";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + math.floor(itemCount/10)*250;
    end
    getglobal("COG_ZaxxisInsigniaCount"):SetText(itemCount.."/10");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("COG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(COG_REP_VALUE ~= repValue)then
        COG_REP_VALUE = repValue;
	ConsortiumGrinder_UpdateRepBars();
    end
end

function ConsortiumGrinder_OnLoad()
    ConsortiumGrinder_RegisterEvents();
end

function ConsortiumGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ConsortiumGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ConsortiumGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ConsortiumGrinder_UpdateDisplayData();
	ConsortiumGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ConsortiumGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("The Consortium",GrinderCore_GetGrindingTime("The Consortium")+COG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("The Consortium",GrinderCore_GetRepGround("The Consortium")+COG_PREVIOUS_REP_GROUND);
	if(COG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("The Consortium",GrinderCore_GetGrindingTime("The Consortium")+(GetTime()-COG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("The Consortium",GrinderCore_GetRepGround("The Consortium")+(COG_GetCurrentRepTotal() - COG_INITIALREP));
	end
    end
end

function ConsortiumGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	COG_TEXT = COG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ConsortiumGrinderGrindFrame"):SetWidth(215);
	getglobal("COG_TimeTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("COG_RepTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("COG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("COG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("COG_TimeTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("COG_RepTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("COG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("COG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	COG_TEXT = COG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("COG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	COG_TEXT = COG_TEXT_ZHTW;

	getglobal("COG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_CoRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("COGToRepUpFrame"):SetWidth(90);
	getglobal("COGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("COG_SB_ActualRep"):SetWidth(80);
    	getglobal("COG_SB_RepWithItems"):SetWidth(80);

	getglobal("ConsortiumGrinderGrindFrame"):SetWidth(215);
	getglobal("COG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("COG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("COG_TimeTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("COG_RepTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("COG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("COG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("COG_TimeTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("COG_RepTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("COG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("COG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ConsortiumGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("COG_CoRep"):SetText(COG_TEXT["Co Rep"]);
    
    getglobal("COG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("COG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("COG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("COG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("COG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("COG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("COG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("COG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("COG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("COG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("COG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("COG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ConsortiumGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, COG_TEXT["Consortium Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("COG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(COG_REP_VALUE/42)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+COG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(COG_REP_VALUE/21)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+COG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(COG_REP_VALUE/12)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+COG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(COG_REP_VALUE/6)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("COG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+COG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(COG_REP_VALUE/3)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+COG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(COG_REP_VALUE/3)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+COG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(COG_REP_VALUE/3)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("COG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("COG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+COG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(COG_REP_VALUE/36)/10;
	getglobal("COG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("COG_RepPoints"):SetText((earnedValue+COG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("COG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ConsortiumGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, COG_TEXT["Consortium Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-COG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-COG_REP_VALUE,0);
    end

    local twofifty = 250;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twofifty = 275;
    end

    local tooltip = getglobal("COGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..COG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Pair of Ivory Tusks")then
	reward = twofifty;
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREY.."3 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/3 = "..(math.floor(itemCount/3)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*3-(itemCount % 3))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Shadrek"].." - "..FG_TEXT["Nagrand"].." (32,57)");
    elseif(text=="Oshu'gun Crystal Fragment")then
	reward = twofifty;
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]);
            tooltip:AddLine(" ");
        end
	if(standingId == 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Gezhe"].." - "..FG_TEXT["Nagrand"].." (31,58)");
    elseif(text=="Obsidian Warbeads")then
	reward = twofifty;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Gezhe"].." - "..FG_TEXT["Nagrand"].." (31,58)");
    elseif(text=="Zaxxis Insignia")then
	reward = twofifty;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	if(UnitLevel("player") >= 68)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 68");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 68");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Nether-Stalker Khay'ji"].." - "..FG_TEXT["Netherstorm"].." (32,64)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ConsortiumGrinder_HideToolTip()
    getglobal("COGToolTip"):Hide();
end

function COG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, COG_TEXT["Consortium Faction Name"]))) then
	    return earnedValue + COG_REP_VALUE;
	end
    end
    return COG_REP_VALUE;
end

function ConsortiumGrinder_ToggleGrinding()
    COG_NOW_GRINDING = not COG_NOW_GRINDING;

    local button = getglobal("COG_BU_ToggleGrinding");
    if(COG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("COG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	COG_GRINDING_STARTED_AT = GetTime();
	COG_INITIALREP = COG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("COG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	COG_PREVIOUS_GRINDING_TIME = COG_PREVIOUS_GRINDING_TIME + (GetTime()-COG_GRINDING_STARTED_AT);
	COG_PREVIOUS_REP_GROUND = COG_PREVIOUS_REP_GROUND + (COG_GetCurrentRepTotal() - COG_INITIALREP); 
    end
end

function ConsortiumGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ConsortiumGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ConsortiumGrinder");
	ConsortiumGrinder_UpdateDisplayData();
    end

    if(GetTime() > COG_NEXT_GRIND_UPDATE)then
	COG_NEXT_GRIND_UPDATE = COG_NEXT_GRIND_UPDATE + COG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(COG_NOW_GRINDING)then	
	    getglobal("COG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(COG_PREVIOUS_GRINDING_TIME + (GetTime()-COG_GRINDING_STARTED_AT)));
	    getglobal("COG_RepTodayVal"):SetText(FG_GREY..(COG_PREVIOUS_REP_GROUND + (COG_GetCurrentRepTotal() - COG_INITIALREP)));
	    RepPerSecond = ((COG_PREVIOUS_REP_GROUND + (COG_GetCurrentRepTotal() - COG_INITIALREP)) / 
                            math.max(math.floor(COG_PREVIOUS_GRINDING_TIME + (GetTime()-COG_GRINDING_STARTED_AT)),1));
	    getglobal("COG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("COG_TimeToRepUpTodayVal"):SetText(FG_GREY..COG_TimeToRepUp(RepPerSecond));

	    getglobal("COG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Consortium")+COG_PREVIOUS_GRINDING_TIME + (GetTime()-COG_GRINDING_STARTED_AT)));
	    getglobal("COG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Consortium")+COG_PREVIOUS_REP_GROUND + (COG_GetCurrentRepTotal() - COG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Consortium")+COG_PREVIOUS_REP_GROUND + (COG_GetCurrentRepTotal() - COG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Consortium")+COG_PREVIOUS_GRINDING_TIME + (GetTime()-COG_GRINDING_STARTED_AT)),1));
	    getglobal("COG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("COG_TimeToRepUpTotalVal"):SetText(FG_GREY..COG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("COG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(COG_PREVIOUS_GRINDING_TIME));
	    getglobal("COG_RepTodayVal"):SetText(FG_GREY..(COG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (COG_PREVIOUS_REP_GROUND / math.max(COG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("COG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("COG_TimeToRepUpTodayVal"):SetText(FG_GREY..COG_TimeToRepUp(RepPerSecond));

	    getglobal("COG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("The Consortium")+COG_PREVIOUS_GRINDING_TIME));
	    getglobal("COG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("The Consortium")+COG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("The Consortium")+COG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("The Consortium")+COG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("COG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("COG_TimeToRepUpTotalVal"):SetText(FG_GREY..COG_TimeToRepUp(RepPerSecond));
        end
    end
end

function COG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, COG_TEXT["Consortium Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-COG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ConsortiumGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(COG_TEXT[itemName]);
    end
end
