--CenarionExpeditionGrinder 1.0
--Written By Tiok - US Thrall

CEG_INITIALREP = 0;

CEG_NOW_GRINDING = false;
CEG_PREVIOUS_GRINDING_TIME = 0;
CEG_GRINDING_STARTED_AT = 0;
CEG_PREVIOUS_REP_GROUND = 0;

CEG_GRIND_UPDATE_INTERVAL = 1;
CEG_NEXT_GRIND_UPDATE = 0;

CEG_REP_VALUE = 0;

CEG_TEXT = 
{
    ["Cenarion Expedition Faction Name"] = "Cenarion Expedition";
    ["CE Rep"] = "CE Rep";

    ["Unidentified Plant Parts"] = "Unidentified Plant Parts";
    ["Coilfang Armaments"] = "Coilfang Armaments";
}

function InstallCenarionExpeditionGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["CenarionExpeditionGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["CenarionExpeditionGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["CenarionExpeditionGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["CenarionExpeditionGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["CenarionExpeditionGrinder"] = "CEG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_CenarionExpeditionLabel");
    FG_CenarionExpeditionLabel:SetFontObject("GameFontNormalSmall");
    FG_CenarionExpeditionLabel:SetText("Cenarion Expedition");
    FG_CenarionExpeditionLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("CenarionExpeditionTexture");
    CenarionExpeditionTexture:SetTexture("Interface\\Icons\\INV_Misc_Flower_03");
    CenarionExpeditionTexture:SetWidth(24);
    CenarionExpeditionTexture:SetHeight(24);
    CenarionExpeditionTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    CenarionExpeditionTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_CenarionExpeditionGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_CenarionExpeditionGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function CenarionExpeditionGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function CenarionExpeditionGrinder_Init()
    CEG_NEXT_GRIND_UPDATE = GetTime()+CEG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("CenarionExpeditionGrinder","Unidentified Plant Parts","24401","white");
    GrinderCore_RegisterItem("CenarionExpeditionGrinder","Coilfang Armaments","24368","white");

    CenarionExpeditionGrinder_UpdateDisplayData();
    CenarionExpeditionGrinder_UpdateRepBars();
end

function CenarionExpeditionGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, CEG_TEXT["Cenarion Expedition Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    itemName = "Unidentified Plant Parts";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId <= 5)then
        repValue = repValue + math.floor(itemCount/10)*250;
    end
    getglobal("CEG_UnidentifiedPlantPartsCount"):SetText(itemCount.."/10");

    itemName = "Coilfang Armaments";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 5)then
        repValue = repValue + itemCount*75;
    end
    getglobal("CEG_CoilfangArmamentsCount"):SetText(itemCount.."/1");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("CEG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(CEG_REP_VALUE ~= repValue)then
        CEG_REP_VALUE = repValue;
	CenarionExpeditionGrinder_UpdateRepBars();
    end
end

function CenarionExpeditionGrinder_OnLoad()
    CenarionExpeditionGrinder_RegisterEvents();
end

function CenarionExpeditionGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        CenarionExpeditionGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	CenarionExpeditionGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	CenarionExpeditionGrinder_UpdateDisplayData();
	CenarionExpeditionGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	CenarionExpeditionGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Cenarion Expedition",GrinderCore_GetGrindingTime("Cenarion Expedition")+CEG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Cenarion Expedition",GrinderCore_GetRepGround("Cenarion Expedition")+CEG_PREVIOUS_REP_GROUND);
	if(CEG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Cenarion Expedition",GrinderCore_GetGrindingTime("Cenarion Expedition")+(GetTime()-CEG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Cenarion Expedition",GrinderCore_GetRepGround("Cenarion Expedition")+(CEG_GetCurrentRepTotal() - CEG_INITIALREP));
	end
    end
end

function CenarionExpeditionGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	CEG_TEXT = CEG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("CenarionExpeditionGrinderGrindFrame"):SetWidth(215);
	getglobal("CEG_TimeTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("CEG_RepTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("CEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("CEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("CEG_TimeTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("CEG_RepTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("CEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("CEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	CEG_TEXT = CEG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("CEG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	CEG_TEXT = CEG_TEXT_ZHTW;

	getglobal("CEG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_CERep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("CEGToRepUpFrame"):SetWidth(90);
	getglobal("CEGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("CEG_SB_ActualRep"):SetWidth(80);
    	getglobal("CEG_SB_RepWithItems"):SetWidth(80);

	getglobal("CenarionExpeditionGrinderGrindFrame"):SetWidth(215);
	getglobal("CEG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("CEG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("CEG_TimeTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("CEG_RepTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("CEG_RepPerHourTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("CEG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("CEG_TimeTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("CEG_RepTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("CEG_RepPerHourTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("CEG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","CenarionExpeditionGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("CEG_CERep"):SetText(CEG_TEXT["CE Rep"]);
    
    getglobal("CEG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("CEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("CEG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("CEG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("CEG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("CEG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("CEG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("CEG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("CEG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("CEG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("CEG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("CEG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function CenarionExpeditionGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, CEG_TEXT["Cenarion Expedition Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("CEG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(CEG_REP_VALUE/42)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+CEG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(CEG_REP_VALUE/21)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+CEG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(CEG_REP_VALUE/12)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+CEG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(CEG_REP_VALUE/6)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+CEG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(CEG_REP_VALUE/3)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+CEG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(CEG_REP_VALUE/3)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+CEG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(CEG_REP_VALUE/3)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("CEG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("CEG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+CEG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(CEG_REP_VALUE/36)/10;
	getglobal("CEG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("CEG_RepPoints"):SetText((earnedValue+CEG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("CEG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function CenarionExpeditionGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, CEG_TEXT["Cenarion Expedition Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-CEG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-CEG_REP_VALUE,0);
    end

    local seventyfive = 75;
    local twofifty = 250;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
	twofifty = 275;
    end

    local tooltip = getglobal("CEGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..CEG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Unidentified Plant Parts")then
	reward = twofifty;
	if(standingId <= 5)then
	    tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end	    
            tooltip:AddLine(" ");
        end
	if(standingId <= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or lower"]);
	end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Lauranna Thar'well"].." - "..FG_TEXT["Zangarmarsh"].." (80,64)");
    elseif(text=="Coilfang Armaments")then
	reward = seventyfive;
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Friendly or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Friendly or better"]);
	end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Ysiel Windsinger"].." - "..FG_TEXT["Zangarmarsh"].." (78,62)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function CenarionExpeditionGrinder_HideToolTip()
    getglobal("CEGToolTip"):Hide();
end

function CEG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, CEG_TEXT["Cenarion Expedition Faction Name"]))) then
	    return earnedValue + CEG_REP_VALUE;
	end
    end
    return CEG_REP_VALUE;
end

function CenarionExpeditionGrinder_ToggleGrinding()
    CEG_NOW_GRINDING = not CEG_NOW_GRINDING;

    local button = getglobal("CEG_BU_ToggleGrinding");
    if(CEG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("CEG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	CEG_GRINDING_STARTED_AT = GetTime();
	CEG_INITIALREP = CEG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("CEG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	CEG_PREVIOUS_GRINDING_TIME = CEG_PREVIOUS_GRINDING_TIME + (GetTime()-CEG_GRINDING_STARTED_AT);
	CEG_PREVIOUS_REP_GROUND = CEG_PREVIOUS_REP_GROUND + (CEG_GetCurrentRepTotal() - CEG_INITIALREP); 
    end
end

function CenarionExpeditionGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("CenarionExpeditionGrinder"))then	
	GrinderCore_AcknowledgeItemChange("CenarionExpeditionGrinder");
	CenarionExpeditionGrinder_UpdateDisplayData();
    end

    if(GetTime() > CEG_NEXT_GRIND_UPDATE)then
	CEG_NEXT_GRIND_UPDATE = CEG_NEXT_GRIND_UPDATE + CEG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(CEG_NOW_GRINDING)then	
	    getglobal("CEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(CEG_PREVIOUS_GRINDING_TIME + (GetTime()-CEG_GRINDING_STARTED_AT)));
	    getglobal("CEG_RepTodayVal"):SetText(FG_GREY..(CEG_PREVIOUS_REP_GROUND + (CEG_GetCurrentRepTotal() - CEG_INITIALREP)));
	    RepPerSecond = ((CEG_PREVIOUS_REP_GROUND + (CEG_GetCurrentRepTotal() - CEG_INITIALREP)) / 
                            math.max(math.floor(CEG_PREVIOUS_GRINDING_TIME + (GetTime()-CEG_GRINDING_STARTED_AT)),1));
	    getglobal("CEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("CEG_TimeToRepUpTodayVal"):SetText(FG_GREY..CEG_TimeToRepUp(RepPerSecond));

	    getglobal("CEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("CenarionExpedition")+CEG_PREVIOUS_GRINDING_TIME + (GetTime()-CEG_GRINDING_STARTED_AT)));
	    getglobal("CEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("CenarionExpedition")+CEG_PREVIOUS_REP_GROUND + (CEG_GetCurrentRepTotal() - CEG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("CenarionExpedition")+CEG_PREVIOUS_REP_GROUND + (CEG_GetCurrentRepTotal() - CEG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("CenarionExpedition")+CEG_PREVIOUS_GRINDING_TIME + (GetTime()-CEG_GRINDING_STARTED_AT)),1));
	    getglobal("CEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("CEG_TimeToRepUpTotalVal"):SetText(FG_GREY..CEG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("CEG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(CEG_PREVIOUS_GRINDING_TIME));
	    getglobal("CEG_RepTodayVal"):SetText(FG_GREY..(CEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (CEG_PREVIOUS_REP_GROUND / math.max(CEG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("CEG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("CEG_TimeToRepUpTodayVal"):SetText(FG_GREY..CEG_TimeToRepUp(RepPerSecond));

	    getglobal("CEG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("CenarionExpedition")+CEG_PREVIOUS_GRINDING_TIME));
	    getglobal("CEG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("CenarionExpedition")+CEG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("CenarionExpedition")+CEG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("CenarionExpedition")+CEG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("CEG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("CEG_TimeToRepUpTotalVal"):SetText(FG_GREY..CEG_TimeToRepUp(RepPerSecond));
        end
    end
end

function CEG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, CEG_TEXT["Cenarion Expedition Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-CEG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function CenarionExpeditionGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(CEG_TEXT[itemName]);
    end
end
