--BroodofNozdormuGrinder 1.0
--Written By Tiok - US Thrall

BNG_INITIALREP = 0;

BNG_NOW_GRINDING = false;
BNG_PREVIOUS_GRINDING_TIME = 0;
BNG_GRINDING_STARTED_AT = 0;
BNG_PREVIOUS_REP_GROUND = 0;

BNG_GRIND_UPDATE_INTERVAL = 1;
BNG_NEXT_GRIND_UPDATE = 0;

BNG_REP_VALUE = 0;

BNG_TEXT = 
{
    ["Brood of Nozdormu Faction Name"] = "Brood of Nozdormu";
    ["BN Rep"] = "BN Rep";

    ["Silithid Carapace Fragment"] = "Silithid Carapace Fragment";
    ["Qiraji Lord's Insignia"] = "Qiraji Lord's Insignia";
    ["Ancient Qiraji Artifact"] = "Ancient Qiraji Artifact";
}

function InstallBroodofNozdormuGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["BroodofNozdormuGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["BroodofNozdormuGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["BroodofNozdormuGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["BroodofNozdormuGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["BroodofNozdormuGrinder"] = "BNG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_BroodofNozdormuLabel");
    FG_BroodofNozdormuLabel:SetFontObject("GameFontNormalSmall");
    FG_BroodofNozdormuLabel:SetText("Brood of Nozdormu");
    FG_BroodofNozdormuLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("BroodofNozdormuTexture");
    BroodofNozdormuTexture:SetTexture("Interface\\Icons\\INV_Misc_Head_Dragon_01");
    BroodofNozdormuTexture:SetWidth(24);
    BroodofNozdormuTexture:SetHeight(24);
    BroodofNozdormuTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    BroodofNozdormuTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_BroodofNozdormuGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_BroodofNozdormuGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function BroodofNozdormuGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function BroodofNozdormuGrinder_Init()
    BNG_NEXT_GRIND_UPDATE = GetTime()+BNG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("BroodofNozdormuGrinder","Silithid Carapace Fragment","20384","white");
    GrinderCore_RegisterItem("BroodofNozdormuGrinder","Qiraji Lord's Insignia","21229","white");
    GrinderCore_RegisterItem("BroodofNozdormuGrinder","Ancient Qiraji Artifact","21230","white");

    BroodofNozdormuGrinder_UpdateDisplayData();
    BroodofNozdormuGrinder_UpdateRepBars();
end

function BroodofNozdormuGrinder_UpdateDisplayData()
    local factionLevel = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,factionLevel,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BNG_TEXT["Brood of Nozdormu Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	factionLevel = 1;
	earnedValue = -42000;
    end

    local repValue = 0;

    local itemCount, itemName;

    itemName = "Silithid Carapace Fragment";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end;
    if(factionLevel <= 3)then
        repValue = repValue + (math.floor(itemCount/200)*500);
    end
    getglobal("BNG_SilithidCarapaceFragmentCount"):SetText(itemCount.."/200");

    itemName = "Qiraji Lord's Insignia";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*500);
    getglobal("BNG_QirajiLordsInsigniaCount"):SetText(itemCount);

    itemName = "Ancient Qiraji Artifact";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*1000);
    getglobal("BNG_AncientQirajiArtifactCount"):SetText(itemCount);

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("BNG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(BNG_REP_VALUE ~= repValue)then
        BNG_REP_VALUE = repValue;
	BroodofNozdormuGrinder_UpdateRepBars();
    end
end

function BroodofNozdormuGrinder_OnLoad()
    BroodofNozdormuGrinder_RegisterEvents();
end

function BroodofNozdormuGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        BroodofNozdormuGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	BroodofNozdormuGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	BroodofNozdormuGrinder_UpdateDisplayData();
	BroodofNozdormuGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	BroodofNozdormuGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Brood of Nozdormu",GrinderCore_GetGrindingTime("Brood of Nozdormu")+BNG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Brood of Nozdormu",GrinderCore_GetRepGround("Brood of Nozdormu")+BNG_PREVIOUS_REP_GROUND);
	if(BNG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Brood of Nozdormu",GrinderCore_GetGrindingTime("Brood of Nozdormu")+(GetTime()-BNG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Brood of Nozdormu",GrinderCore_GetRepGround("Brood of Nozdormu")+(BNG_GetCurrentRepTotal() - BNG_INITIALREP));
	end
    end
end

function BroodofNozdormuGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	BNG_TEXT = BNG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("BroodofNozdormuGrinderGrindFrame"):SetWidth(215);
	getglobal("BNG_TimeTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("BNG_RepTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("BNG_RepPerHourTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("BNG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("BNG_TimeTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("BNG_RepTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("BNG_RepPerHourTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("BNG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	BNG_TEXT = BNG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("BNG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	BNG_TEXT = BNG_TEXT_ZHTW;

	getglobal("BNG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_BNRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("BNGToRepUpFrame"):SetWidth(90);
	getglobal("BNGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("BNG_SB_ActualRep"):SetWidth(80);
    	getglobal("BNG_SB_RepWithItems"):SetWidth(80);

	getglobal("BroodofNozdormuGrinderGrindFrame"):SetWidth(215);
	getglobal("BNG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BNG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("BNG_TimeTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("BNG_RepTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("BNG_RepPerHourTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("BNG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("BNG_TimeTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("BNG_RepTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("BNG_RepPerHourTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("BNG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","BroodofNozdormuGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("BNG_BNRep"):SetText(BNG_TEXT["BN Rep"]);
    
    getglobal("BNG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("BNG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("BNG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("BNG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("BNG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("BNG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("BNG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("BNG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("BNG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("BNG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("BNG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("BNG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function BroodofNozdormuGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BNG_TEXT["Brood of Nozdormu Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 1;
	earnedValue = -42000;
    end

    if(standingId==8)then --Exalted
	getglobal("BNG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(BNG_REP_VALUE/42)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BNG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(BNG_REP_VALUE/21)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BNG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(BNG_REP_VALUE/12)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BNG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(BNG_REP_VALUE/6)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BNG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(BNG_REP_VALUE/3)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+BNG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(BNG_REP_VALUE/3)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+BNG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(BNG_REP_VALUE/3)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("BNG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("BNG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+BNG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(BNG_REP_VALUE/36)/10;
	getglobal("BNG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("BNG_RepPoints"):SetText((earnedValue+BNG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("BNG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function BroodofNozdormuGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((not(isHeader))and(factionName == BNG_TEXT["Brood of Nozdormu Faction Name"])) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 1;
	topValue = -6000;
	earnedValue = -42000;
    end

    repLevel = standingId;
    if(standingId == 8)then --exalted
	--Default is zero rep needed.
    else
	RepToRepUp = math.max(topValue-earnedValue-BNG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-BNG_REP_VALUE,0);
    end

    local fivehundred = 500;
    local onethousand = 1000;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	fivehundred = 550;
	onethousand = 1100;
    end

    local tooltip = getglobal("BNGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..BNG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(text=="Silithid Carapace Fragment")and(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Silithid Carapace Fragment")then
	reward = fivehundred;
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREY.."200 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/200 = "..(math.floor(itemCount/200)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*200-(itemCount % 200))).." "..FG_TEXT["to rep-up"]); end
	    tooltip:AddLine(" ");
	end
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	end
	if(UnitLevel("player") >= 60)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 60");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 60");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Baristolth of the Shifting Sands"].." - "..FG_TEXT["Silithus"].." (49,36)");
    elseif(text=="Qiraji Lord's Insignia")then
	reward = fivehundred;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Kandrostrasz"].." - "..FG_TEXT["Temple of Ahn'qiraj"].." (?,?)");
    elseif(text=="Ancient Qiraji Artifact")then
	reward = onethousand;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Andorgos"].." - "..FG_TEXT["Temple of Ahn'qiraj"].." (?,?)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function BroodofNozdormuGrinder_HideToolTip()
    getglobal("BNGToolTip"):Hide();
end

function BNG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BNG_TEXT["Brood of Nozdormu Faction Name"]))) then
	    return earnedValue + BNG_REP_VALUE;
	end
    end
    return BNG_REP_VALUE;
end

function BroodofNozdormuGrinder_ToggleGrinding()
    BNG_NOW_GRINDING = not BNG_NOW_GRINDING;

    local button = getglobal("BNG_BU_ToggleGrinding");
    if(BNG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("BNG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	BNG_GRINDING_STARTED_AT = GetTime();
	BNG_INITIALREP = BNG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("BNG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	BNG_PREVIOUS_GRINDING_TIME = BNG_PREVIOUS_GRINDING_TIME + (GetTime()-BNG_GRINDING_STARTED_AT);
	BNG_PREVIOUS_REP_GROUND = BNG_PREVIOUS_REP_GROUND + (BNG_GetCurrentRepTotal() - BNG_INITIALREP); 
    end
end

function BroodofNozdormuGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("BroodofNozdormuGrinder"))then	
	GrinderCore_AcknowledgeItemChange("BroodofNozdormuGrinder");
	BroodofNozdormuGrinder_UpdateDisplayData();
    end

    if(GetTime() > BNG_NEXT_GRIND_UPDATE)then
	BNG_NEXT_GRIND_UPDATE = BNG_NEXT_GRIND_UPDATE + BNG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(BNG_NOW_GRINDING)then	
	    getglobal("BNG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(BNG_PREVIOUS_GRINDING_TIME + (GetTime()-BNG_GRINDING_STARTED_AT)));
	    getglobal("BNG_RepTodayVal"):SetText(FG_GREY..(BNG_PREVIOUS_REP_GROUND + (BNG_GetCurrentRepTotal() - BNG_INITIALREP)));
	    RepPerSecond = ((BNG_PREVIOUS_REP_GROUND + (BNG_GetCurrentRepTotal() - BNG_INITIALREP)) / 
                            math.max(math.floor(BNG_PREVIOUS_GRINDING_TIME + (GetTime()-BNG_GRINDING_STARTED_AT)),1));
	    getglobal("BNG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BNG_TimeToRepUpTodayVal"):SetText(FG_GREY..BNG_TimeToRepUp(RepPerSecond));

	    getglobal("BNG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Brood of Nozdormu")+BNG_PREVIOUS_GRINDING_TIME + (GetTime()-BNG_GRINDING_STARTED_AT)));
	    getglobal("BNG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Brood of Nozdormu")+BNG_PREVIOUS_REP_GROUND + (BNG_GetCurrentRepTotal() - BNG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Brood of Nozdormu")+BNG_PREVIOUS_REP_GROUND + (BNG_GetCurrentRepTotal() - BNG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Brood of Nozdormu")+BNG_PREVIOUS_GRINDING_TIME + (GetTime()-BNG_GRINDING_STARTED_AT)),1));
	    getglobal("BNG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BNG_TimeToRepUpTotalVal"):SetText(FG_GREY..BNG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("BNG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(BNG_PREVIOUS_GRINDING_TIME));
	    getglobal("BNG_RepTodayVal"):SetText(FG_GREY..(BNG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (BNG_PREVIOUS_REP_GROUND / math.max(BNG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("BNG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BNG_TimeToRepUpTodayVal"):SetText(FG_GREY..BNG_TimeToRepUp(RepPerSecond));

	    getglobal("BNG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Brood of Nozdormu")+BNG_PREVIOUS_GRINDING_TIME));
	    getglobal("BNG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Brood of Nozdormu")+BNG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Brood of Nozdormu")+BNG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Brood of Nozdormu")+BNG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("BNG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BNG_TimeToRepUpTotalVal"):SetText(FG_GREY..BNG_TimeToRepUp(RepPerSecond));
        end
    end
end

function BNG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BNG_TEXT["Brood of Nozdormu Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 1;
	topValue = -6000;
	earnedValue = -42000;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-BNG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function BroodofNozdormuGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(BNG_TEXT[itemName]);
    end
end
