--BloodsailBuccaneersGrinder 1.0
--Written By Tiok - US Thrall

BBG1_INITIALREP = 0;

BBG1_NOW_GRINDING = false;
BBG1_PREVIOUS_GRINDING_TIME = 0;
BBG1_GRINDING_STARTED_AT = 0;
BBG1_PREVIOUS_REP_GROUND = 0;

BBG1_GRIND_UPDATE_INTERVAL = 1;
BBG1_NEXT_GRIND_UPDATE = 0;

BBG1_REP_VALUE = 0;

BBG1_TEXT = 
{
    ["Bloodsail Buccaneers Faction Name"] = "Bloodsail Buccaneers";
    ["BB Rep"] = "BB Rep";
}

function InstallBloodsailBuccaneersGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["BloodsailBuccaneersGrinderGrindFrame"] == nil) then FactionGrinderSettings["Show"]["BloodsailBuccaneersGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["BloodsailBuccaneersGrinder"] = "BBG1";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_BloodsailBuccaneersLabel");
    FG_BloodsailBuccaneersLabel:SetFontObject("GameFontNormalSmall");
    FG_BloodsailBuccaneersLabel:SetText("Bloodsail Buccaneers");
    FG_BloodsailBuccaneersLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("BloodsailBuccaneersTexture");
    BloodsailBuccaneersTexture:SetTexture("Interface\\Icons\\INV_Helmet_66");
    BloodsailBuccaneersTexture:SetWidth(24);
    BloodsailBuccaneersTexture:SetHeight(24);
    BloodsailBuccaneersTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    BloodsailBuccaneersTexture:SetTexCoord(0,1,0,1);

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_BloodsailBuccaneersGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function BloodsailBuccaneersGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function BloodsailBuccaneersGrinder_Init()
    BBG1_NEXT_GRIND_UPDATE = GetTime()+BBG1_GRIND_UPDATE_INTERVAL;
    --add variable initializations here
    
    --If any, Item Registrations would occur here.

    BloodsailBuccaneersGrinder_UpdateDisplayData();
    BloodsailBuccaneersGrinder_UpdateRepBars();
end

function BloodsailBuccaneersGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    --If any, calculations of reputation based on items would occur here.

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("BBG1_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(BBG1_REP_VALUE ~= repValue)then
        BBG1_REP_VALUE = repValue;
	BloodsailBuccaneersGrinder_UpdateRepBars();
    end
end

function BloodsailBuccaneersGrinder_OnLoad()
    BloodsailBuccaneersGrinder_RegisterEvents();
end

function BloodsailBuccaneersGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        BloodsailBuccaneersGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	BloodsailBuccaneersGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	BloodsailBuccaneersGrinder_UpdateDisplayData();
	BloodsailBuccaneersGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	BloodsailBuccaneersGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Bloodsail Buccaneers",GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+BBG1_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Bloodsail Buccaneers",GrinderCore_GetRepGround("Bloodsail Buccaneers")+BBG1_PREVIOUS_REP_GROUND);
	if(BBG1_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Bloodsail Buccaneers",GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+(GetTime()-BBG1_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Bloodsail Buccaneers",GrinderCore_GetRepGround("Bloodsail Buccaneers")+(BBG1_GetCurrentRepTotal() - BBG1_INITIALREP));
	end
    end
end

function BloodsailBuccaneersGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	BBG1_TEXT = BBG1_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("BloodsailBuccaneersGrinderGrindFrame"):SetWidth(215);
	getglobal("BBG1_TimeTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("BBG1_RepTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("BBG1_RepPerHourTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("BBG1_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("BBG1_TimeTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("BBG1_RepTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("BBG1_RepPerHourTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("BBG1_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	BBG1_TEXT = BBG1_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("BBG1_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	BBG1_TEXT = BBG1_TEXT_ZHTW;

	getglobal("BBG1_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_BBRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("BBG1ToRepUpFrame"):SetWidth(90);
	getglobal("BBG1ToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("BBG1_SB_ActualRep"):SetWidth(80);
    	getglobal("BBG1_SB_RepWithItems"):SetWidth(80);

	getglobal("BloodsailBuccaneersGrinderGrindFrame"):SetWidth(215);
	getglobal("BBG1_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("BBG1_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("BBG1_TimeTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("BBG1_RepTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("BBG1_RepPerHourTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("BBG1_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("BBG1_TimeTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("BBG1_RepTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("BBG1_RepPerHourTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("BBG1_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","BloodsailBuccaneersGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("BBG1_BBRep"):SetText(BBG1_TEXT["BB Rep"]);
    
    getglobal("BBG1_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("BBG1_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("BBG1_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("BBG1_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("BBG1_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("BBG1_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("BBG1_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("BBG1_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("BBG1_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("BBG1_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("BBG1_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("BBG1_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function BloodsailBuccaneersGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BBG1_TEXT["Bloodsail Buccaneers Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("BBG1_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(BBG1_REP_VALUE/42)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BBG1_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/21)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BBG1_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/12)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BBG1_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/6)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+BBG1_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/3)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+BBG1_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/3)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+BBG1_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/3)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("BBG1_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("BBG1_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+BBG1_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(BBG1_REP_VALUE/36)/10;
	getglobal("BBG1_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("BBG1_RepPoints"):SetText((earnedValue+BBG1_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("BBG1_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function BloodsailBuccaneersGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BBG1_TEXT["Bloodsail Buccaneers Faction Name"]))) then
	    factionFound = true;
 	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	RepToRepUp = 0;
    else
	RepToRepUp = math.max(topValue-earnedValue-BBG1_REP_VALUE,0);
    end

    local seventyfive = 75;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	seventyfive = 82.5;
    end

    local tooltip = getglobal("BBG1ToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..BBG1_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

--    if(text=="Deadwood Headdress Feather")then
--	tooltip:AddLine(FG_GREY.."5 = "..seventyfive.." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*seventyfive).." "..FG_TEXT["rep"]);
--	tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/seventyfive)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]);
--    end
--    tooltip:Show();
    tooltip:ClearAllPoints();
--    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function BloodsailBuccaneersGrinder_HideToolTip()
    getglobal("BBG1ToolTip"):Hide();
end

function BBG1_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BBG1_TEXT["Bloodsail Buccaneers Faction Name"]))) then
	    return earnedValue + BBG1_REP_VALUE;
	end
    end
    return BBG1_REP_VALUE;
end

function BloodsailBuccaneersGrinder_ToggleGrinding()
    BBG1_NOW_GRINDING = not BBG1_NOW_GRINDING;

    local button = getglobal("BBG1_BU_ToggleGrinding");
    if(BBG1_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("BBG1_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	BBG1_GRINDING_STARTED_AT = GetTime();
	BBG1_INITIALREP = BBG1_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("BBG1_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	BBG1_PREVIOUS_GRINDING_TIME = BBG1_PREVIOUS_GRINDING_TIME + (GetTime()-BBG1_GRINDING_STARTED_AT);
	BBG1_PREVIOUS_REP_GROUND = BBG1_PREVIOUS_REP_GROUND + (BBG1_GetCurrentRepTotal() - BBG1_INITIALREP); 
    end
end

function BloodsailBuccaneersGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("BloodsailBuccaneersGrinder"))then	
	GrinderCore_AcknowledgeItemChange("BloodsailBuccaneersGrinder");
	BloodsailBuccaneersGrinder_UpdateDisplayData();
    end

    if(GetTime() > BBG1_NEXT_GRIND_UPDATE)then
	BBG1_NEXT_GRIND_UPDATE = BBG1_NEXT_GRIND_UPDATE + BBG1_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(BBG1_NOW_GRINDING)then	
	    getglobal("BBG1_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(BBG1_PREVIOUS_GRINDING_TIME + (GetTime()-BBG1_GRINDING_STARTED_AT)));
	    getglobal("BBG1_RepTodayVal"):SetText(FG_GREY..(BBG1_PREVIOUS_REP_GROUND + (BBG1_GetCurrentRepTotal() - BBG1_INITIALREP)));
	    RepPerSecond = ((BBG1_PREVIOUS_REP_GROUND + (BBG1_GetCurrentRepTotal() - BBG1_INITIALREP)) / 
                            math.max(math.floor(BBG1_PREVIOUS_GRINDING_TIME + (GetTime()-BBG1_GRINDING_STARTED_AT)),1));
	    getglobal("BBG1_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BBG1_TimeToRepUpTodayVal"):SetText(FG_GREY..BBG1_TimeToRepUp(RepPerSecond));

	    getglobal("BBG1_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+BBG1_PREVIOUS_GRINDING_TIME + (GetTime()-BBG1_GRINDING_STARTED_AT)));
	    getglobal("BBG1_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Bloodsail Buccaneers")+BBG1_PREVIOUS_REP_GROUND + (BBG1_GetCurrentRepTotal() - BBG1_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Bloodsail Buccaneers")+BBG1_PREVIOUS_REP_GROUND + (BBG1_GetCurrentRepTotal() - BBG1_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+BBG1_PREVIOUS_GRINDING_TIME + (GetTime()-BBG1_GRINDING_STARTED_AT)),1));
	    getglobal("BBG1_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BBG1_TimeToRepUpTotalVal"):SetText(FG_GREY..BBG1_TimeToRepUp(RepPerSecond));
        else
	    getglobal("BBG1_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(BBG1_PREVIOUS_GRINDING_TIME));
	    getglobal("BBG1_RepTodayVal"):SetText(FG_GREY..(BBG1_PREVIOUS_REP_GROUND));
	    RepPerSecond = (BBG1_PREVIOUS_REP_GROUND / math.max(BBG1_PREVIOUS_GRINDING_TIME,1));
	    getglobal("BBG1_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BBG1_TimeToRepUpTodayVal"):SetText(FG_GREY..BBG1_TimeToRepUp(RepPerSecond));

	    getglobal("BBG1_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+BBG1_PREVIOUS_GRINDING_TIME));
	    getglobal("BBG1_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Bloodsail Buccaneers")+BBG1_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Bloodsail Buccaneers")+BBG1_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Bloodsail Buccaneers")+BBG1_PREVIOUS_GRINDING_TIME),1));
	    getglobal("BBG1_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("BBG1_TimeToRepUpTotalVal"):SetText(FG_GREY..BBG1_TimeToRepUp(RepPerSecond));
        end
    end
end

function BBG1_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, BBG1_TEXT["Bloodsail Buccaneers Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-BBG1_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function BloodsailBuccaneersGrinder_ItemButtonClick(itemName)
    local ItemInCache,ItemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(ItemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(itemName);
    end
end
