--ArgentDawnGrinder 1.8
--Written By Tiok - US Thrall

ADG_INITIALREP = 0;

ADG_NOW_GRINDING = false;
ADG_PREVIOUS_GRINDING_TIME = 0;
ADG_GRINDING_STARTED_AT = 0;
ADG_PREVIOUS_REP_GROUND = 0;

ADG_GRIND_UPDATE_INTERVAL = 1;
ADG_NEXT_GRIND_UPDATE = 0;

ADG_TEXT = 
{
    ["Argent Dawn Faction Name"] = "Argent Dawn";
    ["AD Rep"] = "AD Rep";
    ["Superior"] = "Superior";
    ["Epic"] = "Epic";

    ["Minion's Scourgestone"] = "Minion's Scourgestone";
    ["Invader's Scourgestone"] = "Invader's Scourgestone";
    ["Corruptor's Scourgestone"] = "Corruptor's Scourgestone";
    ["Argent Dawn Valor Token"] = "Argent Dawn Valor Token";
    ["Core of Elements"] = "Core of Elements";
    ["Crypt Fiend Parts"] = "Crypt Fiend Parts";
    ["Bone Fragments"] = "Bone Fragments";
    ["Dark Iron Scraps"] = "Dark Iron Scraps";
    ["Savage Frond"] = "Savage Frond";
    ["Insignia of the Crusade"] = "Insignia of the Crusade";
    ["Insignia of the Dawn"] = "Insignia of the Dawn";
    ["Arcane Quickener"] = "Arcane Quickener";
    ["Osseous Agitator"] = "Osseous Agitator";
    ["Somatic Intensifier"] = "Somatic Intensifier";
    ["Ectoplasmic Resonator"] = "Ectoplasmic Resonator";
    ["Runecloth"] = "Runecloth";

    ["Felstone Field"] = "Felstone Field";
    ["Dalson's Tears or"] = "Dalson's Tears or";
    ["Writhing Haunt"] = "Writhing Haunt";
    ["Gahrron's Withering"] = "Gahrron's Withering";
}

function InstallArgentDawnGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["ArgentDawnGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["ArgentDawnGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ArgentDawnGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["ArgentDawnGrinderGrindFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["ArgentDawnGrinderCauldronFrame"] == nil) then FactionGrinderSettings["Show"]["ArgentDawnGrinderCauldronFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["ArgentDawnGrinder"] = "ADG";

    local f = getglobal("FGScrollChild");

    --Create the text label.    
    f:CreateFontString("FG_ArgentDawnLabel");
    FG_ArgentDawnLabel:SetFontObject("GameFontNormalSmall");
    FG_ArgentDawnLabel:SetText("Argent Dawn");
    FG_ArgentDawnLabel:SetPoint("TOPLEFT",10,0-FGInitTop-26);

    --Create the cauldron text label.
    f:CreateFontString("FG_ArgentDawnCauldronsLabel");
    FG_ArgentDawnCauldronsLabel:SetFontObject("GameFontNormalSmall");
    FG_ArgentDawnCauldronsLabel:SetText("Argent Dawn Cauldrons");
    FG_ArgentDawnCauldronsLabel:SetPoint("TOPLEFT",10,0-FGInitTop-46);

    --Create the texture (faction icon).
    f:CreateTexture("ArgentDawnTexture");
    ArgentDawnTexture:SetTexture("Interface\\Icons\\INV_Jewelry_Talisman_07");
    ArgentDawnTexture:SetWidth(24);
    ArgentDawnTexture:SetHeight(24);
    ArgentDawnTexture:SetPoint("TOPLEFT",185,0-FGInitTop-30);
    ArgentDawnTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ArgentDawnGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-20);

    --Create the cauldron checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ArgentDawnGrinderCauldronFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-40);

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_ArgentDawnGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-30);

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 40;
end

function ArgentDawnGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

ADG_REP_VALUE = 0;

function ArgentDawnGrinder_Init()
    ADG_NEXT_GRIND_UPDATE = GetTime()+ADG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("ArgentDawnGrinder","Minion's Scourgestone","12840","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Invader's Scourgestone","12841","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Corruptor's Scourgestone","12843","green");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Argent Dawn Valor Token","12844","green");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Insignia of the Dawn","22523","green");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Insignia of the Crusade","22524","green");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Crypt Fiend Parts","22525","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Bone Fragments","22526","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Core of Elements","22527","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Dark Iron Scraps","22528","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Savage Frond","22529","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Arcane Quickener","13320","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Ectoplasmic Resonator","13354","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Somatic Intensifier","13356","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Osseous Agitator","13357","white");
    GrinderCore_RegisterItem("ArgentDawnGrinder","Runecloth","14047","white");

    ArgentDawnGrinder_UpdateDisplayData();
    ArgentDawnGrinder_UpdateRepBars();
end

function ArgentDawnGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    itemName = "Bone Fragments";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*20);
    getglobal("ADG_BoneFragmentCount"):SetText(itemCount);

    itemName = "Core of Elements";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*20);
    getglobal("ADG_CoreofElementsCount"):SetText(itemCount);

    itemName = "Crypt Fiend Parts";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*20);
    getglobal("ADG_CryptFiendPartsCount"):SetText(itemCount);

    itemName = "Dark Iron Scraps";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*20);
    getglobal("ADG_DarkIronScrapsCount"):SetText(itemCount);

    itemName = "Savage Frond";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/30)*20);
    getglobal("ADG_SavageFrondCount"):SetText(itemCount);

    itemName = "Minion's Scourgestone";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/20)*150);
    getglobal("ADG_MinionsScourgestoneCount"):SetText(itemCount);

    itemName = "Invader's Scourgestone";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/10)*150);
    getglobal("ADG_InvadersScourgestoneCount"):SetText(itemCount);
 
    itemName = "Corruptor's Scourgestone";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*150);
    getglobal("ADG_CorruptorsScourgestoneCount"):SetText(itemCount);

    itemName = "Argent Dawn Valor Token";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (itemCount*100);
    getglobal("ADG_ArgentDawnValorTokenCount"):SetText(itemCount);

    itemName = "Arcane Quickener";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    local ArcaneQuickenerCount = itemCount;

    itemName = "Runecloth";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    local RuneclothCount = itemCount;

    itemName = "Osseous Agitator";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/6)*50);
    getglobal("ADG_OsseousAgitator"):SetText(itemCount.."/6");
    getglobal("ADG_ArcaneQuickener1"):SetText(ArcaneQuickenerCount.."/"..(math.floor(itemCount/6)));
    getglobal("ADG_Runecloth1"):SetText(RuneclothCount.."/"..(math.floor(itemCount/6)*4));

    itemName = "Somatic Intensifier";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/5)*50);
    getglobal("ADG_SomaticIntensifier"):SetText(itemCount.."/5");
    getglobal("ADG_ArcaneQuickener2"):SetText(ArcaneQuickenerCount.."/"..(math.floor(itemCount/5)));
    getglobal("ADG_Runecloth2"):SetText(RuneclothCount.."/"..(math.floor(itemCount/5)*4));

    itemName = "Ectoplasmic Resonator";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    repValue = repValue + (math.floor(itemCount/4)*50);
    getglobal("ADG_EctoplasmicResonator"):SetText(itemCount.."/4");
    getglobal("ADG_ArcaneQuickener3"):SetText(ArcaneQuickenerCount.."/"..(math.floor(itemCount/4)));
    getglobal("ADG_Runecloth3"):SetText(RuneclothCount.."/"..(math.floor(itemCount/4)*4));

   local race = UnitRace("player");
   if race == FG_TEXT["Human"] then
       repValue = math.floor(repValue * 1.1);
   end

    getglobal("ADG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(ADG_REP_VALUE ~= repValue)then
        ADG_REP_VALUE = repValue;
	ArgentDawnGrinder_UpdateRepBars();
    end

    local repLevel = "";
    local superiorOutOf = 0;
    local epicOutOf = 0;

    local factionFound = false;
    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ADG_TEXT["Argent Dawn Faction Name"]))) then
            factionFound = true;
	    break;
        end
    end
    if(not factionFound)then
	standingId = 4; --Default starting standing for AD is neutral.
    end
    if(standingId==8)then --Exalted
        superiorOutOf = 6;
        epicOutOf = 27;
    elseif(standingId==7)then --Revered
        superiorOutOf = 7;
        epicOutOf = 45;
    elseif(standingId==6)then --Honored
        superiorOutOf = 20;
        epicOutOf = 75;
    elseif(standingId==5)then --Friendly
        superiorOutOf = 30;
        epicOutOf = 110;
    elseif(standingId<=4)then --Neutral or worse
        superiorOutOf = "\226\136\158";
        epicOutOf = "\226\136\158";
    end

    itemName = "Insignia of the Crusade";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    getglobal("ADG_SuperiorSCCount"):SetText(itemCount.."/"..superiorOutOf);
    getglobal("ADG_EpicSCCount"):SetText(itemCount.."/"..epicOutOf);

    itemName = "Insignia of the Dawn";
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
	itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    getglobal("ADG_SuperiorADCount"):SetText(itemCount.."/"..superiorOutOf);
    getglobal("ADG_EpicADCount"):SetText(itemCount.."/"..epicOutOf);
end

function ArgentDawnGrinder_OnLoad()
    ArgentDawnGrinder_RegisterEvents();
end

function ArgentDawnGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        ArgentDawnGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	ArgentDawnGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	ArgentDawnGrinder_UpdateDisplayData();
	ArgentDawnGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	ArgentDawnGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Argent Dawn",GrinderCore_GetGrindingTime("Argent Dawn")+ADG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Argent Dawn",GrinderCore_GetRepGround("Argent Dawn")+ADG_PREVIOUS_REP_GROUND);
	if(ADG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Argent Dawn",GrinderCore_GetGrindingTime("Argent Dawn")+(GetTime()-ADG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Argent Dawn",GrinderCore_GetRepGround("Argent Dawn")+(ADG_GetCurrentRepTotal() - ADG_INITIALREP));
	end
    end
end

function ArgentDawnGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	ADG_TEXT = ADG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("ArgentDawnGrinderGrindFrame"):SetWidth(215);
	getglobal("ADG_TimeTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ADG_RepTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ADG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ADG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ADG_TimeTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ADG_RepTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ADG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ADG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	ADG_TEXT = ADG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("ADG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	ADG_TEXT = ADG_TEXT_ZHTW;

	getglobal("ADGToRepUpFrame"):SetWidth(90);
	getglobal("ADGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("ADG_SB_ActualRep"):SetWidth(80);
    	getglobal("ADG_SB_RepWithItems"):SetWidth(80);
	getglobal("ADG_Superior"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_Epic"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_ADRep"):SetFontObject(GameFontNormalSmall);
	getglobal("ADGToRepUpFrame"):SetPoint("TOP","ArgentDawnGrinderGrindFrame","TOP",30,-216);

	--Reconstruct Grind-Tracker frame
	getglobal("ArgentDawnGrinderGrindFrame"):SetWidth(215);
	getglobal("ADG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ADG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("ADG_TimeTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ADG_RepTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ADG_RepPerHourTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ADG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ADG_TimeTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ADG_RepTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ADG_RepPerHourTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ADG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","ArgentDawnGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately

    getglobal("ADG_Cauldron1"):SetText(ADG_TEXT["Felstone Field"]);
    getglobal("ADG_Cauldron2"):SetText(ADG_TEXT["Dalson's Tears or"]);
    getglobal("ADG_Cauldron3"):SetText(ADG_TEXT["Writhing Haunt"]);
    getglobal("ADG_Cauldron4"):SetText(ADG_TEXT["Gahrron's Withering"]);

    getglobal("ADG_Superior"):SetText(FG_SUPERIOR..ADG_TEXT["Superior"]);
    getglobal("ADG_Epic"):SetText(FG_EPIC..ADG_TEXT["Epic"]);
    getglobal("ADG_RepValue"):SetText(FG_YELLOW..FG_TEXT["Rep Value"].." : 0");
    getglobal("ADG_ADRep"):SetText(ADG_TEXT["AD Rep"]);
    
    getglobal("ADG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("ADG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("ADG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("ADG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ADG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ADG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ADG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("ADG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ADG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ADG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ADG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("ADG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function ArgentDawnGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ADG_TEXT["Argent Dawn Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("ADG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(ADG_REP_VALUE/42)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ADG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(ADG_REP_VALUE/21)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ADG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(ADG_REP_VALUE/12)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ADG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(ADG_REP_VALUE/6)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ADG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(ADG_REP_VALUE/3)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+ADG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(ADG_REP_VALUE/3)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+ADG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(ADG_REP_VALUE/3)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("ADG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("ADG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+ADG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(ADG_REP_VALUE/36)/10;
	getglobal("ADG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("ADG_RepPoints"):SetText((earnedValue+ADG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("ADG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function ArgentDawnGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ADG_TEXT["Argent Dawn Faction Name"]))) then
	    factionFound = true;
	    break;
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Already defaulted to zero rep required.
    else
	RepToRepUp = math.max(topValue-earnedValue-ADG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-ADG_REP_VALUE,0);
    end

    local onefifty = 150;
    local onehundred = 100;
    local fifty = 50;
    local twenty = 20;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	onefifty = 165;
	onehundred = 110;
	fifty = 55;
	twenty = 22;
    end

    local tooltip = getglobal("ADGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..ADG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end

    if(text=="Minion's Scourgestone")then
	reward = onefifty;
	tooltip:AddLine(FG_GREY.."20 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/20 = "..(math.floor(itemCount/20)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*20-(itemCount % 20))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*20-(itemCount % 20))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Argent Officer Pureheart"].." - "..FG_TEXT["Western Plaguelands"].." (42,83)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Duke Nicholas Zverenhoff"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,59)");
    elseif(text=="Invader's Scourgestone")then
        reward = onefifty;
	tooltip:AddLine(FG_GREY.."10 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/10 = "..(math.floor(itemCount/10)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*10-(itemCount % 10))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Argent Officer Pureheart"].." - "..FG_TEXT["Western Plaguelands"].." (42,83)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Duke Nicholas Zverenhoff"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,59)");
    elseif(text=="Corruptor's Scourgestone")then
	reward = onefifty;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.floor((RepToRepUp/reward)+0.9999)).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.floor((RepToExalted/reward)+0.9999)).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Argent Officer Pureheart"].." - "..FG_TEXT["Western Plaguelands"].." (42,83)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Duke Nicholas Zverenhoff"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,59)");
    elseif(text=="Argent Dawn Valor Token")then
	reward = onehundred;
	tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
    elseif(text=="Core of Elements")then
	reward = twenty;
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
	end
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 55)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 55");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 55");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Archmage Angela Dosantos"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,58)");
    elseif(text=="Dark Iron Scraps")then
	reward = twenty;
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
	end
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]);
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 55)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 55");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 55");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Korfax, Champion of the Light"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,58)");
    elseif(text=="Savage Frond")then
	reward = twenty;
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
	end
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 55)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 55");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 55");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Rayne"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,59)");
    elseif(text=="Bone Fragments")then
	reward = twenty;
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
	end
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 55)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 55");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 55");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Rohan the Assassin"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,58)");
    elseif(text=="Crypt Fiend Parts")then
	reward = twenty;
	if(FactionGrinderSettings["Include Items on Alts"])then
	    itemCount = itemCount + GrinderCore_AltTotalCount(text);
	end
	tooltip:AddLine(FG_GREY.."30 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/30 = "..(math.floor(itemCount/30)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*30-(itemCount % 30))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 55)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 55");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 55");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Huntsman Leopold"].." - "..FG_TEXT["Eastern Plaguelands"].." (81,58)");
    elseif(text=="Insignia of the Dawn")then

    elseif(text=="Insignia of the Crusade")then

    elseif(text=="Osseous Agitator")then
	reward = fifty;
	tooltip:AddLine(FG_GREY.."6 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/6 = "..(math.floor(itemCount/6)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*6-(itemCount % 6))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*6-(itemCount % 6))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 50)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 50");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 50");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Scourge Cauldron"].." - "..FG_TEXT["Western Plaguelands"].." (37,56)");
    elseif(text=="Somatic Intensifier")then
	reward = fifty;
	tooltip:AddLine(FG_GREY.."5 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/5 = "..(math.floor(itemCount/5)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*5-(itemCount % 5))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 51)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 51");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 51");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Scourge Cauldron"].." - "..FG_TEXT["Western Plaguelands"].." (46,51)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Scourge Cauldron"].." - "..FG_TEXT["Western Plaguelands"].." (53,65)");
    elseif(text=="Ectoplasmic Resonator")then
	reward = fifty;
	tooltip:AddLine(FG_GREY.."4 = "..reward.." "..FG_TEXT["rep"]); 
	tooltip:AddLine(FG_YELLOW..itemCount.."/4 = "..(math.floor(itemCount/4)*reward).." "..FG_TEXT["rep"]);
	if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*4-(itemCount % 4))).." "..FG_TEXT["to rep-up"]); end
	if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999)*4-(itemCount % 4))).." "..FG_TEXT["to exalted"]); end
	tooltip:AddLine(" ");
	if(UnitLevel("player") >= 51)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 51");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 51");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Scourge Cauldron"].." - "..FG_TEXT["Western Plaguelands"].." (62,58)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function ArgentDawnGrinder_HideToolTip()
    getglobal("ADGToolTip"):Hide();
end

function ADG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ADG_TEXT["Argent Dawn Faction Name"]))) then
	    return earnedValue + ADG_REP_VALUE;
	end
    end
    return ADG_REP_VALUE;
end

function ArgentDawnGrinder_ToggleGrinding()
    ADG_NOW_GRINDING = not ADG_NOW_GRINDING;

    local button = getglobal("ADG_BU_ToggleGrinding");
    if(ADG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("ADG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	ADG_GRINDING_STARTED_AT = GetTime();
	ADG_INITIALREP = ADG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("ADG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	ADG_PREVIOUS_GRINDING_TIME = ADG_PREVIOUS_GRINDING_TIME + (GetTime()-ADG_GRINDING_STARTED_AT);
	ADG_PREVIOUS_REP_GROUND = ADG_PREVIOUS_REP_GROUND + (ADG_GetCurrentRepTotal() - ADG_INITIALREP); 
    end
end

function ArgentDawnGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("ArgentDawnGrinder"))then	
	GrinderCore_AcknowledgeItemChange("ArgentDawnGrinder");
	ArgentDawnGrinder_UpdateDisplayData();
    end

    if(GetTime() > ADG_NEXT_GRIND_UPDATE)then
	ADG_NEXT_GRIND_UPDATE = ADG_NEXT_GRIND_UPDATE + ADG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(ADG_NOW_GRINDING)then	
	    getglobal("ADG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ADG_PREVIOUS_GRINDING_TIME + (GetTime()-ADG_GRINDING_STARTED_AT)));
	    getglobal("ADG_RepTodayVal"):SetText(FG_GREY..(ADG_PREVIOUS_REP_GROUND + (ADG_GetCurrentRepTotal() - ADG_INITIALREP)));
	    RepPerSecond = ((ADG_PREVIOUS_REP_GROUND + (ADG_GetCurrentRepTotal() - ADG_INITIALREP)) / 
                            math.max(math.floor(ADG_PREVIOUS_GRINDING_TIME + (GetTime()-ADG_GRINDING_STARTED_AT)),1));
	    getglobal("ADG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ADG_TimeToRepUpTodayVal"):SetText(FG_GREY..ADG_TimeToRepUp(RepPerSecond));

	    getglobal("ADG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Argent Dawn")+ADG_PREVIOUS_GRINDING_TIME + (GetTime()-ADG_GRINDING_STARTED_AT)));
	    getglobal("ADG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Argent Dawn")+ADG_PREVIOUS_REP_GROUND + (ADG_GetCurrentRepTotal() - ADG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Argent Dawn")+ADG_PREVIOUS_REP_GROUND + (ADG_GetCurrentRepTotal() - ADG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Argent Dawn")+ADG_PREVIOUS_GRINDING_TIME + (GetTime()-ADG_GRINDING_STARTED_AT)),1));
	    getglobal("ADG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ADG_TimeToRepUpTotalVal"):SetText(FG_GREY..ADG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("ADG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ADG_PREVIOUS_GRINDING_TIME));
	    getglobal("ADG_RepTodayVal"):SetText(FG_GREY..(ADG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (ADG_PREVIOUS_REP_GROUND / math.max(ADG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("ADG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ADG_TimeToRepUpTodayVal"):SetText(FG_GREY..ADG_TimeToRepUp(RepPerSecond));

	    getglobal("ADG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Argent Dawn")+ADG_PREVIOUS_GRINDING_TIME));
	    getglobal("ADG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Argent Dawn")+ADG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Argent Dawn")+ADG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Argent Dawn")+ADG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("ADG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ADG_TimeToRepUpTotalVal"):SetText(FG_GREY..ADG_TimeToRepUp(RepPerSecond));
        end
    end
end

function ADG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----";
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
        canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ADG_TEXT["Argent Dawn Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-ADG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function ArgentDawnGrinder_ItemButtonClick(itemName)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(ADG_TEXT[itemName]);
    end
end
