--AldorGrinder 1.0
--Written By Tiok - US Thrall

ALG_INITIALREP = 0;

ALG_NOW_GRINDING = false;
ALG_PREVIOUS_GRINDING_TIME = 0;
ALG_GRINDING_STARTED_AT = 0;
ALG_PREVIOUS_REP_GROUND = 0;

ALG_GRIND_UPDATE_INTERVAL = 1;
ALG_NEXT_GRIND_UPDATE = 0;

ALG_REP_VALUE = 0;

ALG_TEXT = 
{
    ["Aldor Faction Name"] = "The Aldor";
    ["Al Rep"] = "Al Rep";

    ["Dreadfang Venom Sac"] = "Dreadfang Venom Sac";
    ["Mark of Kil'jaeden"] = "Mark of Kil'jaeden";
    ["Fel Armament"] = "Fel Armament";
    ["Mark of Sargeras"] = "Mark of Sargeras";
}

function InstallAldorGrinder()
    --Add this faction to the "Show" settings.
    if (FactionGrinderSettings["Show"]["AldorGrinderDisplayFrame"]  == nil) then FactionGrinderSettings["Show"]["AldorGrinderDisplayFrame"] = 0; end
    if (FactionGrinderSettings["Show"]["AldorGrinderGrindFrame"]    == nil) then FactionGrinderSettings["Show"]["AldorGrinderGrindFrame"] = 0; end

    FactionGrinderSettings["Abbreviations"]["AldorGrinder"] = "ALG";

    local f = getglobal("FGScrollChild");

    --Create the text label.
    f:CreateFontString("FG_AldorLabel");
    FG_AldorLabel:SetFontObject("GameFontNormalSmall");
    FG_AldorLabel:SetText("The Aldor");
    FG_AldorLabel:SetPoint("TOPLEFT",10,0-FGInitTop-31); -- -26 and -46 for double-label factions, -31 for single-label factions

    --Create the texture (faction icon).
    f:CreateTexture("AldorTexture");
    AldorTexture:SetTexture("Interface\\Icons\\Spell_Shadow_DemonicFortitude");
    AldorTexture:SetWidth(24);
    AldorTexture:SetHeight(24);
    AldorTexture:SetPoint("TOPLEFT",185,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions
    AldorTexture:SetTexCoord(0,1,0,1);

    --Create the display checkbox
    local cb = CreateFrame("CheckButton","FG_CB_AldorGrinderDisplayFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_TurninLabel",0,0-FGInitTop-25); -- -20 and -40 for double-label factions, -25 for single-label factions

    --Create the grind checkbox
    local cb = CreateFrame("CheckButton","FG_CB_AldorGrinderGrindFrame",FGScrollChild,"FG_CheckButton");
    cb:SetChecked(false);
    cb:SetPoint("BOTTOM","FG_GrindStatsLabel",0,0-FGInitTop-25); -- -30 for double-label factions, -25 for single-label factions

    --Increment the "top" for the next faction.  Should be 30 for single-label factions and 40 for double-label ones.
    FGInitTop = FGInitTop + 30;
end

function AldorGrinder_RegisterEvents()
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
    this:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");
    --add event registrations here
end

function AldorGrinder_Init()
    ALG_NEXT_GRIND_UPDATE = GetTime()+ALG_GRIND_UPDATE_INTERVAL;
    --add variable initializations here

    GrinderCore_RegisterItem("AldorGrinder","Dreadfang Venom Sac","25802","white");
    GrinderCore_RegisterItem("AldorGrinder","Mark of Kil'jaeden","29425","white");
    GrinderCore_RegisterItem("AldorGrinder","Fel Armament","29740","green");
    GrinderCore_RegisterItem("AldorGrinder","Mark of Sargeras","30809","white");

    AldorGrinder_UpdateDisplayData();
    AldorGrinder_UpdateRepBars();
end

function AldorGrinder_UpdateDisplayData()
    local repValue = 0;

    local itemCount, itemName;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    itemName = "Dreadfang Venom Sac";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId <= 3)then
        repValue = repValue + math.floor(itemCount/8)*250;
    end
    getglobal("ALG_DreadfangVenomSacCount"):SetText(itemCount.."/8");

    itemName = "Mark of Kil'jaeden";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if((standingId == 4)or(standingId == 5))then
        repValue = repValue + itemCount*25;
    end
    getglobal("ALG_MarkofKiljaedenCount"):SetText(itemCount.."/1");

    itemName = "Fel Armament";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + itemCount*350;
    end
    getglobal("ALG_FelArmamentCount"):SetText(itemCount.."/1");

    itemName = "Mark of Sargeras";
    if(FactionGrinderSettings["Include Bank Bags"])then
        itemCount = GrinderCore_PlayerTotalCount(itemName);
    else
        itemCount = GrinderCore_PlayerInventoryCount(itemName);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
        itemCount = itemCount + GrinderCore_AltTotalCount(itemName);
    end
    if(standingId >= 4)then
        repValue = repValue + itemCount*25;
    end
    getglobal("ALG_MarkofSargerasCount"):SetText(itemCount.."/1");

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
        repValue = math.floor(repValue * 1.1);
    end

    getglobal("ALG_RepValue"):SetText(FG_TEXT["Rep Value"].." : "..repValue);
    if(ALG_REP_VALUE ~= repValue)then
        ALG_REP_VALUE = repValue;
	AldorGrinder_UpdateRepBars();
    end
end

function AldorGrinder_OnLoad()
    AldorGrinder_RegisterEvents();
end

function AldorGrinder_OnEvent()
    if ( event == "VARIABLES_LOADED" ) then    
        AldorGrinder_Init();
    elseif((event == "ADDON_LOADED") and (arg1 == "FactionGrinder"))then
	AldorGrinder_LoadConfiguration();
    elseif(event == "CHAT_MSG_CHANNEL_NOTICE")then
	this:UnregisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	AldorGrinder_UpdateDisplayData();
	AldorGrinder_UpdateRepBars();
    elseif( event == "CHAT_MSG_COMBAT_FACTION_CHANGE")then
	AldorGrinder_UpdateRepBars();
    elseif( event == "PLAYER_LEAVING_WORLD" )then
	GrinderCore_SetGrindingTime("Aldor",GrinderCore_GetGrindingTime("Aldor")+ALG_PREVIOUS_GRINDING_TIME);
	GrinderCore_SetRepGround("Aldor",GrinderCore_GetRepGround("Aldor")+ALG_PREVIOUS_REP_GROUND);
	if(ALG_NOW_GRINDING)then
	    GrinderCore_SetGrindingTime("Aldor",GrinderCore_GetGrindingTime("Aldor")+(GetTime()-ALG_GRINDING_STARTED_AT));
	    GrinderCore_SetRepGround("Aldor",GrinderCore_GetRepGround("Aldor")+(ALG_GetCurrentRepTotal() - ALG_INITIALREP));
	end
    end
end

function AldorGrinder_LoadConfiguration()
    --this is where we would load the localization values if needed
    if(GetLocale() == "deDE") then
    	ALG_TEXT = ALG_TEXT_DE;

	--Reconstruct Grind-Tracker frame
	getglobal("AldorGrinderGrindFrame"):SetWidth(215);
	getglobal("ALG_TimeTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ALG_RepTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ALG_RepPerHourTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ALG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ALG_TimeTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ALG_RepTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ALG_RepPerHourTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ALG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-166);
    elseif(GetLocale() == "frFR")then
	ALG_TEXT = ALG_TEXT_FR;

	--Reconstruct Grind-Tracker frame
	getglobal("ALG_BU_ToggleGrinding"):SetWidth(144);
    elseif(GetLocale() == "zhTW")then
	ALG_TEXT = ALG_TEXT_ZHTW;

	getglobal("ALG_RepValue"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_AlRep"):SetFontObject(GameFontNormalSmall);

	--Reconstruct Grind-Tracker frame
        getglobal("ALGToRepUpFrame"):SetWidth(90);
	getglobal("ALGToRepUpOverlayFrame"):SetWidth(90);
    	getglobal("ALG_SB_ActualRep"):SetWidth(80);
    	getglobal("ALG_SB_RepWithItems"):SetWidth(80);

	getglobal("AldorGrinderGrindFrame"):SetWidth(215);
	getglobal("ALG_CurrentlyGrinding"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_Today"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_TimeToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_RepToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_RepPerHourToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_TimeToRepUpToday"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_Total"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_TimeTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_RepTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_RepPerHourTotal"):SetFontObject(GameFontNormalSmall);
	getglobal("ALG_TimeToRepUpTotal"):SetFontObject(GameFontNormalSmall);
        getglobal("ALG_TimeTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-68);
	getglobal("ALG_RepTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-79);
	getglobal("ALG_RepPerHourTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-90);
	getglobal("ALG_TimeToRepUpTodayVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-101);
	getglobal("ALG_TimeTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-133);
	getglobal("ALG_RepTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-144);
	getglobal("ALG_RepPerHourTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-155);
	getglobal("ALG_TimeToRepUpTotalVal"):SetPoint("TOPLEFT","AldorGrinderGrindFrame","TOPLEFT",108,-166);
    end
    
    --now that the localization has been loaded, let's set all text variables appropriately
    
    getglobal("ALG_AlRep"):SetText(ALG_TEXT["Al Rep"]);
    
    getglobal("ALG_BU_ToggleGrinding"):SetText(FG_TEXT["Start Grinding"]);
    getglobal("ALG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

    getglobal("ALG_Today"):SetText(FG_WHITE..FG_TEXT["Today's Grinding"]);
    getglobal("ALG_TimeToday"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ALG_RepToday"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ALG_RepPerHourToday"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ALG_Total"):SetText(FG_WHITE..FG_TEXT["Total Grinding"]);
    getglobal("ALG_TimeTotal"):SetText(FG_GREY..FG_TEXT["Time"].." :");
    getglobal("ALG_RepTotal"):SetText(FG_GREY..FG_TEXT["Rep"].." :");
    getglobal("ALG_RepPerHourTotal"):SetText(FG_GREY..FG_TEXT["Rep/Hour"].." :");
    getglobal("ALG_TimeToRepUpToday"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
    getglobal("ALG_TimeToRepUpTotal"):SetText(FG_GREY..FG_TEXT["Rep-up In"].." :");
end

function AldorGrinder_UpdateRepBars()
    local repPercent = 0;
    local itemPercent = 0;
    local totalPercent = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))) then
	    factionFound = true;
	    break
        end
    end

    if(not factionFound)then
	standingId = 4;
	earnedValue = 0;
    end

    if(standingId==8)then --Exalted
	getglobal("ALG_SB_ActualRep"):SetValue(100);
	repPercent = 100;
	itemPercent = math.floor(ALG_REP_VALUE/42)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Exalted"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE-42000).."/1000");
    elseif(standingId==7)then --Revered
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((earnedValue-21000)/21000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ALG_REP_VALUE-21000)/210)));
	repPercent = math.floor((earnedValue-21000)/21)/10;
	itemPercent = math.floor(ALG_REP_VALUE/21)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Revered"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE-21000).."/21000");
    elseif(standingId==6)then --Honored
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((earnedValue-9000)/12000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ALG_REP_VALUE-9000)/120)));
	repPercent = math.floor((earnedValue-9000)/12)/10;
	itemPercent = math.floor(ALG_REP_VALUE/12)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Honored"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE-9000).."/12000");
    elseif(standingId==5)then --Friendly
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((earnedValue-3000)/6000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ALG_REP_VALUE-3000)/60)));
	repPercent = math.floor((earnedValue-3000)/6)/10;
	itemPercent = math.floor(ALG_REP_VALUE/6)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Friendly"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE-3000).."/6000");
    elseif(standingId==4)then --Neutral
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor(earnedValue/3000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((earnedValue+ALG_REP_VALUE)/30)));
	repPercent = math.floor(earnedValue/3)/10;
	itemPercent = math.floor(ALG_REP_VALUE/3)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Neutral"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE).."/3000");
    elseif(standingId==3)then --Unfriendly (-3000 to 0)
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((3000+earnedValue)/3000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((3000+earnedValue+ALG_REP_VALUE)/30)));
	repPercent = math.floor((3000+earnedValue)/3)/10;
	itemPercent = math.floor(ALG_REP_VALUE/3)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Unfriendly"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE+3000).."/3000");
    elseif(standingId==2)then --Hostile (-6000 to -3000)
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((6000+earnedValue)/3000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((6000+earnedValue+ALG_REP_VALUE)/30)));
	repPercent = math.floor((6000+earnedValue)/3)/10;
	itemPercent = math.floor(ALG_REP_VALUE/3)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Hostile"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE+6000).."/3000");
    elseif(standingId==1)then --Hated (-42000 to -6000)
	getglobal("ALG_SB_ActualRep"):SetValue(math.floor((42000+earnedValue)/36000*100));
	getglobal("ALG_SB_RepWithItems"):SetValue(math.min(100,math.floor((42000+earnedValue+ALG_REP_VALUE)/360)));
	repPercent = math.floor((42000+earnedValue)/36)/10;
	itemPercent = math.floor(ALG_REP_VALUE/36)/10;
	getglobal("ALG_RepLevel"):SetText(FG_TEXT["Now Hated"]);
	getglobal("ALG_RepPoints"):SetText((earnedValue+ALG_REP_VALUE+42000).."/36000");
    end

    totalPercent = repPercent + itemPercent;
    getglobal("ALG_RepPercent"):SetText("|cff00ff00"..repPercent.."% |caaaaaaaa+ |cffffff00"..itemPercent.."% |caaaaaaaa\226\137\136 |cff88ff00"..totalPercent.."%");
end

function AldorGrinder_ShowToolTip(text,parent)
    local RepToRepUp = 0;
    local RepToExalted = 0;

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	--Already set to zero needed rep.
    else
	RepToRepUp = math.max(topValue-earnedValue-ALG_REP_VALUE,0);
	RepToExalted = math.max(42000-earnedValue-ALG_REP_VALUE,0);
    end

    local twentyfive = 25;
    local twofifty = 250;
    local threefifty = 350;

    local race = UnitRace("player");
    if race == FG_TEXT["Human"] then
	twentyfive = 27.5;
	twofifty = 275;
	threefifty = 385;
    end

    local tooltip = getglobal("ALGToolTip");
    tooltip:SetOwner(this,"ANCHOR_TOPLEFT",0,0);
    tooltip:ClearLines();
    tooltip:AddLine(GrinderCore_GetItemColor(text)..ALG_TEXT[text]);

    local itemCount;
    if(FactionGrinderSettings["Include Bank Bags"])then
	itemCount = GrinderCore_PlayerTotalCount(text);
    else
	itemCount = GrinderCore_PlayerInventoryCount(text);
    end
    if(FactionGrinderSettings["Include Items on Alts"])then
	itemCount = itemCount + GrinderCore_AltTotalCount(text);
    end

    if(text=="Dreadfang Venom Sac")then
	reward = twofifty;
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREY.."8 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/8 = "..(math.floor(itemCount/8)*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999)*8-(itemCount % 8))).." "..FG_TEXT["to rep-up"]); end
            tooltip:AddLine(" ");
        end
	if(standingId <= 3)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Unfriendly or lower"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Sha'nir"].." - "..FG_TEXT["Shattrath City"].." (64,16)");
    elseif(text=="Mark of Kil'jaeden")then
	reward = twentyfive;
	if(standingId == 4)or(standingId == 5)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId == 4)or(standingId == 5)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or Friendly"]);
	end
	if(UnitLevel("player") >= 62)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 62");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 62");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Adyen the Lightwarden"].." - "..FG_TEXT["Shattrath City"].." (31,35)");
    elseif(text=="Fel Armament")then
	reward = threefifty;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 64)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 64");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 64");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Ishanah"].." - "..FG_TEXT["Shattrath City"].." (24,30)");
    elseif(text=="Mark of Sargeras")then
	reward = twentyfive;
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREY.."1 = "..reward.." "..FG_TEXT["rep"]);
	    tooltip:AddLine(FG_YELLOW..itemCount.."/1 = "..(itemCount*reward).." "..FG_TEXT["rep"]);
	    if(standingId < 7) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToRepUp/reward)+0.9999))).." "..FG_TEXT["to rep-up"]); end
	    if(standingId < 8) then tooltip:AddLine(FG_GRUE..(math.max(0,math.floor((RepToExalted/reward)+0.9999))).." "..FG_TEXT["to exalted"]); end
            tooltip:AddLine(" ");
        end	
	if(standingId >= 4)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Only repeatable while Neutral or better"]);
	else
	    tooltip:AddLine(FG_RED..FG_TEXT["Only repeatable while Neutral or better"]);
	end
	if(UnitLevel("player") >= 68)then
	    tooltip:AddLine(FG_GREEN..FG_TEXT["Requires level"].." 68");
        else
	    tooltip:AddLine(FG_RED..FG_TEXT["Requires level"].." 68");
        end
	tooltip:AddLine(" ");
	tooltip:AddLine(FG_WHITE..FG_TEXT["Turn-in Locations"]);
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Adyen the Lightwarden"].." - "..FG_TEXT["Shattrath City"].." (31,35)");
	tooltip:AddLine(FG_GREY.."  "..FG_TEXT["Harbinger Saronen"].." - "..FG_TEXT["Shadowmoon Valley"].." (62,29)");
    end
    tooltip:Show();
    tooltip:ClearAllPoints();
    tooltip:SetPoint("BOTTOM",parent,"TOP",0,-5);
end

function AldorGrinder_HideToolTip()
    getglobal("ALGToolTip"):Hide();
end

function ALG_GetCurrentRepTotal()
    for factionIndex = 1, GetNumFactions() do
        factionName,_,_,_,_,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))) then
	    return earnedValue + ALG_REP_VALUE;
	end
    end
    return ALG_REP_VALUE;
end

function AldorGrinder_ToggleGrinding()
    ALG_NOW_GRINDING = not ALG_NOW_GRINDING;

    local button = getglobal("ALG_BU_ToggleGrinding");
    if(ALG_NOW_GRINDING)then
	button:SetText(FG_TEXT["Stop Grinding"]);
	getglobal("ALG_CurrentlyGrinding"):SetText(FG_GREEN..FG_TEXT["Grinding"]);

	ALG_GRINDING_STARTED_AT = GetTime();
	ALG_INITIALREP = ALG_GetCurrentRepTotal();
    else
	button:SetText(FG_TEXT["Start Grinding"]);
	getglobal("ALG_CurrentlyGrinding"):SetText(FG_RED..FG_TEXT["Not Grinding"]);

	ALG_PREVIOUS_GRINDING_TIME = ALG_PREVIOUS_GRINDING_TIME + (GetTime()-ALG_GRINDING_STARTED_AT);
	ALG_PREVIOUS_REP_GROUND = ALG_PREVIOUS_REP_GROUND + (ALG_GetCurrentRepTotal() - ALG_INITIALREP); 
    end
end

function AldorGrinder_UpdateGrindingStats()
    if(GrinderCore_FactionItemsChanged("AldorGrinder"))then	
	GrinderCore_AcknowledgeItemChange("AldorGrinder");
	AldorGrinder_UpdateDisplayData();
    end

    if(GetTime() > ALG_NEXT_GRIND_UPDATE)then
	ALG_NEXT_GRIND_UPDATE = ALG_NEXT_GRIND_UPDATE + ALG_GRIND_UPDATE_INTERVAL;
	local RepPerSecond = 0;

        if(ALG_NOW_GRINDING)then	
	    getglobal("ALG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ALG_PREVIOUS_GRINDING_TIME + (GetTime()-ALG_GRINDING_STARTED_AT)));
	    getglobal("ALG_RepTodayVal"):SetText(FG_GREY..(ALG_PREVIOUS_REP_GROUND + (ALG_GetCurrentRepTotal() - ALG_INITIALREP)));
	    RepPerSecond = ((ALG_PREVIOUS_REP_GROUND + (ALG_GetCurrentRepTotal() - ALG_INITIALREP)) / 
                            math.max(math.floor(ALG_PREVIOUS_GRINDING_TIME + (GetTime()-ALG_GRINDING_STARTED_AT)),1));
	    getglobal("ALG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ALG_TimeToRepUpTodayVal"):SetText(FG_GREY..ALG_TimeToRepUp(RepPerSecond));

	    getglobal("ALG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Aldor")+ALG_PREVIOUS_GRINDING_TIME + (GetTime()-ALG_GRINDING_STARTED_AT)));
	    getglobal("ALG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Aldor")+ALG_PREVIOUS_REP_GROUND + (ALG_GetCurrentRepTotal() - ALG_INITIALREP)));
	    RepPerSecond = ((GrinderCore_GetRepGround("Aldor")+ALG_PREVIOUS_REP_GROUND + (ALG_GetCurrentRepTotal() - ALG_INITIALREP)) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Aldor")+ALG_PREVIOUS_GRINDING_TIME + (GetTime()-ALG_GRINDING_STARTED_AT)),1));
	    getglobal("ALG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ALG_TimeToRepUpTotalVal"):SetText(FG_GREY..ALG_TimeToRepUp(RepPerSecond));
        else
	    getglobal("ALG_TimeTodayVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(ALG_PREVIOUS_GRINDING_TIME));
	    getglobal("ALG_RepTodayVal"):SetText(FG_GREY..(ALG_PREVIOUS_REP_GROUND));
	    RepPerSecond = (ALG_PREVIOUS_REP_GROUND / math.max(ALG_PREVIOUS_GRINDING_TIME,1));
	    getglobal("ALG_RepPerHourTodayVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ALG_TimeToRepUpTodayVal"):SetText(FG_GREY..ALG_TimeToRepUp(RepPerSecond));

	    getglobal("ALG_TimeTotalVal"):SetText(FG_GREY..FactionGrinder_SecondsToTime(GrinderCore_GetGrindingTime("Aldor")+ALG_PREVIOUS_GRINDING_TIME));
	    getglobal("ALG_RepTotalVal"):SetText(FG_GREY..(GrinderCore_GetRepGround("Aldor")+ALG_PREVIOUS_REP_GROUND));
	    RepPerSecond = ((GrinderCore_GetRepGround("Aldor")+ALG_PREVIOUS_REP_GROUND) / 
                            math.max(math.floor(GrinderCore_GetGrindingTime("Aldor")+ALG_PREVIOUS_GRINDING_TIME),1));
	    getglobal("ALG_RepPerHourTotalVal"):SetText(FG_GREY..math.floor(RepPerSecond*3600));
	    getglobal("ALG_TimeToRepUpTotalVal"):SetText(FG_GREY..ALG_TimeToRepUp(RepPerSecond));
        end
    end
end

function ALG_TimeToRepUp(RepPerSecond)
    if(RepPerSecond==0)then
	return "-----"
    end

    local factionFound = false;

    for factionIndex = 1, GetNumFactions() do
        factionName,_,standingId,_,topValue,earnedValue,_,_,isHeader,_,_ = GetFactionInfo(factionIndex)
        if ((isHeader == nil)and(string.find(factionName, ALG_TEXT["Aldor Faction Name"]))) then
	    factionFound = true;
	    break
	end
    end

    if(not factionFound)then
	standingId = 4;
	topValue = 3000;
	earnedValue = 0;
    end

    if(standingId == 8)then --exalted
	return "-----";
    else
	local RepToRepUp = math.max(topValue-earnedValue-ALG_REP_VALUE,0);
	return FactionGrinder_SecondsToTime(RepToRepUp / RepPerSecond);
    end
end

function AldorGrinder_ItemButtonClick(itemName, color)
    local ItemInCache,itemLink = GetItemInfo(GrinderCore_Settings["Item IDs"][itemName]);
    if(ChatFrameEditBox:IsVisible() and IsShiftKeyDown() and ItemInCache)then
    	ChatFrameEditBox:Insert(itemLink);
    elseif(ChatFrameEditBox:IsVisible()) then
	ChatFrameEditBox:Insert(ALG_TEXT[itemName]);
    end
end
