-- Based on BasicBuffs
local FacadeBuffs = LibStub("AceAddon-3.0"):NewAddon("FacadeBuffs")
local LBF = LibStub('LibButtonFacade', true)	

local display = nil
local L = newproxy(true)
getmetatable(L).__index = function(self, key)
	return key
end

local db
local defaults = {
	profile = {
		x = nil,
		y = nil,
		lock = nil,
		buffstyle = {},
		debuffstyle = {},
		weaponstyle = {},
		scale = 1,
		colorBuffGloss = false,
		colorDebuffGloss = true
	}
}

local optionFunc = {
	lock = function()
		if db.lock then
			display:SetBackdropColor(0,1,0,0)
			display:EnableMouse(false)
			display:SetMovable(false)
		else
			display:SetBackdropColor(0,1,0,1)
			display:EnableMouse(true)
			display:SetMovable(true)
		end
	end,
	scale = function() FacadeBuffs:SetScale() end,
	colorBuffGloss = function() FacadeBuffs:UpdateSkin() end,
	colorDebuffGloss = function() FacadeBuffs:UpdateSkin() end,
}

local options = {
	name = L["FacadeBuffs"],
	type = "group",
	hidden = false,	
	get = function(info)
		return FacadeBuffs.db.profile[info[#info]]
	end,
	set = function(info, value)
		FacadeBuffs.db.profile[info[#info]] = value
		local func = optionFunc[info[#info]]
		if func then
			func(info, value)
		end
	end,
	args = {		
		lock = {
			name = L["Locked"],
			type = "toggle",
			desc = L["Locks/unlocks the buff frame."],
			order = 1,
		},
		scale = {
			name = L["Buff Scale"],
			type = "range",
			desc = L["Sets buff scale."],
			min = 0.2,
			max = 3,
			step = 0.05,
			isPercent = true,
			order = 2,
		},
		colorBuffGloss = {
			name = L["Color Buff Gloss"],
			type = "toggle",
			desc = L["Colors the buff gloss green."],
			order = 3,
		},
		colorDebuffGloss = {
			name = L["Color Debuff Gloss"],
			type = "toggle",
			desc = L["Colors the debuff gloss after the current debuff color."],
			order = 4,
		},		
	}
}

local buffs = {}

local eventFunc = function()
	local button, gloss, debuffType, color
	if FacadeBuffs.db.profile.colorBuffGloss then
		for i=1, BUFF_MAX_DISPLAY do
			button = _G["BuffButton"..i]
			gloss = LBF:GetGlossLayer(button)
			if gloss then
				gloss:SetVertexColor(0.2, 0.8, 0.2, 0.8)
			end
		end
	end
	if FacadeBuffs.db.profile.colorDebuffGloss then
		for i=1, DEBUFF_MAX_DISPLAY do
			button = _G["DebuffButton"..i]
			debuffType = GetPlayerBuffDispelType(GetPlayerBuff(i, "HARMFUL"))
			if debuffType then
				color = DebuffTypeColor[debuffType]
			else
				color = DebuffTypeColor["none"]
			end
			gloss = LBF:GetGlossLayer(button)
			if gloss then
				gloss:SetVertexColor(color.r, color.g, color.b, 0.8)
			end
		end
	end
end

eventFrame = CreateFrame("Frame")
eventFrame:SetScript("OnEvent", eventFunc)

------------------------------
--      Initialization      --
------------------------------

local BuffButton_UpdateOld
function FacadeBuffs:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("FacadeBuffsDB", defaults)
	db = self.db.profile
end

------------------------------
--       Frame Setup        --
------------------------------


function FacadeBuffs:OnEnable()
	if display then return end

	LibStub("AceConfig-3.0"):RegisterOptionsTable("FacadeBuffs", options)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("FacadeBuffs", L["FacadeBuffs"])	
	
	display = CreateFrame("Frame", "FacadeBuffsFrame", UIParent)
	display:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",})
	display:SetFrameStrata("BACKGROUND")
	display:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	display:SetBackdropColor(0,1,0)
	display:SetWidth(350)
	display:SetHeight(225)
	display:Show()
	display:EnableMouse(true)
	display:RegisterForDrag("LeftButton")
	display:SetMovable(true)
	display:SetScript("OnDragStart", function() this:StartMoving() end)
	display:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SavePosition()
	end)

	if db.lock then
		display:SetBackdropColor(0,1,0,0)
		display:EnableMouse(false)
		display:SetMovable(false)
	end

	TemporaryEnchantFrame:ClearAllPoints()
	TemporaryEnchantFrame:SetPoint("TOPRIGHT", display, "TOPRIGHT")
	TemporaryEnchantFrame.ClearAllPoints = function() end
	TemporaryEnchantFrame.SetPoint = function() end
	
	if LBF then
		BuffButton_UpdateOld = BuffButton_Update
		BuffButton_Update = function(name, index, filter)
			BuffButton_UpdateOld(name, index, filter)
			local buffName = name..index
			local f = getglobal(buffName)
			if f and not buffs[f] then
				buffs[f] = true
				FacadeBuffs:Register(f, name, index, filter)
			end
		end
	
		LBF:Group('FacadeBuffs', 'Buffs'):Skin(unpack(self.db.profile.buffstyle))
		LBF:Group('FacadeBuffs', 'Debuffs'):Skin(unpack(self.db.profile.debuffstyle))
		LBF:Group('FacadeBuffs', 'Weapons'):Skin(unpack(self.db.profile.weaponstyle))
		
		LBF:RegisterSkinCallback('FacadeBuffs', self.OnSkin, self)
		eventFrame:RegisterEvent("PLAYER_AURAS_CHANGED")
		
		self:Register(TempEnchant1, "TempEnchant", 1)
		self:Register(TempEnchant2, "TempEnchant", 2)
	end
	self:SetScale()
end

local colordbFunc = function(texture)
	debuffType = GetPlayerBuffDispelType(GetPlayerBuff(texture.index, "HARMFUL"))
	local color
	if debuffType then
		color = DebuffTypeColor[debuffType]
	else
		color = DebuffTypeColor["none"]
	end
	texture:SetVertexColorOld(color.r, color.g, color.b, 1)
end

local colorwFunc = function(texture)
	texture:SetVertexColorOld(0.1, 0.3, 1, 1)
end

function FacadeBuffs:Register(f, n, i, t)
	local count = _G[n..i.."Count"]
	if count then
		count:SetJustifyH("RIGHT")
	end
	
	if t == "HELPFUL" then
		LBF:Group('FacadeBuffs', 'Buffs'):AddButton(f)
	elseif t then
		local border = _G[n..i.."Border"]
		border.index = i
		border.SetVertexColorOld = border.SetVertexColor
		border.SetVertexColor = colordbFunc
		LBF:Group('FacadeBuffs', 'Debuffs'):AddButton(f)
	else
		local border = _G[n..i.."Border"]
		border.SetVertexColorOld = border.SetVertexColor
		border.SetVertexColor = colorwFunc
		LBF:Group('FacadeBuffs', 'Weapons'):AddButton(f)
	end
end

function FacadeBuffs:OnSkin(skin, glossAlpha, gloss, group, _, colors)
	local styleDB
	if group == 'Buffs' then
		styleDB = FacadeBuffs.db.profile.buffstyle
	elseif group == 'Debuffs' then
		styleDB = FacadeBuffs.db.profile.debuffstyle
	elseif group == 'Weapons' then
		styleDB = FacadeBuffs.db.profile.weaponstyle
	end

	if styleDB then
		styleDB[1] = skin
		styleDB[2] = glossAlpha
		styleDB[3] = gloss
		styleDB[4] = colors
	end
end

function FacadeBuffs:SavePosition()
	if not display then return end

	local s = display:GetEffectiveScale()
	db.x = display:GetLeft() * s
	db.y = display:GetTop() * s
end

function FacadeBuffs:SetScale()
	BuffFrame:SetScale(self.db.profile.scale)
	TemporaryEnchantFrame:SetScale(self.db.profile.scale)
	display:SetScale(self.db.profile.scale)
	local x = db.x
	local y = db.y
	if x and y then
		local s = display:GetEffectiveScale()
		display:ClearAllPoints()
		display:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
	end	
end

function FacadeBuffs:UpdateSkin()
	if not LBF then return end
	LBF:Group('FacadeBuffs', 'Buffs'):Skin(unpack(self.db.profile.buffstyle))
	LBF:Group('FacadeBuffs', 'Debuffs'):Skin(unpack(self.db.profile.debuffstyle))
	eventFunc()
end