--Here's all the built-in puzzles that ship with the initial version.

local BasePuzzles = {
	{
		["code"] = "022020000000000000000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.3440000000409782, -- [2]
			2, -- [3]
			0.4740000000456348, -- [4]
			2, -- [5]
			0.6100000000442378, -- [6]
			2, -- [7]
			0.7490000000107102, -- [8]
			2, -- [9]
			0.8620000000228174, -- [10]
			2, -- [11]
			1.024000000033993, -- [12]
			2, -- [13]
			1.198000000033062, -- [14]
			4, -- [15]
			1.38800000003539, -- [16]
			5, -- [17]
			1.571000000054482, -- [18]
			0, -- [19]
			0, -- [20]
			0, -- [21]
			0, -- [22]
		},
		["numMoves"] = 1,
		["text"] = "Press \"Play Demo\" to view an animation of the current lesson, or \"Next\" to go to the next tutorial.\n\nFor help with the UI, hold down CTRL and move the mouse over any button, slider or high score list. If you haven't yet checked out the readme file, please do.\n\n\n\n\n^^^^\nThis is your cursor.\nUse your keyboard to move (Default: WASD) the cursor down to those red blocks and flip (Default: ENTER) them so that they are all touching.\nWhen 3 or more blocks of the same color are lined up, they disappear.",
	}, -- [1]
	{
		["code"] = "022020002000000000000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1609999999636784, -- [2]
			2, -- [3]
			0.342000000004191, -- [4]
			2, -- [5]
			0.5150000000139698, -- [6]
			2, -- [7]
			0.6809999999823049, -- [8]
			2, -- [9]
			0.8329999999841675, -- [10]
			2, -- [11]
			0.9980000000214204, -- [12]
			5, -- [13]
			1.168999999994412, -- [14]
			0, -- [15]
			0, -- [16]
			0, -- [17]
			0, -- [18]
		},
		["numMoves"] = 1,
		["text"] = "Blocks which are flipped into empty space will fall. Blocks can only be flipped horizontally, so to move blocks down a row you will need to make them fall.\n\nClearing more than 3 blocks simultaneously is known as a \"Combo\", and will give you bonus points.",
	}, -- [2]
	{
		["code"] = "092990092990029220002000002000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2319999999599531, -- [2]
			2, -- [3]
			0.3819999999832362, -- [4]
			2, -- [5]
			0.5669999999809079, -- [6]
			2, -- [7]
			0.739000000001397, -- [8]
			2, -- [9]
			0.9149999999790452, -- [10]
			3, -- [11]
			1.103000000002794, -- [12]
			5, -- [13]
			1.316999999980908, -- [14]
			0, -- [15]
			0, -- [16]
			0, -- [17]
			0, -- [18]
		},
		["numMoves"] = 1,
		["text"] = "Blocks can only be cleared horizontally or vertically. Diagonal lines don't count.",
	}, -- [3]
	{
		["code"] = "002300003200002300003200002300000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.260999999998603, -- [2]
			2, -- [3]
			0.4660000000149012, -- [4]
			2, -- [5]
			0.6460000000079162, -- [6]
			5, -- [7]
			0.8209999999962747, -- [8]
			2, -- [9]
			1.018000000040047, -- [10]
			2, -- [11]
			1.195999999996275, -- [12]
			2, -- [13]
			1.366000000038184, -- [14]
			2, -- [15]
			1.540000000037253, -- [16]
			5, -- [17]
			1.78100000001723, -- [18]
			1, -- [19]
			1.958000000042375, -- [20]
			1, -- [21]
			2.146000000007916, -- [22]
			5, -- [23]
			2.40500000002794, -- [24]
			0, -- [25]
			0, -- [26]
			0, -- [27]
			0, -- [28]
		},
		["numMoves"] = 3,
		["text"] = "Carefully arranging large groups of blocks can result in big combos. \n\nBe careful not to clear 3 when you could have cleared 10 with a little more thought!",
	}, -- [4]
	{
		["code"] = "092990092990044040002000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2199999999720603, -- [2]
			2, -- [3]
			0.3919999999925494, -- [4]
			2, -- [5]
			0.5540000000037253, -- [6]
			2, -- [7]
			0.7289999999920838, -- [8]
			2, -- [9]
			0.9459999999962747, -- [10]
			4, -- [11]
			1.12699999997858, -- [12]
			5, -- [13]
			1.343999999982771, -- [14]
			0, -- [15]
			0, -- [16]
			0, -- [17]
			0, -- [18]
		},
		["numMoves"] = 1,
		["text"] = "\"Chains\" are formed when blocks fall without your direct input and cause an additional match of 3 or more blocks.\n\n Chains are worth the most points, and are vital to success in multiplayer.",
	}, -- [5]
	{
		["code"] = "001410000940000400000100000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1390000000246801, -- [2]
			2, -- [3]
			0.2770000000018627, -- [4]
			2, -- [5]
			0.4280000000144355, -- [6]
			2, -- [7]
			0.5580000000190921, -- [8]
			2, -- [9]
			0.7050000000162982, -- [10]
			2, -- [11]
			0.8570000000181608, -- [12]
			4, -- [13]
			1.005999999993946, -- [14]
			5, -- [15]
			1.190999999991618, -- [16]
			0, -- [17]
			0, -- [18]
			0, -- [19]
			0, -- [20]
			0, -- [21]
			0, -- [22]
		},
		["numMoves"] = 1,
		["text"] = "Chains can be formed many different ways. Matching up 3 blocks in a row is one thing, but finding long chains is what seperates good players from mediocre ones.",
	}, -- [6]
	{
		["code"] = "025223000330000550000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1000000000349246, -- [2]
			2, -- [3]
			0.2600000000093132, -- [4]
			2, -- [5]
			0.4170000000158325, -- [6]
			2, -- [7]
			0.5869999999995343, -- [8]
			2, -- [9]
			0.753000000026077, -- [10]
			2, -- [11]
			0.9210000000311993, -- [12]
			2, -- [13]
			1.057000000029802, -- [14]
			3, -- [15]
			1.227000000013504, -- [16]
			5, -- [17]
			1.40500000002794, -- [18]
			5, -- [19]
			2.857000000018161, -- [20]
			0, -- [21]
			0, -- [22]
			0, -- [23]
			0, -- [24]
		},
		["numMoves"] = 2,
		["text"] = "Chains will continue as long as one or more falling blocks goes untouched by you."
	}, -- [7]
	{
		["code"] = "999999925236999236999422999463119105000405000200000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1630000000004657, -- [2]
			2, -- [3]
			0.3910000000032596, -- [4]
			3, -- [5]
			0.617000000027474, -- [6]
			5, -- [7]
			0.8240000000223517, -- [8]
			3, -- [9]
			0.9629999999888241, -- [10]
			5, -- [11]
			1.176000000035856, -- [12]
			4, -- [13]
			1.380000000004657, -- [14]
			4, -- [15]
			1.594000000040978, -- [16]
			2, -- [17]
			1.951999999990221, -- [18]
			2, -- [19]
			2.160000000032596, -- [20]
			2, -- [21]
			2.42000000004191, -- [22]
			2, -- [23]
			2.64000000001397, -- [24]
			5, -- [25]
			3.293999999994412, -- [26]
			4, -- [27]
			3.518000000040047, -- [28]
			4, -- [29]
			3.710000000020955, -- [30]
			1, -- [31]
			3.867000000027474, -- [32]
			1, -- [33]
			4.032000000006519, -- [34]
			1, -- [35]
			4.243000000016764, -- [36]
			5, -- [37]
			4.563000000023749, -- [38]
			1, -- [39]
			4.835000000020955, -- [40]
			5, -- [41]
			4.972000000008848, -- [42]
			0, -- [43]
			0, -- [44]
			0, -- [45]
			0, -- [46]
			0, -- [47]
			0, -- [48]
		},
		["numMoves"] = 5,
		["text"] = "Pay attention to blocks that are about to fall. Often their landing spots hold the possibility of a chain or combo."
	}, -- [8]
	{
		["code"] = "392999020969020961030699030969000060000010000010000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1279999999678694, -- [2]
			2, -- [3]
			0.2619999999878928, -- [4]
			2, -- [5]
			0.4329999999608845, -- [6]
			2, -- [7]
			0.5810000000055879, -- [8]
			2, -- [9]
			0.8040000000037253, -- [10]
			2, -- [11]
			0.9709999999613501, -- [12]
			2, -- [13]
			1.154999999969732, -- [14]
			3, -- [15]
			1.312999999965541, -- [16]
			5, -- [17]
			1.447999999974854, -- [18]
			3, -- [19]
			1.588999999978114, -- [20]
			5, -- [21]
			2.742999999958556, -- [22]
			4, -- [23]
			2.98699999996461, -- [24]
			4, -- [25]
			3.135000000009313, -- [26]
			4, -- [27]
			3.331999999994878, -- [28]
			1, -- [29]
			3.492999999958556, -- [30]
			1, -- [31]
			3.649999999965075, -- [32]
			1, -- [33]
			3.968999999982771, -- [34]
			5, -- [35]
			4.166999999957625, -- [36]
			2, -- [37]
			4.413999999989756, -- [38]
			4, -- [39]
			4.472000000008848, -- [40]
			5, -- [41]
			5.416999999957625, -- [42]
			0, -- [43]
			0, -- [44]
			0, -- [45]
			0, -- [46]
		},
		["numMoves"] = 4,
		["text"] = "If you're quick, you can even cause chains by pushing blocks directly underneath blocks that are already falling.\n\nNOTE: If this demo fails, your framerate is too low. Try watching it again after pointing your camera at the ground or moving to a less crowded area."
	}, -- [9]
	{
		["code"] = "243420043400030300040300040400020400020200000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1510000000125729, -- [2]
			2, -- [3]
			0.3250000000116415, -- [4]
			2, -- [5]
			0.5100000000093132, -- [6]
			2, -- [7]
			0.7039999999688007, -- [8]
			5, -- [9]
			0.8589999999967404, -- [10]
			3, -- [11]
			1.055999999982305, -- [12]
			1, -- [13]
			1.288999999989756, -- [14]
			1, -- [15]
			1.496999999973923, -- [16]
			5, -- [17]
			1.742999999958556, -- [18]
			0, -- [19]
			0, -- [20]
			0, -- [21]
			0, -- [22]
		},
		["numMoves"] = 2,
		["text"] = "Try not to clear 3 blocks when you could have cleared more. Arrange blocks before they start to fall to increase your score and crush your opponents!"
	}, -- [10]
	{
		["code"] = "344644622410033450061260005460006140000500000000000000000000000000000000",
		["demo"] = {
			4, -- [1]
			0.1259999999892898, -- [2]
			2, -- [3]
			0.3239999999641441, -- [4]
			2, -- [5]
			0.4739999999874272, -- [6]
			2, -- [7]
			0.6379999999771826, -- [8]
			2, -- [9]
			0.779999999969732, -- [10]
			2, -- [11]
			0.9099999999743886, -- [12]
			2, -- [13]
			1.056999999971595, -- [14]
			2, -- [15]
			1.206000000005588, -- [16]
			5, -- [17]
			1.429000000003725, -- [18]
			0, -- [19]
			0, -- [20]
			0, -- [21]
			0, -- [22]
		},
		["numMoves"] = 1,
		["text"] = "Getting chains longer than 2x will prompt audio cues from your WoW character.\n\nKeep your eyes open for ways to create Chains and Combos from seemingly chaotic piles of blocks."
	}, -- [11]
	{
		["code"] = "442999003244002300003200004400000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1050000000395812, -- [2]
			2, -- [3]
			0.3490000000456348, -- [4]
			2, -- [5]
			0.5190000000293367, -- [6]
			2, -- [7]
			0.7010000000009313, -- [8]
			5, -- [9]
			0.8500000000349246, -- [10]
			2, -- [11]
			0.9960000000428408, -- [12]
			2, -- [13]
			1.159000000043307, -- [14]
			5, -- [15]
			1.336999999999534, -- [16]
			0, -- [17]
			0, -- [18]
			0, -- [19]
			0, -- [20]
		},
		["numMoves"] = 2,
		["text"] = "You can increase the size of chains by letting matching blocks fall to different heights. As long as chains are not simultaneous, they will continue to build on each other."
	}, -- [12]
	{
		["code"] = "561992591194112194502311603204002302002102001000006000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2979999999515712, -- [2]
			2, -- [3]
			0.4450000000069849, -- [4]
			2, -- [5]
			0.6099999999860302, -- [6]
			5, -- [7]
			0.8509999999660067, -- [8]
			0, -- [9]
			0, -- [10]
			0, -- [11]
			0, -- [12]
		},
		["numMoves"] = 1,
		["text"] = "Creating a small delay between falling blocks can allow you to cause very large chains with only a few blocks."
	}, -- [13]
	{
		["code"] = "123456000000000000000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			6, -- [1]
			1.3440000000409782, -- [2]
			6, -- [3]
			2.4740000000456348, -- [4]
			6, -- [3]
			3.4740000000456348, -- [4]
			6, -- [3]
			4.4740000000456348, -- [4]
			6, -- [3]
			5.4740000000456348, -- [4]
			7, -- [19]
			8, -- [20]
		},
		["numMoves"] = 1,
		["text"] = "In Multiplayer and Endless modes, blocks rise up from the ground. Press Q to bump the field up a single row.\n\nIf any blocks touch the top of the screen, clear them away as fast as possible! If they stay there for too long, you lose.",
	},
	{
		["code"] = "022020000000000000000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			2.3440000000409782, -- [2]
			2, -- [3]
			2.4740000000456348, -- [4]
			2, -- [5]
			2.6100000000442378, -- [6]
			2, -- [7]
			2.7490000000107102, -- [8]
			2, -- [9]
			2.8620000000228174, -- [10]
			2, -- [11]
			3.024000000033993, -- [12]
			2, -- [13]
			3.198000000033062, -- [14]
			4, -- [15]
			3.38800000003539, -- [16]
			5, -- [17]
			3.571000000054482, -- [18]
			0, -- [19]
			0, -- [20]
			0, -- [21]
			0, -- [22]
		},
		["numMoves"] = 1,
		["text"] = "MULTIPLAYER ONLY:\n\nGarbage blocks are created when your opponent causes a Combo or Chain. To clear away garbage, match 3 or more blocks that are touching the garbage directly.",
	},
	{
		["code"] = "309988302922600088300088300000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1609999999636784, -- [2]
			2, -- [3]
			0.342000000004191, -- [4]
			2, -- [5]
			0.5150000000139698, -- [6]
			2, -- [7]
			0.6809999999823049, -- [8]
			2, -- [9]
			0.8329999999841675, -- [10]
			2, -- [11]
			0.9980000000214204, -- [12]
			5, -- [13]
			1.168999999994412, -- [14]
			0, -- [15]
			0, -- [16]
			0, -- [17]
			0, -- [18]
		},
		["numMoves"] = 1,
		["text"] = "MULTIPLAYER ONLY:\n\n?-blocks are very rare, but matching 4 or more of them at the same time will grant you a powerup for a short duration.\n\n4 blocks: Bloodlust, which increases the size of all trash sent to your opponent.\n\n5 blocks: Corruption on your opponent, which generates garbage over time.\n\n6 blocks: Tranquility, which lowers the number of colors in play, instantly generating combos.",
	},
	{
		["numMoves"] = 1,
		["demo"] = {
			2, -- [1]
			0.1130000000121072, -- [2]
			2, -- [3]
			0.2650000000139698, -- [4]
			2, -- [5]
			0.4290000000037253, -- [6]
			2, -- [7]
			0.5929999999934807, -- [8]
			2, -- [9]
			0.760999999998603, -- [10]
			5, -- [11]
			0.9170000000158325, -- [12]
			0, -- [13]
			0, -- [14]
			0, -- [15]
			0, -- [16]
		},
		["code"] = "013000003000001000003000003000001000000000000000000000000000000000000000",
		["text"] = "See if you can clear all the blocks on-screen within the allowed number of moves!\n\nIf you want to watch the solution, click \"Give Up\", but try to figure them out for yourself first."
	}, -- [1]
	{
		["code"] = "056561056110000000000000000000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.04200000001583248, -- [2]
			2, -- [3]
			0.2299999999813736, -- [4]
			2, -- [5]
			0.3890000000246801, -- [6]
			2, -- [7]
			0.5819999999948777, -- [8]
			2, -- [9]
			0.7650000000139698, -- [10]
			2, -- [11]
			0.9390000000130385, -- [12]
			2, -- [13]
			1.136999999987893, -- [14]
			5, -- [15]
			1.311999999976251, -- [16]
			3, -- [17]
			1.416000000026543, -- [18]
			3, -- [19]
			1.62400000001071, -- [20]
			1, -- [21]
			1.808000000019092, -- [22]
			5, -- [23]
			1.978000000002794, -- [24]
			0, -- [25]
			0, -- [26]
			0, -- [27]
			0, -- [28]
		},
		["numMoves"] = 2,
	}, -- [2]
	{
		["code"] = "026300011000026000062000026000033000001000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.3070000000298023, -- [2]
			5, -- [3]
			0.7870000000111759, -- [4]
			3, -- [5]
			1.137000000046101, -- [6]
			2, -- [7]
			1.253000000026077, -- [8]
			2, -- [9]
			1.48399999999674, -- [10]
			2, -- [11]
			1.689000000013039, -- [12]
			2, -- [13]
			1.895000000018627, -- [14]
			5, -- [15]
			2.972000000008848, -- [16]
			0, -- [17]
			0, -- [18]
			0, -- [19]
			0, -- [20]
		},
		["numMoves"] = 2,
	}, -- [3]
	{
		["code"] = "116330055650036000060000010000000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.3059999999823049, -- [2]
			2, -- [3]
			0.4729999999981374, -- [4]
			2, -- [5]
			0.6410000000032596, -- [6]
			2, -- [7]
			0.7779999999911524, -- [8]
			2, -- [9]
			0.9120000000111759, -- [10]
			3, -- [11]
			1.056999999971595, -- [12]
			5, -- [13]
			1.193999999959488, -- [14]
			2, -- [15]
			1.304000000003725, -- [16]
			2, -- [17]
			1.423999999999069, -- [18]
			5, -- [19]
			1.539999999979045, -- [20]
			1, -- [21]
			1.628999999957159, -- [22]
			4, -- [23]
			1.722999999998137, -- [24]
			5, -- [25]
			1.885000000009313, -- [26]
			3, -- [27]
			1.963999999978114, -- [28]
			5, -- [29]
			2.059000000008382, -- [30]
			0, -- [31]
			0, -- [32]
			0, -- [33]
			0, -- [34]
		},
		["numMoves"] = 4,
	}, -- [4]
	{
		["code"] = "022621006150000510000250000600000000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2669999999925494, -- [2]
			2, -- [3]
			0.4990000000107102, -- [4]
			2, -- [5]
			0.6950000000069849, -- [6]
			5, -- [7]
			0.9000000000232831, -- [8]
			2, -- [9]
			1.094000000040978, -- [10]
			5, -- [11]
			1.443000000028405, -- [12]
			4, -- [13]
			1.563000000023749, -- [14]
			4, -- [15]
			1.744999999995343, -- [16]
			2, -- [17]
			1.869999999995343, -- [18]
			2, -- [19]
			2.053000000014436, -- [20]
			5, -- [21]
			2.190000000002328, -- [22]
			2, -- [23]
			2.307000000029802, -- [24]
			3, -- [25]
			2.684000000008382, -- [26]
			3, -- [27]
			2.853999999992084, -- [28]
			5, -- [29]
			3.012000000046101, -- [30]
			0, -- [31]
			0, -- [32]
			0, -- [33]
			0, -- [34]
		},
		["numMoves"] = 4,
	}, -- [5]
	{
		["code"] = "332233326623244552116166244552321123362263042250040050010010030030030030",
		["demo"] = {
			2, -- [1]
			0.3360000000102446, -- [2]
			2, -- [3]
			0.5389999999897555, -- [4]
			2, -- [5]
			0.7889999999897555, -- [6]
			3, -- [7]
			0.989000000001397, -- [8]
			3, -- [9]
			1.167000000015833, -- [10]
			5, -- [11]
			1.298999999999069, -- [12]
			4, -- [13]
			1.400000000023283, -- [14]
			4, -- [15]
			1.571999999985565, -- [16]
			4, -- [17]
			1.727000000013504, -- [18]
			4, -- [19]
			1.883000000030734, -- [20]
			5, -- [21]
			2.053000000014436, -- [22]
			3, -- [23]
			2.157999999995809, -- [24]
			3, -- [25]
			2.361000000033528, -- [26]
			2, -- [27]
			2.551000000035856, -- [28]
			2, -- [29]
			2.722999999998137, -- [30]
			3, -- [31]
			2.899000000033993, -- [32]
			3, -- [33]
			3.067000000039116, -- [34]
			5, -- [35]
			3.203000000037719, -- [36]
			4, -- [37]
			3.314000000013039, -- [38]
			4, -- [39]
			3.464000000036322, -- [40]
			4, -- [41]
			3.646000000007916, -- [42]
			4, -- [43]
			3.85899999999674, -- [44]
			5, -- [45]
			4.035000000032596, -- [46]
			3, -- [47]
			4.14100000000326, -- [48]
			3, -- [49]
			4.298000000009779, -- [50]
			1, -- [51]
			4.494999999995343, -- [52]
			5, -- [53]
			4.720000000030268, -- [54]
			0, -- [55]
			0, -- [56]
			0, -- [57]
			0, -- [58]
		},
		["numMoves"] = 5,
	}, -- [6]
	{
		["numMoves"] = 4,
		["demo"] = {
			2, -- [1]
			0.1780000000144355, -- [2]
			2, -- [3]
			0.396999999997206, -- [4]
			2, -- [5]
			0.6330000000307336, -- [6]
			2, -- [7]
			0.8400000000256114, -- [8]
			2, -- [9]
			1.052000000025146, -- [10]
			3, -- [11]
			1.26600000000326, -- [12]
			5, -- [13]
			1.490999999979977, -- [14]
			2, -- [15]
			1.658999999985099, -- [16]
			2, -- [17]
			1.836000000010245, -- [18]
			5, -- [19]
			2.010999999998603, -- [20]
			4, -- [21]
			2.12300000002142, -- [22]
			4, -- [23]
			2.316999999980908, -- [24]
			1, -- [25]
			2.495999999984633, -- [26]
			5, -- [27]
			2.658999999985099, -- [28]
			3, -- [29]
			2.813000000023749, -- [30]
			5, -- [31]
			3.204000000027008, -- [32]
			0, -- [33]
			0, -- [34]
			0, -- [35]
			0, -- [36]
		},
		["code"] = "041310013140041310000000000000000000000000000000000000000000000000000000",
	}, -- [7]
	{
		["code"] = "424400551600611000620000250000040000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2099999999627471, -- [2]
			2, -- [3]
			0.4020000000018627, -- [4]
			2, -- [5]
			0.6020000000135042, -- [6]
			3, -- [7]
			0.7889999999897555, -- [8]
			3, -- [9]
			1.002999999967869, -- [10]
			5, -- [11]
			1.212999999988824, -- [12]
			4, -- [13]
			1.355999999970663, -- [14]
			4, -- [15]
			1.527999999991152, -- [16]
			2, -- [17]
			1.787000000011176, -- [18]
			2, -- [19]
			1.945999999996275, -- [20]
			2, -- [21]
			2.133999999961816, -- [22]
			5, -- [23]
			2.273999999975786, -- [24]
			3, -- [25]
			2.392999999981839, -- [26]
			5, -- [27]
			2.47099999996135, -- [28]
			3, -- [29]
			2.586000000010245, -- [30]
			5, -- [31]
			2.746999999973923, -- [32]
			0, -- [33]
			0, -- [34]
			0, -- [35]
			0, -- [36]
		},
		["numMoves"] = 4,
		["diff"] = 2,
	}, -- [8]
	{
		["code"] = "034460015340052230015120000660000000000000000000000000000000000000000000",
		["demo"] = {
			3, -- [1]
			0.03700000001117587, -- [2]
			2, -- [3]
			0.1309999999939464, -- [4]
			2, -- [5]
			0.364000000001397, -- [6]
			2, -- [7]
			0.5489999999990687, -- [8]
			2, -- [9]
			0.7650000000139698, -- [10]
			5, -- [11]
			0.948000000033062, -- [12]
			2, -- [13]
			1.168000000005122, -- [14]
			2, -- [15]
			1.40400000003865, -- [16]
			2, -- [17]
			1.599000000045635, -- [18]
			4, -- [19]
			1.847999999998137, -- [20]
			4, -- [21]
			1.936000000045169, -- [22]
			4, -- [23]
			2.38800000003539, -- [24]
			5, -- [25]
			2.657000000006519, -- [26]
			3, -- [27]
			2.982000000018161, -- [28]
			3, -- [29]
			3.177000000025146, -- [30]
			3, -- [31]
			3.380999999993946, -- [32]
			5, -- [33]
			4.534000000043307, -- [34]
			0, -- [35]
			0, -- [36]
			0, -- [37]
			0, -- [38]
		},
		["numMoves"] = 3,
		["diff"] = 2,
	}, -- [9]
	{
		["code"] = "066550046410003410002330002020000050000010000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1950000000069849, -- [2]
			2, -- [3]
			0.3649999999906868, -- [4]
			2, -- [5]
			0.5860000000102446, -- [6]
			5, -- [7]
			0.7740000000339933, -- [8]
			2, -- [9]
			0.867000000027474, -- [10]
			2, -- [11]
			1.057000000029802, -- [12]
			2, -- [13]
			1.23399999999674, -- [14]
			5, -- [15]
			1.465000000025611, -- [16]
			4, -- [17]
			1.543999999994412, -- [18]
			4, -- [19]
			1.805999999982305, -- [20]
			1, -- [21]
			1.912000000011176, -- [22]
			1, -- [23]
			2.080000000016298, -- [24]
			1, -- [25]
			2.187000000034459, -- [26]
			1, -- [27]
			2.39100000000326, -- [28]
			5, -- [29]
			2.630999999993946, -- [30]
			0, -- [31]
			0, -- [32]
			0, -- [33]
			0, -- [34]
			0, -- [35]
			0, -- [36]
			0, -- [37]
			0, -- [38]
		},
		["numMoves"] = 3,
		["diff"] = 2,
	}, -- [10]
	{
		["code"] = "004400006100002100002400004200006400006400000100000100000000000000000000",
		["demo"] = {
			2, -- [1]
			0.254999999946449, -- [2]
			2, -- [3]
			0.4130000000004657, -- [4]
			4, -- [5]
			0.6999999999534339, -- [6]
			5, -- [7]
			0.9039999999804422, -- [8]
			3, -- [9]
			1.393999999971129, -- [10]
			2, -- [11]
			1.636999999987893, -- [12]
			5, -- [13]
			1.992999999958556, -- [14]
			0, -- [15]
			0, -- [16]
			0, -- [17]
			0, -- [18]
		},
		["numMoves"] = 2,
		["diff"] = 2,
	}, -- [11]
	{
		["code"] = "252665454110635330056600056000012000040000000000000000000000000000000000",
		["demo"] = {
			3, -- [1]
			0.1429999999818392, -- [2]
			2, -- [3]
			0.3999999999650754, -- [4]
			2, -- [5]
			0.5959999999613501, -- [6]
			5, -- [7]
			0.9759999999660067, -- [8]
			2, -- [9]
			1.185999999986962, -- [10]
			2, -- [11]
			1.34499999997206, -- [12]
			5, -- [13]
			1.543000000005122, -- [14]
			4, -- [15]
			1.654999999969732, -- [16]
			5, -- [17]
			1.798999999999069, -- [18]
			2, -- [19]
			1.945000000006985, -- [20]
			5, -- [21]
			2.104999999981374, -- [22]
			4, -- [23]
			2.217000000004191, -- [24]
			5, -- [25]
			2.353999999992084, -- [26]
			0, -- [27]
			0, -- [28]
			0, -- [29]
			0, -- [30]
		},
		["numMoves"] = 5,
		["diff"] = 2,
	}, -- [12]
	{
		["code"] = "256454661510233650206450005010003000000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.3649999999906868, -- [2]
			2, -- [3]
			0.6210000000428408, -- [4]
			2, -- [5]
			0.856000000028871, -- [6]
			2, -- [7]
			1.128000000026077, -- [8]
			2, -- [9]
			1.42000000004191, -- [10]
			5, -- [11]
			1.785000000032596, -- [12]
			2, -- [13]
			2.326000000000931, -- [14]
			2, -- [15]
			2.597000000008848, -- [16]
			4, -- [17]
			2.847000000008848, -- [18]
			5, -- [19]
			3.270000000018627, -- [20]
			1, -- [21]
			3.975000000034925, -- [22]
			5, -- [23]
			4.355000000039581, -- [24]
			0, -- [25]
			0, -- [26]
			0, -- [27]
			0, -- [28]
		},
		["numMoves"] = 3,
		["diff"] = 2,
	}, -- [13]
	{
		["code"] = "033200044200044300033000043000004000002000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.1560000000172295, -- [2]
			2, -- [3]
			0.3090000000083819, -- [4]
			2, -- [5]
			0.4800000000395812, -- [6]
			2, -- [7]
			0.6490000000339933, -- [8]
			3, -- [9]
			0.823000000033062, -- [10]
			3, -- [11]
			0.9490000000223517, -- [12]
			5, -- [13]
			1.098999999987427, -- [14]
			4, -- [15]
			1.206000000005588, -- [16]
			4, -- [17]
			1.351000000024214, -- [18]
			2, -- [19]
			1.467999999993481, -- [20]
			5, -- [21]
			1.591000000014901, -- [22]
			5, -- [23]
			3.482000000018161, -- [24]
			0, -- [25]
			0, -- [26]
			0, -- [27]
			0, -- [28]
		},
		["numMoves"] = 3,
		["diff"] = 2,
	}, -- [14]
	{
		["code"] = "035430035420042530035430002200002200005400004000005000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2249999999767169, -- [2]
			2, -- [3]
			0.4189999999944121, -- [4]
			2, -- [5]
			0.6049999999813736, -- [6]
			2, -- [7]
			0.8519999999552965, -- [8]
			5, -- [9]
			1.092999999993481, -- [10]
			2, -- [11]
			1.304999999993015, -- [12]
			3, -- [13]
			1.535999999963678, -- [14]
			5, -- [15]
			1.783999999985099, -- [16]
			4, -- [17]
			1.906999999948312, -- [18]
			1, -- [19]
			2.176999999966938, -- [20]
			1, -- [21]
			2.380999999993946, -- [22]
			1, -- [23]
			2.600999999966007, -- [24]
			1, -- [25]
			2.784999999974389, -- [26]
			1, -- [27]
			2.979999999981374, -- [28]
			5, -- [29]
			3.156999999948312, -- [30]
			2, -- [31]
			3.347999999998137, -- [32]
			2, -- [33]
			3.690000000002328, -- [34]
			2, -- [35]
			3.932999999960885, -- [36]
			2, -- [37]
			4.1129999999539, -- [38]
			2, -- [39]
			4.273999999975786, -- [40]
			2, -- [41]
			4.430999999982305, -- [42]
			5, -- [43]
			4.577999999979511, -- [44]
			0, -- [45]
			0, -- [46]
			0, -- [47]
			0, -- [48]
		},
		["numMoves"] = 4,
		["diff"] = 3,
	}, -- [15]
	{
		["code"] = "022330012310050500000200000100000500000000000000000000000000000000000000",
		["demo"] = {
			2, -- [1]
			0.2419999999692664, -- [2]
			2, -- [3]
			0.4389999999548309, -- [4]
			2, -- [5]
			0.651999999943655, -- [6]
			2, -- [7]
			0.8399999999674037, -- [8]
			2, -- [9]
			1.055999999982305, -- [10]
			5, -- [11]
			1.294999999983702, -- [12]
			4, -- [13]
			1.702999999979511, -- [14]
			5, -- [15]
			2.146999999997206, -- [16]
			2, -- [17]
			2.510999999998603, -- [18]
			5, -- [19]
			2.992999999958556, -- [20]
			3, -- [21]
			3.191999999980908, -- [22]
			5, -- [23]
			3.493999999947846, -- [24]
			4, -- [25]
			3.706999999994878, -- [26]
			4, -- [27]
			3.96999999997206, -- [28]
			5, -- [29]
			4.401999999943655, -- [30]
			0, -- [31]
			0, -- [32]
			0, -- [33]
			0, -- [34]
		},
		["numMoves"] = 5,
		["diff"] = 3,
	}, -- [16]
	{
		["code"] = "050600030100050100030400020300020300060600030300020400050400030300000100",
		["demo"] = {
			3, -- [1]
			0.2349999999860302, -- [2]
			2, -- [3]
			0.404999999969732, -- [4]
			5, -- [5]
			0.6080000000074506, -- [6]
			2, -- [7]
			0.75, -- [8]
			2, -- [9]
			0.9149999999790452, -- [10]
			2, -- [11]
			1.070999999996275, -- [12]
			2, -- [13]
			1.221000000019558, -- [14]
			2, -- [15]
			1.375, -- [16]
			5, -- [17]
			1.48399999999674, -- [18]
			1, -- [19]
			2.157999999995809, -- [20]
			1, -- [21]
			2.347999999998137, -- [22]
			1, -- [23]
			2.529999999969732, -- [24]
			1, -- [25]
			2.721000000019558, -- [26]
			5, -- [27]
			2.945999999996275, -- [28]
			4, -- [29]
			3.527000000001863, -- [30]
			4, -- [31]
			3.680999999982305, -- [32]
			1, -- [33]
			3.886999999987893, -- [34]
			5, -- [35]
			4.451000000000931, -- [36]
			3, -- [37]
			4.934999999997672, -- [38]
			3, -- [39]
			5.119999999995343, -- [40]
			2, -- [41]
			5.368000000016764, -- [42]
			2, -- [43]
			5.593999999982771, -- [44]
			5, -- [45]
			8.13900000002468, -- [46]
			0, -- [47]
			0, -- [48]
			0, -- [49]
			0, -- [50]
			0, -- [51]
			0, -- [52]
			0, -- [53]
			0, -- [54]
			1, -- [55]
			7.032000000006519, -- [56]
			1, -- [57]
			7.177000000025146, -- [58]
			0, -- [59]
			0, -- [60]
			0, -- [61]
			0, -- [62]
		},
		["numMoves"] = 5,
		["diff"] = 3,
	}, -- [17]
	{
		["numMoves"] = 4,
		["demo"] = {
			2, -- [1]
			0.1199999999953434, -- [2]
			2, -- [3]
			0.3379999999888241, -- [4]
			2, -- [5]
			0.5580000000190921, -- [6]
			2, -- [7]
			0.760999999998603, -- [8]
			2, -- [9]
			0.9740000000456348, -- [10]
			5, -- [11]
			1.157000000006519, -- [12]
			2, -- [13]
			1.291000000026543, -- [14]
			2, -- [15]
			1.510000000009313, -- [16]
			5, -- [17]
			1.735000000044238, -- [18]
			1, -- [19]
			1.907999999995809, -- [20]
			1, -- [21]
			2.074000000022352, -- [22]
			1, -- [23]
			2.233000000007451, -- [24]
			1, -- [25]
			2.409000000043307, -- [26]
			1, -- [27]
			2.570999999996275, -- [28]
			1, -- [29]
			2.90500000002794, -- [30]
			1, -- [31]
			3.038999999989756, -- [32]
			1, -- [33]
			3.195000000006985, -- [34]
			1, -- [35]
			3.347000000008848, -- [36]
			1, -- [37]
			3.51600000000326, -- [38]
			3, -- [39]
			3.674999999988359, -- [40]
			3, -- [41]
			3.820000000006985, -- [42]
			5, -- [43]
			4, -- [44]
			4, -- [45]
			4.15400000003865, -- [46]
			4, -- [47]
			4.324000000022352, -- [48]
			4, -- [49]
			4.470000000030268, -- [50]
			2, -- [51]
			4.663000000000466, -- [52]
			2, -- [53]
			4.830000000016298, -- [54]
			2, -- [55]
			4.985000000044238, -- [56]
			2, -- [57]
			5.12599999998929, -- [58]
			2, -- [59]
			5.28000000002794, -- [60]
			2, -- [61]
			5.421000000031199, -- [62]
			2, -- [63]
			5.548999999999069, -- [64]
			2, -- [65]
			5.711999999999534, -- [66]
			2, -- [67]
			5.852000000013504, -- [68]
			5, -- [69]
			5.987000000022817, -- [70]
			0, -- [71]
			0, -- [72]
			0, -- [73]
			0, -- [74]
		},
		["code"] = "022600011200044100066400033600055300033500046400046100012100020300000000",
		["diff"] = 3,
	}, -- [18]
	{
		["code"] = "001200001600003500003200001400004500005600002600003100004100004200000000",
		["demo"] = {
			3, -- [1]
			0.08100000000558794, -- [2]
			5, -- [3]
			0.5979999999981374, -- [4]
			5, -- [5]
			1.326000000000931, -- [6]
			2, -- [7]
			1.548000000009779, -- [8]
			2, -- [9]
			1.863000000012107, -- [10]
			2, -- [11]
			2.028999999980442, -- [12]
			2, -- [13]
			2.228999999992084, -- [14]
			4, -- [15]
			2.429999999993015, -- [16]
			4, -- [17]
			2.583999999973457, -- [18]
			5, -- [19]
			2.718999999982771, -- [20]
			2, -- [21]
			2.858000000007451, -- [22]
			2, -- [23]
			3.029999999969732, -- [24]
			2, -- [25]
			3.181999999971595, -- [26]
			3, -- [27]
			3.348999999987427, -- [28]
			5, -- [29]
			3.577999999979511, -- [30]
			3, -- [31]
			3.724999999976717, -- [32]
			1, -- [33]
			3.827999999979511, -- [34]
			5, -- [35]
			4.070000000006985, -- [36]
			4, -- [37]
			4.87599999998929, -- [38]
			1, -- [39]
			5.012999999977183, -- [40]
			1, -- [41]
			5.165999999968335, -- [42]
			5, -- [43]
			5.869999999995343, -- [44]
			0, -- [45]
			0, -- [46]
			0, -- [47]
			0, -- [48]
		},
		["numMoves"] = 6,
		["diff"] = 3,
		["text"] = "This is the final puzzle. If you've beaten them all without giving up on any, Congratulations!"
	}, -- [19]
}

function TetrisAttack_GetPuzzleInfo(num, demo)

	local code = BasePuzzles[num]["code"]
	for Key, Val in pairs(BasePuzzles[num]["demo"]) do
		demo[Key] = Val
	end
	local numMoves = BasePuzzles[num]["numMoves"]
	local diff = BasePuzzles[num]["diff"] or 1
	local text = BasePuzzles[num]["text"] or ""
	return code, numMoves, diff, text
end

function TetrisAttack_GetCustomPuzzleInfo(num, demo)

	local code = TetrisAttack_SavedPuzzles[num]["code"]
	for Key, Val in pairs(TetrisAttack_SavedPuzzles[num]["demo"]) do
		demo[Key] = Val
	end
	local numMoves = TetrisAttack_SavedPuzzles[num]["numMoves"]
	local diff = TetrisAttack_SavedPuzzles[num]["diff"] or 1
	local text = TetrisAttack_SavedPuzzles[num]["text"] or ""
	return code, numMoves, diff, text
end

