local function debug(msg)
	DEFAULT_CHAT_FRAME:AddMessage("FDLogger: "..msg)
end

FDLog = {}

local function FormatTime(t,ms)
	local t = tostring(t)
    if not t:match("%.%d+") then t = t..".000" elseif #(t:match("%.%d+")) == 2 then t = t.."00" elseif #(t:match("%.%d+")) == 3 then t = t.."0" end
    if ms then
		return tonumber(t:sub(-3))
    else
    	return t
    end
end

local currenttime, uptime, round, offset = time(), GetTime()
if FormatTime(uptime, true) > 500 then round = math.ceil else round = math.floor end
offset = currenttime - round(uptime)

local function FDLogger_OnEvent(self, event, unit)
	if not unit:match("(raid%d+)") then return end
	if (select(2,UnitClass(unit))) ~= "HUNTER" then return end
	local timestamp = FormatTime(offset + GetTime())
--	local UnitIsFeignDeath = function(...) return true end
--  if UnitIsFeignDeath(unit) then debug(timestamp.." |cffcfff00"..UnitName(unit).."|r is feigning death: |cff00ff00Yes|r") else debug(timestamp.." |cffcfff00"..UnitName(unit).."|r is feigning death: |cffff0000No|r") end
    if UnitIsFeignDeath(unit) then FDLog[timestamp]=UnitName(unit) end
end

local f = CreateFrame("Frame")
f:SetScript("OnEvent", FDLogger_OnEvent)
f:RegisterEvent("UNIT_HEALTH")

--[[
local function FDLogger_ThreatLog(self, event, prefix, msg, scope, sender)
	if event ~= "CHAT_MSG_ADDON" or prefix ~= "TL2" then return end
	local timestamp = FormatTime(offset + GetTime())
--	debug(timestamp.." T "..msg)
	if msg:match("^%^") then
	    local success,a,b,c,d,e,f,g = LibStub("AceSerializer-3.0"):Deserialize(msg)
	    if success then
	        local output = ""
	        if type(b) ~= "nil" then if type(b) == "boolean" then b=tostring(b) end output = output..b.." "
	        if type(c) ~= "nil" then if type(c) == "boolean" then c=tostring(c) end output = output..c.." "
	        if type(d) ~= "nil" then if type(d) == "boolean" then d=tostring(d) end output = output..d.." "
	        if type(e) ~= "nil" then if type(e) == "boolean" then e=tostring(e) end output = output..e.." "
	        if type(f) ~= "nil" then if type(f) == "boolean" then f=tostring(f) end output = output..f.." "
	        if type(g) ~= "nil" then if type(g) == "boolean" then g=tostring(g) end output = output..g end end end end end end
			if a then
    		debug(timestamp.." TD-A "..LibStub("Threat-2.0"):Dememoize(a).." "..output)
    		end
    	else
    		debug(timestamp.." TD-A failed "..a)
    	end
	else
		local a,b = msg:match("^(..)(.*)$")
		a = LibStub("Threat-2.0"):Dememoize(a)
	    debug(timestamp.." TD "..a.." "..b)
		if a == "THREAT_UPDATE" then
		   	local tag = guid_decompress[(strmatch(msg, "^([^:]+)"))]
			if tag then
				for k, v in string.gmatch(msg, "([^=:]+)=(%d+),") do
					local dstGUID, threat = guid_decompress[k], tonumber(v)
					if dstGUID and threat then
						-- self:ThreatUpdatedForUnit(tag, dstGUID, threat)
						debug(timestamp.." TD-U "..tag.." "..dstGUID.." "..threat)
					end
				end
			end
		end
	end
end

local g = CreateFrame("Frame")
g:SetScript("OnEvent",FDLogger_ThreatLog)
g:RegisterEvent("CHAT_MSG_ADDON")
--]]