EA_Config = { DoAlertSound, AlertSound, LockFrame, ShowFrame };

function EventAlert_OnLoad(self)
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

    this:RegisterEvent("PLAYER_LOGIN");
    this:RegisterEvent("PLAYER_ENTERING_WORLD");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("PLAYER_DEAD");

    EA_Frame:Hide();

    SlashCmdList["EVENTALERT"] = EventAlert_SlashHandler;
    SLASH_EVENTALERT1 = "/eventalert";
    SLASH_EVENTALERT2 = "/ea";


end


function EventAlert_OnEvent(event)

	if event == "VARIABLES_LOADED" then

    	if(not EA_Config.DoAlertSound) then EA_Config.DoAlertSound = true end;
        if(not EA_Config.AlertSound) then EA_Config.AlertSound = "Sound\\Spells\\ShaysBell.wav" end;
		if(not EA_Config.LockFrame) then EA_Config.LockFrame = true end;
   		if(not EA_Config.ShowFrame) then EA_Config.ShowFrame = true end;

        EA_Items = { ["Surge of Light"] = true,
		     ["Shadow Trance"] = true,
             ["Backlash"] = true,
             ["Focused Casting"] = true,
             ["Wrath of Elune"] = true,
             ["Healing Trance"] = true
           };


        EventAlert_Options_Init();
	end


	if(event == "COMBAT_LOG_EVENT_UNFILTERED") then

		local eventType = arg2;

		if(eventType == "SPELL_AURA_APPLIED" and arg7 == UnitName("player")) then
			if (EA_Items[arg10]) then

            	if (EA_Config.ShowFrame == true) then
	                local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(arg9);

    	            EA_Frame:SetBackdrop({bgFile = icon});
        	        EA_Alert_Name:SetText(arg10);

                	EA_Frame:Show();
                end

                if (EA_Config.DoAlertSound == true) then
	                PlaySoundFile(EA_Config.AlertSound);
                end

        	end
		end

        if(eventType == "SPELL_AURA_REMOVED" and arg7 == UnitName("player")) then
			if (EA_Items[arg10]) then
           		EA_Frame:Hide();
        	end
		end
	end

    if(event == "PLAYER_DEAD" or event == "PLAYER_ENTERING_WORLD") then
        EA_Frame:Hide();
    end

end



function EventAlert_SlashHandler(msg)

    msg = string.lower(msg);

	if msg == "options" then

    	if not EventAlert_Options:IsVisible() then
	        ShowUIPanel(EventAlert_Options);
	    else
	        HideUIPanel(EventAlert_Options);
	    end

    else
        DEFAULT_CHAT_FRAME:AddMessage("EventAlert commands (/eventalert or /ea):");
        DEFAULT_CHAT_FRAME:AddMessage("/ea options - Toggle the options window on or off");
    end

end

--[[
function EventAlert_MouseDown(button)
    if button == "LeftButton" and EA_Config.LockFrame == false then
        EA_Frame:StartMoving();
    end
end

function EventAlert_MouseUp(button)
    if button == "LeftButton" then
        EA_Frame:StopMovingOrSizing();
    end
end
]]--