-- All Languages

local ERRORREDIRECT_NAME = "Message Redirect";
local ERRORREDIRECT_VERSION = "20400";
local ERRORREDIRECT_SAVEVERSION = "20400";
local ERRORREDIRECT_LOCALIZATION = GetLocale();
local ERRORREDIRECT_DEFAULTFRAME = "UIErrorFrame";
local ERRORREDIRECT_DISCARDFRAME = "DevNull";

local DefaultColor = "red";
local ErrorRedirect_Colors = {
	["red"]    = {  r = 1.0, g = 0.0, b = 0.0  },
	["green"]  = {  r = 0.0, g = 1.0, b = 0.0  },
	["blue"]   = {  r = 0.0, g = 0.0, b = 1.0  },
	["yellow"] = {  r = 1.0, g = 1.0, b = 0.0  },
	["white"]  = {  r = 1.0, g = 1.0, b = 1.0  },
	["black"]  = {  r = 0.0, g = 0.0, b = 0.0  },
	["purple"] = {  r = 1.0, g = 0.0, b = 1.0  },
	["gray"]   = {  r = 0.7, g = 0.7, b = 0.7  },
	["orange"] = {  r = 1.0, g = 0.4, b = 0.2  },
	--add your own colors here
};

local ERRORREDIRECT_MYADDONS_RELEASEDATE;
local ERRORREDIRECT_CHATHELP1;
local ERRORREDIRECT_COMBOTEXT;
local ERRORREDIRECT_CUSTOMCOLOR;
local ERRORREDIRECT_SUPPRESSNIL;
local ERRORREDIRECT_DISCARD;
local ERRORREDIRECT_NOREDIRECT;
local ERRORREDIRECT_FAULTYGRAB;
local ERRORREDIRECT_OVERFLOW;

if( ERRORREDIRECT_LOCALIZATION == "deDE" ) then
	--
	-- German
	--

	ERRORREDIRECT_MYADDONS_RELEASEDATE = "April 14, 2008";

	ERRORREDIRECT_CHATHELP1 = "Message Redirect\n" .. ERRORREDIRECT_MYADDONS_RELEASEDATE .. " " .. ERRORREDIRECT_LOCALIZATION .. "\n\nError Redirect 2 filters all of the floating\nmessages into the selected chat frame instead of\ncluttering your screen.  Now your screen keeps clear\nfor the real important messages.\nType /err for options.\nBoth Red and Yellow messages can be\nredirected to different chat windows.\n\nThe first tab displays Messages that have\nbeen caught and are available to be\nadded to the exception list.\n\nThe second tab displays Exceptions which may\nhave different settings from the defaults\nlisted for Red or Yellow messages.\n\nThe third tab is this help message.";

	ERRORREDIRECT_COMBOTEXT = { "Disable", "Enable, discard", "Enable, no redirect", "Enable, redirect to %s" }
	ERRORREDIRECT_CUSTOMCOLOR = "Enable individual message color";
	ERRORREDIRECT_SUPPRESSNIL = "Redirect program errors to";

	ERRORREDIRECT_DISCARD = "Discard";
	ERRORREDIRECT_NOREDIRECT = "No Redirect";
	ERRORREDIRECT_FAULTYGRAB = "Set error handler failed.  Another MOD is already overriding.";
	ERRORREDIRECT_OVERFLOW = "Limit one unique message per";
elseif( ERRORREDIRECT_LOCALIZATION == "frFR" ) then
	--
	-- French
	--

	ERRORREDIRECT_MYADDONS_RELEASEDATE = "April 14, 2008";

	ERRORREDIRECT_CHATHELP1 = "Message Redirect\n" .. ERRORREDIRECT_MYADDONS_RELEASEDATE .. " " .. ERRORREDIRECT_LOCALIZATION .. "\n\nError Redirect 2 filters all of the floating\nmessages into the selected chat frame instead of\ncluttering your screen.  Now your screen keeps clear\nfor the real important messages.\nType /err for options.\nBoth Red and Yellow messages can be\nredirected to different chat windows.\n\nThe first tab displays Messages that have\nbeen caught and are available to be\nadded to the exception list.\n\nThe second tab displays Exceptions which may\nhave different settings from the defaults\nlisted for Red or Yellow messages.\n\nThe third tab is this help message.";

	ERRORREDIRECT_COMBOTEXT = { "Disable", "Enable, discard", "Enable, no redirect", "Enable, redirect to %s" }
	ERRORREDIRECT_CUSTOMCOLOR = "Enable individual message color";
	ERRORREDIRECT_SUPPRESSNIL = "Redirect program errors to";

	ERRORREDIRECT_DISCARD = "Discard";
	ERRORREDIRECT_NOREDIRECT = "No Redirect";
	ERRORREDIRECT_FAULTYGRAB = "Set error handler failed.  Another MOD is already overriding.";
	ERRORREDIRECT_OVERFLOW = "Limit one unique message per";
else --enUS
	--
	-- English
	--

	ERRORREDIRECT_MYADDONS_RELEASEDATE = "April 14, 2008";

	ERRORREDIRECT_CHATHELP1 = "Message Redirect\n" .. ERRORREDIRECT_MYADDONS_RELEASEDATE .. " " .. ERRORREDIRECT_LOCALIZATION .. "\n\nError Redirect 2 filters all of the floating\nmessages into the selected chat frame instead of\ncluttering your screen.  Now your screen keeps clear\nfor the real important messages.\nType /err for options.\nBoth Red and Yellow messages can be\nredirected to different chat windows.\n\nThe first tab displays Messages that have\nbeen caught and are available to be\nadded to the exception list.\n\nThe second tab displays Exceptions which may\nhave different settings from the defaults\nlisted for Red or Yellow messages.\n\nThe third tab is this help message.";

	ERRORREDIRECT_COMBOTEXT = { "Disable", "Enable, discard", "Enable, no redirect", "Enable, redirect to %s" }
	ERRORREDIRECT_CUSTOMCOLOR = "Enable individual message color";
	ERRORREDIRECT_SUPPRESSNIL = "Redirect program errors to";

	ERRORREDIRECT_DISCARD = "Discard";
	ERRORREDIRECT_NOREDIRECT = "No Redirect";
	ERRORREDIRECT_FAULTYGRAB = "Set error handler failed.  Another MOD is already overriding.";
	ERRORREDIRECT_OVERFLOW = "Limit one unique message per";
end

MessageRedirectLocalization = {
	Name = ERRORREDIRECT_NAME,
	Version = ERRORREDIRECT_VERSION,
	Save = ERRORREDIRECT_SAVEVERSION,
	Localization = ERRORREDIRECT_LOCALIZATION,
	defaultframe = ERRORREDIRECT_DEFAULTFRAME,
	discardframe = ERRORREDIRECT_DISCARDFRAME,
	Colors = ErrorRedirect_Colors,
	ReleaseDate = ERRORREDIRECT_MYADDONS_RELEASEDATE,
	ChatHelp = ERRORREDIRECT_CHATHELP1,
	ComboText = ERRORREDIRECT_COMBOTEXT,
	EnableColor = ERRORREDIRECT_CUSTOMCOLOR,
	SuppressErrors = ERRORREDIRECT_SUPPRESSNIL,
	Overflow = ERRORREDIRECT_OVERFLOW,
	Discard = ERRORREDIRECT_DISCARD,
	NoRedirect = ERRORREDIRECT_NOREDIRECT,
	FaultyGrab = ERRORREDIRECT_FAULTYGRAB,
	DefaultColor = DefaultColor,
}
