--
-- Error Redirect with GUI
--
-- by Thomas Watts
-- Original Error Redirect by Bastian Pflieger <wb@illogical.de>
-- Credits: Idea by Bunny, compiling original default filter lists
--
-- supports "myAddOns": http://www.curse.com/downloads/details/207/
--

--many variables needed from MessageRedirect
if( not MessageRedirect or not MessageRedirectLocalization ) then
	local err = geterrorhandler();
	err("MessageRedirect not found.  Options pane not loaded.");
	return;
end

--Delete Filter confirm dialog
StaticPopupDialogs["ERRORREDIRECT_DELETEFILTER"] = {
	text = "Delete exception '%s'?",
	button1 = "Delete",
	button2 = "Cancel",
	OnAccept = function() ErrorRedirectOptionsDelete_Delete(); end,
	data = "RUBBERBABYBUGGYBUMBERS",
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
	multiple = 0,
};

local DefaultColor = MessageRedirect.DefaultColor;
local FILTERS_PER_PAGE = 4;
local EXCEPTIONS_PER_PAGE = 8;

--sounds and fonts
local LSM_Fonts = 0;
local LSM_Sounds = 0;

--function stubs and variables
local ErrorRedirectOptions_FillPNEContainers;
local ErrorRedirectOptions_FillFilterContainers;
local ErrorRedirectOptionsPNEStart = 1;
local ER_ExceptionStart = 1;

local function ErrorRedirectOptionsCombo_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local EROFC = this.value;
	local prnt = this.owner:GetParent();
	local index = prnt.value;
	local lookup = prnt.lookup;
	local ero = lookup[index];

	ero.Enabled = EROFC[1] and true or nil;
	ero.Frame = EROFC[1] or nil;

	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());
	local fc = getglobal(prnt:GetName().."Font");
	if( MessageRedirect.LSM and EROFC[3] ) then
		fc:Show();
		UIDropDownMenu_SetSelectedName(fc, ero.Font or DEFAULT);
		UIDropDownMenu_SetText(ero.Font or DEFAULT, fc);
	else
		fc:Hide();
	end
end

local function ErrorRedirectOptionsCombo_Initialize()
	local parent = UIDropDownMenu_GetCurrentDropDown();

	local info1 = {
		text = MessageRedirectLocalization.ComboText[1],
		value = {false, DEFAULT, false},
		func = ErrorRedirectOptionsCombo_OnClick,
		owner = parent,
	};

	local info2 = {
		text = MessageRedirectLocalization.ComboText[2],
		value = {MessageRedirectLocalization.discardframe, MessageRedirectLocalization.Discard, false},
		func = ErrorRedirectOptionsCombo_OnClick,
		owner = parent,
	};

	local info3 = {
		text = MessageRedirectLocalization.ComboText[3],
		value = {MessageRedirectLocalization.defaultframe, MessageRedirectLocalization.NoRedirect, false},
		func = ErrorRedirectOptionsCombo_OnClick,
		owner = parent,
	};

	UIDropDownMenu_AddButton(info1);
	UIDropDownMenu_AddButton(info2);
	UIDropDownMenu_AddButton(info3);

	local infotemp;
	local mrlct = MessageRedirect.ComboTextString;
	local i = 1;
	for _, fr in ipairs(MessageRedirect.AvailableFrames) do
		if( i > 3 ) then
			MessageRedirectLocalization.ComboText[i] = string.format(mrlct, fr[2]);
			UIDropDownMenu_AddButton(
				{
					text = MessageRedirectLocalization.ComboText[i],
					value = fr,
					func = ErrorRedirectOptionsCombo_OnClick,
					owner = parent,
				}
			);
		end
		i = i + 1;
	end
end

local function ErrorRedirectOptionsCombo_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsCombo_Initialize);
	UIDropDownMenu_SetWidth(200, frame);
end

function ErrorRedirectOptionsOverflowActive_OnClick(frame)
	if( frame:GetChecked() ) then
		MessageRedirect.OnUpdate(true, ErrorRedirect_Options.Overflow.Time);
	else
		MessageRedirect.OnUpdate(nil, ErrorRedirect_Options.Overflow.Time);
	end
end

function ErrorRedirectOptionsOverflow_ValueChanged(frame)
	local num = frame:GetNumber() or 0;
	if( num > 0 ) then
		MessageRedirect.OnUpdate(ErrorRedirect_Options.Overflow.Enabled, num);
		frame:SetText(num);
	else
		MessageRedirect.OnUpdate(nil, nil);
		frame:SetText("0");
	end
end

function ErrorRedirectOptionsSuppressActive_OnClick()
	if( this:GetChecked() ) then
		if( geterrorhandler() == _ERRORMESSAGE ) then
			ErrorRedirect_Options.LuaErrors.Enabled = true;
			seterrorhandler(MessageRedirect.ErrorHandler);
		else
			ErrorRedirect_Options.LuaErrors.Enabled = nil;
			DEFAULT_CHAT_FRAME:AddMessage(MessageRedirectLocalization.FaultyGrab);
		end
	else
		ErrorRedirect_Options.LuaErrors.Enabled = nil;
		if( geterrorhandler() == MessageRedirect.ErrorHandler ) then
			seterrorhandler(_ERRORMESSAGE);
		end
	end
end

local function ErrorRedirectOptionsSuppressCombo_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local EROFC = this.value;
	ErrorRedirect_Options.LuaErrors.Frame = EROFC;
end

local function ErrorRedirectOptionsSuppressCombo_Initialize()
	local current_menu = UIDropDownMenu_GetCurrentDropDown();
	local eraf = MessageRedirect.AvailableFrames;
	local skip = 3; --skip first three values

	for _, fr in ipairs(eraf) do
		if( skip <= 0 ) then
			UIDropDownMenu_AddButton( {
				text = fr[2],
				value = fr[1],
				func = ErrorRedirectOptionsSuppressCombo_OnClick,
				owner = current_menu,
			} );
		else
			skip = skip - 1;
		end
	end
end

local function ErrorRedirectOptionsSuppressCombo_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsSuppressCombo_Initialize);
	UIDropDownMenu_SetWidth(100, frame);
end

local function ErrorRedirect_GetChatNumber(txt)
	local mraf = MessageRedirect.AvailableFrames;
	if( not txt ) then
		return mraf[1][2], 1, false; -- Default
	end
	for i, val in ipairs(mraf) do
		if( val[1] == txt ) then
			return val[2], i, val[3];
		end
	end
	return mraf[1][2], 1, false; -- Default
end

function ErrorRedirectOptionsFilterOption_OnClick(frame)
	local index = frame:GetParent().value;
	local filter = ER_Exceptions[index];
	filter[frame.option] = frame:GetChecked();
end

local function ErrorRedirectOptions_CheckButton_Viability(bS, curr, bE)
	if( curr > bS ) then
		ErrorRedirectOptionsMessagePrevButton:Enable();
	else
		ErrorRedirectOptionsMessagePrevButton:Disable();
	end
	if( curr + FILTERS_PER_PAGE <= bE ) then
		ErrorRedirectOptionsMessageNextButton:Enable();
	else
		ErrorRedirectOptionsMessageNextButton:Disable();
	end
end

local function ErrorRedirectOptions_FillFilterContainers()
	local index, frame, f1, f2, f3, f4, f5, f6, filters, fil;
	local filFrame, filColor, filStart, filLength, filFont;
	local i = 1;

	filters = ER_Exceptions;
	filStart = ER_ExceptionStart;
	filLength = ER_Exceptions.Length;

	ErrorRedirectOptions_CheckButton_Viability(1, filStart, filLength);

	while i <= FILTERS_PER_PAGE do
		frame = "ErrorRedirectOptionsMessageFilter"..i;
		if( not getglobal(frame) ) then
			return;
		end

		index = filStart + i - 1;
		index = MessageRedirect.RetrieveIndex(index);

		if( index ) then
			f1 = getglobal(frame.."Active");
			f7 = getglobal(frame.."Sticky");
			f2 = getglobal(frame.."LabelText");
			f3 = getglobal(frame.."Redirect");
			f4 = getglobal(frame.."Color");
			f5 = getglobal(frame.."Sound");
			f6 = getglobal(frame.."Font");

			frame = getglobal(frame);
			frame.value = index;
			frame.lookup = ER_Exceptions;
			frame:Show();

			fil = filters[index];
			if( not fil ) then
				return;
			end
			f1:SetChecked(fil.Enabled);
			f7:SetChecked(fil.Stickied);
			-- String length should remain under 60 characters or so
			f2:SetText(fil["String"]);

			filFrame = fil["Frame"] or 0;
			filFrame, id, filFont = ErrorRedirect_GetChatNumber(filFrame);
			UIDropDownMenu_SetSelectedID(f3, id);
			UIDropDownMenu_SetText(filFrame, f3);

			filColor = fil["Color"] or DefaultColor;
			UIDropDownMenu_SetSelectedName(f4, filColor);
			UIDropDownMenu_SetText(filColor, f4);
			filColor = MessageRedirect.Colors[filColor];
			f2:SetTextColor(filColor.r, filColor.g, filColor.b, 1.0);
			

			if( MessageRedirect.LSM ) then
				f5:Show();
				UIDropDownMenu_SetSelectedName(f5, fil.Sound or DEFAULT);
				UIDropDownMenu_SetText(fil.Sound or DEFAULT, f5);
				f6:Show();
				UIDropDownMenu_SetSelectedName(f6, fil.Font or DEFAULT);
				UIDropDownMenu_SetText(fil.Font or DEFAULT, f6);
			else
				f5:Hide();
				f6:Hide();
			end
			i = i + 1;
		else -- No filter to use
			getglobal(frame):Hide();
			i = i + 1;
		end
	end
end

function ErrorRedirectOptionsFilterButton_OnClick(frame)
	local start = ER_ExceptionStart;

	if( frame:GetID() == 1 ) then
		start = start - FILTERS_PER_PAGE;
	elseif( frame:GetID() == 2 ) then
		start = start + FILTERS_PER_PAGE;
	end

	ER_ExceptionStart = start;
	ErrorRedirectOptions_FillFilterContainers();
end

function ErrorRedirectOptionsPNEButton_OnClick(frame)
	local start = ErrorRedirectOptionsPNEStart;

	if( frame:GetID() == 1 ) then
		start = start - EXCEPTIONS_PER_PAGE;
	elseif( frame:GetID() == 2 ) then
		start = start + EXCEPTIONS_PER_PAGE;
	end

	ErrorRedirectOptionsPNEStart = start;
	ErrorRedirectOptions_FillPNEContainers();
end

local function ErrorRedirectOptions_PNE_Viability(bS, curr, bE)
	if( curr > bS ) then
		ErrorRedirectOptionsNewPrevButton:Enable();
	else
		ErrorRedirectOptionsNewPrevButton:Disable();
	end
	if( curr + EXCEPTIONS_PER_PAGE <= bE ) then
		ErrorRedirectOptionsNewNextButton:Enable();
	else
		ErrorRedirectOptionsNewNextButton:Disable();
	end
end

local function ErrorRedirectOptions_FillPNEContainers()
	local index, frame, fText, filters, fil;
	local filStart, fC;
	local i = 1;

	filters = MessageRedirect.MessageList;
	filStart = ErrorRedirectOptionsPNEStart;

	ErrorRedirectOptions_PNE_Viability(1, filStart, MessageRedirect.MessageLength);

	for i = 1, EXCEPTIONS_PER_PAGE, 1 do
		frame = "ErrorRedirectOptionsNewMessage"..i;
		if( not getglobal(frame) ) then
			return;
		end

		index = filStart + i - 1;
		fil = filters[index];

		if( fil ) then
			fText = getglobal(frame.."LabelText");
			frame = getglobal(frame);

			fC = MessageRedirect.Colors[(fil[2] or DefaultColor)];
			frame.value = fil[1];
			frame.color = fil[2];
			fText:SetText(fil[1]);
			fText:SetTextColor(fC.r, fC.g, fC.b, 1.0);
			frame:Show();
		else -- No filter to use
			getglobal(frame):Hide();
		end
	end
end

function ErrorRedirectOptionsPNEClear_OnClick()
	MessageRedirect.MessageList = {};
	ErrorRedirectOptionsPNEStart = 1;
	MessageRedirect.MessageLength = 0;
	MessageRedirect.MessageIndex = 1;
	ErrorRedirectOptions_FillPNEContainers();
end

function ErrorRedirectOptionsMessage_OnShow()
	ErrorRedirectOptions_FillPNEContainers();
	ErrorRedirectOptions_FillFilterContainers();
end

function ErrorRedirectOptionsNew_OnShow()
	ErrorRedirectOptions_FillPNEContainers();
end

--function ErrorRedirectOptionsHelp_OnClick()
	--ErrorRedirectOptionsHelp:SetText(MessageRedirectLocalization.ChatHelp);
	--ErrorRedirectOptionsHelp:Show();
--end

function ErrorRedirectOptionsFilterColor_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local prnt = this.owner:GetParent();
	local index = prnt.value;
	local filter = ER_Exceptions[index];
	local EROFC = this:GetText();
	local color = this.value;
	if( EROFC == DefaultColor ) then
		filter["Color"] = nil;
	else
		filter["Color"] = EROFC;
	end
	getglobal(prnt:GetName().."LabelText"):SetTextColor(color.r, color.g, color.b, 1.0);
end

function ErrorRedirectOptionsFilterColor_Initialize()
	local current_menu = UIDropDownMenu_GetCurrentDropDown();
	local eraf = MessageRedirect.Colors;

	for i, fr in pairs(eraf) do
		UIDropDownMenu_AddButton( {
			text = i,
			value = fr,
			func = ErrorRedirectOptionsFilterColor_OnClick,
			owner = current_menu,
		} );
	end
end

function ErrorRedirectOptionsFilterColor_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsFilterColor_Initialize);
	UIDropDownMenu_SetWidth(100, frame);
end

function ErrorRedirectOptionsFilterRedirect_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local EROFC = this.value;
	local prnt = this.owner:GetParent();
	local index = prnt.value;
	local font = EROFC[3];
	local filter = ER_Exceptions[index];
	if( not EROFC or EROFC[1] == 0 ) then
		filter["Frame"] = nil;
	else
		filter["Frame"] = EROFC[1];
	end
	local fc = getglobal(prnt:GetName().."Font");
	if( MessageRedirect.LSM and font ) then
		fc:Show();
		UIDropDownMenu_SetSelectedName(fc, filter.Font or DEFAULT);
		UIDropDownMenu_SetText(filter.Font or DEFAULT, fc);
	else
		fc:Hide();
	end
end

local function ErrorRedirectOptionsFilterRedirect_Initialize()
	local current_menu = UIDropDownMenu_GetCurrentDropDown();
	local eraf = MessageRedirect.AvailableFrames;

	for _, fr in ipairs(eraf) do
		UIDropDownMenu_AddButton( {
			text = fr[2],
			value = fr,
			func = ErrorRedirectOptionsFilterRedirect_OnClick,
            owner = current_menu,
		} );
	end
end

local function ErrorRedirectOptionsFilterRedirect_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsFilterRedirect_Initialize);
	UIDropDownMenu_SetWidth(100, frame);
end

function ErrorRedirectOptionsFilterFont_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local EROFC = this.value;
	local prnt = this.owner:GetParent();
	local index = prnt.value;
	local lookup = prnt.lookup;
	local filter = lookup[index];
	if( not EROFC or EROFC == DEFAULT ) then
		filter["Font"] = nil;
	else
		filter["Font"] = EROFC;
	end
end

local function ErrorRedirectOptionsFilterFont_Initialize(level)
	local current_menu = UIDropDownMenu_GetCurrentDropDown();
	local LSM = MessageRedirect.LSM;
	local eraf = LSM:List(LSM.MediaType.FONT);

	UIDropDownMenu_AddButton( {
		text = DEFAULT,
		value = DEFAULT,
		func = ErrorRedirectOptionsFilterFont_OnClick,
		owner = current_menu,
	} );
	for i, fr in ipairs(eraf) do
		UIDropDownMenu_AddButton( {
			text = fr,
			value = fr,
			func = ErrorRedirectOptionsFilterFont_OnClick,
            owner = current_menu,
		} );
	end
end

local function ErrorRedirectOptionsFilterFont_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsFilterFont_Initialize);
	UIDropDownMenu_SetWidth(100, frame);
end

function ErrorRedirectOptionsFilterSound_OnClick()
	UIDropDownMenu_SetSelectedID(this.owner, this:GetID());

	local EROFC = this.value;
	local prnt = this.owner:GetParent();
	local index = prnt.value;
	local lookup = prnt.lookup;
	local filter = lookup[index];
	if( not EROFC or EROFC == DEFAULT ) then
		filter["Sound"] = nil;
	else
		filter["Sound"] = EROFC;
	end
end

local function ErrorRedirectOptionsFilterSound_Initialize(level)
	local current_menu = UIDropDownMenu_GetCurrentDropDown();
	local LSM = MessageRedirect.LSM;
	local eraf = LSM:List(LSM.MediaType.SOUND);

	UIDropDownMenu_AddButton( {
		text = DEFAULT,
		value = DEFAULT,
		func = ErrorRedirectOptionsFilterSound_OnClick,
		owner = current_menu,
	} );
	for i, fr in ipairs(eraf) do
		UIDropDownMenu_AddButton( {
			text = fr,
			value = fr,
			func = ErrorRedirectOptionsFilterSound_OnClick,
            owner = current_menu,
		} );
	end
end

local function ErrorRedirectOptionsFilterSound_OnLoad(frame)
	UIDropDownMenu_Initialize(frame, ErrorRedirectOptionsFilterSound_Initialize);
	UIDropDownMenu_SetWidth(100, frame);
end

function ErrorRedirectOptionsPNEAdd_OnClick(frame)
	local prnt = frame:GetParent();
	local tFil = prnt.value;
	local tCol = prnt.color;
  
	if( not tFil or tFil == "" ) then
		local err = geterrorhandler();
		err("String not accepted, filter was not added");
		return;
	end
	MessageRedirect.TableRemove(tFil);
	ErrorRedirectOptionsPNEStart = 1;
	ErrorRedirectOptions_FillPNEContainers();
	if( tCol == DefaultColor ) then
		tCol = nil;
	end
	MessageRedirect.TableInsert( { ["String"] = tFil, ["Enabled"] = 1, ["Color"] = tCol } );
	ErrorRedirectOptions_FillFilterContainers();
end

function ErrorRedirectOptionsDelete_OnClick(frame)
	local indVal = frame:GetParent().value;
	local filter = ER_Exceptions[indVal];
	if( not filter ) then
		return;
	end
	StaticPopupDialogs["ERRORREDIRECT_DELETEFILTER"].filterIndex = indVal;
	StaticPopup_Show("ERRORREDIRECT_DELETEFILTER", filter["String"]);
end

function ErrorRedirectOptionsDelete_Delete()
	local indVal = StaticPopupDialogs["ERRORREDIRECT_DELETEFILTER"].filterIndex;
	MessageRedirect.TableRemove(indVal);
	ErrorRedirectOptions_FillFilterContainers();
end

function ErrorRedirectOptions_OnShow()
	if( myAddOnsFrame ) then
		HideUIPanel(myAddOnsFrame);
	end
	ErrorRedirectOptionsBasicRed.lookup = ErrorRedirect_Options;
	ErrorRedirectOptionsBasicYellow.lookup = ErrorRedirect_Options;
	if( not MessageRedirect.SetupComboFrames ) then
		if( not MessageRedirect.AvailableFrames ) then
			MessageRedirect.FindChatFrames();
		end
		ErrorRedirectOptionsCombo_OnLoad(ErrorRedirectOptionsBasicRedCombo);
		ErrorRedirectOptionsCombo_OnLoad(ErrorRedirectOptionsBasicYellowCombo);
		ErrorRedirectOptionsSuppressCombo_OnLoad(ErrorRedirectOptionsBasicSuppressCombo);
		ErrorRedirectOptionsFilterRedirect_OnLoad(ErrorRedirectOptionsMessageFilter1Redirect);
		ErrorRedirectOptionsFilterRedirect_OnLoad(ErrorRedirectOptionsMessageFilter2Redirect);
		ErrorRedirectOptionsFilterRedirect_OnLoad(ErrorRedirectOptionsMessageFilter3Redirect);
		ErrorRedirectOptionsFilterRedirect_OnLoad(ErrorRedirectOptionsMessageFilter4Redirect);
		--ErrorRedirectOptionsFilterRedirect_OnLoad(ErrorRedirectOptionsMessageFilter5Redirect);
		MessageRedirect.SetupComboFrames = true;
	end
	local LSM = MessageRedirect.LSM;
	local tmp = MessageRedirect.DecideBestLSM();
	if( LSM ~= tmp ) then
		LSM = tmp;
		LSM_Fonts = 0;
		LSM_Sounds = 0;
	end
	if( LSM ) then
		ErrorRedirectOptions:SetHeight(660);
		ErrorRedirectOptionsBasic:SetHeight(160);
		local num = #LSM:List(LSM.MediaType.FONT);
		if( LSM_Fonts < num ) then
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsBasicRedFont);
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsBasicYellowFont);
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsMessageFilter1Font);
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsMessageFilter2Font);
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsMessageFilter3Font);
			ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsMessageFilter4Font);
			--ErrorRedirectOptionsFilterFont_OnLoad(ErrorRedirectOptionsMessageFilter5Font);
			LSM_Fonts = num;
		end
		num = #LSM:List(LSM.MediaType.SOUND);
		if( LSM_Sounds < num ) then
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsBasicRedSound);
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsBasicYellowSound);
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsMessageFilter1Sound);
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsMessageFilter2Sound);
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsMessageFilter3Sound);
			ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsMessageFilter4Sound);
			--ErrorRedirectOptionsFilterSound_OnLoad(ErrorRedirectOptionsMessageFilter5Sound);
			LSM_Sounds = num;
		end
	end

	local currentConfig = 1;
	local ero = ErrorRedirect_Options;
	local EROIE = ero.Red.Enabled;
	local ERORF = ero.Red.Frame;
	local supportsFonts = false;
	if( LSM ) then
		ErrorRedirectOptionsBasicRedSound:Show();
		UIDropDownMenu_SetSelectedName(ErrorRedirectOptionsBasicRedSound, ero.Red.Sound or DEFAULT);
		UIDropDownMenu_SetText(ero.Red.Sound or DEFAULT, ErrorRedirectOptionsBasicRedSound);
	else
		ErrorRedirectOptionsBasicRedSound:Hide();
	end
	if( EROIE ) then
		ERORF, currentConfig, supportsFonts = ErrorRedirect_GetChatNumber(ERORF);
		if( LSM and supportsFonts ) then
			ErrorRedirectOptionsBasicRedFont:Show();
			UIDropDownMenu_SetSelectedName(ErrorRedirectOptionsBasicRedFont, ero.Red.Font or DEFAULT);
			UIDropDownMenu_SetText(ero.Red.Font or DEFAULT, ErrorRedirectOptionsBasicRedFont);
		else
			ErrorRedirectOptionsBasicRedFont:Hide();
		end
	end
	UIDropDownMenu_SetSelectedID(ErrorRedirectOptionsBasicRedCombo, currentConfig);
	UIDropDownMenu_SetText(MessageRedirectLocalization.ComboText[currentConfig], ErrorRedirectOptionsBasicRedCombo);

	currentConfig = 1;
	EROIE = ero.Yellow.Enabled;
	ERORF = ero.Yellow.Frame;
	supportsFonts = false;
	if( LSM ) then
		ErrorRedirectOptionsBasicYellowSound:Show();
		UIDropDownMenu_SetSelectedName(ErrorRedirectOptionsBasicYellowSound, ero.Yellow.Sound or DEFAULT);
		UIDropDownMenu_SetText(ero.Yellow.Sound or DEFAULT, ErrorRedirectOptionsBasicYellowSound);
	else
		ErrorRedirectOptionsBasicYellowSound:Hide();
	end
	if( EROIE ) then
		ERORF, currentConfig, supportsFonts = ErrorRedirect_GetChatNumber(ERORF);
		if( LSM and supportsFonts ) then
			ErrorRedirectOptionsBasicYellowFont:Show();
			UIDropDownMenu_SetSelectedName(ErrorRedirectOptionsBasicYellowFont, ero.Yellow.Font or DEFAULT);
			UIDropDownMenu_SetText(ero.Yellow.Font or DEFAULT, ErrorRedirectOptionsBasicYellowFont);
		else
			ErrorRedirectOptionsBasicYellowFont:Hide();
		end
	end
	UIDropDownMenu_SetSelectedID(ErrorRedirectOptionsBasicYellowCombo, currentConfig);
	UIDropDownMenu_SetText(MessageRedirectLocalization.ComboText[currentConfig], ErrorRedirectOptionsBasicYellowCombo);

	ErrorRedirectOptionsBasicSuppressActive:SetChecked(ero.LuaErrors.Enabled);

	currentConfig = ero.LuaErrors.Frame;
	supportsFonts = false;
	EROIE, currentConfig, supportsFonts = ErrorRedirect_GetChatNumber(currentConfig);
	UIDropDownMenu_SetSelectedName(ErrorRedirectOptionsBasicSuppressCombo, EROIE);
	UIDropDownMenu_SetText(EROIE, ErrorRedirectOptionsBasicSuppressCombo);

	ErrorRedirectOptionsBasicOverflowActive:SetChecked(ero.Overflow.Enabled);
	ErrorRedirectOptionsBasicOverflowNumber:SetText(ero.Overflow.Time or 0);

	ErrorRedirectOptions_FillPNEContainers();
	ErrorRedirectOptions_FillFilterContainers();
end

function ErrorRedirectOptions_OnLoad(frame)
	table.insert(UISpecialFrames, frame:GetName());

	ErrorRedirectOptionsTitle:SetText(MessageRedirectLocalization.Name);
end

function ErrorRedirectOptionsOkay_OnClick()
	HideUIPanel(ErrorRedirectOptions);
end

function ErrorRedirectOptions_OnHide()
end

function ErrorRedirectOptions_CheckVisible()
	if( ErrorRedirectOptionsNew:IsVisible() ) then
		ErrorRedirectOptions_FillPNEContainers();
	end
end
